// services/api/userAccount.ts

export interface LoginResponseSuccess {
  data: {
    is_advisor: boolean;
    username: string;
    email: string;
    inbox: {
      question: string;
      answer: string;
      student: string;
      advisor: string;
    }[];
  };
}

export interface LoginResponseError {
  error: string;
}

export type LoginResponse = LoginResponseSuccess | LoginResponseError;

export async function loginUser(
  username: string,
  password: string
): Promise<LoginResponse> {
  try {
    const res = await fetch(
      `${process.env.NEXT_PUBLIC_API_URL}/login`, // https://myadvisor.cs.uct.ac.za/backend/login
      {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({ username, password }),
      }
    );

    const data = await res.json();

    // Wrap in expected types
    if (!res.ok || "error" in data) {
      return { error: data.error || "Login failed" };
    }

    return data as LoginResponseSuccess;
  } catch (err) {
    return { error: err instanceof Error ? err.message : "Network error" };
  }
}
