export interface FAQ {
  question: string;
  answer: string;
}

export interface FAQResponse {
  [category: string]: FAQ[];
}
export interface Advisor {
  username: string;
  first_name: string;
  last_name: string | null;
  title: string | null;
  email: string | null;
  phone_number: string | null;
  office_number: string | null;
  building: string | null;
  notes: string;
  faculties: Array<{ faculty_name: string }>;
  departments: Array<{ department_name: string }>;
  programs: any[];
  degrees: any[];
  majors: any[];
}

export interface GlossaryTerm {
  term: string;
  definition: string;
}

export async function getFaqs(): Promise<FAQResponse> {
  const res = await fetch(`https://myadvisor.cs.uct.ac.za/backend/faqs/`, {
    method: "GET",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch FAQs: ${res.statusText}`);
  }

  return res.json();
}



export async function getGlossary(): Promise<GlossaryTerm[]> {
  const res = await fetch(`https://myadvisor.cs.uct.ac.za/backend/glossary/`, {
    method: "GET",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch glossary: ${res.statusText}`);
  }

  return res.json();
}

export async function getAdvisors(): Promise<Advisor[]> {
  const res = await fetch(`https://myadvisor.cs.uct.ac.za/backend/advisors/`, {
    method: "GET",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch advisors: ${res.statusText}`);
  }

  return res.json();
}