

export interface Course {
  course_code: string;
  course_name: string;
  nqf_credits: number;
  nqf_level: number;
  semester: string;
  convener: string;
  notes?: string;
  outline?: string; // Future field
  entryRequirements?: string; // Future field
  dpRequirements?: string; // Future field
  assessment?: string; // Future field
}

export interface DepartmentWithCourses {
  department: Department;
  courses: Course[];
}

export interface Department {
  department_code: string;
  department_name: string;
  hod?: string; // Future field for department head
}

export async function getDepartments(): Promise<Department[]> {
  const res = await fetch(`https://myadvisor.cs.uct.ac.za/backend/departments/`, {
    method: "GET",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch departments: ${res.statusText}`);
  }

  return res.json();
}

// Function to get just courses for a department
export async function getCoursesByDepartment(department_code: string): Promise<Course[]> {
  const res = await fetch(`https://myadvisor.cs.uct.ac.za/backend/departments/${department_code}/courses`, {
    method: "GET",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch department courses: ${res.statusText}`);
  }

  return res.json();
}

// Function to get department with courses (if you need it elsewhere)
export async function getDeptByCourses(department_code: string): Promise<DepartmentWithCourses> {
  // Get all departments to find the specific one
  const departments = await getDepartments();
  const department = departments.find(dept => dept.department_code === department_code);
  
  if (!department) {
    throw new Error(`Department ${department_code} not found`);
  }

  // Get courses for this department
  const courses = await getCoursesByDepartment(department_code);

  return {
    department,
    courses
  };
}