import React from "react";

interface LoadingSpinnerProps {
  message?: string;
}

export function LoadingSpinner({
  message = "Loading...",
}: LoadingSpinnerProps) {
  return (
    <div className="w-full max-w-6xl mt-8 mb-8 z-10 text-center">
      <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-uct-blue mx-auto"></div>
      <p className="mt-2 text-gray-600">{message}</p>
    </div>
  );
}
