import type { Course as APICourse } from "@/services/api/faculties";

// Local course interface for roadmap functionality
export interface Course {
  code: string;
  credits: number;
  passRequirement: string;
  status: number; // 0 = null, 1 = passed, 2 = failed, 3 = problem
  postrequisites: string[];
}

// Interface for course selection groups
export interface CourseGroup {
  required_count: number;
  courses?: APICourse[];
  groups?: CourseGroup[]; // Support nested groups
  groupIndex: number;
  isSelected?: boolean;
  name?: string; // Optional group name
}

// Interface for course selection sections
export interface CourseSection {
  required_count: number;
  courses?: APICourse[];
  groups?: CourseGroup[];
}

export interface Faculty {
  faculty_code: string;
  faculty_name: string;
}

export interface CourseCardProps {
  courses: Course[];
  allCourses?: Course[];
  onStatusChange?: (courseCode: string, status: number) => void;
}

export interface CourseSelectionTableProps {
  courseSections: CourseSection[];
  selectedCourses: Course[];
  selectedGroups: Set<string>; // Changed to string to handle nested group keys
  onCourseToggle: (
    courseCode: string,
    sectionIndex: number,
    groupIndex?: number,
    subGroupIndex?: number
  ) => void;
  onGroupToggle: (sectionIndex: number, groupIndex: number, subGroupIndex?: number) => void;
}

// Function to get row styling based on status
export const getRowStyling = (status: number) => {
  switch (status) {
    case 1: // passed
      return "bg-green-100";
    case 2: // failed
      return "bg-red-100 border-l-4 border-l-red-500";
    case 3: // problem
      return "bg-orange-100 border-l-4 border-l-orange-500";
    default: // null
      return "";
  }
};

// Convert API course to local course format
export const convertApiCourseToLocal = (apiCourse: APICourse): Course => {
  return {
    code: apiCourse.code,
    credits: apiCourse.credits,
    passRequirement: "50%", // Default, could be extracted from dp_requirements
    status: 0,
    postrequisites: [], // Would need to be calculated based on prerequisites
  };
};