import React from "react";
import { Card, CardHeader, CardTitle } from "@/components/ui/card";

interface YearOption {
  year: number;
  title: string;
}

interface YearSelectionProps {
  yearOptions: YearOption[];
  onSelect: (year: YearOption) => void;
}

export function YearSelection({ yearOptions, onSelect }: YearSelectionProps) {
  return (
    <div className="flex justify-center gap-8 flex-wrap px-10 md:px-0">
      {yearOptions.map((year, idx) => (
        <Card
          key={idx}
          onClick={() => onSelect(year)}
          className="flex flex-col items-center border-2 border-[#222222]/50 px-20 h-24 transition-transform duration-200 hover:scale-105 cursor-pointer"
        >
          <CardHeader className="flex items-center justify-center w-full h-full">
            <CardTitle className="text-medium text-center whitespace-nowrap outfit-500">
              {year.title}
            </CardTitle>
          </CardHeader>
        </Card>
      ))}
    </div>
  );
}
