import React from "react";
import { Card, CardHeader, CardTitle } from "@/components/ui/card";
import type { Program } from "@/services/api/faculties";

interface ProgramSelectionProps {
  programs: Program[];
  onSelect: (program: Program) => void;
}

export function ProgramSelection({
  programs,
  onSelect,
}: ProgramSelectionProps) {
  return (
    <div className="grid gap-8 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 px-10 md:px-0">
      {programs.map((program, idx) => (
        <Card
          key={idx}
          onClick={() => onSelect(program)}
          className="flex flex-col items-center border-2 border-[#222222]/50 p-4 h-24 md:h-48 transition-transform duration-200 hover:scale-105 cursor-pointer"
        >
          <CardHeader className="flex items-center justify-center w-full h-full">
            <CardTitle className="text-medium text-center">
              {program.program_name}
            </CardTitle>
          </CardHeader>
        </Card>
      ))}
    </div>
  );
}
