import React from "react";
import { Card, CardHeader, CardTitle } from "@/components/ui/card";
import type { Faculty } from "../types";

interface FacultySelectionProps {
  faculties: Faculty[];
  onSelect: (faculty: Faculty) => void;
}

export function FacultySelection({
  faculties,
  onSelect,
}: FacultySelectionProps) {
  return (
    <div className="grid gap-8 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 px-10 md:px-0">
      {faculties.map((faculty, idx) => (
        <Card
          key={idx}
          onClick={() => onSelect(faculty)}
          className="flex flex-col border-2 border-[#222222]/50 items-center p-4 h-24 md:h-48 transition-transform duration-200 hover:scale-105 cursor-pointer"
        >
          <CardHeader className="flex items-center justify-center w-full h-full">
            <CardTitle className="text-medium text-center">
              {faculty.faculty_name}
            </CardTitle>
          </CardHeader>
        </Card>
      ))}
    </div>
  );
}
