import React from "react";
import { CourseSelectionTable } from "./CourseSelectionTable";
import type { CourseSection, Course } from "../types";

interface CoursePickerProps {
  courseSections: CourseSection[];
  selectedCourses: Course[];
  selectedGroups: Set<string>; // Changed from Set<number> to Set<string>
  onCourseToggle: (
    courseCode: string,
    sectionIndex: number,
    groupIndex?: number
  ) => void;
  onGroupToggle: (sectionIndex: number, groupIndex: number) => void;
  onContinue: () => void;
}

export function CoursePicker({
  courseSections,
  selectedCourses,
  selectedGroups,
  onCourseToggle,
  onGroupToggle,
  onContinue,
}: CoursePickerProps) {
  return (
    <div className="max-w-6xl mx-auto">
      <CourseSelectionTable
        courseSections={courseSections}
        selectedCourses={selectedCourses}
        selectedGroups={selectedGroups}
        onCourseToggle={onCourseToggle}
        onGroupToggle={onGroupToggle}
      />
      <div className="flex justify-center mt-8 outfit-400">
        <button
          onClick={onContinue}
          disabled={selectedCourses.length === 0}
          className="outfit-400 text-lg border-2 border-[#222222]/10 py-2 px-12 rounded-3xl bg-uct-green drop-shadow-lg text-white disabled:bg-gray-400 disabled:cursor-not-allowed"
        >
          Continue to Roadmap
        </button>
      </div>
    </div>
  );
}
