import React from "react";
import { Card } from "@/components/ui/card";
import type { CourseCardProps } from "../types";
import { getRowStyling } from "../types";

export function CourseCard({
  courses,
  allCourses = [],
  onStatusChange,
}: CourseCardProps) {
  const updateCourseStatus = (courseCode: string, status: number) => {
    if (onStatusChange) {
      onStatusChange(courseCode, status);
    }
  };

  return (
    <Card className="w-full border-2 border-[#222222]/40 rounded-xl overflow-hidden drop-shadow-sm flex flex-col h-fit py-0 gap-0 outfit-300">
      <div className="border-b border-[#e2e2e2]">
        <table className="w-full mb-0 block leading-none">
          <thead>
            <tr className="text-[#474747] bg-black/3">
              <th className="py-4 px-4 outfit-500 text-left whitespace-nowrap">
                Course Code
              </th>
              <th className="py-4 px-4 outfit-500 text-center">Credits</th>
              <th className="py-4 px-4 outfit-500 text-center whitespace-nowrap">
                Pass requirement
              </th>
              <th className="py-4 px-4 outfit-500 text-center whitespace-nowrap">
                Options
              </th>
            </tr>
          </thead>
          <tbody>
            {courses.map((course, index) => (
              <tr
                key={index}
                className={`border-t border-[#e2e2e2] ${getRowStyling(
                  course.status
                )}`}
                id={`course-${course.code}`}
              >
                <td className="py-3 px-4">{course.code}</td>
                <td className="py-3 px-4 text-center">{course.credits}</td>
                <td className="py-3 px-4 text-center whitespace-nowrap">
                  {course.passRequirement}
                </td>
                <td className="text-right w-full h-full">
                  <div className="flex justify-end w-full px-0 py-0">
                    <button
                      onClick={() => updateCourseStatus(course.code, 1)}
                      disabled={course.status === 3}
                      className={`
                        ${
                          course.status === 1 ? "bg-green-500" : "bg-[#1EA558]"
                        } 
                        ${
                          course.status === 3
                            ? "bg-gray-400 cursor-not-allowed"
                            : "hover:bg-green-600"
                        }
                        text-white px-3 py-1 w-full h-13 
                      `}
                    >
                      Pass
                    </button>
                    <button
                      onClick={() => updateCourseStatus(course.code, 2)}
                      disabled={course.status === 3}
                      className={`
                        ${course.status === 2 ? "bg-red-500" : "bg-[#EF0B0B]"} 
                        ${
                          course.status === 3
                            ? "bg-gray-400 cursor-not-allowed"
                            : "hover:bg-red-600"
                        }
                        text-white px-3 py-1 w-full h-13 
                      `}
                    >
                      Fail
                    </button>
                  </div>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </Card>
  );
}
