"use client";

import { useState } from "react";
import {
  Accordion,
  AccordionItem,
  AccordionTrigger,
  AccordionContent,
} from "@/components/ui/accordion";

// Define proper types for the transformed data
interface TransformedFAQ {
  q: string;
  a: string;
}

interface TransformedFAQSection {
  title: string;
  questions: TransformedFAQ[];
}

interface FAQClientProps {
  faqSections: TransformedFAQSection[];
}

export function FAQClient({ faqSections }: FAQClientProps) {
  const [selectedSection, setSelectedSection] = useState(0);

  return (
    <div className="w-full flex flex-col sm:flex-row justify-center mt-10 mb-16 px-8 md:px-0 z-10 gap-6 sm:gap-0">
      {/* Table of Contents */}
      <div className="w-full sm:flex-1 sm:max-w-60 sm:pt-4">
        <div className="mb-2 sm:mb-4 text-xl font-semibold outfit-500 text-gray-800">
          Table of contents
        </div>
        <div className="grid grid-cols-2 gap-2 sm:block sm:gap-0">
          <ul className="contents sm:block sm:space-y-2">
            {faqSections.map((section, idx) => (
              <li key={section.title} className="flex-shrink-0 sm:flex-shrink">
                <button
                  className={`whitespace-nowrap sm:w-full text-left outfit-400 py-2 px-3 sm:px-0 rounded transition-all duration-200 font-semibold origin-left ${
                    selectedSection === idx
                      ? "text-uct-blue scale-110 sm:bg-transparent border-b-2 md:border-b-0 border-uct-blue rounded-none"
                      : "text-gray-800"
                  } hover:scale-105`}
                  onClick={() => setSelectedSection(idx)}
                >
                  {section.title}
                </button>
              </li>
            ))}
          </ul>
        </div>
      </div>
      {/* FAQ Accordions */}
      <div className="w-full sm:flex-1 sm:max-w-3xl">
        {faqSections.length > 0 && (
          <Accordion type="single" collapsible>
            {faqSections[selectedSection].questions.map(
              (item: TransformedFAQ, i: number) => (
                <AccordionItem
                  key={i}
                  value={`item-${i}`}
                  className="mb-2 border-b"
                >
                  <AccordionTrigger className="text-base sm:text-lg font-medium outfit-400 text-left">
                    {item.q}
                  </AccordionTrigger>
                  <AccordionContent className="text-gray-700 outfit-300 text-sm sm:text-base">
                    {item.a}
                  </AccordionContent>
                </AccordionItem>
              )
            )}
          </Accordion>
        )}
      </div>
      {/* Blank space - hidden on mobile */}
      <div className="hidden sm:block flex-1 max-w-60" />
    </div>
  );
}
