// types.ts - Shared types for Ask Advisor components

export interface Faculty {
  faculty_code: string;
  faculty_name: string;
}

export interface Program {
  program_code: string;
  program_name: string;
}

export interface Degree {
  degree_code: string;
  degree_name: string;
}

export interface Major {
  major_code: string;
  major_name: string;
}

export interface Department {
  department_code: string;
  department_name: string;
}

export interface QuestionFormData {
  subject: string;
  question: string;
}

export interface BaseQuestionData extends QuestionFormData {
  category: string;
  student: string;
  faculty?: string;
  department?: string;
  program?: string;
  degree?: string;
  major?: string;
}