// components/ask-advisor/forms/FacultyQuestionForm.tsx

import { Label } from "@/components/ui/label";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { QuestionFormFields } from "../QuestionFormFields";
import type { Faculty, QuestionFormData } from "../types";

interface FacultyQuestionFormProps {
  faculties: Faculty[];
  selectedFaculty: string;
  onFacultyChange: (value: string) => void;
  formData: QuestionFormData;
  onFormDataChange: (data: QuestionFormData) => void;
  onSubmit: () => void;
  isSubmitting: boolean;
}

export function FacultyQuestionForm({
  faculties,
  selectedFaculty,
  onFacultyChange,
  formData,
  onFormDataChange,
  onSubmit,
  isSubmitting,
}: FacultyQuestionFormProps) {
  const isValid =
    selectedFaculty && formData.subject.trim() && formData.question.trim();

  return (
    <div className="space-y-4">
      <h3 className="text-lg font-semibold text-gray-800">Faculty Question</h3>

      <div className="space-y-2">
        <Label htmlFor="faculty-select">Select Faculty</Label>
        <Select value={selectedFaculty} onValueChange={onFacultyChange}>
          <SelectTrigger id="faculty-select" className="h-11">
            <SelectValue placeholder="Choose a faculty" />
          </SelectTrigger>
          <SelectContent>
            {faculties.map((faculty) => (
              <SelectItem
                key={faculty.faculty_code}
                value={faculty.faculty_code}
              >
                {faculty.faculty_name}
              </SelectItem>
            ))}
          </SelectContent>
        </Select>
      </div>

      <QuestionFormFields
        subject={formData.subject}
        question={formData.question}
        onSubjectChange={(value) =>
          onFormDataChange({ ...formData, subject: value })
        }
        onQuestionChange={(value) =>
          onFormDataChange({ ...formData, question: value })
        }
        onSubmit={onSubmit}
        isSubmitting={isSubmitting}
        isValid={!!isValid}
        submitButtonText="Submit Faculty Question"
        questionPlaceholder="Ask your question about this faculty..."
      />
    </div>
  );
}
