// components/ask-advisor/forms/DepartmentQuestionForm.tsx

import { Label } from "@/components/ui/label";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { QuestionFormFields } from "../QuestionFormFields";
import type { Department, QuestionFormData } from "../types";

interface DepartmentQuestionFormProps {
  departments: Department[];
  selectedDepartment: string;
  onDepartmentChange: (value: string) => void;
  formData: QuestionFormData;
  onFormDataChange: (data: QuestionFormData) => void;
  onSubmit: () => void;
  isSubmitting: boolean;
}

export function DepartmentQuestionForm({
  departments,
  selectedDepartment,
  onDepartmentChange,
  formData,
  onFormDataChange,
  onSubmit,
  isSubmitting,
}: DepartmentQuestionFormProps) {
  const isValid =
    selectedDepartment && formData.subject.trim() && formData.question.trim();

  return (
    <div className="space-y-4">
      <h3 className="text-lg font-semibold text-gray-800">
        Department Question
      </h3>

      <div className="space-y-2">
        <Label htmlFor="department-select">Select Department</Label>
        <Select value={selectedDepartment} onValueChange={onDepartmentChange}>
          <SelectTrigger id="department-select" className="h-11">
            <SelectValue placeholder="Choose a department" />
          </SelectTrigger>
          <SelectContent>
            {departments.map((dept) => (
              <SelectItem
                key={dept.department_code}
                value={dept.department_code}
              >
                {dept.department_name}
              </SelectItem>
            ))}
          </SelectContent>
        </Select>
      </div>

      <QuestionFormFields
        subject={formData.subject}
        question={formData.question}
        onSubjectChange={(value) =>
          onFormDataChange({ ...formData, subject: value })
        }
        onQuestionChange={(value) =>
          onFormDataChange({ ...formData, question: value })
        }
        onSubmit={onSubmit}
        isSubmitting={isSubmitting}
        isValid={!!isValid}
        submitButtonText="Submit Department Question"
        questionPlaceholder="Ask your question about this department..."
      />
    </div>
  );
}
