// components/ask-advisor/QuestionFormFields.tsx

import { Label } from "@/components/ui/label";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";

interface QuestionFormFieldsProps {
  subject: string;
  question: string;
  onSubjectChange: (value: string) => void;
  onQuestionChange: (value: string) => void;
  onSubmit: () => void;
  isSubmitting: boolean;
  isValid: boolean;
  submitButtonText: string;
  questionPlaceholder: string;
}

export function QuestionFormFields({
  subject,
  question,
  onSubjectChange,
  onQuestionChange,
  onSubmit,
  isSubmitting,
  isValid,
  submitButtonText,
  questionPlaceholder,
}: QuestionFormFieldsProps) {
  return (
    <>
      <div className="space-y-2">
        <Label htmlFor="subject">Subject</Label>
        <Input
          id="subject"
          value={subject}
          onChange={(e) => onSubjectChange(e.target.value)}
          placeholder="Enter the subject of your question..."
          className="h-11 text-sm"
        />
      </div>
      <div className="space-y-2">
        <Label htmlFor="question">Your Question</Label>
        <Textarea
          id="question"
          value={question}
          onChange={(e) => onQuestionChange(e.target.value)}
          placeholder={questionPlaceholder}
          className="min-h-[100px] text-sm"
        />
      </div>
      <Button
        onClick={onSubmit}
        className="w-full"
        disabled={!isValid || isSubmitting}
      >
        {isSubmitting ? "Submitting..." : submitButtonText}
      </Button>
    </>
  );
}
