"use client";

import { motion } from "framer-motion";

type SplitTextProps = {
  text: string;
  delay?: number;
  className?: string;
  speed?: number; // lower = faster
};

const SplitText = ({
  text,
  delay = 0,
  className = "",
  speed = 0.05, // default speed
}: SplitTextProps) => {
  const words = text.split(" ");

  return (
    <motion.div
      className={`inline-block ${className}`}
      initial="hidden"
      animate="visible"
      variants={{
        visible: {
          transition: {
            staggerChildren: speed,
            delayChildren: delay,
          },
        },
      }}
    >
      {words.map((word, wordIndex) => (
        <span
          key={wordIndex}
          className="inline-block whitespace-nowrap mr-[0.25em]"
        >
          {word.split("").map((char, charIndex) => (
            <motion.span
              key={`${wordIndex}-${charIndex}`}
              className="inline-block align-bottom"
              style={{ paddingBottom: "0.1em" }}
              variants={{
                hidden: { opacity: 0, y: "0.25em" },
                visible: {
                  opacity: 1,
                  y: "0em",
                  transition: {
                    ease: "easeOut",
                    duration: speed * 4, // scale duration with speed
                  },
                },
              }}
            >
              {char}
            </motion.span>
          ))}
        </span>
      ))}
    </motion.div>
  );
};

export default SplitText;
