"use client";

import React from "react";
import Link from "next/link";
import Image from "next/image";
export function Footer() {
  return (
    <div className="w-full h-fit bg-uct-footer items-center justify-center z-10 ">
      <div className="w-full h-full md:h-72 flex flex-col md:flex-row items-center justify-center border-b-1 border-[#5C5C5C] gap-x-40  mt-8 md:mt-20 pb-20">
        <div className="hidden md:flex w-fit h-full items-center justify-center">
          <Image
            src="/images/uct_logo.png"
            width={230}
            height={230}
            alt="UCT Logo"
          />
        </div>
        <div className="flex md:hidden pl-16 w-full h-full items-center justify-start gap-x-5 pb-8">
          <Image
            src="/images/uct_logo.png"
            width={70}
            height={70}
            alt="UCT Logo"
          />
          <h1 className="text-2xl text-[#C3C3C3] font-medium">MyAdvisor</h1>
        </div>
        <div className="flex flex-col md:flex-row w-fit h-full md:items-center justify-center gap-x-28 gap-y-12 md:gap-y-0">
          <div className="flex gap-x-20 md:gap-x-28 ">
            <div className="w-fit h-full flex flex-col items-center justify-center ">
              <div className="w-fit h-full flex flex-col justify-center gap-y-5 md:gap-y-8">
                <h1 className="text-[#C3C3C3] md:text-2xl font-medium whitespace-nowrap">
                  Products
                </h1>
                <Link
                  href="/helpbot"
                  className="text-white text-sm md:text-base font-medium"
                >
                  HelpBot
                </Link>
                <Link
                  href="/degree_planning/roadmap"
                  className="text-white text-sm md:text-base font-medium"
                >
                  Roadmap
                </Link>
                <Link
                  href="/academic_info/fac"
                  className="text-white text-sm md:text-base font-medium whitespace-nowrap"
                >
                  Handbook Explorer
                </Link>
              </div>
            </div>
            <div className="w-fit h-full flex flex-col items-center justify-center ">
              <div className="w-fit h-full flex flex-col justify-center gap-y-5 md:gap-y-8">
                <h1 className="text-[#C3C3C3] md:text-2xl font-medium whitespace-nowrap">
                  Terms & Conditions
                </h1>
                <p className="text-white text-sm md:text-base font-medium whitespace-nowrap">
                  Terms of Use
                </p>
                <p className="text-white text-sm md:text-base font-medium whitespace-nowrap">
                  Privacy Policy
                </p>
                <p className="text-white text-sm md:text-base font-medium whitespace-nowrap">
                  UCT links
                </p>
              </div>
            </div>
          </div>
          <div className="w-fit h-full flex flex-col items-center justify-center ">
            <div className="w-fit h-full flex flex-col justify-center gap-y-5 md:gap-y-8">
              <h1 className="text-[#C3C3C3] md:text-2xl font-medium whitespace-nowrap">
                About Us
              </h1>
              <p className="text-white text-sm md:text-base font-medium whitespace-nowrap">
                Contact Us
              </p>
              <p className="text-white text-sm md:text-base font-medium">FAQ</p>
              <p className="text-white text-sm md:text-base font-medium">
                Glossary
              </p>
            </div>
          </div>
        </div>
      </div>
      <div className="w-full h-20 flex"></div>
    </div>
  );
}
