import type React from "react";
import { Navbar } from "@/components/Navbar";
import { Footer } from "@/components/Footer";
import { getGlossary } from "@/services/api/student_help";
import { GlossaryClient } from "@/components/glossary-client";

const Icons = {
  logo: (props: React.SVGProps<SVGSVGElement>) => (
    <svg {...props} viewBox="0 0 24 24" fill="none">
      <circle cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="2" />
      <path d="M8 12h8" stroke="currentColor" strokeWidth="2" />
      <path d="M12 8v8" stroke="currentColor" strokeWidth="2" />
    </svg>
  ),
};

// Define proper types for glossary terms
interface GlossaryTerm {
  term: string;
  definition: string;
}

// Updated type definition for Next.js 15
type PageProps = {
  params?: Promise<any>;
};

export default async function Page({ params }: PageProps) {
  // Fetch glossary data server-side
  const glossaryTerms: GlossaryTerm[] = await getGlossary();

  return (
    <div className="relative flex flex-col items-center min-h-screen pt-5 bg-gradient-to-br from-rose-50 via-sky-50 to-violet-50">
      <div className="absolute inset-0 z-0">
        {/* Soft Gradient Overlay */}
        <div className="absolute inset-0 bg-gradient-to-br from-rose-100/40 via-sky-100/30 to-violet-100/40" />
      </div>
      {/* Nav Bar */}
      <Navbar />
      {/* Big heading */}
      <div className="w-full flex flex-col items-center justify-center text-center mt-16 md:mt-10 outfit-400 z-10">
        <div className="text-5xl md:text-8xl mb-1 mt-5">
          <span className="text-uct-blue">Glossary</span>
        </div>
      </div>

      {/* Glossary Section - Client Component */}
      <GlossaryClient glossaryTerms={glossaryTerms} />

      {/* Contact Us Section */}
      <Footer />
    </div>
  );
}
