import type React from "react";
import { Navbar } from "@/components/Navbar";
import { Footer } from "@/components/Footer";
import { getFaqs, type FAQResponse } from "@/services/api/student_help";
import { FAQClient } from "@/components/faq-client";

const Icons = {
  logo: (props: React.SVGProps<SVGSVGElement>) => (
    <svg {...props} viewBox="0 0 24 24" fill="none">
      <circle cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="2" />
      <path d="M8 12h8" stroke="currentColor" strokeWidth="2" />
      <path d="M12 8v8" stroke="currentColor" strokeWidth="2" />
    </svg>
  ),
};

// Define proper types for the transformed data
interface TransformedFAQ {
  q: string;
  a: string;
}

interface TransformedFAQSection {
  title: string;
  questions: TransformedFAQ[];
}

// Updated type definition for Next.js 15
type PageProps = {
  params?: Promise<any>;
};

export default async function Page({ params }: PageProps) {
  // Fetch FAQ data server-side
  const faqData: FAQResponse = await getFaqs();

  // Transform FAQ data into sections array
  const faqSections: TransformedFAQSection[] = Object.entries(faqData).map(
    ([title, questions]) => ({
      title,
      questions: questions.map((faq) => ({
        q: faq.question,
        a: faq.answer,
      })),
    })
  );

  return (
    <div className="relative flex flex-col items-center min-h-screen pt-5 bg-gradient-to-br from-rose-50 via-sky-50 to-violet-50">
      <div className="absolute inset-0 z-0">
        {/* Soft Gradient Overlay */}
        <div className="absolute inset-0 bg-gradient-to-br from-rose-100/40 via-sky-100/30 to-violet-100/40" />
      </div>
      {/* Nav Bar */}
      <Navbar />
      {/* Big heading */}
      <div className="w-full flex flex-col items-center justify-center text-center mt-18 md:mt-8 px-4 sm:px-8 md:px-0 z-10">
        <div className="text-5xl md:text-8xl outfit-400 mb-1 mt-0">
          Frequently asked
        </div>
        <div className="text-5xl md:text-8xl outfit-400 mb-1 text-uct-blue">
          questions
        </div>

        <div className="max-w-2xl text-sm md:text-base text-gray-700 mt-3 sm:mt-5 outfit-300 px-2">
          Find everything you need to know about courses, credits, degree
          planning, using the platform, and more—all in one place.
        </div>
      </div>

      {/* FAQ Section - Client Component */}
      <FAQClient faqSections={faqSections} />

      {/* Contact Us Section */}
      <Footer />
    </div>
  );
}
