import React from "react";
import { Navbar } from "@/components/Navbar";
import { Footer } from "@/components/Footer";
import { getAdvisors, type Advisor } from "@/services/api/student_help";
import { AdvisorsClient } from "@/components/ui/advisor-client";

// Updated type definition for Next.js 15
type PageProps = {
  params?: Promise<any>;
};

export default async function Page({ params }: PageProps) {
  // Fetch advisors data server-side
  const advisors: Advisor[] = await getAdvisors();

  return (
    <div className="relative flex flex-col items-center min-h-screen pt-5 bg-gradient-to-br from-rose-50 via-sky-50 to-violet-50">
      {/* Nav Bar */}
      <div className="absolute inset-0 z-0">
        {/* Soft Gradient Overlay */}
        <div className="absolute inset-0 bg-gradient-to-br from-rose-100/40 via-sky-100/30 to-violet-100/40" />
      </div>

      <Navbar />
      {/*Big heading*/}
      <div className="w-full flex flex-col items-center justify-center text-center mt-16 z-10">
        <div className="text-5xl md:text-8xl outfit-400 mb-1 mt-3 px-6">
          Find Your <span className="text-uct-blue">Advisor</span>
        </div>
        <div className="max-w-2xl text-sm md:text-base text-gray-700 outfit-300 mt-5 px-8 md:px-0">
          Explore everything you need to know about UCT courses in one place.
          Search by name, filter by faculty, and find key details like
          prerequisites, credits, and course summaries—all made simple and easy
          to understand.
        </div>
      </div>

      {/* Advisors Section - Client Component */}
      <AdvisorsClient advisors={advisors} />

      {/*Footer section*/}
      <Footer />
    </div>
  );
}
