import { GalleryVerticalEnd } from "lucide-react";

import { LoginForm } from "@/components/login-form";
import Image from "next/image";

export default function LoginPage() {
  return (
    <div className=" relative grid min-h-svh lg:grid-cols-2 bg-gradient-to-br from-rose-50 via-sky-50 to-violet-50">
      <div className="absolute inset-0 z-0">
        {/* Soft Gradient Overlay */}
        <div className="absolute inset-0 bg-gradient-to-br from-rose-100/40 via-sky-100/30 to-violet-100/40" />
      </div>
      <div className="flex flex-col gap-4 p-6 md:p-10 z-10">
        <div className="flex justify-center gap-2 md:text-xl">
          <a href="/" className="flex items-center gap-2 text-xl outfit-400 ">
            MyAdvisor
          </a>
        </div>
        <div className="flex flex-1 items-center justify-center">
          <div className="w-full max-w-xs">
            <LoginForm />
          </div>
        </div>
      </div>
      <div className="bg-muted relative hidden lg:block">
        <video
          src="/images/UCT_login_vid.mp4"
          className="absolute inset-0 h-full w-full object-cover dark:brightness-[0.2] dark:grayscale"
          autoPlay
          loop
          muted
          playsInline
        />
      </div>
    </div>
  );
}
