import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Anta } from "next/font/google";
import { Aldrich } from "next/font/google";
import { Outfit } from "next/font/google";

const outfit = Outfit({
  subsets: ["latin"], // You can change to ["latin-ext"] etc.
  weight: ["300", "400", "500", "700"], // Choose weights you actually use
});

const anta = Anta({
  weight: "400", // Anta is a static font so only one weight
  subsets: ["latin"],
  variable: "--font-anta", // Creates a CSS variable
});

const aldrich = Aldrich({
  weight: "400", // Anta is a static font so only one weight
  subsets: ["latin"],
  variable: "--font-aldrich", // Creates a CSS variable
});

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "MyAdvisor",
  description: "Generated by create next app",
};

import { AuthProvider } from "@/components/AuthContext";

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <AuthProvider>
        <body
          className={`${geistSans.variable} ${geistMono.variable} antialiased`}
        >
          {children}
        </body>
      </AuthProvider>
    </html>
  );
}
