// Remove "use client" from page.tsx
import React from "react";
import { Navbar } from "@/components/Navbar";
import { Footer } from "@/components/Footer";
import { getFacultiesAction } from "@/lib/actions";
import { RoadmapClient } from "@/components/roadmap/RoadmapClient";

export default async function Page() {
  // Fetch data server-side (no CORS issues)
  const initialFaculties = await getFacultiesAction();

  return (
    <div className="relative flex flex-col items-center min-h-screen pt-5 bg-gradient-to-br from-rose-50 via-sky-50 to-violet-50">
      <div className="absolute inset-0 z-0">
        <div className="absolute inset-0 bg-gradient-to-br from-rose-100/40 via-sky-100/30 to-violet-100/40" />
      </div>
      <div className="relative z-10 w-full flex flex-col items-center h-min-screen">
        <Navbar />

        {/* Pass initial data to client component */}
        <RoadmapClient initialFaculties={initialFaculties} />
      </div>
      <Footer />
    </div>
  );
}
