import { NextRequest, NextResponse } from 'next/server';

export async function GET(request: NextRequest) {
  try {
    const res = await fetch(
      `https://myadvisor.cs.uct.ac.za/backend/departments/`,
      { 
        method: "GET",
        cache: 'no-store',
        headers: {
          'Accept': 'application/json',
        }
      }
    );

    if (!res.ok) {
      console.error('External API error:', res.statusText);
      return NextResponse.json(
        { error: `Failed to fetch departments: ${res.statusText}` },
        { status: res.status }
      );
    }

    const data = await res.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('API Route error:', error);
    return NextResponse.json(
      { 
        error: 'Internal server error', 
        details: error instanceof Error ? error.message : 'Unknown error occurred'
      },
      { status: 500 }
    );
  }
}