import type { IncomingMessage, ServerResponse } from 'http';
import type { __ApiPreviewProps } from '../.';
import type { ServerOnInstrumentationRequestError } from '../../app-render/types';
type RevalidateFn = (config: {
    urlPath: string;
    revalidateHeaders: {
        [key: string]: string | string[];
    };
    opts: {
        unstable_onlyGenerated?: boolean;
    };
}) => Promise<void>;
type ApiContext = __ApiPreviewProps & {
    trustHostHeader?: boolean;
    allowedRevalidateHeaderKeys?: string[];
    hostname?: string;
    revalidate?: RevalidateFn;
    multiZoneDraftMode?: boolean;
    dev: boolean;
};
export declare function apiResolver(req: IncomingMessage, res: ServerResponse, query: any, resolverModule: any, apiContext: ApiContext, propagateError: boolean, dev?: boolean, page?: string, onError?: ServerOnInstrumentationRequestError): Promise<void>;
export {};
