from flask import Flask, request, jsonify
import psycopg2
import psycopg2.extras

app = Flask(__name__)

# Establish the connection once when the app starts
DATABASE_CONFIG = {
    'host': 'localhost',
    'port': 5432,
    'dbname': 'university_test',
    'user': 'postgres',
    'password': 'kie6Aegh'
}

try:
    conn = psycopg2.connect(**DATABASE_CONFIG)
    conn.autocommit = True  # optional: avoid needing conn.commit()
    print("✅ Database connection established.")
except Exception as e:
    print("❌ Failed to connect to database:", e)
    conn = None

@app.route('/faculties', methods=['GET'])
def get_faculties():
    if conn is None:
        return jsonify({"error": "Database not connected"}), 500
    
    try:
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
        cursor.execute("SELECT * FROM faculties;")
        rows = cursor.fetchall()
        # Convert rows to list of dicts
        result = [dict(row) for row in rows]
        cursor.close()
        return jsonify(result)
    except Exception as e:
        return jsonify({"error": str(e)}), 500

@app.route('/departments', methods=['GET'])
def get_departments():
    if conn is None:
        return jsonify({"error": "Database not connected"}), 500
    
    try:
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
        cursor.execute("SELECT * FROM departments where faculty_id=1;")
        rows = cursor.fetchall()
        # Convert rows to list of dicts
        result = [dict(row) for row in rows] 
        cursor.close()
        return jsonify(result)
    except Exception as e:
        return jsonify({"error": str(e)}), 500

@app.route('/add-student', methods=['POST'])
def add_student():
    data = request.get_json()
    name = data.get('name')
    major = data.get('major')

    if not name or not major:
        return jsonify({"error": "Missing name or major"}), 400

    try:
        cursor = conn.cursor()
        cursor.execute(
            "INSERT INTO students (name, major) VALUES (%s, %s);",
            (name, major)
        )
        cursor.close()
        return jsonify({"message": "Student added successfully!"})
    except Exception as e:
        return jsonify({"error": str(e)}), 500

if __name__ == '__main__':
    app.run(debug=True)
