# MyAdvisor Frontend

MyAdvisor is a web-based academic advising platform developed for the University of Cape Town (UCT).
The application simplifies handbook navigation, streamlines advisor communication, and supports academic planning for students across faculties.
This repository contains the **frontend application**, built for both **desktop and mobile users** with a responsive, student-friendly design.

## Table of Contents

- [Features](#features)
- [Technologies Used](#technologies-used)
- [Requirements](#requirements)
- [Installation](#installation)
- [Usage](#usage)
- [Project Structure](#project-structure)
- [Contribution Guidelines](#contribution-guidelines)
- [Contact & Acknowledgments](#contact--acknowledgments)

---

## Features

- **Handbook Simplification**: Dynamic filtering/searching of faculty handbooks.
- **Helpbot**: NLP-powered chatbot trained on UCT FAQs and student queries.
- **Ask an Advisor**: Structured query submission routed to relevant advisors.
- **Degree Roadmap**: Visual representation of student progress with pass/fail tracking.
- **FAQ Section**: Quick access to commonly asked questions.
- **Glossary**: Definitions of UCT-specific academic terms.
- **Find Advisor Page**: Searchable directory of faculty advisors.
- **Courses Page**: Interactive course catalog with prerequisites and credit information.

---

## Technologies Used

- **React.js** (UI development, component-based architecture)
- **Next.js** (routing, server-side rendering)
- **Tailwind CSS** (utility-first styling)
- **shadcn/ui** (UI component library)
- **npm** (package management)

---

## Requirements

- **Node.js** version 18+
- **npm** (comes bundled with Node.js) or **yarn** package manager
- Modern browser (latest Chrome, Firefox, or Edge recommended)

---

## Installation

```bash
# Navigate into the project directory
cd My-Advisor

# Install dependencies
npm install
# or
yarn install
```

---

## Usage

```bash
# Start the development server
npm run start

# Run tests
npm run dev

# Build for production
npm run build
```

---

## Project Structure

```
myadvisor-frontend/
│── public/            # Static assets (images, icons, etc.)
│── src/
|   ├── app/           # Pages for the web appilcaiton
│   ├── components/    # Reusable UI components
│   ├── lib/           # Api Helper function
│   ├── style/         # Tailwind CSS and custom styles
│   ├── utils/         # Helper functions
│   └── hooks/         # Custom React hooks
│── package.json       # Project metadata and dependencies
│── README.md          # Documentation (this file)
```

---

## Contribution Guidelines

1. Fork the repository.
2. Create a new branch for your feature/fix:
   ```bash
   git checkout -b feature/your-feature
   ```
3. Commit your changes with a descriptive message.
4. Push your branch and submit a Pull Request.

Please follow standard **React + Next.js coding conventions**, use **Prettier/ESLint** for formatting, and write tests for new features.

---

## Contact & Acknowledgments

**Maintainer:** Ethan Allies

- Email: ethan.allies@gmail.com
- GitHub: [EthanAllies](https://github.com/EthanAllies)

Special thanks to the UCT Computer Science Honours program for project supervision and support.

---
