INSERT INTO course (
    course_code,
    course_name, 
    nqf_credits,
    nqf_level,
    semester_id,
    department_id,
    convener,
    course_entry_requirements,
    corequisites,
    objective,
    course_outline,
    lecture_times,
    dp_requirements,
    assessment,
    notes
) VALUES
('ECO4006F', 'MACROECONOMICS', 16, 8, 'F', 'ECO', 'A Hofmeyr', 'At least 40% for ECO4112F', NULL, NULL, 'The course studies the principal macroeconomic approaches towards understanding short-run fluctuations in aggregate output and the longer-term determinants of macroeconomic performance. Business cycles are investigated from a traditional Keynesian and New Keynesian perspective, complemented by a discussion on monetary and fiscal policy options. For understanding economic growth, the course reviews the exogenous growth model as well as new growth theories and alternative perspectives.', 'Tuesday: 09h00-10h45', 'None', 'Coursework 40% and examination 60% Note: A supplementary exam will only be offered for ECO4006F during the mid-year vacation.', NULL),

('ECO4007F', 'MICROECONOMICS', 16, 8, 'F', 'ECO', 'A Hofmeyr', 'At least 40% for ECO4112F.', NULL, NULL, 'This course covers topics in microeconomics that are fundamental to modelling the behaviour of economic agents, markets, and strategic interactions. The course starts with the analysis of individual decision making, which is often referred to as decision theory. It then covers individual interactions in "markets," prior to focussing on game theory, which is the natural extension of decision theory to strategic interactions between economic agents. The course concludes by focussing on applications of game theory.', 'Wednesday: 11h00-12h45', 'None.', 'Coursework 50%, Examination 50%. Note: A supplementary exam will only be offered for ECO4007F during the mid-year vacation.', NULL),

('ECO4013S', 'INTERNATIONAL FINANCE', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'The course provides an introduction to international finance and makes use of financial and open-economy macroeconomics modelling techniques to investigate topics that are relevant to this field of study. Topics covered include an overview of the foreign exchange markets, the properties of exchange rate data, models for exchange rate determination, interest rate parity conditions, carry-trade and currency momentum models, measuring and managing exchange rate risk, as well as the role of deficits and current account imbalances.', 'Thursday: 09h00-10h45.', 'None.', 'Coursework 40%, Examination 60%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4016F', 'ECONOMETRICS', 16, 8, 'F', 'ECO', 'A Hofmeyr', 'At least 50% for ECO4112F', NULL, NULL, 'This course is an introduction to econometric theory and practice. It provides the tools with which to test hypotheses and generate predictions of economic activity. The main focus is on causal inference with non-experimental data. The course has a strong lab-based component in which students work with the statistical computing package Stata. The topics covered include omitted variable bias and measurement error in regression models; panel data methods; limited dependent variables and sample selection corrections; and basic regression analysis with time series data (covering stationarity, autocorrelation, and other similar introductory concepts).', 'Tuesday: 11h00-12h45 & 14h00 - 14h45', 'None.', 'Coursework 60%; examination 40%. Note: A supplementary exam will only be offered for ECO4016F during the mid-year vacation.', NULL),

('ECO4020S', 'ECONOMIC CHALLENGES IN AFRICA', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'After independence, many parts of Africa suffered serious relative economic decline. Recent growth rates have been very promising. This course is therefore about the challenges confronting economic development in Africa (generally excluding South Africa). It seeks to provide a detailed overview of African development, and exposes students to debates regarding past problems, current issues and future possibilities. The focus is applied and policy oriented. Topics include the state in Africa, challenges of managing capital flows, aid, resources and conflict, agriculture and industrialisation.', NULL, 'None', 'Coursework only consisting of 2 essays, each 25%; 20% on panel performance and class participation. Note: No supplementary exam is offered for this course.', NULL),

('ECO4021W', 'RESEARCH & WRITING I', 30, 8, 'W', 'ECO', 'A Hofmeyr', 'See entrance requirements for Honours in Economics. At least 40% for ECO4112F. If students do not pass ECO4006F, ECO4007F, and ECO4016F, they will have to deregister from ECO4021W.', NULL, NULL, 'The long paper is to take the form of an article intended for submission to the South African Journal of Economics. A student must follow their referencing style. Given that it is to take the form of an article, the long paper should be divided into sections rather than chapters, and a maximum of 8 000 words has been imposed. It must be written in an appropriate academic style.', 'None', 'None.', '100% written work Note: Students that receive a subminimum of 40% for their research paper (ECO4021W), will be given one opportunity to revise and resubmit their paper before the start of the following academic year. The revised research paper will be eligible for a maximum grade of 50%. Any student who fails ECO4021W after re-submission fails the degree.', NULL),

('ECO4026S', 'THE ECONOMY & ITS FINANCIAL MARKETS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course is designed to help students appreciate the relationship between the economy and its financial markets so that they may better understand how the economy works, how financial markets behave and how they work and interact with each other. The programme is aimed at developing a feel for the rationality of ''the market'' and the often discordant sounds and rhythms of financial markets. We hope to develop a stronger sense of how the financial market anticipate and influence economic policy. We will interact with the data on the economy and the markets using Econometric packages with which students should be familiar. We will use regression analysis and other econometric techniques to build and analyse models of the economy and the financial markets. As a result students will be expected to become more perceptive analysts of published financial data and economic events and of the role played by financial markets in promoting economic development.', 'Friday: 14h00 – 17h45', 'None.', 'Coursework 50%; examination 50%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4027S', 'THE ANALYSIS OF SURVEY DATA', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course will be jointly offered to both Economics and Statistics honours students. This course examines a range of statistical techniques for using survey data and presents methods to compensate for design features for complex sample survey data. These techniques are then applied to a selection of policy issues through the analysis of South Africa household surveys. Firm survey data is also introduced and economic development applications are presented. Section 1: Analysis of complex sample surveys. Section 2: Social policy issues and the analysis of household survey data.', 'Monday & Wednesday:14h00-15h45', 'None.', 'Coursework 60%; examination 40%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4028S', 'POLICY ANALYSIS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course will give students exposure to policy issues in a number of key economic domains. The course will utilise real policy issues that have emerged in the current context in South Africa in which those teaching will have had an active role. While precise topics will vary each year, examples are industrial policy, trade, overall government strategy, environmental management and alcohol regulation. Students will be exposed to the debates over real policy issues and the techniques and tools to deal with them. Outputs will place emphasis on policy briefings, cabinet memoranda and the like rather than essays. There will be a strong emphasis on discussion and participation in class.', 'Wednesday:16h00-17h45', 'None.', 'Coursework 100%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4029S', 'EXPERIMENTS IN ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course is an introduction to the methodology of experimental economics and its application to specific topics such as decision making under risk and over time, the provision of public goods, and bargaining. We will primarily focus on laboratory experiments but we will also cover field experiments, and briefly discuss randomised evaluations, and natural experiments. The course will start with a consideration of the scope and role of experiments in economics. It then explores some basic principles of experimental design such as the role of randomisation and control in experimentation, the use of incentives, and the interplay of theory, experimental design, and statistics. Thereafter we will focus on specific examples of experiments from both decision theory and game theory.', 'Friday: 09h00-10h45', 'None.', 'Coursework 60%; examination 40%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4032S', 'ECONOMICS OF INDUSTRY, REGULATION AND FIRMS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'The course is an introduction to industrial economics and competition policy. During the course you will become familiar with theoretical models of price discrimination and product design by a monopolist, regulation of natural monopoly and oligopolistic competition. We will then use these models to study horizontal and vertical mergers between firms and understand the mechanics of collusion. The application of these models will be illustrated using examples of firm strategies as well as regulatory and antitrust cases. The course is fundamental to students interested in working as economists at the antitrust authorities, regulatory agencies, economic consulting firms or other firms which are involved in regulated activities. During the course you will receive take home exercises to be able to practice how to solve the theoretical models by yourself. You will be also asked to make a group presentation of a selected competition case. The main topics covered within the course are: Monopoly and price discrimination Regulation of natural monopoly Models of imperfect competition Collusion Market definition and horizontal mergers Vertical relations and restraints.', 'Tuesday: 14h00-15h45', 'None', 'Coursework (30%); final examination (70%). Note: No supplementary exam is offered for this course.', NULL),

('ECO4051S', 'DEVELOPMENT ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course covers a range of macro and microeconomic issues of particular relevance to developing countries. While precise topics covered will vary, examples include the nature and measurement of development, privatisation and deregulation, role of institutions, industrialisation and trade strategy, globalisation, transnational corporations and foreign investment and the role of the state and industrial policy. While key theoretical issues are dealt with, the approach is primarily applied with extensive use made of actual policy experience in a wide range of developing countries.', NULL, 'None.', 'Coursework consisting of essays, presentation and class participation (60%), examination (40%). Weightings may change from year to year and will be specified clearly in the course outline Note: No supplementary exam is offered for this course.', NULL),

('ECO4052S', 'ENVIRONMENTAL ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course will expose students to a variety of real world problems like control of pollution, management of mines, forests and fisheries, funding biodiversity and putting the environment into project and policy decision-making. The emphasis is on practical application of economic tools. The course will consist of a mixture of lectures, readings, seminars and practical/problem solving sessions. There will be group projects for 3-4 people which will be very practically based, but should be written as a short paper, with a basic literature review that draws on the topics covered in the class.', 'Thursday: 14h00-15h45', 'None.', 'Coursework 50%; examination 50%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4053S', 'FINANCIAL ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'Economics of arbitrage and martingale pricing, derivatives markets; binomial model, introduction to Ito calculus, Black-Merton-Scholes analysis; bond market basics introduction to interest rate derivatives; mean-variance analysis, Capital Asset Pricing Model, multi-factor models and Arbitrage Pricing Model, stochastic discount factor; asymmetric information and limits to arbitrage.', 'Tuesdays- 16h00-17h45; Lab Sessions: Wednesdays: 09h00-10h45', 'None.', 'Coursework 40%; examination 50%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4112F', 'MATHEMATICS AND STATISTICS FOR ECONOMISTS', 16, 8, 'F', 'ECO', 'A Hofmeyr', 'See entrance requirements for Honours in Economics.', NULL, NULL, 'This course covers the basic tools and applications in order to prepare the student for the study of Macroeconomics, Microeconomics and Economometrics at an intermediate and advanced level. Material covered includes linear algebra, comparative statics, optimisation, integration and differential difference equations.', NULL, 'None.', 'Coursework consisting of 3 tests (15% each); 45%; examination 55%. Note: Students who obtain less than 50% for ECO4112F will not be allowed to continue with the programme.', NULL),

('ECO4113S', 'LABOUR ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'The Honours course in labour economics intends to introduce a number of topics that are important for the analysis of economies in developing countries as well as our own. The course will focus on the following topics: labour supply and returns to education, inequality and the labour market, discrimination, international migration, intergenerational mobility, data analysis in labour economics, schooling, growth, poverty and inequality: the role of labour markets, minimum wages, labour regulation, enforcement and violation, trade unions, collective bargaining and wage-employment dynamics, labour regulation.', 'Monday, 09h00 - 10h45, 16h00-17h45', 'None.', 'Coursework 40%; examination 60%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4114S', 'THE ECONOMICS OF CONFLICT, WAR AND PEACE', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'Peace, war and international security is an area in which economists are often conspicuous by their absence, to a degree that rivals the importance of economic issues to the problems at hand. This course considers the contribution that economics has and does make to the understanding of conflict war and peace, with a focus on Africa. It covers topics such as: the causes and economic effects of military spending; the economic causes and effects of conflict and terrorism; the economics of post conflict reconstruction; the international arms industry; and the international arms trade.', 'Tuesday: 09h00-10h45', 'None.', 'Coursework consisting of one project 50%; examination 50%. Note: No supplementary exam is offered for this course.', NULL),

('ECO4131S', 'DIGITAL ECONOMICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'The purpose of this course is to introduce the main topics in digital (or Internet) economics. During the course we will identify and formalize the main features of digital goods and discuss why they may lead to particular market outcomes (such as market dominance by a single firm). Next, we will discuss pricing and product design strategies used by firms in digital markets. During the lectures we will make references to relevant theoretical and empirical material in industrial organization and management science. We will debate and students will be asked to deliver oral presentations of past and ongoing regulatory and antitrust cases. We will also discuss the role of government in the regulation of digital markets.', NULL, 'Submitted homework assignments; Case study presentation', 'Coursework: 40%; Written examination: 60% Note: No supplementary exam is offered for this course.', NULL),

('ECO4132S', 'ECONOMICS OF INEQUALITY: CAUSES, CONSEQUENCES AND POLICY', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course aims to study the causes, consequences and policy implications of income inequality. Strong emphasis is placed on determining the mechanisms through which the persistence of inequality arises. While the primary lens used to analyse this phenomenon is economics, the course also considers the impacts of financial markets, credit and savings, health, education, social networks and political mechanisms. We complement the theory by reviewing relevant empirical findings where possible. The course includes an overview of global inequality, both within and between countries, as well as a strong emphasis on South African inequality.', NULL, 'The classroom presentation will be compulsory. This will be a 10-15 minute presentation on a topic of the student''s choosing where they investigate some aspect of economic inequality.', 'The course will have three assessment components.1. A mid-term essay (30%) 2. A classroom presentation (20%) 3. A final essay (50%) Note: No supplementary exam is offered for this course.', NULL),

('ECO4200S', 'TIME SERIES ECONOMETRICS', 14, 8, 'S', 'ECO', 'A Hofmeyr', 'ECO4006F, ECO4007F and ECO4016F. PPE (and other) students who do not have to complete the core as part of their degree requirements may be granted permission to register for this elective at the discretion of the Head of Department.', NULL, NULL, 'This course provides an intermediate level introduction to the application of modern time series methods that may be used to analyse economic data. The initial part of the course includes a review of techniques that can be used to identify the dynamic properties of time series data. Thereafter, a selection of the popular modelling frameworks is introduced (i.e. autoregressive integrated moving average models, distributed lag models, and vector autoregressive models). Extensions to these frameworks, which allow for aspects such as cointegration and error correction representations, are also covered, before attention is directed towards the application of model misspecification tests and forecasting exercises.', 'Thursday: 09h00-10h45.', 'None.', 'Coursework 30%, Examination 70%. Note: No supplementary exam is offered for this course.', NULL),

-- FINANCE COURSES (FTX)
('FTX4051H', 'FINANCE RESEARCH PROJECT', 36, 8, 'H', 'FTX', 'C Huang', 'A combined average of at least 60% for FTX3044F and FTX3045S with a minimum of 50% for each of these courses – a pass in both ECO2003F and ECO2004S.', 'STA3022F', 'To develop and implement finance research skills through an academic research project.', 'Lectures are held to impart basic knowledge and skills in order to embark on a finance-related research project. Concurrently, students are required to form a group of specified size, agree on a research topic with a supervisor, and submit a proposal. Once a proposal is accepted, the student-groups apply relevant finance research techniques to solve their research problem. During the course of the year, the student-groups are expected to submit a literature review and a final submission of their report. The report is expected to be in the format of a journal manuscript. Students may be required to attend a question and answer session after the final submission.', 'There is 1 double lecture per week, Wednesday, during 7th and 8th period.', 'Progress to the supervisor''s satisfaction, lecture attendance and 40% average of graded submissions.', 'Assessment will be based on the research project. Literature review submission 10% - 20%, Final submission 80% - 90%. Exact allocation in course outline.', NULL),

('FTX4052H', 'FINANCE HONOURS RESEARCH PROJECT', 40, 8, 'H', 'FTX', 'C Huang', 'Registration for the Bachelor in Commerce Honours degree specialising in Finance (CH001FTX05).', 'FTX4056F Applied Investments; FTX4057S Applied Corporate Finance; FTX4086F Alternative Investments.', 'To develop and implement finance research skills through an academic research project.', 'Lectures are held to impart basic knowledge and skills in order to embark on a finance-related research project. Concurrently, students are required to agree on a research topic with a supervisor, and submit a proposal. Once a proposal is accepted, the student applies relevant finance research techniques to solve the research problem. During the course of the year, the student is expected to submit a literature review and a final submission of their report. The report is expected to be in a format of a journal manuscript. Students may be required to participate in a question and answer session after the final submission.', 'There is 1 double lecture per week, Wednesday, during 7th and 8th period.', 'Progress to the supervisor''s satisfaction, lecture attendance and 40% average of graded submissions.', 'Assessment will be based on the research project. Literature review submission 10% - 20%, Final submission 80% - 90%. Exact allocation in course outline.', NULL),

('FTX4056S', 'APPLIED INVESTMENTS', 18, 8, 'S', 'FTX', 'A Majoni', 'A combined average of at least 60% for FTX3044F and FTX3045S with a minimum of 50% for each of these courses; ECO2003F and ECO2004S; STA2020F/S.', NULL, 'The course will allow students to (1) deepen their understanding of derivatives, financial risk management, fixed income securities and portfolio management. (2) apply finance concepts, principles, and techniques to make informed investment decisions and solve practical problems currently encountered by finance professionals. (3) develop analytical problem-solving skills and critical thinking skills. (4) To bridge the gap between university investment theory and its practical application.', 'In this course students are exposed to advanced issues in investment finance from both a practical and theoretical perspective. Students are required to understand and be able to deal with substantial uncertainty when making investment decisions, and to report on a range of practical problems which are currently encountered by finance professionals.', '2 lectures per week, Monday and Thursday, both 7th and 8th periods.', 'A minimum weighted average of at least 40% for tests and assignments as well as 100% workshop attendance.', 'Coursework (including tests and assignments) 40% final examination 60%.', NULL),

('FTX4057F', 'APPLIED CORPORATE FINANCE', 18, 8, 'F', 'FTX', 'R Kruger', 'A combined average of at least 60% for FTX3044F and FTX3045S with a minimum of 50% for each of these courses, ECO2003F and ECO2004S', NULL, 'The course objectives are: 1. To give students experience in analysing and solving a range of practical real-life problems involving the application of finance concepts. 2. To expose students to real-life problems facing finance managers and other finance professionals. 3. To bridge the gap between university corporate finance theory and corporate finance practice.', 'In this course, students are exposed to advanced issues in corporate finance from both a practical and theoretical perspective. Academically, the course builds on the theoretical foundation laid in the prerequisite earlier courses. However, this course takes a more application-orientated approach, and is therefore largely case-study based.', '2 lectures per week, Monday, Thursday, both 7th & 8th periods.', 'Satisfactory progress in the assignments and mid-term test.', 'Coursework (including tests and assignments) 50%; final examination 50%.', 'Ad Hoc Workshops hosted, no tutorials.'),

('FTX4086F', 'ALTERNATIVE INVESTMENTS', 18, 8, 'F', 'FTX', 'F Toerien', 'A combined average of at least 60% for FTX3044F and FTX3045S with a minimum of 50% for each of these courses, ECO2003F and ECO2004S, or registration for the Bachelor of Commerce Honours specialising in Finance [CH001FTX05].', NULL, 'To give students exposure to the main classes of Alternative Investments.', 'The so-called "alternative investments" are becoming increasingly important as an investment class. This course deals with a number of specialised areas of investment finance which are not typically covered in other parts of the finance undergraduate curriculum, such as real estate investments, hedge funds, commodities and private equity. Each investment class covered in the course will be discussed as a separate module, and students will be exposed to both the theoretical and practical aspects of each. In addition to lectures, this course also includes workshops intended to make concepts and the practical application of alternative investments clearer.', '2 lectures per week, Tuesday, Friday, both 6th & 7th periods.', 'None.', 'Coursework including tests and projects 40%; Final examination 60%.', '(Ad Hoc Workshops hosted, no tutorials).'),

('FTX4087S', 'TOPICS IN BANKING AND TREASURY MANAGEMENT', 18, 8, 'S', 'FTX', 'R Kruger', 'A combined average of at least 60% for FTX3044F and FTX3045S with a minimum of 50% for each of these courses, ECO2003F and ECO2004S', NULL, 'To introduce students to key concepts and challenges in banking and treasury management.', 'Treasury management is an essential function within every corporation and has as its goal the management of the firm''s liquidity, operational and financial risk. This course exposes students to these topics with a focus not only on understanding the theory underpinning these crucial functions, but also the challenges companies face in achieving these aims and practical tools they may use to mitigate these risks. In addition to this, students are introduced to the treasury management function within banking institutions and how they support their clients'' corporate treasury management functions.', '2 lectures per week, Tuesday and Friday during 7th and 8th period.', 'None', 'Coursework including test and project (40%); Final examination 60%', NULL),

-- INFORMATION SYSTEMS COURSES (INF)
('INF4024W', 'INFORMATION SYSTEMS RESEARCH PROJECT', 60, 8, 'W', 'INF', 'S Kabanda', 'This course is restricted to students admitted into the honours programmes in Information Systems and the honours programme in Management Information Systems.', NULL, 'The course provides a first research exposure leading to an Honours Degree. Candidates will be expected to develop critical reading, analysis and research design skills, as well as to demonstrate good writing skills.', 'The course commences with taught sessions in research techniques. The Department may, at its discretion, choose to cover these materials in evening sessions of three hours each or via short full-time blocks, not exceeding six days in duration. Thereafter students will select research areas and prepare research proposals. Students will be assigned to mentors, who will assist and guide them through the research process. Additional three-hour seminars covering academic writing and research methodology will be provided at appropriate times throughout the year.', 'This course runs in 2 block session: One in the beginning of the 1st semester, and the second block runs in the middle of the 1st semester', 'None', 'Students will be evaluated as follows: Interim deliverables 40%; Empirical report 60%. An overall mark of at least 50% is required to pass the programme and a minimum of 50% must be obtained for the Empirical Report.', NULL),

('INF4025S', 'INFORMATION SYSTEMS MANAGEMENT', 20, 8, 'S', 'INF', 'A Budree', 'Students should meet the entrance requirements to the IS Honours programme.', NULL, 'The major objectives of the course are to research, present and discuss the major academic contributions in the field of IS development and management in seminars. To develop strong communication, interpersonal and change agent skills. To develop a community spirit through the Honours Outreach and Community Involvement Programme (HOCIP)', 'The course covers IS Management topics, which are selected based on current research from academia and industry. Students are required to research a topic, and firstly produce a seminar paper in collaboration with an academic. Once the seminar paper has been approved by the academic, students have to develop and present a seminar on the topic, and facilitate a question and answer session. Guests from industry are often invited to present their experience on the topic after the students.', 'Monday and Thursday, 6th & 7th', '75% attendance and participation in seminars, a minimum of 50% for seminar management (developing and presenting a seminar paper according to scope, quality and time guidelines), and a sub-minimum of 45% in the final examination', 'Seminar and classwork deliverables 60%, Final Assessment 40%', NULL),

('INF4026F', 'APPLICATION & TECHNICAL DEVELOPMENT', 20, 8, 'F', 'INF', 'A Budree', 'Students should meet the entrance requirements to the IS Honours programme.', NULL, 'The major objectives of the course are to research, present and discuss the major academic contributions in the field of IS development and management in seminars. To develop strong communication, interpersonal and change agent skills. To develop a community spirit through the Honours Outreach and Community Involvement Programme (HOCIP), and Service in Context course', 'The course covers twelve IS application and technical development topics, which are selected based on current research from academia and industry. Students are required to research a topic, and firstly produce a seminar paper in collaboration with an academic. Once the seminar paper has been approved by the academic, students have to develop and present a seminar on the topic, and facilitate a question and answer session. Guests from industry are often invited to present their experience on the topic after the students.', 'Monday and Thursday, 6th to 7th period', '75% attendance and participation in seminars, a minimum of 50% for seminar management (developing and presenting a seminar paper according to scope, quality and time guidelines), and a sub-minimum of 45% in the final examination.', 'Seminar and classwork deliverables 60%, Final Assessment 40%', NULL),

('INF4027W', 'SYSTEM DEVELOPMENT PROJECT II', 40, 8, 'W', 'INF', 'E Scott', 'Students should meet the entrance requirements to the IS Honours programme and may be required to write an entrance exam.', NULL, 'The main objective of the course is to develop students'' knowledge and understanding of facts, concepts, principles and theories of software development and agile methodologies through the implementation of these concepts in a systems development (SD) team project for sponsor in industry.', 'For the Systems Development Project II course, teams of students are required to identify and analyse a real-world IS problem, then design, and develop and test a fully-functioning Information System that meets current and future requirements. The software projects are formulated by Industry Sponsors and relate to real-life business problems that need to be solved to bring business value. Students are required to use agile methodologies (Scrum/Kanban) to manage their projects. The course combines theoretical elements of agile project management and software development methodologies with the practical implementation of these concepts through the completion of the team projects. Students should use and integrate Analysis, Design, Programming and Testing skills learned during other undergraduate courses in their projects. Students should also adhere to the Software Engineering Institute (SEI) guidelines and principles in the five key focus areas of software development (requirements analysis, design, construction, testing, and quality assurance). Students are required to work independently, liaise with their sponsors to gather requirements and produce a workable solution in four (4) Iterations. To support development work, students should use tools like Trello, Jira, Git, Microsoft Azure etc. The course aims to equip students with problem-solving, team management, and technical skills, for them to be ready for a professional work environment.', NULL, 'None', 'Assessment will be based on compulsory deliverables within the following categories: Programming Test, Vision Presentation, BA & Innovation Document, Iterations Assessments (Documentation & Presentation) and the individual portfolio of evidence of each student.', NULL),

-- BUSINESS COURSES (BUS)
('BUS4006W', 'ORG PSYCH HONS COURSEWORK', 60, 8, 'W', 'BUS', 'A Jaga', 'The minimum admission requirement is a bachelor''s degree with Organisational Psychology/ Industrial Psychology as a major. In order to qualify for selection into the programme applicants should have an average of at least 65% for their third year level Organisational courses. Selection is based on academic performance and the University''s equity policy.', NULL, NULL, 'The central theme of this component is organisational change. This component aims to equip students with the knowledge and skills to act as change agents within an organisation. The coursework component comprises several compulsory modules.', NULL, 'Students must attend all lectures and complete all assessments', 'Students are required to obtain at least 50% overall for all coursework modules. Students are required to pass both the coursework (BUS4006W) and the research (BUS4030H) components in order to be awarded the degree.', NULL),

('BUS4026W', 'MARKETING III', 72, 8, 'W', 'BUS', 'TBA', 'Only available to 4th year Business Science marketing students, and having completed BUS3041F, BUS3043S, BUS3008W.', NULL, NULL, 'The course consists of a number of advanced modules and electives may also be offered. Modules may include Retail Management, International Marketing, Service Marketing, B2B Marketing, Contemporary Marketing and Digital Marketing. Depending on the minimum number of students required, electives may be added or withdrawn on an annual basis. Similarly, module weights may be changed annually. Students should consult with the Marketing section to establish which modules are offered in a specific year. If resources permit students will be allowed to select from multiple modules. As a general rule, this course is available only to 4th year Business Science students.', 'Lecture periods vary per semester and per module. Please refer to course outline, and liaise with course convener', 'For each module students must obtain at least 50% for all class work (projects, assignments and tests) to be allowed to write the examination. Students must also pass each module (>50%) and obtain at least a 50% aggregate mark to pass the course.', 'Coursework 50%, Final Exam 50%', 'Only available to 4th year Business Science Marketing students.'),

('BUS4027W', 'ACTUARIAL RISK MANAGEMENT', 54, 8, 'W', 'BUS', 'P Botha', 'Prerequisite courses: BUS2016H, BUS3018F, BUS3024S, STA3041F, STA3043S and, STA3045F. Co-requisite courses:, BUS4028F.', NULL, NULL, 'The aim of this subject is to instil in successful candidates the ability to apply a wide range of key actuarial concepts in simple traditional and non-traditional situations. It comprises the following topics: How to do a professional job, Stakeholders, Client needs and customer needs and implications for other stakeholders, Managing risks, Marketing, External environment, Investment environment, Meeting investor needs, Capital, Interaction with client, Awareness of risk, Management of provisions for liabilities, Project planning and management, Input validation, Methodology and techniques, Assumption setting, Design, Expenses, Developing the cost and the price, Provisioning, Relationship between assets and liabilities, Maintaining profitability, Determining the expected results, Reporting actual results, Risk management, Asset management, Capital management, Surplus management, Mergers and acquisitions, Insolvency and closure, Options and guarantees, Monitoring, Principal terms.', NULL, 'Completion and timeous submission of tutorial exercises. Sitting all class tests. An overall average of 40% for class work.', 'Tutorials and Tests 50%; End of year examinations (2x 3 hours) 50%', NULL),

('BUS4028F', 'ACTUARIAL SCIENCE III: FINANCIAL ECONOMICS', 21, 8, 'F', 'BUS', 'E Maritz', '4th year status in BBusSci (AcSci) or BBusSci (QF) – see Program Rules of BBusSci Actuarial Science – Rule FBC4. BComHons (AcSci / QF): As for progression to 4th year of BBusSci (AcSci / QF); or be in their second year of BComHons (AcSci / QF). Honours students not meeting the 60% requirement outlined in Rule FBC3.6 and FBC3.7 are required to defer registration for BUS4028F to their second year of registration.', NULL, NULL, 'The course covers the behaviour of financial markets, measures of investments risk, asset return models, derivative pricing and liability valuation. Topics include: the efficient markets hypothesis, utility theory, behavioural economics, measures of investment risks, mean-variance portfolio theory, the capital asset pricing model, multi-factor models of asset returns, Brownian motion, ito calculus, stochastic models for security prices, models of the term structures of interest rates, simple models for credit risk, valuation of futures and options, ruin theory and run-off triangles.', NULL, 'Completion of tutorials and tests with an average of 40%.', 'Tutorials 8%; Tests 32%; 3h15min written examination 42%; 1h45min computer- based examination 18%.', NULL),

('BUS4029H', 'ACTUARIAL RESEARCH PROJECT', 36, 8, 'H', 'BUS', 'M Mdlekeza', NULL, 'Concurrent registration for BUS4028F (Actuarial Science III: Financial Economics).', NULL, 'The project course aims at equipping students with research skills, to empower students with paper writing skills and to equip students with ability to search for information online using e.g. library resources, Bloomberg and other sources. The project also aims at inculcating a sense of responsibility and discipline among students. Submissions will be checked for plagiarism and other research misconduct. The project process consists of a submission of proposal, a literature review, an initial draft of the final paper and the final paper. Except for the proposal, all the other submissions will be evaluated with the marks forming part of the final project mark.', NULL, 'Passing the draft proposal by at least 4/10.', 'Course work 20%. Dissertation 80%. The literature Review will be marked out of 10 and the draft proposal will be marked out of 10. The final draft will be marked out of 100 but the overall mark = Literature Review Mark + Draft mark + 0.8* Final Mark.', NULL),

('BUS4030H', 'ORGANISATIONAL PSYCHOLOGY RESEARCH PAPER', 60, 8, 'H', 'BUS', 'A Jaga', 'Students must be registered for BUS4006W (i.e. students must have been accepted into the 4th year/Honours degree for Organisational Psychology.)', NULL, NULL, 'The aim of this component is to introduce students to research. Students who complete this component also will have a fundamental understanding of the ethics involved in the research process. Students form small research teams and are assigned to a supervisor. Regular meetings take place between supervisors and research teams. Deadlines for completion are set and have to be met at the different stages of the research process.', NULL, 'Students must attend compulsory workshops and complete all assessments.', 'Each research submission has an assessment weighting. Together with the final research report these submissions make up the mark for BUS4030H. Students are required to obtain at least 50% for the research report. Students are required to pass both the coursework (BUS4006W) and the research (BUS4030H) components in order to be awarded the degree.', NULL),

('BUS4034S', 'PROFESSIONAL COMMUNICATION (ACTUARIAL SCIENCE)', 27, 8, 'S', 'BUS', 'C Kalil', 'BUS2016H, BUS3018F and STA3041F. BUS3024S, STA3043S, STA3045F, BUS4028F.', NULL, NULL, 'The course develops theory and practice related to professional and business communication. It aims to enhance students'' ability to: plan and write business and professional document types with a focus on communicating actuarial science topics to various non-specialist audiences (e.g. traditional and electronic correspondence, reports and proposals); structure and deliver business presentations; design visual support for oral and written message; and work in teams to develop collaborative management and communication skills. Specific learning objectives are for effective: persuasion and argument; organisation, language and style for written business genres; use of visual aids, layout and formatting to enhance ease of access to information; planning and delivering persuasive presentations integrating visual aids; and collaborative management and communication for teaming.', NULL, 'Submission of all assignments and participation in oral presentations; attendance at all compulsory lectures and workshops.', 'PCU component: semester course work and presentations (60%); 3-hour written examination [Paper 1] (40%). Students must achieve a sub-minimum of 40% for each component with an average of 50%. In addition there is a 3-hour written examination (Paper 2) for professional exemption (N211). The final BUS4034S mark will be weighted as follows: PCU final mark: 70%; N211 Paper 2: 30%.', NULL),

('BUS4050H', 'STRATEGIC THINKING', 18, 8, 'H', 'BUS', 'M Hoffman', 'Completion of all special field courses up to the end of the third year (e.g. a Finance student must have completed all Finance courses). Students may register for BUS4050W only in the year in which they can potentially graduate.', NULL, NULL, 'BUS4050W is the capstone course available only to final year Business Science students. The aim of BUS4050W is to develop, test and improve students'' strategic thinking ability and how they can apply this to business. This future-oriented and outcome-based course develops other types of thinking or competencies which include visionary thinking, contextual thinking, collaborative thinking and creative thinking. The course covers and concentrates on classic Strategic Management, Blue Ocean Strategy, Scenario Planning, and Business Models which will assist the students'' preparation for the world of work. Business case studies will be introduced and discussed to assess embedded knowledge at the end of each of the above mentioned topics.', NULL, 'Completion of all coursework assessments.', 'Coursework 100%.', NULL),

('BUS4052H', 'MARKETING RESEARCH PROJECT', 36, 8, 'H', 'BUS', 'TBA', 'A student must be in his/her final year of study in the Business Science degree taking BUS4050W and BUS4026W and having completed BUS3041F, BUS3043S, BUS3008W and STA3022F.', NULL, NULL, 'Students will be required to undertake a scholarly research project in Marketing. Students will identify and develop a research project to investigate Marketing problems. The research involves the development of a research proposal, a review of the relevant literature, data collection and data analysis. Students report these in a thesis and present their findings to a panel of assessors and their peers. Guest lectures may be invited to provide practical Marketing Research Topics.', NULL, 'Submission of all deliverables and attendance of all guest lectures.', 'Various deliverables including a proposal (20%), literature review (40%), final report and manuscript (40%). There is no final exam for this course.', NULL),

('BUS4053H', 'QUANTITATIVE FINANCE RESEARCH PROJECT', 36, 8, 'H', 'BUS', 'M Mdlekeza', NULL, 'Concurrent registration for BUS4028F (Actuarial Science III: Financial Economics).', NULL, 'The project course aims at equipping students with research skills, to empower students with paper writing skills and to equip students with ability to search for information online using e.g. library resources, Bloomberg and other sources. The project also aims at inculcating a sense of responsibility and discipline among students. Submissions will be checked for plagiarism and other research misconduct. The project process consists of a submission of proposal, a literature review, an initial draft of the final paper and the final paper. Except for the proposal, all the other submissions will be evaluated with the marks forming part of the final project mark.', NULL, 'Passing the draft proposal by at least 4/10.', 'Course work 20%. Dissertation 80%. The literature Review will be marked out of 10 and the draft proposal will be marked out of 10. The final draft will be marked out of 100 but the overall mark = Literature Review Mark + Draft mark + 0.8* Final Mark.', NULL),

('BUS4058F', 'STRATEGIC MARKETING MANAGEMENT', 36, 8, 'F', 'BUS', 'TBA', 'Only available to 4th year Business Science marketing students, and having completed BUS3041F, BUS3043S and BUS3008W.', NULL, NULL, 'This course explores the field of strategic marketing and assumes market and stakeholder orientations. It seeks understanding of strategic analysis in general and customer, company and competitor analysis specifically. It then teaches the craft of strategy design from both prescriptive and descriptive perspectives. Therefore it includes both conventional and contemporary marketing strategy theories. The course concludes with approaches for strategy implementation and specific emphasis on marketing metrics, societal challenges and strategic control.', 'Tuesday 11h00 - 12h45 and Thursday: 12h00 - 12h45', 'Students must obtain at least 50% for all class work (projects, assignments and tests) to be allowed to write the examination.', 'Projects, assignments and tests) 50%, Final examinations (3 hours) 50%. Consult the course outline for the weighting of assessment components.', NULL),

-- GRADUATE PUBLIC POLICY COURSES (GPP)
('GPP4000W', 'RESEARCH AND POLICY NUMERACY', 10, 8, 'W', 'GPP', 'R Govender', 'Admission to the programme.', NULL, NULL, 'The course is designed to help participants improve their skills in the treatment and analysis of quantitative data and the reporting of research results. It begins with an overview of primary concepts in sampling, measurement and data sources before proceeding to explore and apply various bivariate and multivariate analytic techniques to available data. The course is not a statistics course per se, but instead focuses on how statistical techniques may be applied to quantitative data to answer specific questions related to development policy, planning and practice. The techniques covered range from frequency and contingency analysis to correlation and simple and multiple linear regression.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', '25% class participation, 75% Coursework. Submission of all assignments.', NULL),

('GPP4001W', 'PUBLIC LEADERSHIP AND GOVERNANCE', 20, 8, 'W', 'GPP', 'S Haricharan & M Camerer', 'Admission to the programme.', NULL, NULL, 'This course aims to equip students with skills, personal insight and inter-personal capabilities to enhance their effectiveness as leaders – within their organisations, across government, and at the interface between government, the private sector and civil society. Understanding the challenges facing leaders who promote public governance that supports a capable, ethical and developmental state is a key part of the course.', '2 hours per week.', NULL, 'Submission of all assignments and projects.', NULL),

('GPP4003W', 'TOPICS IN DEVELOPMENT POLICY', 20, 8, 'W', 'GPP', 'S Haricharan', 'Admission to the programme.', NULL, NULL, 'This course aims to equip students with cutting edge knowledge and tools in specialized areas of direct relevance to public sector leaders. At the beginning of the course, 3-4 subject areas will be introduced to all students by leading experts in each area, following which students will work in depth on one of these subject areas with the expert faculty.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', 'Submission of all assignments and projects.', NULL),

('GPP4004W', 'THE PRACTICE OF POLICY IMPLEMENTATION', 25, 8, 'W', 'GPP', 'F Ismail', 'Admission to the programme.', NULL, NULL, 'The course and assignments focus students on implementation realities and dealing with complex public policy problems, and help students think about and experiment with an implementation approach suited to complex problems. The students learn about constructing and deconstructing policy problems (to bring these onto the policy agenda and to enable policy responses). They also learn about the many options available to policy makers (in terms of solutions) and how to explore different options, experiment, and learn about what works and why. Students also learn about building and maintaining their authorizing environment and building and growing the multi-agent groups that make policy happen. Students work actively during the time in class to produce a problem analysis and implementation protocol for a problem of their choosing and then spend three months iterating with ideas to enact this protocol. This allows learning by doing.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', 'Submission of all assignments and projects.', NULL),

('GPP4006F', 'THE PRACTICE OF STRATEGIC POLICY-MAKING FOR DEVELOPMENT', 20, 8, 'F', 'GPP', 'M Nxele', 'Admission to the programme', NULL, NULL, 'This course aims to equip students with knowledge and tools to identify, design and build support for priority development policies. The course will: Provide a comparative overview of different approaches to development policy-making, across countries and over time; Explore ways to identify a ''good fit'' between policy design and a country''s economic, political and social context and institutions; Anchor the learning in case studies, with an emphasis on South African, and other African examples; and Provide a practical bridge between priority policy objectives in the student''s place of work and the knowledge and tools explored in the course', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', 'Submission of all assignments and projects.', NULL),

('GPP4008F', 'INTRODUCTION TO AFRICAN ECONOMIC DEVELOPMENT', 10, 8, 'F', 'GPP', 'C Lopes', 'Admission to the programme.', NULL, NULL, 'The purpose of this module is to help participants engage with the major concepts used in the analysis of economic development in Africa and to become familiar with some of the more important recent contributions to thinking about economic development that are relevant to Africa.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', 'Submission of all assignments and projects.', NULL),

('GPP5001F', 'STRATEGIC POLICYMAKING FOR DEVELOPMENT: ANALYSIS & PRACTICE', 20, 9, 'F', 'GPP', 'M Nxele', 'Honours degree or equivalent', NULL, NULL, 'This course aims to equip participants with knowledge and tools to identify, design and build support for priority development policies. The course will: Provide a comparative overview of different approaches to development policy-making, across countries and over time; Explore ways to identify a ''good fit'' between policy design and a country''s economic, political and social context and institutions; Introduce and apply tools that can help build momentum for policy change by engaging multiple government and non-governmental stakeholders in the policy formulation process; Anchor the learning in case studies, with an emphasis on South African, and other African, examples; and Provide a practical bridge between priority policy objectives in the participant''s place of work and the knowledge and tools explored in the course; Provide participants with methodological tools to evaluate current knowledge and data and facilitate the making of sound judgements on policy and implementation.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department. Submission of all assignments is required (research papers).', 'No examinations. Two papers (each 50% of the course grade) that apply the knowledge and tools of the course.', NULL),

('GPP5002S', 'POLICY IMPLEMENTATION', 25, 8, 'S', 'GPP', 'F Ismail', 'Honours degree or equivalent.', NULL, NULL, 'This course aims to equip students with knowledge and tools to move from broad policy goals and strategies to the details of design and implementation that are key to development effectiveness. The course will: Survey the multiple management functions that need to be addressed within the public sector (including budget planning; management of public expenditure and administration; procurement; parastatal governance); Diagnose the strengths and weaknesses of public bureaucracies as instruments of implementing public policy; Examine the potential of a variety of tools to enhance the transparency, accountability and effectiveness of public bureaucracies Anchor the learning in case studies, with an emphasis on South African, and other African, examples; and Provide a practical bridge between priority policy implementation challenges in their places of work and the knowledge and tools explored in the course. Review key economic concepts, with a focus on their relevance for policymaking, and the governance of markets; Explore the role and challenges of market regulation (e.g. utility regulation, environmental regulation, competition policy), with a focus on how economic reasoning can help guide regulatory design; Provide continuing instruction in methodological tools to evaluate current knowledge and data and facilitate the making of sound judgements on policy and implementation.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', '100% coursework.. Submission of all assignments and projects.', NULL),

('GPP5003W', 'PUBLIC LEADERSHIP AND GOVERNANCE', 20, 9, 'W', 'GPP', 'S Haricharan & M Camerer', 'Honours degree or equivalent', NULL, NULL, 'The aim of the Public Leadership and Governance course is to support students in their leadership development journey through gaining insights into their beliefs, attitudes, and behaviours and contextual developmental realities in Africa and globally. The course is offered in two parts: the first part takes you on a journey of self and social-awareness in supporting your personal development and agency in effecting change in your management and leadership roles. Classes focuses on understanding self; emotional intelligence; transformational leadership; personal, interpersonal and organisational transformation; mindfulness; neuroleadership; COVID-19 and leadership; and public governance. The second part explores ethical leadership and public accountability with a focus on ethical awareness, ethical blindness and ethical decision-making, including whistleblowing. The interaction between individual and institutional integrity is examined in the light of a critical evaluation of current international efforts to counter corruption.The course introduces students to a range of relevant theories, conceptual frameworks, case studies, tools, and practices in class, supported by distance assignments and coaching.', NULL, 'Attendance at lectures is compulsory except with the permission of the convener.', '100% coursework. Submission of all assignments and projects.', NULL),

('GPP5004W', 'DISCOURSES IN DEVELOPMENT POLICY IN AFRICA', 20, 9, 'W', 'GPP', 'F Ismail', 'Honours degree or equivalent.', NULL, NULL, 'This course aims to provide students with the capacity to critically examine and evaluate development policies in Africa. Key subject areas include discourses in trade policies of South Africa and the African continent, including; regional integration, bilateral relations, global governance and the climate-development nexus in Africa. The subject areas will enable students to engage and participate in discourses on the challenges of African public institutions, and development policy formulation and implementation, with a primary focus on trade strategy formulation and negotiations at a bilateral, regional or multilateral level, and a secondary focus on the political economy of climate change, just transition, and the green economy, among other topical discourses.', NULL, 'Attendance at lectures is compulsory except with the permission of the instructor.', 'Assessment will comprise the following: 100% coursework.', NULL),

('GPP5005W', 'MINOR DISSERTATION 60 CREDIT', 60, 9, 'W', 'GPP', 'M Nxele', 'Completion of coursework.', NULL, NULL, 'This is the final phase of the MPhil programme, in which the participant conducts research and submits a research dissertation of 20,000 words. The dissertation should demonstrate the participant''s ability to apply the material covered in the MPhil programme to a concrete development problem. It is desirable, though not required, that the dissertation address a development problem linked to the participant''s work experience. The dissertation generally should: •demonstrate mastery of the technical (economic and other) material relevant to the problem; •show an ability to diagnose the political, social and institutional environment within which the problem is embedded; •show an ability to assess how this environment influences what might be feasible options for addressing the problem; and •include and motivate a set of feasible technical and process proposals to address the problem.', NULL, 'Submission of a written research proposal of length 3500 words and presentation and departmental approval of the research proposal and receipt of ethics approval (if applicable).', 'Dissertation will be examined - 100% written work.', NULL),

('GPP5006F', 'RESEARCH DESIGN AND METHODS', 24, 9, 'F', 'GPP', 'R Govender', 'Honours degree or equivalent.', NULL, NULL, 'This course prepares students for their thesis work by introducing them to the fundamental principles of research design and methodology in qualitative, quantitative and mixed methods research. It covers the following core areas: the philosophies of the major research paradigms, ethics, values and virtues in contemporary research, conducting research in institutional contexts, and research design and current methods of data collection, data analysis and report writing.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', 'Coursework 100%.', NULL),

('GPP5007F', 'GLOBAL LEADERSHIP PRIORITIES', 15, 9, 'F', 'GPP', 'F Ismail', 'Honours degree or equivalent.', NULL, NULL, 'This multi-disciplinary course explores the intricate relationship between climate change and development on the African continent. It introduces students to various climate change-related topics that are prevalent in African policymaking circles and encourages students to also think about climate change critically through different disciplinary lenses. The primary objectives of this course are: (1) to introduce and help students understand African interests in climate change negotiations; (2) provide analytical tools and knowledge to help students understand different (and sometimes competing interests) of international players, especially global powers, in climate negotiations; and, (3) draw on different disciplines, such as economics, international relations, environmental science, and development studies, to provide students with a broad spectrum of knowledge that they can draw on to think critically about climate change and its impact on Africa''s development.', NULL, 'Attendance at lectures is compulsory except with the permission of the instructor.', '100% coursework.', NULL),

('GPP5008W', 'TOPICS IN AFRICAN ECONOMIC DEVELOPMENT', 10, 8, 'W', 'GPP', 'C Lopes', 'Honours degree or equivalent.', NULL, NULL, 'This course will help students navigate the challenges presented by an adverse global context and emerging megatrends when pursuing structural transformation. It will assess the opportunities offered by regional dimensions, modern-day industrialisation pitfalls and innovative sources of financing. Africa undoubtedly has great potential, so too is the size of the challenge that African leaders face as countries prepare to take their place in the future global economy. They must transform their economies in the context of a harsh global climate, where patterns of industrialisation have changed, characterised by an unfriendly trade environment, complex intellectual property rights, circumscribed policy space, and fractured internal structures. Case studies and in-depth analysis of uneven efforts at structural transformation will help illustrate the complexity of policy making.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department.', '100% Coursework.', NULL),

('GPP5009W', 'RESEARCH DESIGN AND PROPOSAL DEVELOPMENT', 15, 9, 'W', 'GPP', 'M Nxele and R Govender', 'Honours degree or equivalent.', NULL, NULL, 'The course is designed to equip students to carry out successful research for their research project. It builds on the previous courses focussing on research design and methodology for qualitative, quantitative and mixed methods research. This course will emphasize the development of the topic and research question to structure the design, execution and completion of research project. The course will also cover issues of ethics, research reporting and academic writing, and plagiarism. Teaching during the course will be through seminars, workshops and individual supervision, working towards the submission of a completed research proposal.', NULL, 'Attendance at all seminars and workshops.', 'Submission of proposal of 3 500 words or less.', NULL),

('GPP5010W', 'RESEARCH PROJECT', 45, 9, 'W', 'GPP', 'M Nxele', 'Honours degree or equivalent.', NULL, NULL, 'This is the final phase of the Masters programme, in which the participant submits a research project written up in the form of a long paper up to 15 000 words. The research project should demonstrate the participant''s ability to apply the material covered in the Masters programme to a concrete development problem. It is desirable, though not required, that the research project address a development problem linked to the participants'' work experience.', NULL, 'None', 'Final submission of Research Project 100%', NULL),

('GPP5011F', 'THE PRACTICE OF POLICY MAKING AND IMPLEMENTATION', 30, 9, 'F', 'GPP', 'M Nxele', 'Honours degree or equivalent.', NULL, NULL, 'The objectives of the course are to (a) provide an orienting framework for achieving better development results by aligning policy choices and approaches to implementation with political and institutional realities; and, (b) provide an opportunity to apply the framework in addressing concrete development challenges of direct relevance to the participants'' country contexts. The course will argue that reforms need to be compatible with the incentives of a critical mass of influential actors, so that they have a stake in the reforms and are willing to champion them in the face of opposition from those who benefit from the pre-existing arrangements. The aim is to identify entry points through which to nudge things along, seeking incremental gains that can give rise to a cascading sequence of change for the better. The course thus aims to encourage the exploration of possibilities that respond creatively to the governance ambiguities of our early twenty-first century.', NULL, 'Attendance at all sessions, and submission of all assignments', 'Coursework 100%', NULL),

('GPP5011S', 'THE PRACTICE OF POLICY MAKING AND IMPLEMENTATION', 30, 9, 'S', 'GPP', 'M Nxele', 'Honours degree or equivalent.', NULL, NULL, 'The objectives of the course are to (a) provide an orienting framework for achieving better development results by aligning policy choices and approaches to implementation with political and institutional realities; and, (b) provide an opportunity to apply the framework in addressing concrete development challenges of direct relevance to the participants'' country contexts. The course will argue that reforms need to be compatible with the incentives of a critical mass of influential actors, so that they have a stake in the reforms and are willing to champion them in the face of opposition from those who benefit from the pre-existing arrangements. The aim is to identify entry points through which to nudge things along, seeking incremental gains that can give rise to a cascading sequence of change for the better. The course thus aims to encourage the exploration of possibilities that respond creatively to the governance ambiguities of our early twenty-first century.', NULL, 'Attendance at all sessions, and submission of all assignments', 'Coursework 100%', NULL),

('GPP5012W', 'LEADERSHIP IN PUBLIC GOVERNANCE', 26, 9, 'W', 'GPP', 'S Haricharan and M Camerer', 'An NQF level 8 qualification in any discipline.', NULL, NULL, 'The public service can be a turbulent and complex space demanding high levels of emotional intelligence, resilience and critical judgment, i.e. discretion. Public managers operate in a world of volatility, uncertainty, complexity, and ambiguity (VUCA) that challenge and frustrate them in developing and implementing public policy. In this transforming landscape, as illustrated by the COVID-19 pandemic, public leaders are expected to lead in adaptable, innovative and compassionate ways. The immersive and interactive course places emphasis on theory and practice related to emotional and social intelligence, neuro-leadership, integral theory, and mindfulness. Participants are supported to heighten their self- and social awareness towards achieving their personal growth plan, and directing their personal agency toward orchestrating change for public good. A key component of the course draws on case studies to explore ethical leadership and public accountability, in particular, ethical awareness, ethical blindness and ethical decision-making, including whistleblowing. The emerging theoretical focus on the interaction between individual and institutional integrity, is examined in the light of a critical evaluation of current international efforts to counter corruption.', NULL, 'Attendance at lectures is compulsory; except with the permission of the convener.', '20% class participation, 80% Coursework. Submission of all assignments.', NULL),

('GPP5013S', 'TOPICS IN AFRICAN ECONOMIC TRANSFORMATION', 20, 9, 'S', 'GPP', 'C Lopes', 'An NQF level 8 qualification in any discipline.', NULL, NULL, 'This course will help students navigate the challenges presented by an adverse global context and emerging megatrends when pursuing structural transformation. It will assess the opportunities offered by regional dimensions, modern-day industrialisation pitfalls and innovative sources of financing. Africa undoubtedly has great potential, so too is the size of the challenge that African leaders face as countries prepare to take their place in the future global economy. They must transform their economies in the context of a harsh global climate, where patterns of industrialisation have changed, characterised by an unfriendly trade environment, complex intellectual property rights, circumscribed policy space, and fractured internal structures. Case studies and in-depth analysis of uneven efforts at structural transformation will help illustrate the complexity of policy making.', NULL, 'Attendance at lectures is compulsory except with the permission of the convener', '50% class participation, 50% Assignments. Submission of all assignments.', NULL),

('GPP5014S', 'INTERNATIONAL TRADE NEGOTIATIONS AND GLOBAL GOVERNANCE', 20, 9, 'S', 'GPP', 'F Ismail', 'An NQF level 8 qualification in any discipline', NULL, NULL, 'The course aims to provide students with the capacity to critically examine and evaluate the trade policies of South Africa and the African continent. It will enable students to engage and participate in trade strategy formulation and negotiations at a bilateral, regional or multilateral level. Students acquire skills to advise governments, business organisations and regional and multilateral agencies on trade policies and trade diplomacy. The course provides students with an overview of the changing architecture of the global trading system and the role of Africa in global governance. The course provides students with the theoretical and practical tools to evaluate the unfolding regional integration process underway in Africa, with a focus on the African Continental Free Trade Area (AfCFTA) negotiations. South Africa''s role in the continent will be critically examined with a view to exploring how South Africa can play a developmental role that supports development integration. Africa''s trade relationships bilaterally with its main trading partners in the North (the EU and US) and the South (China and other developing countries) will be explored and analysed with the use of case studies and simulations. Africa''s role in the multilateral trading system is critically examined. The history and role of developing countries in the GATT/WTO will be critically discussed. A simulation of the negotiations on reform of the WTO will be undertaken to highlight the different perspectives between developing and developed countries.', NULL, 'Attendance at lectures is compulsory except with the permission of the Head of Department. Students are required to write all tests; and to hand in all necessary individual assessments or reports.', 'Final Examination: 50%, Test: 25%, Assignment: 25%', NULL),

('GPP5016H', 'RESEARCH DESIGN AND QUALITATIVE METHODS', 10, 9, 'H', 'GPP', 'R Govender and D Rule', 'An NQF level 8 qualification in any discipline.', NULL, NULL, 'The course will provide students with the foundational knowledge, skills and orientation to help them prepare for their thesis proposals and thesis research activity and writing. This course introduces students to the fundamental concepts and principles of research design and methods for application in their thesis research. It begins with an introduction to the philosophies of contemporary research paradigms and proceeds to learning the key methods of data collection, analysis and writing of qualitative research. Also included is a focus on ethics and values in research, and issues related to conducting research in institutional contexts.', NULL, 'Class attendance and participation grade.', '100% Coursework', NULL),

('GPP6000W', 'THESIS IN DEVELOPMENT POLICY AND PRACTICE', 360, 10, 'W', 'GPP', 'R Govender', 'Acceptance to a PhD programme', NULL, NULL, 'This is a research degree on an advanced topic under supervision.', NULL, 'None', '100% Thesis', NULL),

-- COMMERCIAL LAW COURSES (CML)
('CML4004S', 'LABOUR LAW', 18, 8, 'S', 'CML', 'Professor R Le Roux', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'The aims of this course are to develop an understanding of the purpose and function of labour law and the industrial legislation framework, and to examine and analyse the role of the common law; basic conditions of employment; unfair dismissal; the institutions of collective bargaining and participative decision-making, statutory and non-statutory dispute resolution as well as discrimination and equity in employment.', NULL, 'Completion of all work required of the class and attendance at all tutorials.', 'Coursework 40% November examination 60%', 'Final Level course, half course, second semester'),

('CML4006W', 'COMMERCIAL TRANSACTIONS LAW', 36, 8, 'W', 'CML', 'B Zungu', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, 'The course covers principles of the law of agency, sale, lease, credit agreements, insurance, secured transactions and insolvency. Aspects of consumer protection, financial inclusion, and financial technology will also be covered.', 'Assessment: One compulsory class test in June, 30%; One optional written assignment, 20%; One November examination, 50% or 70%. The material tested in June will not be examined directly in the final examination but students will be expected to be familiar with that material for the final examination. If a student elects to do the assignment option, the proportion of that student''s examination mark to the overall final mark for the course will be adjusted accordingly. Refer to the course outline distributed at the beginning of the year for further details.', NULL, 'None', 'Coursework 30% or 50% Final Examination 70% or 50%', 'Final Level, whole year course, six small group teaching sessions and 72 lectures. Refer to the Final Level Year Plan distributed at registration for details regarding the small group teaching dates.'),

('CML4501F', 'DISPUTE RESOLUTION', 9, 8, 'F', 'CML', '*M Carels', 'All Preliminary and Intermediate Level courses to have been completed. The course is limited to 24 students; application (with motivation) to do the course must be directed to Monique Carels by 31 October.', NULL, NULL, 'The nature and path of conflict; approaches to managing conflict; positional and interest-based negotiation; defining the process of mediation; the stages of mediation; specialised forms of mediation; comparing adjudication and mediation, arbitration: the forms of arbitration and the defining characteristics and dispute system design.', NULL, 'None', 'Reflective journal: 25%, Class test: 25%, May/June examination: 50%', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week.'),

('CML4502F', 'INSURANCE LAW', 9, 8, 'F', 'CML', 'S Mesthrie', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'This course will serve as a complement to the discussion on insurance in Commercial Transactions Law (CML4006W), for those with a deeper interest in the subject. Both capital and indemnity insurance will be discussed. The course seminars will focus on specific topics (which may vary from year to year) and will provide deeper context and detail on South African insurance law than there is time for in Commercial Transactions Law.', NULL, 'Satisfactory attendance at and participation in lectures.', 'Coursework 3000 word assignment (compulsory) 30%; Presentation on a topic of choice (voluntary) 20%; June examination 50% (if presentation) 70% (if no presentation).', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week.'),

('CML4503F', 'COPYRIGHT & PATENTS', 9, 8, 'F', 'CML', 'Associate Professor L-A Tong', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'This course provides an introduction to two of the main intellectual property rights, namely copyright and patents. This is done primarily from a South African perspective. In addition to covering the principles of copyright and patent law, the course provides an opportunity for students to explore topical issues related to these intellectual property rights. The effect of intellectual property rights on access to medicines and educational materials, and the protection of traditional knowledge, are examples of such issues. Students are encouraged to also register for CML4504S Trade Marks & Unlawful Competition in order to gain a more comprehensive exposure to intellectual property law.', NULL, 'None', 'Coursework: 40%, 60% capstone assignment/examination', 'Final Level, half course, first semester, two lectures per week.'),

('CML4504S', 'TRADE MARKS & UNLAWFUL COMPETITION', 9, 8, 'S', 'CML', 'Associate Professor L-A Tong', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'This course provides an introduction to two of the key pillars in intellectual property law, namely trade marks and unlawful competition. It covers the principles of statutory trade mark law and explores various manifestations of unlawful competition, including passing off and the protection of confidential information. It also provides an opportunity for students to explore related topical issues, such as geographical indications, advertising, and domain names. Students are encouraged to also register for CML4503F Copyright & Patents in order to gain a more comprehensive exposure to intellectual property law.', NULL, 'None', 'Coursework: 40%, 60% capstone assignment/examination.', '(not offered in 2025) Final Level, half course, second semester, two lectures per week.'),

('CML4505F', 'INTERNATIONAL TRADE AND MARITIME LAW', 9, 8, 'F', 'CML', 'TBA', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'Part 1: International Trade Law (the business of carriage of goods by sea, incoterms, payment in international law; tender of shipping documents). Part 2: Maritime Law (ship registration, admiralty jurisdiction, carriage of goods by sea, charterparties, pollution, salvage and wreck, marine insurance).', NULL, 'None', 'Coursework 40%, June examination 60%', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week.'),

('CML4506F', 'FUNDAMENTAL PRINCIPLES OF TAX LAW', 9, 8, 'F', 'CML', 'Associate Professor A Titus', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'Every area of the law affects understanding and practical application of tax law. The study of tax law is therefore introduced in the final stage of the LLB curriculum. Taxation is complex because it overlays all fields of the law, draws on other disciplines, transcends national borders, affects every commercial transaction and often influences societal behaviours. This course introduces the subject of tax law. It seeks to illustrate the interrelation of tax law with other fields of law by focussing on primary themes and structural challenges faced by a tax system. In much of the coursework, the emphasis will be on the South African income tax. A selection of fundamental features of the South African income tax will be considered, mainly through critical evaluation of case law. Key jurisdictional concepts comprising the source and residence basis of income taxation will be considered. The course will analyse the statutory and jurisprudential frameworks for the determination of taxable income, including the notion of income, the distinction between capital and revenue receipts and the deductibility of expenditure and losses. At the end of this course students are expected to be able to start to identify the broader relevance and impact of tax law', NULL, 'None', 'Coursework: 20% (optional), Examination: 80%', 'Final Level, half course, first semester, two lectures per week.'),

('CML4507S', 'STATUTORY TAX LAW OF ENTITIES AND TRANSACTIONS', 9, 8, 'S', 'CML', 'B Cronin', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'This course builds on Fundamental Principles of Tax Law as a further introductory course for law undergraduates on the subject of tax law. The focus of the course is on legislation as the primary source of tax law. In much of the coursework, the emphasis will be on the South African income tax legislation. Because the focus is on legislation, the course is introduced by a recapitulation of the legal framework for statutory construction. Throughout the course, the emphasis will be on development of the competencies required to use revenue legislation in a responsible manner. A selection of features of the South African Income Tax Act, 58 of 1962, will be considered. The relevant provisions are categorised into those dealing with the main tenants of the taxation of individuals, companies and other vehicles such as trusts and partnerships. Selected issues affecting the taxation of corporate income will be considered. In addition, the legislation imposing tax on capital gains will be dealt with, in overview. The course is concluded by a consideration of the various common law and statutory measures that address tax evasion and tax avoidance. Brief consideration will be given to common legitimate tax planning techniques.', NULL, 'None', 'Coursework 20%; Examination 80%', 'Final Level, half course, second semester, two lectures per week'),

('CML4508S', 'TRUSTS AND ESTATE PLANNING', 9, 8, 'S', 'CML', 'TBC', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'The primary objective of this course is to outline aspects of the law relevant to the use of trusts in estate planning. More specifically the course covers the law of trusts, the income tax implications of using trusts, the calculation of estate duty and the standard estate plans using trusts.', NULL, 'None', 'Coursework 20% (optional), Examination 80%/100%', '(Not offered in 2025) Final Level, half course, second semester, two lectures per week.'),

('CML4509S', 'WAYS OF DOING BUSINESS', 9, 8, 'S', 'CML', 'TBC', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'This course provides a comparative and critical overview of the legal nature, regulation, relative advantages and disadvantages, and ideological and theoretical bases of a number of different legal forms and models that are used for the carrying on of commercial activities and in structuring commercial relationships, with an emphasis on those that fall outside the compulsory LLB course curriculum. The particular forms and models that will be considered each year will vary in accordance with current legal and commercial trends and are likely to include partnerships, joint ventures, companies, franchising, licensing and distribution agreements, co-operatives and trusts.', NULL, 'None', 'Coursework 20%, November examination 80%', '(Not offered in 2025) Final Level, half course, second semester, two lectures per week.'),

('CML4510F', 'CYBERLAW', 9, 8, 'F', 'CML', 'Associate Professor T Schönwetter', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'Given the ubiquitous nature of digital technologies, and the complex legal issues that these technologies raise, it is imperative that the next generation of legal practitioners and scholars is properly prepared for these new realities. This course affects numerous areas of law and addresses the key legal issues related to digital technologies, including: electronic contracting, electronic evidence, cybercrime, data protection, consumer protection online, e-commerce & tax, electronic communications, IP in the digital realm, the liability of internet service providers, and the right to freedom of expression online. While emphasis is on South African law, the multi-jurisdictional dimension of the Internet digital technologies, especially the internet, requires that some attention is paid to other jurisdictions. One important element of this course is to identify and examine issues that are of particular relevance for South Africans, such as mobile technology for accessing the Internet and the use of domestic digital services (such ''mobile money''); access to information; the digital divide between those who have access to digital technology and those who don''t; and developments in the area of cyberlaw in other African countries. The course includes some computer skills instructions for technology tools that are available to lawyers and legal researchers.', NULL, 'None', 'Coursework 40%, Examination 60%.', 'Final Level, half course, first semester, two lectures per week.'),

('CML4601F', 'THEORY AND PRACTICE OF COMMERCIAL REGULATION AND GOVERNANCE', 9, 8, 'F', 'CML', 'TBC', NULL, NULL, NULL, 'The regulation of commercial activities is seen as a necessary measure to manage risk and mediate the conflicting interests of parties. Increasingly however, formalistic legal (or state) regulation of commercial activities is under pressure to give way to ''softer'' forms of governance. This course in regulation and governance introduces students to (i) basic economic perspectives on regulation and governance and global trends in this regard; (ii) basic sociological perspectives on the regulation of commercial activities; which will provide students with an understanding of various regulatory models – from the traditional command-and-control to more reflexive/responsive models – and will equip students with the tools to critique the contemporary regulatory regime and its impact on commercial activity.', NULL, 'None', 'Participation in class 20%, Research paper (5000 words) 80%', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week.'),

('CML4602S', 'COMPETITION LAW', 9, 8, 'S', 'CML', 'TBA and Judge D M Davis', 'All Preliminary and Intermediate Level courses to have been completed.', 'This course requires a large measure of student participation. Class attendance is compulsory. Class participation takes the form of both group-work and individual presentations.', NULL, 'In this course we examine the regulation of competition under the ''new'' Competition Act 89 of 1998. The focus of the course is on the statutory regulation of competition and the underlying policy considerations which the Act aims to address. In particular, we examine the practices that firms are prohibited from engaging in under the Act, and the way in which the Act regulates the merger of firms. The content of the Act has been heavily influenced by European and American Antitrust Law and practice. Since the South African competition authorities have not yet had an opportunity to develop an extensive jurisprudence of their own, we look to comparative sources for guidance as to how the Act might come to be interpreted and applied.', NULL, 'None', 'Research 80% and Test 20%', 'Final Level, half course, second semester, two lectures per week.'),

('CML4603S', 'BANKING LAW', 9, 8, 'S', 'CML', 'S Mesthrie', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'In the first half of the course students are introduced to the private law aspect of banking. The course will examine the concepts of money and payments by exploring both the traditional forms of payments to modern methods such as digital finance. The course also examines African banking concepts such as stokvels and credit-rotating associations, and critically analyse the greater need for financial inclusion in South Africa. In this section students are introduced to the different roles of banks including banks as intermediaries, banks as guarantors, and banks as lenders (domestically and in the international financial markets). This sections also focuses on the bank-customer relationship and bank liability arising out of contract, delict or enrichment. The second half of the course examines the regulation of the banking and finance sector by exploring key legislation such as the Banks Act, the Financial Advisory and Intermediary Services Act, the Financial Markets Act amongst many others. In this section students will be introduced to key theoretical concepts such as systemic risk. This part of the module will also examine South Africa''s reform of the banking and finance sector towards Twin Peaks with focus on what is twin peaks and why is there a global trend towards twin peaks.', NULL, 'None', 'Research Paper (5000 words) 100%', 'Final level, half course, second semester.'),

('CML4604F', 'CURRENT DEVELOPMENTS IN COMPANY LAW', 9, 8, 'F', 'CML', '* Dr T Thabane', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'The Companies Act 71 of 2008 introduced major developments that modernised company law, aligned it with the constitution, and rendered it responsive to business needs and global trends. Over the years, the Act has been tested by rapid developments in business and the economy at large. Case law and academic commentary show that the various aspects of the Act require clarification, amendment, or realignment. The aims of this course are to critically explore the changes that will be ushered by amendment Bills to the Companies Act 71 of 2008; analyse recent case law; engage with academic commentary on new developments and expose students to research and writing techniques that will enable them to produce research papers that address current developments in company law.', NULL, 'None', 'Research paper (5000 words) 100%', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week.'),

('CML4605F', 'LAW, DEVELOPMENT, LABOUR AND SOCIAL POLICY', 9, 8, 'F', 'CML', 'TBC', 'All Preliminary and Intermediate Level courses to have been completed.', NULL, NULL, 'The aim of this course is to introduce students to selected debates around the role of law in development, specifically in the context of labour market regulation in the era of globalisation. Topics may include developments in case law, social security principles and implementation, statutory and extra-legal social dialogue arrangements, the harmonisation of labour standards and social policy in Southern Africa, workplace discrimination, affirmative action, freedom of association, HIV/AIDS in the workplace, dispute prevention and resolution, and health and safety.', NULL, 'None', 'Participation in class 20%, Research paper (5000 words) 80%', '(Not offered in 2025) Final Level, half course, first semester, two lectures per week. This course is limited to 15 students.'),

('CML4629S', 'LAW AND REGIONAL INTEGRATION IN AFRICA', 9, 8, 'S', 'CML', 'Professor A Ordor', 'None', 'None', NULL, 'This course provides a forum for students to study the ways in which the law has been utilised to shape and direct regional integration processes in Africa. The course starts with a discussion of theories of regional integration, followed by an overview of the historical trajectory of integration on the continent, with a focus on development integration. Its comparative dimension is directed at identifying and analysing strengths, weaknesses and challenges reflected in various regional efforts at integration on the continent, including the AU, SADC, EAC, ECOWAS, AMU, the Tripartite Free Trade Area (TFTA) as well as the proposed African Continental Free Trade Area (AfCFTA). Furthermore, the role of regional institutions such as regional courts is discussed, along with relevant cases. Current regional integration issues worldwide constitute a vital context for class discussions. The course is delivered through a series of weekly seminars, with occasional guest lectures. Students'' participation is essential and various avenues created for this purpose include group discussions, in-class review of literature, student presentations and simulation of a multilateral negotiation session. Students are expected to develop their presentations into a research paper under the supervision of the course conveners.', NULL, 'None', 'Coursework 20%; final research paper 80%', NULL)

ON CONFLICT (course_code) DO UPDATE SET
    course_name = EXCLUDED.course_name,
    nqf_credits = EXCLUDED.nqf_credits,
    nqf_level = EXCLUDED.nqf_level,
    semester_id = EXCLUDED.semester_id,
    department_id = EXCLUDED.department_id,
    convener = EXCLUDED.convener,
    course_entry_requirements = EXCLUDED.course_entry_requirements,
    corequisites = EXCLUDED.corequisites,
    objective = EXCLUDED.objective,
    course_outline = EXCLUDED.course_outline,
    lecture_times = EXCLUDED.lecture_times,
    dp_requirements = EXCLUDED.dp_requirements,
    assessment = EXCLUDED.assessment,
    notes = EXCLUDED.notes;