(function ($) {
  "use strict";

  console.log("Jazzmin custom main.js loaded!");

  function setCookie(key, value) {
    const expires = new Date();
    expires.setTime(expires.getTime() + value * 24 * 60 * 60 * 1000);
    document.cookie =
      key +
      "=" +
      value +
      ";expires=" +
      expires.toUTCString() +
      "; SameSite=Strict;path=/";
  }

  function getCookie(key) {
    const keyValue = document.cookie.match("(^|;) ?" + key + "=([^;]*)(;|$)");
    return keyValue ? keyValue[2] : null;
  }

  function handleMenu() {
    // Force sidebar to stay open - disable menu toggle functionality
    $("[data-widget=pushmenu]").bind("click", function (e) {
      e.preventDefault();
      e.stopPropagation();
      // Always keep menu open
      setCookie("jazzy_menu", "open");
      $("body").removeClass("sidebar-collapse");
      return false;
    });

    // Ensure sidebar stays open on page load
    setCookie("jazzy_menu", "open");
    $("body").removeClass("sidebar-collapse");
  }

  function setActiveLinks() {
    /*
         Set the currently active menu item based on the current url, or failing that, find the parent
         item from the breadcrumbs
         */
    const url = window.location.pathname;
    const $breadcrumb = $(".breadcrumb a").last();
    const $link = $('a[href="' + url + '"]');
    const $parent_link = $('a[href="' + $breadcrumb.attr("href") + '"]');

    if ($link.length) {
      $link.addClass("active");
    } else if ($parent_link.length) {
      $parent_link.addClass("active");
    }

    const $a_active = $("a.nav-link.active");
    const $main_li_parent = $a_active.closest("li.nav-item.has-treeview");
    const $ul_child = $main_li_parent.children("ul");

    $ul_child.show();
    $main_li_parent.addClass("menu-is-opening menu-open");
  }

  $(document).ready(function () {
    // Force sidebar to stay open on page load
    $("body").removeClass("sidebar-collapse sidebar-mini");
    setCookie("jazzy_menu", "open");

    // Set active status on links
    setActiveLinks();

    // When we use the menu, store its state in a cookie to preserve it
    handleMenu();

    // Add minimal changelist styling to templates that we have been unable to override (e.g MPTT)
    // Needs to be here and not in change_list.js because this is the only JS we are guaranteed to run
    // (as its included in base.html)
    const $changeListTable = $("#changelist .results table");
    if (
      $changeListTable.length &&
      !$changeListTable.hasClass("table table-striped")
    ) {
      $changeListTable.addClass("table table-striped");
    }

    // Initialize custom delete functionality
    initCustomDeleteButton();
  });

  function initCustomDeleteButton() {
    console.log("Initializing custom delete button...");
    
    // Wait for DOM to be ready
    setTimeout(function() {
      // Check if we're on a changelist page
      const $changelist = $("#changelist, #changelist-form").first();
      console.log("Changelist found:", $changelist.length > 0);
      
      if (!$changelist.length) {
        console.log("No changelist found, skipping delete button init");
        return;
      }

      // Hide original action dropdown and button
      $(".actions select").hide();
      $(".actions input[type='submit']").hide();
      $(".actions .button").hide();

      // Create custom delete button with better positioning
      const deleteButtonHtml = `
        <button id="custom-delete-button" 
                type="button" 
                style="display:none; 
                       background-color: #dc3545; 
                       border: 1px solid #dc3545; 
                       color: white; 
                       padding: 8px 16px; 
                       border-radius: 4px; 
                       cursor: pointer; 
                       margin: 10px 0; 
                       font-size: 14px; 
                       font-weight: bold;
                       transition: background-color 0.3s;">
          <i class="fas fa-trash"></i> Delete Selected
        </button>
      `;

      // Find the best place to insert the button
      let $insertLocation = $(".actions");
      if (!$insertLocation.length) {
        // Create actions div if it doesn't exist
        $insertLocation = $('<div class="actions"></div>');
        $("#changelist-search").after($insertLocation);
      }
      
      // Add the button
      $insertLocation.append(deleteButtonHtml);
      console.log("Delete button added");

      // Update button function
      function updateDeleteButton() {
        const $checkboxes = $('#result_list tbody input[type="checkbox"]:checked, .results tbody input[type="checkbox"]:checked');
        const selectedCount = $checkboxes.length;
        const $deleteButton = $("#custom-delete-button");
        
        console.log("Selected count:", selectedCount);
        console.log("Checkboxes found:", $checkboxes.length);

        if (selectedCount > 0) {
          $deleteButton.show();
          $deleteButton.html(`<i class="fas fa-trash"></i> Delete ${selectedCount} Selected`);
          console.log("Delete button shown");
        } else {
          $deleteButton.hide();
          console.log("Delete button hidden");
        }
      }

      // Handle checkbox changes with more specific selectors
      $(document).off('change.customDelete').on('change.customDelete', '#result_list input[type="checkbox"], .results input[type="checkbox"]', function() {
        console.log("Checkbox changed:", this.checked);
        setTimeout(updateDeleteButton, 10); // Small delay to ensure state is updated
      });

      // Handle select all checkbox
      $(document).off('change.customDeleteAll').on('change.customDeleteAll', '#action-toggle', function() {
        console.log("Select all toggled:", this.checked);
        const isChecked = this.checked;
        $('#result_list tbody input[type="checkbox"], .results tbody input[type="checkbox"]').prop('checked', isChecked);
        setTimeout(updateDeleteButton, 10);
      });

      // Handle delete button click
      $(document).off('click.customDelete').on('click.customDelete', '#custom-delete-button', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const $selectedCheckboxes = $('#result_list tbody input[type="checkbox"]:checked, .results tbody input[type="checkbox"]:checked');
        const selectedCount = $selectedCheckboxes.length;
        
        console.log("Delete button clicked, selected count:", selectedCount);

        if (selectedCount === 0) {
          alert("Please select at least one record to delete.");
          return;
        }

        const confirmMessage = `Are you sure you want to delete ${selectedCount} selected record(s)? This action cannot be undone.`;

        if (confirm(confirmMessage)) {
          // Find the form - try multiple selectors
          let $form = $("#changelist-form");
          if (!$form.length) {
            $form = $("form").first();
          }
          
          console.log("Form found:", $form.length);
          
          if ($form.length) {
            // Remove any existing action inputs
            $form.find('input[name="action"]').remove();
            
            // Add the delete action
            $form.append('<input type="hidden" name="action" value="delete_selected">');
            
            // Submit the form
            console.log("Submitting form for deletion");
            $form.submit();
          } else {
            alert("Could not find the form to submit. Please try using the standard delete method.");
          }
        }
      });

      // Initial update
      setTimeout(updateDeleteButton, 100);
      
    }, 500); // Wait 500ms for page to fully load
  }
})(jQuery);
