-- Bachelor of Business Science specialising in Statistics and Data Sciences [CB004STA13]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004STA13', 'Statistics and Data Sciences', '* STA1006S is compulsory for students following the Mathematical Statistics option in the second and subsequent years. If students move from MAM1031F/MAM1032S to MAM1005H they will have to deregister from STA1006S and register for it concurrently with MAM1006H. **The STA4010W course starts two weeks before the undergraduate academic year. Candidates will be required to obtain at least a 65% average for their 3rd year Statistics courses at the first attempt in order to be accepted to STA4010W. *** MAM2010F and MAM2011F are compulsory courses. Students must choose 2 courses from MAM2012S, MAM2013S or MAM2014S');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'ACC1021F', NULL, 1, NULL),
('CB004STA13', 'ACC1022Z', NULL, 1, NULL),
('CB004STA13', 'BUS1036F', NULL, 1, NULL),
('CB004STA13', 'ECO1010F', NULL, 1, NULL),
('CB004STA13', 'CSC1015F', NULL, 1, NULL),
('CB004STA13', 'MAM1031F', NULL, 1, 'If moving to MAM1005H, deregister from STA1006S and register concurrently with MAM1006H'),
('CB004STA13', 'MAM1032S', NULL, 1, 'If moving to MAM1005H, deregister from STA1006S and register concurrently with MAM1006H'),
('CB004STA13', 'ECO1011S', NULL, 1, NULL),
('CB004STA13', 'CSC1016S', NULL, 1, NULL);

-- First Year Statistics Option (STA1000S OR STA1006S)
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', NULL, 1, 'Statistics foundation choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA1000S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 1, NULL),
('CB004STA13', 'STA1006S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 1, 'Required for Mathematical Statistics option in second and subsequent years');

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'ECO2003F', NULL, 2, NULL),
('CB004STA13', 'MAM2010F', NULL, 2, NULL),
('CB004STA13', 'MAM2011F', NULL, 2, NULL),
('CB004STA13', 'PHI2043S', NULL, 2, NULL),
('CB004STA13', 'BUS2010F', NULL, 2, NULL),
('CB004STA13', 'CML1004S', NULL, 2, NULL),
('CB004STA13', 'ECO2004S', NULL, 2, NULL);

-- Second Year Mathematics Option - Choose 2 from 3 courses
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', NULL, 2, 'Mathematics electives - 2 of 3');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'MAM2012S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004STA13', 'MAM2013S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004STA13', 'MAM2014S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Second Year Statistics Options
INSERT INTO degree_parent_course_group (degree_id, required_count, description) VALUES ('CB004STA13', 1, 'Statistics pathway choice');
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 2, 'Mathematical Statistics Option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA2004F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004STA13', 'STA2005S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 2, 'Applied Statistics Option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004STA13', 'STA2020S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004STA13', 'STA2030S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
-- Finance Option
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', NULL, 1, 'Finance option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'FTX2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'FTX2024S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Third Year Additional Core (AND separated courses - no group needed)
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'BUS2033S', NULL, 3, NULL),
('CB004STA13', 'BUS3039S', NULL, 3, NULL),
('CB004STA13', 'CSC2001F', NULL, 3, NULL);

-- Third Year Information Systems OR Economics Option
INSERT INTO degree_parent_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', NULL, 1, 'Third year pathway choice');
-- comsci pathway
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 1, 'Computer Science pathway');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'CSC2002S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);
-- INF pathway (requires all 3 courses)
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 3, 'Information Systems pathway');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'INF2006F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'INF2007F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'ECO3021S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Economics pathway (single course)
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 1, 'Economics pathway');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'ECO3021S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Third Year Statistics Core Option
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', NULL, 1, 'Statistics core choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA3022F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'STA3045F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Third Year Final Statistics Options
INSERT INTO degree_parent_course_group (degree_id, required_count, description) VALUES ('CB004STA13', 1, 'Third year statistics specialization');
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 2, 'Mathematical Statistics Option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA3041F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'STA3043S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB004STA13', (SELECT parent_group_id FROM degree_parent_course_group WHERE degree_id = 'CB004STA13' ORDER BY parent_group_id DESC LIMIT 1), 2, 'Applied Statistics Option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA3030F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004STA13', 'STA3036S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004STA13' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004STA13', 'STA4007W', NULL, 4, 'Starts two weeks before the undergraduate academic year. Requires 65% average in 3rd year Statistics courses for acceptance.'),
('CB004STA13', 'BUS4050H', NULL, 4, NULL);
