-- Bachelor of Business Science in Actuarial Science specialising in Quantitative Finance [CB003BUS09]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB003BUS09', 'Quantitative Finance', '* STA1006S is compulsory for students following the Mathematical Statistics option in the second and subsequent years. If students move from MAM1031F/MAM1032S to MAM1005H they will have to deregister from STA1006S and register for it concurrently with MAM1006H. ** MAM2010F and MAM2011F are compulsory courses. Students must choose 2 courses from MAM2012S, MAM2013S or MAM2014S.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'ACC1006F', NULL, 1, NULL),
('CB003BUS09', 'BUS1036F', NULL, 1, NULL),
('CB003BUS09', 'CSC1015F', NULL, 1, NULL),
('CB003BUS09', 'ECO1010F', NULL, 1, NULL),
('CB003BUS09', 'MAM1031F', NULL, 1, NULL),
('CB003BUS09', 'MAM1032S', NULL, 1, NULL),
('CB003BUS09', 'BUS1003H', NULL, 1, NULL),
('CB003BUS09', 'ACC1011S', NULL, 1, NULL),
('CB003BUS09', 'ECO1011S', NULL, 1, NULL),
('CB003BUS09', 'STA1006S', NULL, 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'CML1001F', NULL, 2, NULL),
('CB003BUS09', 'ECO2003F', NULL, 2, NULL),
('CB003BUS09', 'STA2004F', NULL, 2, NULL),
('CB003BUS09', 'MAM2010F', NULL, 2, NULL),
('CB003BUS09', 'MAM2011F', NULL, 2, NULL),
('CB003BUS09', 'BUS2016H', NULL, 2, NULL),
('CB003BUS09', 'ECO2004S', NULL, 2, NULL),
('CB003BUS09', 'FTX2024S', NULL, 2, NULL),
('CB003BUS09', 'STA2005S', NULL, 2, NULL);

-- Second Year Mathematics Option - Choose 2 from 3 courses
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB003BUS09', NULL, 2, 'Mathematics electives - 2 of 3');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'MAM2012S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS09' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB003BUS09', 'MAM2013S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS09' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB003BUS09', 'MAM2014S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS09' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'BUS3039F', NULL, 3, NULL),
('CB003BUS09', 'FTX3044F', NULL, 3, NULL),
('CB003BUS09', 'STA3041F', NULL, 3, NULL),
('CB003BUS09', 'STA3045F', NULL, 3, NULL),
('CB003BUS09', 'FTX3045S', NULL, 3, NULL),
('CB003BUS09', 'PHI2043S', NULL, 3, NULL),
('CB003BUS09', 'STA3047S', NULL, 3, NULL),
('CB003BUS09', 'STA3048S', NULL, 3, NULL);

-- Third Year Professional Communication Option (F/S split)
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB003BUS09', NULL, 1, 'Professional Communication semester choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'BUS2033F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS09' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB003BUS09', 'BUS2033S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS09' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS09', 'BUS4028F', NULL, 4, NULL),
('CB003BUS09', 'FTX4086F', NULL, 4, NULL),
('CB003BUS09', 'BUS4050H', NULL, 4, NULL),
('CB003BUS09', 'BUS4053H', NULL, 4, NULL),
('CB003BUS09', 'BUS4087S', NULL, 4, NULL),
('CB003BUS09', 'FTX4056S', NULL, 4, NULL);
