-- Bachelor of Business Science specialising in MARKETING [CB004BUS07]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004BUS07', 'Marketing', 'As a rule, at least a 65% average across all 3rd year Marketing courses establishes a right to be considered for a place in Marketing 4th year. Students who do not qualify for admission to the 4th year will be required to change their specialisation or degree in consultation with the Head of the School of Management Studies.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004BUS07', 'ACC1021F', 1, NULL),
('CB004BUS07', 'ACC1022Z', 1, NULL),
('CB004BUS07', 'BUS1036F', 1, NULL),
('CB004BUS07', 'ECO1010F', 1, NULL),
('CB004BUS07', 'INF1002F', 1, NULL),
('CB004BUS07', 'ACC1011S', 1, NULL),
('CB004BUS07', 'ECO1011S', 1, NULL),
('CB004BUS07', 'STA1000S', 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004BUS07', 'BUS2010F', 2, 'Can be taken in either semester'),
('CB004BUS07', 'BUS2033F', 2, 'Can be taken in either semester'),
('CB004BUS07', 'ECO2003F', 2, NULL),
('CB004BUS07', 'STA2020F', 2, 'Can be taken in either semester'),
('CB004BUS07', 'CML1004S', 2, NULL),
('CB004BUS07', 'ECO2007S', 2, NULL),
('CB004BUS07', 'ECO2004S', 2, NULL),
('CB004BUS07', 'PHI2043S', 2, NULL);

-- Second Year Finance Choice (FTX2020F OR FTX2024S)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004BUS07', 1, 'Finance choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004BUS07', 'FTX2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004BUS07', 'FTX2024S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004BUS07', 'BUS3039F', 3, NULL),
('CB004BUS07', 'BUS3041F', 3, NULL),
('CB004BUS07', 'ECO3020F', 3, NULL),
('CB004BUS07', 'STA3022F', 3, NULL),
('CB004BUS07', 'BUS3008W', 3, NULL),
('CB004BUS07', 'BUS3043S', 3, NULL);

-- Third Year Project Management Choice (BUS3038S OR approved 3000 level course)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004BUS07', 1, 'Project management choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004BUS07', 'BUS3038S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ELE3999X', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, 'Must get approval');

-- Third Year Economics Elective (choose 1)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004BUS07', 1, 'Third year economics elective');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004BUS07', 'ECO3009F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3016F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3021S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3022S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3023S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3024F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004BUS07', 'ECO3025S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004BUS07' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004BUS07', 'BUS4026W', 4, NULL),
('CB004BUS07', 'BUS4050H', 4, NULL),
('CB004BUS07', 'BUS4052H', 4, NULL),
('CB004BUS07', 'BUS4058F', 4, NULL);
