-- Bachelor of Business Science specialising in INFORMATION SYSTEMS [CB004INF01]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004INF01', 'Information Systems', 'Students who complete CSC1015F can complete CSC1016S in first year in substitution for INF1003F in second year. Unless otherwise agreed by the Head of Department, candidates will be expected to obtain an overall credit weighted average of 65% for their third year Information Systems major courses and at least 55% for each course to be considered for a place in the 4th year Information System courses. Places may be limited. Students who do not qualify for 4th year Information Systems courses will be required to change their specialisation or degree in consultation with the Head of Department. Students shall not repeat the following courses: INF4024W and INF4027W.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004INF01', 'ACC1021F', 1, NULL),
('CB004INF01', 'ACC1022Z', 1, NULL),
('CB004INF01', 'BUS1036F', 1, NULL),
('CB004INF01', 'ECO1010F', 1, NULL),
('CB004INF01', 'MAM1010F', 1, NULL),
('CB004INF01', 'ECO1011S', 1, NULL),
('CB004INF01', 'MAM1012S', 1, NULL),
('CB004INF01', 'STA1000S', 1, NULL);

-- First Year Programming Foundation Option (INF1002F OR CSC1015F)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004INF01', 1, 'Programming foundation choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004INF01', 'INF1002F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004INF01' ORDER BY course_group_id DESC LIMIT 1), 1, NULL),
('CB004INF01', 'CSC1015F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004INF01' ORDER BY course_group_id DESC LIMIT 1), 1, 'Can substitute INF1003F in second year with CSC1016S');

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004INF01', 'INF1003F', 2, 'Can be substituted with CSC1016S if CSC1015F taken in first year'),
('CB004INF01', 'INF2006F', 2, NULL),
('CB004INF01', 'INF2007F', 2, NULL),
('CB004INF01', 'INF2009F', 2, NULL),
('CB004INF01', 'FTX2020F', 2, NULL),
('CB004INF01', 'STA2020S', 2, NULL),
('CB004INF01', 'INF2010S', 2, NULL),
('CB004INF01', 'INF2011S', 2, NULL),
('CB004INF01', 'CML1004S', 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004INF01', 'BUS2010F', 3, NULL),
('CB004INF01', 'BUS3039F', 3, NULL),
('CB004INF01', 'INF3014F', 3, NULL),
('CB004INF01', 'INF3003W', 3, NULL),
('CB004INF01', 'BUS2033F', 3, NULL),
('CB004INF01', 'INF3012S', 3, NULL),
('CB004INF01', 'PHI2043S', 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004INF01', 'INF4026F', 4, NULL),
('CB004INF01', 'BUS4050H', 4, NULL),
('CB004INF01', 'INF4027W', 4, 'Cannot be repeated'),
('CB004INF01', 'INF4024W', 4, 'Cannot be repeated'),
('CB004INF01', 'INF4025S', 4, NULL);
