-- Bachelor of Business Science specialising in FINANCE with ACCOUNTING [CB004FTX04]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004FTX04', 'Finance with Accounting', '(i) This curriculum is designed to facilitate entry into the Accounting profession. After graduating, candidates may apply for admission to the Postgraduate Diploma in Accounting. Passing the diploma is a prerequisite for entry to the SAICA Initial Test of Competence. (ii) Students may replace Financial Reporting III (ACC3009W) with Financial Reporting & Analysis (ACC3020W), but this option will not meet the requirements for admission to the Postgraduate Diploma in Accounting. (iii) Candidates will be required to obtain at least a 60% average for their 3rd year finance courses in order to be accepted into FTX4000.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX04', 'ACC1006F', 1, NULL),
('CB004FTX04', 'ECO1010F', 1, NULL),
('CB004FTX04', 'INF1002F', 1, NULL),
('CB004FTX04', 'MAM1010F', 1, NULL),
('CB004FTX04', 'ACC1011S', 1, NULL),
('CB004FTX04', 'ACC1015S', 1, NULL),
('CB004FTX04', 'ECO1011S', 1, NULL),
('CB004FTX04', 'MAM1012S', 1, NULL),
('CB004FTX04', 'STA1000S', 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX04', 'ACC2023H', 2, NULL),
('CB004FTX04', 'BUS2010F', 2, NULL),
('CB004FTX04', 'CML1001F', 2, NULL),
('CB004FTX04', 'ECO2003F', 2, NULL),
('CB004FTX04', 'ACC2022H', 2, NULL),
('CB004FTX04', 'CML2010Z', 2, NULL),
('CB004FTX04', 'ECO2004S', 2, NULL),
('CB004FTX04', 'FTX2024S', 2, NULL),
('CB004FTX04', 'PHI2043S', 2, NULL);

-- Second Year Applied Statistics Option (F/S split)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004FTX04', 1, 'Applied Statistics semester choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004FTX04', 'STA2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX04' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004FTX04', 'STA2020S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX04' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX04', 'CML2001F', 3, NULL),
('CB004FTX04', 'FTX3044F', 3, NULL),
('CB004FTX04', 'INF2004F', 3, NULL),
('CB004FTX04', 'ACC2012W', 3, NULL),
('CB004FTX04', 'ACC2018H', 3, NULL),
('CB004FTX04', 'ACC3023W', 3, NULL),
('CB004FTX04', 'BUS3039S', 3, NULL),
('CB004FTX04', 'FTX3045S', 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX04', 'FTX4057F', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX04', 'BUS4050H', 4, NULL),
('CB004FTX04', 'ACC3004W', 4, NULL),
('CB004FTX04', 'ACC3022W', 4, NULL),
('CB004FTX04', 'FTX4087S', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX04', 'FTX4056S', 4, 'Requires 60% average in 3rd year finance courses');

-- Fourth Year Financial Reporting Option
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004FTX04', 1, 'Financial Reporting option');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004FTX04', 'ACC3009W', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX04' ORDER BY course_group_id DESC LIMIT 1), 4, 'Required for Postgraduate Diploma in Accounting admission'),
('CB004FTX04', 'ACC3020W', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX04' ORDER BY course_group_id DESC LIMIT 1), 4, 'Does not meet requirements for Postgraduate Diploma in Accounting');
