-- Bachelor of Business Science specialising in Finance, Investment and Banking [CB004FTX05]

-- Insert wildcard courses for electives (if they don't exist)
INSERT INTO course (course_code, course_name, nqf_credits, nqf_level) 
SELECT 'ECO3999X', 'ECONOMICS NQF LEVEL 7 (3RD YEAR) ELECTIVE', 18, 7
WHERE NOT EXISTS (SELECT 1 FROM course WHERE course_code = 'ECO3999X');

-- Insert Topics courses (if they don't exist)
INSERT INTO course (course_code, course_name, nqf_credits, nqf_level) 
SELECT 'FTX4087S', 'TOPICS IN BANKING AND TREASURY MANAGEMENT', 18, 8
WHERE NOT EXISTS (SELECT 1 FROM course WHERE course_code = 'FTX4087S');

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004FTX05', 'Finance, Investment and Banking', 'Candidates will be required to obtain at least a 60% average for their 3rd year finance courses in order to be accepted into FTX4000 level courses.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX05', 'ACC1021F', 1, NULL),
('CB004FTX05', 'ACC1022Z', 1, NULL),
('CB004FTX05', 'ECO1010F', 1, NULL),
('CB004FTX05', 'INF1002F', 1, NULL),
('CB004FTX05', 'MAM1010F', 1, NULL),
('CB004FTX05', 'BUS1036S', 1, NULL),
('CB004FTX05', 'ECO1011S', 1, NULL),
('CB004FTX05', 'MAM1012S', 1, NULL),
('CB004FTX05', 'STA1000S', 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX05', 'BUS2010F', 2, NULL),
('CB004FTX05', 'CML1001F', 2, NULL),
('CB004FTX05', 'ECO2003F', 2, NULL),
('CB004FTX05', 'ACC2022H', 2, NULL),
('CB004FTX05', 'ECO2007S', 2, NULL),
('CB004FTX05', 'ECO2004S', 2, NULL),
('CB004FTX05', 'FTX2024S', 2, NULL),
('CB004FTX05', 'PHI2043S', 2, NULL);

-- Second Year Applied Statistics Option (F/S split)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004FTX05', 1, 'Applied Statistics semester choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004FTX05', 'STA2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX05' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004FTX05', 'STA2020S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX05' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX05', 'ECO3020F', 3, NULL),
('CB004FTX05', 'FTX3044F', 3, NULL),
('CB004FTX05', 'STA3022F', 3, NULL),
('CB004FTX05', 'BUS3039S', 3, NULL),
('CB004FTX05', 'ECO3021S', 3, NULL),
('CB004FTX05', 'FTX3045S', 3, NULL);

-- Third Year Approved ECO Course (elective)
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX05', 'ECO3999X', 3, 'Must be approved');

-- Third Year Professional Communication Option (F/S split)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004FTX05', 1, 'Professional Communication semester choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004FTX05', 'BUS2033F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX05' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004FTX05', 'BUS2033S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004FTX05' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004FTX05', 'FTX4057F', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX05', 'FTX4086F', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX05', 'BUS4050H', 4, NULL),
('CB004FTX05', 'FTX4051H', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX05', 'FTX4056S', 4, 'Requires 60% average in 3rd year finance courses'),
('CB004FTX05', 'FTX4087S', 4, 'Requires 60% average in 3rd year finance courses');
