-- Bachelor of Business Science specialising in ECONOMICS with LAW [CB004ECO03]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004ECO03', 'Economics with Law', 'See "Entrance to the Legal Profession" elsewhere in this Handbook. Places on the Law Courses in the 2nd and 3rd year are limited. To be eligible for consideration for a possible (but not guaranteed) place, students wishing to apply to take Law courses in 2nd and 3rd year need to fulfil all the requirements set out in Promotion Rule for Law degrees. As a rule, a 65% average for 3rd year Economics courses and at least 60% for ECO3020F, ECO3021S and another 3rd year level economics establishes the right to be considered for a place in the Economics 4th year class. Students who obtain less than 40% for ECO4112F will not be allowed to continue with the programme. Students who do not qualify for admission to the 4th year Economics courses or who have obtained less than 40% in ECO4112F will be required to change their specialisation or degree in consultation with the Head of Department. CB004 readmission rules apply to CB024, however if you fail 2 courses in the first semester of the first year, your registration will be changed to the extended version (CB015ECO03). The pre-requisites for registering for the PVL courses are receipt of confirmation of place on those courses and fulfilment of all the requirements set out in Promotion Rule.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO03', 'ACC1021F', 1, NULL),
('CB004ECO03', 'ACC1022Z', 1, NULL),
('CB004ECO03', 'ECO1010F', 1, NULL),
('CB004ECO03', 'INF1002F', 1, NULL),
('CB004ECO03', 'MAM1010F', 1, NULL),
('CB004ECO03', 'ECO1011S', 1, NULL),
('CB004ECO03', 'MAM1012S', 1, NULL),
('CB004ECO03', 'STA1000S', 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO03', 'ECO2003F', 2, NULL),
('CB004ECO03', 'STA2020F', 2, NULL),
('CB004ECO03', 'PVL1003W', 2, 'Places on Law courses are limited'),
('CB004ECO03', 'PVL1004F', 2, 'Places on Law courses are limited'),
('CB004ECO03', 'PVL1008H', 2, 'Places on Law courses are limited'),
('CB004ECO03', 'ECO2004S', 2, NULL),
('CB004ECO03', 'ECO2007S', 2, NULL);

-- Second Year Finance Choice (FTX2020F OR FTX2024S)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO03', 1, 'Finance choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO03', 'FTX2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004ECO03', 'FTX2024S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO03', 'BUS3039F', 3, NULL),
('CB004ECO03', 'ECO3020F', 3, NULL),
('CB004ECO03', 'PBL2000W', 3, NULL),
('CB004ECO03', 'PVL2002H', 3, NULL),
('CB004ECO03', 'PVL2003H', 3, NULL),
('CB004ECO03', 'ECO3021S', 3, NULL),
('CB004ECO03', 'PHI2043S', 3, NULL);

-- Third Year Economics Elective (1 ECO 3000 level course)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO03', 1, 'Third year economics elective');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO03', 'ECO3999X', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 3, 'Choose 1 other ECO 3000 level course');

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO03', 'BUS4050H', 4, NULL),
('CB004ECO03', 'BUS2010S', 4, NULL),
('CB004ECO03', 'ECO4006F', 4, NULL),
('CB004ECO03', 'ECO4007F', 4, NULL),
('CB004ECO03', 'ECO4016F', 4, NULL),
('CB004ECO03', 'ECO4112F', 4, 'Students who obtain less than 40% will not be allowed to continue'),
('CB004ECO03', 'ECO4021W', 4, NULL);

-- Fourth Year Electives (choose 2 options)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO03', 2, 'Fourth year electives');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO03', 'ECO4013S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4020S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4026S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4027S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4028S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4029S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4032S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4051S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4052S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4053S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4113S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4114S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4131S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4132S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO03', 'ECO4200S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO03' ORDER BY course_group_id DESC LIMIT 1), 4, NULL);
