-- Bachelor of Business Science specialising in ECONOMICS [CB004ECO01]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004ECO01', 'Economics', '*Students wishing to register for MAM2000W after completing MAM1010F/S and MAM1012F/S must obtain permission from the convener of MAM2000W. See the MAM2000W handbook entry for further details. **Students who take STA3022 cannot take STA3000 level courses and must, therefore, take FTX2024. *** Students have an option to choose three electives. As a rule, a 65% average for 3rd year Economics courses and at least 60% for ECO3020F, ECO3021S and another 3rd year level economics establishes the right to be considered for a place in the Economics 4th year class. Students who obtain less than 50% for ECO4112F will not be allowed to continue with the programme. Students who do not qualify for admission to the 4th year Economics courses or who have obtained less than 50% in ECO4112F will be required to change their specialisation or degree in consultation with the Head of Department. Subject to the approval of the Graduate Convener, students may substitute a maximum of one of the options with an NQF level 8 course of a similar credit value offered in another department. Students’ may carry one semester course to the honours year (only F or S. Students will not be allowed to carry any H or W courses).');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO01', 'ACC1021F', 1, NULL),
('CB004ECO01', 'ACC1022Z', 1, NULL),
('CB004ECO01', 'ECO1010F', 1, NULL),
('CB004ECO01', 'INF1002F', 1, NULL),
('CB004ECO01', 'MAM1010F', 1, NULL),
('CB004ECO01', 'ECO1011S', 1, NULL),
('CB004ECO01', 'MAM1012S', 1, NULL),
('CB004ECO01', 'STA1000S', 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO01', 'CML1001F', 2, NULL),
('CB004ECO01', 'ECO2003F', 2, NULL),
('CB004ECO01', 'STA2020F', 2, NULL),
('CB004ECO01', 'BUS2010S', 2, NULL),
('CB004ECO01', 'ECO2004S', 2, NULL),
('CB004ECO01', 'ECO2007S', 2, NULL);

-- Second Year Finance Choice (FTX2020F OR FTX2024F)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO01', 1, 'Finance choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'FTX2020F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004ECO01', 'FTX2024F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 2, 'Required if taking STA3022F');

-- Second Year Statistics Choice (STA2030S OR STA3022F)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO01', 1, 'Statistics choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'STA2030S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB004ECO01', 'STA3022F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 2, 'Students who take STA3022 cannot take STA3000 level courses and must take FTX2024');

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO01', 'BUS2033F', 3, NULL),
('CB004ECO01', 'BUS3039F', 3, NULL),
('CB004ECO01', 'ECO3020F', 3, NULL),
('CB004ECO01', 'ECO3021S', 3, NULL),
('CB004ECO01', 'PHI2043S', 3, NULL);

-- Third Year Economics Electives (2 NQF level 7 ECO courses)
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'ECO3999X', NULL, 3, NULL),
('CB004ECO01', 'ECO3999X', NULL, 3, NULL);


-- Third Year Level 7 Courses Choice (2 courses)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO01', 2, 'Third year level 7 courses');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'FTX3044F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004ECO01', 'STA3030F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004ECO01', 'FTX3045S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004ECO01', 'STA3036S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Third Year Additional Course (ECO2008S or 1 NQF level 6 or 7 course)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO01', 1, 'Third year additional course');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'ECO2008S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004ECO01', 'ELE2999X', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL),
('CB004ECO01', 'ELE3999X', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year, notes) VALUES
('CB004ECO01', 'BUS4050H', 4, NULL),
('CB004ECO01', 'ECO4006F', 4, NULL),
('CB004ECO01', 'ECO4007F', 4, NULL),
('CB004ECO01', 'ECO4016F', 4, NULL),
('CB004ECO01', 'ECO4112F', 4, 'Students who obtain less than 50% will not be allowed to continue'),
('CB004ECO01', 'ECO4021W', 4, NULL);

-- Fourth Year Electives (choose 2 options)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004ECO01', 2, 'Fourth year electives');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004ECO01', 'ECO4013S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4020S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4026S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4027S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4028S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4029S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4032S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4051S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4052S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4053S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4113S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4114S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4131S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4132S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004ECO01', 'ECO4200S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004ECO01' ORDER BY course_group_id DESC LIMIT 1), 4, NULL);

