-- Bachelor of Business Science specialising in COMPUTER SCIENCE [CB004CSC05]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB004CSC05', 'Computer Science', '** One of these options may be replaced by an elective from another department (with approval of the Computer Science Honours convenor). Not all electives will be offered each year. Unless otherwise agreed by the Head of the School, candidates will be expected to obtain an overall average of 65% for their third year Computer Science major courses and at least 55% for each course to be considered for a place in 4th year Computer Science courses. Places may be limited. Students who do not qualify for admission to 4th year Computer Science courses will be required to change their specialisation or degree in consultation with the Head of Department and the Deputy Dean Undergraduate Studies of Commerce.');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year) VALUES
('CB004CSC05', 'BUS1036F', 1),
('CB004CSC05', 'CSC1015F', 1),
('CB004CSC05', 'ECO1010F', 1),
('CB004CSC05', 'MAM1008S', 1),
('CB004CSC05', 'CSC1016S', 1),
('CB004CSC05', 'ECO1011S', 1),
('CB004CSC05', 'STA1000S', 1);

-- First Year Mathematics Option (MAM1031F OR MAM1004F)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004CSC05', 1, 'Mathematics foundation choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year) VALUES
('CB004CSC05', 'MAM1031F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 1),
('CB004CSC05', 'MAM1004F', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 1);

INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004CSC05', 1, 'Statistics foundation choice');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year) VALUES
('CB004CSC05', 'STA1000S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 1),
('CB004CSC05', 'STA1006S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 1);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year) VALUES
('CB004CSC05', 'ACC1021F', 2),
('CB004CSC05', 'ACC1022Z', 2),
('CB004CSC05', 'CSC2001F', 2),
('CB004CSC05', 'CML1001F', 2),
('CB004CSC05', 'INF2009F', 2),
('CB004CSC05', 'STA2020F', 2),
('CB004CSC05', 'INF2011S', 2),
('CB004CSC05', 'CSC2002S', 2),
('CB004CSC05', 'CSC2004Z', 2),
('CB004CSC05', 'PHI2043S', 2);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year) VALUES
('CB004CSC05', 'BUS3039F', 3),
('CB004CSC05', 'CSC3002F', 3),
('CB004CSC05', 'BUS3038S', 3),
('CB004CSC05', 'BUS2010S', 3),
('CB004CSC05', 'CSC3003S', 3),
('CB004CSC05', 'FTX2020F', 3);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, year) VALUES
('CB004CSC05', 'BUS4050H', 4),
('CB004CSC05', 'CSC4019Z', 4),
('CB004CSC05', 'CSC4020Z', 4),
('CB004CSC05', 'CSC4021Z', 4),
('CB004CSC05', 'CSC4002W', 4);

-- Fourth Year Electives (choose some from available options)
INSERT INTO degree_course_group (degree_id, required_count, description) VALUES ('CB004CSC05', 4, 'Choose 4 from Computer Science Honours electives');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB004CSC05', 'CSC4007Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4010Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4023Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4024Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4025Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4026Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4027Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4028Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'CSC4029Z', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, NULL),
('CB004CSC05', 'STA4026S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB004CSC05' ORDER BY course_group_id DESC LIMIT 1), 4, 'May replace with elective from another department with approval');
