-- Bachelor of Business Science in ACTUARIAL SCIENCE [CB003BUS01]

-- Insert Degree Details
INSERT INTO degree (degree_code, degree_name, notes) VALUES 
('CB003BUS01', 'Actuarial Science', '(i) Students failing in their first year to achieve the requirements for entry to BUS2016H can expect to take an additional year over their degree and should explore alternatives. (ii) CB019 readmission rules apply to CB026, however if a student fails 2 courses in the first semester of the first year, they will be transferred into the extended programme (CB018BUS01).');

-- First Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS01', 'ACC1006F', NULL, 1, NULL),
('CB003BUS01', 'BUS1036F', NULL, 1, NULL),
('CB003BUS01', 'CSC1015F', NULL, 1, NULL),
('CB003BUS01', 'ECO1010F', NULL, 1, NULL),
('CB003BUS01', 'MAM1031F', NULL, 1, NULL),
('CB003BUS01', 'MAM1032S', NULL, 1, NULL),
('CB003BUS01', 'BUS1003H', NULL, 1, NULL),
('CB003BUS01', 'ACC1011S', NULL, 1, NULL),
('CB003BUS01', 'ECO1011S', NULL, 1, NULL),
('CB003BUS01', 'STA1006S', NULL, 1, NULL);

-- Second Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS01', 'CML1001F', NULL, 2, NULL),
('CB003BUS01', 'ECO2003F', NULL, 2, NULL),
('CB003BUS01', 'STA2004F', NULL, 2, NULL),
('CB003BUS01', 'MAM2010F', NULL, 2, NULL),
('CB003BUS01', 'MAM2011F', NULL, 2, NULL),
('CB003BUS01', 'BUS2016H', NULL, 2, 'Students failing first year requirements for this course will need an additional year'),
('CB003BUS01', 'ECO2004S', NULL, 2, NULL),
('CB003BUS01', 'FTX2024S', NULL, 2, NULL),
('CB003BUS01', 'STA2005S', NULL, 2, NULL);

-- Second Year Mathematics Option - Choose 2 from 3 courses
INSERT INTO degree_course_group (degree_id, parent_group_id, required_count, description) VALUES ('CB003BUS01', NULL, 2, 'Mathematics electives - 2 of 3');
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS01', 'MAM2012S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS01' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB003BUS01', 'MAM2013S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS01' ORDER BY course_group_id DESC LIMIT 1), 2, NULL),
('CB003BUS01', 'MAM2014S', (SELECT course_group_id FROM degree_course_group WHERE degree_id = 'CB003BUS01' ORDER BY course_group_id DESC LIMIT 1), 2, NULL);

-- Third Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS01', 'BUS3018F', NULL, 3, NULL),
('CB003BUS01', 'BUS3039F', NULL, 3, NULL),
('CB003BUS01', 'STA3041F', NULL, 3, NULL),
('CB003BUS01', 'STA3045F', NULL, 3, NULL),
('CB003BUS01', 'BUS3024S', NULL, 3, NULL),
('CB003BUS01', 'PHI2043S', NULL, 3, NULL),
('CB003BUS01', 'STA3047S', NULL, 3, NULL),
('CB003BUS01', 'STA3048S', NULL, 3, NULL);

-- Fourth Year Core Modules
INSERT INTO courses_per_degree (degree_id, course_id, course_group_id, year, notes) VALUES
('CB003BUS01', 'BUS4028F', NULL, 4, NULL),
('CB003BUS01', 'BUS4027W', NULL, 4, NULL),
('CB003BUS01', 'BUS4050H', NULL, 4, NULL),
('CB003BUS01', 'BUS4029H', NULL, 4, NULL),
('CB003BUS01', 'BUS4034S', NULL, 4, NULL);
