"""
URL configuration for myadvisor project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from handbook import views as handbook_views
from advising import views as advising_views
# from django.conf import settings
# from django.conf.urls.static import static

urlpatterns = [
    path('', handbook_views.get_health, name='get_health'),
    path('admin/', admin.site.urls),
    path('faculties/', handbook_views.get_faculties, name='get_faculties'),
    path('faculties/<str:faculty_code>/programs/', handbook_views.get_programs_by_faculty, name='get_programs_by_faculty'),
    path('faculties/<str:faculty_code>/programs/<str:program_code>/degrees/', handbook_views.get_degrees_by_program, name='get_degrees_by_program'),
    path('faculties/<str:faculty_code>/programs/<str:program_code>/majors/', handbook_views.get_majors_by_program, name='get_majors_by_program'),
    path('departments/', handbook_views.get_departments, name='get_departments'),
    path('departments/<str:department_code>/courses/', handbook_views.get_courses_by_department, name='get_courses_by_department'),
    path('faculties/<str:faculty_code>/programs/<str:program_code>/degrees_no_courses/', handbook_views.get_degrees_by_program_no_courses, name='get_degrees_by_program_no_courses'),
    path('faculties/<str:faculty_code>/programs/<str:program_code>/majors_no_courses/', handbook_views.get_majors_by_program_no_courses, name='get_majors_by_program'),
    path('roadmap_result/', handbook_views.get_roadmap_result, name='get_roadmap_result'),

    path('advisors/', advising_views.get_advisors, name='get_advisors'),
    path('advisor_questions/', advising_views.get_advisor_questions, name='get_advisor_questions'),
    path('advisor_chatbot_questions/', advising_views.get_advisor_questions_chatbot, name='advisor_chatbot_questions'),
    path('advisor_questions_fetch/', advising_views.get_advisor_questions_id, name='advisor_questions_fetch'),
    path('faqs/', advising_views.get_faqs, name='get_faqs'),
    path('glossary/', advising_views.get_glossary, name='get_glossary'),
    path('login/', advising_views.login_user, name='login_user'),
    path('register/', advising_views.register_user, name='register_user'),
    path('ask_question/', advising_views.ask_question, name='ask_question'),
    path('answer_question/', advising_views.answer_question, name='answer_question'),
    path('refresh/', advising_views.refresh_user_data, name='refresh_user_data'),
    # path('chatbot/', views.ChatbotView.as_view(), name='chatbot'),
    # path('chatbot/ask/stream/', views.ask_question_stream, name='ask_question_stream'),
] # + static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)