"""
Django settings for myadvisor project.

Generated by 'django-admin startproject' using Django 5.2.4.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-7i^!%y)8otonqu5!3%+d4y#4e!u_mw=go7$u!u8%*-03kjol3q'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['myadvisor-1.cs.uct.ac.za', 'myadvisor.cs.uct.ac.za', 'badkamer.cs.uct.ac.za', '137.158.59.19:8004', '127.0.0.1', 'localhost']


# Application definition

INSTALLED_APPS = [
    'jazzmin',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'handbook',
    'advising',
    'other',
]

JAZZMIN_SETTINGS = {
    "site_title": "UCT Admin",
    "site_header": "University of Cape Town",
    "site_brand": "UCT",
    "site_logo": "jazzmin/img/UCT-logo.png",
    "site_logo_classes": "img-circle small-logo",
    "site_icon": "jazzmin/img/UCT-logo.png",
    "welcome_sign": "Welcome to the UCT MyAdvisor Admin Portal",
    "show_sidebar": True,
    "navigation_expanded": True,
    "sidebar_disable_expand": False,
    "sidebar": {
        "fixed": True,
        "collapsed": False,
    },
    "layout_fixed": True,
    "sidebar_nav_small_text": False,
    "sidebar_nav_legacy_style": False,
    "sidebar_nav_compact_style": False,
    "default_icon_parents": "fas fa-chevron-circle-right",
    "default_icon_children": "fas fa-circle",
    "icons": {
        "auth": "fas fa-users-cog",
        "auth.user": "fas fa-user",
        "auth.Group": "fas fa-users",
        
        # Advising app models
        "advising.Student": "fas fa-user-graduate",
        "advising.Advisor": "fas fa-chalkboard-teacher",
        "advising.AdvisorQuestion": "fas fa-question-circle",
        "advising.FaqSection": "fas fa-folder",
        "advising.Faq": "fas fa-question",
        "advising.Glossary": "fas fa-book",
        
        # Handbook app models
        "handbook.Faculty": "fas fa-university",
        "handbook.Department": "fas fa-building",
        "handbook.Semester": "fas fa-calendar-alt",
        "handbook.Course": "fas fa-book-open",
        "handbook.Program": "fas fa-graduation-cap",
        "handbook.Qualification": "fas fa-certificate",
        "handbook.Degree": "fas fa-award",
        "handbook.Major": "fas fa-star",
    },
    "custom_css": "admin/css/custom.css",
}

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'myadvisor.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'myadvisor.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': 'myadvisor',
        'USER': 'postgres',
        'PASSWORD': 'myadvisor',
        'HOST': 'localhost',
        'PORT': '5432',
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/

STATIC_URL = 'static/'

#STATIC_URL = '/backend/static/'
#MEDIA_URL = '/backend/media/'
#FORCE_SCRIPT_NAME = '/backend'

STATIC_ROOT = BASE_DIR / 'staticfiles'

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

CSRF_TRUSTED_ORIGINS = [
    'https://myadvisor.cs.uct.ac.za',
]
