# Generated by Django 5.2.5 on 2025-08-29 18:51

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('course_code', models.CharField(help_text="Unique 8-digit code e.g. 'MAM1004F'. First 3 digits is the department code that the course falls under e.g. 'MAM' for Maths department. 4th digit is typically the year e.g. '1' for 1st year course. Next 3 digits is a number between 001 and 999. Last digit is a semester letter representing the semester the course is in. e.g. 'F' for First semester", max_length=8, primary_key=True, serialize=False)),
                ('course_name', models.TextField()),
                ('nqf_credits', models.IntegerField(blank=True, default=18, null=True)),
                ('nqf_level', models.IntegerField(blank=True, default=5, null=True)),
                ('convener', models.TextField(blank=True, null=True)),
                ('course_entry_requirements', models.TextField(blank=True, null=True)),
                ('corequisites', models.TextField(blank=True, null=True)),
                ('objective', models.TextField(blank=True, null=True)),
                ('course_outline', models.TextField(blank=True, null=True)),
                ('lecture_times', models.TextField(blank=True, null=True)),
                ('dp_requirements', models.TextField(blank=True, null=True)),
                ('assessment', models.TextField(blank=True, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'course',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='CoursesPerDegree',
            fields=[
                ('course_degree_id', models.AutoField(primary_key=True, serialize=False)),
                ('year', models.IntegerField(default=1)),
                ('notes', models.TextField(blank=True, null=True)),
                ('degree', models.ForeignKey('Degree', models.DO_NOTHING, db_column='degree')),
                ('course', models.ForeignKey('Course', models.DO_NOTHING, db_column='course')),
            ],
            options={
                'db_table': 'courses_per_degree',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='CoursesPerMajor',
            fields=[
                ('course_major_id', models.AutoField(primary_key=True, serialize=False)),
                ('year', models.IntegerField(default=1)),
                ('notes', models.TextField(blank=True, null=True)),
                ('major', models.ForeignKey('Major', models.DO_NOTHING, db_column='major')),
                ('course', models.ForeignKey('Course', models.DO_NOTHING, db_column='course')),
            ],
            options={
                'db_table': 'courses_per_major',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Degree',
            fields=[
                ('degree_code', models.CharField(help_text="Unique 10-digit code e.g. 'CB001MAM01' for Bachelor of Commerce specialising in Mathematics. First 5 digits are the program code e.g. 'CB001' for Bachelor of Commerce. Next 3 are the department code that the degree falls under e.g. 'MAM' for the Mathematics Department. Last 2 is a number between 01 and 99.", max_length=10, primary_key=True, serialize=False)),
                ('degree_name', models.TextField()),
                ('notes', models.TextField(blank=True, null=True)),
                ('department', models.ForeignKey('Department', models.DO_NOTHING, db_column='department')),
                ('program', models.ForeignKey('Program', models.DO_NOTHING, db_column='program')),
            ],
            options={
                'db_table': 'degree',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DegreeCourseGroup',
            fields=[
                ('course_group_id', models.AutoField(primary_key=True, serialize=False)),
                ('required_count', models.IntegerField(default=1, help_text='Select the number of courses that a student must take in this Group.')),
                ('description', models.TextField(default='Group <django.db.models.fields.AutoField>')),
                ('degree', models.ForeignKey('Degree', models.DO_NOTHING, blank=True, null=True, db_column='degree')),
                ('parent_group', models.ForeignKey('DegreeParentCourseGroup', models.CASCADE, blank=True, null=True))
            ],
            options={
                'db_table': 'degree_course_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DegreeParentCourseGroup',
            fields=[
                ('group_id', models.AutoField(primary_key=True, serialize=False)),
                ('required_count', models.IntegerField(default=1)),
                ('description', models.TextField(default='Parent Group <django.db.models.fields.AutoField>')),
                ('degree', models.ForeignKey('Degree', models.CASCADE))
            ],
            options={
                'db_table': 'degree_parent_course_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Elective',
            fields=[
                ('elective_id', models.AutoField(primary_key=True, serialize=False)),
                ('year', models.IntegerField(default=1)),
                ('notes', models.TextField(blank=True, null=True)),
                ('program', models.ForeignKey('Program', models.DO_NOTHING, db_column='program_code')),
                ('course', models.ForeignKey('Course', models.DO_NOTHING, db_column='course_code'))
            ],
            options={
                'db_table': 'elective',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Faculty',
            fields=[
                ('faculty_name', models.TextField(help_text='Must be unique', unique=True)),
                ('faculty_code', models.CharField(help_text="Unique 3-letter code e.g 'COM' for Commerce", max_length=3, primary_key=True, serialize=False)),
                ('colour', models.CharField(default='#0000FF', help_text="Hex color code for the faculty e.g '#0000FF' for blue", max_length=7)),
                ('icon', models.BinaryField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'Faculties',
                'db_table': 'faculty',
            },
        ),
        migrations.CreateModel(
            name='Major',
            fields=[
                ('major_code', models.CharField(max_length=10, primary_key=True, serialize=False)),
                ('major_name', models.TextField()),
                ('notes', models.TextField(blank=True, null=True)),
                ('department', models.ForeignKey('Department', models.DO_NOTHING, db_column='department')),
                ('program', models.ForeignKey('Program', models.DO_NOTHING, db_column='program')),
            ],
            options={
                'db_table': 'major',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='MajorCourseGroup',
            fields=[
                ('course_group_id', models.AutoField(primary_key=True, serialize=False)),
                ('required_count', models.IntegerField(default=1, help_text='Select the number of courses that a student must take in this Group.')),
                ('description', models.TextField(default='Group <django.db.models.fields.AutoField>')),
                ('major', models.ForeignKey('Major', models.DO_NOTHING)),
                ('parent_group', models.ForeignKey('MajorParentCourseGroup', models.CASCADE, blank=True, null=True))
            ],
            options={
                'db_table': 'major_course_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='MajorParentCourseGroup',
            fields=[
                ('group_id', models.AutoField(primary_key=True, serialize=False)),
                ('required_count', models.IntegerField(default=1)),
                ('description', models.TextField(default='Parent Group <django.db.models.fields.AutoField>')),
                ('major', models.ForeignKey('Major', models.CASCADE))
            ],
            options={
                'db_table': 'major_parent_course_group',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Program',
            fields=[
                ('program_code', models.CharField(help_text="Unique 5-digit code e.g. 'CB001' for Bachelor of Commerce. 1st digit is for faculty e.g. 'C' for Commerce. 2nd digit is for qualification e.g. 'B' for Bachelor's. Last 3 digits is a number between 001 and 999.", max_length=5, primary_key=True, serialize=False)),
                ('program_name', models.CharField(max_length=255)),
                ('program_abbreviation', models.CharField(help_text="Unique abbreviation for the program. e.g. 'BCom' for Bachelor of Commerce.", max_length=255, unique=True)),
                ('saqa_id', models.CharField(blank=True, max_length=255, null=True)),
                ('minimum_duration_years', models.IntegerField(default=3)),
                ('nqf_level', models.IntegerField(default=7, help_text="7 for Bachelor's, 8 for Honour's, 9 for Master's, 10 for Doctorate")),
                ('notes', models.TextField(blank=True, null=True)),
                ('faculty', models.ForeignKey('Faculty', models.CASCADE)),
                ('qualification', models.ForeignKey('Qualification', models.CASCADE)),
            ],
            options={
                'db_table': 'program',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Qualification',
            fields=[
                ('qualification_id', models.AutoField(primary_key=True, serialize=False)),
                ('qualification_name', models.CharField(max_length=255, unique=True)),
            ],
            options={
                'db_table': 'qualification',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Semester',
            fields=[
                ('semester_letter', models.CharField(max_length=1, primary_key=True, serialize=False)),
                ('semester_name', models.TextField()),
            ],
            options={
                'db_table': 'semester',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('department_name', models.TextField(unique=True)),
                ('department_code', models.CharField(max_length=3, primary_key=True, serialize=False)),
                ('building', models.TextField(blank=True, null=True)),
                ('faculty', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='handbook.faculty')),
            ],
            options={
                'db_table': 'department',
            },
        ),
    ]
