--
-- PostgreSQL database dump
--

-- Dumped from database version 17.4
-- Dumped by pg_dump version 17.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: advisor; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor (
    advisor_id integer NOT NULL,
    username character varying(255) NOT NULL,
    first_name character varying(255),
    last_name character varying(255),
    email character varying(255),
    title character varying(255),
    phone_number character varying(15),
    office_number character varying(255),
    building character varying(255),
    profile_photo bytea,
    notes text,
    date_joined timestamp with time zone NOT NULL,
    is_active boolean NOT NULL,
    is_staff boolean NOT NULL,
    is_superuser boolean NOT NULL,
    last_login timestamp with time zone,
    password character varying(255)
);


ALTER TABLE public.advisor OWNER TO postgres;

--
-- Name: advisor_advisor_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor ALTER COLUMN advisor_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_advisor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_degrees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_degrees (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    degree_id character varying(10) NOT NULL
);


ALTER TABLE public.advisor_degrees OWNER TO postgres;

--
-- Name: advisor_degree_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_degrees ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_degree_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_departments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_departments (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    department_id character varying(3) NOT NULL
);


ALTER TABLE public.advisor_departments OWNER TO postgres;

--
-- Name: advisor_department_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_departments ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_department_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_faculties; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_faculties (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    faculty_id integer
);


ALTER TABLE public.advisor_faculties OWNER TO postgres;

--
-- Name: advisor_faculty_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_faculties ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_faculty_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_groups (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.advisor_groups OWNER TO postgres;

--
-- Name: advisor_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_majors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_majors (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    major_id character varying(10) NOT NULL
);


ALTER TABLE public.advisor_majors OWNER TO postgres;

--
-- Name: advisor_major_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_majors ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_major_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_programs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_programs (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    program_id character varying(5) NOT NULL
);


ALTER TABLE public.advisor_programs OWNER TO postgres;

--
-- Name: advisor_program_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_programs ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_program_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_question; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_question (
    question_id integer NOT NULL,
    question text NOT NULL,
    answer text,
    advisor integer,
    student integer,
    advisor_read boolean NOT NULL,
    category character varying(255),
    student_read boolean NOT NULL,
    subject character varying(255),
    q_timestamp timestamp with time zone,
    a_timestamp timestamp with time zone
);


ALTER TABLE public.advisor_question OWNER TO postgres;

--
-- Name: advisor_question_question_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_question ALTER COLUMN question_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_question_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: advisor_user_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.advisor_user_permissions (
    id bigint NOT NULL,
    advisor_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.advisor_user_permissions OWNER TO postgres;

--
-- Name: advisor_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.advisor_user_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.advisor_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_group (
    id integer NOT NULL,
    name character varying(150) NOT NULL
);


ALTER TABLE public.auth_group OWNER TO postgres;

--
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_group ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_group_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_group_permissions (
    id bigint NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_group_permissions OWNER TO postgres;

--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_group_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_permission (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE public.auth_permission OWNER TO postgres;

--
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_permission ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_user (
    id integer NOT NULL,
    password character varying(128) NOT NULL,
    last_login timestamp with time zone,
    is_superuser boolean NOT NULL,
    username character varying(150) NOT NULL,
    first_name character varying(150) NOT NULL,
    last_name character varying(150) NOT NULL,
    email character varying(254) NOT NULL,
    is_staff boolean NOT NULL,
    is_active boolean NOT NULL,
    date_joined timestamp with time zone NOT NULL
);


ALTER TABLE public.auth_user OWNER TO postgres;

--
-- Name: auth_user_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_user_groups (
    id bigint NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.auth_user_groups OWNER TO postgres;

--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_user_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_user ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: auth_user_user_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.auth_user_user_permissions (
    id bigint NOT NULL,
    user_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.auth_user_user_permissions OWNER TO postgres;

--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.auth_user_user_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.auth_user_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: course; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.course (
    course_name character varying(255) NOT NULL,
    nqf_credits integer NOT NULL,
    nqf_level integer NOT NULL,
    convener character varying(255),
    course_entry_requirements text,
    corequisites text,
    objective text,
    course_outline text,
    lecture_times text,
    dp_requirements text,
    assessment text,
    notes text,
    course_code character varying(15) NOT NULL,
    department character varying(3),
    semester character(1),
    department_id character varying(3),
    semester_id character varying(1),
    CONSTRAINT courses_nqf_credits_check CHECK (((nqf_credits >= 0) AND (nqf_credits <= 999))),
    CONSTRAINT courses_nqf_level_check CHECK (((nqf_level >= 0) AND (nqf_level <= 99)))
);


ALTER TABLE public.course OWNER TO postgres;

--
-- Name: degree_course_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.degree_course_group (
    course_group_id integer NOT NULL,
    degree_id character varying(10),
    required_count integer NOT NULL,
    description text DEFAULT 'Missing Description'::text NOT NULL,
    parent_group_id integer,
    major_code character varying(5)
);


ALTER TABLE public.degree_course_group OWNER TO postgres;

--
-- Name: course_groups_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.course_groups_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.course_groups_group_id_seq OWNER TO postgres;

--
-- Name: course_groups_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.course_groups_group_id_seq OWNED BY public.degree_course_group.course_group_id;


--
-- Name: courses_per_degree; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses_per_degree (
    course_degree_id integer NOT NULL,
    degree_id character varying(10) NOT NULL,
    course_id character varying(15) NOT NULL,
    course_group_id integer,
    year integer NOT NULL,
    notes text
);


ALTER TABLE public.courses_per_degree OWNER TO postgres;

--
-- Name: courses_per_degree_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_per_degree_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.courses_per_degree_id_seq OWNER TO postgres;

--
-- Name: courses_per_degree_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_per_degree_id_seq OWNED BY public.courses_per_degree.course_degree_id;


--
-- Name: courses_per_major; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.courses_per_major (
    course_major_id integer NOT NULL,
    major_id character varying(10) NOT NULL,
    course_id character varying(15) NOT NULL,
    course_group_id integer,
    year integer NOT NULL,
    notes text
);


ALTER TABLE public.courses_per_major OWNER TO postgres;

--
-- Name: courses_per_major_course_major_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.courses_per_major_course_major_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.courses_per_major_course_major_id_seq OWNER TO postgres;

--
-- Name: courses_per_major_course_major_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.courses_per_major_course_major_id_seq OWNED BY public.courses_per_major.course_major_id;


--
-- Name: degree; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.degree (
    degree_name character varying(255) NOT NULL,
    degree_code character varying(10) NOT NULL,
    notes text,
    department_id character varying(3),
    program_id character varying(5)
);


ALTER TABLE public.degree OWNER TO postgres;

--
-- Name: degree_parent_course_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.degree_parent_course_group (
    parent_group_id integer NOT NULL,
    degree_id character varying(10) NOT NULL,
    required_count integer NOT NULL,
    description text DEFAULT 'Missing Description'::text NOT NULL
);


ALTER TABLE public.degree_parent_course_group OWNER TO postgres;

--
-- Name: degree_parent_course_group_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.degree_parent_course_group_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.degree_parent_course_group_group_id_seq OWNER TO postgres;

--
-- Name: degree_parent_course_group_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.degree_parent_course_group_group_id_seq OWNED BY public.degree_parent_course_group.parent_group_id;


--
-- Name: department; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.department (
    department_name text NOT NULL,
    building text,
    department_code character varying(3) NOT NULL,
    faculty_id integer NOT NULL
);


ALTER TABLE public.department OWNER TO postgres;

--
-- Name: django_admin_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.django_admin_log (
    id integer NOT NULL,
    action_time timestamp with time zone NOT NULL,
    object_id text,
    object_repr character varying(200) NOT NULL,
    action_flag smallint NOT NULL,
    change_message text NOT NULL,
    content_type_id integer,
    user_id integer NOT NULL,
    CONSTRAINT django_admin_log_action_flag_check CHECK ((action_flag >= 0))
);


ALTER TABLE public.django_admin_log OWNER TO postgres;

--
-- Name: django_admin_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.django_admin_log ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_admin_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_content_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.django_content_type (
    id integer NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE public.django_content_type OWNER TO postgres;

--
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.django_content_type ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.django_migrations (
    id bigint NOT NULL,
    app character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    applied timestamp with time zone NOT NULL
);


ALTER TABLE public.django_migrations OWNER TO postgres;

--
-- Name: django_migrations_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.django_migrations ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.django_migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: django_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp with time zone NOT NULL
);


ALTER TABLE public.django_session OWNER TO postgres;

--
-- Name: elective; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.elective (
    elective_id integer NOT NULL,
    program_id character varying(5) NOT NULL,
    course_id character varying(15) NOT NULL,
    year integer NOT NULL,
    notes text,
    CONSTRAINT electives_year_level_check CHECK ((year = ANY (ARRAY[1, 2, 3, 4, 5, 6, 7, 8, 9])))
);


ALTER TABLE public.elective OWNER TO postgres;

--
-- Name: electives_elective_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.electives_elective_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.electives_elective_id_seq OWNER TO postgres;

--
-- Name: electives_elective_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.electives_elective_id_seq OWNED BY public.elective.elective_id;


--
-- Name: faculty; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.faculty (
    faculty_name text NOT NULL,
    faculty_code character varying(3) NOT NULL,
    colour character varying(7) DEFAULT '#0000FF'::character varying NOT NULL,
    icon bytea,
    faculty_id integer NOT NULL
);


ALTER TABLE public.faculty OWNER TO postgres;

--
-- Name: faculty_faculty_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.faculty ALTER COLUMN faculty_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.faculty_faculty_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: faq; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.faq (
    faq_id integer NOT NULL,
    question text NOT NULL,
    answer text NOT NULL,
    section_id integer
);


ALTER TABLE public.faq OWNER TO postgres;

--
-- Name: faq_faq_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.faq_faq_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.faq_faq_id_seq OWNER TO postgres;

--
-- Name: faq_faq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.faq_faq_id_seq OWNED BY public.faq.faq_id;


--
-- Name: faq_section; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.faq_section (
    section_name character varying(255) NOT NULL,
    section_id integer NOT NULL
);


ALTER TABLE public.faq_section OWNER TO postgres;

--
-- Name: faq_section_section_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.faq_section_section_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.faq_section_section_id_seq OWNER TO postgres;

--
-- Name: faq_section_section_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.faq_section_section_id_seq OWNED BY public.faq_section.section_id;


--
-- Name: glossary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.glossary (
    term_id integer NOT NULL,
    term character varying(255) NOT NULL,
    definition text NOT NULL
);


ALTER TABLE public.glossary OWNER TO postgres;

--
-- Name: glossary_word_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.glossary_word_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.glossary_word_id_seq OWNER TO postgres;

--
-- Name: glossary_word_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.glossary_word_id_seq OWNED BY public.glossary.term_id;


--
-- Name: major; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.major (
    major_code character varying(10) NOT NULL,
    major_name character varying(255) NOT NULL,
    notes text,
    department_id character varying(3),
    program_id character varying(5)
);


ALTER TABLE public.major OWNER TO postgres;

--
-- Name: major_course_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.major_course_group (
    course_group_id integer NOT NULL,
    major_id character varying(10) NOT NULL,
    required_count integer NOT NULL,
    description text DEFAULT 'Missing Description'::text NOT NULL,
    parent_group_id integer
);


ALTER TABLE public.major_course_group OWNER TO postgres;

--
-- Name: major_course_group_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.major_course_group_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.major_course_group_group_id_seq OWNER TO postgres;

--
-- Name: major_course_group_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.major_course_group_group_id_seq OWNED BY public.major_course_group.course_group_id;


--
-- Name: major_parent_course_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.major_parent_course_group (
    parent_group_id integer NOT NULL,
    major_id character varying(10) NOT NULL,
    required_count integer NOT NULL,
    description text DEFAULT 'Missing Description'::text NOT NULL
);


ALTER TABLE public.major_parent_course_group OWNER TO postgres;

--
-- Name: major_parent_course_group_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.major_parent_course_group_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.major_parent_course_group_group_id_seq OWNER TO postgres;

--
-- Name: major_parent_course_group_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.major_parent_course_group_group_id_seq OWNED BY public.major_parent_course_group.parent_group_id;


--
-- Name: majors_per_program; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.majors_per_program (
    major_program_id integer NOT NULL,
    program_code character varying(5) NOT NULL,
    major_code character varying(5) NOT NULL
);


ALTER TABLE public.majors_per_program OWNER TO postgres;

--
-- Name: major_program_link_major_program_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.major_program_link_major_program_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.major_program_link_major_program_id_seq OWNER TO postgres;

--
-- Name: major_program_link_major_program_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.major_program_link_major_program_id_seq OWNED BY public.majors_per_program.major_program_id;


--
-- Name: program; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.program (
    program_name text NOT NULL,
    program_abbreviation text NOT NULL,
    program_code character varying(5) NOT NULL,
    saqa_id text,
    minimum_duration_years integer NOT NULL,
    nqf_level integer NOT NULL,
    qualification_id integer NOT NULL,
    notes text,
    faculty_id integer
);


ALTER TABLE public.program OWNER TO postgres;

--
-- Name: qualification; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.qualification (
    qualification_id integer NOT NULL,
    qualification_name character varying(255) NOT NULL
);


ALTER TABLE public.qualification OWNER TO postgres;

--
-- Name: qualification_qualification_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.qualification_qualification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.qualification_qualification_id_seq OWNER TO postgres;

--
-- Name: qualification_qualification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.qualification_qualification_id_seq OWNED BY public.qualification.qualification_id;


--
-- Name: semester; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.semester (
    semester_letter character(1) NOT NULL,
    semester_name character varying(255) NOT NULL
);


ALTER TABLE public.semester OWNER TO postgres;

--
-- Name: student; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student (
    student_id integer NOT NULL,
    username character varying(255) NOT NULL,
    first_name character varying(255),
    last_name character varying(255),
    email character varying(255),
    password character varying(255) NOT NULL,
    date_joined timestamp with time zone NOT NULL,
    is_active boolean NOT NULL,
    is_staff boolean NOT NULL,
    is_superuser boolean NOT NULL,
    last_login timestamp with time zone
);


ALTER TABLE public.student OWNER TO postgres;

--
-- Name: student_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_groups (
    id bigint NOT NULL,
    student_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.student_groups OWNER TO postgres;

--
-- Name: student_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.student_groups ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.student_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: student_student_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.student ALTER COLUMN student_id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.student_student_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: student_user_permissions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.student_user_permissions (
    id bigint NOT NULL,
    student_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE public.student_user_permissions OWNER TO postgres;

--
-- Name: student_user_permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.student_user_permissions ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.student_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: courses_per_degree course_degree_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree ALTER COLUMN course_degree_id SET DEFAULT nextval('public.courses_per_degree_id_seq'::regclass);


--
-- Name: courses_per_major course_major_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major ALTER COLUMN course_major_id SET DEFAULT nextval('public.courses_per_major_course_major_id_seq'::regclass);


--
-- Name: degree_course_group course_group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_course_group ALTER COLUMN course_group_id SET DEFAULT nextval('public.course_groups_group_id_seq'::regclass);


--
-- Name: degree_parent_course_group parent_group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_parent_course_group ALTER COLUMN parent_group_id SET DEFAULT nextval('public.degree_parent_course_group_group_id_seq'::regclass);


--
-- Name: elective elective_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.elective ALTER COLUMN elective_id SET DEFAULT nextval('public.electives_elective_id_seq'::regclass);


--
-- Name: faq faq_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faq ALTER COLUMN faq_id SET DEFAULT nextval('public.faq_faq_id_seq'::regclass);


--
-- Name: faq_section section_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faq_section ALTER COLUMN section_id SET DEFAULT nextval('public.faq_section_section_id_seq'::regclass);


--
-- Name: glossary term_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.glossary ALTER COLUMN term_id SET DEFAULT nextval('public.glossary_word_id_seq'::regclass);


--
-- Name: major_course_group course_group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_course_group ALTER COLUMN course_group_id SET DEFAULT nextval('public.major_course_group_group_id_seq'::regclass);


--
-- Name: major_parent_course_group parent_group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_parent_course_group ALTER COLUMN parent_group_id SET DEFAULT nextval('public.major_parent_course_group_group_id_seq'::regclass);


--
-- Name: majors_per_program major_program_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.majors_per_program ALTER COLUMN major_program_id SET DEFAULT nextval('public.major_program_link_major_program_id_seq'::regclass);


--
-- Name: qualification qualification_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.qualification ALTER COLUMN qualification_id SET DEFAULT nextval('public.qualification_qualification_id_seq'::regclass);


--
-- Data for Name: advisor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor (advisor_id, username, first_name, last_name, email, title, phone_number, office_number, building, profile_photo, notes, date_joined, is_active, is_staff, is_superuser, last_login, password) FROM stdin;
10	JacquesRousseau	Jacques	Rousseau	\N	\N	\N	\N	\N	\N	CB001BUS06 – 1st and 2nd year students, surnames A–Mk	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
8	StudentAdvisors-OrganisationalPsychology	Student Advisors – Organisational Psychology	\N	admin.orgpsy@uct.ac.za	\N	\N	\N	\N	\N	Student advisors, or more accurately, curriculum advisors, are there to help students with their overall curriculum...	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
6	InformationSystemsAdvisors	Information Systems Advisors	\N	inf-studentadvisors-ug-group@uct.ac.za	\N	\N	\N	\N	\N	Undergraduate: Go to the Student advice page for the relevant advisor details. Postgraduate: Please contact the administrators and convenors of your relevant programmes.	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
5	EconomicsAdvisors	Economics Advisors	\N	soeadvice@uct.ac.za	\N	\N	\N	\N	\N	Student advisors, or curriculum advisors, are there to help students with their overall curriculum. We help you understand what degree options you have, what courses you should be doing each year, and can advise on careers in economics...	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
7	StudentAdvisors-ActuarialScience	Student Advisors - Actuarial Science	\N	\N	\N	\N	\N	\N	\N	Email: studentadvice.uctactsci@uct.ac.za.	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
4	StudentAdvisors-FinanceandTax	Student Advisors - Finance and Tax	\N	ftxstudentadvice@uct.ac.za	\N	\N	\N	\N	\N	Finance student advisors can assist students in planning their curriculum for the undergraduate degrees below: BBusSc specialising in Finance, Investment and Banking, BBusSc specialising in Finance with Accounting	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
3	StudentAdvisors-Accounting	Student Advisors - Accounting	\N	accstudentadvice@uct.ac.za	\N	\N	\N	\N	\N		2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
2	DominiqueKatshunga	Dominique	Katshunga	dominique.katshunga@uct.ac.za	\N	\N	\N	\N	\N	BBusSc in Statistics and Data Science	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
18	PragasenPillay	Pragasen	Pillay	\N	Dr	\N	\N	\N	\N	Senior Lecturer - Masters in Marketing in Consumer Neuroscience and PhD in Marketing	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
17	NkosivileMadinga	Nkosivile	Madinga	\N	Associate Professor	\N	\N	\N	\N	Deputy Dean - Research and Internationalisation – Masters in Marketing	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
16	NqobileBundwini	Nqobile	Bundwini	\N	Dr	\N	\N	\N	\N	Senior Lecturer - BCom in Management Studies and BCom Honours in Marketing	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
15	RaeesahChohan	Raeesah	Chohan	\N	Dr	\N	\N	\N	\N	Associate Professor - Postgraduate Diploma in Marketing	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
14	LebogangMototo	Lebogang	Mototo	lebogang.mototo@uct.ac.za	Lecturer	021 650 3554	5.28, Leslie Commerce	\N	\N	Lecturer - Bachelor of Business Science in Marketing	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
13	DanielMunene	Daniel	Munene	\N	\N	\N	\N	\N	\N	CB023BUS06 – All years, all students, CB011BUS06 – All years, all students	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
11	MarlinHoffman	Marlin	Hoffman	\N	\N	\N	\N	\N	\N	CB001BUS06 – 1st and 2nd year students, surnames Ml–Z	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
1	AslamSafla	Aslam	Safla	aslam.safla@uct.ac.za	Professor	\N	\N	\N	\N		2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
9	AlisonMeadows	Alison	Meadows	\N	\N	\N	\N	\N	\N	CB001BUS06 – All 3rd year students	2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
20	MitchellFlanegan	Mitchell	Flanegan	mflanegan8@gmail.com	Dr	\N	\N	\N	\N		2025-08-22 23:52:47.919988+02	t	f	f	\N	pbkdf2_sha256$1000000$Dm1djh0GU6N5WHJFuuRUeG$gWf6pDkZQRuGU9eR2qnLvOcb9WzpBm/JPR2IZKcJaXg=
\.


--
-- Data for Name: advisor_degrees; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_degrees (id, advisor_id, degree_id) FROM stdin;
1	1	CB004CSC05
2	2	CB004STA13
3	2	CB015STA13
4	2	CB024STA13
5	1	CB024CSC05
6	1	CB015CSC05
7	9	CB001BUS06
\.


--
-- Data for Name: advisor_departments; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_departments (id, advisor_id, department_id) FROM stdin;
1	20	CSC
2	18	BUS
3	17	BUS
4	16	BUS
5	15	BUS
6	14	BUS
7	13	BUS
8	11	BUS
9	10	BUS
10	9	BUS
11	8	BUS
12	1	CSC
13	6	INF
14	5	ECO
15	7	BUS
16	4	FTX
17	3	ACC
18	2	STA
\.


--
-- Data for Name: advisor_faculties; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_faculties (id, advisor_id, faculty_id) FROM stdin;
1	20	6
2	18	6
3	17	6
4	16	6
5	15	6
6	14	6
7	13	6
8	11	6
9	10	6
10	9	6
11	8	6
12	1	5
13	1	6
14	6	6
15	5	6
16	7	6
17	4	6
18	3	6
19	2	6
20	20	2
\.


--
-- Data for Name: advisor_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_groups (id, advisor_id, group_id) FROM stdin;
\.


--
-- Data for Name: advisor_majors; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_majors (id, advisor_id, major_id) FROM stdin;
1	1	SB001CSC05
2	1	SB001CSC02
3	1	SB001CSC03
\.


--
-- Data for Name: advisor_programs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_programs (id, advisor_id, program_id) FROM stdin;
1	1	CB011
2	1	CB004
3	1	SB016
4	1	SB001
5	1	CB024
6	1	CB015
7	1	CB023
8	1	CB001
9	7	CB018
10	7	CB020
11	7	CB025
12	7	CB019
13	7	CB026
14	7	CB003
\.


--
-- Data for Name: advisor_question; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_question (question_id, question, answer, advisor, student, advisor_read, category, student_read, subject, q_timestamp, a_timestamp) FROM stdin;
1	What is life?	IDK	20	5	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
3	Can I apply for a concession in Law?	There is a standard process if you are looking for any kind of concession related to a departure from the required curriculum:\r\nIf you would like to apply for a concession please complete the appropriate form LAW 02 (available for download here: https://forms.uct.ac.za/studentforms.htm) and submit it to the Deputy Dean (deputydean.law@uct.ac.za) with a copy of your academic record.\r\nA concession would include any departure from the standard curriculum prescribed for any particular level of the LLB."	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
4	Can I apply for an exemption in Law?	Please note that the Faculty of Law does not grant extensions on essay or assignment submission deadlines or make-up essays, assignments or tests, but exemptions may be applied for. If you would like to apply for an exemption from an essay, assignment or test, please use Form LAW03 – available at http://www.forms.uct.ac.za/studentforms.htm - which must be submitted, as per the instructions on the Form and together will full supporting documentation, to the Deputy Dean (Undergraduate Studies) on deputydean.law@uct.ac.za. The supporting documentation must clearly confirm an inability to perform on the specific date of the essay, assignment or test for which the exemption is sought. If the exemption is granted, the essay, assignment or test will not be taken into account in calculating your year mark for the course concerned and the final examination will count proportionately more towards your final course mark.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
5	Can I apply for an extended degree programme in law?	No, the UCT Law Faculty does not offer an extended degree programme. Rather, additional skills development opportunities are offered to students.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
6	Can I apply for deferred exams in law?	A deferred exam is an exam that is written at a later date instead of on the date originally set for the exam. Deferred exams are granted on medical or compassionate grounds, or for religious or political reasons, and applications for deferral are considered by a committee established by Senate for this purpose in terms of the general university rules. (see Handbook 3 General Rules and Policies). The granting of this permission is entirely at the discretion of Senate, irrespective of the grounds (including medical) on which the application is made. No deferred examination may be granted for a supplementary examination or examination without attendance (EWA).\r\nFor important additional information on this, please look at http://www.law.uct.ac.za/academic-administration-and-forms"	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
7	Can I apply for UCT financial assistance if I have exceeded my NSFAS N+1 funding rule?	Unfortunately not. UCT is unable to assist. UCT applies the same basic funding rules as NSFAS. Funding is limited and the focus is assist students to achieve a first qualifcation within the national funding rules.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
8	Can I apply to UCT while completing Grade 11?	No. Applications may only be submitted in the year before you plan to register.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
9	Can I apply/submit a late application for NSFAS funding?	No late applications are normally allowed. NSFAS applications for 2022 will open on 2 November 2021 and close on 7 January 2022.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
10	Can I be accepted into commerce if I don’t meet the Maths requirements?	No, you have to do maths in Commerce at UCT. Maths is an integral part of majority of the Commerce degrees and is therefore a requirement. In Humanities, maths is not a requirement.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
11	Can I defer my exams because of my mental health?	To defer your exams, you need to complete the deferment form which you can download from this website: https://forms.uct.ac.za/studentforms.htm. You also need to have a proof of counselling letter which you can get from your counsellor/psychologist. For further deferment questions, you can email deferred.exams@uct.ac.za.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
12	Can I do a Postgraduate Diploma in Actuarial Science?	The Postgraduate Diploma in Actuarial Science is aimed at graduates who have completed examinations of the A100 and A200-series of the Actuarial Society of South Africa (AS) or CT-series of the Institute and Faculty of Actuaries (UK) and now intend to study the A300, F100 and F200-series of the AS examinations (alternatively CA, ST and SA-series of UK examinations)	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
13	Can I get an extension for transcript submissions?	To make adjustments or changes for expected delays of documents on your application, please contact the admissions office. Simply write to admissions-ug@uct.ac.za (undergraduate applicants) or admissions-pg@uct.ac.za (postgraduate applicants) or call 021 650 2128 and inform them about your situation.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
14	Can I get into UCT using my Cambridge results?	UCT accepts students from international institutions and the Admissions office facilitates the selection process for applicants.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
15	Can I physically return my books to UCT library?	All library materials may be returned at the central drop-off point at CPS Burnage or book drop boxes located at all library sites. No borrowed material may be returned as an in-person transaction to the Libraries. Library material currently out on loan will be renewed until further notice.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
16	Can I still use a Jammie shuttle if I stay off campus?	You can use the Jammie even if you stay off-campus. You can use the closest Jammie stop to you which can be found here: http://www.students.uct.ac.za/students/services/transport-parking/jammie-shuttle/routes-timetables	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
17	Can I transfer from another university into Law at UCT?	For students who wish to transfer to the 4-year LLB, the admission criteria for 2022 is based on your matric and NBT scores. Once you receive a conditional offer further information will be provided on how you may apply for credits to be granted for courses that you have completed.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
18	Can I volunteer to assist at the Disability Service?	Yes, if you are a registered UCT student there are a variety of volunteering opportunities available, including Advocacy, Barrier Free Accessibility and Specialised Support Assistance. Please contact the Direct Services Specialist for more information (Denise.Oldham@uct.ac.za)	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
19	Do all students qualify for NSFAS accommodation funding?	No, students that are from out of Cape Town are eligible for accommodation. The University tries to accommodate NSFAS students in residence, so it's important that you indicate in your admissions application that you require student residence accommodation.\r\nI am a local student, do I qualify for NSFAS accommodation funding? Local students who live within reasonable distance to the University do not automatically qualify for accommodation. Students from informal settlements can apply for University residence accommodation. All other local students must submit a motivation to Student Financial Aid for permission.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
20	Do I have to write the NBTs if I want to do Law?	"All applicants to UCT must write both the Academic and Quantitative Literacy tests. These are critical as part of your application process. Go to https://www.nbt.ac.za/ and https://nbtests.uct.ac.za/ for more information."	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
21	What software (microsoft word, powerpoint, excel) does uct provide?	"UCT provides you with various software packages for free to enhance your productivity and learning for the duration of your studies. These include Office 365 (http://www.icts.uct.ac.za/office-365) (which you can install on up to 5 devices), Nvivo, MATLAB, SPSS, McAfee antivirus, and more. For more information on what is available, visit the ICTS Software page (http://www.icts.uct.ac.za/software)"	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
22	Do I need to send my final school-leaving results to UCT?	National Senior Certificate (NSC) candidates do not need to submit final examination results. UCT will obtain results from your results from your examination authority. However, if you present an international qualification, it is advisable to submit a final, certified copy to admissions-ug@uct.ac.za. Note that we may require your assistance in order to verify your results, in which case we will contact you.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
23	Do I need to take the NBTs to apply to UCT?	Go to http://www.students.uct.ac.za/students/applications/admission-requirements/national-benchmark-tests. For admission in 2022, the NBTs are a requirement for admission to all faculties, except for the Faculty of Engineering & the Built Environment.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
24	Qualify for student housing?	Housing offers to new undergraduate applicants will be made according to the criteria as set out below:\r\n• Financial Aid: All students who are made an academic offer and are awarded financial aid will be made an offer for housing\r\n• Minors: All students who are minors on 1 February in the year of registration and are made an academic offer will be made an offer for housing\r\n• Excellence: all entering u/g applicants who score 540 APS will be made an offer of housing.\r\n• Faculty criteria will be proposed on the basis of strategic priorities in the faculties and approved annually by the Admissions Committee. Faculty strategic criteria include rules–based and discretionary\r\n• Medical needs: To be confirmed (ratified) by Disability Service and Student Wellness\r\n• Director’s Discretion: These are high level special requests to which the director must apply his/her mind when considering a request for housing\r\nPlease refer to full criteria here: http://www.dsa.uct.ac.za/application-procedures-policy-0	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
25	Do I receive a funding offer with a UCT acceptance letter?	No, your application for admission to UCT and the application for funding are two separate applications. It takes time to assess the eligibility of all applications received and we want applicants to know their NSFAS and UCT financial aid funding status early. Knowing how you will pay for your studies helps to make an informed decision about where you accept a study offer. Eligible students can also immediately receive their allowances once they are registered.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
26	Do I receive a housing offer with a UCT acceptance letter?	No, your application for admission to UCT and your application for housing are two separate applications. Your application for admission is processed by the Faculty Office and housing applications are processed by the Student Housing Admissions & Advacocacy Services Office (SHAAS). Should you be made an offer of admission, SHAAS will process the application for residence but a place of study does not necessarily mean you would be granted housing as well.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
27	Does Careers Service offer help with finding opportunities for work or study overseas/internationally?	The UCT Careers Service advertises study/funding/work opportunities via MyCareer - a number of these are not in South Africa. You can use the Location search function to see what is available in a particular country/region: www.mycareer.uct.ac.za/students/jobs. You may need to also do your own research and tap your networks to find further opportunities & information. We can assist with opportunity search skills and how to target your application,. Please note that we do not advise on or assist with visa/permit requirements to work internationally.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
28	Does NSFAS cover private accommodation if I don’t get into a University residence?	Yes, but only if the accommodation has been accredited by the University. Information on accredited accommodation is available on the OCSAS: http://www.dsa.uct.ac.za/student-housing/off-campus-student-accommodation-services/about-the-ocsas. Students who sign a lease for accommodation that is not accredited will not receive a rental allowance.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
29	Does the library only have serious materials?	No, we also have fun materials including popular fiction in all genres, graphic novels, board-games such as chess, jigsaw puzzles, etc. Do let us know what you would like to read so that we may grow our collection.	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
30	Does UCT offer counselling support?	Yes we do. You can read more about our counselling services here: http://www.dsa.uct.ac.za/student-wellness/counseling-services/overview	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
31	Does UCT offer medical support?	Yes we do. You can read about the full list of services offered here: http://www.dsa.uct.ac.za/student-wellness/health-services/services	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
32	Does UCT offer support for psychiatric emergencies?	We offer support for psychiatric emergencies. You can read about the full list of medical services offered here: http://www.dsa.uct.ac.za/student-wellness/health-services/services	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
33	Does UCT provide data for online learning?	The university will continue data provisioning: Follow link for updated information: http://www.icts.uct.ac.za/news/mobile-data-rollout-june-2021	\N	\N	f	\N	t	\N	2025-08-26 17:23:16.930608+02	\N
34	How to degree	\N	1	5	f	Faculty	t	Advice	2025-08-26 22:40:36.816192+02	2025-08-26 22:40:36.816215+02
36	How to degree	\N	1	5	f	\N	t	Advice	2025-08-26 22:54:13.518427+02	2025-08-26 22:54:13.518442+02
37	How to degree	\N	1	2	f	Faculty	t	Advice	2025-08-26 23:16:08.2946+02	2025-08-26 23:16:08.294615+02
38	asdsf	\N	1	2	f	faculty	t	sdads	2025-08-26 23:35:45.660322+02	2025-08-26 23:35:45.660347+02
39	This is a test text for the user ethan	\N	1	2	f	faculty	t	This is a test question	2025-08-26 23:38:07.815789+02	2025-08-26 23:38:07.815813+02
40	Test 2 text area	\N	1	2	f	faculty	t	Test 2 	2025-08-26 23:54:39.923323+02	2025-08-26 23:54:39.923345+02
42	What do I do if I dont have DP? 	\N	1	2	f	faculty	t	DP	2025-08-28 12:29:23.468473+02	2025-08-28 12:29:23.468494+02
43	It was so nice I want to do it twice. Can I? How?	\N	1	2	f	faculty	t	Can I do computer science again	2025-08-28 14:48:14.748729+02	2025-08-28 14:48:14.748746+02
44	I am unsure of which course I should take in my first year of university, 	\N	1	2	f	faculty	t	nervous first year	2025-08-29 10:32:05.185711+02	2025-08-29 10:32:05.185731+02
45	hiiiiii :) should i study computer science if i am interested in fintech?	\N	1	2	f	faculty	t	any question	2025-08-29 13:41:30.581701+02	2025-08-29 13:41:30.581721+02
46	Howzit	\N	1	2	f	faculty	t	Test	2025-08-29 15:26:42.493581+02	2025-08-29 15:26:42.493598+02
47	How do I buy a degree?	\N	1	2	f	faculty	t	Science Department	2025-08-29 15:38:38.159302+02	2025-08-29 15:38:38.159318+02
\.


--
-- Data for Name: advisor_user_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.advisor_user_permissions (id, advisor_id, permission_id) FROM stdin;
\.


--
-- Data for Name: auth_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_group (id, name) FROM stdin;
\.


--
-- Data for Name: auth_group_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_group_permissions (id, group_id, permission_id) FROM stdin;
\.


--
-- Data for Name: auth_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_permission (id, name, content_type_id, codename) FROM stdin;
1	Can add log entry	1	add_logentry
2	Can change log entry	1	change_logentry
3	Can delete log entry	1	delete_logentry
4	Can view log entry	1	view_logentry
5	Can add permission	2	add_permission
6	Can change permission	2	change_permission
7	Can delete permission	2	delete_permission
8	Can view permission	2	view_permission
9	Can add group	3	add_group
10	Can change group	3	change_group
11	Can delete group	3	delete_group
12	Can view group	3	view_group
13	Can add user	4	add_user
14	Can change user	4	change_user
15	Can delete user	4	delete_user
16	Can view user	4	view_user
17	Can add content type	5	add_contenttype
18	Can change content type	5	change_contenttype
19	Can delete content type	5	delete_contenttype
20	Can view content type	5	view_contenttype
21	Can add session	6	add_session
22	Can change session	6	change_session
23	Can delete session	6	delete_session
24	Can view session	6	view_session
25	Can add alternative course groups	7	add_alternativecoursegroups
26	Can change alternative course groups	7	change_alternativecoursegroups
27	Can delete alternative course groups	7	delete_alternativecoursegroups
28	Can view alternative course groups	7	view_alternativecoursegroups
29	Can add courses	8	add_courses
30	Can change courses	8	change_courses
31	Can delete courses	8	delete_courses
32	Can view courses	8	view_courses
33	Can add departments	9	add_departments
34	Can change departments	9	change_departments
35	Can delete departments	9	delete_departments
36	Can view departments	9	view_departments
37	Can add faculties	10	add_faculties
38	Can change faculties	10	change_faculties
39	Can delete faculties	10	delete_faculties
40	Can view faculties	10	view_faculties
41	Can add majors	11	add_majors
42	Can change majors	11	change_majors
43	Can delete majors	11	delete_majors
44	Can view majors	11	view_majors
45	Can add programs	12	add_programs
46	Can change programs	12	change_programs
47	Can delete programs	12	delete_programs
48	Can view programs	12	view_programs
49	Can add auth group	14	add_authgroup
50	Can change auth group	14	change_authgroup
51	Can delete auth group	14	delete_authgroup
52	Can view auth group	14	view_authgroup
53	Can add auth group permissions	15	add_authgrouppermissions
54	Can change auth group permissions	15	change_authgrouppermissions
55	Can delete auth group permissions	15	delete_authgrouppermissions
56	Can view auth group permissions	15	view_authgrouppermissions
57	Can add auth permission	16	add_authpermission
58	Can change auth permission	16	change_authpermission
59	Can delete auth permission	16	delete_authpermission
60	Can view auth permission	16	view_authpermission
61	Can add auth user	17	add_authuser
62	Can change auth user	17	change_authuser
63	Can delete auth user	17	delete_authuser
64	Can view auth user	17	view_authuser
65	Can add auth user groups	18	add_authusergroups
66	Can change auth user groups	18	change_authusergroups
67	Can delete auth user groups	18	delete_authusergroups
68	Can view auth user groups	18	view_authusergroups
69	Can add auth user user permissions	19	add_authuseruserpermissions
70	Can change auth user user permissions	19	change_authuseruserpermissions
71	Can delete auth user user permissions	19	delete_authuseruserpermissions
72	Can view auth user user permissions	19	view_authuseruserpermissions
73	Can add courses per major	13	add_coursespermajor
74	Can change courses per major	13	change_coursespermajor
75	Can delete courses per major	13	delete_coursespermajor
76	Can view courses per major	13	view_coursespermajor
77	Can add django admin log	20	add_djangoadminlog
78	Can change django admin log	20	change_djangoadminlog
79	Can delete django admin log	20	delete_djangoadminlog
80	Can view django admin log	20	view_djangoadminlog
81	Can add django content type	21	add_djangocontenttype
82	Can change django content type	21	change_djangocontenttype
83	Can delete django content type	21	delete_djangocontenttype
84	Can view django content type	21	view_djangocontenttype
85	Can add django migrations	22	add_djangomigrations
86	Can change django migrations	22	change_djangomigrations
87	Can delete django migrations	22	delete_djangomigrations
88	Can view django migrations	22	view_djangomigrations
89	Can add django session	23	add_djangosession
90	Can change django session	23	change_djangosession
91	Can delete django session	23	delete_djangosession
92	Can view django session	23	view_djangosession
93	Can add faculty	29	add_faculty
94	Can change faculty	29	change_faculty
95	Can delete faculty	29	delete_faculty
96	Can view faculty	29	view_faculty
97	Can add department	39	add_department
98	Can change department	39	change_department
99	Can delete department	39	delete_department
100	Can view department	39	view_department
101	Can add semester	38	add_semester
102	Can change semester	38	change_semester
103	Can delete semester	38	delete_semester
104	Can view semester	38	view_semester
105	Can add course	30	add_course
106	Can change course	30	change_course
107	Can delete course	30	delete_course
108	Can view course	30	view_course
109	Can add qualification	40	add_qualification
110	Can change qualification	40	change_qualification
111	Can delete qualification	40	delete_qualification
112	Can view qualification	40	view_qualification
113	Can add program	33	add_program
114	Can change program	33	change_program
115	Can delete program	33	delete_program
116	Can view program	33	view_program
117	Can add degree	31	add_degree
118	Can change degree	31	change_degree
119	Can delete degree	31	delete_degree
120	Can view degree	31	view_degree
121	Can add major	37	add_major
122	Can change major	37	change_major
123	Can delete major	37	delete_major
124	Can view major	37	view_major
125	Can add degree parent course group	35	add_degreeparentcoursegroup
126	Can change degree parent course group	35	change_degreeparentcoursegroup
127	Can delete degree parent course group	35	delete_degreeparentcoursegroup
128	Can view degree parent course group	35	view_degreeparentcoursegroup
129	Can add major parent course group	43	add_majorparentcoursegroup
130	Can change major parent course group	43	change_majorparentcoursegroup
131	Can delete major parent course group	43	delete_majorparentcoursegroup
132	Can view major parent course group	43	view_majorparentcoursegroup
133	Can add degree course group	44	add_degreecoursegroup
134	Can change degree course group	44	change_degreecoursegroup
135	Can delete degree course group	44	delete_degreecoursegroup
136	Can view degree course group	44	view_degreecoursegroup
137	Can add major course group	36	add_majorcoursegroup
138	Can change major course group	36	change_majorcoursegroup
139	Can delete major course group	36	delete_majorcoursegroup
140	Can view major course group	36	view_majorcoursegroup
141	Can add courses per degree	28	add_coursesperdegree
142	Can change courses per degree	28	change_coursesperdegree
143	Can delete courses per degree	28	delete_coursesperdegree
144	Can view courses per degree	28	view_coursesperdegree
145	Can add elective	45	add_elective
146	Can change elective	45	change_elective
147	Can delete elective	45	delete_elective
148	Can view elective	45	view_elective
149	Can add faq	46	add_faq
150	Can change faq	46	change_faq
151	Can delete faq	46	delete_faq
152	Can view faq	46	view_faq
153	Can add faq section	47	add_faqsection
154	Can change faq section	47	change_faqsection
155	Can delete faq section	47	delete_faqsection
156	Can view faq section	47	view_faqsection
157	Can add glossary	48	add_glossary
158	Can change glossary	48	change_glossary
159	Can delete glossary	48	delete_glossary
160	Can view glossary	48	view_glossary
161	Can add advisor	42	add_advisor
162	Can change advisor	42	change_advisor
163	Can delete advisor	42	delete_advisor
164	Can view advisor	42	view_advisor
165	Can add student	41	add_student
166	Can change student	41	change_student
167	Can delete student	41	delete_student
168	Can view student	41	view_student
169	Can add advisor question	49	add_advisorquestion
170	Can change advisor question	49	change_advisorquestion
171	Can delete advisor question	49	delete_advisorquestion
172	Can view advisor question	49	view_advisorquestion
173	Can add auth group	50	add_authgroup
174	Can change auth group	50	change_authgroup
175	Can delete auth group	50	delete_authgroup
176	Can view auth group	50	view_authgroup
177	Can add auth group permissions	51	add_authgrouppermissions
178	Can change auth group permissions	51	change_authgrouppermissions
179	Can delete auth group permissions	51	delete_authgrouppermissions
180	Can view auth group permissions	51	view_authgrouppermissions
181	Can add auth permission	52	add_authpermission
182	Can change auth permission	52	change_authpermission
183	Can delete auth permission	52	delete_authpermission
184	Can view auth permission	52	view_authpermission
185	Can add auth user	53	add_authuser
186	Can change auth user	53	change_authuser
187	Can delete auth user	53	delete_authuser
188	Can view auth user	53	view_authuser
189	Can add auth user groups	54	add_authusergroups
190	Can change auth user groups	54	change_authusergroups
191	Can delete auth user groups	54	delete_authusergroups
192	Can view auth user groups	54	view_authusergroups
193	Can add auth user user permissions	55	add_authuseruserpermissions
194	Can change auth user user permissions	55	change_authuseruserpermissions
195	Can delete auth user user permissions	55	delete_authuseruserpermissions
196	Can view auth user user permissions	55	view_authuseruserpermissions
197	Can add django admin log	56	add_djangoadminlog
198	Can change django admin log	56	change_djangoadminlog
199	Can delete django admin log	56	delete_djangoadminlog
200	Can view django admin log	56	view_djangoadminlog
201	Can add django content type	57	add_djangocontenttype
202	Can change django content type	57	change_djangocontenttype
203	Can delete django content type	57	delete_djangocontenttype
204	Can view django content type	57	view_djangocontenttype
205	Can add django migrations	58	add_djangomigrations
206	Can change django migrations	58	change_djangomigrations
207	Can delete django migrations	58	delete_djangomigrations
208	Can view django migrations	58	view_djangomigrations
209	Can add django session	59	add_djangosession
210	Can change django session	59	change_djangosession
211	Can delete django session	59	delete_djangosession
212	Can view django session	59	view_djangosession
\.


--
-- Data for Name: auth_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_user (id, password, last_login, is_superuser, username, first_name, last_name, email, is_staff, is_active, date_joined) FROM stdin;
2	pbkdf2_sha256$1000000$H2Z3vVuYT559nhXC9rV9py$MzxzYX3idzCy4Knt9ivqdPKWN9V4rlYx2vLVr6PXhRc=	\N	t	TimLow				t	t	2025-08-21 14:26:19+02
1	pbkdf2_sha256$1000000$OAJZh3TkhfDOFZPXhZKAhI$yTHR2t2pYcLXWJ6AC7Px/EpLUYioOp/K3cc+3d9SDos=	2025-08-30 13:13:50.984456+02	t	myAdvisorAdmin			myadvisor@myadvisor.com	t	t	2025-07-12 14:52:58+02
\.


--
-- Data for Name: auth_user_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_user_groups (id, user_id, group_id) FROM stdin;
\.


--
-- Data for Name: auth_user_user_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.auth_user_user_permissions (id, user_id, permission_id) FROM stdin;
\.


--
-- Data for Name: course; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.course (course_name, nqf_credits, nqf_level, convener, course_entry_requirements, corequisites, objective, course_outline, lecture_times, dp_requirements, assessment, notes, course_code, department, semester, department_id, semester_id) FROM stdin;
TEST COURSE	18	5	Dr M Flanegan								The best course	TST1010F	TST	F	TST	F
COMPUTER SCIENCE 1015	18	5	A Safla and K Prag	At least 70% for NSC Mathematics. Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to CSC1010H from week 7.			This course is an introduction to problem solving, algorithm development and programming in the Python language. It includes fundamental programming constructs and abstractions, sorting and searching techniques, and machine representations of data. The practical component covers input/output, conditionals, loops, strings, functions, arrays, lists, dictionaries, recursion, text files and exceptions in Python. Students are taught testing and debugging, as well as sorting and searching algorithms, algorithm complexity and equivalence classes. Number systems, binary arithmetic, Boolean algebra and logic gates are also introduced. The course is offered in a blended-learning format: students are provided with a set of online video lectures and contact time is in a tutorial/practical format aimed at reinforcing the principles introduced in the online lectures and giving students time to do exercises under the supervision of tutors.	4th or 5th period once per week, Tutorials: One per week, replacing one lecture, Practicals: One per week, Monday, Tuesday, Wednesday or Thursday 14h00 - 16h00 or 16h00 - 18h00	Minimum of 45% aggregate in practical work.	Theory tests 15%; practical tests and practical assignments 25%; June examination 2 hours 60%. Subminima: 45% for practicals, 45% on weighted average of theory tests and examination.		CSC1015F	CSC	F	CSC	F
MOLECULAR BIOSCIENCE	24	6	To be advised	CEM1000W or equivalent, BIO1000F and BIO1004S (or equivalents)	\N	\N	This course will introduce students to the concepts of biological chemistry fundamental to understanding the distinctive properties of living matter and biological processes. The course covers core principles in three major areas, (i) the structural chemistry of key components of living matter and the relationship between chemical structure and biological function of these components, (ii) metabolism - the nature of chemical reactions that occur in living matter and (iii) the chemistry of molecules and processes involved in the transmission of biological information. In addition to these core principles, students will learn about scientific method, basic biochemistry/molecular biology techniques and experimental design.	Monday - Friday, 5th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests and assignments count 40%; practicals count 10%; one three-hour paper written in June counts 50%. A subminimum of 40% in the examination is required.	Entrance is limited to 140 students. Registration for this course is provisional until confirmed by the department. Should the limit be exceeded students will be ranked on CEM1000W (or equivalent) marks. No semester abroad students will be admitted to this course.	MCB2021F	MCB	F	MCB	F
METABOLISM & BIOENGINEERING	24	6	Dr M Williams	MCB2020F and MCB2021F	\N	\N	This course will introduce students to some key aspects of metabolic energy production in eukaryotic and prokaryotic systems. It aims to raise awareness of issues at the forefront of the discipline and give students the ability to dissect problems in order to identify solutions. Topics covered may include carbohydrate and lipid metabolism, metabolic integration, the metabolic diversity in Bacteria and Archaea, and bioengineering in bacteria and plants.	Monday - Friday, 5th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests and assignments count 40%; practicals count 10%; one three-hour paper written in November counts 50%. A subminimum of 40% in the examination is required.	Entrance is limited to 140 students.	MCB2022S	MCB	S	MCB	S
FUNCTIONAL GENETICS	24	6	Professor N Illing	MCB2020F and MCB2021F	\N	\N	The course lays the foundation for the major in genetics, and shows how the tools of classical and molecular genetics can be applied to understanding the regulation of gene expression, cell differentiation and patterning in bacteria and eukaryotes. Concepts covered include gene mapping, forward and reverse genetics; microbial genetics, including regulation of the lac operon; CRISPR/ Cas9 gene editing and DNA repair; alternative splicing and sex-determination; epigenetic mechanisms used in dosage compensation; the genetic analysis of cell cycle regulation; stem cell technology and axis determination in Drosophila.	Monday - Friday, 4th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests and assignments count 40%; practicals count 10%; one three-hour paper written in November counts 50%. A subminimum of 40% in the examination is required. NOTE: All MCB majors must complete MCB3012Z (Research project in Molecular and Cell Biology) during the second semester. This course replaces practical classes for both third year second semester MCB courses.	Entrance is limited to 140 students	MCB2023S	MCB	S	MCB	S
MATHEMATICS DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	MAM5000W	MAM	W	MAM	W
TERTIARY MATHEMATICS EDUCATION DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front section of the faculty handbook.	\N	\N	\N	\N	MAM5019W	MAM	W	MAM	W
1ST YEAR ELECTIVE NUMBER 2	18	1										ELEC1002	\N	\N	\N	\N
MATHEMATICS HONOURS (EXTENDED1)	80	8	Dr F Ebobisse-Bille	(i) 60% or higher for MAM3000W, and, (ii) The average of the four marks for MAM1000W, MAM1019H, MAM2000W, and MAM3000W should be 60% or higher. In all cases acceptance is subject to individual approval by the Head of Department.	\N	\N	This course, together with MAM4110W and MAM4014W, covers the content of MAM4000W over two years. Students in this course will do two core modules in the first semester and two more modules in the second semester (total 80 credits).	\N	\N	As per MAM4000W	\N	MAM4100W	MAM	W	MAM	W
COMPUTER SCIENCE 1015	18	5	A Safla and K Prag	At least 70% for NSC Mathematics. Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to CSC1010H from week 7.			This course is an introduction to problem solving, algorithm development and programming in the Python language. It includes fundamental programming constructs and abstractions, sorting and searching techniques, and machine representations of data. The practical component covers input/output, conditionals, loops, strings, functions, arrays, lists, dictionaries, recursion, text files and exceptions in Python. Students are taught testing and debugging, as well as sorting and searching algorithms, algorithm complexity and equivalence classes. Number systems, binary arithmetic, Boolean algebra and logic gates are also introduced. The course is offered in a blended-learning format: students are provided with a set of online video lectures and contact time is in a tutorial/practical format aimed at reinforcing the principles introduced in the online lectures and giving students time to do exercises under the supervision of tutors.	4th or 5th period once per week, Tutorials: One per week, replacing one lecture, Practicals: One per week, Monday, Tuesday, Wednesday or Thursday 14h00 - 16h00 or 16h00 - 18h00	Minimum of 45% aggregate in practical work.	Theory tests 15%; practical tests and practical assignments 25%; June examination 2 hours 60%. Subminima: 45% for practicals, 45% on weighted average of theory tests and examination.		CSC1015S	CSC	S	CSC	S
DEFENCE & DISEASE	36	7	Professor J Hapgood	MCB2020F, MCB2021F and MCB2022S or MCB2023S	\N	\N	This course will initially examine the innate immune systems of plants. The focus will switch to the adaptive immune system, with emphasis on three major disease challenges in South Africa; namely, HIV, TB and malaria. Host-pathogen interactions will also be discussed, with a focus on viruses and how they infect mammals. Finally, the course will examine strategies to produce vaccines that enable immunity to viral infection.	Monday - Friday, 5th period	None	Tests count 40%; one 3-hour examination written in November counts 60%. A subminimum of 40% in the examination is required.	\N	MCB3024S	MCB	S	MCB	S
STRUCTURAL & CHEMICAL BIOLOGY	36	7	Dr R Hurdayal	MCB2020F, MCB2021F and MCB2022S or MCB2023S	\N	\N	This course addresses how modern techniques of structural and chemical biology are being used to solve biological problems. It draws on multiple aspects of macromolecular biochemistry including nucleic acid structure and interactions, signalling proteins and membrane proteins, and demonstrates how this knowledge can be used in drug discovery and protein design in biotechnology. Topics include: mechanisms of reversible and irreversible enzyme inhibitors, ligand binding, protein folding, molecular basis for protein function, regulation of protein activity, cell signalling and proteomics.	Monday - Friday, 5th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests count 40%; practicals, tutorials essays and assignments count 10%; one 3-hour examination written in June counts 50%. A subminimum of 40% in the examination is required.	\N	MCB3025F	MCB	F	MCB	F
MOLECULAR GENETICS AND GENOMICS	36	7	Associate Professor C O’Ryan	MCB2020F, MCB2021F and MCB2022S or MCB2023S	\N	\N	This course explores various topics in molecular genetics covering humans, plants, bacteria, viruses and mobile genetic elements (MGEs). Focus is given to understanding genetic mechanisms by studying genes, proteins, antisense RNA, sRNA and the role they play in regulatory and biochemical processes. Topics include plasmid biology, regulation of viral lifecycles, bacterial biosynthetic pathways, human genetic disorders, transgenic plants and metagenomics among others. Different and cutting-edge tools in modern day molecular biology are taught with an emphasis on data analyses and interpretation and these include bioinformatics (DNA sequence analysis, assembly, annotation, databases, BLAST, primer design), phylogenetics, Next generation sequencing, RNA sequencing and genome projects.	Monday - Friday, 4th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests count 40%; practicals, tutorials, essays and assignments count 10%; one 3-hour examination written in June counts 50%. A subminimum of 40% in the examination is required.	\N	MCB3026F	MCB	F	MCB	F
MOLECULAR & CELL BIOLOGY HONOURS	160	8	Dr T Oelgeschläger	BSc degree with a major in Biochemistry, Biotechnology, Genetics or Microbiology. Molecular-based courses are highly recommended. Preference may be given to UCT graduates. Entrance is limited to 16 students, dependent on availability of supervisors and funding. Acceptance will be at the discretion of the Head of Department who will consider quality of senior course results and material covered in the undergraduate curriculum.	\N	\N	The first part of this course consists of a ten-week techniques course including gel electrophoresis, recombinant DNA technology, PCR, sequencing, bioinformatics, gene expression, protein isolation and analysis, confocal and electron microscopy, and large data set analysis. After successful completion of the techniques course, a six-month research project on a specific topic will be undertaken.	\N	Techniques examination must be passed at 50% to continue course.	Two 3-hour techniques examinations written in May, and the techniques course assignments, count 20%; essays count 15%; oral presentations count 20%; statistics module 1%, one 4-hour examination written in November counts 10%; project counts 34%. The research project must be passed at 50%. These component parts of the course will be combined in a final overall mark which will be reflected against the course code MCB4002W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code MCB4002W will not carry a NQF credit value, students will be concurrently registered for MCB4003W (coursework component of 96 NQF credits) and MCB4004W (research project of 64 NQF credits). Entrance is limited to 16 students.	MCB4002W	MCB	W	MCB	W
BUSINESS ANALYSIS & GOVERNANCE I	13	7	Jahangir Allie	Please refer to the "Entry to CA specific courses".	\N	\N	The course develops the finance foundations in a highly contextualised manner through the analysis of the financial information. The focus of the course is the decisions made by companies within the financial management frameworks of a company. The content comprises : business analysis, capital structure, valuations, and the distribution decision analysed through real world businesses.	Tuesday at 3PM and Thursday at 11AM	Attendance of 75% of tutorials. Weighted average 40% average of individual components. Completion of group and individual components.	50% Coursework. 50% Exam.	\N	ACC3001F	ACC	F	ACC	F
MOLECULAR & CELL BIOLOGY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook	\N	\N	\N	\N	MCB5005W	MCB	W	MCB	W
MOLECULAR & CELL BIOLOGY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies	\N	\N	\N	\N	MCB6002W	MCB	W	MCB	W
PRINCIPLES OF OCEANOGRAPHY	24	6	Associate Professor K Altieri	GEO1009F, CEM1000W, or permission of the convener	\N	\N	An introduction to the principles of oceanography, including an introduction to physical, biological and chemical oceanography, marine geology, and the ocean atmosphere system. The course comprises multiple modules, which cover the above topics. Oceanographic instrumentation and methods of data analysis will be covered in the tutorials and practicals.	Monday - Friday, 4th period	Attendance at practicals and a class mark of at least 40%.	Practicals and tests count 40%; one 3-hour examination written in June/July counts 40%. A subminimum of 40% in the examination is required.	\N	SEA2004F	SEA	F	SEA	F
MARINE SYSTEMS	24	6	Associate Professor S E Fawcett	GEO1009F, CEM1000W, SEA2004F, or permission of the convener	\N	\N	Building on the Principles of Oceanography SEA2004F course, this more advanced course will cover the main ocean and atmosphere systems, with a particular emphasis on their biogeochemical functioning. This includes an introduction to the major marine biogeochemical cycles, seawater carbonate chemistry, phytoplankton-nutrient interactions and growth kinetics, surface ocean-lower atmosphere interactions, and an introduction to Earth system dynamics. The physical forcings and their biogeochemical and ecosystem responses will be quantitatively illustrated for upwelling systems, oligotrophic systems, coastal systems around South Africa, and the Southern Ocean. Emphasis will be placed on treating the systems in an integrative manner. Methods of data sampling and analysis, and computation of biogeochemical pools, rates and feedbacks will be covered in the tutorials and practicals.	Monday - Friday, 4th period	Attendance of lectures and practicals, and a class mark of at least 40%.	Practicals, tests, and in-class activities count 60%; a final examination written in October/November counts 40%. A subminimum of 40% in the examination is required.	\N	SEA2005S	SEA	S	SEA	S
OCEAN & ATMOSPHERE DYNAMICS	36	7	Professor M Vichi	MAM1031F+MAM1032S (recommended) or equivalent, PHY1031F or equivalent, or permission of the convener.	\N	\N	The Ocean & Atmosphere dynamics course will begin to specialise in advanced material related to physical oceanography, atmospheric science and climate. These topics will include a quantitative approach to ocean/atmosphere dynamics, theories of circulation and the development of ocean and atmospheric weather systems, coupled ocean/atmosphere processes, interactions and feedbacks with the carbon cycle in the earth system and climate change. Methods of analysis of both observations and model data will be covered in the tutorials and practicals.	Monday - Friday, 3rd period	Attendance at tutorials and practicals, and a class mark of at least 40%.	Tutorials/practicals and tests count 50%; one 3-hour examination written in June/July counts 50%. A subminimum of 40% in the examination is required.	\N	SEA3004F	SEA	F	SEA	F
MICROECONOMICS I	18	5	N Narker	Admission to degree. National Senior Certificate: a pass (5) in Mathematics.	There is no co-requisite, but students are strongly advised to do a formal mathematics course (MAM1010 or equivalent). Not having done such a course will preclude entry to second year Economics.		This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	Tuesday, Wednesday, Thursday & Friday 12h00 – 13h00. Students are advised to reserve a Monday slot for tutorial sessions.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework 50%; Exam 50%. The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The ECO1010F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1010S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1010S	ECO	S	ECO	S
PHYSICS THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	PHY6000W	PHY	W	PHY	W
OCEAN & ATMOSPHERE SCIENCE HONOURS	160	8	Dr M.N Ragoasha	A BSc degree with a major/specialisation in Ocean & Atmosphere Science or in a related discipline. CEM1000W or equivalent is a prerequisite. Acceptance will be at the discretion of the Head of Department who will consider quality of final year results, material covered in the undergraduate curriculum, and possibly referee reports. Preference may be given to UCT graduates who meet the course entry requirements.	\N	\N	Honours students intending careers in ocean and atmosphere science will complete a full set of modules and a research project. Honours students from Environmental & Geographical Science, Applied Mathematics, and other physical science and engineering departments, are encouraged to attend selected modules. The curriculum includes lecture-tutorials, seminars and practical work in advanced oceanography, meteorology and climate, an introduction to modelling and data analysis. Practical work includes fieldwork at sea and may include dive training (class 4 diving qualification, at the students own cost if they choose to do the dive course). Student performance in each module may be assessed by project work, seminar presentations, written assignments and examinations, together making up 65% of the final mark. In the second half of the year the research project will take priority. Students will be expected to present a seminar on their projects at the year’s end.	\N	\N	Module assessment by submission of a research portfolio, which includes fieldtrip reports, skills examination and formal test results. A weighted average of the continuous assessment of reports and tests counts 65% of the final mark; the research project counts 35% of the final mark. The research project must be passed at 50%. These component parts of the course will be combined in a final overall mark which will be reflected against the course code SEA4001W: each of these components must be passed separately for the award of the degree.	Since the code SEA4001W will not carry a NQF credit value, students will be concurrently registered for SEA4003W (coursework component of 112 NQF credits) and SEA4004W (research project of 48 NQF credits).	SEA4001W	SEA	W	SEA	W
FOUNDATIONS OF SOUTH AFRICAN LAW	36	5	Professor AJ Barnard-Naudé	Undergraduate LLB students: concurrent registration with PVL1004F \r\nand  PVL1008H.  Graduate  LLB  students:  concurrent  registration  with  PVL1004F,  PVL1008H, \r\nPBL2000W, PVL2002H, PVL2003H.			An introduction to the South African legal system is covered in the first section of the course. This is \r\nfollowed by an introduction to critical post-apartheid jurisprudence, including transformative \r\nconstitutionalism  and  decolonisation.  An  outline  of  the  development  of  public  law  culture,  viewed \r\nthrough the lens of the rule of law, follows in the second semester. Finally, a section on the rules of \r\ninterpretation of law and the practical application of those rules, concludes the course.		None	Coursework 50%, final examination 50%.	Preliminary Level, whole year course, three lectures per week.	PVL1003W	PVL	W	PVL	W
OCEAN & ATMOSPHERE SCIENCE DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	SEA5000W	SEA	W	SEA	W
MATHEMATICS 1110 FOR CADP	18	5	S Torr	NSC level 5 in Mathematics, or 60% on Higher Grade Mathematics (SC).	\N	\N	The aim of this course is to introduce topics in mathematics that are of interest to Commerce students, with applications to economics. Introductory financial mathematics including compound interest and annuities, functions, limits, differential calculus and applications of the derivative including graph sketching and Newton’s Method, introduction to integral calculus and techniques of integration.	Monday - Friday, 1st period.	Minimum of 30% in class tests and satisfactory attendance at lectures and tutorials.	Year mark up to 40% Final examination 1 x 2 hour paper	(for EDU Commerce Academic Development students)	MAM1110F	MAM	F	MAM	F
MICROECONOMICS I	18	5	N Narker	Admission to degree. National Senior Certificate: a pass (5) in Mathematics.	There is no co-requisite, but students are strongly advised to do a formal mathematics course (MAM1010 or equivalent). Not having done such a course will preclude entry to second year Economics.		This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	Tuesday, Wednesday, Thursday & Friday 09h00 – 10h00; 10h00 – 11h00; 11h00 – 12h00; 12h00 – 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework 50%; Exam 50%. The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	Note: The ECO1010F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1010S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1010F	ECO	F	ECO	F
PHYSICAL OCEANOGRAPHY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	SEA5001W	SEA	W	SEA	W
DISTRIBUTED SCIENTIFIC COMPUTING	12	9	Professor R Simmonds	Admission into the Master's degree specialising in Computer Science, or permission from the course convener. A basic understanding of computer networking and software systems.	\N	\N	The objective is to provide an understanding of the basic components used to build Grid and Cloud computing systems, with a focus on how these can support Scientific Computing. This course gives an overview of the components that make up Grid and Cloud computing environments. These include the components used to build distributed data and computing grids and the various “as a Service” systems referred to as Cloud computing. It also looks at how these are used for a range of activities, including supporting large scale Scientific Computing.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC5022Z	CSC	Z	CSC	Z
MACROECONOMICS I	18	5	G Van der Rede	A minimum mark of 50% for ECO1010F/S or ECO1110F/S. ECO1010F/S may be taken concurrently with ECO1011F/S if ECO1010F/S has been previously attempted.			This course is an introductory level course in macroeconomic theory and policy. Macroeconomics studies the aggregate behaviour of the economy. The list of topics covered include gross domestic product, economic growth, unemployment, inflation, exchange rates, balance of payments, business cycles, fiscal and monetary policy tools and objectives. The course will build on macroeconomic relationships to develop basic models explaining various interactions within the economy, providing students with a framework for understanding and interrogating the workings of the economy. The course emphasizes relevant and current issues in the context of South African economic history. We also explore South Africa’s relationship with the rest of the world.	ECO1011F 15h00 – 16h00 Monday, Tuesday, Wednesday & Thursday. ECO1011S Tuesday, Wednesday, Thursday & Friday 09h00 – 10h00; 10h00 – 11h00; 11h00 – 12h00; 12h00 – 13h00. Students are advised to reserve a Monday slot for tutorial sessions.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination	Coursework: 50%; Exam: 50%. The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The ECO1011F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1011S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1011F	ECO	F	ECO	F
DATA SCIENCE MINOR DISSERTATION	90	9	Professor J Gain	Successful completion of the coursework component of the Master's specialising in Data Science.	\N	\N	The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on an analysis of large data sets from Physics, Astronomy, Medicine, Finance or other areas of application using methodology learnt in coursework component of degree. Alternatively, the dissertation component may focus on methodological developments in Computer Sciences required for the analysis of large amount of data. PhD	\N	\N	\N	\N	CSC5009W	CSC	W	CSC	W
OPERATIONAL OCEANOGRAPHY COURSEWORK	50	9	Professor M Vichi	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	This course is a component of the Applied Ocean Sciences Master's coursework (refer to BIO5012W). Co-requisites are BIO5012W, BIO5013F, STA5014Z and a minor dissertation code chosen from the ones listed in the BIO5012W handbook. Changes in the dissertation code are allowed according to the student background and prior to consultation with the course conveners.	\N	This course is comprised of 4 modules focusing on the usage and provision of marine services that describe the ocean physical and biogeochemical state through observational and modeling components. The course covers the global ocean and coastal observing systems, the usage of ocean diagnostics and climate indicators as well as an introduction to the major monitoring techniques for physical and biogeochemical oceanography. Qualified students will have the possibility of participating to an open ocean research cruise in July. In addition, students will choose at least two elective courses, chosen from a range of modules offered in both disciplinary streams. They provide the student the opportunity to explore new areas, or look at more specific disciplinary backgrounds in the vast subject of ocean sciences. The list and details of these courses will be made available at the opening of each registration period in the BIO5012W handbook on the Marine and Antarctic Research Centre for Innovation and Sustainability (MARIS) website.	\N	\N	Every module is assessed independently either with a class test or individual project assignments. The syllabus and the relative weight for each module are described in a handbook that will be made available on the BIO5012W website (hosted by the Marine and Antarctic Research Centre for Innovation and Sustainability - MARIS).	\N	SEA5011F	SEA	F	SEA	F
APPLIED OCEAN SCIENCES MINOR DISSERTATION	90	9	Professor M Vichi (SEA) and a representative from BIO	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	BIO5012W, BIO5013F, BIO5014F/SEA5011F, STA5014Z	\N	The minor dissertation, which forms 50% of the overall degree, is based on a six-month supervised research project. The choice of project will be determined by the student's prior qualification and in agreement with the course conveners and supervisors. The dissertation should be submitted at the end of January, with the possibility of extension to June of the next year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree. A distinction in the minor dissertation can be attained only if there is a distinction in the coursework component.	\N	SEA5012W	SEA	W	SEA	W
OCEAN & ATMOSPHERE SCIENCE THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision, which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	SEA6000W	SEA	W	SEA	W
GENERAL PHYSICS A	18	5	Dr S M Wheaton	At least 60% for NSC Physical Science. Note: Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to PHY1023H from week 7.	\N	\N	PHY1031F is an algebra-based introductory course for Science students who do not intend proceeding to in Physics. Some calculus may be used. The course includes the following topics: Mechanics: vectors, kinematics, forces, dynamics, momentum, impulse, work, energy, power, collisions, rotation, rotational dynamics, torque, angular momentum, static equilibrium, gravitation. Properties of matter: elasticity, hydrostatics, hydrodynamics. Vibrations and waves: simple harmonic motion, damped oscillations, forced oscillations, resonance, travelling waves, superposition, standing waves, sound waves, sound intensity and Doppler Effect.	Monday - Friday, 3rd period	Minimum of 40% for the class record; including 50% in laboratory assessment.	Class record (weekly problem sets, class tests and laboratory record) counts 50%; one 2-hour written examination in June counts 50%.	Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to PHY1023H from week 7. Course outline: PHY1031F is an algebra-based introductory course for Science students who do not intend proceeding to in Physics. Some calculus may be used. The course includes the following topics: Mechanics: vectors, kinematics, forces, dynamics, momentum, impulse, work, energy, power, collisions, rotation, rotational dynamics, torque, angular momentum, static equilibrium, gravitation. Properties of matter: elasticity, hydrostatics, hydrodynamics. Vibrations and waves: simple harmonic motion, damped oscillations, forced oscillations, resonance, travelling waves, superposition, standing waves, sound waves, sound intensity and Doppler Effect. Lecture times: Monday - Friday, 3rd period DP requirements: Minimum of 40% for the class record; including 50% in laboratory assessment. Assessment: Class record (weekly problem sets, class tests and laboratory record) counts 50%; one 2-hour written examination in June counts 50%.	PHY1031F	PHY	F	PHY	F
MATTER & INTERACTIONS	36	5	Professor A Buffler	At least 60% for NSC Physical Science. MAM1000W or both MAM1031F & MAM1032S (or equivalent) must have been passed or be taken concurrently. Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to PHY1031F or PHY1023H from week 7.	\N	\N	PHY1004W is an advanced calculus-based introductory course for Science students intending to continue with second-year Physics. It features the modelling of physical systems from fundamental principles, and computational problem solving using Python. The course includes the following topics: Modern mechanics: Conservation laws, the momentum principle, atomic nature of matter, conservation of energy, energy in macroscopic systems, energy quantization, multi-particle systems, exploring the nucleus, angular momentum, entropy. Electric and magnetic interactions: Electric fields, electric potential, magnetic fields, electric circuits, capacitance, resistance, magnetic force, Gauss' Law, Ampere's Law, Faraday's Law, induction, electromagnetic radiation, waves and particles.	Monday - Friday, 3rd period	Minimum of 40% in class record, including 50% in laboratory assessment.	Class record (weekly problem sets, class tests and laboratory record) counts 50%; one 2-hour examination in June counts 25%; one 2-hour examination in November counts 25%.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at www.phy.uct.ac.za. (A tablet or “netbook” will not be suitable). The course convener will provide details of additional software (open source) required.	PHY1004W	PHY	W	PHY	W
DATA SCIENCE FOR PARTICLE PHYSICS	12	9	Dr J M Keaveney	Core modules of the Masters course in Data Science.	\N	\N	This course introduces students to the important computational aspects of high-energy nuclear and particle physics research. Using examples from current research at the European Organization for Nuclear Research (CERN), the students are introduced to: the basic principles of high- energy physics, the Grid computing model employed by the Worldwide LHC Computing Grid (WLCG), the simulation of interactions between subatomic particles and their detection, the ROOT data analysis tool used by all the large high-energy physics collaborations, the signal extraction and significance estimation techniques employed by the most recent particle discoveries including concepts like nuisance parameters and the look-elsewhere effect.	\N	50% average for the two projects.	Two projects: 25% each. Practical 'take-home' Computing examination: 50%. A sub- minimum of 50% for each of the project and examination components will be required.	\N	PHY5007Z	PHY	Z	PHY	Z
MACROECONOMICS	18	5	G Van der Rede	A minimum mark of 50% for ECO1010F/S or ECO1110F/S. ECO1010F/S may be taken concurrently with ECO1011F/S if ECO1010F/S has been previously attempted.			This course is an introductory level course in macroeconomic theory and policy. Macroeconomics studies the aggregate behaviour of the economy. The list of topics covered include gross domestic product, economic growth, unemployment, inflation, exchange rates, balance of payments, business cycles, fiscal and monetary policy tools and objectives. The course will build on macroeconomic relationships to develop basic models explaining various interactions within the economy, providing students with a framework for understanding and interrogating the workings of the economy. The course emphasizes relevant and current issues in the context of South African economic history. We also explore South Africa’s relationship with the rest of the world.	ECO1011F 15h00 – 16h00 Monday, Tuesday, Wednesday & Thursday. ECO1011S Tuesday, Wednesday, Thursday & Friday 09h00 – 10h00; 10h00 – 11h00; 11h00 – 12h00; 12h00 – 13h00. Students are advised to reserve a Monday slot for tutorial sessions.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination	Coursework: 50%; Exam: 50%. The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The ECO1011F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1011S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1011S	ECO	S	ECO	S
NATURAL LANGUAGE PROCESSING	12	9	Dr J Buys	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	The course will introduce students to fundamental concepts and current approaches in Natural Language Processing. Course content includes: Text preprocessing; Naive Bayes and logistic regression for text classification; Word vectors and distributional semantics; n-gram language models; Sequence labelling with hidden Markov Models; Syntactic parsing; Recurrent neural networks for sequence processing; Encoder-decoder neural networks; Transformers neural networks and contextual embeddings. A selection of Natural Language Processing applications included from: Sentiment analysis, Parts-of-Speech tagging, Named Entity Recognition, machine translation, information extraction and question answering.	\N	None	Exam (take-home): 50%; Assignments: 50%.	This course will not be offered every year.	CSC5035Z	CSC	Z	CSC	Z
PRINCIPLES OF PHYSICS	18	5	Associate Professor D L Taylor	At least 60% for NSC Physical Science. The permission of the Dean or Head of Department is required prior to registration for this course. Notes: 1) This course only begins in week 7 and is intended for students who have been advised to transfer to this course after initially registering for PHY1004W or PHY1031F (see entries for these courses). 2) The course places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning.	\N	\N	PHY1023H is an algebra-based introductory course for Science students. Some calculus may be used. The course includes the following topics: Tools and skills: Essential mathematical, diagrammatic and conceptual tools and skills for Physics, co-ordinate systems, vectors, rates of change, the fundamental forces, mathematical techniques and their relationship with physical phenomena. Mechanics: kinematics, forces, dynamics, momentum, impulse, work, energy, power, collisions, rotation, rotational dynamics, torque, angular momentum, static equilibrium, gravitation. Properties of matter: elasticity, hydrostatics, hydrodynamics. Vibrations and waves: simple harmonic motion, damped oscillations, forced oscillations, resonance, travelling waves, superposition, standing waves, sound waves, sound intensity and Doppler Effect.	Monday - Friday, 3rd period	Minimum of 40% for the class record, including 50% in laboratory assessment.	Class record (weekly problem sets, class tests and laboratory record) counts 50%; one 2-hour written examination in November counts 50%.	Students passing PHY1023H may proceed into PHY1032S. Students who pass PHY1023H and then register for and pass PHY1004W will gain credit for both courses.	PHY1023H	PHY	H	PHY	H
GENERAL PHYSICS B	18	5	Associate Professor H W G Weigert	PHY1031F or PHY1023H	\N	\N	PHY1032S is an algebra-based introductory course usually taken by Science students. Some calculus may be used. The course includes the following topics: Electricity and magnetism: electric charge, electric field, Gauss’ law, electric potential, capacitance, current, current density, emf, resistance, resistivity, networks, magnetic field, Biot Savart law, Ampere’s law, electromagnetic induction, inductance, alternating currents. Thermal physics: temperature, heat, kinetic theory of gases, first and second laws of thermodynamics. Optics: Geometrical optics, polarization, electromagnetic waves, interference, diffraction. Modern physics: atomic structure, quantum physical phenomena, wave-particle duality, X-rays, elementary nuclear physics, radioactivity.	Monday - Friday, 3rd period	Minimum of 40% for the class record, including 50% in laboratory assessment.	Class record (weekly problem sets, class tests and laboratory record) counts 50%; one 2-hour written examination in November counts 50%.	\N	PHY1032S	PHY	S	PHY	S
INTERMEDIATE PHYSICS	48	6	Dr S M Wheaton	PHY1004W, a full in Mathematics, and MAM2000W or (MAM2010F, MAM2011F, MAM2013S and MAM2014S) or (MAM2004H and MAM2047H) or (MAM2010F and MAM2011F and MAM2040F and 1 of MAM2041F, MAM2042S, MAM2043S) as co-requisite.	\N	\N	PHY2004W develops the foundations of a major in Physics and allows continuation to third-year Physics. The theory component features a set of intermediate topics, and the laboratory component develops both experimental and computational skills. The course includes the following topics: Mechanics: Review of Newton’s Laws, inertial and non-inertial frames, transformations, equations of motion for 1D systems, oscillations, resonance, non-linear systems, Euler’s equation, Lagrange’s equation, generalized co-ordinates and constrained systems, Hamiltonian formalism, phase space and Liouville’s theorem, effective potentials, planetary motion, systems of particles, angular momentum, collisions, rigid bodies, simple harmonic motion, resonance, coupled oscillators, wave equation, special relativity, relativistic mechanics. Electromagnetism: Vector calculus (div, grad, curl), electrostatics, special techniques for potentials, electric fields in matter, magnetostatics, magnetic fields in matter, current, Ohm’s law, circuits, electromagnetic induction, electrodynamics, Maxwell’s equations. Quantum Mechanics: The basic assumptions of quantum mechanics, solutions of Schrödinger's equation, properties of wave functions and operators, one-dimensional applications, angular momentum in quantum mechanics, three-dimensional applications, the hydrogen atom, approximate methods. Laboratory: Practical and computational tasks designed to develop advanced skills of experimentation and problem solving within the context of Mechanics, Electromagnetism and Quantum Mechanics.	Monday - Friday, 4th period	Minimum of 40% for the class record; completion of all laboratory reports and 75% of tutorial work and problem sets; attendance at all tests.	Class record (tests, weekly problem sets and laboratory work) counts 50%; one 3-hour examination in June counts 25%; one 3-hour examination in November counts 25%. A subminimum of 40% is required in each of the two examinations.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at www.phy.uct.ac.za. (A tablet or “netbook” will not be suitable). The course convenor will provide details of additional software (open source) required.	PHY2004W	PHY	W	PHY	W
FINANCIAL MANAGEMENT	18	6	P Brijlal	A pass in MAM1010F/S or an equivalent course, a pass in STA1000F/S or an equivalent course, a pass in ACC1006F/S (or ACC1106F) or an equivalent course		This course introduces financial management in a corporate environment. The course has two primary objectives. The first objective is to introduce students to the financial aspects of businesses, financial markets, and the environment in which businesses operate. The second objective is to equip students with the decision-making skills required by modern financial managers.	This course gives students a comprehensive foundation in the discipline and covers key decision- making skills such as: the valuation of future cash flows and risk, capital budgeting decisions, the working capital management and financing decisions, and corporate risk management.	Mondays to Fridays: (FTX2024F: 08h00 - 08h45; (FTX2024S: 11h00 - 11h45 or 12h00 -12h45).	A sub-minimum for coursework of 40% average for class tests and a minimum of 80% for tutorial submissions and tutorial attendances. These requirements will be strictly enforced.	Tests and assignments 40%; final examination 60%.		FTX2024F	FTX	F	FTX	F
ADVANCED PHYSICS	72	7	Dr T W Leadbeater	PHY2004W, and 40% in MAM2000W or (MAM2004H and MAM2047H).	\N	\N	This course completes the major in Physics. The theory component aims to develop advanced skills in problem solving within physics, and includes the following topics: Electromagnetism: Maxwell's equations in vacuum and matter, momentum and angular momentum in electromagnetic fields, electromagnetic waves, wave guides, gauge transformations, retarded potentials, electric and magnetic dipole radiation, special relativity, relativistic kinematics and electrodynamics, electromagnetic field tensor. Thermodynamics and Statistical Physics: Temperature, heat and work, laws of thermodynamics, ensembles and entropy, Boltzmann distribution and Helmholtz free energy, thermal radiation, chemical potential and Gibbs distribution, Fermi-Dirac statistics, electrons in metals, Bose-Einstein statistics, phonons, photons and the black-body distribution, the Bose-Einstein condensate, applications to classical and quantum systems. Applications of Quantum Mechanics: Atomic Physics (atomic structure and spectra, selection rules, spin, fine structure, Zeeman effect, time dependent and independent perturbation theory); Nuclear and Particle Physics (properties of nuclei, nuclear forces, structure, reactions and models, nuclear models, interactions of elementary particles, quarks and leptons, symmetries and the gauge forces); and Solid State Physics (crystal structure, lattice vibrations, electron states in solids, energy band theory, semiconductor physics and devices). The laboratory component includes practical and computational tasks to develop advanced skills of experimentation and scientific report writing.	Monday - Friday, 4th period	Minimum of 40% for the class record; attendance at all tests; completion of all laboratory reports; completion of the project and completion of 75% of tutorials and problem sets.	Class record (tests, weekly problem sets, laboratory work and project) counts 50%; two 2-hour examinations in June count 25%; two 2-hour examinations in November count 25%. A subminimum of 40% exists in the weighted average of the four examinations.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at www.phy.uct.ac.za. (A tablet or “netbook” will not be suitable). The course convenor will provide details of additional software (open source) required.	PHY3004W	PHY	W	PHY	W
PHYSICS HONOURS	160	8	Dr J M Keaveney	The entrance requirement is a BSc degree with a major in Physics. Acceptance will be at the discretion of the Head of Department who will consult the Honours course convenor. Criteria for acceptance include a pass of 60% in PHY3004W, or equivalent; and a pass of 60% in MAM2000W or MAM2046W, or equivalent; and in cases where the Head of Department deems it necessary, favourable referee reports. Enrolment is limited to 15 students. Preference may be given to UCT graduates who meet the course entry requirements.	\N	\N	The Honours course in Physics consists of several modules. Each student needs to design a module package which sums up to at least 12 units, and not more than 14 units. The Research Project (3 units) is compulsory. The compulsory modules (1 unit each) are: Electromagnetism 1, Quantum Mechanics 1 and Statistical Physics. At least five further modules (1 unit each) must be chosen from: Electromagnetism 2, Quantum Mechanics 2, Classical Mechanics, Computational Physics, Particle Physics, Nuclear Physics, Relativistic Quantum Mechanics, Quantum Field Theory, and Solid State Physics. Students are strongly encouraged to include both Electromagnetism 2 and Quantum Mechanics 2 in their module choice. The course starts with a compulsory non-credit bearing module dealing with mathematical tools and skills, and aspects of physics education. Furthermore, the course can be complemented by physics-related modules offered by the Departments of Astronomy, and Mathematics and Applied Mathematics, for example. The choice of modules and research project must be approved by the Head of Physics in consultation with the PHY4000W convener. Details appear on the Physics website: www.phy.uct.ac.za. The Department of Physics is presently reviewing the curriculum of PHY4000W.	\N	30% for class tests and problem sets, and suitable progress in the Research Project.	The pass mark is 50% and is based on an aggregation of the results of all modules, and is further subject to the subminimum criteria of obtaining a minimum mark of 50% in the Research Project, passing two thirds of all modules, and achieving a mark of at least 35% in all but one of the compulsory modules. The Research Project will count 25% of the final mark. These component parts of the course will be combined in a final overall mark which will be reflected against the course code PHY4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code PHY4000W will not carry a NQF credit value, students will be concurrently registered for PHY4006W (coursework component of 120 NQF credits) and PHY4007W (research project of 40 NQF credits).	PHY4000W	PHY	W	PHY	W
SOCIAL ISSUES AND PROFESSIONAL PRACTICE	12	9	T Chimboza	A non-IT honours degree, or equivalent.	None.	\N	1 Identify important social and human factor issues that impact professional behaviour linked to Cyber Security. 2 Research and analyse material and real-world situations that relate to social and human factor issues linked to Cyber Security. 3 Discuss and report the outcomes of investigations. 4 Provide advice and recommendations about how to tackle social and human factor issues linked to Cyber Security	\N	In order to be permitted to sit the final exam a minimum average of 40% on the coursework must be obtained.	2 Assignments (50%) and an Exam (50%).	\N	INF5007Z	INF	Z	INF	Z
PHYSICS DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	PHY5000W	PHY	W	PHY	W
THEORETICAL PHYSICS DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	PHY5001W	PHY	W	PHY	W
TERTIARY PHYSICS EDUCATION DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	PHY5006W	PHY	W	PHY	W
TERTIARY PHYSICS EDUCATION THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	PHY6001W	PHY	W	PHY	W
RESEARCH & INNOVATION	16	8	F Meyer	Admission to BSc Hons specialising in Computer Science.	\N	\N	This course introduces students to knowledge essential for computer professionals and researchers. The course develops communication and writing skills and introduces basic research methodology. The first module of the course focusses on Professional Communications in general, including written and visual communication. A second component teaches entrepreneurship as New Venture Planning: a critical element of economic development. This module introduces students to the ideas, theories and concepts associated with entrepreneurial ventures, with a focus on the elements needed to develop a viable business plan. A third module teaches scientific writing and research methods for statistical analysis and evaluation of data.	\N	None	The practical aspects of the work will be evaluated through: a series of 4 NVP assignments (10%/15%/35%/40%), culminating in a business plan; a literature review for the project (35%) and the project proposal (40%). NVP and RM are equally weighted.	\N	CSC4019Z	CSC	Z	CSC	Z
INTRODUCTORY STATISTICS	18	5	N Watson	Students should have obtained a DP for either STA1000F/S.	\N	\N	This is an introductory statistics course aimed at exposing students to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This course is offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistics; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence intervals; introduction to hypothesis testing (including tests on means, tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using spreadsheet functions.	\N	Satisfactory attendance of tests and completion of assignments and/or exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	(offered during summer and winter terms)	STA1000P	STA	P	STA	P
STATISTICS DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the beginning of the handbook.	\N	\N	\N	\N	STA5000W	STA	W	STA	W
FINANCIAL MANAGEMENT	18	6	P Brijlal	A pass in MAM1010F/S or an equivalent course, a pass in STA1000F/S or an equivalent course, a pass in ACC1006F/S (or ACC1106F) or an equivalent course		This course introduces financial management in a corporate environment. The course has two primary objectives. The first objective is to introduce students to the financial aspects of businesses, financial markets, and the environment in which businesses operate. The second objective is to equip students with the decision-making skills required by modern financial managers.	This course gives students a comprehensive foundation in the discipline and covers key decision- making skills such as: the valuation of future cash flows and risk, capital budgeting decisions, the working capital management and financing decisions, and corporate risk management.	Mondays to Fridays: 11h00 - 11h45 or 12h00 -12h45.	A sub-minimum for coursework of 40% average for class tests and a minimum of 80% for tutorial submissions and tutorial attendances. These requirements will be strictly enforced.	Tests and assignments 40%; final examination 60%.		FTX2024S	FTX	S	FTX	S
BUSINESS ETHICS	18	5	Associate Professor G Hull	At  least  second  year  status  or  be  registered  for  an  ACC04/ACC08 \r\nprogramme.			Ethical  choices  are  unavoidable  in  business.  This  course  aims  to  help  students  to  articulate  their \r\noptions when confronted with an ethical dilemma in business, and to make well-informed judgements \r\nabout the right thing to do. The course will consider a range of problems, from issues that could arise \r\nin a student’s first job to questions of business regulation that they may one day face as a leader in \r\ncommerce  or  government.  In  each  case,  the  course  will  challenge  and  assist  students  to  recognise \r\nethical  problems  in  practical  situations,  understand  the  possible  solutions,  and  make  reasoned \r\ndecisions.	Monday, Tuesday, Wednesday 3rd or 4th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of \r\nall essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June or October/November counts \r\n60%.	Please note that this course DOES NOT count towards the Philosophy major. This course may also \r\nbe offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI2043F	PHI	F	PHI	F
ECONOMICS OF EMERGING MARKETS	20	7	J Mukuddem-Petersen	\N	\N	\N	The economy is the environment of business. One of the prerequisites of doing well in business is to understand the environment that you are operating in. In this context there are a number of forces that act on business. Some are slow and often predictable. Others are sudden and very often unexpected. At the same time, while these forces play themselves out governments are also likely to react with a variety of policy changes. Hence the dual challenge for people in business is not only to position themselves to either take advantage of favourable economic conditions or take defensive action from negative economic shocks but also to anticipate the likely policy response on the part of government. In addition to this there can be quite dramatic differences in the economics experienced in developed economies compared to emerging markets. The course will explore some of these differences.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3003X	GSB	X	GSB	X
FUNCTIONAL PROGRAMMING	12	8	Associate Professor G Nitschke	Admission to BSc Hons specialising in Computer Science.	\N	\N	This course will expose students to the alternative functional programming paradigm, its theoretical underpinnings in the lambda calculus and its practical implementation in specific languages. Students' theoretical understanding of computability will be expanded from the introduction in the undergraduate theory of algorithms module where a Turing machine approach was used. Students will be introduced to the notion of “functions as rules”. Students will also learn how to use functional programming as a practical programming skill. Topics include side effect free programming and its benefits; first-class functions and higher-order functions; partial application and defining higher-order operations on aggregates, especially map, reduce/fold, and filter. Important new functional programming concepts including lazy evaluation and monads.	\N	None	Final examination: 50%; Practical assignments: 50%	\N	CSC4020Z	CSC	Z	CSC	Z
INTRODUCTORY STATISTICS	18	5	N Watson	Students should have obtained a DP for either STA1000F/S.	\N	\N	This is an introductory statistics course aimed at exposing students to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This course is offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistics; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence intervals; introduction to hypothesis testing (including tests on means, tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using spreadsheet functions.	\N	Satisfactory attendance of tests and completion of assignments and/or exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	(offered during summer and winter terms)	STA1000L	STA	L	STA	L
STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS	24	6	Associate Professor R Altwegg	A pass in STA1000F/S or STA1006S or STA1007S or STA1106H or STA1100S or STA1008F/S) and (MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1005H or MAM1010F/S or MAM1020F/S or MAM1110F/H)	\N	\N	The course aims to equip students with practical experience and skills in analysing data, using statistical techniques frequently used in the sciences. The skills include designing experiments, choosing appropriate statistical methods for visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding of limitations of statistical methods and data. By the end of the course the student should have gained enough confidence to transfer these skills to new problems or data sets in their own profession. Topics covered include: Introduction to statistical notation, linear regression, design and analysis of experiments, generalized linear models. There will be strong emphasis on the practical application of the above methods, using open-source statistical software such as R. There will be a one-day face-to-face workshop at the beginning of the first semester and a one-day face-to-face workshop at the beginning of the second semester.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35% .	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	This course is offered in blended learning format. A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2007F	STA	F	STA	F
BAYESIAN COMPUTATIONAL METHODS	12	8	Dr A Clark	Currently doing an Honours or Masters degree in statistics or at the discretion of the Head of Department.	\N	\N	The course aims to provide students with an introduction to the Bayesian method and the acquisition of the theory and methods required to apply Bayesian analysis to real world practical problems. Topics included in the course are as follows: Bayesian linear regression, variable selection, mixture modelling, Markov chain Monte Carlo methods (theory and practical applications).	\N	Satisfactory completion of assignments	Assignments and Exam	\N	STA4027Z	STA	Z	STA	Z
APPLIED MATHEMATICS DISSERTATION	180	9	\N	\N	\N	\N	The course will consist of the investigation of one or two topics chosen for intensive study by the candidate and approved by the Head of Department. Examination will be by dissertation. An oral examination may be required. The Department has research programmes in four particular areas of Applied Mathematics, namely (i) general relativity and astrophysics, (ii) mathematical modelling of biological, ecological and environmental systems, (iii) continuum mechanics, applied analysis and finite elements, and (iv) nonlinear evolution equations and non-integrable systems. See also 'Research in Mathematics & Applied Mathematics'. Candidates will be particularly encouraged to take part in one of these programmes. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	MAM5001W	MAM	W	MAM	W
ASTROPHYSICS & SPACE SCIENCE MINOR DISSERTATION	90	9	\N	AST5003F Assessment: Students will work on an approved research topic on which a minor dissertation must be presented for formal examination.	\N	\N	\N	\N	\N	Students will work on an approved research topic on which a minor dissertation must be presented for formal examination.	(National Astrophysics & Space Science Programme (NASSP); for further details see entry under Department of Astronomy)	MAM5005W	MAM	W	MAM	W
STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS	24	6	Associate Professor R Altwegg	A pass in STA1000F/S or STA1006S or STA1007S or STA1106H or STA1100S or STA1008F/S) and (MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1005H or MAM1010F/S or MAM1020F/S or MAM1110F/H)	\N	\N	The course aims to equip students with practical experience and skills in analysing data, using statistical techniques frequently used in the sciences. The skills include designing experiments, choosing appropriate statistical methods for visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding of limitations of statistical methods and data. By the end of the course the student should have gained enough confidence to transfer these skills to new problems or data sets in their own profession. Topics covered include: Introduction to statistical notation, linear regression, design and analysis of experiments, generalized linear models. There will be strong emphasis on the practical application of the above methods, using open-source statistical software such as R. There will be a one-day face-to-face workshop at the beginning of the first semester and a one-day face-to-face workshop at the beginning of the second semester.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35% .	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	This course is offered in blended learning format. A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2007S	STA	S	STA	S
BUSINESS ETHICS	18	5	Associate Professor G Hull	At  least  second  year  status  or  be  registered  for  an  ACC04/ACC08 \r\nprogramme.			Ethical  choices  are  unavoidable  in  business.  This  course  aims  to  help  students  to  articulate  their \r\noptions when confronted with an ethical dilemma in business, and to make well-informed judgements \r\nabout the right thing to do. The course will consider a range of problems, from issues that could arise \r\nin a student’s first job to questions of business regulation that they may one day face as a leader in \r\ncommerce  or  government.  In  each  case,  the  course  will  challenge  and  assist  students  to  recognise \r\nethical  problems  in  practical  situations,  understand  the  possible  solutions,  and  make  reasoned \r\ndecisions.	Monday, Tuesday, Wednesday 3rd or 4th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of \r\nall essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June or October/November counts \r\n60%.	Please note that this course DOES NOT count towards the Philosophy major. This course may also \r\nbe offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI2043S	PHI	S	PHI	S
STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS	24	6	Associate Professor R Altwegg	A pass in STA1000F/S or STA1006S or STA1007S or STA1106H or STA1100S or STA1008F/S) and (MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1005H or MAM1010F/S or MAM1020F/S or MAM1110F/H)	\N	\N	The course aims to equip students with practical experience and skills in analysing data, using statistical techniques frequently used in the sciences. The skills include designing experiments, choosing appropriate statistical methods for visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding of limitations of statistical methods and data. By the end of the course the student should have gained enough confidence to transfer these skills to new problems or data sets in their own profession. Topics covered include: Introduction to statistical notation, linear regression, design and analysis of experiments, generalized linear models. There will be strong emphasis on the practical application of the above methods, using open-source statistical software such as R. There will be a one-day face-to-face workshop at the beginning of the first semester and a one-day face-to-face workshop at the beginning of the second semester.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35% .	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	This course is offered in blended learning format. A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2007H	STA	H	STA	H
STATISTICS AND DATA SCIENCE HONOURS	160	8	Associate Professor G Distiller and Dr E Pienaar	The minimum requirements are (MAM1031F or MAM1004F/S or MAM1010F/S or MAM1033F) and (MAM1032S or MAM1034S), a first year semester module in Computer Science plus one of the following two sets of 3rd year courses: Applied Statistics stream: STA3030F + STA3036S/STA3022F; OR Mathematical Statistics Stream: STA3041F, STA3043S; Applicants fulfilling the minimum requirements above with an average of 65% or more for their 3rd year courses (at first attempt) for the Mathematical Statistics stream and students with an average of 70% or more for their 3rd year courses (at first attempt) for the Applied Statistics stream can be confident of admission into the programme. Applied Statistics students also need a minimum of 60% for each of the two pre-requisite courses. Students who do not achieve the requisite threshold levels in their respective streams may be considered on a case-by-case basis.	\N	\N	This honours programme teaches students the necessary data analytical and computing skills for a career in Data Science. It covers theoretical and applied statistics, supervised and unsupervised learning, statistical computing and operations research. It aims to give students a good theoretical basis and statistical computing skills through the teaching of core modules (81 NQF credits). It further exposes students to the practical application of quantitative methods in different areas through the offering of elective modules (39 NQF credits). It provides training in research through supervised project work (40 NQF credits). Elective modules vary from year to year, but typically include Portfolio Theory, Time Series Analysis, Biostatistics, Decision Modelling, Spatial Statistics.	\N	Attendance of 85% of departmental seminars.	Each coursework module comprises tests, assignments and a final examination. The relative weighting placed on the year work within different modules varies between 30% and 50%. The final grade for STA4007W as a whole is a weighted average (3: 1) of the combined final marks for each coursework module (weighted by the number of credits), and the individual project. The student is required to obtain a mark of at least 50% in all core modules and for the individual project. The student may fail at most one elective module provided that a mark of at least 40% is obtained for that module. These component parts of the course will be combined in a final overall mark which will be reflected against the course code STA4007W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code STA4007W will not carry a NQF credit value, students will be concurrently registered for STA4022W (coursework component of 120 NQF credits) and STA4023W (research project of 40 NQF credits).	STA4007W	STA	W	STA	W
PORTFOLIO THEORY	12	8	Associate Professor T Gebbie	STA3041F, STA3043S or at the discretion of the Head of Department. STA3045F is strongly recommended.	\N	\N	The course introduces the historical development of ideas from Economics, gambling and Finance with a South African perspective for portfolio control. Data-wrangling, portfolio optimization, sequential historic back-testing and simulation, and their attribution are developed in R. The static mean-variance theoretical foundations of portfolio choice, asset pricing and notions of market equilibrium are developed from first principles. Following an operations research approach tactical and strategic portfolios are formulated to admit short-term departures from long-term equilibrium for asset allocation. The theory is used to demonstrate the Generalised Fundamental Law of Asset Management, the Roll Critique and a Bayesian Black-Litterman portfolio choice framework. Active management and its complexities due to estimation and intrinsic uncertainties are demonstrated via case-studies. Various performance measures are derived from theoretical considerations. Performance attribution is used to measure the impact of information, return, risk and performance within a sequence of single-period portfolio control decisions. There is an emphasis on understanding the implications of back-test over-fitting. The course introduces indexation methods and the integration of the developed tools within a standard portfolio management workflow. Advanced topics such as cluster-based portfolio choice, risk-parity models and machine-learning extensions may be included.	\N	Satisfactory completion of assignments	Assignments and Exam	\N	STA4028Z	STA	Z	STA	Z
ADVANCED PROBABILITY THEORY	12	8	M Mavuso	Currently doing an Honours or Masters degree in statistics or at the discretion of the Head of Department.	\N	\N	The course aims to cover advanced concepts in probability and martingale theory, including products and conditioning, analysis, L2 theory of random variables, characteristic functions, convergence and uniform integrability, martingales, square integrable martingales, local martingales.	\N	Class record of at least 40%	Assignments, Class tests and Exam Refer to the “Rules for Master’s Degrees” in the front section of this handbook for the curriculum structure of the various Master’s by coursework and minor dissertation offered by the Department of Statistical Sciences (STA). The detailed courses are presented here.	\N	STA4029Z	STA	Z	STA	Z
PROFESSIONAL COMMUNICATION	18	6	S Rousseau	A pass in at least 8 courses towards the degree.			The course aims to provide students with the ability to design and produce various types of persuasive business and professional documents, and deliver business presentations. Students develop skills in planning and producing effective messages through practice in both verbal and visual arguments. They also develop management and communication skills for collaboration through teamwork.		None	Final written examination: 40% (with a 35% subminimum). Coursework mark:60%.		BUS2033F	BUS	F	BUS	F
SOFTWARE ENGINEERING	12	9	D Snyman	A non-IT honours degree, or equivalent.	None.	\N	This module aims to introduce a range of techniques within both structured and object-oriented methods, in order to enable you to analyse and design well engineered software solutions. You will be introduced to the practical use of CASE tools in modelling and documenting analysis and design specifications. Different life cycle models will also be discussed.	\N	In order to be permitted to sit the final exam a minimum average of 40% on the coursework must be obtained	2 Assignments (50%) and an Exam (50%).	\N	INF5009Z	INF	Z	INF	Z
OPERATIONAL RESEARCH DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the beginning of the handbook.	\N	\N	\N	\N	STA5001W	STA	W	STA	W
STATISTICS AND DATA SCIENCE MINOR DISSERTATION	90	9	Dr B Erni	STA5003W	\N	\N	On successful completion of the coursework component, students will undertake an individual, supervised research project on a suitable topic, the results of which are to be written up as a minor dissertation. The minor dissertation component of the Statistics and Data Science masters specialization is a research project based on a selected research in a methodological or applied field of Statistics or Data Science.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	STA5004W	STA	W	STA	W
MATHEMATICS THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the general rules for the PhD as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	MAM6000W	MAM	W	MAM	W
BIOSTATISTICS MINOR DISSERTATION	90	9	Associate Professor F Gumedze	Successful completion of the coursework component of the Master’s course in Biostatistics.	\N	\N	This course presents the research component of the Master's course in Biostatistics. The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on methodological or applied problems from the Health or Biological Sciences. Students may be based in a research unit from where the problem has originated for the duration of their research. On completion of the research component, and the preceding coursework component, students will be able to: (1) conduct collaborative research in the health sciences, (2) conduct independent research in statistical methodology for the health sciences, (3) act as statistical consultants for health sciences research, (4) be able to also work with researchers in the biological sciences.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each counts 50% towards the degree; each must be passed separately for the award of the degree.	\N	STA5058W	STA	W	STA	W
OPERATIONAL RESEARCH IN DEVELOPMENT COURSEWORK	90	9	Dr R G Rakotonirainy	Entry to the course requires a good Honours degree including a strong quantitative component (normally at least two years of Mathematics at a tertiary level). In selecting candidates for admission to the course, consideration will also be given to recommendations from at least two referees who are able to attest to the applicants’ academic abilities and suitability.	\N	\N	The aim of this one year course is to provide a broad professional training in the principles and tools of operational research (OR), with particular emphasis on application in the context of development and the developing world. OR has been defined as the discipline of applying advanced analytical methods (system analysis, and computer and mathematical models) to help make better decisions. The OR in Development programme focuses on preparing graduates for a career in applying OR to the unique problems of the developing world, such as conflicting objectives in balancing, for example, socio-economic development and corrective actions, less reliable infrastructures, and a post-colonial need for community participation in all levels of planning. The first academic year is based primarily on coursework, supplemented by group discussions and case studies. The coursework includes the basic techniques of operational research and statistics, specific developmental issues, problem structuring and decision analysis.	\N	\N	This component will be assessed through class assessments and examinations. A pass for this coursework requires an average of 50% over all modules, as well as a minimum of 50% for certain modules designated as core material.	This course may not be offered in 2025	STA5010W	STA	W	STA	W
OPERATIONAL RESEARCH IN DEVELOPMENT MINOR DISSERTATION	90	9	Dr R G Rakotonirainy	STA5010W	\N	\N	On successful completion of the coursework component, students will undertake an individual, supervised applied research project on a suitable topic, the results of which are to be written up as a minor dissertation. In some cases, the project might be undertaken on a local problem at the student's home base.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	This course may not be offered in 2025	STA5011W	STA	W	STA	W
STATISTICAL ECOLOGY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the beginning of the handbook.	\N	\N	\N	\N	STA5013W	STA	W	STA	W
PROFESSIONAL COMMUNICATION	18	6	S Rousseau	A pass in at least 8 courses towards the degree.			The course aims to provide students with the ability to design and produce various types of persuasive business and professional documents, and deliver business presentations. Students develop skills in planning and producing effective messages through practice in both verbal and visual arguments. They also develop management and communication skills for collaboration through teamwork.		None	Final written examination: 40% (with a 35% subminimum). Coursework mark:60%.		BUS2033S	BUS	S	BUS	S
CONSERVATION BIOLOGY MINOR DISSERTATION	90	9	Dr G Jamie	BIO5007H	\N	\N	The research component must be submitted as a minor dissertation for formal examination. It should be completed by mid-February following first registration.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	Students will enrol (and pay fees) for both courses BIO5007H and BIO5008W in their first year of registration; where the minor dissertation is not submitted by the February deadline of the subsequent year, the student will be required to enrol (and pay fees) for the minor dissertation component in the subsequent year/s. Those students already in possession of a Master's degree, or in exceptional cases those who wish to upgrade to a PhD, may expand a project in accordance with the normal pursuit of that degree at UCT.	BIO5008W	BIO	W	BIO	W
STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS DOING POSTGRADUATE	0	9	Associate Professor R Altwegg	Co-registration for an Honours degree in a relevant discipline such as Biology, Medicine, Actuarial Science, Finance and Engineering that involves a substantial component of quantitative training, as assessed by Head of Statistical Sciences Department	\N	\N	The course aims to equip students with practical experience and skills in analysing data, using statistical techniques frequently used in the sciences. The skills include designing experiments, choosing appropriate statistical methods for visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding of limitations of statistical methods and data. By the end of the course the student should have gained enough confidence to transfer these skills to new problems or data sets in their own profession. Topics covered include: Introduction to statistical notation, linear regression, design and analysis of experiments, generalized linear models. There will be strong emphasis on the practical application of the above methods, using open-source statistical software such as R. There will be a half-day face-to-face workshop at the beginning of the first semester and a half-day face-to-face workshop at the beginning of the second semester.	\N	\N	Assignments and tests count 50%; one 3-hour examination in November counts 50%. A sub-minimum of 40% is required for the examination.	\N	STA5014Z	STA	Z	STA	Z
BUSINESS LAW II - SUMMER TERM	12	6	TBA	Business Law I. No undergraduate student in the first year of study may register for Business Law II.	\N	\N	Refer to course outline for CML 2010Z.	Lectures are offered on a daily basis for three hours over a four-week period.	Writing the test is compulsory. If a student does not write the test and does not get an exemption then the student will be marked absent and awarded 0 for the test. But the student will be able to write the exam.	Test 30% and final examination 70%.	\N	CML2010P	CML	P	CML	P
SPECIAL TOPIC IN HUMAN/ENVIRONMENT INTERACTIONS	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Human/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of human or environmental geography. The course will focus on using theory, but will encourage the use of case studies. Course outcomes will emphasize the development of conceptual and analytical skills.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework	\N	EGS4040F	EGS	F	EGS	F
TOPICS IN BIOSTATISTICS A	15	9	Associate Professor F Gumedze	Previous exposure to quantitative training that will enable the student to cope with the material in the chosen module plus successful completion of pre-courses deemed necessary for the module, as assessed by Head of the Statistical Sciences Department and the module convener.	\N	\N	The aim of this module is to allow students to register for a single module that forms part of the Master’s course in Biostatistics. Possible modules include Multivariate Statistics, Longitudinal Data Analysis, Survival Analysis and Design and Analysis of Experiments in the Health Sciences, Advanced Topics in Regression, Simulation and Optimisation, Machine Learning, Bayesian Decision Analysis, Infectious Disease Modelling and Structural Equation Modelling. Students will acquire skills and knowledge of statistical methodology relevant to Health Sciences Research.	\N	\N	Class assignments 50%; one 3-hour examination counts 50%. A sub-minimum of 40% is required for the examination and the class assignments.	\N	STA5059Z	STA	Z	STA	Z
TOPICS IN BIOSTATISTICS B	15	9	Associate Professor F Gumedze	Previous exposure to quantitative training that will enable the student to cope with the material in the chosen module plus successful completion of pre-courses deemed necessary for the module, as assessed by Head of the Statistical Sciences Department and the module convener.	\N	\N	The aim of this module is to allow students to register for a single module that forms part of the MSc in Biostatistics. Possible modules include Multivariate Statistics, Longitudinal Data Analysis, Survival Analysis and Design and Analysis of Experiments in the Health Sciences, Advanced Topics in Regression, Simulation and Optimisation, Machine Learning, Bayesian Decision Analysis, Infectious Disease Modelling and Structural Equation Modelling. Students will acquire skills and knowledge of statistical methodology relevant to Health Sciences Research.	\N	\N	Class assignments 50%; one 3-hour examination counts 50%. A sub-minimum of 40% is required for the examination and the class assignments.	\N	STA5060Z	STA	Z	STA	Z
BUSINESS LAW I - SUMMER TERM	18	5	TBA	\N	\N	\N	Refer to course outline for CML1001F/CML1004S.	Lectures are offered on a daily basis for three hours over a four-week period.	Writing the test is compulsory. If a student does not write the test and does not get an exemption then the student will be marked absent and awarded 0 for the test. But the student will be able to write the exam.	Test 40%; final examination 60%.	\N	CML1001P	CML	P	CML	P
BAYESIAN DECISION MODELLING	15	9	Dr A Clark	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics subject and/ or statistical background deemed sufficient by the Head of Department.	\N	\N	This module develops the Bayesian approach to inference and decision making, starting from concepts of subjective probability and subjective expected utility, and moving on to structures of Bayesian modelling for inference, computational solution of such models, and representation of complex learning and decision making processed through Bayesian Networks.	\N	Completion and submission of the assignment component at a satisfactory grade (40% minimum)	Assignments 35%. Written examination 65%. A subminimum of 40% in each of the assignments and examination is required.	\N	STA5061Z	STA	Z	STA	Z
BUSINESS ANALYSIS & GOVERNANCE II	11	7	Navitha Sewpersadh	ACC3001F.	\N	\N	The course reflects on and integrates the technical subject matter included in the four core disciplines included in the Chartered Accountant B.Com program (Financial Reporting, Managerial Accounting & Finance, Governance, Auditing and Assurance, and Taxation) in a highly contextualised and integrative manner. The content focusses on value creation of businesses looking more broadly than profit, and evaluating the broader impacts of business such as social, environmental, and regulatory. The content topics are; strategy, integrated reporting, environment social and governance, and mergers & acquisitions.	Tuesday, 3PM & Thursday, 11AM.	Attendance of 75% of tutorials. Weighted average 40% average for individual components. Completion of Group and individual components.	Coursework 50%. Exam 50%.	\N	ACC3002S	ACC	S	ACC	S
MICROECONOMICS FOR THE BUILT ENVIRONMENT	18	5	C van Walbeek	Admission to degree. National Senior Certificate: a pass (5) in Mathematics.			This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	Tuesday, Wednesday, Thursday and Friday 09h00 - 10h00; 10h00 - 11h00; 11h00 - 12h00; 12h00 - 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework (50%) and final exam (50%). The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO1008F	ECO	F	ECO	F
BUSINESS ACUMEN FOR ACCOUNTANTS	15	5	S Herbert	Registration for a BCom Accounting or BBusSci Finance with Accounting degree, or by permission of the department.	ACC1006F and ACC1011S	This course exposes students to real-life businesses in South Africa. The internal and external business environment are explored, equipping students with the ability to evaluate the role of business in society.	This course explores integrated thinking, real-life business evaluation, and entity types.	Monday and Friday 10:00	Participation in group project, and 70% weekly hand-ins.	Group assignment: 30%, Individual assignments: 20%, Final Exam: 45%		ACC1015F	ACC	F	ACC	F
OPERATIONS MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The Operations course equips students to understand, plan, and control many large processing systems that form the core of manufacturing and service organizations. Operations management principles are equally applicable in managing manufacturing and service organizations. Fast, low-cost, accurate, and uniform operations are important in service areas such as health services, government, transportation, retail, fast-food franchises, airlines, insurance, and banking, among others.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3007F	GSB	F	GSB	F
FOUNDATIONS OF INFORMATION SYSTEMS	18	5	T Chimboza and L Tekeni	Admission may be restricted for students other than Commerce based on student numbers. For students outside of Commerce, entrance requirements include either 70% for NBT QL or at least 50% for Maths (NSC) or MAM1014F or at least 60% for MAM1022F	\N	\N	The course provides a foundation to the use and impact of Information systems in business and society. Fundamental knowledge of information systems, their functioning and how they contribute to globalisation will be discussed. Particular focus is for students to understand the value of information, its collection, processing, storage and transmission through use of information systems in businesses, suppliers and customers. Practical exposure (linked to the theorical themes) to data analysis tools, programming and systems development in organisations is provided.	Monday: 6th OR 7th period, Tuesday 6th AND 7th period OR Wednesday 6th and 7th.	Year mark greater or equal to 45% (based on all assessments prior to the final exam). 80% participation for all practicals (tutorials and workshops).	Coursework 65%; Final Examination 35%. Sub-minimum of 40% for the final exam.	\N	INF1002S	INF	S	INF	S
MICROECONOMICS FOR THE BUILT ENVIRONMENT	18	5	C van Walbeek	Admission to degree. National Senior Certificate: a pass (5) in Mathematics.			This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	Tuesday, Wednesday, Thursday and Friday 09h00 - 10h00; 10h00 - 11h00; 11h00 - 12h00; 12h00 - 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework (50%) and final exam (50%). The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO1008S	ECO	S	ECO	S
MICROECONOMICS AUGMENTED	18	5	N Narker	The course is open to first-year EDU students who meet the criteria for admission to ECO1010F.	There is no co-requisite, but students are strongly advised to do a formal mathematics course (MAM1010 or equivalent). Not having done such a course will preclude entry to second year Economics.	\N	This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	ECO1110F Monday, Tuesday, Wednesday, Thursday, Friday 11h00 – 12h00; 12h00 – 13h00. ECO1110S Monday, Tuesday, Wednesday, Thursday and Friday 12h00 – 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework 50%; Exam 50%. The course outline will detail the breakdown for assessment weightings and variation for exemptions and absences.	Students in this course write the same final examination as the ECO1010F/S students. The ECO1110F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1110S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1110F	ECO	F	ECO	F
BUSINESS ACUMEN FOR ACCOUNTANTS	15	5	J Kew	Registration for a BCom Accounting or BBusSci Finance with Accounting degree, or by permission of the department.	ACC1006F and ACC1011S	This course exposes students to real-life businesses in South Africa. The internal and external business environment are explored, equipping students with the ability to evaluate the role of business in society.	This course explores integrated thinking, real-life business evaluation, and entity types.	Monday and Friday 10:00	Participation in group project, and 70% weekly hand-ins.	Group assignment: 30%, Individual assignments: 20%, Final Exam: 45%		ACC1015S	ACC	S	ACC	S
LONGITUDINAL DATA ANALYSIS	15	9	Associate Professor F Gumedze	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	This course looks at advanced methods for the analysis of longitudinal data, including linear mixed effect models, generalized estimating equations, generalized linear mixed effect models, nonlinear mixed effect models, smoothing spline models, imputation methods for missing data and causal models. Both the underlying theory and the application of these models using appropriate statistical software are covered. The course may not be offered every year.	\N	40% for the assignment component	Assignments 50%. Written exam 50%. Sub-minimum of 40% in each of assignment and examination component.	\N	STA5067Z	STA	Z	STA	Z
LEADERSHIP AND COMMUNICATION	20	7	J Mukuddem-Petersen	\N	\N	\N	The Leadership and Communication course will provide students with the opportunity to explore the topic of personal and team leadership and effectiveness in communication. From a leadership perspective, the purpose of the course is not to provide a single, ‘correct’ perspective, but rather it is intended to be a catalyst for personal reflection and insight (mirroring-principle) into processes and concepts critical for managing oneself and team more effectively. From a communication point of view, the course will provide a key set of tools for greater efficacy in effective communication, a cornerstone of sound leadership.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3002X	GSB	X	GSB	X
MICROECONOMICS AUGMENTED	18	5	N Narker	The course is open to first-year EDU students who meet the criteria for admission to ECO1010F.	There is no co-requisite, but students are strongly advised to do a formal mathematics course (MAM1010 or equivalent). Not having done such a course will preclude entry to second year Economics.	\N	This is an introductory course in microeconomics, which aims to expose students to a wide variety of microeconomic concepts and theories as well as certain practical applications of these concepts. The course begins with a discussion of economic history and the characteristics of different economic systems, as well as factors influencing economic development following the Industrial Revolution. Hereafter, students are introduced to topics within the standard utility-maximisation theory of consumption, including optimal-bundle and indifference curve analysis. Students are then exposed to game theoretical frameworks to model social interactions amongst economic agents, before applying this framework to wage-setting relationships in the labour market. Applications of experimental economic methods are also briefly explored. Finally, students are introduced to the standard neoclassical theories of supply and demand as well as firms’ pricing decisions under differing levels of market competition.	ECO1110F Monday, Tuesday, Wednesday, Thursday, Friday 11h00 – 12h00; 12h00 – 13h00. ECO1110S Monday, Tuesday, Wednesday, Thursday and Friday 12h00 – 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework 50%; Exam 50%. The course outline will detail the breakdown for assessment weightings and variation for exemptions and absences.	Students in this course write the same final examination as the ECO1010F/S students. The ECO1110F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course. The ECO1110S supplementary/deferred exam will be scheduled during January of the following year. If students do not write this exam, they will be marked as AB and will have to retake the course.	ECO1110S	ECO	S	ECO	S
FOUNDATIONS OF INFORMATION SYSTEMS	18	5	T Chimboza and L Tekeni	Admission may be restricted for students other than Commerce based on student numbers. For students outside of Commerce, entrance requirements include either 70% for NBT QL or at least 50% for Maths (NSC) or MAM1014F or at least 60% for MAM1022F	\N	\N	The course provides a foundation to the use and impact of Information systems in business and society. Fundamental knowledge of information systems, their functioning and how they contribute to globalisation will be discussed. Particular focus is for students to understand the value of information, its collection, processing, storage and transmission through use of information systems in businesses, suppliers and customers. Practical exposure (linked to the theorical themes) to data analysis tools, programming and systems development in organisations is provided.	Monday: 6th OR 7th period, Tuesday 6th AND 7th period OR Wednesday 6th and 7th.	Year mark greater or equal to 45% (based on all assessments prior to the final exam). 80% participation for all practicals (tutorials and workshops).	Coursework 65%; Final Examination 35%. Sub-minimum of 40% for the final exam.	\N	INF1002F	INF	F	INF	F
FOUNDATIONS OF INFORMATION SYSTEMS	18	5	M. I. Kapepo	Admission to the Commerce EDU programme. For students outside of Commerce, entrance requirements include either 70% for NBT QL or at least 50% for Maths (NSC) or MAM1014F or 60% for MAM1022F.	\N	\N	The course provides a foundation to the use and impact of Information systems in business and society. Fundamental knowledge of information systems, their functioning and how they contribute to DEPARTMENTS IN THE FACULTY OF COMMERCE 179 globalisation will be discussed. Particular focus is for students to understand the value of information, its collection, processing, storage and transmission through use of information systems in businesses, suppliers and customers. Practical exposure (linked to the theoretical themes) to data analysis tools, programming and systems development in organisations is provided.	Monday, 6th and 7th period, Tuesday to Wednesday, 6th period	Year mark greater or equal to 45% for the year mark (based on all assessment prior to the final exam). 80% participation for all practicals (tutorials and workshops)	Coursework 65%; Final Examination 35%. Sub-minimum of 40% for the final exam.	For Academic Development programme (Commerce). Students in this course write the same class tests and final examination as the INF1002F/S students.	INF1102F	INF	F	INF	F
FOUNDATIONS OF INFORMATION SYSTEMS	18	5	M. I. Kapepo	Admission to the Commerce EDU programme. For students outside of Commerce, entrance requirements include either 70% for NBT QL or at least 50% for Maths (NSC) or MAM1014F or 60% for MAM1022F.	\N	\N	The course provides a foundation to the use and impact of Information systems in business and society. Fundamental knowledge of information systems, their functioning and how they contribute to DEPARTMENTS IN THE FACULTY OF COMMERCE 179 globalisation will be discussed. Particular focus is for students to understand the value of information, its collection, processing, storage and transmission through use of information systems in businesses, suppliers and customers. Practical exposure (linked to the theoretical themes) to data analysis tools, programming and systems development in organisations is provided.	Monday, 6th and 7th period, Tuesday to Wednesday, 6th period	Year mark greater or equal to 45% for the year mark (based on all assessment prior to the final exam). 80% participation for all practicals (tutorials and workshops)	Coursework 65%; Final Examination 35%. Sub-minimum of 40% for the final exam.	For Academic Development programme (Commerce). Students in this course write the same class tests and final examination as the INF1002F/S students.	INF1102S	INF	S	INF	S
MARKETING I	18	6	N Madinga	Students should be in their second AYOS or above Objective: To give an overview of the Marketing Process considering current trends in the South African context. The course will stress the importance of the Marketing Concept, Target Marketing and the Marketing Mix as a means of formulating a Marketing Strategy with the view to achieving the strategic objectives of an organisation.	\N	To give an overview of the Marketing Process considering current trends in the South African context. The course will stress the importance of the Marketing Concept, Target Marketing and the Marketing Mix as a means of formulating a Marketing Strategy with the view to achieving the strategic objectives of an organisation.	The marketing concept, the marketing environment, consumer markets and industrial markets, buyer behaviour, marketing research, the use and importance of differentiation, market segmentation and target marketing, the marketing mix, product policy, pricing policy, distribution policy, promotion DEPARTMENTS IN THE FACULTY OF COMMERCE 190 policy, marketing strategy, marketing organisation and implementation, measurement and control of marketing effectiveness including the marketing audit.	\N	40% class mark and the completion of all required assignments.	Essays, case studies, project and test 50%; June / October examinations (2 hours) 50%	0 credits if taken as part of a Postgraduate Diploma in Management offered by the School of Management Studies	BUS2010F	BUS	F	BUS	F
MARKETING I	18	6	N Madinga	Students should be in their second AYOS or above Objective: To give an overview of the Marketing Process considering current trends in the South African context. The course will stress the importance of the Marketing Concept, Target Marketing and the Marketing Mix as a means of formulating a Marketing Strategy with the view to achieving the strategic objectives of an organisation.	\N	To give an overview of the Marketing Process considering current trends in the South African context. The course will stress the importance of the Marketing Concept, Target Marketing and the Marketing Mix as a means of formulating a Marketing Strategy with the view to achieving the strategic objectives of an organisation.	The marketing concept, the marketing environment, consumer markets and industrial markets, buyer behaviour, marketing research, the use and importance of differentiation, market segmentation and target marketing, the marketing mix, product policy, pricing policy, distribution policy, promotion DEPARTMENTS IN THE FACULTY OF COMMERCE 190 policy, marketing strategy, marketing organisation and implementation, measurement and control of marketing effectiveness including the marketing audit.	\N	40% class mark and the completion of all required assignments.	Essays, case studies, project and test 50%; June / October examinations (2 hours) 50%	0 credits if taken as part of a Postgraduate Diploma in Management offered by the School of Management Studies	BUS2010S	BUS	S	BUS	S
PEOPLE MANAGEMENT	18	7	TBA	Entry to BUS3039F is restricted to: 1.) Third Year BCom (Management Studies) students who have not taken organizational psychology undergraduate courses, 2.) Third Year BBusSc students in all fields except for Organisational Psychology, Finance, Finance (CA), and 3.) PG Diploma students in the following areas: Sports Management, Business Communication, Entrepreneurship and Marketing. Entry to BUS3039S is restricted to: 1.) Third Year BCom (Management Studies) students and 2.) Third Year BBusSc Finance, Finance (CA), Finance 5-year and Finance (CA) 5-year students.	\N	\N	This course introduces business science and management students to people management issues (e.g., leadership, teamwork, and diversity) that may arise as they enter the world of work. Students will learn to manage current and emerging South African contextual complexities in managing people from diverse local lived realities. Adopting a collaborative learning approach, the course focuses on building the knowledge and skills necessary for students to be active in leading transformative workplace change and social justice.	\N	None	Coursework 100%.	\N	BUS3039F	BUS	F	BUS	F
ARCHAEOLOGY DISSERTATION	180	9	\N	\N	\N	\N	See also AGE5006W, Faculty of Humanities Handbook. This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material.	\N	\N	\N	\N	AGE5000W	AGE	W	AGE	W
PEOPLE MANAGEMENT	18	7	TBA	Entry to BUS3039F is restricted to: 1.) Third Year BCom (Management Studies) students who have not taken organizational psychology undergraduate courses, 2.) Third Year BBusSc students in all fields except for Organisational Psychology, Finance, Finance (CA), and 3.) PG Diploma students in the following areas: Sports Management, Business Communication, Entrepreneurship and Marketing. Entry to BUS3039S is restricted to: 1.) Third Year BCom (Management Studies) students and 2.) Third Year BBusSc Finance, Finance (CA), Finance 5-year and Finance (CA) 5-year students.	\N	\N	This course introduces business science and management students to people management issues (e.g., leadership, teamwork, and diversity) that may arise as they enter the world of work. Students will learn to manage current and emerging South African contextual complexities in managing people from diverse local lived realities. Adopting a collaborative learning approach, the course focuses on building the knowledge and skills necessary for students to be active in leading transformative workplace change and social justice.	\N	None	Coursework 100%.	\N	BUS3039S	BUS	S	BUS	S
LEADERSHIP AND COMMUNICATION	20	7	J Mukuddem-Petersen	\N	\N	\N	The Leadership and Communication course will provide students with the opportunity to explore the topic of personal and team leadership and effectiveness in communication. From a leadership perspective, the purpose of the course is not to provide a single, ‘correct’ perspective, but rather it is intended to be a catalyst for personal reflection and insight (mirroring-principle) into processes and concepts critical for managing oneself and team more effectively. From a communication point of view, the course will provide a key set of tools for greater efficacy in effective communication, a cornerstone of sound leadership.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3002F	GSB	F	GSB	F
APPROACHES AND ISSUES IN PHYSICAL AND ENVIRONMENTAL SCIENCES	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Physical/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of physical or environmental geography. The course will cover theoretical, empirical and methodological concerns and will include a fieldwork component.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4041F	EGS	F	EGS	F
LEADERSHIP AND COMMUNICATION	20	7	J Mukuddem-Petersen	\N	\N	\N	The Leadership and Communication course will provide students with the opportunity to explore the topic of personal and team leadership and effectiveness in communication. From a leadership perspective, the purpose of the course is not to provide a single, ‘correct’ perspective, but rather it is intended to be a catalyst for personal reflection and insight (mirroring-principle) into processes and concepts critical for managing oneself and team more effectively. From a communication point of view, the course will provide a key set of tools for greater efficacy in effective communication, a cornerstone of sound leadership.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3002S	GSB	S	GSB	S
LEADERSHIP AND COMMUNICATION	20	7	J Mukuddem-Petersen	\N	\N	\N	The Leadership and Communication course will provide students with the opportunity to explore the topic of personal and team leadership and effectiveness in communication. From a leadership perspective, the purpose of the course is not to provide a single, ‘correct’ perspective, but rather it is intended to be a catalyst for personal reflection and insight (mirroring-principle) into processes and concepts critical for managing oneself and team more effectively. From a communication point of view, the course will provide a key set of tools for greater efficacy in effective communication, a cornerstone of sound leadership.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3002Z	GSB	Z	GSB	Z
ECONOMICS OF EMERGING MARKETS	20	7	J Mukuddem-Petersen	\N	\N	\N	The economy is the environment of business. One of the prerequisites of doing well in business is to understand the environment that you are operating in. In this context there are a number of forces that act on business. Some are slow and often predictable. Others are sudden and very often unexpected. At the same time, while these forces play themselves out governments are also likely to react with a variety of policy changes. Hence the dual challenge for people in business is not only to position themselves to either take advantage of favourable economic conditions or take defensive action from negative economic shocks but also to anticipate the likely policy response on the part of government. In addition to this there can be quite dramatic differences in the economics experienced in developed economies compared to emerging markets. The course will explore some of these differences.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3003F	GSB	F	GSB	F
MARKETING MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The marketing course focuses on three broad topics: understanding the nature and scope of marketing, analysing marketing opportunities (to facilitate identifying and selecting target markets), and developing and implementing marketing strategies in a particular context. This course introduces fundamental and advanced analytical approaches, tools and techniques that marketers use in their work. Students are required to draw systematically from the body of knowledge and to apply their learning to a complex problem or organisation. Hence the course emphasizes conceptual and practical issues, primarily through the use of case study discussions and interactive lectures.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3005Z	GSB	Z	GSB	Z
ECONOMICS OF EMERGING MARKETS	20	7	J Mukuddem-Petersen	\N	\N	\N	The economy is the environment of business. One of the prerequisites of doing well in business is to understand the environment that you are operating in. In this context there are a number of forces that act on business. Some are slow and often predictable. Others are sudden and very often unexpected. At the same time, while these forces play themselves out governments are also likely to react with a variety of policy changes. Hence the dual challenge for people in business is not only to position themselves to either take advantage of favourable economic conditions or take defensive action from negative economic shocks but also to anticipate the likely policy response on the part of government. In addition to this there can be quite dramatic differences in the economics experienced in developed economies compared to emerging markets. The course will explore some of these differences.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3003S	GSB	S	GSB	S
ECONOMICS OF EMERGING MARKETS	20	7	J Mukuddem-Petersen	\N	\N	\N	The economy is the environment of business. One of the prerequisites of doing well in business is to understand the environment that you are operating in. In this context there are a number of forces that act on business. Some are slow and often predictable. Others are sudden and very often unexpected. At the same time, while these forces play themselves out governments are also likely to react with a variety of policy changes. Hence the dual challenge for people in business is not only to position themselves to either take advantage of favourable economic conditions or take defensive action from negative economic shocks but also to anticipate the likely policy response on the part of government. In addition to this there can be quite dramatic differences in the economics experienced in developed economies compared to emerging markets. The course will explore some of these differences.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3003Z	GSB	Z	GSB	Z
FINANCE AND ACCOUNTING MANAGEMENT	20	7	J Mukuddem-Petersen	\N	\N	\N	This course focusses on developing literacy in matters pertaining to accounting and finance. In the first half, students are taught to read, understand and interpret financial statements. It will equip students with the skills to appreciate the role of accounting in making decisions and controlling and planning the operations of an organisation, and to interpret and use financial information for decision- making purposes. In the second half, the course explores how good financial management lies at the heart of a successful and sustainable business. Students are introduced to standard finance techniques and concepts that are useful in the practice of financial management across a range of business areas. In addition to equipping the student with a set of analytical tools and frameworks relevant to project assessment and cash flow management, the course also looks at the links between a company’s investment and financing decisions.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3004F	GSB	F	GSB	F
FINANCE AND ACCOUNTING MANAGEMENT	20	7	J Mukuddem-Petersen	\N	\N	\N	This course focusses on developing literacy in matters pertaining to accounting and finance. In the first half, students are taught to read, understand and interpret financial statements. It will equip students with the skills to appreciate the role of accounting in making decisions and controlling and planning the operations of an organisation, and to interpret and use financial information for decision- making purposes. In the second half, the course explores how good financial management lies at the heart of a successful and sustainable business. Students are introduced to standard finance techniques and concepts that are useful in the practice of financial management across a range of business areas. In addition to equipping the student with a set of analytical tools and frameworks relevant to project assessment and cash flow management, the course also looks at the links between a company’s investment and financing decisions.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3004S	GSB	S	GSB	S
HUMAN RESOURCES MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The HRM course covers three main themes: The Individual in the Organisation, High Performance work practices and Leading and Managing People. The course will provide an overall organisational approach to people management strategies. The first theme sets the context by creating a rationale and frame for the course. Centring on the changing world of work, it examines the different assumptions about people, their motivation, how they work and what they want out of their experiences. The second and final themes illustrate how organisations go about leading and managing their employees also focussing on the specific practices within organisations that can assist them in being more effective.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3006F	GSB	F	GSB	F
FINANCE AND ACCOUNTING MANAGEMENT	20	7	J Mukuddem-Petersen	\N	\N	\N	This course focusses on developing literacy in matters pertaining to accounting and finance. In the first half, students are taught to read, understand and interpret financial statements. It will equip students with the skills to appreciate the role of accounting in making decisions and controlling and planning the operations of an organisation, and to interpret and use financial information for decision- making purposes. In the second half, the course explores how good financial management lies at the heart of a successful and sustainable business. Students are introduced to standard finance techniques and concepts that are useful in the practice of financial management across a range of business areas. In addition to equipping the student with a set of analytical tools and frameworks relevant to project assessment and cash flow management, the course also looks at the links between a company’s investment and financing decisions.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3004X	GSB	X	GSB	X
FINANCE AND ACCOUNTING MANAGEMENT	20	7	J Mukuddem-Petersen	\N	\N	\N	This course focusses on developing literacy in matters pertaining to accounting and finance. In the first half, students are taught to read, understand and interpret financial statements. It will equip students with the skills to appreciate the role of accounting in making decisions and controlling and planning the operations of an organisation, and to interpret and use financial information for decision- making purposes. In the second half, the course explores how good financial management lies at the heart of a successful and sustainable business. Students are introduced to standard finance techniques and concepts that are useful in the practice of financial management across a range of business areas. In addition to equipping the student with a set of analytical tools and frameworks relevant to project assessment and cash flow management, the course also looks at the links between a company’s investment and financing decisions.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3004Z	GSB	Z	GSB	Z
MARKETING MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The marketing course focuses on three broad topics: understanding the nature and scope of marketing, analysing marketing opportunities (to facilitate identifying and selecting target markets), and developing and implementing marketing strategies in a particular context. This course introduces fundamental and advanced analytical approaches, tools and techniques that marketers use in their work. Students are required to draw systematically from the body of knowledge and to apply their learning to a complex problem or organisation. Hence the course emphasizes conceptual and practical issues, primarily through the use of case study discussions and interactive lectures.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3005F	GSB	F	GSB	F
SUSTAINABILITY & ENVIRONMENT	36	7	Dr P Sabela-Rikhotso	EGS2013F, EGS2015S	\N	\N	The course critically engages with current debates and discourses in the fields of sustainability, vulnerability and environmental management, including examination of key concepts such as integration, systems-thinking, complexity, equity, vulnerability, risk, resilience, adaptation and mitigation. Approaches and methods for analysing environmental problems and integrating risk reduction as well as sustainability principles and practices into policy, programme, plan and project cycle processes are investigated and applied in different contexts.	Monday - Friday, 3rd period	Attendance and satisfactory completion of practicals (including fieldwork), other assignments and tests; students must attain an average mark of not less than 40% for the coursework.	Practical reports (including fieldwork), class tests and other assignments count 60%; one 3-hour June examination counts 50% (subminimum of 40% required).	There is a compulsory fieldwork component involving a half-day field excursion.	EGS3021F	EGS	F	EGS	F
MARKETING MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The marketing course focuses on three broad topics: understanding the nature and scope of marketing, analysing marketing opportunities (to facilitate identifying and selecting target markets), and developing and implementing marketing strategies in a particular context. This course introduces fundamental and advanced analytical approaches, tools and techniques that marketers use in their work. Students are required to draw systematically from the body of knowledge and to apply their learning to a complex problem or organisation. Hence the course emphasizes conceptual and practical issues, primarily through the use of case study discussions and interactive lectures.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3005S	GSB	S	GSB	S
MARKETING MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The marketing course focuses on three broad topics: understanding the nature and scope of marketing, analysing marketing opportunities (to facilitate identifying and selecting target markets), and developing and implementing marketing strategies in a particular context. This course introduces fundamental and advanced analytical approaches, tools and techniques that marketers use in their work. Students are required to draw systematically from the body of knowledge and to apply their learning to a complex problem or organisation. Hence the course emphasizes conceptual and practical issues, primarily through the use of case study discussions and interactive lectures.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3005X	GSB	X	GSB	X
MATHEMATICAL MODELLING FOR INFECTIOUS DISEASES	15	9	Associate Professor S Silal	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	This course introduces students to mathematical modelling of infectious diseases. Topics include differential equation modelling, agent based modelling, computer simulation, statistical data fitting, public health modelling, introduction to economic modelling. The course may not be offered every year.	\N	40% for the assignment component	Assignments 40%. Written examination 60%. Sub-minimum of 40% for each of assignment and examination component.	\N	STA5066Z	STA	Z	STA	Z
HUMAN RESOURCES MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The HRM course covers three main themes: The Individual in the Organisation, High Performance work practices and Leading and Managing People. The course will provide an overall organisational approach to people management strategies. The first theme sets the context by creating a rationale and frame for the course. Centring on the changing world of work, it examines the different assumptions about people, their motivation, how they work and what they want out of their experiences. The second and final themes illustrate how organisations go about leading and managing their employees also focussing on the specific practices within organisations that can assist them in being more effective.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3006S	GSB	S	GSB	S
MATHEMATICS 1010	18	5	Dr R Moolman	At least 60% in NSC Mathematics, or 50% in Higher Grade Mathematics (SC), or passes in both MAM1014F/MAM1022F and MAM1015S.	\N	\N	The aim of this course is to introduce topics in mathematics that are of interest to Commerce students, with applications to economics. Introductory financial mathematics including compound interest and annuities, functions, limits, differential calculus and applications of the derivative including graph sketching and Newton’s Method, introduction to integral calculus and techniques of integration.	Monday - Friday, 1st, 3rd, or 4th period	Minimum of 30% in class tests and full attendance at workshops.	Semester mark up to 40%. June examination 1 x 2 hour paper	\N	MAM1010F	MAM	F	MAM	F
TAXATION II	32	7	S Maqhubela / T Adams	A pass in ACC2023, and concurrent registration or a previous pass in ACC3009W or ACC3020W.	\N	\N	This course builds on the basic principles of taxation taught in Taxation I. The aim of the course is to develop proficiency in the application of tax knowledge, with a focus on understanding and applying relevant taxation legislation, identification of relevant case law and applying these in the context of real-life scenarios.	TBC	Attendance at and submission of a minimum of 75% of tutorials AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 40% Exam: 60%	\N	ACC3004W	ACC	W	ACC	W
HUMAN RESOURCES MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The HRM course covers three main themes: The Individual in the Organisation, High Performance work practices and Leading and Managing People. The course will provide an overall organisational approach to people management strategies. The first theme sets the context by creating a rationale and frame for the course. Centring on the changing world of work, it examines the different assumptions about people, their motivation, how they work and what they want out of their experiences. The second and final themes illustrate how organisations go about leading and managing their employees also focussing on the specific practices within organisations that can assist them in being more effective.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3006X	GSB	X	GSB	X
HUMAN RESOURCES MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The HRM course covers three main themes: The Individual in the Organisation, High Performance work practices and Leading and Managing People. The course will provide an overall organisational approach to people management strategies. The first theme sets the context by creating a rationale and frame for the course. Centring on the changing world of work, it examines the different assumptions about people, their motivation, how they work and what they want out of their experiences. The second and final themes illustrate how organisations go about leading and managing their employees also focussing on the specific practices within organisations that can assist them in being more effective.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3006Z	GSB	Z	GSB	Z
OPERATIONS MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The Operations course equips students to understand, plan, and control many large processing systems that form the core of manufacturing and service organizations. Operations management principles are equally applicable in managing manufacturing and service organizations. Fast, low-cost, accurate, and uniform operations are important in service areas such as health services, government, transportation, retail, fast-food franchises, airlines, insurance, and banking, among others.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3007S	GSB	S	GSB	S
OPERATIONS MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The Operations course equips students to understand, plan, and control many large processing systems that form the core of manufacturing and service organizations. Operations management principles are equally applicable in managing manufacturing and service organizations. Fast, low-cost, accurate, and uniform operations are important in service areas such as health services, government, transportation, retail, fast-food franchises, airlines, insurance, and banking, among others.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3007X	GSB	X	GSB	X
OPERATIONS MANAGEMENT	15	7	J Mukuddem-Petersen	\N	\N	\N	The Operations course equips students to understand, plan, and control many large processing systems that form the core of manufacturing and service organizations. Operations management principles are equally applicable in managing manufacturing and service organizations. Fast, low-cost, accurate, and uniform operations are important in service areas such as health services, government, transportation, retail, fast-food franchises, airlines, insurance, and banking, among others.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3007Z	GSB	Z	GSB	Z
DATA SCIENCE MINOR DISSERTATION	90	9	Dr S Er	Successful completion of the coursework component of the Masters course in Data Science.	\N	\N	The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on an analysis of large data sets from Physics, Astronomy, Medicine, Finance or other areas of application using the methodology learnt in coursework component. Alternatively, the dissertation component may focus on methodological developments in Statistical Sciences or Computer Sciences required for the analysis of a large amount of data.	\N	\N	\N	\N	STA5079W	STA	W	STA	W
STRATEGY AND INNOVATION LAB	15	7	J Mukuddem-Petersen	\N	\N	\N	This course is structured as a lab that builds on the conceptual material taught in all the core courses. It is opened with an introduction to Strategy and then emphasizes practical application of innovation concepts in real-world contexts. The strategy component will introduce students to the fundamental principles and concepts of strategic thinking and management. It will provide the opportunity for students to develop the necessary skills for strategic thinking and analysis. Students will learn about business and corporate strategy formulation relevant to the macro-environment and industry, as well as the competitive drivers which face organisations. They will also learn about the role that purpose, resources, and capabilities play in strategy formation and implementation, with the main purpose of this course being to develop rigour and confidence in strategic thinking. Students are then immersed in the world of designing creative, sustainable processes towards change using multiple learning strategies that can be customized for each student.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3008F	GSB	F	GSB	F
STRATEGY AND INNOVATION LAB	15	7	J Mukuddem-Petersen	\N	\N	\N	This course is structured as a lab that builds on the conceptual material taught in all the core courses. It is opened with an introduction to Strategy and then emphasizes practical application of innovation concepts in real-world contexts. The strategy component will introduce students to the fundamental principles and concepts of strategic thinking and management. It will provide the opportunity for students to develop the necessary skills for strategic thinking and analysis. Students will learn about business and corporate strategy formulation relevant to the macro-environment and industry, as well as the competitive drivers which face organisations. They will also learn about the role that purpose, resources, and capabilities play in strategy formation and implementation, with the main purpose of this course being to develop rigour and confidence in strategic thinking. Students are then immersed in the world of designing creative, sustainable processes towards change using multiple learning strategies that can be customized for each student.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3008S	GSB	S	GSB	S
STRATEGY AND INNOVATION LAB	15	7	J Mukuddem-Petersen	\N	\N	\N	This course is structured as a lab that builds on the conceptual material taught in all the core courses. It is opened with an introduction to Strategy and then emphasizes practical application of innovation concepts in real-world contexts. The strategy component will introduce students to the fundamental principles and concepts of strategic thinking and management. It will provide the opportunity for students to develop the necessary skills for strategic thinking and analysis. Students will learn about business and corporate strategy formulation relevant to the macro-environment and industry, as well as the competitive drivers which face organisations. They will also learn about the role that purpose, resources, and capabilities play in strategy formation and implementation, with the main purpose of this course being to develop rigour and confidence in strategic thinking. Students are then immersed in the world of designing creative, sustainable processes towards change using multiple learning strategies that can be customized for each student.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3008X	GSB	X	GSB	X
STRATEGY AND INNOVATION LAB	15	7	J Mukuddem-Petersen	\N	\N	\N	This course is structured as a lab that builds on the conceptual material taught in all the core courses. It is opened with an introduction to Strategy and then emphasizes practical application of innovation concepts in real-world contexts. The strategy component will introduce students to the fundamental principles and concepts of strategic thinking and management. It will provide the opportunity for students to develop the necessary skills for strategic thinking and analysis. Students will learn about business and corporate strategy formulation relevant to the macro-environment and industry, as well as the competitive drivers which face organisations. They will also learn about the role that purpose, resources, and capabilities play in strategy formation and implementation, with the main purpose of this course being to develop rigour and confidence in strategic thinking. Students are then immersed in the world of designing creative, sustainable processes towards change using multiple learning strategies that can be customized for each student.	\N	Attendance at all contact sessions except with permission of the programme convener. Submission of assessments by the due date.	The course is assessed by means of individual assignments and a final examination. In order to pass the course, students must obtain a DP and a minimum of 50% on individual assessment components.	\N	GSB3008Z	GSB	Z	GSB	Z
ECOLOGICAL STATISTICS	15	9	Associate Professor R Altwegg	\N	\N	\N	This module covers the latest statistical methods particular to ecological statistics. Topics include capture-mark-recapture models (closed and open populations, multi-state models), occupancy models, distance sampling, spatially explicit capture-recapture models, and state-space models in ecology, models for animal movement. The course may not be offered every year.	\N	40% for the assignment component	Assignments 50%. Examination 50%. A subminimum of 40% in both the assignment and examination component is required.	\N	STA5064Z	STA	Z	STA	Z
MANAGERIAL FINANCE	18	5	FTX1005F TBC / FTX1005S N Jwara	Matriculation mathematics, Mathematics Literacy or registration for the Post graduate diploma in Management in Entrepreneurship, Marketing Sport Management Tourism and Business Communication.	\N	This course is designed to provide a general introduction to the study of the financial function in business, particularly in a South African environment. The course has two primary objectives: Firstly to expose students with little or no commercial or financial background to the fundamentals of the financial aspects of business and the environment in which businesses operate. The second objective is to afford the students with the opportunity of gaining as much practical experience as possible in key areas of Finance, Management Accounting and Accounting.	This course is designed to introduce students with little or no commercial or financial background to the fundamentals of managerial finance. Having completed the course students should have a basic understanding of accounting concepts, be able to read financial statements and perform basic (ratio) analysis of key performance areas of the business, understand the concept of time value of money, employ basic steps toward efficient working capital management and have a basic understanding of capital budgeting and valuations. The course covers the following key topics: Introduction to basic accounting concepts, understanding annual financial statements, source of finance, basic financial ratio analysis, investments, risk & return, working capital management, cost volume profit analysis, budgeting, time value of money, basic valuations, cost of capital, discounted cash flow, and capital budgeting.	Monday, Wednesday, Thursday & Friday: 12h00 -12h45	Writing all class tests. Attendance and submission of 80% of tutorials. Satisfactory completion of the project and assignments. 40% average year mark.	Class tests, 1-15%; 2-15%; objective tests (10% - Best 5 out of 10); 1 group project (10%); final examination (50%).	This course will be run in 2024, unless less than 20 students sign up for it.	FTX1005F	FTX	F	FTX	F
MATHEMATICS 1033	18	5	Dr H Wiggins	At least 70% in NSC Mathematics	\N	\N	The aim of this course is to introduce students to the fundamental ideas in differential calculus. It is designed for students majoring in mathematical and physical sciences. In addition, a fundamental aim is for students to come away with an understanding of how to read, write and apply mathematics using mathematical thinking practices for clarity, consistency and a depth of understanding that prepares them for MAM2000W, MAM3000W, and the mathematical requirements of their other Science courses.	Five lectures per week, Monday - Friday, 1st or 3rd period.	Minimum of 30% for class tests, minimum 30% for weekly online tests, 80% attendance at tutorial sessions and 100% attendance at Mathematical Thinking workshops.	Semester mark counts 33.3% and end-of-semester exam counts 66.6%.	\N	MAM1033F	MAM	F	MAM	F
MANAGERIAL FINANCE	18	5	FTX1005F TBC / FTX1005S N Jwara	Matriculation mathematics, Mathematics Literacy or registration for the Post graduate diploma in Management in Entrepreneurship, Marketing Sport Management Tourism and Business Communication.	\N	This course is designed to provide a general introduction to the study of the financial function in business, particularly in a South African environment. The course has two primary objectives: Firstly to expose students with little or no commercial or financial background to the fundamentals of the financial aspects of business and the environment in which businesses operate. The second objective is to afford the students with the opportunity of gaining as much practical experience as possible in key areas of Finance, Management Accounting and Accounting.	This course is designed to introduce students with little or no commercial or financial background to the fundamentals of managerial finance. Having completed the course students should have a basic understanding of accounting concepts, be able to read financial statements and perform basic (ratio) analysis of key performance areas of the business, understand the concept of time value of money, employ basic steps toward efficient working capital management and have a basic understanding of capital budgeting and valuations. The course covers the following key topics: Introduction to basic accounting concepts, understanding annual financial statements, source of finance, basic financial ratio analysis, investments, risk & return, working capital management, cost volume profit analysis, budgeting, time value of money, basic valuations, cost of capital, discounted cash flow, and capital budgeting.	Monday, Wednesday, Thursday & Friday: 12h00 -12h45	Writing all class tests. Attendance and submission of 80% of tutorials. Satisfactory completion of the project and assignments. 40% average year mark.	Class tests, 1-15%; 2-15%; objective tests (10% - Best 5 out of 10); 1 group project (10%); final examination (50%).	This course will be run in 2024, unless less than 20 students sign up for it.	FTX1005S	FTX	S	FTX	S
MATHEMATICS 1031	18	5	Dr H Wiggins	At least 70% in NSC Mathematics	\N	\N	The aim of this course is to introduce students to the fundamental ideas in differential calculus covering functions of one variable, limits, continuity and differentiation with applications, as well as formal proof methods. This course (or equivalent), along with MAM1032S (or equivalent) is necessary for entry into second year mathematics.	Five lectures per week, Monday - Friday, 1st or 3rd period	Minimum of 30% for class tests, minimum 30% for weekly online tests, and 80% attendance at tutorial sessions.	Semester mark counts 33.3% and end-of-semester exam counts 66.6%.	\N	MAM1031F	MAM	F	MAM	F
INDEPENDENT RESEARCH IN COMPUTER SCIENCE	24	7	Dr J Chavula	Academically strong students may apply for entrance. Selection will be made on the basis of final results in CSC1015F, CSC1016S and CSC2001F. The number of places will be limited depending on the availability of supervisors, and the final decision will be at the discretion of the Head of Department.	\N	\N	This course allows students to pursue a course of independent research in one of the areas of specialisation of the department, as listed on the department's website, under the direct supervision of one of the staff members. Students will learn research methods in Computer Science and apply these in a suitable project. They will also learn about research writing (proposal and report). Students will complete a research project and document this in a research report (mini-dissertation). An intermediate deliverable will be a project proposal and presentation to staff.	Regular meetings with supervisor, by arrangement	\N	Proposal 20%, Final research report 80%	\N	CSC2005F	CSC	F	CSC	F
INDEPENDENT RESEARCH IN COMPUTER SCIENCE	24	7	Dr J Chavula	Academically strong students may apply for entrance. Selection will be made on the basis of final results in CSC1015F, CSC1016S and CSC2001F. The number of places will be limited depending on the availability of supervisors, and the final decision will be at the discretion of the Head of Department.	\N	\N	This course allows students to pursue a course of independent research in one of the areas of specialisation of the department, as listed on the department's website, under the direct supervision of one of the staff members. Students will learn research methods in Computer Science and apply these in a suitable project. They will also learn about research writing (proposal and report). Students will complete a research project and document this in a research report (mini-dissertation). An intermediate deliverable will be a project proposal and presentation to staff.	Regular meetings with supervisor, by arrangement	\N	Proposal 20%, Final research report 80%	\N	CSC2005S	CSC	S	CSC	S
CAUSAL MODELLING	15	9	Associate Professor F Gumedze	Acceptance into Master's programs in Advanced Analytics, Data Science or Biostatistics, and/ or statistical background deemed sufficient by the Head of Department.	\N	\N	This course introduces students to the concept of causality, causal diagrams and causal modelling. Topics to be covered include Counterfactual Theory, Directed Acyclical Graphs, Propensity Scores, Inverse Probability Weighting, Marginal Structural Models, G-estimation, Path Analysis, Confirmatory Factor Analysis, Structural Equation Modelling (SEM), Multiple Group SEM, MIMIC (Multiple Indicators and Multiple Causes) Models, Multilevel SEM, and Latent Growth Curve SEM. The course covers both the theory and the application of the methods with computer software such as R, STATA and LISREL. The course may not be offered every year.	\N	40% for the assignment component	Assignments 40%. Written exam 60%. Sub-minimum of 40% in each of assignment and examination component.	\N	STA5062Z	STA	Z	STA	Z
DESIGN OF CLINICAL TRIALS	15	9	Associate Professor F Gumedze	Acceptance into Master’s program in Biostatistics, or statistical background deemed sufficient by the Head of Department.	\N	\N	This module will look at the Design of Clinical Trials. Concepts of randomisation, replication and blocking will be discussed. Students will be introduced to the different phases, that is Phases I, II, III, and IV, of trial designs. Specific designs which will also be covered include, inter alia, randomised trials, dose-escalation studies, cross-over trials, PK/PD studies, designs for survival studies and multi-centre trials. The implications of the specific design for the analysis of the data will be discussed. the course may not be offered every year.	\N	40% for the assignment component	Assignments 50%. Written exam 50%. Sub-minimum of 40% in each of assignment and examination component.	\N	STA5063Z	STA	Z	STA	Z
FINANCIAL ECONOMETRICS	15	9	To be advised	Acceptance into Master’s programs in Advanced Analytics or Data Science and/ or statistical background deemed sufficient by the Head of Department.	\N	\N	This course examines from an advanced econometric and quantitative perspective the following key areas : Market efficiency in macro-economic markets including the JSE, bond market and short-term interest rate markets; Characteristics of the JSE and its sectors; appropriate return transformations, the notion of company specific, sector specific and market wide effects; Special focus on the R$ exchange rate; its effect on local markets (JSE and bond); causes of changes and modelling the impact on inflation; Technical modelling of bond market (Nelson-Siegel parameterisation) and the share market (Black Scholes; derivatives). The course may not be offered every year.	\N	40% for the assignment component	Assignment - 30%. Examination, 3 hours 70%. A subminimum of 40% in each of the assignment and examination components.	\N	STA5065Z	STA	Z	STA	Z
MACROECONOMICS FOR THE BUILT ENVIRONMENT	18	5	G van der Rede	A minimum mark of 50% for ECO1008F or ECO1010F/S or ECO1110F/S. ECO1008F/S may be taken concurrently with ECO1009F/S if ECO1008F/S has been previously attempted.			This course is an introductory level course in macroeconomic theory and policy. Macroeconomics studies the aggregate behaviour of the economy. The list of topics covered include gross domestic product, economic growth, unemployment, inflation, exchange rates, balance of payments, business cycles, fiscal and monetary policy tools and objectives. The course will build on macroeconomic relationships to develop basic models explaining various interactions within the economy, providing students with a framework for understanding and interrogating the workings of the economy. The course emphasizes relevant and current issues in the context of South African economic history. We also explore South Africa’s relationship with the rest of the world.	Tuesday, Wednesday, Thursday and Friday 09h00 - 10h00; 10h00 - 11h00; 11h00 - 12h00; 12h00 - 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework (50%) and final exam (50%). The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The ECO1009S supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO1009F	ECO	F	ECO	F
MACHINE LEARNING	15	9	Dr E Pienaar	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/ or statistical and computing background deemed sufficient by the Head of Department.	\N	\N	This course serves as an overview of the increasingly important field of Machine Learning. Topics covered include the fundamentals of the Machine Learning Paradigm, the Vapnik-Chervonenkis Inequality, the Bias-Variance Tradeoff, Regularization, Cross-Validation, Linear and Nonlinear Dimension Reduction, Support Vector Machines, Neural Networks, Convolutional Neural Networks, and other contemporary topics in Machine Learning. The course may not be offered every year.	\N	40% for assignment and project component	Assignments, making up the course mark, and two exams, one written and one computer-based exam. A subminimum of 40% is required for each component.	\N	STA5068Z	STA	Z	STA	Z
MULTIVARIATE STATISTICS	15	9	Dr S Er	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/ or statistical background deemed sufficient by the Head of Department.	\N	\N	In this module, multivariate statistical analysis methods with associated graphical representations will be discussed. Topics to be covered include Principal Component Analysis and PCA biplots, Simple and Multiple Correspondence Analysis, Multidimensional Scaling, Cluster Analysis, Discriminant Analysis, Canonical Variate Analysis, Analysis of Distance and Biadditive Models. The course may not be offered every year.	\N	40% for assignment component	Assignments 40%. Written examination 60%. Sub-minimum of 40% in each of assignment and examination component.	\N	STA5069Z	STA	Z	STA	Z
PROBLEM STRUCTURING AND SYSTEM DYNAMICS	15	9	Dr R G Rakotonirainy	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	Problem Structuring: We explore a number of tools and methods which support the initial phases of a process of enquiry or analysis. Our interest is in understanding both the epistemological basis of different approaches as well as evaluating the extent to which they add rigour and promote insight. We will be critiquing the efficacy of different approaches through a variety of case studies. System Dynamics: We discuss features that result in complexity of systems, with case studies. These are then represented first qualitatively and then quantitatively in simulation studies using appropriate software (Vensim is proposed). The course may not be offered every year.	\N	40% for project work components.	Problem Structuring section: project work (50%); written exam (50%). System Dynamics section: project work (40%); written exam (60%). The two sections count equally to the final grade. In each section a subminimum of 40% is required in both the project and written exam.	\N	STA5070Z	STA	Z	STA	Z
SIMULATION AND OPTIMISATION	15	9	Associate Professor S Silal	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/ or statistical background as deemed sufficient by the Head of Department.	\N	\N	This module is split into three sections: Simulation (Random Number Generation, Monte Carlo Methods, Statistical Analysis of Simulated Data, Variance Reduction, Bootstrap Methods, Markov Chain Monte Carlo), Fundamentals of Linear and Nonlinear Optimization (Unconstrained and Constrained Optimization, Kuhn-Tucker Duality, Convexity, Quadratic Programming, Dynamic Programming, Stochastic Programming) and Stochastic Methods in Optimization ("No Free Lunch" Theorems, Metaheuristics, Random Search, Simulated Annealing, Evolutionary and Genetic Algorithms, Partition Algorithms). The course may not be offered every year.	\N	40% for assignment component	Module is split into three sections. For each section, we have: Assignments: 50% Exam: 50%. A subminimum of 40% in each of the assignment and exam component is required.	\N	STA5071Z	STA	Z	STA	Z
SURVIVAL ANALYSIS	15	9	Associate Professor F Gumedze	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/ or statistical background deemed sufficient by the Head of Department.	\N	\N	This module will look at advanced methods for the analysis of survival data. We will first review the Cox proportional hazards model. The advanced methods to be covered will include handling time- varying effects in the Cox proportional hazards model, parametric survival models, accelerated failure time model, frailty models and recurrent events models, competing risks models, extension of the Cox proportional hazards model for time-dependent variables and joint models for longitudinal and time-to-event outcomes.. Both the underlying theory and the application of these models using appropriate statistical software are covered. The course may not be offered every year.	\N	40% for the assignment component	Assignments 50%. Written exam 50%. Sub-minimum of 40% in each of assignment and examination component.	\N	STA5072Z	STA	Z	STA	Z
ADVANCED CALCULUS (2AC)	12	6	Dr F Ebobisse-Bille	MAM1031F and MAM1032S or equivalent. With permission from the convener, students with 70% for both MAM1010F and MAM1012S may register for MAM2010F.	\N	\N	Students will study the fundamentals of multivariable calculus, including: Curves and surfaces in three dimensions, change of coordinates; Line integrals, surface integrals; Stoke's, Green's and divergence theorems. Please note that lectures alternate during the week so that students can take MAM2010F and MAM2011F concurrently.	Tuesdays, Fridays and some Wednesdays in 5th period.	\N	\N	\N	MAM2010F	MAM	F	MAM	F
MACROECONOMICS FOR THE BUILT ENVIRONMENT	18	5	G van der Rede	A minimum mark of 50% for ECO1008F or ECO1010F/S or ECO1110F/S. ECO1008F/S may be taken concurrently with ECO1009F/S if ECO1008F/S has been previously attempted.			This course is an introductory level course in macroeconomic theory and policy. Macroeconomics studies the aggregate behaviour of the economy. The list of topics covered include gross domestic product, economic growth, unemployment, inflation, exchange rates, balance of payments, business cycles, fiscal and monetary policy tools and objectives. The course will build on macroeconomic relationships to develop basic models explaining various interactions within the economy, providing students with a framework for understanding and interrogating the workings of the economy. The course emphasizes relevant and current issues in the context of South African economic history. We also explore South Africa’s relationship with the rest of the world.	Tuesday, Wednesday, Thursday and Friday 09h00 - 10h00; 10h00 - 11h00; 11h00 - 12h00; 12h00 - 13h00.	All tests/assignments/essays/projects/tutorial attendance/submissions to be completed for DP purposes (details will be provided in the course documentation). If your year mark is below 40% you will not be permitted to write the final examination.	Coursework (50%) and final exam (50%). The course documentation will detail the breakdown for assessment weightings and variation for exemptions and absences.	The ECO1009S supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO1009S	ECO	S	ECO	S
DATA SCIENCE FOR INDUSTRY	15	9	Associate Professor I Durbach	Acceptance into the Master's course in Data Science or quantitative background deemed sufficient by Head of Department.	\N	\N	The goal of the module is to provide an applied, hands-on overview of selected topics useful in the working world of data science that are not covered by other modules in the program. Topics fall into two themes: workflow/productivity tools and skills; and modelling. Under the workflow theme we cover data wrangling (reading/writing data, webscraping, accessing APIs), version control with Git, and visualization and communication of data and results (ggplot2, R shiny). Under the modelling theme we cover recommender systems, text mining and basic natural language processing, and feedforward and convolutional neural networks.	\N	At least 40% for the assignments section	Assignments: 50%. Examination: 50%. A sub-minimum of 40% for each of the assignment and examination component will be required.	\N	STA5073Z	STA	Z	STA	Z
DECISION MODELLING FOR PRESCRIPTIVE ANALYTICS	12	9	Dr R G Rakotonirainy	Acceptance into the Master’s course in Data Science or quantitative background deemed sufficient by Head of Department.	\N	\N	This course aims to develop an understanding of the role of formal (soft and hard; deterministic and stochastic) modelling in decision support and analyses, to develop understanding of the key technologies behind decision modelling for prescriptive analytics, and to introduce new tools and techniques for analysing data in new ways in order to improve decision making.	\N	None	Assignments and Exam	\N	STA5074Z	STA	Z	STA	Z
STATISTICAL AND HIGH PERFORMANCE COMPUTING	12	9	S Salau	Acceptance into the Master’s course in Data Science or quantitative background deemed sufficient by Head of Department.	\N	\N	This course aims to provide students with a foundation in statistical computing for data science. The course is divided into three sections, namely Basic Programming, High Performance Computing and Simulation & Optimisation. In the first section, students will learn how to write computer programs to analyse data with the R Language and Environment for Statistical Computing. Students will then be taught how to run jobs in parallel on a remote computer cluster using a Linux command prompt. Finally, the course will introduce students to the fundamental principles and uses of simulation and optimisation.	\N	None	Assignments and Exam.	\N	STA5075Z	STA	Z	STA	Z
COMPLEX ANALYSIS (3CA)	18	7	Associate Professor E Berdysheva	MAM2010F, MAM2011F, MAM2014S and at least one of MAM2012S or MAM2013S.	\N	\N	Fields of complex numbers, Holomorphic functions, Power series, Elementary functions, Complex integration, Cauchy's Integral Theorem, Cauchy's Integral Formula, Liouville’s Theorem, Fundamental Theorem of Algebra, Coincidence Principle, Maximum Modulus Principle, Singularities, Residues, Laurent Series, Arguments, Rouche's Theorem, Open Mapping Theorems.	Tuesdays, Fridays and some Wednesdays in 4th period.	\N	\N	\N	MAM3015F	MAM	F	MAM	F
SUPERVISED LEARNING	18	9	Dr S Er	Acceptance into the Master’s program in Data Science or Advanced Analytics and/or statistical background deemed sufficient by Head of Department.	\N	\N	Supervised learning is a set of statistical modelling tools for predicting or estimating the relationships between predictor and target variables in complex data sets. This course covers essential concepts like the bias-variance trade-off; regularisation; variable selection procedures; and model evaluation and comparison. The modelling techniques include linear and non-linear regression; logistic regression; classification and regression trees; and ensemble techniques like random forests and gradient boosting. The course also introduces Support Vector Machines, Neural Networks, and Deep Learning principles, emphasising practical application in R to equip students with the skills needed to make informed decisions in predictive analytics.	\N	None	Six quizzes (25%) and a take-home exam on each of three sections (75%)	\N	STA5076Z	STA	Z	STA	Z
UNSUPERVISED LEARNING	12	9	M Ngwenya	Acceptance into the Master’s course in Data Science or quantitative background deemed sufficient by Head of Department.	\N	\N	As part of the Master's in Data Science degree this course aims to familiarise students with the statistical methodology needed to analyse relationships between variables in big data without having causal relationships with predictor and response variables. Topics covered include association rules and market basket analysis, self-organising maps, multidimensional scaling, cluster analysis, principal component analysis.	\N	\N	Assignments and Exam.	\N	STA5077Z	STA	Z	STA	Z
STOCHASTIC PROCESSES	15	9	M Mavuso	STA4029Z, Honours course in Advanced Probability Theory or at the discretion of the Head of Department.	\N	\N	The course aims to cover advanced concepts in stochastic processes and stochastic calculus, together with some financial applications. Topics included in the course are as follows: Semimartingales, stochastic integration, Ito's formula, Feyman-Kac theorem, martingale representation, discrete trading, continuous trading.	\N	Class record of at least 40%	Assignments, Class Test and Exam.	This course may not be offered every year.	STA5078Z	STA	Z	STA	Z
VECTOR CALCULUS FOR ENGINEERS	16	6	Dr E Fredericks	MAM1020 or equivalent and MAM1021 or equivalent.	\N	\N	This course aims to develop an understanding of differentiation of vector valued functions, space curves and surfaces. Partial derivatives, chain rule, maxima and minima, Lagrange multipliers. Gradient, divergence and curl. Taylor's theorem for one and several variables, Jacobians, Newton's method for several variables. Multiple integrals and change of variable. Surface integrals. Line integrals, work done by a force, potentials. Green's theorem, divergence theorem, and Stokes' theorem.	\N	35% class record and satisfactory tutorial attendance.	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	This course is designed specifically for students in the Faculty of Engineering & the Built Environment.	MAM2083S	MAM	S	MAM	S
CRITICAL THINKING	18	5	Associate Professor E Galgut	None			Why do we value our beliefs? We value them because we take them to be true and, as true, they are good guides. But how can we tell when a belief is true? Our only handle here is whether or not the belief is justified. So we aim to have beliefs that are justified. The course concentrates on the practical business of appraising justifications. Of course, we all routinely attempt to justify our beliefs and arrive at new beliefs on the basis of supposed justifications. But almost as routinely we are hoodwinked. The course aims to make students better believers by making them more aware of the nature of justification, of the different sorts of justification and the pitfalls of each. At the end of it they will be less gullible and more able to explain just why a particular argument does or doesn't convince them. As an Introductory course we employ teaching and delivery methods that allow for active engagement and the development of critical reading and writing skills in the Humanities.	Monday, Tuesday, Wednesday 3rd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 50%; one 2-hour examination in June counts 50%.		PHI1025S	PHI	S	PHI	S
FLUID DYNAMICS (3FD)	18	7	Professor A Malan	MAM2040F, MAM2041F, MAM2042S and MAM2043S.	\N	\N	Applications, description of fluids, equations of fluid flow for simple fluids, analytical techniques.	Monday and Tuesday, meridian. Thursday, 5th period.	\N	\N	\N	MAM3046S	MAM	S	MAM	S
THE HUMAN PLANET: PREHISTORY TO PRESENT	18	5	Dr V J Hare	None	\N	\N	This aim of this course is to introduce the study of archaeology, and the study of human origins. Archaeology is defined as the study of the human past through material culture. Over the second semester, this course presents an overview of prehistory leading up to the modern day, as well as the broader climatic, geographic, ecological, social, and cultural contexts which made modern humans. In particular, it looks at the past through the lens of what people leave behind - the archaeological record. What you can expect to take away from this course: •A broad understanding of the timescales of human prehistory, and our interactions with the Earth System, from the Early Pleistocene through to the Historical period, and the emergence of present day societies (the "Anthropocene"). •An understanding of current concepts in archaeological thought, and the complexities of relationships between archaeologists, science, and society today. •Familiarity with the foundational skills and terminology necessary for present-day archaeological research and investigation. This broad course is suitable for all undergraduate students in the sciences and humanities; but particularly for those wishing to major in Archaeology, Environmental & Geographical Science, or cognate subjects.	Monday - Thursday, 5th period	Attendance at lectures and tutorials and completion of assignments.	Assignments and class tests count 50% towards the final mark and one 3-hour examination written in November counts 50%. A sub-minimum of 40% is required for the examination.	\N	AGE1002S	AGE	S	AGE	S
HUMAN EVOLUTION	24	6	Professor R Ackermann	Any first-year Science course, or any first-year Humanities course from a related discipline such as Social Anthropology, Historical Studies, Sociology, etc or by permission of the Head of Department.	\N	\N	In AGE2011S we examine the record of primate and human evolution, showing how fossil skeletons and artefacts are interpreted in terms of human behaviour and evolutionary processes. We also consider genetic and other comparative evidence that are increasingly providing insight into the origin of our lineage. We answer questions such as: Why did our ancestors evolve in Africa? How did we evolve such large and complex brains? What advantage does bipedalism provide? When do humans begin to make tools? Why is human skin colour so variable? What makes humans unique? The syllabus for AGE2011S includes practical sessions for the study of primate and human, fossil and recent skeletal material and the artefacts associated with our ancestors.	Monday - Thursday, 3rd period, Practicals: One 2-hour practical per week, at times to be arranged	Attendance at lectures and practicals and completion of assignments.	Assignments and tests count 50%; one 3-hour examination in October/November counts 50%. A sub-minimum of 40% is required for the examination.	\N	AGE2011S	AGE	S	AGE	S
THE FIRST PEOPLE	24	6	Dr Y Sahle	Any first-year Science course; or any one of AXL1400F (was SAN1015F,) or AGE1002S or equivalent first-year semesters; or AGE2011S; or any first-year Humanities course from cognate disciplines such as Anthropology, Historical Studies, Sociology; or by permission of the Head of Department.	\N	\N	All humans living today have a common African origin. The first humans were hunter-gatherers, as were their descendants. Indeed, our ancestors were hunter-gatherers for at least 99% of our evolutionary history, which means that our physical, psychological and social selves have been shaped by this way of life. We learn about the origin and evolution of our hunter-gatherer ancestors from genetic, fossil, archaeological and ethnographic evidence. Studies of Khoesan peoples of southern Africa have contributed significantly to our understanding of such societies. In this course we focus on the hunter-gatherer way of life over the past few hundreds of thousands of years. Specific topics covered include modern human origins, the Middle and Later Stone Age, ethnographic studies of Khoesan, the origins of pastoralism, coastal vs. arid environment adaptations, rock art and symbolic interpretation, genetics and biology, revisionism, and contemporary socio-politics and identity. In the weekly practical sessions, students will conduct hands-on, problem-solving exercises with archaeological materials.	Monday - Thursday, 3rd period, Practicals: One 2-hour practical per week, at times to be arranged	Attendance at lectures and practicals, completion of assignments and participation in a one-day museum trip.	Assignments and practical tests count 50% towards the final mark and one 3-hour examination written in June counts 50%. A sub-minimum of 40% is required for the examination. Third-Year Courses	\N	AGE2012F	AGE	F	AGE	F
ADVANCED PORTFOLIO THEORY	15	9	Associate Professor T Gebbie	Acceptance into Master’s programs in Advanced Analytics or Data Science, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	The course Advanced Portfolio Theory is intended to expose students to the more advanced topics in portfolio theory, portfolio management and risk management. Statistical techniques such as optimisation, simulation, spectral decomposition of the covariance matrix and robust optimisation are some of the techniques that will be utilised in the models. Notwithstanding the emphasis in this course is on the practical application of the models and theories. There will thus be an emphasis on on the qualification of these measures and parameterisation of models in a South African (and African) setting. Furthermore there will be a focus on the interpretation and linkages between the concepts. Topics covered include: Interest rates;Equity evaluation; Portfolio risk components; risk in thinly-traded environments- the SA and African case; Advanced risk measures; systematic risk; eigenvectors; tail risk measures. Active management and the Generalised Fundamental Law. Absolute and Active Portfolio optimisation; the Black-Litterman Model; the Qualitative Model, Non-parametric Models, Robust Portfolio optimisation models including Bayesian shrinkage. Rebalancing of portfolios. Advanced performance measures. Asset pricing models. The course may not be offered every year.	\N	\N	Final examination counts 60% and the assignments count the remaining 40%	Fifth year status, second semester, two double lectures per week (24 lectures).	STA5086Z	STA	Z	STA	Z
BASICS OF MATHEMATICAL STATISTICS	0	9	Associate Professor F Gumedze	Acceptance into MPhil Mathematical Finance or another Master's program in Statistical Sciences.	\N	\N	This course will serve as an introduction to mathematical statistics for postgraduate students with a good mathematical background who have not studied statistics before. The course will include probability theory, distribution theory and statistical inference, including Estimation, Maximum Likelihood, Large Sample Theory; The Method of Moments, Efficiency; Hypothesis Testing; Tests for Distribution and Tests for Normality; Confidence Intervals.	\N	None	One examination counting 100% of the final mark	Preliminary block course, before start of first semester (24 lectures). This course may not be offered every year.	STA5089F	STA	F	STA	F
ADVANCED TOPICS IN REGRESSION	15	9	Dr A Clark	Acceptance into Master’s programs in Advanced Analytics, Data Science or Biostatistics, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	Linear regression and generalised regression and generalised methods such as shrinkage, splines, kernel smoothing methods and wavelets. Model selection and model assessment. Principal component regression, partial least squares regression, mixture models and generalised additive models. The course may not be offered every year.	\N	\N	Assignments and/or Exam	\N	STA5090Z	STA	Z	STA	Z
DATA-ANALYSIS FOR HIGH-FREQUENCY TRADING	15	9	Associate Professor T Gebbie	Acceptance into Master’s programs in Advanced Analytics or Data Science, and/or statistical background deemed sufficient by the Head of Department.	\N	\N	The course aims to equip students with data-science skills required to manage and explore high- frequency financial market data. This includes managing large financial data-sets, carrying out statistical analysis of large data-sets and knowledge relating to the link between statistical analysis of fast large data-sets, the modeling thereof and how this can be used to understand and control real- time trading and risk systems in modern financial markets. The course aims to consolidate prior knowledge relating to the statistical properties of daily sampled financial data and to then extend this to the analysis, exploration and data-science of large data-sets relating to both limit-order data and real-time transaction data. Students will acquire skills in Understanding and Preparing Financial Market Data; Data Science of Market Microstructure; Market Structure and Market Microstructure; Statistical Learning for Financial Market Data.	\N	\N	\N	This course may not be offered every year.	STA5091Z	STA	Z	STA	Z
EXPLORATORY DATA ANALYSIS	12	9	Dr S Er	Acceptance into Master's program in Data Science or Advanced Analytics and/or statistical background deemed sufficient by Head of Department.	\N	\N	As part of the MSc specialising in Data Science, this course aims to introduce the essential techniques for performing exploratory data analysis (EDA). These techniques are typically applied before formal modelling commences and allow the researcher to discover patterns, spot anomalies, test hypotheses and check assumptions with the help of summary statistics and graphical representations. Different types of data will be described and the appropriate EDA techniques for each data type will be introduced. We will distinguish between univariate and multivariate, as well as graphical and non-graphical techniques, and will teach the R syntax required for each. Presentation of an EDA with interactive elements in a dashboard environment will also be covered and assessed.	\N	\N	A take-home exam on each of the three sections	\N	STA5092Z	STA	Z	STA	Z
DATA SCIENCE MINOR DISSERTATION	60	9	Dr S Er	Successful completion of the coursework component of the Masters course in Data Science.	\N	\N	The research component of the degree is based on a 60 credit dissertation. The topic of the research will be based on an analysis of large data sets from Physics, Astronomy, Medicine, Finance or other areas of application using the methodology learnt in coursework component.	\N	\N	\N	\N	STA5093W	STA	W	STA	W
COOPERATION AND COMPETITION	18	6	M Keswell	ECO1010 or MAM1010 (or equivalent)	\N	\N	This is an introductory course in game theory, the framework for analysing strategic interaction. Game theory is (among other things), the basic technology for understanding most phenomena in microeconomics and some phenomena in macroeconomics, along with many processes in political science, law, evolutionary biology, and the science of animal behaviour (ethology). In this course we will study the basic structure of the theory. All mathematics will be either self-contained within the course, or will be familiar from STA1000 or MAM1010.	09h00 - 10h00 and 11h00 - 12h00; Monday, Tuesday, Wednesday, Thursday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weighting and variation for exemptions and absences.	\N	ECO2007S	ECO	S	ECO	S
STATISTICAL SCIENCES THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in book 3, General Rules and Policies.	\N	\N	\N	\N	STA6001W	STA	W	STA	W
ARCHAEOLOGY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	AGE6000W	AGE	W	AGE	W
THE ROOTS OF RECENT AFRICAN IDENTITIES	36	7	Associate Professor A Esterhuysen	AGE2011S or AGE2012F, or by permission of the Head of Department.	\N	\N	In this course we explore the history of Africa’s people over the past 2000 years with special reference to southern Africa. Why are southern African populations so diverse? What lies behind the linguistic map that we see today? What social, technological and palaeoenvironmental systems shaped the evolution of societies? Did Africa have any civilisations? Who did Africa interact with? We discuss the archaeological record of artefacts, settlement systems, food waste, environmental contexts and human skeletons. We deploy historical, material science, molecular science, anthropological and palaeoclimatic techniques to explore this rich and diverse heritage of the last two thousand years.	Monday - Thursday, 4th period, Practicals: One 2-hour practical per week, at times to be arranged	Attendance at lectures and practicals, completion of assignments.	Assignments and class tests count 50% towards the final mark and one 3-hour examination written in June counts 50%. A sub-minimum of 40% is required for the examination.	\N	AGE3011F	AGE	F	AGE	F
DATA SCIENCE FOR ASTRONOMY	12	9	To be advised	Core modules of the Master's in Data Science course.	\N	\N	This course introduces students to various aspects of data intensive astrophysics, ranging from data visualisation and complex databases, to advanced statistical tools for astronomical data analysis and computational astrophysics. At the core of this module are examples in modern data-intensive astrophysics derived from the global data challenges around MeerKAT, the Square Kilometre Array (SKA), associated projects in radio astronomy, and other large multi-wavelength surveys. Students will be introduced to the use of Bayesian statistics in astronomy, the complexity of visualising large data cubes, optimising database operations in the presence of multi-dimensional data, data mining and discovery tools, and the role of large-scale simulations to interpret the significance of astronomical observations.	\N	50% average for the two projects.	Two projects: 25% each. Practical 'take-home' data science examination: 50%. A sub- minimum of 50% for each of the projects, and examination component will be required.	\N	AST5004Z	AST	Z	AST	Z
ARCHAEOLOGY IN PRACTICE	36	7	Associate Professor D Stynder	AGE2011S and AGE2012F, or by permission of the Head of Department.	\N	\N	The course will run throughout the academic year. The lecture programme (campus and field) will be flexible and a schedule will be decided upon in consultation with participating students. The curriculum covers training in site location, excavation, field note taking, stratigraphic observation, site survey, use of GPS and total station, photography, rock art recording, processing of field observations, spread sheet use, preliminary conservation and accessioning of materials, preliminary analyses and report writing.	\N	Participation in all field excursions and completion of all assignments.	Assignments 30%; Research paper 20%; Practical examination 25%; Theory examination 25%.	Please note that this course requires you to make yourselves available for field excursions during the first (March/April) and second (June/July) vacations of the academic year. While the majority of field excursions are likely to be day trips, there will be a four-week residential field-school during the second vacation. It is mandatory to participate fully in all field excursions.	AGE3013H	AGE	H	AGE	H
STATISTICAL ECOLOGY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in book 3, General Rules and Policies. SCIENCE DEGREES FACULTIES TOWARDS SCIENCE DEGREES Departments in the Faculty of Commerce COLLEGE OF ACCOUNTING Head of College and Professor: I Lubbe, BCom(Hons) Johannesburg HDTE MPhil (Higher Education Studies) Cape Town CA(SA)	\N	\N	\N	\N	STA6002W	STA	W	STA	W
INTRODUCTION TO ELECTRICAL ENGINEERING & POWER UTILISATION	16	6	Dr S Jayalath	PHY1013F/S (MEC), MAM1021S (MEC), PHY1004W or PHY1032S (CSC), MAM1004F (>60%) and MAM1008S (>60%) or MAM1000W (CSC)	\N	\N	This course aims to develop an understanding of (a) DC circuits and networks including series and parallel circuits, Kirchhoff’s laws, Mesh Analysis, Superposition Theorem, Star-to-delta and Delta- to-star Transformation, Thevenin’s theorem, Maximum Power Transfer theorem, DC transients in R-L and R-C circuits; (b) Fundamentals of AC including generation, concepts of waveform, period, frequency, angular velocity, phase etc., average, peak and RMS values; (c) Single-phase AC circuit including AC through resistance (R), inductance (L) and capacitance (C), concept of reactance and impedance, phasors, single-phase AC series and parallel circuits, concept of active power, reactive power, apparent power and power factor; (d) Three-phase AC systems; (e) Magnetic circuits including definition of magnetic circuits, simple and composite magnetic circuits and magnetic circuit calculations; (f) Single-phase transformers including core construction, principle of operation, e.m.f. equation and transformation ratio, no-load and on-load operation, phasor diagram under no-load and full-load operation, exact and approximate equivalent circuits, voltage regulation, losses and efficiency and open and short circuit tests; (g) DC motors including principle of operation, e.m.f. equation, types of motors, speed and torque characteristics and speed control.	\N	Please refer to the official course handout document for detailed information regarding the DP requirements for this course.	Please refer to the official course handout document regarding the assessment criteria for this course.	For students in the Mechanical Engineering and Mechanical & Mechatronic Engineering programmes and Computer Science.	EEE2041F	EEE	F	EEE	F
INTRODUCTION TO ANALOGUE AND DIGITAL ELECTRONICS	8	6	Associate Professor F Nicolls	MAM1021F/S (MEC), PHY1013F/S (MEC), PHY1004W or PHY1032S (CSC), MAM1004F (>60%) and MAM1008S (>60%) or MAM1000W (CSC), DP for EEE2041F.	\N	\N	The course aims to help students understand the following concepts: (a) Introduction to Semiconductor Physics and Diode basics. (b) Diode circuit model, applications and LEDs (c) Introduction to BJTs and basic models (d) BJT amplifier circuit (only focus on common-emitter) (e) Introduction to Op Amps, op-amp ideal and practical models (f) Opamp inverting and non-inverting applications (g) Introduction to FETs, FET analogue applications (h) Simple H-bridge circuits (i) SCIENCE DEGREES Difference between analogue and digital applications, intro into digital electronics (j) Digital electronic continued (Boolean algebra, logic gates) (k) FET digital applications, introduction to Flip Flops (l) Basics of state machines and electronic instruments.	\N	Please refer to the official course handout document for detailed information regarding the DP requirements for this course.	Please refer to the official course handout document regarding the assessment criteria for this course.	For students in the Mechanical Engineering and Mechanical & Mechatronic programmes and Computer Science.	EEE2042S	EEE	S	EEE	S
ASTRONOMY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	AST6000W	AST	W	AST	W
1ST ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE1	\N	\N	\N	\N
FIELD GEOLOGY & GEOLOGICAL MAPPING	24	6	Associate Professor J F Diener	GEO1006S, GEO2004S (co-requisite)	\N	\N	This is a field-based course that introduces techniques used to identify, describe and document rocks in the field and for interpreting their inter-relationships, with the view to producing geological maps, stratigraphic logs and structural sections. Techniques covered include: mineralogical and textural descriptions of rocks using a hand-lens; measurement of attitude of bedding using compass and clinometer; measurement, description and interpretation of depositional and deformational structures; stereo plots, interpretation and use of aerial photographs; identifying contact relationships; GPS positioning. Course material is taught over four separate field camps spread over two years of study.	None	Attendance at all field camps	Maps and reports count 70%; three 2-hour practical examinations in June and November count for 30%.	\N	GEO2005X	GEO	X	GEO	X
DATA SCIENCE MINOR DISSERTATION	90	9	Dr S Er	Successful completion of the coursework component of the Masters course in Data Science.	\N	\N	The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on an analysis of large data sets from Astronomy.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	AST5005W	AST	W	AST	W
INTRODUCTION TO GENERAL RELATIVITY (3GR)	18	7	Dr B Mongwane	MAM2040F, MAM2041F, MAM2042S and MAM2043S.			This course introduces special relativity and general relativity including tensors, the metric tensor, symmetries, curvature, Einstein's field equations and solutions of Minkowski space and Black Holes. Please note that lectures alternate during the week so that students can take MAM3043S and MAM3045S concurrently.	Monday - Friday, 3rd period.		Class record counts up to 50%, while the balance is given by the final examination.		MAM3045F	MAM	F	MAM	F
TOWARDS A DECOLONISED SCIENCE IN SOUTH AFRICA	18	5	Professor R Ackermann				This course addresses some key topics relevant to the decolonization of science in South Africa. Course objectives are as follows: (1) to contrast the science behind human diversity (e.g. skin colour variation, sex) with socially-constructed categories (e.g. race, gender binary); (2) to demonstrate how the history of racism and gender bias has limited the focus of scientific enquiry; (3) to highlight the importance of diversity and diverse voices in the production of scientific knowledge, (4) to show how African voices in particular have shaped and are continuing to shape the trajectory of science. The approach is a blended learning environment which combines online lectures, tutorials, tasks, and assessments. Guests both within UCT and from further afield will be brought in to supplement material through lectures, interviews and/or short case studies.			Class participation (workshops/tutorials and online discussions) 20%, online tests 20%, final exam 30%, final project 30%. NOTE: The allocation of 30% to the final exam breaks with the traditional 50% threshold. Given the format and intense interactive nature of the courses, the decision has been made that a large component of student assessment should be a course project which allows them to engage with and reflect on their changing understanding of decolonisation and race in the course. This project will be equal weight to the exam, and will be externally examined.	(offered during winter term)	AGE1005L	AGE	L	AGE	L
GALACTIC & EXTRAGALACTIC ASTROPHYSICS	36	7	Dr J Delhaize	AST2002H and AST2003H, PHY2004W, MAM2000W (or MAM2004H and MAM2047H or equivalent credit courses).	\N	\N	The aim of this course is to provide a broad introduction to galactic & extragalactic astrophysics and cosmology. Topics will include the Milky Way and normal galaxies, supermassive black holes, active galaxies, clusters of galaxies, and cosmology and the origin of structure in the universe. Current hot topics in the area are also discussed in lectures from time to time and students are encouraged to keep abreast of the latest developments. A further aim is to develop observing data reduction skills. Students will therefore participate in a fieldtrip to the South African Astronomical Observatory in Sutherland, where they will obtain their own spectroscopic data and will be taught how to do the data reduction and analysis.	Monday - Friday, 2nd period, Tutorials/Practicals: One practical or tutorial per week, Wednesday, 14h00 - 17h00; one observing practical extending over several days/nights in Term 4.	Satisfactory attendance at lectures and tutorials; class record of at least 35%.	Class record 50% (this includes two class tests, tutorials, and practicals); one 2-hour final examination 50%; subminimum requirement of 40% for final examination.	\N	AST3003S	AST	S	AST	S
INTRODUCTION TO ASTRONOMY	18	5	Associate Professor S-L Blyth	None	\N	\N	The course introduces students to the subject of Astronomy and our place in the universe from the small scales of the Earth-Sun-Moon system to the large scales of distant galaxies. It aims to provide insight into how we study astrophysical objects via EM radiation and telescopes (theory) as well as providing a high-level overview of objects in the universe, moving outwards from our solar system, to stars and stellar remnants, our galaxy and others, dark matter and cosmology, and the study of the universe at the largest scales. The course is open to all interested students as well as providing a solid introduction to those wishing to continue in astrophysics.	Monday - Friday, 5th period. Practicals: One compulsory practical or tutorial per week, Wednesday, 14h00 -17h00.	Satisfactory attendance at lectures and compulsory attendance at Wednesday afternoon sessions and submission of bi-weekly problem sets and poster project; class record of at least 35%.	Class record: 50%; final examination 2 hours: 50%. Sub-minimum: 40% for final examination.	Two practical sessions are held in the Planetarium of Iziko Museums of Cape Town, plus one evening trip to the South African Astronomical Observatory, Cape Town, by arrangement.	AST1000S	AST	S	AST	S
2ND ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE2	\N	\N	\N	\N
ASTROPHYSICS	24	6	Dr L Marchetti	PHY1004W, MAM1000W or both MAM1031F & MAM1032S (or equivalent).	\N	\N	This course presents an introduction to the theoretical aspects of modern astrophysics. The key objective is to illustrate the application of physical laws in an astronomical context and to explain how we know what we do about the universe and its constituents. Subject matter broached includes: Celestial mechanics; radiation laws; blackbody radiation, Planck function and approximations; magnitudes; the hydrogen atom; stellar spectroscopy; stellar evolution and remnants; special relativity; the Earth-Moon system; the Solar system; extrasolar planets; stellar motions; the Milky Way and other galaxies; the extragalactic distance scale; large scale structure; Newtonian cosmology.	Monday - Friday, 2nd period, Term 2 and 4, Tutorials: 10 Compulsory tutorial/practical sessions over the year, Wednesday, 14h00 - 17h00.	Satisfactory attendance at lectures and tutorials; satisfactory completion levels of quizzes, tests and assignments and class mark of at least 35%.	Three class tests count 25%; 4 compulsory tutorials/practicals count 20%. Regular quizzes count 5%. One 2-hour final examination in November counts for 50%; subminimum requirement of 40% for final examination.	One fieldtrip to the South African Astronomical Observatory, Sutherland.	AST2002H	AST	H	AST	H
COMPILERS 1	12	8	G Stewart	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	This course will introduce students to the inner mechanics of a modern programming language compiler or interpreter. Students will appreciate why programming languages are designed in particular ways and they will learn how to develop compilers and compiler-related tools. Course content will include: language classes, formal grammars, recursive descent parsing, tokenisers, parsing, and abstract syntax trees.	\N	None	Final examination: 60%; Practical assignments: 40%	\N	CSC4021Z	CSC	Z	CSC	Z
INTRODUCTORY ALGEBRA (2IA)	12	6	Associate Professor A Schauerte	MAM1031F and MAM1032S or equivalent.	\N	\N	Students will study the fundamentals of abstract algebra and number theory, including: induction, strong induction and Well-Ordering axiom; Divisibility and prime factorization; Modular arithmetic; Permutations; Groups, Subgroups, Cyclic groups; Isomorphisms; Simple groups, Factor groups, Lagrange's Theorem; The First Isomorphism Theorem. Please note that lectures alternate during the week so that students can take any of MAM2012S, MAM2013S and MAM2014S concurrently.	Tuesdays, Fridays and some Wednesdays in 5th period.	\N	\N	\N	MAM2013S	MAM	S	MAM	S
APPROACHES AND ISSUES IN PHYSICAL AND ENVIRONMENTAL SCIENCES	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Physical/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of physical or environmental geography. The course will cover theoretical, empirical and methodological concerns and will include a fieldwork component.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4041S	EGS	S	EGS	S
ASTRONOMICAL TECHNIQUES	24	6	Professor P A Woudt	PHY1004W and MAM1000W or both MAM1031F & MAM1032S (or equivalent) (pre-requisites), or PHY1023H and MAM1005H (pre-requisites) and PHY1004W and MAM1006H (co-requisites)	\N	\N	This course combines a large practical component (radio and optical astronomy practicals) with theoretical background in astronomical techniques, instrumentation and data analysis. The techniques, instrumentation and data analysis section includes: Positional astronomy: time systems, spherical astronomy, co-ordinate systems and conversions, astrometry; Detection systems: interaction of radiation and matter, ultraviolet and optical detectors; Optics and telescope design; Multi-wavelength astronomy: infrared, ultraviolet, x-ray and gamma–ray astronomy, fundamentals of radio astronomy; Observational techniques: photometry and spectroscopy; Orthodox statistics: probability distributions, Chi-squared distribution, propagation of errors; Stochastic processes and noise: photon noise.	Monday - Friday, 2nd period, Term 1 and 3, Tutorials: Five over the year, Wednesday, 14h00 - 17h00, by arrangement. Practicals: Evening observing practicals using the UCT teaching telescopes, by arrangement.	Satisfactory attendance at lectures and tutorials. Attendance at all fieldwork practicals. Class record of at least 35%.	Two class tests 15%; 6 tutorials over the year in which students will learn astronomical data analysis and statistical techniques count 20%. Observing projects, practicals and quizzes together count 40%. One 2-hour theoretical examination counts 25%.	One observational radio astronomy project and one observational optical astronomy project, by arrangement. One fieldtrip to South African Astronomical Observatory, Sutherland.	AST2003H	AST	H	AST	H
STELLAR ASTROPHYSICS	36	7	Dr I Monageng	AST2002H and AST2003H, PHY2004W, MAM2000W (or MAM2004H and MAM2047H or equivalent credit courses).	\N	\N	This course introduces fundamental concepts such as radiative transfer and opacity to explain the observed spectroscopic and photometric signatures of stars. Students will interpret the observed intrinsic properties of stars through a theoretical understanding of the energy production inside stars and the propagation of the electromagnetic radiation from the stellar core through its interior to the stellar surface, from where the radiation escapes unhindered. The life cycle of stars is considered in great detail, from the collapse of an interstellar gas cloud to the end products of stellar evolution: white dwarfs, neutron stars and black holes. This course includes an observational component in which the students use the modern teaching observatory on campus to derive fundamental properties of stars and stellar systems.	Monday - Friday, 2nd period, Practicals: One practical or tutorial per week, Wednesday, 14h00 - 17h00.	Satisfactory attendance at lectures and tutorials; class record of at least 35%.	Class record 50% (this includes two class tests, tutorials, weekly quizzes and practicals); one 2-hour final examination 50%; subminimum requirement of 40% for final examination.	Two evening observing sessions at the UCT teaching observatory, by prior arrangement.	AST3002F	AST	F	AST	F
3RD ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE3	\N	\N	\N	\N
ARCHAEOLOGIES OF DOMINANCE AND RESISTANCE IN THE LAST-500 YEARS	36	7	Dr V Lupuwana	AGE2011S or AGE2012F, or by permission of the Head of Department.			The period of the last-500 years greatly impacted the social lives and economies of indigenous communities in southern Africa. Preceding this period, the importance of the African continent and its products had led to increased movements and travel from both the East and the West, and from the 16th century, these movements and trade routes led to the trade in African people and increased interest in the exploitation of resources and labour on the continent. This period of interaction, domination and colonisation led to the development of new orders of power, control and trade, greatly impacting indigenous societies who were subjected to slavery, genocide and eventually, apartheid. In this course, we explore the impact of these interactions and the subsequent influence and impact of the creation of a European diaspora in southern Africa. We explore the concept of frontier as a central theme that impacts racial, gender and social relations. While being a period of intense contestation and competition for resources, this is also a period of indigenous agency and resistance. In order to examine these relations, this course explores the archaeological evidence, written sources and oral history to understand the multiple lived experiences and perspectives emblematic of the period.	Monday - Thursday, 4th period, Practicals: One 2-hour practical per week, at times to be arranged	Attendance at lectures and practicals, completion of assignments.	Assignments and class tests count 50% towards the final mark and one 3-hour exam written in November counts 50%. A sub-minimum of 40% is required for the examination.		AGE3012S	AGE	S	AGE	S
EMBEDDED SYSTEMS I FOR SCIENCE STUDENTS	18	6	Dr MY Abdul Gaffar	CSC1015F/S and EEE2042S	\N	\N	This course aims to give Science students majoring in Computer Engineering a strong foundation in embedded systems by introducing them to digital system fundamentals, including: information representation, Boolean algebra, logic gate behaviour, combinational and sequential digital circuits, digital building blocks and algorithmic state machines; C programming with a focus on microcontroller applications; basic microcontroller usage, including an introduction to computer architecture, general purpose input/outputs, analogue to digital convertors and basic timers.	\N	Please refer to the official course handout document for detailed information regarding the DP requirements for this course.	Please refer to the official course handout document regarding the assessment criteria for this course.	\N	EEE2050F	EEE	F	EEE	F
CELL BIOLOGY	18	5	Dr M Vaaltyn	Admission will be restricted to students who have passed either NSC Physical Science or Life Science with at least 60%. The permission of the Dean or Head of Department is required prior to registration for this course. NOTES: 1) Preference will be given to students registered in the Science Faculty. 2) This course only begins in week 7 and is intended for students who have been advised to transfer to this course after initially registering for BIO1000F (see entry forBIO1000F). 3) The course places an emphasis on the strengthening of foundational concepts and skills, the carefully paced introduction of new material, and the development of sound approaches to effective learning. 4) BIO1000H is equivalent to BIO1000F in level, credit value towards the degree and as prerequisite for certain other courses.	\N	\N	Basic biological principles and processes at a cellular level provide an essential grounding for future study in the life sciences. The structure and function of cell components is introduced, followed by an introduction to chemistry, including the structure and functions of biological macro-molecules. Cell division and the role of genetics in inheritance and the control of biological systems is then considered. This leads into an introduction to membrane physiology, metabolism and its regulation. Cellular processes that are considered in detail include the functioning of photosynthesis and cellular respiration, and how these relate to organismal physiology. Cellular communication and the immune system of animals complete the organismal physiology.	Monday - Friday, 2nd period, Tutorials: One per week, by arrangement, Practicals: One afternoon per week, Friday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 80% of deliverables (tests, practicals, tutorials), including at least one class test and at least one practical test; attendance of practicals; minimum of 40% for the class record.	Class record counts 40% (three class tests count 27%; two practical tests count 5%; and a practical bookmark counts 8%). One 2-hour examination paper (Theory) written in November counts 40%; a subminimum of 40% is required for this paper. One 1.5-hour examination paper (Practical) in November counts 20%.	\N	BIO1000H	BIO	H	BIO	H
PLANT DIVERSITY AND FUNCTIONAL BIOLOGY	24	6	Professor M D Cramer	BIO1000F/H, BIO1004S	\N	\N	The course begins with a discussion on the nature and origin of plants that includes an overview of major autotrophic eukaryote lineages. The benefits and challenges of life in water and on land are also presented. Diversity and evolution of life histories and reproductive systems in plants and consequences of the diversity of major plant lineages are studied. The functional biology of the major organs of the plant including roots, stems and leaves in relation to strategies for resource acquisition and utilisation, mineral nutrition, plant water relations and carbon metabolism are considered. This entails studying variations in root, stem and leaf morphologies in various plant lineages and unique terrestrial and aquatic environments and their function in water, nutrients, and carbon metabolism. There is a strong focus on African plants, and a particular emphasis on the Cape Floristic region. The course practicals are compulsory and complements the theory with hands-on experience on working with different lineages of plants, data collection and analysis from scientific studies and experiments, and scientific writing. A compulsory 4-day field camp is undertaken for students to study the relationship between ecology and plant morphology, function, and diversity.	Monday – Friday, 3rd period, Practicals: One per week, Wednesday, 14h00- 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, field trip report), including at least one class test and the field trip report; attendance of practicals and field trip; minimum of 40% for the class record.	A 3 hour examination written in June, with a subminimum of 40%, counts 50% of the course. Coursework marks will be allocated as follows: Practical classes count 20%, project based on field camp counts 10%, two class tests count 20%.	Includes a compulsory four-day field camp.	BIO2017F	BIO	F	BIO	F
INTEGRATED ANATOMICAL AND PHYSIOLOGICAL SCIENCES PART A	24	6	Dr J Harbron and Assoc Professor D Lang	BIO1000F, BIO1004S and CEM1000W (or equivalent courses).	An average grade of 60% or more for these two courses is recommended.	\N	This course is under review and the content may change as a result. The course introduces the concept of integrating human physiology, anatomy, cell biology and histology. It includes the study of cells and tissues, the basic anatomy and histology of the musculoskeletal, endocrine and digestive systems, and an introduction to embryology and osteology. Physiological concepts include fluid balance, cell signaling, hormone regulation, digestion, absorption and metabolism. The course consists of lectures, practical sessions and tutorials. In the practicals, students work in small groups using computers and specialised equipment to study the physiology and histology of the abovementioned organ systems. At the end of the course, students will be able to describe structure-function relationships of body systems coved in the course; apply concepts and principles taught in lectures and practical sessions to solve theoretical or real-life problems posed in tutorials, tests and examinations; follow and implement instructions in computer- simulated physiology experiments and interpret result; identify micro-anatomical organisation of organs under a microscope or in monographs; identify and name structures in anatomical specimens; and design simple experiments to determine physiologic parameters such as blood type, fluid compartment volumes, enzyme activities etc.	Lectures: Monday to Friday (08h00-08h45); Practicals: Mondays or Tuesdays (14h00-17h00).	Attendance at all practical sessions, 40% average in class tests and an average of 50% for all assignments.	The breakdown of course marks is as follows: Class tests 30%, practical write-up 15%, assignments or tutorials 5%. Final examinations (50%) as follows: Theory examination 30%, practical examination 20%. A subminimum of 40% is required for the theory and practical examination to pass this course. Supplementary examinations, in the form of written, practical or oral assessment, may be offered to students whose overall score is 45-49%. An oral examination may be required in the case of selected students.	Entrance is limited to 80 students.	HUB2019F	HUB	F	HUB	F
PETROLOGY & STRUCTURAL GEOLOGY	36	7	Professor P E Janney	GEO2001F, GEO2004S	\N	\N	This course covers key concepts in igneous, metamorphic and sedimentary petrology in combination with structural geology as follows: interpreting major and trace element and isotope variations in igneous rocks; origin and evolution of the major magma series; thermodynamics, kinetics and chemography of metamorphic reactions; tectonic setting of metamorphic terrains; principles of interpretations and classification of continental and marine sedimentary environments; kinematic principles, deformation mechanisms, microstructure, faulting and tectonic geomorphology.	Monday - Friday, 2nd period	Attendance at 80% of practicals and an average of 30% in all marked class work and tests.	Class work counts 20%; one 4-hour practical examination written in June counts 30%; one 3-hour theory examination written in June counts 50%. Subminima of 40% required in practical and theory examination papers.	\N	GEO3005F	GEO	F	GEO	F
ARCHAEOLOGY HONOURS	160	8	Dr Y Sahle	A Bachelor’s degree majoring in Archaeology and an acceptable academic record. Students applying for admission to the Honours programme in Archaeology must satisfy the Head of Department that they have adequate fieldwork experience.	\N	\N	The purpose of the Honours programme in Archaeology is to look in depth at current issues in the discipline, both internationally and in southern Africa. Those taking part are expected to become fully involved in the academic life of the Department, attending such seminars as may be given by staff members, research students and visitors. In addition, they must participate in the structured programme of lectures and tutorials, and write a research dissertation. The dissertation is a central part of the Honours programme. Each student must prepare a project proposal, worked out with a supervisor and approved by the Head of Department. In addition, students must take part in one open seminar, where they present their project to the Department. All students are required to participate in two weeks of fieldwork.	\N	\N	On average the course work component counts 70% (this includes 50% from final examinations) and the research project counts 30%. A sub-minimum of 50% is required for the research project. These component parts of the course will be combined in a final overall mark which will be reflected against the course code AGE4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code AGE4000W will not carry a NQF credit value, students will be concurrently registered for AGE4003W (coursework component of 112 NQF credits) and AGE4004W (research project of 48 NQF credits).	AGE4000W	AGE	W	AGE	W
ARCHAEOLOGY & ENVIRONMENTAL SCIENCE HONOURS	160	8	Dr Y Sahle	A BSc degree with majors in both Archaeology and Environmental & Geographical Science. Acceptance will be at the discretion of the Head of Department.	\N	\N	Using the resources of both the Departments of Archaeology and Environmental & Geographical Science, this Honours programme focuses on the palaeoenvironmental context in which humans lived during the long course of the Quaternary. Course requirements include modules from both Archaeology and from Environmental & Geographical Science and a research project (48 credits).	\N	\N	On average the course work component counts 70% (this includes 50% from final examinations) and the research project counts 30%. A sub-minimum of 50% is required for the research project. These component parts of the course will be combined in a final overall mark which will be reflected against the course code AGE4001W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code AGE4001W will not carry a NQF credit value, students will be concurrently registered for AGE4005W (coursework component of 112 NQF credits) and AGE4006W (research project of 48 NQF credits).	AGE4001W	AGE	W	AGE	W
STATISTICAL MODELLING, MACHINE LEARNING & BAYESIAN	36	7	Dr E Pienaar	STA2004F and STA2005S; MAM2000W or MAM2004H is strongly recommended. Recommended MAM2000W modules: MAM2011F - Linear Algebra (2LA), MAM 2010F - Advanced Calculus (2AC), MAM2012S - Differential Equations (2DE) and MAM2014S - Real Analysis (2RA).	\N	\N	This course forms part of the third-year major in Mathematical Statistics. It consists of three modules: The first, Generalised Linear Models, introduces students to the theory and application of fitting linear models to various types of response variables with different underlying distributions. Subsequently, elementary concepts and methods in machine learning within the framework of statistical learning are explored. Finally, the Introduction to Bayesian Analysis module is dedicated to the Bayesian paradigm of statistical inference, analysis, and risk theory. The contents of the respective modules are outlined as follows: Generalized linear models: Topics covered include: The exponential family of distributions, the GLM formulation, estimation and inference, models for continuous responses with skew distributions, logistic regression, log-linear models and Poisson regression. Machine learning: Topics covered include: A basic introduction to statistical learning paradigms, applications of regression and classification trees, and a primer on feedforward neural networks and backpropagation. Introduction to Bayesian Analysis: Topics covered include: use of Bayes’ theorem; Bayesian statistical analysis for Bernoulli and normal sampling; empirical Bayes and credibility theory; loss and extreme value distributions; Monte Carlo methods. Students are assessed through formal written exam plus computer assignments done under exam conditions.	Five lectures per week, Monday - Friday, 1st period.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	ANALYSIS A student cannot obtain credits for both STA3043S and (STA3047S+STA3048S)	STA3043S	STA	S	STA	S
5TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE5	\N	\N	\N	\N
ASTROPHYSICS & SPACE SCIENCE HONOURS	160	8	To be advised	AST3002F and AST3003S or PHY3004W or MAM3040W or equivalent. Candidates with an Engineering background will also be considered. Enrolments are limited to 20 students. Candidates must satisfy the Steering Committee that they have sufficient background in Mathematics and Physics. Admission is subject to the approval of the Steering Committee and an application must be made before 31 August of the preceding year. Late applications will also be considered.	\N	\N	The Honours course in Astrophysics & Space Science consists of courses presented by distinguished South African researchers from research institutions participating in NASSP. There is a theory component which includes courses in spectroscopy, electrodynamics, general relativity, general astrophysics, galaxies, computational physics, astrophysical fluid dynamics and computational methods, as well as an observational techniques component which includes optical and infrared astronomy and radio astronomy. In addition students will complete a mini research project as well as a main research project and go on a number of fieldtrips to the national facilities.	\N	Satisfactory lecture attendance (minimum 50%); class record of at least 40%.	The assessment of the coursework is based on the class records and examinations for each of the modules. In general they are made up from tests, oral presentations, projects and a final examination. Examinations count 40%, class record 40% and research project 20% of the final result. The project component must be passed at 50%. These component parts of the course will be combined in a final overall mark which will be reflected against the course code AST4007W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code AST4007W will not carry a NQF credit value, students will be concurrently registered for AST4008W (coursework component of 128 NQF credits) and AST4009W (research project of 32 NQF credits).	AST4007W	AST	W	AST	W
ASTRONOMY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	AST5000W	AST	W	AST	W
ASTROPHYSICS & SPACE SCIENCE MINOR DISSERTATION	90	9	\N	AST5003F	\N	\N	This course consists of an investigation of an approved research topic on which a minor dissertation must be presented for formal assessment. The minor dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	(National Astrophysics & Space Science Programme (NASSP))	AST5001W	AST	W	AST	W
ASTROPHYSICS & SPACE SCIENCE COURSEWORK	90	9	To be advised	This course is open to Honours graduates in Astronomy and Space Science (AST4007W), Physics (PHY4000W, PHY4001W, PHY4002W) or equivalent, and Engineering. Entrance is subject to a minimum pass mark of 60% in the Honours degree. Admission is subject to the approval of the Steering Committee and an application must be made before 30 June of the preceding year.	\N	\N	This course consists of a selection of advanced topics presented by distinguished South African researchers from research institutions participating in NASSP. The courses vary from year to year but usually include cataclysmic variables, extragalactic astronomy, space technology, hot topics in cosmology, advanced general relativity, high energy astrophysics, observational cosmology, geomagnetism and aeronomy, plasma physics and magnetohydrodynamics.	\N	\N	On average, examinations of individual modules count 60% of the final result, and marked practical work counts 40%.	(National Astrophysics & Space Science Programme (NASSP). All students on the National Astrophysics & Space Science Programme (NASSP) will enrol (and pay fees) for the coursework component (AST5003F) at the start of their first year of registration. Those who choose to remain at UCT to complete the minor dissertation component (AST5001W, MAM5005W or PHY5003W) will be required to enrol (and pay fees) for the minor dissertation component in July. Where the minor dissertation is not submitted by the February deadline of the subsequent year, the student will be required to enrol (and pay fees) for the minor dissertation component in the subsequent year/s.	AST5003F	AST	F	AST	F
MARINE ECOSYSTEMS	36	7	Professor P W Froneman	A pass or permission to write a SUPP exam in BIO2014F, SEA2004F (or concurrent registration for SEA2004F).	\N	\N	The course aims to develop and promote skills in the marine sciences in South Africa, making students familiar with global marine ecosystem structure and functioning, but with an emphasis on South African systems. Lectures, tutorials, and practicals will be aimed at developing interpretative and integrative skills built during previous courses (e.g., SEA2004F; BIO2014F; BIO1004S; BIO1000F), which cover large amounts of more basic information. A further important aim will be to develop numerical and written skills, as well as introducing students to modern research techniques and approaches.	Monday - Friday, 1st period, Practicals: One per week, Wednesday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals and field trip; minimum of 40% for the class record.	A 3-hour examination written in June, with a sub-minimum of 40% will count for 50% of the course. Class mark will count 50% of the course mark (breakdown: 2 tests count 40% of the class mark, project write up 30% and the practicals 30%).	Includes a compulsory three-day field camp during first semester	BIO3002F	BIO	F	BIO	F
SYSTEMS SECURITY	12	9	Z Ruhwanya	A non-IT honours degree, or equivalent.	None.	\N	The course will cover the following topics: • Cybersecurity and impacting issues • Cyber security theories & frameworks • Real-world Cybercrime Cases • Cyber-Forensic investigations • Reporting and evidence admissibility • Strategies to address Cyber security challenges	\N	In order to be permitted to sit the final exam a minimum average of 40% on the coursework must be obtained.	2 Assignments (50%) and an Exam (50%).	\N	INF5008Z	INF	Z	INF	Z
BIOLOGICAL DIVERSITY	18	5	Dr S Welman	A pass at 60% in NSC Life Sciences or Physical Sciences or by permission of the Head of Department.	\N	\N	This course aims to illustrate the diversity and complexity of living organisms, from viruses to humans. Topics include: evolution as a means of interpreting change with time; modern theories on the mechanisms of evolution; the origin of species, including humans; structure and functioning of the simplest microbial life forms; structure and life cycles of fungi; the evolution of aquatic and terrestrial plants; the diversity and adaptations of invertebrate animals; the development and adaptations of chordate groups; primate diversity and evolution; conservation and biodiversity issues in relation to South African biomes and global change. The course includes a strong practical component which further examines biodiversity and related concepts.	Monday - Friday, 5th period, Tutorials: One per week, by arrangement, Practicals: one practical per week, Monday, Tuesday, Wednesday, or Thursday 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 80% of deliverables (tests, practicals, tutorials, field trip report), including at least one class test, the practical test, and the field trip report; attendance of practicals and field trip; minimum average of 50% for practicals; minimum of 40% for the class record.	Coursework 40%. Theory test 1 (7%), theory test 2 (7%), practical test (10%), practicals (10%), field trip report (group mark, 6%). Examinations 60%. One 2-hour theory examination written in November counts 40% (subminimum of 40% applies); one 1.5-hour practical examination written in November counts 20%.	Preference will be given to students registered in the Science Faculty. Fieldwork: A compulsory one-day excursion will be held over a weekend.	BIO1004S	BIO	S	BIO	S
PRINCIPLES OF ECOLOGY & EVOLUTION	24	6	Dr C Janion-Scheepers	BIO1000F/H, BIO1004F/S, DP in STA1007S	\N	\N	This course begins with an exploration of the mechanisms by which populations evolve and ultimately give rise to the entities that we term species. Building on this, it then explores the nature of the genealogical relationships between species (phylogeny), and the manner in which these are estimated in practice. The focus then shifts to abiotic and biotic controls on the distribution of species and higher taxa in nature, as viewed through the lens of niche theory, as well as constraints on the adaptability of populations or species to changing selective conditions. Finally, the course explores life history variation amongst organisms, including the factors that regulate its evolution and its demographic consequences. The latter provides context for a brief introduction to population ecology. Lectures provide theoretical background, while practicals and the compulsory field trip provide hands-on experience of material taught in lectures, as well as training in basic research techniques.	Monday-Friday, 2nd period, Practicals: One per week, Monday, 14h00- 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, field trip report), including at least one class test and the field trip report; attendance of practicals and field trip; minimum of 40% for the class record.	A 3-hour examination, written in June, with a subminimum of 40%, counts 50% of the course mark. The class record, which counts for the balance, is made up as follows: practicals count 15%, the field camp report counts 15% and two class tests count 20%.	Includes a compulsory weekend field camp.	BIO2014F	BIO	F	BIO	F
VERTEBRATE DIVERSITY & FUNCTIONAL BIOLOGY	24	6	Dr C A Ngcamphalala	BIO1000F/H, BIO1004S	\N	\N	This course begins with an overview of the evolution, characteristics, diversity, morphology, and life histories of the different craniate classes, paying particular attention to adaptations underlying the success of the vertebrates. Distinctive or advanced biological features of each group are highlighted, and their ecological/economic importance briefly considered. The rest of the course comprises integrative, cross-taxonomic modules on the functional biology of vertebrates, notably locomotion, sensory systems, metabolism, homeostasis and behaviour. The course includes a strong practical component to demonstrate the links between form and function; as well as a 4-day compulsory field camp during which students will be trained in methods for studying the diversity, ecology and behaviour of selected vertebrate groups.	Monday – Friday, 2nd period, Practicals: One per week, Thursday, 14h00- 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals; minimum of 40% for the class record	A 3-hour theory examination written in November, with subminimum of 40%, will count 50% of the course mark. Coursework marks will be allocated as follows: practical tests (two deliverables) count 10%, project report based on projects counts 20%, two class tests together count 20%.	Includes a compulsory field camp.	BIO2015S	BIO	S	BIO	S
ECOLOGY & EVOLUTION	36	7	Dr J A Slingsby	A pass or permission to write a SUPP exam in BIO2014F.	\N	\N	Ecological and evolutionary processes together determine patterns of biodiversity. This African- centric ecology and evolution course utilises regional examples within the global context to illustrate plant and animal ecology and evolution. The course starts with community assembly and the mechanisms (e.g., functional traits) that contribute to species coexistence (e.g., niche construction) and turnover (competition/facilitation for resources) between communities and the results of this (e.g., succession and alternate states). The role of disturbance (e.g., fire, herbivory, predation) in structuring communities and the roles of adaptation versus exaptation are then considered. Alien invasions are considered in the context of the supposed “empty niche” and as current examples of dispersalism and mechanisms (e.g., traits) of coexistence and competition. This is followed by behavioural ecology, focusing on how competition and cooperation between and within species affects evolutionary fitness. This leads into analytical biogeography, considering the distribution of species and how this was established (i.e., vicariance versus dispersalism) before discussing the evolution and coexistence of species regionally and globally. The course is based on a two-week fieldtrip before the semester starts, with assignment hand-ins and tutorials during the semester.	All lectures and practicals occur during a residential two-week field course occurring before the start of the first semester. Tutorials: By arrangement in 5th period – typically one per practical. Practical slot: (used for prac, tutorials or tests) Tuesday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, field trip seminar), including the class test and the field trip seminar; attendance of two-week field trip and subsequent practicals; minimum of 40% for the class record.	An examination, written in June, with a subminimum of 40%, counts for 50% of the course mark. The class record, which counts for the balance, is made up as follows: practicals 35%, seminar 5%, class test 10%.	This course is a residential two-week field course, occurring before term starts. During term time tutorials and various assignments need to be completed.	BIO3018F	BIO	F	BIO	F
INVERTEBRATE DIVERSITY & FUNCTIONAL BIOLOGY	24	6	Associate Professor D Pillay	BIO1000F/H, BIO1004S	\N	\N	The course exposes students to the diversity of invertebrates and their functional biologies. Topics will be presented within an evolutionary framework to emphasise past and contemporary selective pressures driving diversification. Students will be exposed to key topics in functional biology across the major invertebrate groups and will include cellular to organism level processes. The course begins with an introduction to the evolution of the invertebrates and the major phyla. This leads to an exploration of invertebrate functional biology, with an emphasis on key adaptations across the aquatic–terrestrial gradient. Lectures, practicals and field trips will expose students to contemporary philosophical, methodological and conceptual approaches used in the field of invertebrate functional biology and diversity.	Monday – Friday, 3rd period, Practicals: One per week, Wednesday, 14h00- 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, field trip report), including at least one class test and the field trip report; attendance of practicals and field trip; minimum of 40% for the class record.	A 3-hour examination, written in November, with a subminimum of 40%, counts for 50% of the course mark. Coursework marks will be allocated as follows: practicals count 15%, the field camp report counts 15% and two class tests count 20%.	Includes a compulsory four-day field camp.	BIO2016S	BIO	S	BIO	S
SOUTH AFRICAN PRIVATE LAW: SYSTEM AND CONTEXT	18	5	M Baase		Undergraduate LLB students:  PVL1003W and PVL1008H. Graduate LLB students: \r\nconcurrent registration with PVL1003W, PVL1008H, PBL2000W, PVL2002H, PVL2003H.		The  course  serves  primarily  as  an  introduction  to  the  common  law  of  property  and  obligations, \r\nalthough other areas of private law may be covered. Its main aims are, first, to provide both a map of \r\nthe  law  and  an  understanding  of  the  operation  of  the  system  of  private  law  rules;  and,  second,  to \r\nprovide  students  with  an  understanding  of  the  development  of  legal  rules  in  their  historical  and \r\ncomparative contexts.		None	Coursework 50% Final Examination 50%.	Preliminary Level, first semester, three lectures per week.	PVL1004F	PVL	F	PVL	F
GLOBAL CHANGE ECOLOGY	36	7	Professor A G West	BIO1000F/H, BIO1004F/S; approved 2000-level semester Science course.	\N	\N	How are organisms and ecosystems affected by the drivers of global environmental change? In this course we briefly explore the drivers of global change, both natural (e.g. Milankovitch cycles, tectonic drift) and anthropogenic (e.g. greenhouse gas emissions, pollution, land-use change), and then examine how these drivers influence (and are influenced by) terrestrial and marine biological systems. We cover a variety of topics, ranging from organismal and physiological responses to global change, biodiversity, global biogeochemical cycles, ecological function and ecosystem services. While the majority of the class is focussed on contemporary global change, this is contextualized relative to palaeohistorical environmental change. The course provides an integrated knowledge of contemporary environmental issues related to global change (e.g. carbon sequestration, climate change mitigation, land-use change) and its implications for biodiversity, ecosystem services and human wellbeing).	Monday - Friday, 2nd period, Practicals: One per week, Monday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals; minimum of 40% for the class record.	A 3-hour examination written in June, with a sub-minimum of 40%, will count for 50% of the course. Coursework marks will be allocated as follows: Practical classes (assessed weekly) count 15%; research project counts 20%; class tests count 15%.	\N	BIO3013F	BIO	F	BIO	F
CONSERVATION: GENES, POPULATION & BIODIVERSITY	36	7	Professor M J O’Riain	A pass or permission to write a SUPP exam in BIO2014F.	\N	\N	This course introduces students to the science and practice of conservation biology, beginning with an overview of conservation issues, the value of biodiversity, extinction risks and the history and philosophy of conservation. The conservation of biodiversity is explored at multiple levels, including the diversity of genes, species, populations and ecosystems. At the species and population levels, we consider the role of life history and behaviour in the management of populations in the real world. The conservation and management of ecosystems is considered in terms of important processes, such as disturbance, re-wilding and threats by alien species. This course includes consideration of conservation, society, landscapes and ecosystem services. Issues to be considered here include incentives, access, who benefits from conservation, legal aspects and management policies.	Monday - Friday, 2nd period, Tutorials, by arrangement, Practicals: One per week, Monday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals; minimum of 40% for the class record.	A 3-hour examination written in November, with a sub-minimum of 40%, will count for 50% of the course. Coursework marks will be allocated as follows: Practical classes (assessed weekly) count 20%; project work counts 15%; two class tests count 15%.	\N	BIO3014S	BIO	S	BIO	S
MARINE RESOURCES	36	7	Dr M M Reddy	A pass or permission to write a SUPP exam in BIO2014F; BIO3002F is recommended.	\N	\N	This course covers the science that supports renewable marine resource management. Topics include the diversity and life-history strategies of living marine resources, the diversity of fish and fisheries, surplus production, ecological responses to exploitation, monitoring and assessment techniques, regulatory strategies, resource economics, diversity and principles of marine aquaculture, and marine conservation.	Monday - Friday, 3rd period, Tutorials: By arrangement, Practicals: One per week, Thursday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals; minimum of 40% for the class record	A 3-hour examination written in November, with a sub-minimum of 40%, will count for 50% of the course. Coursework marks will be allocated as follows: Practical classes count 10%; project work counts 20%; two class tests count 20%.	\N	BIO3017S	BIO	S	BIO	S
APPROACHES AND ISSUES IN PHYSICAL AND ENVIRONMENTAL SCIENCES	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Physical/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of physical or environmental geography. The course will cover theoretical, empirical and methodological concerns and will include a fieldwork component. NQF 9 level there is a strong emphasis on the development of analytical skills and students are expected to apply these skills in the context of an appropriate theory, to a case study of their own specialist field of physical geography.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5041F	EGS	F	EGS	F
METHODS OF MATHEMATICAL PHYSICS (3MP)	18	7	To be advised	MAM2040F, MAM2041F, MAM2042S and MAM2043S.			The aim of this course is to introduce a selection of advanced topics in Applied Mathematics. Topics include: The Fourier-transform solution of linear PDEs on the line. The long-term asymptotic behaviour of solutions: the methods of Laplace, stationary phase and steepest descents. Nonlinear waves: the method of characteristics; the effect of dissipation; the Cole-Hopf transform for the Burgers equation; travelling fronts for the KPP equation. The effect of dispersion: KdV and nonlinear Schroedinger equation. Elliptic integrals and elliptic functions; dark and bright solitons; kinks and breathers for the sine-Gordon equation. Multisoliton solutions: the Hirota method and Baecklund transformations. Please note that lectures alternate during the week so that students can take MAM3043S and MAM3045S concurrently.	Monday - Friday, 3rd period.	Class record of 30% or more.	Class record counts up to 50%, while the balance is given by the final examination.		MAM3043F	MAM	F	MAM	F
LAW OF PERSONS AND FAMILY	18	5	Associate Professor A Barratt		Undergraduate LLB students: concurrent registration with PVL1003W and \r\nPVL1004F. Graduate LLB students: concurrent registration with PVL1003W, PVL1004F, \r\nPVL2002H, PVL2003H and PBL2000W		This is a foundational law course and focuses particularly on developing legal problem-solving skills. \r\nThe  course  aims to  introduce  students  to  the  study  of  private  law.  We  examine  the  nature  of  legal \r\npersonality; the principles of legal capacity; and look at the principles of domicile. Most of the course \r\nfocuses on Family Law and looks particularly at the legal relationships between parents and children; \r\nthe personal consequences of marriage; the law of marital property; divorce; and the law governing \r\nunmarried people who live in long-term domestic partnerships. The course also examines the ways in \r\nwhich South African family law is changing to become compliant with the Constitution and Bill of \r\nRights.		None	Coursework 50%; Final Examination 50%	Preliminary Level, half course, thirty-six lectures and three tutorials.	PVL1008H	PVL	H	PVL	H
QUANTITATIVE BIOLOGY	36	7	Professor T A Hedderson	A pass or permission to write a SUPP exam in BIO2014F, approved 2000-level Science STA or MAM course.	\N	\N	In an era of "big data", the ability to work with large amounts of numerical data is an important skill. Biological systems are notoriously complex across all levels of organisation and are often difficult to manipulate experimentally on meaningful temporal and spatial scales. Mathematical models provide a means of gaining insight into such systems, allowing us to disentangle complicated processes, focus on variables of interest to a particular research question, test alternative hypotheses, make predictions, and help present ideas in an unambiguous fashion. This course deals with the use, interpretation, and limits of modelling approaches in biology. In a series of modules exploring processes ranging from the behaviour of genes to understanding global scale distributions of species and communities, students will gain experience in question formulation, model development and parameterisation, interpretation of results, and model critique.	Monday - Friday, 5th period, Tutorials: By arrangement, Practicals: One per week, Tuesday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 70% of deliverables (tests, practicals, project report), including at least one class test and the project report; attendance of practicals; minimum of 40% for the class record.	A 3-hour examination written in November, with a subminimum of 40%, will count 50% of the course. The class record, which counts for the balance, is made up as follows: practicals and project work count 35%, two class tests count 15%.	\N	BIO3019S	BIO	S	BIO	S
BIOLOGICAL SCIENCES HONOURS	160	8	Professor A M Muasya	A BSc degree in Biology, with a pass in STA2007 F/S/H or an equivalent 2000-level semester statistics course. Students lacking this statistical prerequisite will be required to register concurrently for STA5014Z. Acceptance will be at the discretion of the Head of Department who will consider quality of final year results, material covered in the undergraduate curriculum, and also possibly referees’ reports. Enrolments are limited to 20.	\N	\N	The Honours course is designed to enrich the student's appreciation of theory through advanced coursework, essay writing, seminars, discussion groups and fieldwork. In addition to compulsory coursework modules, students are required to choose eight elective modules and complete an original research project.	\N	Attendance of field camp and all lectures are required for the DP. The non- project component of the course carries a sub-minimum of 50% and the project component a sub- minimum of 50%.	Two 3-hour examinations written in November count 20%; project and research seminar count 40%; compulsory coursework counts 20%; elective coursework counts 20%. These component parts of the course will be combined in a final overall mark which will be reflected against the course code BIO4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code BIO4000W will not carry a NQF credit value, students will be concurrently registered for BIO4002W (coursework component of 88 NQF credits) and BIO4003W (research project of 72 NQF credits).	BIO4000W	BIO	W	BIO	W
MARINE BIOLOGY HONOURS	160	8	Professor A M Muasya	A BSc degree in Marine Biology, with a pass in STA2007 F/S/H or an equivalent 2000-level semester statistics course. Students lacking this statistical prerequisite will be required to register concurrently for STA5014Z. Enrolments are limited to 12. Acceptance will be at the discretion of the Head of Department who will consider quality of final year results, material covered in the undergraduate curriculum, and also possibly referees’ reports.	\N	\N	The Honours course is designed to enrich the student’s appreciation of theory through advanced coursework, essay writing, seminars, discussion groups and fieldwork. In addition to compulsory coursework modules, students are required to choose eight elective modules, at least four of which must be marine topics, and complete an original research project.	\N	Attendance of field camp and all lectures are required for the DP. The non- project component of the course carries a sub-minimum of 50% and the project component a sub- minimum of 50%.	Two 3-hour examinations written in November count 20%; project and research seminar count 40%; compulsory coursework counts 20%; elective coursework counts 20%. These component parts of the course will be combined in a final overall mark which will be reflected against the course code BIO4001W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code BIO4001W will not carry a NQF credit value, students will be concurrently registered for BIO4004W (coursework component of 88 NQF credits) and BIO4005W (research project of 72 NQF credits).	BIO4001W	BIO	W	BIO	W
CONSERVATION BIOLOGY COURSEWORK	90	9	Dr G Jamie	A relevant honours degree or equivalent: students with an honours degree from another discipline may be required to register for an MPhil in Conservation Biology.	\N	\N	This course deals with the conservation and biologically sustainable use of biodiversity. It provides the education and training necessary to identify threatened species, ecosystems and ecological processes, and to develop appropriate measures to reduce the effects of threats to biodiversity. This course is intended for students concerned with both the theory and practise of conservation. The coursework consists of a series of compulsory modules that run from January to August and cover a range of fields of conservation biology: biodiversity basics, philosophy of science and conservation ethics, population ecology and viability analysis, conservation genetics, community ecology, ecosystem/aquatic ecology, invasive species, landscape ecology, GIS and conservation planning, climate change and conservation, resource economics, societies and natural resources, conservation leadership.	\N	\N	Each student receives a mark for each of the modules, and the modules are examined in two examinations.	Students will enrol (and pay fees) for both courses BIO5007H and BIO5008W in their first year of registration; where the minor dissertation is not submitted by the February deadline of the subsequent year, the student will be required to enrol (and pay fees) for the minor dissertation component in the subsequent year/s. A handbook of postgraduate studies is available from the Fitzpatrick Institute's website: https://science.uct.ac.za/fitzpatrick	BIO5007H	BIO	H	BIO	H
LAW OF PROPERTY	18	6	Dr G Mathiba	Undergraduate LLB students: concurrent registration with PBL2000W \r\nand  PVL2003H.  Graduate  LLB  students:  concurrent  registration  with  PVL1003W,  PVL1004F, \r\nPVL1008H, PBL2000W and PVL2003H.			The  purpose  of  this  course  is  to  introduce  students  to  fundamental  concepts  and  common  law \r\nprinciples of the South African Law of Property as regards what is property, how rights in property \r\nare  acquired  or  lost  and  are  protected.  The  law  is  examined  in  its  current  constitutional  and  socio-\r\npolitical context. In addition to the focus on the content of this area of law, considerable attention is \r\ngiven  to  development  of  appropriate  analytical  and  problem-solving  skills,  independent  and  active \r\nlearning as well as appropriate study methodology and techniques.			Coursework 50% Final Examination 50%.	Preliminary Level, half course, 36 lectures.	PVL2002H	PVL	H	PVL	H
ADVANCED STOCHASTIC PROCESSES & DISTRIBUTION	36	7	Associate Professor T Gebbie	STA2004F, STA2005S, MAM2000W and concurrent registration for STA3041F. Recommended MAM2000W modules: MAM2011F - Linear Algebra (2LA), MAM 2010F - Advanced Calculus (2AC), MAM2012S - Differential Equations (2DE) and MAM2014S - Real Analysis (2RA). Note: A student may not register concurrently for STA3045F and CSC2001F.	\N	\N	This course is a third-year module for students studying Actuarial Science or Mathematical Statistics, though not a requirement for a major in Mathematical Statistics. The course begins by giving a brief introduction to copulas and extreme value theory, together with some applications to risk management. The rest of the course gives a theoretical overview of stochastic processes, with the models covered spanning both discrete and continuous time as well as discrete and continuous state- space. Though the emphasis is on the theoretical properties of the models, the application of the methods to real-world problems is also explored at length. Topics covered: copulas, an introduction to extreme value theory, homogenous and non-homogeneous continuous-time Markov chains, random walks, probability theory, martingales, Brownian motion, and diffusion processes.	Five lectures per week, Monday - Friday, 2nd period.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	THEORY A student may not register concurrently for STA3045F and CSC2001F. Course outline: This course is a third-year module for students studying Actuarial Science or Mathematical Statistics, though not a requirement for a major in Mathematical Statistics. The course begins by giving a brief introduction to copulas and extreme value theory, together with some applications to risk management. The rest of the course gives a theoretical overview of stochastic processes, with the models covered spanning both discrete and continuous time as well as discrete and continuous state- space. Though the emphasis is on the theoretical properties of the models, the application of the methods to real-world problems is also explored at length. Topics covered: copulas, an introduction to extreme value theory, homogenous and non-homogeneous continuous-time Markov chains, random walks, probability theory, martingales, Brownian motion, and diffusion processes. Lecture times: Five lectures per week, Monday - Friday, 2nd period. DP requirements: Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%. Assessment: Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	STA3045F	STA	F	STA	F
CONSERVATION BIOLOGY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of this handbook.	\N	\N	\N	\N	BIO5009W	BIO	W	BIO	W
BIOLOGICAL SCIENCES DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	BIO5010W	BIO	W	BIO	W
LAW OF SUCCESSION	18	5	Professor F du Toit	Undergraduate LLB students: concurrent registration with PBL2000W \r\nand  PVL2002H.  Graduate  LLB  students:  concurrent  registration  with  PVL1003W,  PVL1004F, \r\nPVL1008H, PBL2000W and PVL2002H.			Aims and objectives \r\nThe course is concerned with the consequences of death and in particular, the devolution of a \r\nperson’s property on death. \r\nCourse content \r\nThe  course  considers  the  distinction  between  testate  and  intestate  succession;  the  devolution  of  an \r\nestate under intestacy law; testamentary capacity; formalities for wills; revocation and revival of wills; \r\ncapacity  to  inherit;  freedom  of  testation;  vesting  and  conditional  bequests;  the  different  kinds  of \r\ntestamentary  vehicles  and  the  content  of  wills;  doctrine  of  collation;  interpretation  of  wills  and \r\nsuccession  by  contract.  The  course  will  also  consider  legal  ethics  in  the  context  of  the  law  of \r\nSuccession.		Please refer to course handout.	Coursework 50%, Final examination 50%.	Preliminary Level, half course, 36 lectures.	PVL2003H	PVL	H	PVL	H
6TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE6	\N	\N	\N	\N
APPLIED OCEAN SCIENCES COURSEWORK	0	9	Professor M Vichi and Dr L C Gammage	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	The relevant dissertation code from those proposed in the handbook.	\N	This course is convened between the Departments of Biological Sciences and Oceanography. The code BIO5012W represents the overall coursework component and will reflect the overall coursework result. This full-time master with coursework and minor dissertation is offered over 13 months, beginning in January each year. It provides interdisciplinary vocational training in applied aspects of oceanography and marine biology for future ocean professionals. The course is designed for both recent graduates as well as those with several years’ work experience and who wish to gain skills to operate in the ocean services sector, focusing on operational and conservational activities, food, water quality and recreation preservation and other aspects of the Blue Economy. The curriculum offers a choice of two streams: Applied Marine Biology (BIO5014F) and Operational Oceanography (SEA5011F), with a common course in Foundations of Applied Ocean Sciences (BIO5013F) and Statistical Methods (STA5014Z). In addition, students will choose at least two elective courses, chosen from a range of modules offered in both disciplinary streams. The list and details of the offered courses will be available at registration. Students can choose to register for the minor dissertation in a number of disciplines.	\N	\N	Students must pass all coursework components with a subminimum of 40% for the fundamental course BIO5013F and the disciplinary courses (BIO5014F and SEA5011F); an aggregate coursework mark of 50% is required. A composite grade of the performance on the coursework component as a whole will be reflected against the assessment course code BIO5012W. The minor dissertation component is 50% of the degree. The choice of project for the minor dissertation will be determined by prior qualification with the course conveners and supervisors from other Departments. Students may register for a minor dissertation in a range of Departments across the University.	Students will enrol (and pay fees) for the coursework codes BIO5012W, BIO5013F, BIO5014F/SEA5011F and STA5014Z, as well as the minor dissertation course BIO5015W in their first year of registration; where the minor dissertation is not submitted by the February deadline of the subsequent year, the student will be required to enrol (and pay fees) for the minor dissertation component in the subsequent year/s.	BIO5012W	BIO	W	BIO	W
FUNDAMENTALS OF APPLIED OCEAN SCIENCES	40	9	Professor M Vichi and Dr L C Gammage	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	STA5014Z and BIO5014F or SEA5011F depending on the chosen stream. A minor dissertation code chosen from the ones described in the handbook.	\N	The course is composed of the following modules covering the foundational aspects of applied ocean sciences: 1) Introduction to Applied Ocean Sciences, which combines introduction to system- based marine sciences, basics of ecological and physical oceanography, ocean governance and project management; 2) Statistical Methods (STA5014Z), which provides an intermediate introduction to statistics and experimental design; 3) Scientific Computing and Data Management, which introduces to scientific programming and data analysis for the ocean sciences.	\N	\N	Every module is assessed independently either with a class test or individual project assignments. The syllabus and the relative weight for each module are described in a handbook that will be made available on the BIO5012W website (hosted by the Marine and Antarctic Research Centre for Innovation and Sustainability).	\N	BIO5013F	BIO	F	BIO	F
CHEMISTRY 1000	36	5	Professor G S Smith	Students wishing to register for CEM1000W will normally be expected to have passed NSC Physical Science with at least 60% and NSC Mathematics with at least 70%.	\N	\N	This course lays the foundation of chemistry in its context as a central science for scientists and engineers working in the chemical, biological or earth sciences or in chemical engineering. Fundamental concepts in chemistry are covered to illustrate their application to understanding the molecular nature of the world around us. Topics include microscopic and macroscopic concepts, atomic structure, chemical bonding and molecular structure, the chemistry of the elements and inorganic chemistry, chemical equilibrium, acids and bases, solubility, phases of matter, thermochemistry and thermodynamics, colligative properties, oxidation and reduction, electrochemistry and chemical kinetics. The course continues with an introduction to the language of organic chemistry, including structure and reactivity in organic chemistry, describing and predicting organic reactivity and the properties and reactivity of biologically important molecules. Practicals aim to develop essential manipulative and technical laboratory skills, as well as to draw links to interpreting the physical world in terms of its molecular nature. A blended approach to learning may be used where academic activities will be delivered online and face-to-face, if feasible. This will be at the discretion of the course convener.	Monday to Wednesday and Friday, 2nd or 4th period. Tutorials: Thursday 2nd or 4th period. Practicals: Tuesday, Thursday or Friday, 14h00 - 17h00.	Attendance and completion of practicals, tests and tutorial exercises, and at least 35% for the class record.	Class record (comprising tests, tutorials and practicals) counts 50%; one 3-hour examination written in November counts 50%. A subminimum of 40% is required in the final examination.	NOTES: Preference will be given to students registered in the Science Faculty. Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course, and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to CEM1009H from week 7.	CEM1000W	CEM	W	CEM	W
CHEMISTRY 1009	18	5	Dr C Edmonds-Smith	Admission will be restricted to students who have passed NSC Physical Science with at least 60%. The permission of the Dean or Head of Department is required prior to registration for this course.	\N	\N	This course lays the foundation of chemistry in its context as a central science for scientists working in the chemical, biological or earth sciences. Fundamental concepts in chemistry are covered to illustrate their application to understanding the molecular nature of the world around us. Topics include microscopic and macroscopic concepts, atomic structure, chemical bonding and molecular structure, chemical equilibrium, acids and bases, solubility, phases of matter, thermochemistry, osmosis and chemical kinetics. The course continues with an introduction to the language of organic chemistry, including naming of compounds, identification of functional groups and isomers. Practicals are designed to develop essential manipulative and technical laboratory skills, to take measurements and handle data, as well as to draw links to interpreting the physical world in terms of its molecular nature.	Wednesday - Friday, 4th period. Tutorials: Monday and Tuesday, 4th period. Practicals: Wednesday, 14h00 - 17h00.	Attendance and completion of practicals, tests and tutorial exercises and at least 35% for the class record.	Class record (comprising tests, tutorials and practicals) counts 50%; one 2-hour examination written in November counts 50%. A subminimum of 50% is required in the final examination.	NOTES: 1) Preference will be given to students registered in the Science Faculty. 2) This course only begins in week 7 and is intended for students who have been advised to transfer to this course after initially registering for CEM1000W (see entry for CEM1000W). 3) The course places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. 4) CEM1009H + CEM1010H is equivalent to CEM1000W in level, credit value towards the degree and as prerequisite for certain other courses.	CEM1009H	CEM	H	CEM	H
CHEMISTRY 1010	18	5	Dr S Douman	CEM1009H	\N	\N	Topics covered at a more advanced level include microscopic and macroscopic concepts, atomic structure, chemical bonding and molecular structure, the chemistry of the elements and inorganic chemistry, chemical equilibrium, acids and bases, solubility, vapour pressure and phase diagrams, thermodynamics, colligative properties, oxidation and reduction, electrochemistry and chemical kinetics. The course includes an introduction to the language of organic chemistry, structure and reactivity in organic chemistry, describing and predicting organic reactivity and the properties and reactivity of biologically important molecules. Practicals aim to develop essential manipulative and technical laboratory skills, as well as to draw links to interpreting the physical world in terms of its molecular nature.	Monday - Wednesday and Friday, 4th period,. Tutorials: Thursday, 4th. Practicals: Wednesday, 14h00 - 17h00.	Attendance and completion of practicals, tests and tutorial exercises and at least 35% for the class record.	Class record (comprising tests, tutorials and practicals) counts 50%; one 2-hour examination written in November counts 50%. A subminimum of 40% is required in the final examination. CEM2005W is required for students proceeding to a major in Chemistry.	NOTES: 1) This course follows on from CEM1009H and also places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. 2) CEM1009H + CEM1010H is equivalent to CEM1000W in level, credit value towards the degree and as prerequisite for certain other courses.	CEM1010H	CEM	H	CEM	H
7TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE7	\N	\N	\N	\N
STATISTICAL INFERENCE & MODELLING	36	7	Associate Professor G Distiller	STA2020F/S (or concurrent registration), STA2030S, MAM1032 or MAM1034S or MAM1006S or MAM1012F/S or MAM1021F/S or MAM1112S.	\N	\N	This course forms part of the third-year major in Applied Statistics. The aim of the course is to provide students with the main intellectual and practical skills required in the use of inferential statistics and statistical modelling. The course consists of 4 modules: The simulation module introduces students to the use of computer simulation and data re-sampling techniques (bootstrap) to investigate the following problems: one and two sample tests of means and variances; one way analysis of variance; moments and other properties of distributions. The generalized linear models module introduces students to the exponential family of distributions and extends linear regression models to models for non-normal response variables, including logistic regression. The machine learning module covers a basic introduction to statistical learning paradigms, applications of regression and classification trees, and a primer on feedforward neural networks and backpropagation. The Bayesian module introduces students to decision theory and Bayesian inference. Students will use the R programming language.	Monday - Thursday, 1st period	Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for both STA3030F and STA3041F.	STA3030F	STA	F	STA	F
COMPUTER SCIENCE HONOURS PROJECT	60	8	Associate Professor C M Keet	BSc degree with a major in Computer Science from UCT. An overall pass for the coursework component of this degree.	\N	\N	This course is the compulsory research project component of a Computer Science Honours degree. The research project comprises a large project run over the course of the year under academic supervision, with a final mini-dissertation and other project deliverables.	\N	\N	\N	\N	CSC4002W	CSC	W	CSC	W
COMPILERS 2	12	8	To be advised	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	This course will introduce students to the inner mechanics of a modern programming language compiler or interpreter. Students will appreciate why programming languages are designed in particular ways and they will learn how to develop compilers and compiler-related tools. Course content will include: semantic analysis, activation records, intermediate code, optimisations, basic block analysis, instruction selection, liveness analysis and register allocation.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC4022Z	CSC	Z	CSC	Z
INTERMEDIATE CHEMISTRY	48	6	Dr G A Venter	For Science students: CEM1000W (or equivalent), 1000-level full course in Physics, 1000-level full or semester course in Mathematics. Concurrent registration for STA1000F/S (or equivalent) is highly recommended. For Chemical Engineering students: CEM1000W (or equivalent), PHY1012F/S, MAM1020F/S, CHE1005W	\N	\N	This course develops the foundations of a major in Chemistry at an intermediate level and allows continuation to third-year Chemistry for the completion of a major in Chemistry. The theory component features a set of intermediate topics, and the laboratory component develops both experimental and interpretative skills. The course includes the following topics: spectroscopy and modern analytical tools, introduction to inorganic chemistry, organic structure and reactivity, thermodynamics, thermodynamics of solutions, phase equilibria, chemical reaction kinetics and equilibria, reactions of organic molecules (patterns, predictions and preparation of new products), introduction to coordination chemistry, structures and energetics of inorganic solids and electrochemistry. The practical course covers the same topics and aims to develop manipulative and technical laboratory skills including the application of modern analytical methods to the elucidation of chemical structures.	Monday - Friday, 3rd period. Tutorials and problem sheets by arrangement. Practicals, EBE: Tuesday, 14h00 - 17h00; Science: Thursday, 14h00 - 17h00.	Attendance and completion of practicals, tests and tutorial exercises; at least 40% average for practical exams.	The class record counts 50%; one 3-hour examination written in November counts 50%. The class record consists of class tests (20%), tutorials and problem sheets (10%), practical reports (10%) and practical exams (10%). A subminimum of 40% is required in the final examination. CEM3005W is the required course for students completing a major in Chemistry.	\N	CEM2005W	CEM	W	CEM	W
ADVANCED NUMERICAL METHODS (3AN)	18	7	Dr N Alexeeva	MAM2040F, MAM2041F, MAM2042S and MAM2043S.			Advanced methods for ODEs, boundary value problems, differential eigenvalue problems. Numerical solution of PDEs by methods of finite differences, finite elements and spectral methods. Please note that lectures alternate during the week so that students can take MAM3042F and MAM3044F concurrently.	Monday - Friday, 3rd period. Assessment: Class record counts up to 50%, while the balance is given by the final examination.		Class record counts up to 50%, while the balance is given by the final examination.		MAM3042S	MAM	S	MAM	S
CHEMISTRY 3005	72	7	Associate Professor C Veale	CEM2005W, 1000-level full course in Mathematics; completion of or concurrent registration for STA1000F/S is highly recommended.	\N	\N	This final course for the Chemistry major aims to develop understanding and integrated knowledge of the core disciplines in Chemistry. Lecture material includes topics in wave mechanics and spectroscopy, adsorption and heterogeneous catalysis, solid-state chemistry and X-ray crystallography, dynamics, inorganic reaction mechanisms, organometallic chemistry, further topics in organic structure and reactivity, organic synthesis and organic dynamic stereochemistry. The practical course covers the same topics and aims to develop integrative and interpretive skills. A further aim is to develop skills in writing within the discipline, as well as introducing students to modern research methods.	Monday - Friday, 3rd period. Practicals: Wednesday and Friday, 14h00 - 17h00.	Attendance and completion of practicals, tests and tutorial exercises, and at least 50% for the class record and practical component, respectively.	Class record (comprising class tests [20%], tutorials [5%] and practicals [25%]) counts 50%; a 3-hour June examination counts 25%; and a 3-hour November examination counts 25% towards the final mark. A subminimum aggregate of 40% across the June and November examination paper, together with at least 50% overall is required to pass the course.	\N	CEM3005W	CEM	W	CEM	W
NON-MONOTONIC REASONING	12	9	Professor T A Meyer	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	This course will introduce students to the subarea of Artificial Intelligence known as Non- Monotonic Reasoning. In addition to a brief history of the topic, students will be given a detailed introduction to at least one of the widely used approaches to Non-Monotonic Reasoning. Students will learn these approaches from both a theoretical and computational perspective.	\N	None	24-hour take-home exam, 50%; Assignments: 50%.	This course will not be offered every year.	CSC5039Z	CSC	Z	CSC	Z
CHEMISTRY HONOURS	160	8	Dr S Ngubane	A BSc degree (or equivalent) with a major in Chemistry at a sufficiently high standard to satisfy the Head of Department. Entrance to the Honours course is competitive and applications are considered individually, taking into consideration the entire academic record. UCT graduates require 60% or higher in CEM3005W as the normal minimum prerequisite for admission. Applicants from other universities must satisfy the Honours steering committee that they have covered the same topics at the equivalent level.	\N	\N	The Honours course is designed to enrich the understanding of chemical theory, while developing skills in the modern research techniques and approaches required of the professional chemist. The course has several components: Modern instrumental methods are taught through experiential workshops and lectures covering topics in NMR spectroscopy, X-ray methods of analysis, introduction to molecular modelling and separation methods. The coursework component provides the conceptual tools required in modern inorganic, organic and physical chemistry. Topics covered include inorganic spectroscopy, organometallic chemistry, bioinorganic chemistry and catalysis (inorganic chemistry), stereochemistry and FMO theory, p-block synthetic methodology, green chemistry and natural products (organic chemistry), as well as statistical thermodynamics, quantum chemistry, solid-state chemistry and group theory (physical chemistry). A 4-week extended practical covering aspects of synthesis, spectroscopy and analysis is carried out in the first semester alongside the core course. A workshop on scientific writing is carried out during this period. In the second semester, after submission of a research proposal, the student engages in 10 weeks of full-time research work which culminates in the presentation of a short dissertation, research poster and an oral presentation to the Department. Training in oral communication is provided during this period.	By arrangement. Lectures, tutorials and practicals start at the end of January. Lectures and tutorials are daily in the first four periods and at other times arranged. The extended practical work occupies one afternoon per week during the first semester and all day, all week during the second semester.	\N	Examinations count 33%, coursework 26% and the Honours research project 41%. To pass the Honours course candidates must obtain an overall average of 50%, an average of 45% for the Core Course written examinations with a subminimum of 33% on each individual paper of the Core Course examinations. In addition, candidates must attain at least 50% for the research project, 45% for the Modern Instrumental Methods and Group Theory module, complete all practical work, tutorial assignments, generic skills course and any other compulsory activities. These component parts of the course will be combined in a final overall mark which will be reflected against the course code CEM4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code CEM4000W will not carry a NQF credit value, students will be concurrently registered for CEM4001W (coursework component of 94 NQF credits) and CEM4002W (research project of 66 NQF credits). Entrance is limited to 18 students.	CEM4000W	CEM	W	CEM	W
CHEMISTRY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	CEM5000W	CEM	W	CEM	W
COMPUTATIONAL SCIENCE DISSERTATION	180	9	\N	\N	\N	\N	The academic disciplines of chemistry, chemical biology and biophysics have a critical dependence on computer simulation and large scale data analysis to understand observed phenomena and advance the frontiers of disciplinary knowledge. This course aims to prepare students to undertake research in computational science as applied to chemistry, chemical biology, biophysics and chemical physics. The two streams of focus are computation and informatics. The course will commence with project assignment followed by a combination of in-house and online short training (non-credit) courses in: Scientific Computing, High Performance Computing, Computational Methods for Data Analysis, Data Management, R Programming, Quantum Mechanics and Statistical Mechanics. The above short training courses are designed to prepare students to successfully complete a computational science project and dissertation.	\N	\N	\N	\N	CEM5002W	CEM	W	CEM	W
BIG DATA MANAGEMENT & ANALYSIS	12	8	Associate Professor C M Keet	Admission to BSc Hons specialising in Computer Science or Information Technology. A basic understanding of databases, similar to the CSC2001F database material, is expected.	\N	\N	This course will enable students to understand the challenges of designing and implementing database applications at very large scale. They will know the approaches taken by big data technologies such as relational databases, NoSQL, Hadoop and data mining tools, and have practice in applying this knowledge. The focus of this course is on systems designed for big data storage and analysis. Topics covered include NoSQL, Hadoop, HBase, HIVE, YARN and Apache Spark, as well as an introduction to data mining techniques and tools. The course concludes with a series of short presentations on new developments in database technology such as spatial, temporal, mobile, multimedia, text and social network data management.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC4023Z	CSC	Z	CSC	Z
HUMAN COMPUTER INTERACTION	12	8	Associate Professor M Densmore	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	This course will introduce you to basic concepts and practice around user-centred design of digital systems. This course covers how to design and evaluate interactive systems for real users both in the developed and developing worlds. We will look at both theory and practice of designing digital systems. Topics include the design cycle, sketching and storyboarding, task analysis, contextual inquiry, conceptual models, usability inspection, human information processing, experience design, and qualitative and quantitative study design and evaluation. We may also invite guest speakers from industry and research to talk about their own experiences with user-centred design.	\N	None	Participation: 5% (measured by participation in user studies, in-class activities, in-class discussion/presentations, and pre-class quizzes online) Individual Practical Assessments: 15%. Group Project Assessments: 30% Final Exam: 50%	This course will not be offered in 2025.	CSC4024Z	CSC	Z	CSC	Z
ARTIFICIAL INTELLIGENCE	12	8	Dr J Buys	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	This course will expose students to foundational concepts and computational techniques in modern Artificial Intelligence and their theoretical underpinnings in logic, search, optimisation and mathematical statistics. Students will also learn how to select and implement these techniques to solve various real world problems. Core topics will include: problem solving, knowledge representation and reasoning, machine learning and dealing with uncertainty, with selected topics from: planning, agents and natural language processing.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC4025Z	CSC	Z	CSC	Z
9TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE9	\N	\N	\N	\N
STRATIGRAPHY & ECONOMIC GEOLOGY	36	7	Dr G Howarth	GEO2004S and DP in GEO3005F	\N	\N	This course covers the development of the oceanic and continental rock record and associated ore deposits as follows: the principles of stratigraphy with examples drawn from the South African rock record; the methods and procedures involved in dating rocks; the genesis of economic mineral deposits, their microscopic textures, and their valuation and exploitation; geophysical techniques.	Monday - Friday, 2nd period	An average of 30% in all marked class work and class tests.	Practicals and tests count 25%; one 3-hour theory examination written in November counts 45%; two 2-hour practical examinations written in November count 30%. Subminima of 40% required in practical and theory examination papers.	\N	GEO3001S	GEO	S	GEO	S
GEOSYSTEMS: AN INTRODUCTION TO EARTH & ENVIRONMENTAL SCIENCES	18	5	Associate Professor E M Bordy	At least 50% for NSC Geography or at least 60% for NSC Physical Science or Life Sciences. NOTE: Preference will be given to students majoring in Archaeology, Environmental and Geographical Science, Geology or Oceanography.	\N	This course aims to develop a broad understanding of how the Earth works.	This course is presented jointly by the Departments of Archaeology, Environmental & Geographical Sciences, Geological Sciences, and Oceanography, but administered by Geological Sciences. Students majoring in these subjects are required to attend one half-day excursion. Over its >4.5 billion-year-long history, the Earth has been shaped by chemical, physical and biological processes. The course demonstrates why decoding the rock record of deep-time events is critical for explaining past, present and future environmental changes and the distribution of natural resources. It examines the interplay of terrestrial, marine, atmospheric, and cryospheric processes within the Earth system, with an emphasis on monitoring essential variables for understanding climate variability and change. The Earth has also sustained life over the last >3.5 billion years. Our species, Homo sapiens, is a relatively recent arrival, yet it has had, and continues to have, the greatest impact on our planet. The course reviews human evolution and how we became the dominant cause of global environmental change. The course also explores the social risks and vulnerabilities in response to the Earth’s biophysical processes and change. The course concludes with attention to the concepts of environmental hazard, risk, resilience, monitoring and adaptation.	Monday - Friday, 2nd period	An average of 40% on all marked classwork and tests. Submission of 80% of weekly assignments in each of the four sections (i.e., GEO, AGE, SEA, EGS). Attendance of the field trip is compulsory for students majoring in Archaeology, EGS, Geology, or Oceanography.	Marked classwork, including class test/s, counts 50%, and a 3-hour written examination counts 50%. A subminimum of 40% in the class mark is required to write the theory examination paper. Supplementary examinations for GEO1009F will be offered in July.	\N	GEO1009F	GEO	F	GEO	F
NETWORK & INTERNETWORK SECURITY	12	8	Dr J Chavula	Admission to BSc Hons specialising in Computer Science or Information Technology. Computer Networking at third year level.	\N	\N	The objective of this course is to introduce cryptographic techniques and protocols for secure exchange of information on networks and internetworks, and to examine the deployment of these in emerging technologies. The course will cover risk issues (ISO27000; PoPI act); security services; conventional encryption (classical encryption techniques, DES/AES, key distribution, key generation); public-key encryption (RSA algorithm, key management, certification hierarchies); authentication & digital signatures; authentication and key exchange (Kerberos, Diffie-Hellman); electronic messaging security (S- MIME/PGP/WhatsApp); HTTP security (S-HTTP, SSL, capabilities); secure electronic commerce (SET); web application security (OWASP); web-services security (WS-Security, SAML); cloud computing security (public vs private clouds); critical infrastructure security (Stuxnet etc); Security Information & Event Management (SIEM) and next generation Security Operation Centres.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC4026Z	CSC	Z	CSC	Z
COMPUTER GAME DESIGN	12	8	Professor J Gain	Admission to BSc Hons specialising in Computer Science or Information Technology. Computer Graphics at third year level.	\N	\N	This course will introduce students to the techniques and technologies used in designing and programming computer games and related applications. This course introduces high-level game programming concepts and practical game construction. By the end of the course, students will be able to design and implement simple 2D and 3D games. The course content include: appropriate terminology, methods, and tools for computer game development are introduced; fundamental algorithms for 2D game development; design and development of simple 3D and networked games; uncertainty and constantly changing gaming environments; and techniques for multiuser and distributed games. This is a practical course: students collaborate with designers and artists to produce a full games that builds on concepts covered in lectures.	\N	None	Final examination: 60%; Practical assignments: 40%	This course will not be offered every year.	CSC4027Z	CSC	Z	CSC	Z
HIGH-PERFORMANCE COMPUTING	12	8	Professor M M Kuttel	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	High performance computing is high-speed computing - the use of parallel processing to run application programs efficiently, reliably and fast. It is an interdisciplinary field, encompassing computer architecture, programming languages, system software and benchmarking, as well as subject domains such as Physics, Astronomy, Chemistry, Finance etc. In this course, we cover the following topics. An introduction to and motivation for high performance computing (HPC), including typical applications; HPC architectures with a focus on current supercomputer design; programming interfaces for paralllel computing (OpenMP and MPI); parallel libraries; parallel algorithms; bench marking, profiling and debugging. We then examine case studies of papers from the annual SuperComputing conference.	\N	None	Final examination: 50%; Coursework: 50%; Subminima of 45% for both exam and the assignments.	This course will not be offered every year.	CSC4028Z	CSC	Z	CSC	Z
INTRODUCTION TO COMPUTER GRAPHICS	12	8	Associate Professor P Marais	Admission to BSc Hons specialising in Computer Science or Information Technology.	\N	\N	This course will expose students to the foundational theory of 3D computer graphics and provide a short introduction to OpenGL and GLSL shader programming. Theory will encompass the formal description of 3D models and how these can be lit and rendered to produce a desired representation of a 3D scene. On the practical side, a series of short assignments will introduce basic OpenGL and shader programming and allow students to apply the theory they have learned. Topics include: the rendering pipeline and rasterization; 3D mesh model representation; homogeneous coordinates; modelling and viewing transformations; shading, lighting and texturing; GLSL shader programming; OpenGL/WebGL programming; advanced rendering - ray-tracing.	\N	40% in the practical assignments for the course.	Assignment (40%), Exam (60%)	This course will not be offered every year.	CSC4029Z	CSC	Z	CSC	Z
10TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE10	\N	\N	\N	\N
COMPUTATIONAL GEOMETRY FOR 3D PRINTING	12	9	Professor J Gain	Admission into the Master's degree specialising in Computer Science, or permission from the course convener. Computer Graphics at third-year level.	\N	\N	The objective is to master surface and volumetric modelling concepts applicable to 3D printing. The use of 3D printers for rapid prototyping is becoming increasingly prevalent. However, the process used by most current 3D printers of depositing thin layers of semi-molten material, which is known as Fused Deposition Modelling (FDM), is not without limitations. Factors such as material thickness and support structures need to be considered. This course will cover the theoretical concepts required for creating geometric models suitable for 3D printing. From a practical perspective, students will code modelling software, then design and ultimately print a 3D model. Topics covered include: Geometry and Topology for Computer Graphics; 3D Printing Concepts: Printing Hardware, Overhang Support, Applications; Volumetric Concepts: Voxels, Computational Solid Geometry, Isosurface Extraction; Surface Concepts: Parametric Surfaces, Mesh Smoothing, Free-Form Deformation.	\N	None	Exam: open book, 2 hours, 40%. Practical assessments 50%; Final printed show piece, 10%	This course will not be offered every year.	CSC5021Z	CSC	Z	CSC	Z
ANALYTICS	18	8	Dr E Pienaar	Undergraduate degree that included a substantial degree of training in quantitative subjects and programming, as assessed by the course convener.	\N	\N	This course covers various topics in the field of Analytics. Section A, Theory and Application of Supervised Learning, covers topics including but not limited to the bias-variance trade-off, model validation methods, linear and non-linear models for regression and classification, both under constrained and unconstrained optimisation (i.e., objective function regularisation), classification model evaluation metrics (accuracy, precision, recall, ROC curves etc.), and non-parametric heuristics. These include K-nearest neighbours, regression and classification trees, ensemble methods such as bagging, random forests, and gradient boosted trees (with variations). Section B, First Principles Neural Networks, develops the mathematics that underpins model construction and optimisation for the class from the original perceptron learning algorithm, logistic regression and polytomous regression to the famous backpropagation algorithm that is used during the implementation of gradient descent as a learning algorithm. As such, we will not be using the download-and-run-X-package approach but rather we will be coding all relevant machinery from first principles and use this code to conduct analysis. Finally, Section C, Theory and Application of Unsupervised Learning covers distance based clustering (K-means/medoids/modes and Hierarchical), density based clustering, probabilistic methods, and self-organising maps. Finally a brief digression into association rule mining is made. All coding is conducted in R and typesetting in LaTeX, R-Markdown, or equivalents. A large proportion of the coding is from first principles and is examined as such.	\N	Satisfactory completion of assignments	Assignments, a Computer-based Exam and a Theory Exam Master's specialising in Computer Science by Dissertation	\N	STA4026S	STA	S	STA	S
COMPUTER SCIENCE DISSERTATION	180	9	Professor J Gain	Computer Science Honours from UCT prior to 2018, or permission from the Head of Department in exceptional cases. In the normal case, students will be expected to register for Master’s specialising in Computer Science, by coursework and minor dissertation.	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook. Students will be expected to attend a research methods course in the first year. Master's specialising in Computer Science or Artificial Intelligence or Human- Computer Interaction, by Coursework and Minor dissertation The Department offers two Master's streams: MSc specialising in Computer Science (CS) and MSc specialising in Artificial Intelligence (AI). Programme Convener: Professor J Gain Course structure: See General rules for Master's Degrees in the front section of this book. Progression: In any given year, students must either be registered for or have passed at least six of the elective courses. Students get two attempts to pass each course. Should a student fail any course on the second attempt, they will not be allowed to continue with the degree. This applies to the Research Methods course as well. Students should pass a minimum of two elective courses per year. With the course convenor’s permission, students who have passed the Research Methods course as well as four of the six elective courses may be permitted to register for CSC5002W/CSC5037W/CSC5041W. Students are not eligible to register for CSC5002W/CSC5037W/CSC5041W until they have completed the Research Methods course and at least four (out of six) elective courses.	\N	\N	\N	\N	CSC5000W	CSC	W	CSC	W
COMPUTER SCIENCE MINOR DISSERTATION	90	9	Professor J Gain	Completion of all coursework, or permission of the convener.	\N	\N	Upon successful completion of the coursework, students will be required to register for this minor dissertation component and complete a suitable research project under supervision of an appropriate computer science academic staff member. The research component will expose the student to research methodology, experimental design, data analysis techniques, and dissertation writing skills. Students should be in a position to submit the final dissertation by the end of the year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	CSC5002W	CSC	W	CSC	W
ARTIFICIAL INTELLIGENCE MINOR DISSERTATION	90	9	Professor J Gain	Completion of all coursework, or permission of the convener.	\N	\N	Upon successful completion of the coursework component, students will be required to register for this minor dissertation component in Artificial Intelligence and complete a suitable research project on a topic within the broad area of Artificial Intelligence under supervision of an appropriate computer science academic staff member. The research component will expose the student to research methodology, experimental design, data analysis techniques, and dissertation writing skills. Students should be in a position to submit the final dissertation by the end of the year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	CSC5037W	CSC	W	CSC	W
DATA VISUALISATION	12	9	Professor M M Kuttel	Admission into the Master's degree specialising in Computer Science, or permission from the course convener.	\N	\N	Visualisation is the graphical representation of data with the goal of improving comprehension, communication, hypothesis generation and decision making. This course aims to teach the principles of effective visualisation of large, multidimensional data sets. We cover the field of visual thinking, outlining current understanding of human perception and demonstrating how we can use this knowledge to create more effective data visualisations.	\N	40% for assignment component.	Students will be assessed with assignments (50%) and an exam (50%). A sub- minimum of 40% will be required for each of the assignment and exam components of the course.	This course will not be offered every year.	CSC5008Z	CSC	Z	CSC	Z
11TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE11	\N	\N	\N	\N
REAL ANALYSIS (2RA)	12	6	M Vandeyar	MAM1031F and MAM1032S or equivalent.	\N	\N	Students will study the fundamentals of real analysis, including: Axioms of the real numbers, supremum and infimum; Countable sets; Sequences and series; Open and closed sets, compactness; Limits, continuity, differentiability; Sequences and series of functions, uniform convergence, power series; Integration. Please note that lectures alternate during the week so that students can take any of MAM2012S, MAM2013S and MAM2014S concurrently.	Mondays, Thursdays and some Wednesdays in 4th and 5th period.	\N	\N	\N	MAM2014S	MAM	S	MAM	S
RESEARCH METHODS IN COMPUTER SCIENCE	18	9	Professor J Gain	Admission into the Master's degree specialising in Computer Science, or permission from the course convener.	\N	\N	The objective of the Research Methods course is to introduce students to a suite of research methods from the perspective of Computer Science, that will prepare them for the minor dissertation component of the degree. More specifically, the aim is to ensure that students are able to write an appropriate research proposal, and have a good understanding of what it means to conduct research within Computer Science. Course content includes: An introduction to finding and reading research papers; Literature reviews; Writing research proposals; Problem statements, research questions, and hypotheses; Types of research within Computer Science; Research Ethics within Computer Science; Scientific and technical writing; Qualitative and quantitative research methods; Research statistics; Research planning and grant writing; Academic career planning.	\N	None	A submitted literature review (50%) and research proposal (50%).	\N	CSC5020Z	CSC	Z	CSC	Z
GEOLOGY HONOURS	160	8	Associate Professor J F Diener	A BSc degree with a major in Geology, first qualifying courses in Chemistry and Mathematics. A first qualifying course in Physics is recommended. The Senate may accept other courses as being equivalent to these and this criterion will be applied when considering science graduates from other universities. Registrations are limited to 16 and acceptance will be at the discretion of the Head of Department, who will consider quality of final year results, material covered in undergraduate curriculum, and referee reports in making decisions. Preference will be given to UCT graduates who meet the course entry requirements.	\N	\N	Students are required to take 7 compulsory modules which cover the following subject areas: Geochemistry (including Isotope and Marine Geochemistry), Geophysics, Economic Geology, Igneous, Metamorphic and Mantle Petrology, Palaeontology, Quaternary Geology, Petroleum Geology, Sedimentary Basins, Tectonics, Geological Data Interpretation & Analysis, and Scientific Communication. In addition, each student is required to undertake a supervised research project. Choice of research project requires the approval of the Honours course co-ordinator and Head of Department. All students are required to attend a two week fieldtrip held during the year.	\N	\N	The modules will be examined in mid-year and in October, and the latter examinations will include a 3 hour General Exam. Examinations will count 45%, practical and assignment work done during the year counts 30%, and the research project 25% towards the final grade. Subminima are required for the overall examination mark (40%) and for the research project (50%). These component parts of the course will be combined in a final overall mark which will be reflected against the course code GEO4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code GEO4000W will not carry a NQF credit value, students will be concurrently registered for GEO4003W (coursework component of 120 NQF credits) and GEO4004W (research project of 40 NQF credits). Entrance is limited to 16 students.	GEO4000W	GEO	W	GEO	W
META-HEURISTICS	12	9	Associate Professor G Nitschke	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener. A basic understanding of genetics and evolution is useful, but not required.	\N	\N	Meta-heuristics are a sub-field of biologically inspired artificial intelligence and general algorithmic frameworks that can be applied to different optimisation problems with relative few modifications to adapt them to a specific problem. This course examines the theory and application of several different meta-heuristic methods, including: iterated local search, tabu search, evolutionary algorithms, ant colony optimisation, simulated annealing, and particle swarm optimisation. Course objectives include: gaining an understanding of the algorithmic theory and implementation of various meta-heuristic algorithms, identifying meta-heuristics suitable for solving different types of problems, and how to apply (implement) such meta-heuristics to various optimisation, machine learning, and design tasks.	\N	None	Exam: 50%; Practical assignments: 50%.	This course may not be offered every year.	CSC5023Z	CSC	Z	CSC	Z
INFORMATION RETRIEVAL	12	9	To be advised	Admission into the Master's degree specialising in Computer Science, or permission from the course convener. Basic understanding of XML data is required. Some background on statistics and linear algebra will be useful.	\N	\N	The objective is to understand how search engines work at an algorithmic level. Learn how to build and incorporate basic and specialized search engines into your own projects. Course content includes: Introduction to Information Retrieval (IR); Models of Basic IR (Boolean, Vector, Probabilistic); IR evaluation and testbeds; Stemming, Stopping, Relevance Feedback; Models of Web and linked-data retrieval (Pagerank, HITS); Latent Semantic Analysis and Clustering; Multimedia IR; Cross-lingual and multilingual IR; and IR in Practice (CMSes, digital libraries, Web, social media, etc.). Selected topics will be included from: Distributed and Federated IR; Recommender Systems; Natural Language Processing for IR; Sentiment Analysis; Opinion Retrieval; and Text Summarization.	\N	None	Exam (take-home): 40%; Assignments: 40%; Class participation: 20%	This course will not be offered every year.	CSC5024Z	CSC	Z	CSC	Z
INTELLIGENT SYSTEMS	12	9	Associate Professor D Moodley	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener. A strong mathematics background.	\N	\N	This Computer Science masters course provides an introduction to designing and implementing intelligent systems, using selected Artificial Intelligence techniques. The course will introduce you to at least two widely used Artificial Intelligence approaches, including machine learning and Bayesian Artificial Intelligence. You will learn these techniques from a Computer Science perspective, specifically how to design real world intelligent systems that incorporate such AI techniques.	\N	None	2 hour open book exam: 50%, Practical assignments: 50%	This course will not be offered every year.	CSC5025Z	CSC	Z	CSC	Z
LOGICS FOR ARTIFICIAL INTELLIGENCE	12	9	Professor T A Meyer	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener. Familiarity with basic discrete mathematics is highly recommended.	\N	\N	This course will introduce students to logics used in the area of Knowledge Representation - a subarea of Artificial Intelligence. Logic plays a central role in many areas of Artificial Intelligence. This course will introduce students to Description Logics, a family of logics frequently used in the area of Knowledge Representation and Reasoning. Description Logics are frequently used to represent formal ontologies. Topics covered include the following: The Description Logic ALC; Reasoning in Description Logics with Tableaux Algorithms; Reasoning in the EL family of Description Logics; and Query Answering.	\N	None	Exam: open book, 3 hours, 50%; Assignments: 50%.	This course will not be offered every year.	CSC5027Z	CSC	Z	CSC	Z
12TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE12	\N	\N	\N	\N
GEOCHEMISTRY HONOURS	160	8	\N	\N	\N	\N	\N	\N	\N	\N	As for GEO4000W above. Students undertaking a geochemical or analytical geochemistry project can elect to graduate in Geochemistry, subject to the approval of the Head of Department. Since the code GEO4001W will not carry a NQF credit value, students will be concurrently registered for GEO4005W (coursework component of 120 NQF credits) and GEO4006W (research project of 40 NQF credits).	GEO4001W	GEO	W	GEO	W
ONTOLOGY ENGINEERING	12	9	Associate Professor M Keet	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener. Experience in modelling (ER, UML Class diagrams) and some familiarity with logic will be helpful.	\N	\N	The principal aim of this module is to provide the participant with an overview of ontology engineering—including language features, automated reasoning, and top-down and bottom-up ontology development—and a main application field being the Semantic Web. Course Content: Ontologies are used in a wide range of applications, such as data integration, recommender systems, e-learning, semantic scientific workflows, and natural language processing. While some of these applications pass the revue, the main focus of the course is on the ontologies. The topics covered include the following: Logic foundations for ontologies: Languages (Description Logics, OWL); and Automated reasoning (class and instance classification, satisfiability and ontology consistency checking). Ontology development: Ontology engineering, top-down - foundational ontologies, ontology design patterns; Ontology engineering, bottom-up - exploiting legacy material, such as relational databases, thesauri, text; and Methodologies for ontology development and maintenance, methods to enhance ontology quality and to automate some aspect of the methodology.	\N	None	Exam (closed-book but with some material provided) - 50%, assignments - 50%.	This course will not be offered every year.	CSC5028Z	CSC	Z	CSC	Z
MIT: RESEARCH METHODS	12	9	Associate Professor G Nitschke	Admission into the Master's degree specialising in IT, or permission from the course convenor.	\N	\N	This module is intended to provide students with the insight and techniques required to allow them to write a successful postgraduate research project - the final module leading to the Master's Degree. Topics to be covered include: Introduction to IT Research; Ethics in Research; Conducting a Literature Review; Finding a Research Question/Goal; Project Management; Research Proposals; Experimentation; Prototypes; Case Studies; Surveys; Conducting Observations; Testing in IT Research; Modelling; Usability Analysis; Introduction to Statistics; The Writing Process; Research Presentations; and The Masters/PhD Thesis.	\N	40% for assignment component.	Final examination: 50%; Practical assignments: 50%. A sub-minimum of 40% will be required for each of the assignment and exam components of the course. Master's specialising in Data Science For details of this course, refer to the Department of Statistical Sciences. The curriculum structure is outlined in the front section of this book.	\N	CSC5017Z	CSC	Z	CSC	Z
RESEARCH METHODS FOR NATURAL SCIENTISTS	30	8	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course has a dual purpose. Firstly, a series of weekly lectures and hands-on practical seminars on the nuts and bolts of quantitative analysis. The analysis techniques investigated are (mostly) the fundamental methods found commonly in the literature; viz: Classification, time series analysis, EOF/PCA, non-linear analysis. In parallel to this are a series of seminars on “the Philosophy of Science” addressing issues of values, perception, the science community, etc.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4023F	EGS	F	EGS	F
INTRODUCTION TO IMAGE PROCESSING AND COMPUTER VISION	12	9	Associate Professor P Marais	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	To introduce students to basic concepts in computer vision and image processing, oriented towards solving real world, practical image analysis problems. The student will be introduced to basic concepts from digital signal processing, and a foundation built that will allow understanding of how more sophisticated schemes such as image analysis/segmentation which can be used to describe image and volumetric data at a higher, more useful, levels of abstraction. Case studies and papers will be examined which relate this to real-world problems. A number of lectures (as indicated below) will be presented by the course convener, interspersed with paper/review sessions in which topical papers are discussed and followed up by review questions. Topic will include: Basic Signal processing; Image Transforms & Operations; Feature Detection; Object Descriptions; Basic Segmentation & Registration; Fundamental Segmentation techniques; Machine Learning & GAs in Cvision; Case Study; and Paper Reviews.	\N	None	Exam: Open Book; 2 hours. Class Record: Practical 60%, Review Questions 40%. Final Mark: Exam 40%, Class Record 60%.	This course will not be offered every year.	CSC5029Z	CSC	Z	CSC	Z
ADVANCED TOPICS IN COMPUTER SCIENCE MASTER'S 1	12	9	Professor J Gain	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	This course introduces advanced and cutting edge topics in Computer Science as they emerge with new areas of investigation or practice.	\N	None	Exam: 50% and Coursework: 50%	This course will not be offered every year.	CSC5030Z	CSC	Z	CSC	Z
ADVANCED TOPICS IN COMPUTER SCIENCE MASTER'S 2	12	9	Professor J Gain	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	To introduce advanced and cutting edge topics in Computer Science as they emerge as new areas of investigation or practice.	\N	None	Exam: 50% and Coursework: 50%	This course will not be offered every year.	CSC5031Z	CSC	Z	CSC	Z
INTRODUCTION TO ICT FOR DEVELOPMENT	12	9	Associate Professor M Densmore	Admission into the Master's degree specialising in Computer Science, or permission from the course convener.	\N	\N	The goal is for you to understand basic ideas underlying ICT4D and how they are used in practice. You will learn about and critically evaluate ICT4D projects. You will learn how to design and evaluate development-oriented computing projects. Course Content: Introduction to key terminology around socio-economic development; Key concepts in ICT4D (e.g. social inclusion, after access); Case studies in specific domains, including healthcare, agriculture, mobile money, education, etc.; Critical evaluation of ICT4D projects.	\N	None	Practical assignments: 80%; Case Study Presentation: 10%; Class Participation: 10%	This course will not be offered in 2025.	CSC5026Z	CSC	Z	CSC	Z
NETWORKS & INTERNET SYSTEMS	12	9	Dr J Chavula	Admission into the Master's degree specialising in Computer Science, or permission from the course convener. Working knowledge of computer networks.	\N	\N	The objective is to gain advanced understanding of techniques for traffic engineering and quality of service in the Internet architecture. The course focuses on advanced topics in internetworking, traffic engineering, and mechanisms for measuring performance and Quality of Service (QoS) for network services and the Internet. Course content includes: New Network and Transport Protocols (IPv6, Mobile IP, IP Multicast, Multipath TCP, QUIC); Routing and Traffic Engineering (Interdomain Routing and Traffic Engineering with Border Gateway Protocol); Traffic Engineering with Overlay Networking (MPLS/GMPL, Location/Identifier Separation Protocols, Software Defined Networking and Network Function Virtualization); Internet Measurements (Quality of Service and Quality of Experience (QoS and QoE), IP Traffic Monitoring and Analysis) Selected reading/discussion topics will be included from: Cloud Infrastructure; Content Delivery Networks; Internet Access in the Developing World, Community Networks; ICT4D, Online Data Protection and Online Censorship.	\N	None	Assignments: 40%. Discussion sessions: 15%. Active Participation in Class: 5%. Final Exam : 40%	This course will not be offered every year.	CSC5032Z	CSC	Z	CSC	Z
HUMAN COMPUTER INTERACTION	12	9	Associate Professor M Densmore	Admission into the Master's degree specialising in Computer Science, or permission from the course convener.	\N	\N	This course will introduce you to basic concepts and practice around user-centred design of digital systems. This course covers how to design and evaluate interactive systems for real users both in the developed and developing worlds. We will look at both theory and practice of designing digital systems. Topics include the design cycle, sketching and storyboarding, task analysis, contextual inquiry, conceptual models, usability inspection, human information processing, experience design, and qualitative and quantitative study design and evaluation. We will also invite guest speakers from industry and research to talk about their own experiences with user-centred design. The course will contain additional practical work to distinguish it from the honours level module on Human Computer Interaction (CSC4024Z).	\N	None	Participation: 10% (measured by participation in user studies, in-class activities, in- class discussion/presentations, and pre-class quizzes on Vula) Individual Practical Assessments: 20%. Group Project Assessments: 40% Final Exam : 30%	This course will not be offered in 2025.	CSC5033Z	CSC	Z	CSC	Z
VIRTUAL REALITY	12	9	Professor J Gain	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	Virtual Reality (VR) involves the creation of a digital replacement for the senses (sight, hearing, smell, taste, touch) using devices, such as head-mounted displays and haptic feedback, in such a way that users perceives themselves to be immersed in an alternate or augmented reality. VR has applications in games, simulation and training. This course will introduce the theoretical underpinnings and practical skills necessary for creating virtual environments. Topics covered include the following: Interaction in VR, navigation and locomotion in VR, simulator sickness, immersion and presence, designing VR Environments with Unity, non-visual modalities (binaural output, virtual flavour, haptics).	\N	None	Exam: open book, 24 hours, 50%; Assignments: 50%.	This course will not be offered every year.	CSC5036Z	CSC	Z	CSC	Z
ARTIFICIAL LIFE	12	9	Associate Professor G Nitschke	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	Artificial life is a multi-disciplinary field of study (drawing from computer science, artificial intelligence, complex systems, evolutionary biology and chemistry), wherein researchers examine living systems, their adaptive processes and evolution, through the use of computer simulations, robotics, and biochemistry. In Artificial Intelligence (AI), researchers ponder the nature of intelligence by trying to build intelligent systems from scratch, and in Artificial Life (ALIFE), researchers investigate the nature of “life” by trying to build artificial living systems from scratch. This course examines the origins of ALIFE, Cybernetics and AI: simulation and synthesis of life- like systems, self-reproducing artificial evolution systems of digital organisms, cellular automata, swarm intelligence and stigmergy, as well as nature-inspired computation such as automated product design and evolutionary art. Course objectives include gaining an understanding of the theory and application of several selected topics via the implementation and analysis of various artificial life systems.	\N	None	Exam: 50%; Practical Work: 50%.	This course will not be offered every year.	CSC5038Z	CSC	Z	CSC	Z
POLITICS OF AFRICA AND THE GLOBAL SOUTH	30	7	Associate Professor L Paremoer	Any 2000-level POL course, or with special permission from the Head of Department.	\N	\N	This course reviews the theories and approaches that are typically used to analyse the political economies and political regimes of countries in the global South. The reliability, validity and normative implications of these theories will be evaluated with reference to key case studies -- in many cases drawn from the African Continent – in order to illustrate or problematise their claims. Though this is a political science course, our study of the politics of the South will be informed by debates that span a number of disciplines, including history, economics, law, anthropology and sociology.	Monday, Tuesday, Wednesday 4th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL3029S	POL	S	POL	S
POLITICAL THEORY	24	6	Dr G M Maxaulane	POL1004F and POL1005S or with special permission from the Head of Department.	\N	\N	The course examines the social theories of modernity or the role of the post-Enlightenment Scientific Revolution in the formation of the theory of the subject. Against this backdrop, we examine how Descartes goes about establishing the existence of the subject and then we will examine some of the different forms assumed by the new subject (including colonial, democratic, fascist, and totalitarian forms). When it comes to colonial modernity, we will consider the effects of the modern episteme in the history of colonialism and the modes of resistance assumed by the anti-colonial subject and the "post"-colonial subject.	Monday to Thursday 8th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL2002S	POL	S	POL	S
SOCIAL AND DEVELOPMENTAL PSYCHOLOGY	24	6	TBA	PSY1004F and PSY1005S or equivalent.	\N	This course provides an introduction to two major areas of psychological research and theory.	This course provides an introduction to two major areas of psychological research and theory. Social Psychology is taught in one half of the course. The social psychology module introduces students to some basic concepts and theories in social psychology, exposes students to current research within the field, and provides an opportunity for students to engage critically with existing theories and their relevance to the South African context. Some of the major topics covered will include race and racism, social identity and social change, intergroup contact, and social influence. Developmental psychology is taught in the other half of the course. The developmental psychology module focuses on understanding the changes and continuities that occur in children from conception through adolescence. The sessions will cover central theoretical issues and research strategies in developmental psychology, prenatal development, cognitive and language development, social and emotional development, and contexts of development.	Tuesday to Friday, 7th period.	Completion of all coursework, and 80% attendance at tutorials.	Coursework will be weighted at 50%, and will include completion of tutorial assignments, essays and tests as required. An exam at the end of the semester will be weighted 50%.	Was previously PSY2003S (Social Psychology and Intergroup Relations) and PSY2009F (Developmental Psychology)	PSY2013S	PSY	S	PSY	S
DISCRETE MATHEMATICS (3DM)	18	7	Associate Professor D Erwin	MAM2010F, MAM2011F, and two of MAM2012S, MAM2013S and MAM2014S.	\N	\N	Graph theory, combinatorial counting, discrete probability theory, recurrences, algorithms, applications.	Monday - Friday, 4th period.	\N	\N	\N	MAM3012F	MAM	F	MAM	F
DATABASE SYSTEMS	12	9	Associate Professor S Berman	Acceptance into the Master's degree, specialising in Data Science or Information Technology.	\N	\N	This course will introduce students with little or no prior experience to the three cornerstone database technologies for big data, namely relational, NoSQL and Hadoop ecosystems. The course aims to give students an understanding of how data is organised and manipulated at large scale, and practical experience of the design and development of such databases using open source infrastructure. The relational part will cover conceptual, logical and physical database design, including ER modelling and normalisation theory, as well as SQL coding and best practices for performance enhancement. NoSQL databases were developed for big data and semi-structured data applications where relational systems are too inefficient; all four types of NoSQL architecture will be introduced. Distributed data processing is key in manipulating large data sets effectively. The final section of the course will teach the popular Hadoop technologies for distributed data processing, such as MapReduce programming and the execution model of Apache Spark. The course will be presented in an online format.	\N	40% for assignment component.	Final examination: 50%; Practical assignments: 50%. A sub-minimum of 40% will be required for each of the assignment and exam components of the course.	\N	CSC5007Z	CSC	Z	CSC	Z
NATURAL LANGUAGE GENERATION	12	9	Dr Z Mahlaza	Admission into the Master's degree specialising in Computer Science or Artificial Intelligence, or permission from the course convener.	\N	\N	This course will introduce you to the subarea of Artificial Intelligence known as Natural language generation (NLG). In addition to a brief history of the topic, you will be given a detailed introduction to three approaches for building NLG systems (i.e., symbolic, statistical, and neural techniques). You will learn these approaches from both a theoretical and computational perspective.	\N	None	Exam: 24-hour take-home exam, 60%; Assignments: 40%. Master's specialising in Information Technology by Coursework and Minor dissertation Programme Convener: Associate Professor G Nitschke Entry requirements: The Masters in Information Technology by Coursework and Dissertation is a conversion course designed for those with a degree in a non-IT field to attain a strong background and a qualification in Information Technology. This course follows a Bachelor Honours or equivalent in any non-IT degree. All admissions decisions are at the discretion of the university. Course structure: See General Rules for Master's Degrees in the front section of this book. Progression: Students should pass a minimum of three courses each year. Should a student fail any course on the second attempt, they will not be allowed to continue with their studies. Students are eligible to register for dissertation research (CSC5004W or INF5007W) once they have passed 7 of the 8 courses. Students should register for their dissertation in the department of their supervisor.	This course will not be offered every year.	CSC5042Z	CSC	Z	CSC	Z
INFORMATION TECHNOLOGY MINOR DISSERTATION	90	9	Associate Professor G Nitschke	CSC5005H and CSC5006H or (CSC5007Z/CSC5013Z, CSC5010Z, CSC5011Z, CSC5012Z, CSC5014Z/INF5007Z, CSC5015Z/INF5009Z, CSC5016Z/INF5008Z and CSC5017Z) or permission from the convener.	\N	\N	Upon successful completion of the coursework component (Two block modules (CSC5005H and CSC5006H) or all eight individual modules (CSC5007Z, CSC5010Z, CSC5011Z, CSC5012Z, CSC5014Z, CSC5015Z, CSC5016Z and CSC5017Z)), students will be required to register for this minor dissertation course and complete a one year research project under supervision of an appropriate computer science academic staff member.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	CSC5004W	CSC	W	CSC	W
MASTERS IN IT: INFORMATION TECHNOLOGY MINOR DISSERTATION	90	9	I Brown	A non-IT honours degree, or equivalent.	None.	\N	The research component will expose students to critical reading and writing skills, develop analysis and research skills through research methodology and data analysis techniques. Students should be in a position to submit the final dissertation by the end of the year	\N	In order to be permitted to sit the final exam a minimum average of 40% on the coursework must be obtained.	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	INF5010W	INF	W	INF	W
MIT: COMPUTER NETWORKS	12	9	Dr J Chavula	Admission into the Master’s degree specialising in IT, or permission from the course convenor.	\N	\N	In the course, a framework for describing the operation of computer networks is developed. Within this framework, we start with the operation of local-area networks, packet-switched networks and the Internet. After this, the module moves to the uses made of these networks, concentrating on business applications. The effect on organisations of introducing such networked applications is also examined.	\N	40% for assignment component.	Final examination: 50%; Practical assignments: 50%. A sub-minimum of 40% will be required for each of the assignment and exam components of the course.	\N	CSC5010Z	CSC	Z	CSC	Z
MIT: OBJECT-ORIENTED PROGRAMMING IN PYTHON	12	9	To be advised	Admission into the Master's degree specialising in IT, or permission from the course convenor.	\N	\N	The underlying aim of all courses is to develop a foundation in key topics related to the application of computer hardware and software in solving practical problems. This is a basic introduction to object-oriented programming in a modern language, namely, Python. Python is becoming increasingly popular as an effective means of introducing programming concepts to those who are new to programming. Students will be taught how to create simple applications in the Python language.	\N	40% for assignment component.	Final examination: 50%; Practical assignments: 50%. A sub-minimum of 40% will be required for each of the assignment and exam components of the course.	\N	CSC5011Z	CSC	Z	CSC	Z
TOPICS IN ALGEBRA (3TA)	18	7	Dr J Sanchez-Ortega	MAM2010F, MAM2011F, and two of MAM2012S, MAM2013S and MAM2014S.	\N	\N	This courses provides an Introduction to Ring Theory. A selection of the topics covered: Definition of a ring, examples, main properties. The field of fraction of an integral domain. Polynomial rings.	Tuesdays, Fridays and some Wednesdays in 5th period.	\N	\N	\N	MAM3013S	MAM	S	MAM	S
COMPUTER SCIENCE THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	Students will be expected to attend a research methods course in the first year.	CSC6000W	CSC	W	CSC	W
ATMOSPHERIC SCIENCE HONOURS	160	8	To be advised	As for EGS4004W, with the additional requirement of at least a half- course in Mathematics or a full-course in Physics, as well as a senior undergraduate course in climatology or atmospheric science. Computer literacy is highly recommended.	\N	\N	The Atmospheric Science programme provides a 4th year of development for those interested in following a career associated with atmospheric science and climatology, or for progression to research in this area. The focus is on practical skills and the application of theory to the issues related to the climate system. The programme follows the same pattern as EGS4004W, with the constraint that three of four course modules must be from the atmospheric options, and the fourth module from one of the Honours level physical science options in Environmental & Geographical Science or the Oceanography department. Included in the requirements are a research project, two seminar presentations, and course fieldwork. Students will also attend and present at the annual conference of the South African Society for Atmospheric Scientists.	\N	Students must pass at least three of their coursework electives and achieve a composite pass on the coursework. Students must achieve a pass on their research project to proceed to graduation in the degree.	The examinations will follow the same structure as EGS4004W. Not all course options have formal examinations, and a significant portion of the total coursework mark may be based on set project tasks. Examinations on average count 50% and coursework 50% for each module. The combined module results count 75% and the research project counts 25% of the degree as a whole. Students must pass the project component in order to qualify. These component parts of the course will be combined in a final overall mark which will be reflected against the course code EGS4001W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code EGS4001W will not carry a NQF credit value, students will be concurrently registered for EGS4052W (coursework component of 120 NQF credits) and EGS4053W (research project of 40 NQF credits).	EGS4001W	EGS	W	EGS	W
ENVIRONMENTAL & GEOGRAPHICAL SCIENCE HONOURS	160	8	Dr P Sabela-Rikhotso	A BSc degree with a major in Environmental & Geographical Science or related field. Acceptance will be at the discretion of the Head of Department who will consider quality of final year results, material covered in the undergraduate curriculum, and referee reports. Preference may be given to UCT graduates who meet the course entry requirements.	\N	\N	Students complete four advanced semester modules. One of these four modules must be a research methods module. Students complete a research methods course and then select a further three modules from a range of advanced courses in Environmental and Geographical Science that have foundations in one or more of the following areas of study: Human Geography, Environmental Management, Physical Geography. Curricula must be approved by the course convener in consultation with the Head of Department. In addition, each student completes a research project. At the discretion of the Convener, in consultation with the Head of Department, students may take one course from outside the Department (in addition to the methods course) towards the BSc Hons degree in Environmental & Geographical Science.	\N	Students must pass at least three of their coursework electives and achieve a composite pass on the coursework. Students must achieve a pass on their research project to proceed to graduation in the degree.	Courses will be examined at the end of each semester, and the marks combined with project, essay, fieldwork and seminar presentation marks. The combined module results count 75% and the research project counts 25% of the degree as a whole. Students must pass the project component in order to qualify. These component parts of the course will be combined in a final overall mark which will be reflected against the course code EGS4004W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code EGS4004W will not carry a NQF credit value, students will be concurrently registered for EGS4054W (coursework component of 120 NQF credits) and EGS4055W (research project of 40 NQF credits). Entrance is limited to 30 students	EGS4004W	EGS	W	EGS	W
MIT: HUMAN COMPUTER INTERACTION	12	9	To be advised	Admission into the Master's degree specialising in IT, or permission from the course convenor.	\N	\N	Introduction to the discipline of human-computer interaction. This module covers how knowledge from fields such as psychology and graphic design can be used to increase the usability of computer software.	\N	40% for assignment component.	Final examination: 50%; Practical assignments: 50%. A sub-minimum of 40% will be required for each of the assignment and exam components of the course.	\N	CSC5012Z	CSC	Z	CSC	Z
INTRODUCTION TO CLIMATE CHANGE & SUSTAINABLE DEVELOPMENT	30	8	Dr M Norton	Acceptance for EGS Honours and by agreement of the course convenor.	\N	\N	This course provides a broad, integrated, knowledge on key issues in climate change and sustainable development, making students conversant across the spectrum of climate change issues and history. Topics covered include: sustainable development; the climate system, anthropogenic forcing and climate system response; African climate variability and change; international climate change legal frameworks, negotiations, and politics; the economics of climate change and climate change financing; the concept of climate compatible development. The course is lecture, seminar and group- work based. Each section of the course will involve basic framing lectures, supported by either an essay exercise or a group work exercise and seminar.	\N	80% of classes, and all assignments.	Coursework 75%; examination 25%	\N	EGS4031F	EGS	F	EGS	F
INTRODUCTION TO CLIMATE CHANGE & SUSTAINABLE DEVELOPMENT	30	8	Dr M Norton	Acceptance for EGS Honours and by agreement of the course convenor.	\N	\N	This course provides a broad, integrated, knowledge on key issues in climate change and sustainable development, making students conversant across the spectrum of climate change issues and history. Topics covered include: sustainable development; the climate system, anthropogenic forcing and climate system response; African climate variability and change; international climate change legal frameworks, negotiations, and politics; the economics of climate change and climate change financing; the concept of climate compatible development. The course is lecture, seminar and group- work based. Each section of the course will involve basic framing lectures, supported by either an essay exercise or a group work exercise and seminar.	\N	80% of classes, and all assignments.	Coursework 75%; examination 25%	\N	EGS4031S	EGS	S	EGS	S
CLIMATE CHANGE ADAPTATION & MITIGATION	30	8	Drs M Norton and D Sparks	Acceptance for EGS Honours and by agreement of the course convenor.	\N	\N	This course provides in depth coverage of (i) adaptation and (ii) mitigation from both a theoretical and practical/applied point of view. Adaptation and mitigation are the two key domains of academic and applied learning required for students to be qualified to undertake research and be employable in the climate change arena in the South African and developing country context. The issues are explored from a developing country, climate compatible perspective.	\N	80% of classes and all assignments	Coursework 80%; examination 20%	\N	EGS4032F	EGS	F	EGS	F
CLIMATE CHANGE ADAPTATION & MITIGATION	30	8	Drs M Norton and D Sparks	Acceptance for EGS Honours and by agreement of the course convenor.	\N	\N	This course provides in depth coverage of (i) adaptation and (ii) mitigation from both a theoretical and practical/applied point of view. Adaptation and mitigation are the two key domains of academic and applied learning required for students to be qualified to undertake research and be employable in the climate change arena in the South African and developing country context. The issues are explored from a developing country, climate compatible perspective.	\N	80% of classes and all assignments	Coursework 80%; examination 20%	\N	EGS4032S	EGS	S	EGS	S
INTERROGATING SOUTHERN AFRICAN LANDSCAPES	30	8	Associate Professor S Daya	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	South African landscapes have always been contested. In the contemporary moment of global environmental crisis and deepening social inequality, it is critical that we build an interdisciplinary understanding of the histories, legacies and transformations playing out in particular places. Geography and allied disciplines offer many different ways of studying how the ecological and the cultural intertwine in shaping our landscapes. In this course, through foundational theoretical engagements and field-based activities, we explore some of the cross-cutting social, political, economic, ecological and biophysical dynamics playing out in the context of the rapidly changing Southern African region.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	NB: enrolment to this course is by invitation only	EGS4034F	EGS	F	EGS	F
INTERROGATING SOUTHERN AFRICAN LANDSCAPES	30	8	Associate Professor S Daya	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	South African landscapes have always been contested. In the contemporary moment of global environmental crisis and deepening social inequality, it is critical that we build an interdisciplinary understanding of the histories, legacies and transformations playing out in particular places. Geography and allied disciplines offer many different ways of studying how the ecological and the cultural intertwine in shaping our landscapes. In this course, through foundational theoretical engagements and field-based activities, we explore some of the cross-cutting social, political, economic, ecological and biophysical dynamics playing out in the context of the rapidly changing Southern African region.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	NB: enrolment to this course is by invitation only	EGS4034S	EGS	S	EGS	S
CLIMATE CHANGE AND PREDICTABILITY	30	8	Professor B Hewitson	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course explores the theory of climate change, and then goes into the question of predictability, cross scale relationships and feedbacks in the climate system, the tools and techniques of prediction, and translation of predictions into the user community including impacts and vulnerability analyses and touching on the social dimension.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4038F	EGS	F	EGS	F
CLIMATE CHANGE AND PREDICTABILITY	30	8	Professor B Hewitson	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course explores the theory of climate change, and then goes into the question of predictability, cross scale relationships and feedbacks in the climate system, the tools and techniques of prediction, and translation of predictions into the user community including impacts and vulnerability analyses and touching on the social dimension.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4038S	EGS	S	EGS	S
2ND YEAR ELECTIVE NUMBER 1	18	1										ELEC2001	\N	\N	\N	\N
APPLIED MARINE BIOLOGY	50	9	Professor M Vichi and Dr L C Gammage	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	This course is a component of the Applied Ocean Sciences Master's coursework (refer to BIO5012W). Co-requisites are BIO5012W, BIO5013F, STA5014Z and minor dissertation code chosen from the ones listed in the BIO5012W handbook. Changes in the dissertation code are allowed according to the student background and prior to consultation with the course conveners.	\N	The course in Applied Marine Biology focuses on conservation, ecosystem-based management, sustainable utilization and alternative livelihoods such as aquaculture.	\N	\N	Every module is assessed independently either with a class test or individual project assignments. The syllabus and the relative weight for each module are described in a handbook that will be made available on the BIO5012W website (hosted by the Marine and Antarctic Research Centre for Innovation and Sustainability).	\N	BIO5014F	BIO	F	BIO	F
URBAN FOOD SECURITY	30	8	Associate Professor J Battersby	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Topics include an overview of poverty and urbanization in Southern Africa; urban food security, methods and issues; urban poverty and vulnerability debates; food security and health; managing urban food systems (ecological, regulatory and fiscal dynamics).	\N	At least 80% attendance record and submission of all assignments.	Assignments 75%; examination 25%.	\N	EGS4039F	EGS	F	EGS	F
URBAN FOOD SECURITY	30	8	Associate Professor J Battersby	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Topics include an overview of poverty and urbanization in Southern Africa; urban food security, methods and issues; urban poverty and vulnerability debates; food security and health; managing urban food systems (ecological, regulatory and fiscal dynamics).	\N	At least 80% attendance record and submission of all assignments.	Assignments 75%; examination 25%.	\N	EGS4039S	EGS	S	EGS	S
CLIMATE CHANGE ADAPTATION AND TRANSFORMATION	30	8	Professor G Ziervogel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The central question of this course is “Why does adaptation to climate change need to be understood from a social and governance perspective?” Climate change adaptation will be explored as a means for responding to global environmental change, at the local, national and international scale and from the perspective of individuals, organisations and government. Coming out of the course you will understand the complexity of adaptation and the relationship between reducing climate risk and broader socio-economic issues, how to position adaptation to climate change in the development context and as a means of transformation. Through the course you will develop skills to critically assess adaptation responses in terms of potential contributions and challenges and identify how the social and governance aspects of adaptation could be strengthened.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4043F	EGS	F	EGS	F
CLIMATE CHANGE ADAPTATION AND TRANSFORMATION	30	8	Professor G Ziervogel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The central question of this course is “Why does adaptation to climate change need to be understood from a social and governance perspective?” Climate change adaptation will be explored as a means for responding to global environmental change, at the local, national and international scale and from the perspective of individuals, organisations and government. Coming out of the course you will understand the complexity of adaptation and the relationship between reducing climate risk and broader socio-economic issues, how to position adaptation to climate change in the development context and as a means of transformation. Through the course you will develop skills to critically assess adaptation responses in terms of potential contributions and challenges and identify how the social and governance aspects of adaptation could be strengthened.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4043S	EGS	S	EGS	S
GEOMORPHOLOGY	30	8	Professor F Eckardt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of this course is to introduce students to the theory of geomorphological systems and apply this to an area or topic of their choice. The course is particularly targeted at Honours students who have selected physical geography topics for their dissertation. It gives them the opportunity to deepen some of their geomorphological literature relevant to their chosen project. Students are expected to interpret landscapes, identify formative processes and events, examine environmental changes at different spatial and temporal scales, place their area of study into the geological, Quaternary, climatic and applied context in order to appreciate geomorphologic concepts such as systems approach, complexity, relationships, feedbacks, thresholds, equilibrium and cycles.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS4045F	EGS	F	EGS	F
GEOMORPHOLOGY	30	8	Professor F Eckardt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of this course is to introduce students to the theory of geomorphological systems and apply this to an area or topic of their choice. The course is particularly targeted at Honours students who have selected physical geography topics for their dissertation. It gives them the opportunity to deepen some of their geomorphological literature relevant to their chosen project. Students are expected to interpret landscapes, identify formative processes and events, examine environmental changes at different spatial and temporal scales, place their area of study into the geological, Quaternary, climatic and applied context in order to appreciate geomorphologic concepts such as systems approach, complexity, relationships, feedbacks, thresholds, equilibrium and cycles.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS4045S	EGS	S	EGS	S
WATER RESOURCE MANAGEMENT	30	8	Dr D Kibirige	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of the module is to develop a comprehensive understanding of issues and challenges in water resources management at both an urban and catchment scale, and with a primary focus on the South African context. The various themes in this module will present a fascinating interplay of tensions and challenges that play out in geographical space and over time, and will involve the consideration of factors such as the increasing demand that society places on scarce water resources; on efforts to meet the basic social need for clean, potable water; on the consequences of interventions and institutional arrangements involved in water governance; and on the role of the private sector in managing water risk in a particular catchment. The module also emphasises the value of an integrated understanding of theories and practices in water resources management and it does so by exploring the perspectives and approaches of sustainability science. Key themes in the module include water quality, monitoring and compliance; new directions in water research in South Africa; a consideration of biological treatment of water; participation in water governance; and how corporate enterprises are becoming leaders in water stewardship, shared water risk and value creation. These and other themes will be discussed in interactive seminar sessions. The course includes a three-week directed reading period, as well as a 4-day field camp.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS4046F	EGS	F	EGS	F
WATER RESOURCE MANAGEMENT	30	8	Dr D Kibirige	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of the module is to develop a comprehensive understanding of issues and challenges in water resources management at both an urban and catchment scale, and with a primary focus on the South African context. The various themes in this module will present a fascinating interplay of tensions and challenges that play out in geographical space and over time, and will involve the consideration of factors such as the increasing demand that society places on scarce water resources; on efforts to meet the basic social need for clean, potable water; on the consequences of interventions and institutional arrangements involved in water governance; and on the role of the private sector in managing water risk in a particular catchment. The module also emphasises the value of an integrated understanding of theories and practices in water resources management and it does so by exploring the perspectives and approaches of sustainability science. Key themes in the module include water quality, monitoring and compliance; new directions in water research in South Africa; a consideration of biological treatment of water; participation in water governance; and how corporate enterprises are becoming leaders in water stewardship, shared water risk and value creation. These and other themes will be discussed in interactive seminar sessions. The course includes a three-week directed reading period, as well as a 4-day field camp.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS4046S	EGS	S	EGS	S
POLICY AND GOVERNANCE	30	8	Associate Professor Z Patel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course looks at the underlying dynamics involved in the negotiation of environmental policy and its implementation. The assumption here is that unsustainable outcomes are not a result of a lack of will or intention, but rather due to vastly varying values, knowledge and data that are brought to bear on decision making for the environment. The approach of this course is to challenge the ‘cultural embeddedness’ of policy i.e. it critiques the cultural processes underlying environmental policy. A deeper understanding of the cultural politics of environmental policy and practice will deal with the processes through which institutions define and mediate policy outcomes; governance arrangements for sustainable development; the roles of power, rationality, knowledge and values in achieving environmental and social justice.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4047F	EGS	F	EGS	F
POLICY AND GOVERNANCE	30	8	Associate Professor Z Patel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course looks at the underlying dynamics involved in the negotiation of environmental policy and its implementation. The assumption here is that unsustainable outcomes are not a result of a lack of will or intention, but rather due to vastly varying values, knowledge and data that are brought to bear on decision making for the environment. The approach of this course is to challenge the ‘cultural embeddedness’ of policy i.e. it critiques the cultural processes underlying environmental policy. A deeper understanding of the cultural politics of environmental policy and practice will deal with the processes through which institutions define and mediate policy outcomes; governance arrangements for sustainable development; the roles of power, rationality, knowledge and values in achieving environmental and social justice.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4047S	EGS	S	EGS	S
URBAN POLITICAL ECOLOGY	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores urbanisation dynamics with a particular interest in examining the role of political economic shifts, history, discourse, and new forms of techno-management in shaping the contemporary urban environment. It does this through drawing on urban political ecology as an interdisciplinary field of study that provides insights into the power relations underlying unequal access to urban space, resources and infrastructure. Situated in this rapidly evolving field of Urban Studies, the course aims to open up conversations about the dynamics underlying unequal access to cities as well as the possibilities that could support more just and equitable cities. Students will be expected to read set texts, both empirical and theoretical, in preparation for classes, which take the form of weekly, student-led seminars.	\N	At least 80% attendance record and submission of all assignments.	Assignments 70%; examination 30%.	\N	EGS4057F	EGS	F	EGS	F
URBAN POLITICAL ECOLOGY	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores urbanisation dynamics with a particular interest in examining the role of political economic shifts, history, discourse, and new forms of techno-management in shaping the contemporary urban environment. It does this through drawing on urban political ecology as an interdisciplinary field of study that provides insights into the power relations underlying unequal access to urban space, resources and infrastructure. Situated in this rapidly evolving field of Urban Studies, the course aims to open up conversations about the dynamics underlying unequal access to cities as well as the possibilities that could support more just and equitable cities. Students will be expected to read set texts, both empirical and theoretical, in preparation for classes, which take the form of weekly, student-led seminars.	\N	At least 80% attendance record and submission of all assignments.	Assignments 70%; examination 30%.	\N	EGS4057S	EGS	S	EGS	S
APPLIED STATISTICS	24	6	N Watson	A pass in STA1000F/S/P/L or STA1006S or STA1106H or STA1100S or STA1007S or STA1008F/S and MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1010F/S or MAM1020F/S or MAM1110F/H or MAM1005H.	\N	\N	This course is designed to extend the student’s basic knowledge, acquired in STA1000F/S/P/L. The emphasis of the course is on applying statistical methods and modelling techniques to data rather than focusing on the mathematical rigour underpinning these methods. Topics covered include: Analysis of variance and experimental design; revision and extension of simple linear regression; multiple regression; logistic regression; time series analysis; and non-parametric statistics. Students will analyse data using R.	Monday - Thursday, 7th period	Satisfactory attendance of lectures, lab practicals and tests and completion of weekly quizzes and lab practicals as set out in course outline. Class record of at least 35% and at least 35% for Practical test.	Class record 40% and a 3-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2020S	STA	S	STA	S
CRITICAL PERSPECTIVES ON THE BIO-ECONOMY	30	8	Professor R Wynberg	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Located at the interface of fast-changing genetic and information technologies, and the juncture of a range of social, environmental and ethical concerns, the so-called bio-economy has changed ways in which biodiversity is used, conserved and commercialised. Although often touted as a panacea for energy crises, livelihoods, environmental remediation and food security, critical questions have been raised about who stands to benefit, the involvement of local communities, and economic and political drivers behind the bio-economy "push". Using a political ecology framing, this interdisciplinary course aims to introduce key theories that situate the bio-economy and to deepen understandings about the nature of emerging debates. These range from contestations about genetically modified crops, and 'biopiracy' charges of patenting biodiversity and traditional knowledge, through to the potential of agroecology as a sustainable agricultural future. The course aims to deepen critical thinking around these questions, and to inspire a scholarship that explores possibilities for socially just and environmentally sustainable approaches, with a particular focus on the Global South. The course involves both theory and practice, drawing on research mostly from Sub-Saharan Africa. Students will be expected to read set texts, to watch set videos, and to prepare seminars. The course includes several short fieldtrips. For more information see bio- economy.org.za.	\N	At least 80% attendance and submission of all assignments	1 exam - 40%, 1 essay (3000-4000 words) - 30%, 1 seminar presentation - 15%, 1 critique (response to a particular article, policy or media piece) - 15%.	\N	EGS4058F	EGS	F	EGS	F
AIR QUALITY MONITORING, MANAGEMENT AND PREDICTION	30	8	Dr J von Holdt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Compromised air quality is a major environmental concern, especially in urban environments and even more so in cities in developing parts of the world. This course explores the current state of global air quality but with a focus on examples and case studies from the global south, particularly Africa. We will investigate the factors and role players that have an influence on air quality, the distribution of polluted versus clean air and the impacts on people and the environment. This module will look at the different scales at which people are exposed to poor air quality and the data and tools we use to study and monitor the atmosphere at these different scales and explore the potential for locally developed interventions and solutions. We will also look at air quality management and how the current socio-economic situation is reflected in this space with specific reference to South and southern Africa. Students will be expected to identify an air quality issue of their choice, find and interpret relevant literature, appropriate datasets and methods and produce results which will culminate in a short research report with recommendations for interventions that can potentially result in improvements in the air quality at receptor sites.	\N	At least 80% class attendance and 40% minimum in assignments.	Assignments 60%; Examination 40%	\N	EGS4067F	EGS	F	EGS	F
CRITICAL PERSPECTIVES ON THE BIO-ECONOMY	30	8	Professor R Wynberg	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Located at the interface of fast-changing genetic and information technologies, and the juncture of a range of social, environmental and ethical concerns, the so-called bio-economy has changed ways in which biodiversity is used, conserved and commercialised. Although often touted as a panacea for energy crises, livelihoods, environmental remediation and food security, critical questions have been raised about who stands to benefit, the involvement of local communities, and economic and political drivers behind the bio-economy "push". Using a political ecology framing, this interdisciplinary course aims to introduce key theories that situate the bio-economy and to deepen understandings about the nature of emerging debates. These range from contestations about genetically modified crops, and 'biopiracy' charges of patenting biodiversity and traditional knowledge, through to the potential of agroecology as a sustainable agricultural future. The course aims to deepen critical thinking around these questions, and to inspire a scholarship that explores possibilities for socially just and environmentally sustainable approaches, with a particular focus on the Global South. The course involves both theory and practice, drawing on research mostly from Sub-Saharan Africa. Students will be expected to read set texts, to watch set videos, and to prepare seminars. The course includes several short fieldtrips. For more information see bio- economy.org.za.	\N	At least 80% attendance and submission of all assignments	1 exam - 40%, 1 essay (3000-4000 words) - 30%, 1 seminar presentation - 15%, 1 critique (response to a particular article, policy or media piece) - 15%.	\N	EGS4058S	EGS	S	EGS	S
ENVIRONMENTAL GOVERNANCE IN THE GLOBAL SOUTH	30	8	Dr P Mbatha	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course aims to introduce students to the theory and praxis of environmental governance relevant to global South contexts. It begins by outlining and discussing dominant historical and current environmental governance theories, models and approaches at the global level. The course then engages with various economic, political, historical, institutional and social drivers that influence environmental governance processes, practices and implementation, using the global South as a lens. It underlines symmetries and asymmetries of environmental governance by drawing on various natural resource use and governance sectors, i.e. biodiversity conservation, mining, forestry, tourism, etc. The course also engages the Sustainable Development Goals from a governance perspective, by critically analysing whether or not they can realistically be in conversation with and address issues relating to environmental governance practice in the global South.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4059F	EGS	F	EGS	F
ENVIRONMENTAL GOVERNANCE IN THE GLOBAL SOUTH	30	8	Dr P Mbatha	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course aims to introduce students to the theory and praxis of environmental governance relevant to global South contexts. It begins by outlining and discussing dominant historical and current environmental governance theories, models and approaches at the global level. The course then engages with various economic, political, historical, institutional and social drivers that influence environmental governance processes, practices and implementation, using the global South as a lens. It underlines symmetries and asymmetries of environmental governance by drawing on various natural resource use and governance sectors, i.e. biodiversity conservation, mining, forestry, tourism, etc. The course also engages the Sustainable Development Goals from a governance perspective, by critically analysing whether or not they can realistically be in conversation with and address issues relating to environmental governance practice in the global South.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS4059S	EGS	S	EGS	S
GEOGRAPHIES OF SEXUALITIES: IDENTITY, PLACE, & HEALTH.	30	8	Professor A Tucker	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores and critically engages with geographical research related to sexuality, with a particular focus on the interrelationships between identity, place and health. The course explores how geographical thinking on sexuality – and in particular on Lesbian, Gay, Bisexual, and Trans (LGBT) groups – has evolved over time, and the key relationships that have emerged between the study of sexuality and the study of health needs and inequalities. Starting with an exploration of the historical roots of the geographies of sexualities literature the course will go on to explore the connections such work has had with wider post-structuralist queer theories, globalization debates, and research on sexualities drawn from sub-Saharan Africa. The course will then situate such work in relation to the development of work on HIV/ AIDS prevention, treatment and care, by considering how sexualities have been variously framed, and the at times limited conceptual space for an appreciation of diverse sexual identities. The course then draws together these various strands to consider the options and possibilities for current HIV programming in Cape Town for LGBT groups together with a critical examination of the epidemiological logics and conceptual challenges of the public health deployment of ‘men who have sex with men’(MSM).	\N	Class attendance (80%) and submissions of all assignments.	1 essay (4000-4500 words) – 35%, 1 seminar presentation – 5%, 1 24hr take-home exam – 60%.	\N	EGS4066F	EGS	F	EGS	F
GEOGRAPHIES OF SEXUALITIES: IDENTITY, PLACE, & HEALTH.	30	8	Professor A Tucker	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores and critically engages with geographical research related to sexuality, with a particular focus on the interrelationships between identity, place and health. The course explores how geographical thinking on sexuality – and in particular on Lesbian, Gay, Bisexual, and Trans (LGBT) groups – has evolved over time, and the key relationships that have emerged between the study of sexuality and the study of health needs and inequalities. Starting with an exploration of the historical roots of the geographies of sexualities literature the course will go on to explore the connections such work has had with wider post-structuralist queer theories, globalization debates, and research on sexualities drawn from sub-Saharan Africa. The course will then situate such work in relation to the development of work on HIV/ AIDS prevention, treatment and care, by considering how sexualities have been variously framed, and the at times limited conceptual space for an appreciation of diverse sexual identities. The course then draws together these various strands to consider the options and possibilities for current HIV programming in Cape Town for LGBT groups together with a critical examination of the epidemiological logics and conceptual challenges of the public health deployment of ‘men who have sex with men’(MSM).	\N	Class attendance (80%) and submissions of all assignments.	1 essay (4000-4500 words) – 35%, 1 seminar presentation – 5%, 1 24hr take-home exam – 60%.	\N	EGS4066S	EGS	S	EGS	S
AIR QUALITY MONITORING, MANAGEMENT AND PREDICTION	30	8	Dr J von Holdt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Compromised air quality is a major environmental concern, especially in urban environments and even more so in cities in developing parts of the world. This course explores the current state of global air quality but with a focus on examples and case studies from the global south, particularly Africa. We will investigate the factors and role players that have an influence on air quality, the distribution of polluted versus clean air and the impacts on people and the environment. This module will look at the different scales at which people are exposed to poor air quality and the data and tools we use to study and monitor the atmosphere at these different scales and explore the potential for locally developed interventions and solutions. We will also look at air quality management and how the current socio-economic situation is reflected in this space with specific reference to South and southern Africa. Students will be expected to identify an air quality issue of their choice, find and interpret relevant literature, appropriate datasets and methods and produce results which will culminate in a short research report with recommendations for interventions that can potentially result in improvements in the air quality at receptor sites.	\N	At least 80% class attendance and 40% minimum in assignments.	Assignments 60%; Examination 40%	\N	EGS4067S	EGS	S	EGS	S
DISASTER RISK SCIENCE	30	8	Dr P Sabela-Rikhotso	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The severity and frequency of disastrous events has been in the rise for the past two decades. In the South African context however, declaration of the state of disaster has become a bone of contention in its ability to encourage disaster risk reduction. A myriad of stereotypes and bad publicity has been built around the roles, responsibilities, and authority of government to efficiently manage disasters. Through a transdisciplinary lens, this course aims to explore broad concepts, legislative and policy framework, practical applications, tools, and skills influencing disaster risk science. The course begins by exploring different scholarly arguments about the unnatural state of natural disasters. It will further investigate theoretical models and case studies which will underscore the fundamentals of disaster impact minimisation. The course will interrogate various ways in which humans, through environmental and socio-economic factors drive vulnerability and subsequently create disaster risk.	\N	At least 80% attendance and submission of all assignments.	Assignments 50%, Final exam 50%	\N	EGS4068F	EGS	F	EGS	F
DISASTER RISK SCIENCE	30	8	Dr P Sabela-Rikhotso	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The severity and frequency of disastrous events has been in the rise for the past two decades. In the South African context however, declaration of the state of disaster has become a bone of contention in its ability to encourage disaster risk reduction. A myriad of stereotypes and bad publicity has been built around the roles, responsibilities, and authority of government to efficiently manage disasters. Through a transdisciplinary lens, this course aims to explore broad concepts, legislative and policy framework, practical applications, tools, and skills influencing disaster risk science. The course begins by exploring different scholarly arguments about the unnatural state of natural disasters. It will further investigate theoretical models and case studies which will underscore the fundamentals of disaster impact minimisation. The course will interrogate various ways in which humans, through environmental and socio-economic factors drive vulnerability and subsequently create disaster risk.	\N	At least 80% attendance and submission of all assignments.	Assignments 50%, Final exam 50%	\N	EGS4068S	EGS	S	EGS	S
ENVIRONMENTAL & GEOGRAPHICAL SCIENCE DISSERTATION	180	9	Dr S Scheba	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	EGS5000W	EGS	W	EGS	W
ENVIRONMENTAL & GEOGRAPHICAL SCIENCE DISSERTATION	180	9	Dr S Scheba	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found in the front of the handbook.	\N	\N	\N	\N	EGS5003W	EGS	W	EGS	W
CLIMATE MODELLING	23	9	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	An introduction into the development and application of climate models for exploring climate dynamics, forecasting, and climate change. The course explores the inner working of climate models, the use in operational seasonal forecasting in Africa (with hands on work with the current forecasts), and actual running model experiments. Students are expected to have done EGS3012S or its equivalent. At the NQF level 9 students will do an additional grand challenge submission for their portfolio which will entail the development of an independent research question, aim and methods, and the application of these methods in carrying out the research.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5030F	EGS	F	EGS	F
CLIMATE MODELLING	23	9	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	An introduction into the development and application of climate models for exploring climate dynamics, forecasting, and climate change. The course explores the inner working of climate models, the use in operational seasonal forecasting in Africa (with hands on work with the current forecasts), and actual running model experiments. Students are expected to have done EGS3012S or its equivalent. At the NQF level 9 students will do an additional grand challenge submission for their portfolio which will entail the development of an independent research question, aim and methods, and the application of these methods in carrying out the research.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5030S	EGS	S	EGS	S
ENVIRONMENT, SOCIETY & SUSTAINABILITY COURSEWORK	90	9	Dr M Norton	An Honours degree (or equivalent). In special circumstances graduates who have shown by examination, or publication, or a record of appropriate training, that they have reached a level equivalent to an Honours degree may be considered. Since there is a limit of 12 places in this course, admission is competitive. Selection will be at the discretion of the Head of the Department, based on quality of qualification, experiential learning and/or referee reports. For further details refer to the departmental website - see www.egs.uct.ac.za.	\N	\N	This interdisciplinary course is designed for students with diverse backgrounds who have an interest in the issues pertaining to the environment, society and sustainability. This course contributes half of the total credits for a Master’s qualification which can be awarded as an MSc or MPhil, depending on the academic background of the student. The coursework component starts with registration in February. Students select four coursework modules in, for example, Theory & Practice of Environmental Management, Capital Politics & Nature, Geography of Development & Environment, Living with Environmental Change, Urban Food Security, Cultural Geographies, Managing Complex Human-Ecological Systems, or Geomorphology. Upon successful completion of the coursework component, students will be required to register for the minor dissertation component (EGS5009W) in the following year.	\N	\N	Assessment for the coursework modules includes both written examinations and coursework assignments such as essays, projects, practical assignments, etc. Examinations on average count 50% and coursework 50% for each module. The combined module results will be reflected as a final coursework result.	Entrance is limited to 12 students	EGS5008H	EGS	H	EGS	H
ENVIRONMENT, SOCIETY & SUSTAINABILITY MINOR DISSERTATION	90	9	Dr M Norton	EGS5008H	\N	\N	Students will be required to register for this course in the first semester of the second year and complete a suitable research proposal in consultation with an appropriate supervisor. After approval of the proposal in the first year of registration, students will undertake a research project demonstrating the application of theory to practical issues in the research area of environment, society and sustainability. The work must be submitted in the form of a minor dissertation early in the second year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	EGS5009W	EGS	W	EGS	W
OPERATIONAL RESEARCH TECHNIQUES	36	7	Dr R G Rakotonirainy	STA2030S or STA2005S; STA3030F is recommended	\N	\N	This course forms part of the third-year major in Applied Statistics. It is an introduction to the study of Operational Research (OR) and explores fundamental quantitative techniques in the OR armamentarium with a strong focus on computer-based application. The course is intended for students in the applied statistics stream but may be taken as an elective by students in the mathematical statistics stream. Topics covered include linear and non-linear programming where students will learn to find optimal solutions by characterising problems in terms of objectives, decision variables and constraints, decision making under uncertainty through decision trees, decision rules and scenario planning, Queueing Theory simulation through modelling the operation of real world systems as they evolve over time.	Monday - Thursday, 3rd period	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	\N	STA3036S	STA	S	STA	S
APPLIED MATHEMATICS THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the general rules for the PhD as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	MAM6001W	MAM	W	MAM	W
CLIMATE CHANGE AND PREDICTABILITY COURSEWORK	0	9	Dr M Norton	A relevant Honours degree (or equivalent). Students with backgrounds in scientific, planning, engineering, economic, educational, social and legal disciplines are encouraged to apply.	\N	\N	This full-time taught Master’s course (MSc or MPhil) is offered over 13 months, beginning in January. It provides interdisciplinary training in climate change and sustainable development, with a focus on the issues of relevance to African development. The course is designed for both recent graduates as well as those with several years’ experience and who wish to gain a broad understanding of the issues involved in climate change and sustainable development from an African and developing world perspective. The curriculum comprises two compulsory core courses, EGS5031F: Introduction to Climate Change & Sustainable Development and EGS5032F/S: Climate Change Adaptation & Mitigation (details of these courses are presented later in this section). In addition, students will choose at least two elective courses, chosen from a range of courses which offer the student the opportunity to explore new areas, or look at climate and development through existing disciplinary backgrounds. A partial list and details of these courses are available from the ACDI handbook.	\N	\N	To qualify for the Master’s degree, students must pass all coursework with a subminimum of 33% for each core or elective course module; an aggregate coursework mark of 50% is required. A composite grade of the performance on the coursework component as a whole will be reflected against the assessment course EGS5012W. The choice of project for the minor dissertation will be determined by prior qualification. Students may register for a minor dissertation in a range of Departments across the University, including Biological Sciences, Environmental & Geographical Science, Geological Sciences, Chemical Engineering, Mechanical Engineering, Economics, Sociology, Law [Refer to relevant Faculty Handbooks]. Minor Dissertation options in the Science Faculty.	This course is convened by UCT’s African Climate & Development Initiative; refer to the section “Inter-faculty Units” later in this handbook. The code EGS5012W represents the overall coursework component; the overall coursework result will be reflected against this code. There are a range of possible minor dissertation codes, depending on the discipline in which the student chooses to register for the research component.	EGS5012W	EGS	W	EGS	W
RESEARCH METHODS FOR NATURAL SCIENTISTS	23	9	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course has a dual purpose. Firstly, a series of weekly lectures and hands-on practical seminars on the nuts and bolts of quantitative analysis. The analysis techniques investigated are (mostly) the fundamental methods found commonly in the literature; viz: Classification, time series analysis, EOF/PCA, non-linear analysis. In parallel to this are a series of seminars on “the Philosophy of Science” addressing issues of values, perception, the science community, etc. At the NQF level 9 students will do an additional grand challenge submission for their portfolio which will entail the development of an independent research question, aim and methods, and the application of these methods in carrying out the research.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5023F	EGS	F	EGS	F
STATISTICAL THEORY	24	6	M Ngwenya	At least 45% for STA2020F/S or STA2007F/S/H or STA2005S.	Concurrent registration for MAM1032S or MAM1034S or MAM1012S or MAM1021F/S. Note: A student may not register concurrently for STA2030S and MAM1006H.	\N	This course introduces students to Statistical Theory and Inference. It explores aspects of probability theory that are particularly relevant to statistics, including the notions of random variables, joint probability distributions, expected values and moment generating functions. The course content includes univariate distributions and moments of univariate distributions, moments of bivariate distributions, distributions of sample statistics and parameter estimation and inference.	Monday - Thursday, 1st period	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline. Third-Year Courses	A student cannot obtain credits for both STA2004F and STA2030S. A student may not register concurrently for STA2030S and MAM1006H. Course outline: This course introduces students to Statistical Theory and Inference. It explores aspects of probability theory that are particularly relevant to statistics, including the notions of random variables, joint probability distributions, expected values and moment generating functions. The course content includes univariate distributions and moments of univariate distributions, moments of bivariate distributions, distributions of sample statistics and parameter estimation and inference. Lecture times: Monday - Thursday, 1st period DP requirements: Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%. Assessment: Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline. Third-Year Courses	STA2030S	STA	S	STA	S
RESEARCH METHODS FOR NATURAL SCIENTISTS	23	9	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course has a dual purpose. Firstly, a series of weekly lectures and hands-on practical seminars on the nuts and bolts of quantitative analysis. The analysis techniques investigated are (mostly) the fundamental methods found commonly in the literature; viz: Classification, time series analysis, EOF/PCA, non-linear analysis. In parallel to this are a series of seminars on “the Philosophy of Science” addressing issues of values, perception, the science community, etc. At the NQF level 9 students will do an additional grand challenge submission for their portfolio which will entail the development of an independent research question, aim and methods, and the application of these methods in carrying out the research.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5023S	EGS	S	EGS	S
SENIOR RESEARCH PROJECT IN ENVIRONMENTAL & GEOGRAPHICAL STUDIES (MA)	90	9	Dr M Norton	\N	\N	\N	The minor dissertation is based on a three- to six-month supervised research project, to be submitted at the end of January, with the possibility of extension to June the following year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	EGS5023H	EGS	H	EGS	H
ETHICS	18	5	O Mogomotsi	None	\N	\N	This course introduces students to moral philosophy and to the questions it asks. These may include: What makes an action right? Is morality relative (to one's own views or to one's culture) or is it objective? What is the relationship between religion and ethics? What is it to be a good person?	Monday, Tuesday, Wednesday, 5th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in October/November counts 60%.	This course may also be offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI1010S	PHI	S	PHI	S
EVIDENCE-BASED MANAGEMENT	18	5	J Rousseau	Admission as First Year Faculty of Commerce students, or by permission of Head of the School.			This course equips students with crucial intellectual resources for facing the challenges presented by a globalised knowledge-dependent economy. Its focus is on developing critical reasoning skills, in particular competence at, and confidence in, assessing the quality of available evidence; distinguishing disinformation from misinformation, and understanding the influence of social media on shaping judgments and decision-making. Students will learn how to use evidence and sound argumentation to reach well-justified conclusions, and to then efficiently and persuasively communicate those conclusions to relevant stakeholders. Practically, the course uses case studies of contemporary debates on social and traditional media to emphasise the importance of understanding commercial activity as occurring within particular social and political environments, and on how those environments can affect our ability to make rational decisions.		Submission of all coursework assignments. Achieving a weighted average of at least 40%.	Coursework 75%; Capstone assessment 25%. A sub-minimum of 45% must be achieved in the capstone assessment.	First year status, first or second semester, (depending on degree stream).	BUS1036S	BUS	S	BUS	S
INTRODUCTION TO CLIMATE CHANGE & SUSTAINABLE DEVELOPMENT	23	9	Dr M Norton	Acceptance for EGS5012W and by agreement of the course convenor.	\N	\N	This course provides a broad, integrated, knowledge on key issues in climate change and sustainable development, making students conversant across the spectrum of climate change issues and history. Topics covered include: sustainable development; the climate system, anthropogenic forcing and climate system response; African climate variability and change; international climate change legal frameworks, negotiations, and politics; the economics of climate change and climate change financing; the concept of climate compatible development. The course is lecture, seminar and group- work based. Each section of the course will involve basic framing lectures, supported by either an essay exercise or a group work exercise and seminar.	\N	\N	Coursework 75%; Examination 25%	\N	EGS5031F	EGS	F	EGS	F
CLIMATE CHANGE ADAPTATION & MITIGATION	23	9	Dr M Norton	Acceptance for EGS5012W and by agreement of the course convenor.	\N	\N	This course provides in depth coverage of (i) adaptation and (ii) mitigation from both a theoretical and practical/applied point of view. Adaptation and mitigation are the two key domains of academic and applied learning required for students to be qualified to undertake research and be employable in the climate change arena in the South African and developing country context. The issues are explored from a developing country, climate compatible perspective.	\N	\N	Coursework 80%; Examination 20%.	This course will run in the second semester in 2025.	EGS5032F	EGS	F	EGS	F
CLIMATE CHANGE ADAPTATION & MITIGATION	23	9	Dr M Norton	Acceptance for EGS5012W and by agreement of the course convenor.	\N	\N	This course provides in depth coverage of (i) adaptation and (ii) mitigation from both a theoretical and practical/applied point of view. Adaptation and mitigation are the two key domains of academic and applied learning required for students to be qualified to undertake research and be employable in the climate change arena in the South African and developing country context. The issues are explored from a developing country, climate compatible perspective.	\N	\N	Coursework 80%; Examination 20%.	This course will run in the second semester in 2025.	EGS5032S	EGS	S	EGS	S
CLIMATE CHANGE & PREDICTABILITY	23	9	Professor B Hewitson	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course explores the theory of climate change, and then goes into the question of predictability, cross scale relationships and feedbacks in the climate system, the tools and techniques of prediction, and translation of predictions into the user community including impacts and vulnerability analyses and touching on the social dimension. At the NQF 9 level students will be expected to compose reports with a higher word count, at a higher intellectual level and with an expectation of a more comprehensive understanding of the pertinent literature. Students at this level will be expected to display a greater commitment and engagement in the oral components of the course.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5038F	EGS	F	EGS	F
DYNAMICS	18	5	To be advised	\N	MAM1031F and MAM1032S or equivalent	\N	The aim of this course is to introduce the elements of mechanics. Topics covered include: Kinematics in three dimensions. Newton's laws of motion, models of forces (friction, elastic springs, fluid resistance). Conservation of energy and momentum. Simple systems of particles, including brief introduction to rigid systems. Orbital Mechanics with applications to the planning of space missions to the outer planets.	First semester: 2nd period Tuesday, Thursday. Second semester: 2nd period Monday, Wednesday, Friday.	A class record of 30% or more.	Class record counts up to 40%. A project and one 2.5-hour examination written in October/November make up the balance.	This course can be taken in conjunction with MAM1043H as lectures are arranged so that this is possible.	MAM1044H	MAM	H	MAM	H
GEOLOGY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	GEO5000W	GEO	W	GEO	W
THEORIES OF JUSTICE & INEQUALITY MINOR DISSERTATION	90	9	Dr S Daya	\N	\N	\N	Students will complete a suitable research proposal in consultation with an appropriate supervisor. After approval of the proposal, students will undertake a research project critically interrogating established paradigms of understanding justice and inequality and/or demonstrating the application of theory to empirical issues related to justice and inequality.	\N	\N	By Faculty external examination process.	\N	EGS5064W	EGS	W	EGS	W
URBAN FOOD SECURITY	23	9	Associate Professor J Battersby	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Topics include an overview of poverty and urbanization in Southern Africa; urban food security, methods and issues; urban poverty and vulnerability debates; food security and health; managing urban food systems (ecological, regulatory and fiscal dynamics). At the NQF 9 level students will be expected to conduct a small piece of independent fieldwork which will inform their extended essay for the course. In this essay all students are expected to engage a current debate on food security or food systems studies. For students at the NQF 9 level they will use a real world case study to critically engage the theoretical literature. These students will be assessed on their ability to interpret the data and use data to critically engage theory.	\N	At least 80% attendance record and submission of all assignments.	Assignments 75%; examination 25%.	\N	EGS5039F	EGS	F	EGS	F
URBAN FOOD SECURITY	23	9	Associate Professor J Battersby	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Topics include an overview of poverty and urbanization in Southern Africa; urban food security, methods and issues; urban poverty and vulnerability debates; food security and health; managing urban food systems (ecological, regulatory and fiscal dynamics). At the NQF 9 level students will be expected to conduct a small piece of independent fieldwork which will inform their extended essay for the course. In this essay all students are expected to engage a current debate on food security or food systems studies. For students at the NQF 9 level they will use a real world case study to critically engage the theoretical literature. These students will be assessed on their ability to interpret the data and use data to critically engage theory.	\N	At least 80% attendance record and submission of all assignments.	Assignments 75%; examination 25%.	\N	EGS5039S	EGS	S	EGS	S
SPECIAL TOPIC IN HUMAN/ENVIRONMENT INTERACTIONS	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Human/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of human or environmental geography. The course will focus on using theory, but will encourage the use of case studies. Course outcomes will emphasize the development of conceptual and analytical skills. At the NQF 9 level there is a strong emphasis on the development of analytical skills and students are expected to apply these skills in the context of an appropriate theory, to a case study of their own specialist field of human or environmental geography.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5040F	EGS	F	EGS	F
ETHICS +	10	5	TBA	\N	\N	In these tutorials, students will receive explicit support around the co-requisite course assignments and detailed feedback on their written work.	The purpose of this course is to augment and support its co-requisite course: PHI1010S Ethics. It aims to improve students’ performance by enhancing their grasp of key ideas and concepts, and by developing their mastery of the disciplinary discourse. It provides additional pedagogic enrichment in the form of regular Plus Tuts that extend into Writing Hub exercises and consultations.	\N	100% tutorial attendance plus successful completion of all coursework assignments.	Coursework 100% comprising of tutorial assessments and other written work.	\N	PHI1011S	PHI	S	PHI	S
APPROACHES AND ISSUES IN PHYSICAL AND ENVIRONMENTAL SCIENCES	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Physical/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of physical or environmental geography. The course will cover theoretical, empirical and methodological concerns and will include a fieldwork component. NQF 9 level there is a strong emphasis on the development of analytical skills and students are expected to apply these skills in the context of an appropriate theory, to a case study of their own specialist field of physical geography.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5041S	EGS	S	EGS	S
GEOMORPHOLOGY	23	9	Professor F Eckardt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of this course is to introduce students to the theory of geomorphological systems and apply this to an area or topic of their choice. The course is particularly targeted at Honours students who have selected physical geography topics for their dissertation. It gives them the opportunity to deepen some of their geomorphological literature relevant to their chosen project. Students are expected to interpret landscapes, identify formative processes and events, examine environmental changes at different spatial and temporal scales, place their area of study into the geological, Quaternary, climatic and applied context in order to appreciate geomorphologic concepts such as systems approach, complexity, relationships, feedbacks, thresholds, equilibrium and cycles. At the NQF 9 level students will be expected to back their literature review with data analyses including climatic or hydrological in nature and may also consider the application of GIS data and use Remote Sensing. At the NQF 9 level converting and preparing elements of course content towards the use for a publication would be expected.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS5045F	EGS	F	EGS	F
GEOMORPHOLOGY	23	9	Professor F Eckardt	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of this course is to introduce students to the theory of geomorphological systems and apply this to an area or topic of their choice. The course is particularly targeted at Honours students who have selected physical geography topics for their dissertation. It gives them the opportunity to deepen some of their geomorphological literature relevant to their chosen project. Students are expected to interpret landscapes, identify formative processes and events, examine environmental changes at different spatial and temporal scales, place their area of study into the geological, Quaternary, climatic and applied context in order to appreciate geomorphologic concepts such as systems approach, complexity, relationships, feedbacks, thresholds, equilibrium and cycles. At the NQF 9 level students will be expected to back their literature review with data analyses including climatic or hydrological in nature and may also consider the application of GIS data and use Remote Sensing. At the NQF 9 level converting and preparing elements of course content towards the use for a publication would be expected.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS5045S	EGS	S	EGS	S
WATER RESOURCE MANAGEMENT	23	9	Dr D Kibirige	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of the module is to develop a comprehensive understanding of issues and challenges in water resources management at both an urban and catchment scale, and with a primary focus on the South African context. The various themes in this module will present a fascinating interplay of tensions and challenges that play out in geographical space and over time, and will involve the consideration of factors such as the increasing demand that society places on scarce water resources; on efforts to meet the basic social need for clean, potable water; on the consequences of interventions and institutional arrangements involved in water governance; and on the role of the private sector in managing water risk in a particular catchment. The module also emphasises the value of an integrated understanding of theories and practices in water resources management and it does so by exploring the perspectives and approaches of sustainability science. Key themes in the module include water quality, monitoring and compliance; new directions in water research in South Africa; a consideration of biological treatment of water; participation in water governance; and how corporate enterprises are becoming leaders in water stewardship, shared water risk and value creation. These and other themes will be discussed in interactive seminar sessions. The course includes a three- week directed reading period, as well as a 4-day field camp. At the NQF 9 level students are required to complete an additional assignment that comprises a literature review on a topic of their choice. Furthermore, students at this level are required to prepare, manage and lead a course discussion. NQF 9 level students will receive a separate exam paper to those at the NQF 8 level.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS5046F	EGS	F	EGS	F
WATER RESOURCE MANAGEMENT	23	9	Dr D Kibirige	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The aim of the module is to develop a comprehensive understanding of issues and challenges in water resources management at both an urban and catchment scale, and with a primary focus on the South African context. The various themes in this module will present a fascinating interplay of tensions and challenges that play out in geographical space and over time, and will involve the consideration of factors such as the increasing demand that society places on scarce water resources; on efforts to meet the basic social need for clean, potable water; on the consequences of interventions and institutional arrangements involved in water governance; and on the role of the private sector in managing water risk in a particular catchment. The module also emphasises the value of an integrated understanding of theories and practices in water resources management and it does so by exploring the perspectives and approaches of sustainability science. Key themes in the module include water quality, monitoring and compliance; new directions in water research in South Africa; a consideration of biological treatment of water; participation in water governance; and how corporate enterprises are becoming leaders in water stewardship, shared water risk and value creation. These and other themes will be discussed in interactive seminar sessions. The course includes a three- week directed reading period, as well as a 4-day field camp. At the NQF 9 level students are required to complete an additional assignment that comprises a literature review on a topic of their choice. Furthermore, students at this level are required to prepare, manage and lead a course discussion. NQF 9 level students will receive a separate exam paper to those at the NQF 8 level.	\N	At least 80% attendance record and submission of all assignments.	Assignments 50%; examination 50%.	\N	EGS5046S	EGS	S	EGS	S
APPLIED MULTIVARIATE DATA ANALYSIS	36	7	Dr S Er	STA2020F/S or STA2005S or STA2007F/S/H	\N	\N	The aim of the course is to create a practical working familiarity with the analysis of data, focusing on multivariate methods as applied in areas such as marketing, the social science and the sciences. Topics covered include item reliability analysis, multidimensional scaling, correspondence analysis, principal component and factor analysis, cluster analysis, discriminant analysis, classification trees and structural equation modelling.	Monday - Thursday, 4th period	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	\N	STA3022F	STA	F	STA	F
SPECIAL TOPIC IN HUMAN/ENVIRONMENT INTERACTIONS	30	8	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Human/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of human or environmental geography. The course will focus on using theory, but will encourage the use of case studies. Course outcomes will emphasize the development of conceptual and analytical skills.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework	\N	EGS4040S	EGS	S	EGS	S
ACCOUNTING FOR BUSINESS I	15	5	Magon Gajewski	Admission to degree. NSC level 5 in Mathematics and level 4 in English HL (or level 5 in English FAL).		This course aims to introduce non-accounting students to the basic principles of accounting that would benefit them in management and other roles.	Introductory course in financial and management accounting for non-accounting Commerce students.	4 lectures/week (12 weeks), 2 tutorials/week (11 weeks)	75% course participation and a minimum of 38% for the April test.	One class test in April. One final exam in the June exam block.		ACC1021F	ACC	F	ACC	F
ACCOUNTING FOR BUSINESS II	9	5	Magon Gajewski	ACC1021F	\N	This course continues from ACC1021F and introduces students to taxation and governance.	Covers cash flows, taxation, and governance principles for non-accounting students.	4 lectures/week (5 weeks), 2 tutorials/week (5 weeks)	75% course participation	One final exam before/after the September vacation.	\N	ACC1022Z	ACC	Z	ACC	Z
POLICY AND GOVERNANCE	23	9	Associate Professor Z Patel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course looks at the underlying dynamics involved in the negotiation of environmental policy and its implementation. The assumption here is that unsustainable outcomes are not a result of a lack of will or intention, but rather due to vastly varying values, knowledge and data that are brought to bear on decision making for the environment. The approach of this course is to challenge the ‘cultural embeddedness’ of policy i.e. it critiques the cultural processes underlying environmental policy. A deeper understanding of the cultural politics of environmental policy and practice will deal with the processes through which institutions define and mediate policy outcomes; governance arrangements for sustainable development; the roles of power, rationality, knowledge and values in achieving environmental and social justice. At the NQF 9 level students will be expected to apply theory to appropriate areas of application in the realm of urban environmental policy. Masters level students will be assigned two presentations and subsequent written submissions, with an emphasis on the application of theoretical considerations. The extended policy analysis assignment will contain additional analytical variables to ensure a higher level of analysis.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS5047F	EGS	F	EGS	F
POLICY AND GOVERNANCE	23	9	Associate Professor Z Patel	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course looks at the underlying dynamics involved in the negotiation of environmental policy and its implementation. The assumption here is that unsustainable outcomes are not a result of a lack of will or intention, but rather due to vastly varying values, knowledge and data that are brought to bear on decision making for the environment. The approach of this course is to challenge the ‘cultural embeddedness’ of policy i.e. it critiques the cultural processes underlying environmental policy. A deeper understanding of the cultural politics of environmental policy and practice will deal with the processes through which institutions define and mediate policy outcomes; governance arrangements for sustainable development; the roles of power, rationality, knowledge and values in achieving environmental and social justice. At the NQF 9 level students will be expected to apply theory to appropriate areas of application in the realm of urban environmental policy. Masters level students will be assigned two presentations and subsequent written submissions, with an emphasis on the application of theoretical considerations. The extended policy analysis assignment will contain additional analytical variables to ensure a higher level of analysis.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS5047S	EGS	S	EGS	S
APPLIED OCEAN SCIENCES MINOR DISSERTATION	90	9	Professor M Vichi	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	BIO5012W, BIO5013F, BIO5014F/SEA5011F	\N	The minor dissertation, which forms 50% of the overall degree, is based on a six-month supervised research project. The choice of project will be determined by the student's prior qualification and in agreement with the course conveners and supervisors. The dissertation should be submitted at the end of January, with the possibility of extension to June of the next year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	EGS5052W	EGS	W	EGS	W
URBAN POLITICAL ECOLOGY	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores urbanisation dynamics with a particular interest in examining the role of political economic shifts, history, discourse, and new forms of techno-management in shaping the contemporary urban environment. It does this through drawing on urban political ecology as an interdisciplinary field of study that provides insights into the power relations underlying unequal access to urban space, resources and infrastructure. Situated in this rapidly evolving field of Urban Studies, the course aims to open up conversations about the dynamics underlying unequal access to cities as well as the possibilities that could support more just and equitable cities. Students will be expected to read set texts, both empirical and theoretical, in preparation for classes, which take the form of weekly, student-led seminars.	\N	At least 80% attendance record and submission of all assignments.	Assignments 70%; examination 30%.	\N	EGS5057F	EGS	F	EGS	F
URBAN POLITICAL ECOLOGY	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores urbanisation dynamics with a particular interest in examining the role of political economic shifts, history, discourse, and new forms of techno-management in shaping the contemporary urban environment. It does this through drawing on urban political ecology as an interdisciplinary field of study that provides insights into the power relations underlying unequal access to urban space, resources and infrastructure. Situated in this rapidly evolving field of Urban Studies, the course aims to open up conversations about the dynamics underlying unequal access to cities as well as the possibilities that could support more just and equitable cities. Students will be expected to read set texts, both empirical and theoretical, in preparation for classes, which take the form of weekly, student-led seminars.	\N	At least 80% attendance record and submission of all assignments.	Assignments 70%; examination 30%.	\N	EGS5057S	EGS	S	EGS	S
CRITICAL PERSPECTIVES ON THE BIO-ECONOMY	23	9	Professor R Wynberg	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Located at the interface of fast-changing genetic and information technologies, and the juncture of a range of social, environmental and ethical concerns, the so-called bio-economy has changed fundamentally ways in which biodiversity is used, conserved and commercialised. Although often touted as a panacea for energy crises, livelihoods, environmental remediation and food security, critical questions have been raised about who stands to benefit, the involvement of local communities, and economic and political drivers behind the bio-economy "push". Using a political ecology framing, this interdisciplinary course aims to introduce key theories that situate the bio- economy and to deepen understandings about the nature of emerging debates. These range from contestations about genetically modified crops, and 'biopiracy' charges of patenting biodiversity and traditional knowledge, through to the potential of agroecology as a sustainable agricultural future. The course aims to deepen critical thinking around these questions, and to inspire a scholarship that explores possibilities for socially just and environmentally sustainable approaches, with a particular focus on the Global South. The course involves both theory and practice, drawing on research mostly from Sub-Saharan Africa. Students will be expected to read set texts, to watch set videos, and to prepare seminars. The course includes a short fieldtrip.	\N	At least 80% attendance and submission of all assignments	1 exam - 40%, 1 essay (4000-5000 words) - 30%, 1 seminar presentation - 15%, 1 critique (response to a particular article, policy or media piece) - 15%.	\N	EGS5058F	EGS	F	EGS	F
AIR QUALITY MONITORING, MANAGEMENT AND PREDICTION	23	9	Dr J von Holdt	\N	\N	\N	Compromised air quality is a major environmental concern, especially in urban environments and even more so in cities in developing parts of the world. This course explores the current state of global air quality but with a focus on examples and case studies from the global south, particularly Africa. We will investigate the factors and role players that have an influence on air quality, the distribution of polluted versus clean air and the impacts on people and the environment. This module will look at the different scales at which people are exposed to poor air quality and the data and tools we use to study and monitor the atmosphere at these different scales and explore the potential for locally developed interventions and solutions. We will also look at air quality management and how the current socio-economic situation is reflected in this space with specific reference to South and southern Africa. Students will be expected to identify an air quality issue of their choice, find and interpret relevant literature, appropriate datasets and methods and produce results which will culminate in a short research report with recommendations for interventions that can potentially result in improvements in the air quality at receptor sites.	\N	At least 80% class attendance and 40% minimum in assignments.	Literature review 10%, data analysis assignment and paper 35%, discussion piece 10%, project poster and presentation 15%, final capstone exam 30%.	\N	EGS5067F	EGS	F	EGS	F
MACHINE LEARNING	12	9	Associate Professor G Nitschke	Admission into the Master's degree specialising in Artificial Intelligence, or permission from the course convener.	\N	\N	This course will expose students to foundational concepts and computational techniques in Machine Learning and underlying theory and concepts related to formulating and implementing machine learning algorithms to solve a wide range of problems. Students will also learn how to implement a broad range of classical to biologically inspired machine learning algorithms with realworld applications. Core topics include supervised and unsupervised learning such as: concept learning, clustering, artificial neural networks and reinforcement learning.	\N	None	Practical work counts 50%; examination counts 50%.	This course will not be offered every year.	CSC5034Z	CSC	Z	CSC	Z
CRITICAL PERSPECTIVES ON THE BIO-ECONOMY	23	9	Professor R Wynberg	Acceptance for Honours or Master’s specialising in EGS or cognate disciplines.	\N	\N	Located at the interface of fast-changing genetic and information technologies, and the juncture of a range of social, environmental and ethical concerns, the so-called bio-economy has changed fundamentally ways in which biodiversity is used, conserved and commercialised. Although often touted as a panacea for energy crises, livelihoods, environmental remediation and food security, critical questions have been raised about who stands to benefit, the involvement of local communities, and economic and political drivers behind the bio-economy "push". Using a political ecology framing, this interdisciplinary course aims to introduce key theories that situate the bio- economy and to deepen understandings about the nature of emerging debates. These range from contestations about genetically modified crops, and 'biopiracy' charges of patenting biodiversity and traditional knowledge, through to the potential of agroecology as a sustainable agricultural future. The course aims to deepen critical thinking around these questions, and to inspire a scholarship that explores possibilities for socially just and environmentally sustainable approaches, with a particular focus on the Global South. The course involves both theory and practice, drawing on research mostly from Sub-Saharan Africa. Students will be expected to read set texts, to watch set videos, and to prepare seminars. The course includes a short fieldtrip.	\N	At least 80% attendance and submission of all assignments	1 exam - 40%, 1 essay (4000-5000 words) - 30%, 1 seminar presentation - 15%, 1 critique (response to a particular article, policy or media piece) - 15%.	\N	EGS5058S	EGS	S	EGS	S
ENVIRONMENTAL GOVERNANCE IN THE GLOBAL SOUTH	23	9	Dr P Mbatha	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course aims to introduce students to the theory and praxis of environmental governance relevant to global South contexts. It begins by outlining and discussing dominant historical and current environmental governance theories, models and approaches at the global level. The course then engages with various economic, political, historical, institutional and social drivers that influence environmental governance processes, practices and implementation, using the global South as a lens. It underlines symmetries and asymmetries of environmental governance by drawing on various natural resource use and governance sectors, i.e. biodiversity conservation, mining, forestry, tourism, etc. The course also engages the Sustainable Development Goals from a governance perspective, by critically analyzing whether or not they can realistically be in conversation with and address issues relating to environmental governance practice in the global South.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS5059F	EGS	F	EGS	F
ENVIRONMENTAL GOVERNANCE IN THE GLOBAL SOUTH	23	9	Dr P Mbatha	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course aims to introduce students to the theory and praxis of environmental governance relevant to global South contexts. It begins by outlining and discussing dominant historical and current environmental governance theories, models and approaches at the global level. The course then engages with various economic, political, historical, institutional and social drivers that influence environmental governance processes, practices and implementation, using the global South as a lens. It underlines symmetries and asymmetries of environmental governance by drawing on various natural resource use and governance sectors, i.e. biodiversity conservation, mining, forestry, tourism, etc. The course also engages the Sustainable Development Goals from a governance perspective, by critically analyzing whether or not they can realistically be in conversation with and address issues relating to environmental governance practice in the global South.	\N	At least 80% attendance record and submission of all assignments.	Assignments 60%; examination 40%.	\N	EGS5059S	EGS	S	EGS	S
GEOGRAPHIES OF SEXUALITIES: IDENTITY, PLACE, & HEALTH	23	9	A Tucker	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores and critically engages with geographical research related to sexuality, with a particular focus on the interrelationships between identity, place and health. The course explores how geographical thinking on sexuality – and in particular on Lesbian, Gay, Bisexual, and Trans (LGBT) groups – has evolved over time, and the key relationships that have emerged between the study of sexuality and the study of health needs and inequalities. Starting with an exploration of the historical roots of the geographies of sexualities literature the course will go on to explore the connections such work has had with wider post-structuralist queer theories, globalization debates, and research on sexualities drawn from sub-Saharan Africa. The course will then situate such work in relation to the development of work on HIV/ AIDS prevention, treatment and care, by considering how sexualities have been variously framed, and the at times limited conceptual space for an appreciation of diverse sexual identities. The course then draws together these various strands to consider the options and possibilities for current HIV programming in Cape Town for LGBT groups together with a critical examination of the epidemiological logics and conceptual challenges of the public health deployment of ‘men who have sex with men’(MSM).	\N	Class attendance (80%) and submissions of all assignments.	1 essay (6000-6500 words) – 30%, 1 seminar presentation – 10%, 1 24hr take-home exam – 60%.	\N	EGS5066F	EGS	F	EGS	F
GEOGRAPHIES OF SEXUALITIES: IDENTITY, PLACE, & HEALTH	23	9	A Tucker	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	This course explores and critically engages with geographical research related to sexuality, with a particular focus on the interrelationships between identity, place and health. The course explores how geographical thinking on sexuality – and in particular on Lesbian, Gay, Bisexual, and Trans (LGBT) groups – has evolved over time, and the key relationships that have emerged between the study of sexuality and the study of health needs and inequalities. Starting with an exploration of the historical roots of the geographies of sexualities literature the course will go on to explore the connections such work has had with wider post-structuralist queer theories, globalization debates, and research on sexualities drawn from sub-Saharan Africa. The course will then situate such work in relation to the development of work on HIV/ AIDS prevention, treatment and care, by considering how sexualities have been variously framed, and the at times limited conceptual space for an appreciation of diverse sexual identities. The course then draws together these various strands to consider the options and possibilities for current HIV programming in Cape Town for LGBT groups together with a critical examination of the epidemiological logics and conceptual challenges of the public health deployment of ‘men who have sex with men’(MSM).	\N	Class attendance (80%) and submissions of all assignments.	1 essay (6000-6500 words) – 30%, 1 seminar presentation – 10%, 1 24hr take-home exam – 60%.	\N	EGS5066S	EGS	S	EGS	S
AIR QUALITY MONITORING, MANAGEMENT AND PREDICTION	23	9	Dr J von Holdt	\N	\N	\N	Compromised air quality is a major environmental concern, especially in urban environments and even more so in cities in developing parts of the world. This course explores the current state of global air quality but with a focus on examples and case studies from the global south, particularly Africa. We will investigate the factors and role players that have an influence on air quality, the distribution of polluted versus clean air and the impacts on people and the environment. This module will look at the different scales at which people are exposed to poor air quality and the data and tools we use to study and monitor the atmosphere at these different scales and explore the potential for locally developed interventions and solutions. We will also look at air quality management and how the current socio-economic situation is reflected in this space with specific reference to South and southern Africa. Students will be expected to identify an air quality issue of their choice, find and interpret relevant literature, appropriate datasets and methods and produce results which will culminate in a short research report with recommendations for interventions that can potentially result in improvements in the air quality at receptor sites.	\N	At least 80% class attendance and 40% minimum in assignments.	Literature review 10%, data analysis assignment and paper 35%, discussion piece 10%, project poster and presentation 15%, final capstone exam 30%.	\N	EGS5067S	EGS	S	EGS	S
DISASTER RISK SCIENCE	23	9	Dr P Sabela-Rikhotso	Acceptance for EGS Masters	\N	\N	The severity and frequency of disastrous events has been in the rise for the past two decades. In the South African context however, declaration of the state of disaster has become a bone of contention in its ability to encourage disaster risk reduction. A myriad of stereotypes and bad publicity has been built around the roles, responsibilities, and authority of government to efficiently manage disasters. Through a transdisciplinary lens, this course aims to explore broad concepts, legislative and policy framework, practical applications, tools, and skills influencing disaster risk science. The course begins by exploring different scholarly arguments about the unnatural state of natural disasters. It will further investigate theoretical models and case studies which will underscore the fundamentals of disaster impact minimisation. The course will interrogate various ways in which humans, through environmental and socio-economic factors drive vulnerability and subsequently create disaster risk.	\N	At least 80% attendance and submission of all assignments.	Assignments 50%, Final exam 50%	\N	EGS5068F	EGS	F	EGS	F
MATHEMATICS 1034	18	5	Dr H Wiggins	MAM1033F	\N	\N	The aim of this course is to introduce the fundamental ideas in calculus and related topics. The main topics include integral calculus, differential equations, partial derivatives, vector geometry, matrix algebra, complex numbers, and Taylor polynomials. The course includes an explicit focus on mathematical thinking practices necessary for the depth of mathematical understanding for studies in the mathematical and physical sciences. These practices include: inductive and deductive reasoning, justifying, defining, proving, using mathematical understanding to flexibly solve multi-level problems, reading mathematics for learning, and communicating mathematical knowledge in writing and applying mathematics using mathematical thinking practices for clarity, consistency and a depth of understanding that prepares them for second- and third-year mathematics, and the mathematical requirements of their other Science courses. This course (or equivalent), along with MAM1033F (or equivalent) is necessary for entry into second year mathematics.	Five lectures per week, Monday - Friday, 1st or 3rd period.	Minimum of 30% for class tests, minimum 30% for weekly online tests, 80% attendance at tutorial sessions, and 100% attendance at Mathematical Thinking workshops.	Semester mark counts 33.3% and end-of-semester exam counts 66.6%.	\N	MAM1034S	MAM	S	MAM	S
ENVIRONMENTAL & GEOGRAPHICAL SCIENCE THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Prospective candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	EGS6003W	EGS	W	EGS	W
INTRODUCTION TO MINERALS, ROCKS & STRUCTURE	18	5	Dr R Pickering	A minimum of 45% in GEO1009F	\N	\N	This course introduces students to the Geology major and covers the essentials of the discipline as follows: crystals and minerals; igneous and metamorphic rocks; structural geology; mineral deposits and economic geology; palaeontology; the interpretation of geological maps. A three-day field trip to the Western Cape serves as an introduction to field geology.	Monday - Friday, 5th period	An average of 30% in all marked classwork and tests.	Class tests count 35%; field reports count 15%; one 2-hour theory examination written in November counts 50%. A subminimum of 40% is required in the theory examination paper.	\N	GEO1006S	GEO	S	GEO	S
APPLIED OCEAN SCIENCES MINOR DISSERTATION	90	9	Professor M Vichi and Dr L C Gammage	A relevant Honours degree (or equivalent). Students with backgrounds in scientific and engineering disciplines are encouraged to apply.	BIO5012W, BIO5013F, BIO5014F/SEA5011F, STA5014Z	\N	The minor dissertation, which forms 50% of the overall degree, is based on a six-month supervised research project. The choice of project will be determined by the student's prior qualification and in agreement with the course conveners and supervisors. The dissertation should be submitted by mid- February of the following year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	Students will enrol (and pay fees) for coursework codes BIO5012W, BIO5013F, BIO5014F/SEA5011F and STA5014Z together with BIO5015W in their first year of registration; where the minor dissertation is not submitted by the February deadline of the subsequent year, the student will be required to enrol (and pay fees) for the minor dissertation component in the subsequent year/s.	BIO5015W	BIO	W	BIO	W
NATURAL RESOURCE ECONOMICS	18	7	D Thiam	Students must have completed ECO2003.	\N	\N	This introduction to Natural Resource Economics examines the scarcity and optimal allocation of freshwater resources in the Western Cape, South Africa. The theoretical framework is neo-classical microeconomics and market failure and climate change are being addressed.	08h00 – 09h00 on Tuesday, Wednesday, Thursday, Friday.	40% year mark, at least one test must be written. Two concessions will result in DPR.	Coursework 40%; Exam 60%. See the course outline for a detailed breakdown of the course work component.	The supplementary / deferred exam for Eco3009F will be scheduled during the last week of the mid-year vacation. If students do not write this exam, they will be marked AB and will have to retake the course.	ECO3009F	ECO	F	ECO	F
FINANCIAL REPORTING II	36	6	M Bardien	A pass in ACC1006, a minimum mark of 60% for ACC1011 within two years of first registration for this course. Concurrent registration or a previous pass in ACC2022, ACC2023 and MAM1010	\N	\N	This course integrates knowledge from first year accounting and Financial Reporting I. Students should be able to prepare and present separate and group financial statements within the scope of the Conceptual Framework for Financial Reporting and the International Financial Reporting Standards (‘IFRS’) upon completion of this course.	Monday to Friday 8:00 for BBusSci and 9:00 for BCom.	Attendance at and submission of a minimum of 75% of tutorials in each semester and a weighted average of 40% for class tests (excluding objective tests) and a weighted average of 40% for assignments.	Coursework: 40%. Exam: 60%	Course queries to be directed to ACC2012W@uct.ac.za only	ACC2012W	ACC	W	ACC	W
MICROECONOMICS II	18	6	J Burns	ECO1010 and MAM1010 (or an equivalent) or MAM1031F or MAM1032S, If a student gets at least 40% for MAM1000W they will be allowed to register for ECO2004S.	\N	\N	The course studies the role of institutions and power in influencing the outcomes of economic exchange. The course introduces the concept of institutions and how they influence the balance of power in economic interactions, and affect the fairness and efficiency of the allocations that result. The course then applies these concepts to a study of economic inequality, focusing on its trends, sources and policy options for more equal societies. The course then considers firms and the role that market structure plays in the setting of prices. Finally, the course studies market failures with application to environmental policy, and innovation and the networked economy. The course makes use of mathematical techniques to complement the graphical and discursive representation of the theory. All sections of the course incorporate real world applications.	Lecture/Workshop times:09h00 – 10h00 Monday, Tuesday, Wednesday, Thursday. 12h00 – 13h00 Monday, Tuesday, Wednesday, Thursday.13h00 – 14h00 Monday, Tuesday, Wednesday, Thursday.	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	The ECO2003F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO2003F	ECO	F	ECO	F
GOVERNANCE, AUDIT AND ASSURANCE I	18	6	D Govender (course queries to be directed to ACC2018H@uct.ac.za only)	A pass in INF1002 and concurrent registration or a previous pass in ACC1015 and ACC2012W. Registration for a BCom Accounting or BBusSci Finance with Accounting degree, or by permission of the department.	\N	\N	The course builds on the foundations of Financial Accounting and Reporting, Information Systems and general understanding of business. The course introduces students to the foundational principles of business cycles (systems) and internal control, where “Governance” refers to the system by which an entity is directed and controlled and “Internal Control” refers to the process in place to ensure the entity’s objectives with regard to reliability of financial reporting, effectiveness and efficiency of operations, and compliance with applicable laws and regulations.	Wednesday and Thursday 15:00 (Repeat lectures at 16:00).	Attendance at and submission of a minimum of 75% of tutorials in each semester AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 40% Exam: 60%	\N	ACC2018H	ACC	H	ACC	H
INTRODUCTION TO GENERAL RELATIVITY (3GR)	18	7	Dr B Mongwane	MAM2040F, MAM2041F, MAM2042S and MAM2043S.	\N	\N	This course introduces special relativity and general relativity including tensors, the metric tensor, symmetries, curvature, Einstein's field equations and solutions of Minkowski space and Black Holes. Please note that lectures alternate during the week so that students can take MAM3043S and MAM3045S concurrently.	Monday - Friday, 3rd period.	\N	Class record counts up to 50%, while the balance is given by the final examination.	\N	MAM3045S	MAM	S	MAM	S
MANAGEMENT ACCOUNTING I	18	6	J Dean (course queries to be directed to ACC2022H@uct.ac.za only)	ACC1006F or equivalent. Registration for a BCom Accounting, BBusSci Finance with Accounting, or BBusSci Finance degree, or by permission of the department.	\N	\N	An introduction to the discipline of Management Accounting; the analysis of cost systems, cost classification, and cost behaviour; product costing including job costing and process costing; the allocation of costs from service departments; absorption and variable costing; activity based costing; cost-volume-profit relationships, relevant costing and cost benefit analyses; budgeting systems; standard costing and flexible budgeting; financial performance measurement in business segments.	TBC	Attendance at and submission of a minimum of 75% of tutorials in each semester AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments	Course work 40% Exam 60%	\N	ACC2022H	ACC	H	ACC	H
MINERALOGY, CRYSTALLOGRAPHY AND PETROGRAPHY	24	6	Professor P E Janney	GEO1009F and GEO1006S, CEM1000W or equivalent.	\N	\N	This course covers the fundamentals of physical and chemical mineralogy and its application to igneous and metamorphic rocks as a basis for senior courses in petrology. The course comprises inter-related sections as follows: crystallography and crystal optics (including a brief introduction to X-ray crystallography): mineralogy (the chemical, physical and optical properties of selected groups of rock-forming minerals, and the theory and practice of identifying minerals by means of the polarising microscope); phase diagrams (interpretation of simple phase diagrams relevant to igneous and metamorphic rocks); classification and petrography of igneous rocks (physical processes of magma differentiation; the relationship between chemical composition and modal mineralogy); classification and petrography of metamorphic rocks (types of metamorphism, metamorphic textures and mineral assemblages).	Monday - Friday, 2nd period	Attendance at 80% of practicals and an average of 30% in all marked class work and tests.	Marked class work, including tests, count 20%; one 2-hour practical examination in June counts 30%; one 2-hour theory examination in June counts 50%. Subminima of 40% are required in practical and theory examination papers.	Entrance is limited to 35 students	GEO2001F	GEO	F	GEO	F
FINANCIAL REPORTING I AUGMENTED	18	5	B Diale	ACC1106F. Registration for a BCom Accounting, BBusSci Finance with Accounting, or Actuarial Science degree through the Education Development Unit, or by permission of the department.	\N	\N	Financial Reporting 1 strengthens students' understanding of financial reporting principles. Topics include companies, property, plant and equipment, cash flows, liabilities, and financial analysis.	Fridays at either 10h00–10h45 or 11h00–11h45, and a double-period tutorial per week. Optional in-person learning Mon–Thurs.	A weighted average of 35% for class tests, having written at least one class test.	Coursework: 40% Exam: 60%. The coursework component may include participation.	Students require an overall average of 60% for Financial Reporting I to proceed to Financial Reporting II	ACC1111S	ACC	S	ACC	S
TAXATION I	18	6	Z Wormald / S Esack	ACC1011S and concurrent registration or a previous pass in ACC1015. Registration for a BCom Accounting or BBusSci Finance with Accounting degree, or by permission of the department.	\N	\N	The primary aim of Taxation I (ACC2023H) is to provide students with a foundation to the income tax legislation in order to enable them to apply such knowledge in problem-solving situations. The study of value-added tax has an important bearing on the study of income tax. The aim in covering these areas is to give students a rounded knowledge of the fiscal tax planning arena.	TBC	Attendance at and submission of a minimum of 75% of tutorials and assignments (i.e., objective tests) in each semester AND a weighted average of 40% for all class tests (excluding objective tests) AND a weighted average of 40% for the project assignments.	Coursework: 40% Exam: 60%	Course queries to be directed to ACC2023H@uct.ac.za only	ACC2023H	ACC	H	ACC	H
CORPORATION LAW	36	7	Dr S Phungula and Dr M Maphiri	All Preliminary Level courses to have been completed.	\N	\N	The course will provide an overview of the law governing various structures available for the carrying on of business and will then focus on the general principles of Company Law, the provisions of the Companies Act 71 of 2008, corporate governance and corporate law reform.	\N	Please refer to the course handout and/or the intermediate year schedule.	Optional essay/opinion 20%, mid-year test (compulsory) 30%. Examination 50% (if essay/opinion submitted) or 60% (if no essay/opinion submitted)	Intermediate Level, whole course, 72 lectures and tutorials.	CML3001W	CML	W	CML	W
MANAGEMENT AND COST ACCOUNTING FOR NONSPECIALISTS	16	6	J Dean	ACC1006F or equivalent.	\N	\N	This is a terminating course covering an introduction to the discipline of Management Accounting; the analysis of cost systems, cost classification, and cost behaviour; product costing including job costing and process costing; the allocation of costs from service departments; absorption and variable costing; activity based costing; cost-volume-profit relationships, relevant costing and cost benefit analyses; budgeting systems; standard costing and flexible budgeting; financial performance measurement in business segments. This course is intended for students registering for Construction Studies and does not lead to further accounting studies.	Friday, 2-4PM.	Weighted average mark of 40% for all class tests (excluding objective tests) AND Attendance at and submission of a minimum of 75% of tutorials and assignments.	Invigilated tests (40%) and one final exam (60%), no projects.	\N	ACC2042H	ACC	H	ACC	H
FINANCIAL REPORTING III	36	7	S Gwadiso	Please refer to the “Entry to CA specific courses” section.	\N	\N	The objective of Financial Reporting III within the CA(SA) qualification process is to ensure that students display competencies related to the recording, recognition, measurement and presentation of financial and non-financial information in accordance with International Financial Reporting Standards (IFRS). It does so by building on the basic principles of accounting taught in Financial Reporting I and II. Particular emphasis is placed on the application of full IFRS, integration of income taxes and the application of various accounting principles in a group situation.	TBC	Attendance at a minimum of 75% of tutorials AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 40% Exam: 60%	\N	ACC3009W	ACC	W	ACC	W
FINANCIAL REPORTING AND ANALYSIS	36	7	S Fakier and N Daniels	A pass in ACC2012W, and DP for ACC2023.	\N	\N	This course provides a broad-based accounting major that ensures preparation for the business and financial reporting environment. The focus is on the understanding and interpretation of advanced accounting concepts and financial reporting and to provide a basis for further postgraduate studies in financial accounting and related disciplines; in particular to provide a grounding for professional qualifications issued by bodies such as SAIPA, ACCA and CIMA.	TBC	Attendance at a minimum of 75% of tutorials AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 50% Exam: 50%	\N	ACC3020W	ACC	W	ACC	W
GOVERNANCE, AUDIT AND ASSURANCE II	26	7	S Shamsoodien	ACC2018S and ACC2012W, concurrent registration or a previous pass in INF2004F.	\N	\N	This course covers most of the key concepts contained in the auditing, assurance and related services syllabus for the Initial Test of Competence (ITC) for entrance into the accountancy profession. On successful completion of the course a student will have an understanding of the principles and rationale of auditing and the ability to solve basic practical auditing problems.	TBC	Attendance at a minimum of 75% of tutorials AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 40% Exam: 60%	\N	ACC3022W	ACC	W	ACC	W
MANAGEMENT ACCOUNTING II	26	7	R Davids and T Prince	ACC2022; ACC1011S; and FTX2024 or FTX2020.	\N	\N	Management Accounting II course focuses on the core pillars of Costing, Decision Making, and Planning and Control. The principles build on the foundations of Management Accounting I, and expand on these principles further. The course is designed to enable students, after graduating, to go on with professional courses such as those offered by the Chartered Institute of Management Accountants (CIMA), South African Institute of Chartered Accountants (SAICA), and the Association of Chartered Certified Accountants (ACCA).	TBC	Attendance at and submission of a minimum of 75% of tutorials AND a weighted average of 40% for class tests (excluding objective tests) AND a weighted average of 40% for assignments.	Coursework: 40% Exam: 60%	\N	ACC3023W	ACC	W	ACC	W
ECONOMICS FOR NON-SPECIALISTS	18	5	S Filby	Only students who are registered in the Faculty of Humanities may register for this course or with special permission from the course convenor or head of department	\N	This course is designed for students intending to do only one semester of Economics. It is therefore aimed at providing a broad perspective on the subject, and concentrates more on an understanding of economic concepts and their application than it does on rigorous proofs and analysis.	This course comprises both micro- and macro-economics. Microeconomics focuses on individuals, be it individual consumers, firms or markets. The focus is on understanding the behaviour of these individual entities. Macroeconomics focuses on the economy as a whole. Rather than looking at the factors that determine an individual’s consumption decisions (i.e. his/her income, the expected utility derived from different goods and the prices of those goods), the focus in macroeconomics is on total consumption of all consumers in the economy. Similarly, the focus is not on the output decision of any individual firm, or even an industry, but on the total output of all firms in the economy as a whole.	16h00 - 18h00 Monday - Thursday	All class tests and assignments/essays/projects to be completed. Attend at least 70% tutorials. Satisfactory completion and timeous submission of at least 70% of tutorials. A weighted average mark of 30% for tests, tutorials, essays and assignments.	Coursework 50%; Exam 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	The ECO1006F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO1006F	ECO	F	ECO	F
ECONOMICS FOR ENGINEERS	18	5	C Mlatsheni	None	\N	This course is open to all students not specializing in economics but seeking an introduction to the discipline. It is aimed at providing a broad perspective on the subject covering topics from both the core microeconomics and macroeconomics syllabus. The course concentrates more on an understanding of economic concepts and their applications rather than rigorous proofs and analysis.	ECO1007S is a one semester course that introduces students to the core concepts in both micro- and macroeconomics. The focus is on the understanding of theoretical concepts and applications, rather than on rigorous proofs. Microeconomics focuses on the decisions of individual consumers, producers, and households, and in this section we look at standard economic models including the production possibility frontier, demand and supply analysis, and elasticity. We also explore the idea of comparative advantage as it applies to specialisation and trade. Macroeconomics focuses on the economy as a whole and in this section of the course we unravel the meaning, application, and limitations of such everyday concepts as money, inflation, exchange rates, unemployment, and GDP.	12h00 - 13h00 Tuesday, Wednesday, Thursday & Friday	All assessments (including tests and essay) to be completed.	Coursework: 45%; Exam: 55%. The course outline will provide more detail on the breakdown for submission weightings and variation for exemptions and absences.	As all Commerce students are required to register for ECO1010 and ECO1011, this course is not available to Commerce students.	ECO1007S	ECO	S	ECO	S
MICROECONOMICS II	18	6	C Mlatsheni	ECO1010 and MAM1010 (or an equivalent) or MAM1031F or MAM1032S. Students who wish to register for this course need to have failed the course previously or have been denied entry because they now meet the Mathematics requirements but previously did not. Alternatively, they need to prove that by registering for the course it would allow them to finish their degree at least 6 months earlier than had they not done the summer term course. Students may not register for both ECO2003P/L and ECO2004P/L simultaneously. To register for this course, permission is required from the School of Economics.	\N	\N	The course studies the role of institutions and power in influencing the outcomes of economic exchange. The course introduces the concept of institutions and how they influence the balance of power in economic interactions, and affect the fairness and efficiency of the allocations that result. The course then applies these concepts to a study of economic inequality, focusing on its trends, sources and policy options for more equal societies. The course then considers firms and the role that market structure plays in the setting of prices. Finally, the course studies market failures with application to environmental policy, and innovation and the networked economy. The course makes use of mathematical techniques to complement the graphical and discursive representation of the theory. All sections of the course incorporate real world applications.	Lecture/Workshop times:09h00 – 12h00 Monday, Tuesday, Wednesday, Thursday and Friday	None	50%; Exam: 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	\N	ECO2003P/L	ECO	L	ECO	L
COMMERCIAL PROGRAMMING	18	5	S Kabanda	At least 65% for INF1002F/S/N or equivalent (or at least 70% for CSC1017F). Objective: At the end of the course, students will be able to:• Demonstrate understanding of C# language features;• Demonstrate understanding of object-oriented programming;• Write entry-level programs, from specifications, using C#,• Use the Visual Studio integrated development environment proficiently	\N	At the end of the course, students will be able to:• Demonstrate understanding of C# language features;• Demonstrate understanding of object-oriented programming;• Write entry-level programs, from specifications, using C#,• Use the Visual Studio integrated development environment proficiently	The course focuses on integrating good programming practices through planning and developing software programs using C#. The course is practically-orientated and students should be prepared to spend time after hours to do programming exercises and examples in the computer laboratories, or on a personal computer at home. Theory lectures are used to communicate course content, which includes: Data Types and Expressions, Methods and Behaviours, Creating Your Own Classes, Making Decisions, Repeating Instructions, Arrays, Introduction to Windows Programming, Advanced Object- Oriented Programming Features, and Debugging and Handling Exceptions.	Monday, Tuesday and Thursday, 8th and 9th period.	Submission of 80% of quizzes and workshops. A minimum year mark of 45%.	Coursework: 80%; Summative Assessment 20%. Subminimum 40% for the summative assessment.	\N	INF1003F	INF	F	INF	F
MACROECONOMICS II	18	6	T Mpofu	ECO1010, ECO1011 and MAM1010 (or an equivalent) or MAM1031F or MAM1032S. A student will be permitted to take ECO2004S without having passed ECO2003F, although it is desirable to pass ECO2003F prior to taking ECO2004S. If a student gets at least 40% for MAM1000W they will be allowed to register for ECO2004S.	\N	\N	The course builds upon ECO1011S and aims to provide students with the analytical tools and formal models to explain the behaviour of output, inflation, employment, interest rates, and other economic aggregates. These tools are used to understand current economic issues, forecast the behaviour of the economy, and assess the impact of policy choices. The course allows students to understand the behaviour of households, firms, governments and Central Banks. It starts with analysing the short run behaviour of the economy and then moves on to explore the open economy and exchange rates. Finally, it looks at the long run and assesses the role of technology and population growth on aggregate economic growth using the Solow growth model.	Lecture/Workshop times: 09h00 – 10h00 Monday, Tuesday, Wednesday, Thursday,12h00 – 13h00 Monday, Tuesday, Wednesday, Thursday,13h00 – 14h00 Monday, Tuesday, Wednesday, Thursday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	\N	ECO2004S	ECO	S	ECO	S
MACROECONOMICS II	18	6	C Mlatsheni	ECO1010, ECO1011 and MAM1010 (or an equivalent) or MAM1031F or MAM1032S. A student will be permitted to take ECO2004S without having passed ECO2003F, although it is desirable to pass ECO2003F prior to taking ECO2004P/L. If a student gets at least 40% for MAM1000W they will be allowed to register for ECO2004P/L. Students who wish to register for this course need to have failed the course previously or have been denied entry because they now meet the Mathematics requirements but previously did not. To register for this course, permission is required from the School of Economics.	\N	\N	The course builds upon ECO1011S and aims to provide students with the analytical tools and formal models to explain the behaviour of output, inflation, employment, interest rates, and other economic aggregates. These tools are used to understand current economic issues, forecast the behaviour of the economy, and assess the impact of policy choices. The course allows students to understand the behaviour of households, firms, governments and Central Banks. It starts with analysing the short run behaviour of the economy and then moves on to explore the open economy and exchange rates. Finally, it looks at the long run and assesses the role of technology and population growth on aggregate economic growth using the Solow growth model..	Lecture/Workshop times:09h00 – 12h00 Monday, Tuesday, Wednesday, Thursday, Friday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	\N	ECO2004P/L	ECO	L	ECO	L
DEVELOPMENT ECONOMICS	18	6	S Khan	ECO1010 and ECO1011 or first year equivalents in Political Studies, Sociology, Anthropology, History or Philosophy.	\N	\N	The course provides an introduction to development economics. It covers the major topics in the field. These include the meaning of development, economic growth, inequality and poverty. In addition, the course deals with resource mobilisation, agricultural and industrial development, globalisation, sustainable development and institutions and the political economy of development. The discussion is both theoretical and applied with extensive use made of country and regional case- studies. The course focuses on development challenges confronting South Africa and the rest of Africa. Considerable attention is devoted to key theoretical and policy debates.	14h00 – 15h00 Tuesday, Wednesday, Thursday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	\N	ECO2008S	ECO	S	ECO	S
CONSERVATION BIOLOGY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	BIO6002W	BIO	W	BIO	W
BPM & ENTERPRISE SYSTEMS	18	7	L Seymour	INF1003F, INF2009F and INF2011S	\N	\N	This course examines the role, relationship and effect IT Applications have on businesses and vice versa. It has a heavy emphasis on ERP systems, business processes and Business Process Management (BPM). Students will be exposed to methodologies and techniques to identify, model, measure and improve processes. Students will be introduced to technologies that can be used as part of process improvement initiatives as well as technologies such as ERP that impact on business processes. A group project will allow students to apply their analytical skills to improving an existing process. Students will be introduced to S/4 HANA and will acquire a basic working knowledge of the Application.	11h00-11h45 Tuesday- Friday and 10h00-10h45 Thursday and Friday	Submission of group project and a sub-minimum of 45% for the year mark prior to writing the final examination. In addition, students must complete, make a reasonable attempt at, and submit 80% of workshops.	Classwork 70% (workshops, class exercises, test and a group project), final examination 30%. Sub-minimum of 40% for the final examination.	\N	INF3012S	INF	S	INF	S
HISTORY OF ECONOMIC THOUGHT	18	7	M Smith	ECO2003 and ECO2004.	\N	\N	This course explores the history of economic thought beginning with Adam Smith’s defence of market society at the start of the industrial revolution and Karl Marx’s critique of capitalism. It includes debates over socialist and development planning, the rise of development economics in the colonial and post-colonial context, and debates over the role of finance in shaping growth and inequality. The relationship between state, market and society is a central theme – as is the contemporary relevance of economic thought for Africa. Additional lenses are also given to theories developed around African economic development and their linkages with other continents and development theories.	10h00 – 11h00 Monday, Tuesday, Wednesday, Thursday, Friday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for different components of the course-work and related requirements.	The ECO3016F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO3016F	ECO	F	ECO	F
SKILLS FOR COMMERCE	2	5	D Munene	First year registration in the Commerce Education Development Unit and any first year Commerce student (maximum intake of 40) who elects to register for the course. The course is compulsory for all students registered for the CB011, CB015, CB018, CB020, CB023, CB024, CB025 and CB026 degree programmes.	\N	\N	This course is aimed to provide first-year EDU students with the skills to manage the academic and personal aspects of their university studies, and to introduce students to the concept of career management. Semester 1: Managing academic and personal aspects of university studies through goal setting, planning, time management, stress management, exam anxiety, exam competence, exam preparation, career development, reviewing academic progress and exam consolidation. Semester 2: Students will be introduced to the concept of career management skills which aims to inform career exploration and future choices. There will be a focus on raising self-awareness and the development of career research skills, enhancing the ability to make informed and effective career decisions.	\N	\N	Attendance at each session will be recorded. 80% attendance will be required for this course to be passed.	\N	DOC1103H	DOC	H	DOC	H
ADVANCED MACRO AND MICRO ECONOMICS	18	7	A Kerr	MAM1010 (or equivalent) or MAM1031F or MAM1032S or ECO2003, ECO2004	\N	\N	This course has two, equally weighted components: the microeconomics component and the macroeconomics component. The first 6 weeks of the course will focus on Microeconomics. This section of the course will focus on the dynamic interplay of behaviour and institutions, and the outcomes produced through their interaction. The heart of the microeconomics we will study is really the question of how social interactions can be structured such that people are free to choose their own actions while avoiding outcomes that none would have chosen. We will draw attention to issues of distribution and market exclusion (issues of power and bargaining) as well as efficiency and will try to focus our thinking on applied issues.The macroeconomics component follows Stephen Williamson’s Macroeconomics and employs his graphical and sectoral approach, which employs a micro foundations approach to macroeconomics. It starts by developing a basic closed economy model and expands it to a full open economy monetary model. Students will study the real business cycle model, the functioning of foreign trade and the role of money and banking.	09h00 – 10h00 Monday, Tuesday, Wednesday, Thursday, Friday10h00 – 11h00 Monday, Tuesday, Wednesday, Thursday, Friday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weighting and variation for exemptions and absences.	The ECO3020F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO3020F	ECO	F	ECO	F
QUANTITATIVE METHODS IN ECONOMICS	18	7	R Hill	Students must have completed MAM1010 (or an equivalent), STA1000, ECO2003 and ECO2004.	\N	\N	The emphasis in this course is to introduce students to new tools and techniques for quantitative analysis in the social and behavioural sciences. In this respect, it is aimed at students wishing to pursue postgraduate studies in economics. The course covers two inter-related modules, and while the sequence may vary from year to year, the broad areas of study include the following: Module one: cross sectional econometrics using Stata. Module two: time series econometrics using R.	09h00 – 10h00 Tuesday, Wednesday, Thursday, Friday	None	Exam: 40%; Coursework: 60%. In some years a bonus 5% may be achievable for a Stata Assignment. The course outline will detail the breakdown for submission weighting and variation for exemptions and absences.	\N	ECO3021S	ECO	S	ECO	S
APPLIED INTERNATIONAL TRADE BARGAINING	18	7	J Chien	ECO1010 and ECO1011; At least TWO 2000-level economics courses.	\N	\N	This course is a simulation of a multi-national, multilateral trade negotiating round, based on the ‘Doha agenda.’ Students representing countries, based on random assignment, and, after researching their country's trade policies and interests, participate in supervised negotiations simulating the World Trade Organisation bargaining and treaty-making process. The course is partly web-based, using a special site and resources on the Vula interface. There is no sit-down examination, but students submit substantial final reports that are externally examined and have equivalent status to an examination.	10h00 – 11h00 Monday, Tuesday, Wednesday, Thursday, Friday	None	Coursework: 60%; Final Research Report: 40%. The course outline will detail the breakdown for submission weighting and variation for exemptions and absences.	\N	ECO3025S	ECO	S	ECO	S
SYSTEMS DEVELOPMENT PROJECT I	48	7	W Uys	All second year Information Systems courses. Objective: It aims to equip the student with crucial problem-solving skills using object-oriented software development techniques, and endeavours to improve technical document writing skills.	\N	It aims to equip the student with crucial problem-solving skills using object-oriented software development techniques, and endeavours to improve technical document writing skills.	This whole year course is for students majoring in Information Systems (IS) to gain an understanding of the issues that are influencing ICT projects and experience the development and implementation of such a project. This course combines the theoretical elements of project management with the practical implementation of these concepts through the completion of a systems development team project, integrating practical and theoretical elements obtained and developed during other undergraduate IS courses. The theoretical parts of this course aim to make the project team experiences more true to life, aiding the development of a project practitioner. Students should be aware that successful project management consists of a sound plan (using project management tools and techniques) and strong people management to direct the plan through to the completion of the project’s deliverables. The basis for this development process is an interactive project team environment of learning through experiences and reflection. The practical part of this course involves the application and implementation of these concepts following the full life cycle of a team-based IS project in a real-life setting.	First semester: 10h00-10h45 Monday and Tuesday, and 10h00-11h45 Wednesday and Friday, and 10h00-12h45 Thursday Second semester: 12h00-12h45 Thursday	Students will be considered to have duly performed the course work if they have obtained a minimum of 45% for their year mark.	Coursework 60%. (Weekly coding workshops and tutorials, as well as continuous assignments for the team project culminating in a formal presentation and code presentation). Teamwork makes up 40% of the course mark. Exam 40%. Sub-minimum of 40% for the examination (both Project Management and Code).	\N	INF3003W	INF	W	INF	W
ADVANCED LABOUR ECONOMICS	18	7	C Mlatsheni	ECO2003 and ECO2004.	\N	\N	The aim of the course is to learn the basics of modern labour economics so as to understand some of the most crucial economic issues in South Africa and internationally (e.g. unemployment, inequality, migration etc.). The course covers a review of labour demand and supply; alternative approaches to labour economics and to the SA labour market; the economics of education and training; earnings inequality and discrimination; the economics of trade union collective bargaining; and unemployment.	14h00 – 15h00 Monday, Tuesday, Wednesday, Thursday, Friday	None	Coursework: 40%; Exam: 60%. The course outline will detail the breakdown for submission weightings and variation for exemptions and absences.	\N	ECO3022S	ECO	S	ECO	S
PUBLIC ECONOMICS	18	7	N Pillay	ECO2003 and ECO2004.	\N	\N	The course covers the core issues in public economics that are common to most countries and contexts: the theoretical and empirical tools of public economics, externalities, public goods, social insurance, redistribution and taxation. These tools are used to analyse questions that are more specific and/or relevant to current issues, such as healthcare, infrastructure and social grants. Reference will be made to key policy debates of other countries, developed and developing, but the primary focus will be on South Africa.	15h00 – 16h00 Monday, Tuesday, Wednesday, Thursday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission and variation for exemptions and absences.	\N	ECO3023S	ECO	S	ECO	S
INTRODUCTION TO STRATEGY AND MARKETING	18	5	A Meadows	Students must be in their 2ND or 3rd academic year of study or have the permission of the Head of Department of the School of Management Studies. BUS1004F is offered as an elective to students from all faculties as well as SSA students.	\N	\N	The objective of this course is to provide a general introduction to the world of business strategy and marketing. The course is divided into two modules and the students will study a selection of core topics in the business strategy module and subsequently in the marketing module. As such, the course builds a foundation for developing the business knowledge and skills within the above business disciplines. Those can be further applied in everyday lives, by aspiring entrepreneurs or in careers which are likely to have a significant managerial/business component.	\N	All guest lectures and tutorials are compulsory. Students must satisfactorily submit their projects; write the class tests and obtain an average of 40% in order to receive their Duly Performed certificate.	Coursework 60% of the final mark; final assessment 40% of the final mark.	\N	BUS1004F	BUS	F	BUS	F
INTERNATIONAL TRADE AND FINANCE	18	7	L Edwards	The course is recommended only for students who attained at least 60% for ECO2003 and ECO2004.	\N	\N	The course presents an overview of international economics with a focus on trade theory and international finance. The course covers many topics including the determinants of international trade flows, trade policy, exchange rates and open-economy macroeconomics, and international macroeconomic policy. The course draws upon empirical evidence to verify whether the theories taught in the course are relevant in explaining South Africa’s performance in the international economy. By the end of the course, students will have an in-depth understanding of international economics and its application to the South African economy.	16h00 – 17h00 Monday, Tuesday, Wednesday, Thursday	None	Coursework: 50%; Exam: 50%. The course outline will detail the breakdown for submission weighting and variation for exemptions and absences.	The ECO3024F supplementary/deferred exam will be scheduled during the last week of the mid-year vacation. If students do not write this exam they will be marked as AB and will have to retake the course.	ECO3024F	ECO	F	ECO	F
NUMERICAL ANALYSIS (2NA)	12	6	Dr B Mongwane	MAM1031F and MAM1032S or equivalent, MAM1043H and MAM1044H	MAM2010F and MAM2011F	\N	The course will cover non-linear equations and rates of convergence. Direct and iterative methods for solving linear systems, pivoting strategies, matrix factorisation, norms, conditioning. Solutions to initial-value problems, including higher-order ordinary differential equations. Interpolation and approximation theory, splines, discrete and continuous least squares. Numerical differentiation and integration. Error analysis and control. Please note that lectures alternate during the week so that students can take MAM2040F and MAM2041F concurrently.	Monday - Friday, 3rd period.	\N	\N	\N	MAM2041F	MAM	F	MAM	F
INTRODUCTION TO MARKETING	18	6	N Madinga	Course restricted to Postgraduate Diploma in Management (Marketing, Entrepreneurship, Tourism and Events, Sport and Business Communication) students.	\N	\N	Students will be expected to be familiar with the following issues by the end of the course: marketing concept, marketing environment, consumer markets and industrial markets, buyer behaviour, marketing research, the use and importance of differentiation, market segmentation and target marketing, marketing mix, product policy, pricing policy, distribution policy, promotion policy, marketing strategy, marketing organisation and implementation, measurement and control of marketing effectiveness including the marketing audit and contemporary marketing issues.	\N	A minimum of 50% must be achieved for coursework	Coursework (Projects/assignments and tests) 50%; Final Examination 50%.	0 credits if taken as part of a Postgraduate Diploma in Management offered by the School of Management studies.	BUS2011F	BUS	F	BUS	F
I.T. PROJECT MANAGEMENT	18	7	G Mwalemba	INF1003F, INF2009F and at least 45% for INF2011S	\N	\N	This is a first-semester capstone course for students majoring in Information Systems (IS) and either Computer Science, Finance or Informatics who wish not only to gain an understanding of project management issues but also experience the execution of such projects. The course thus combines the theoretical elements of project management (and people management) with the practical implementation of these concepts through the completion of a team project. The course integrates practical and theoretical elements obtained and developed in other undergraduate IS courses	10h00-10h45 Monday - Thursday and 10h00-11h45 Friday	Submission of required project work and a sub-minimum of 45% for the year mark prior to writing the final examination. In addition, students must have satisfactory attendance at tutorials and lectures.	Coursework counts 70%. Final examination counts 30%. Sub-minimum of 40% for the final examination.	Students cannot be credited for this course and for INF3003W.	INF3011F	INF	F	INF	F
INFORMATION TECHNOLOGY IN BUSINESS	18	6	T Chimboza	Successful completion of INF1002F/S and ACC1006F or equivalents. Course restricted to Commerce students.	\N	\N	Information Technology in Business (INF2004F) is offered to Accounting and Finance students in order to prepare them for a range of roles within the business environment. The course prepares students for a range of IT-related roles such as users, manager, designers, project managers and evaluators of information systems. The course covers the conceptual foundations, control, applications, and system development process of Accounting Information Systems. The course is linked with other courses: Foundations of Information Systems (INF1002F/S), Financial Reporting II (ACC2012W) and Governance, Audit and Assurance I (ACC2018H). The course has been developed to be in line with South African Institute of Chartered Accountants (SAICA) competency requirements.	Monday and Tuesday either 15h00-15h45 or 16h00-16:45.	Year mark greater or equal to 45% (based on all continuous assessment prior to the final exam) and 80% participation for all practicals (tutorials and workshops).	Coursework 60%, Final Examination 40% with a Sub-minimum of 40% for the final exam.	This course is not credited towards an Information Systems degree.	INF2004F	INF	F	INF	F
BUSINESS INTELLIGENCE AND ANALYTICS	6	6	A. Budree	INF1002 OR equivalent.	\N	\N	The course introduces students to the main features of business intelligence and business analytics, including data warehousing and data marts, decision support systems, OLAP, data mining and analytics, corporate performance management, data visualisation, real-time BI, pervasive BI, mobile BI and big data analytics. Case studies and management approaches for implementation are covered and a hands-on project requires students to produce a management report after analysing data using commercial BI software.	Course runs only for 3 weeks: Monday to Wednesday, 5th period, Friday 4th and 5th period	80% Class attendance.	Assessment requirements for both INF2006F and INF2007F need to be met in order to pass INF2008F.	\N	INF2006F	INF	F	INF	F
RESEARCH DESIGN IN ORGANISATIONAL PSYCHOLOGY	18	7	N Veldsman	This course is restricted to students in their third year of study or higher. The course is intended for students majoring in Organisational Psychology, but students from other streams/ faculties may choose this course as an elective.	\N	\N	This course aims to develop the foundational knowledge and skills required by the scientistpractitioner. To this end, we focus on the continual interplay between theory and application in our applied field. Students learn how to design empirical research projects to investigate and engage with current topics in Organisational Psychology. Topic selection is based on recent and emerging trends in research from academia and industry. This course will provide an applied overview of the research planning process, from the perspective of quantitative, qualitative, and mixed methods research approaches.	\N	None	Coursework (assignments and tests) 60%, Final examination 40%.	\N	BUS3003F	BUS	F	BUS	F
PROJECT IN MATHEMATICS	0	7	Associate Professor E Berdysheva	\N	\N	\N	With permission from the Convenor, and subject to the availability of a suitable supervisor in the Department, students may complete a project on a topic in Mathematics. This is strongly recommended for students intending to continue to Honours in Mathematics.	\N	\N	\N	\N	MAM3006Z	MAM	Z	MAM	Z
APPLYING DATABASE PRINCIPLES	12	6	W Chigona	INF1003F or equivalent, or INF1003F as co-requisite. Students cannot be credited for this course and CSC2001F.	\N	\N	The course introduces students to database concepts, advanced database design and implementation and new developments in the database field. These are core skills which I.S. professionals require throughout their careers. There is a strong practical component to the course, where students will be taught the practical aspects of designing, implementing and using databases. This course explores different database architectures and design approaches, data modelling techniques, data dictionaries, database implementation, database security and administration. The concepts are applicable to any development context, and the workshops ensure the students are able to apply this theory to real world applications.	Monday to Wednesday 12h00 - 12h45	Submit 80% of workshops; submitted all project work and a year-mark of 45%.	The final grade is derived from the following deliverables: Coursework: 60%; Final Exam 40%. Sub-minimum 45% for the final exam.	Assessment requirements for both INF2006F and INF2007F need to be met in order to pass INF2008F.	INF2007F	INF	F	INF	F
INTRODUCTION TO ORGANISATIONAL PSYCHOLOGY	18	5	B Arendse	This course is intended for students in the special field of Organisational Psychology, but students from other faculties may choose this course as an elective.	\N	\N	This course introduces students to the field of Organisational Psychology, which deals with the application of psychological theories and principles to solve problems in the workplace. It will focus on the major historical trends and research that have shaped the discipline, as well as current and future developments in the workplace. This course will also provide students with an understanding of why individuals in organisations behave in particular ways and how organisations can influence the behaviour of their employees.	\N	None	Coursework (assignments and tests) 60%, Final examination 40%.	\N	BUS1007S	BUS	S	BUS	S
INTRODUCTION TO ACTUARIAL SCIENCE	18	5	TBA	Admission to an Actuarial Programme.	\N	\N	The aim of the course is to provide an overview of the fields of actuarial science and quantitative finance. The central concept for both disciplines is the measurement and valuation of financial transactions with a component of uncertainty. Topics covered include risk assessment and management, different types of insurance, different types of asset classes. Students are introduced to financial mathematics and life contingency functions which enables them to value assets and insurance products. The course also addresses questions concerning professionalism and what it is to be an actuary/quant.	\N	Attempting all classwork and obtaining an overall average of 40%.	Tutorials and Assignments 15%; Tests 35%; Examination 50%.	\N	BUS1003H	BUS	H	BUS	H
DATABASE SYSTEMS	18	6	W Chigona	INF1003F or equivalent or INF1003F as co-requisite. Students cannot be credited for this course and CSC2001F.	\N	\N	The course combines INF2006F (weighted 33%) and INF2007F (weighted 67%). Please see course outlines for these courses. This course introduces students to database concepts, advanced database design and implementation and new developments in the database field. The main features of business intelligence and business analytics, including data warehousing and data marts, decision support systems, OLAP, data mining and analytics, corporate performance management, data visualization, real-time BI, pervasive BI, mobile BI and big data analytics are introduced. There is a strong practical component to the course, where students will be taught the practical aspects of designing, implementing and using databases. This course explores different database architectures and design approaches, data modelling techniques, data dictionaries, database implementation, database security and administration. The concepts are applicable to any development context, and the workshops ensure the students are able to apply this theory to real world applications. Case studies and management approaches for implementation are covered and a hands-on project requires students to produce a management report after analysing data using commercial BI software.	\N	80% attendance at workshops, completion of all course deliverables, year mark of 45%.	The course combines INF2006F (weighted 33%) and INF2007F(67%). Both need to be met in order for the student to pass INF2008F.	\N	INF2008F	INF	F	INF	F
SYSTEMS ANALYSIS	18	6	A Pekane	INF1003F or equivalent or INF1003F as co-requisite.	\N	\N	INF2009F is a half course designed for students intending to major in Information Systems or Computer Science for the BCom, BBusSci or Bsc degrees. Students pursuing other computing degrees may be accepted, space permitting. DEPARTMENTS IN THE FACULTY OF COMMERCE 181 This course explores the role of the Systems Analyst in business, different approaches used in the development of information systems, and the various tools and techniques used in the specification of system requirements. It is intended to provide students with an in-depth knowledge of the systems development process, with a particular emphasis on the analysis stage of the life cycle. There is a strong practical component to the course, where students will be taught to understand and use the common tools of object-oriented systems analysis, with a particular focus on UML models.	Monday to Wednesday, 4th period, Practical workshops: Thursday 3rd & 4th periods OR 4th & 5th OR 8th & 9th	Submitted at least 80% of the coursework (80% of individual deliverables and 80% of group work). Subminimum of 45% course year-mark.	The final grade is derived from results of the Coursework (Formative Assessment: 40% + Summative Assessment 20%) and the Final Examination (40%). Sub-minimum of 40% for the final examination.	\N	INF2009F	INF	F	INF	F
MARKETING IIA	18	7	TBA	BUS2010F/S	\N	\N	The course provides an opportunity for an in-depth study of Consumer Behaviour. The course is designed to focus on understanding how and why consumers make the decisions which they do when confronted with a buying decision. It attempts to use this information in guiding marketers to better design appropriate marketing strategies. While the course recognises the universality of consumer decision making, it puts this in a South African context.	\N	Students must obtain at least 50% for all class work (projects, assignments and tests) to be allowed to write examination. All the class work assessments must be completed.	Coursework (projects, assignments and tests) 50%, Final examination 50%	\N	BUS3041F	BUS	F	BUS	F
IT ARCHITECTURE	18	7	G Oosterwyk	Minimum 45% final mark for INF1003F or equivalent. Students cannot be credited for this course and CSC2002S	\N	\N	This course is intended to provide students with an in-depth knowledge of hardware, software, data communications and networking theory. This course is designed to build the skills required for the management and building of distributed systems and commercial networks. This course provides the hardware and software technology background required for understanding various computer architectures for single and multiple users. The analysis and design of networked applications is covered, including telecommunication devices, media, network hardware and software, network configuration and applications, network architectures, topologies and protocols, LAN and WAN networks, intranets and the Internet. The underlying architecture of modern computer hardware and operating systems, mobile computing, the cloud and basic computer security is also covered.	Monday to Wednesday 12h00 -12h45	Completing 80% of deliverables including quizzes, assignments (including the IT technical report) and semester test. Year mark of 45%.	The final grade is derived from the results of quizzes, assignments (including IT technical report) and the semester test which counts 60%; the Final Exam (40%)—sub-minimum of 45% for the final examination	\N	INF2010S	INF	S	INF	S
SYSTEMS DESIGN & DEVELOPMENT	18	7	D Snyman	Minimum 45% final mark for [INF2007 or INF2008 or CSC2001 or equivalent] and INF2009 and [INF1003 or CSC1016 or equivalent]	\N	\N	This course is intended to provide students with an in-depth knowledge of the systems development process with particular emphasis on the design and implementation stages of the life cycle. There is a strong practical component to the course, where students will use object - oriented tools to design and construct a working system. This course is designed to build on the skills acquired in INF2009F Systems Analysis.	Monday, Tuesday and Wednesday, 4th period, Thursday: Weekly workshop sessions 3rd to 4th OR 4th to 5th periods. Friday: Practical workshops 5th – 7th	Submit 80% of workshops and quizzes. Year-mark of 45%. Submitted all project work.	The final grade is derived from the following deliverables: Coursework: 60%; Exam 40%. Subminimum 45% for the final exam.	\N	INF2011S	INF	S	INF	S
ELECTRONIC COMMERCE	18	7	G Mwalemba	INF1003F, INF2009F and at least 45% for INF2011S	\N	\N	INF3014F is a course for students majoring in Information Systems (IS) as well as any other student that wish to gain an understanding of electronic commerce (e-Commerce) technologies and their usage in society. The course covers both theoretical e-Commerce issues as well as the practical skills required to develop a basic e-Commerce system. The course plays a role in facilitating students' ability to constructively develop integrated knowledge on e-Commerce, including an understanding of and the ability to apply and critically evaluate the key concepts, techniques and practices that form part of e-Commerce systems design, development, implementation and usage. The practical component includes planning, structuring, and developing e-Commerce related web applications as well as designing the user experience (UX). The practical component will culminate in a project that involves developing an e-Commerce application that addresses a real business or social need.	12h00-13h45 Tuesday and Wednesday and either 13h00-14h45 or 14h00-15h45 Friday	Submission of tutorials, seminar, and project work as well as a subminimum of 45% for the year mark prior to writing the final examination.	Coursework 70%. Exam 30%. Subminimum of 40% for the final examination.	\N	INF3014F	INF	F	INF	F
ACTUARIAL SCIENCE 1: FINANCIAL MATHEMATICS	18	6	S Mataramvura	BUS1003H* On a first attempt of a course only: ACC1006F and ACC1011S (60% average); or ACC1106F and ACC1111S (60% average); ECO1010F/S and ECO1011F/S (60% average); or ECO1110F/S and ECO1111F/S (60% average); STA1006S (65%); or STA1106H (65%); MAM1031F and MAM1032S (65% average);or MAM1005H and MAM1006H (65% average).ORSTA2004F and STA2005S (60% average); MAM2010F, MAM2011F, MAM2012S and MAM2014S (60% average);ORSTA1006S (65%); or STA1106H (65%); MAM2010F, MAM2011F, MAM2012S, and MAM2014S (60% average); MAM1031F and MAM1032S; or MAM1005H and MAM1006H; STA2004F and STA2005S;ORMAM1031F and MAM1032S (65% average); or MAM1005H and MAM1006H (65% average); STA2004F and STA2005S (60% average); STA1006S or STA1106H, MAM2010F, MAM2011F, MAM2012S and MAM2014S.	\N	\N	The course aims to provide a grounding in financial mathematics and simple applications with respect to non-random cash flows. Lectures and tutorials will cover aspects of cash flow models for financial transactions, compound interest and discounting, present values and accumulations of streams of payments, nominal and effective rates, equations of value, loan schedules, project appraisal techniques, compound interest problems and index linked securities, income and capital gains tax on fixed interest securities, arbitrage pricing and forward contracts, basic types of assets, pricing methods and the term structure of interest rates.	\N	At least 40% for coursework, 80% total tutorial attendance.	Tutorials (groupwork) 10%; Tests 30%; Examination 60% (42% written exam; 18% Excel-based exam).	\N	BUS2016H	BUS	H	BUS	H
AI: DEEP LEARNING	18	7	To be advised	CSC2001F, CSC2042S	\N	\N	The course builds on fundamental concepts in machine learning to introduce modern practical deep neural networks. Different neural network architectures are covered, including deep feedforward networks, convolutional and recurrent neural networks, and Transformers. There is a focus on the design and implementation of scalable deep learning systems. A selection of applications from Natural Language Processing and Computer Vision are included. Finally, ethics for machine learning is introduced through a number of case studies, covering issues such as dataset and algorithmic bias.	Monday – Friday, 3rd period, Practicals: One 4-hour practical per week, by arrangement	Minimum of 45% aggregate in practical work.	Tests 25%; practical work 25%; examinations 50%. Subminima: 45% for practicals, 45% weighted average of theory tests and examinations.	This course will only be offered from 2026.	CSC3042F	CSC	F	CSC	F
AI: REASONING IN AI	18	7	To be advised	CSC2041F, CSC2042S, CSC2001F	\N	\N	This course covers a selection of advanced topics in reasoning in Artificial Intelligence such as: reasoning through language with Large Language Models; visual reasoning with diffusion models; probabilistic reasoning with Bayesian networks; logic programming; and expert systems.	Monday – Friday, 3rd period, Practicals: One 4-hour practical per week, by arrangement	Minimum of 45% aggregate in practical work.	Tests 25%; practical work 25%; examinations 50%. Subminima: 45% for practicals, 45% weighted average of theory tests and examinations.	This course will only be offered from 2026.	CSC3043S	CSC	S	CSC	S
ORGANISATIONAL BEHAVIOUR	18	6	Z Zungu	This course is restricted to students in their second year of study or higher. The course is intended for students majoring in Organisational Psychology, but students from other streams/faculties may choose this course as an elective.	\N	\N	The practices and underlying theories covered in BUS2024F - Psychology of Human Resource Management (HRM) serve to recruit, develop and retain the best employees, and to ensure that people are treated fairly at their places of work. Whether or not employees perform to the best of their ability also depends on the interpersonal relationships they have at work. Human interactions are complex, and each relationship is unique, but if you understand human behaviour in organisations (called Organisational Behaviour (OB) you can create ways of interacting which are likely to result in effective working environments, that is, environments in which employees feel they are treated fairly, are committed to their work and motivated to contribute to the organisation’s success. OB is one of the areas which distinguishes work psychology from HRM: To understand human interactions you require a thorough knowledge of psychology. In this course, we will teach how to apply OB theory to understand the behaviour of people working in organisations, particularly under consideration of the South African workplace context, and to critically reflect on your own behaviour when working with others.	\N	None.	Coursework 60% (assignments, tests), Final examination 40%.	\N	BUS2023S	BUS	S	BUS	S
PSYCHOLOGY OF HUMAN RESOURCE MANAGEMENT	18	6	Z Zungu	This course is restricted to students in their second year of study or higher. The course is intended for students majoring in Organisational Psychology, but students from other streams/faculties may choose this course as an elective.	\N	\N	Broadly, human resource management (HRM) deals with the practices an organisation employs to manage its people so that they can best fulfil the organisation’s strategic goals. It includes the hiring, developing and retaining of employees and ensures their fair treatment. This course introduces students to HRM practices and considers how organisational psychology's understanding of human behaviour in workspaces informs these.	\N	None.	Coursework (assignments and tests) 60%, Final examination 40%	\N	BUS2024F	BUS	F	BUS	F
ORDINARY DIFFERENTIAL EQUATIONS (2OD)	12	6	To be advised	MAM1031F and MAM1032S or equivalent, MAM1043H and MAM1044H	MAM2010F and MAM2011F	\N	The course will cover first-order equations; existence and uniqueness of solutions. Linear equations of the n-th order; systems of n linear first-order equations. Non-homogeneous linear equations and systems; variation of parameters; qualitative theory of non-linear equations; phase plane analysis; externally- and parametrically-driven oscillators; resonance; application to the theory of non-linear vibrations. Calculus of variations. Please note that lectures alternate during the week so that students can take MAM2040F and MAM2041F concurrently.	Monday - Friday, 3rd period.	\N	\N	\N	MAM2040F	MAM	F	MAM	F
RESEARCH DATA ANALYSIS IN ORGANISATIONAL PSYCHOLOGY	18	7	N Veldsman	This course is restricted to students in their third year of study or higher. The course is intended for students majoring in Organisational Psychology, but students from other streams/ faculties may choose this course as an elective.	\N	\N	This course will equip students with an understanding of how to conduct quantitative and qualitative data analysis to inform Organisational Psychology practice. Students will gain skills to critically assess and empirically analyse research findings relating to the management of people in organisations. Additionally, students will be able to apply this learning to make effective decisions in a business/organisational environment.	\N	None	Coursework (assignments and tests) 60%, Final examination 40%.	\N	BUS3004S	BUS	S	BUS	S
MARKETING RESEARCH I	36	7	TBA	STA2020F/S; BUS2010F/S; ECO2003F and ECO2004S (or can be taken concurrently); MAM1002W OR MAM1010F and MAM1012S OR MAM1110F and MAM1112S	BUS3041F; BUS3043S; STA3022F	\N	The course aims to give students an in depth and practical understanding of Research in Marketing and prepare students for further commercial and scholarly research. It covers the stages of the research process including formulation of the problem, research design, data collection methods and forms, sample design, analysis and interpretation of data and report writing. A practical project will run concurrently with the lectures. Specific applications of Marketing Research are also covered.	\N	Minimum aggregate class work mark of 50%. Completion of all required project assignments. Attendance is compulsory for all tutorials.	Coursework (tutorials, group project and semester test) 70%, Final examination 30%. Sub-minimum of 45% in final examination to the course	\N	BUS3008W	BUS	W	BUS	W
PERSONAL FINANCIAL MANAGEMENT	18	6	TBA	Students must be in at least their 2nd year of study to register for the course. 3rd and 4th year students may also register for the course	\N	\N	The course introduces students to the fundamental principles of sound financial management at the individual level and equips them with the tools to ensure that they are better able to manage their personal finances. Topics covered include basic financial planning, time value of money, credit management, real estate, the basics of investing, personal income tax, medical schemes and insurance and estate and retirement planning. While the course provides a sound theoretical grounding in these topics, the focus is on practical application and real-world relevance.	Monday, Tuesday & Wednesday: 15h00 -15h45	Completion and submission of at least 80% of tutorial assignments and attendance at 80% of tutorial sessions, and 40% average year mark.	Assessment Weighting: Students will be required to complete weekly tutorial assignments and a Group Investment project (10%) will be prepared and submitted for grading. In addition to the project 10%, the balance of the marks are made up as follows: weekly objective tests 10% (best 5 out of 10 counts); two class tests 20% (2 x 10%) and final exam 60% will be written.	\N	FTX2000S	FTX	S	FTX	S
BUSINESS FINANCE	18	6	N Jwara	A DP in MAM1010 or equivalent, or a DP in STA1001F/S or equivalent	ACC1006F	The course is designed to provide an overview of activities, decisions, and techniques used to fund and manage businesses efficiently. The course also provides an introduction to investment and financial markets.	Business Finance serves as an introduction to the concepts of corporate finance. It covers the principles of corporate finance, commencing with mastery of the tools and techniques essential for financial management and proceeding to the principles underlying investment and financing decisions made by large corporations listed on a securities exchange. The course also aims to provide an entrepreneurial focus, equipping the prospective entrepreneurs with some of the quantitative decision making tools required for a successful business venture.	Tuesday, Wednesday, Thursday, and Friday: 15h00 -15h45.	Minimum 40% for coursework. This includes completion of all required submissions, tests and attendance of 9 out of 10 tutorials.	Students will be required to write two tests during the semester, each with a weight of 20%, and a final exam of 60%.	This course is NOT for students intending to major in Finance in a Commerce degree and is not a substitute for FTX2024F/S as a course entry requirement for further studies in Finance.	FTX2020F	FTX	F	FTX	F
MOLECULAR EVOLUTIONARY GENETICS & DEVELOPMENT	36	7	Dr S F Dube	MCB2020F, MCB2021F and MCB2022S or MCB2023S	\N	\N	This course provides advanced level studies in the area of molecular evolutionary genetics and development. Focus is placed on understanding key experiments in these fields and on interpreting data. Topics covered include: The origins and molecular genetics of viruses, principles of mouse molecular genetics applied to limb and neural development; evo-devo or how genetic change leads to morphological diversity; interactions between genetics, the environment and development.	Monday - Friday, 4th period	None	Tests count 40%; one 3-hour examination written in November counts 60%. A subminimum of 40% in the examination is required.	\N	MCB3023S	MCB	S	MCB	S
ACTUARIAL SCIENCE II MODELS	18	7	C Marais	BUS2016H, MAM2010F, MAM2011F, MAM2012S, MAM2014S, STA2004F, STA2005S, BUS1003H, unless course taken as part of a postgraduate degree.	\N	\N	The course aims to provide students with a solid foundation in stochastic processes and survival models, and their actuarial application. Topics covered include: Principles of actuarial modelling; principles and classification of stochastic processes; definition and application of Markov chains and processes; survival models; estimation of lifetime distributions; multiple states; single and multiple decrements; transition intensities and maximum likelihood estimators; binomial model of mortality; multiple state models; process of graduation; testing crude estimates; standard tables; assurances and annuities.	\N	Completion and timeous submission of tutorial exercises. Writing of all class tests. An overall average of 40% for classwork.	Tutorials and tests 40%; Examination (3 hour) 60%.	\N	BUS3018F	BUS	F	BUS	F
PROGRAMMING ASSESSMENT	0	6	Associate Professor S Berman	(CSC1015F and CSC1016S) or (CSC1010H and CSC1011H)	\N	\N	All students who take advanced courses in Computer Science need to build on a foundation of strong programming skills. The aim of this course is to assess and confirm mastery in fundamental programming skills before students can proceed to advanced courses.	\N	\N	Practical programming examination counts for 100%	This is a required course for all students majoring in Computer Science and/or who wish to continue to any third year courses in Computer Science. It should be taken in the second year of study and will demonstrate competency in programming, which is assumed in all third year courses. It is a compulsory course in the Computer Science major CSC05.	CSC2004Z	CSC	Z	CSC	Z
ACTUARIAL SCIENCE II CONTINGENCIES	18	7	C Marais	BUS3018F, MAM2010F, MAM2011F, MAM2012S, MAM2014S, STA2004F, STA2005S, BUS2016H, BUS1003H, unless taken as part of a postgraduate degree.	\N	\N	The course aims to provide a grounding in the mathematical techniques used to model and value cash flows dependent on death, survival or other uncertain risks. Topics covered include: Simple assurance and annuity contracts; more complex contracts (increasing benefits); derivation of formulae for means and variances of benefit payments; definition of standard actuarial symbols and the relationships between them, including standard life table functions (ultimate and select); calculation of net premiums and net premium provisions (prospective and retrospective); calculation of death strain at risk, actual and expected death strains, mortality profit; calculation of gross premiums; functions involving two lives; cash flow models; discounted emerging costs; practical application using MS Excel.	\N	Completion and timeous submission of tutorial exercises. Writing of all class tests. An overall average of 40% for classwork.	Tutorials and tests 40%; Examination 60%.	\N	BUS3024S	BUS	S	BUS	S
INTRODUCTION TO PROJECT MANAGEMENT	18	7	M Hoffman	Students should be in their 3rd year of a BCom or BBusSc or be registered for a Postgraduate Diploma in Management, or be an SSA student.	\N	\N	The key objective of this course is to provide a general introduction to Project Management for Commerce students. Students are introduced to the Project Life Cycle and the project management methodology as outlined in the Project Management Book of Knowledge (PBOK). Students registered for this course will be required to apply the project management process to new product development, with the practical group project focusing on doing a feasibility study for a new product. Particular emphasis is placed on quality, both as an important element of product development but equally important as an element of project management process.	\N	Completion of all coursework assessments.	Coursework 100%.	\N	BUS3038S	BUS	S	BUS	S
MARKETING IIB	18	7	TBA	BUS2010F/S	\N	\N	The Integrated Marketing Communication module aims to provide an overview of marketing communications so that students develop an understanding of, and insight into, the industry, its processes and its role as a business tool. Students will be equipped with the skills to formulate a marketing communication strategy. This course will focus on providing students with an understanding of the different marketing communication tools, the media involved with these, and how these activities form part of the overall marketing strategy. The course will cover traditional and new marketing communication tools, the importance of marketing communication tools, the importance of marketing insights in marketing communication strategy development, advertising and media, as well as the theoretical creative approaches to integrated marketing communications.	\N	Attendance and participate in a minimum of 80% of all tutorial classes. Students must obtain at least 50% for all class work (projects, tests and assignments) to be allowed to write the examination.	Coursework (projects, assignments and tests) 50%, Final examination 50%	\N	BUS3043S	BUS	S	BUS	S
SOCIAL IMPACT ENTERPRISE (SIE)	18	7	S Hendry	Registration for a Postgraduate Diploma in Management in the School of Management Studies or be in the 3rd Academic Year of Study (AYOS) in the Faculty of Commerce or be an approved SSA student.	\N	\N	Students will be introduced to current thinking and trends in entrepreneurship, with a specific focus on social entrepreneurship. The course is designed to provide students with an understanding of the key processes, challenges and experiences of initiating and delivering a profitable business venture that also has a positive and transformative impact on society. Through a combination of focussing on entrepreneurial leadership, agile project management and working with a “real” client on case studies and “live” projects, students will learn how to identify the key elements of successful social enterprises, integrate various elements of the social entrepreneurship ventures and evaluate and mobilise resources needed for activation. By the end of the course, students will be able to:  Understand the transformation imperative that exists in South Africa  Understand the role that social entrepreneurship can play in leading this transformation  Identify key elements of successful social enterprises  Design creative problem-solving strategies aimed at solving real challenges in a real organisation.	\N	All lectures and workshops are compulsory. Students must satisfactorily submit both their group and individual assignments and obtain at least a weighted overall average of 40% for their course work.	70% for formative assessments: Individual Assignment 1 – 10%; Class Participation Mark – 10%; Group Contract – 5%; Client MOU – 5%; Research and Report Writing Plan – 10% and Final Report – 30%.30% for summative assessment. Minimum of 40% in final examination.	\N	BUS3095S	BUS	S	BUS	S
CLIMATE CHANGE & PREDICTABILITY	23	9	Professor B Hewitson	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course explores the theory of climate change, and then goes into the question of predictability, cross scale relationships and feedbacks in the climate system, the tools and techniques of prediction, and translation of predictions into the user community including impacts and vulnerability analyses and touching on the social dimension. At the NQF 9 level students will be expected to compose reports with a higher word count, at a higher intellectual level and with an expectation of a more comprehensive understanding of the pertinent literature. Students at this level will be expected to display a greater commitment and engagement in the oral components of the course.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5038S	EGS	S	EGS	S
BUSINESS LAW II	12	6	*J Franco	Business Law I. No undergraduate student in the first year of study may register for Business Law II.	\N	\N	Business law 2 is designed to give students an understanding of commercial transactions, how they are financed, and the risks involved. The course covers insolvency, credit agreements, stokvels and the various forms of security that can be used to finance commercial transactions. By the end of the course, students should have an appreciation of the types of legal issues that commonly arise in financing transactions – how creditors can best secure themselves in the event of non-payment and ultimately the risk of insolvency and how debtors are protected under the National Credit Act. The course also covers public sector financial management, looking specifically at the legal obligations set out in the Public Finance Management Act 1999 and the Municipal Finance Management Act 2003 and related laws.	The course is an intensive one with 5 contact periods per week for 8 weeks in Semester 2.	Writing the test is compulsory. If a student does not write the test and does not get an exemption then the student will be marked absent and awarded 0 for the test. But the student will be able to write the exam.	Coursework 30% and final examination 70%	\N	CML2010Z	CML	Z	CML	Z
FOUNDATIONS OF COMPUTER PROGRAMMING FOR ENGINEERS	12	5	A Safla	\N	\N	\N	This course offers an introduction to the development of algorithms and design of computer programs and provides an introduction to programming and algorithms, using the Python programming language. Topics include: basic syntax, variables, operators, comments, expressions, strings, input and output; conditional statements, if, nested ifs, if-else ladders, Boolean expressions; loops, for and while, nested loops; functions, parameters, return values; arrays and lists, multidimensional arrays and text files. The course is offered in a blended-learning format: students are provided with a set of online video lectures and contact time is in a tutorial/practical format aimed at reinforcing the principles introduced in the online lectures and giving students time to do exercises under the supervision of tutors.	\N	45% weighted average for practical work.	Theory tests count for 20%, practicals count for 20%, practical tests count for 10%, June examination counts for 50% of the course mark. Subminima: 45% weighted average for practical work, 45% weighted average of tests and exams.	\N	CSC1019F	CSC	F	CSC	F
INVESTMENT MANAGEMENT A	18	7	A Charteris	A pass in FTX2024F/S and passes ACC1011S/ACC2011S, MAM1012S (or equivalent), ECO1010F/S or ECO1110F/S and ECO1011F/S.	STA2020F/S or an approved equivalent	To build on the knowledge gained in Financial Management, and to give students a thorough grounding in equities, portfolio theory and investment ethics.	The course seeks to provide students with a solid foundation in investment theory. The course is split into three modules namely, equities, portfolio theory and investment ethics. The equities module gives students a practical understanding of issues in the valuation and trading of equities and covers basic equity valuations and analysis. The portfolio theory module focuses on the investment decision- making framework, the notions of risk and return, and the theories of efficiency. Investment ethics exposes students to some of the ethical dilemmas of the investment profession and provides a set of guidelines within which these ethical issues can be considered.	Monday, Tuesday, Wednesday, Friday: 11h00 - 11h45 or 12h00 – 12h45	A minimum weighted average of 40% for all coursework and attendance at 80% of tutorials.	Coursework (including tests and assignments) 50%; final examination 50%.	\N	FTX3044F	FTX	F	FTX	F
AI: AUTOMATED PLANNING AND CONTROL	18	7	To be advised	(CSC2041F or CSC2042S), CSC2001F	\N	\N	This course provides an introduction to problem solving by searching: uninformed search, heuristic search, and adversarial search for games are covered. Introduction to reinforcement learning: Markov Decision Processes for sequential decision making, passive and active reinforcement learning, policy search and data-driven control techniques. The course also covers applications in game playing, planning in interactive environments, and robot navigation and control.	Monday – Friday, 3rd period, Practicals: One 4-hour practical per week, by arrangement	Minimum of 45% aggregate in practical work.	Tests 25%; practical work 25%; examinations 50%. Subminima: 45% for practicals, 45% weighted average of theory tests and examinations.	This course will only be offered from 2026.	CSC3041F	CSC	F	CSC	F
INVESTMENT MANAGEMENT B	18	7	A Sayed	A pass in FTX2024F/S and passes ACC1011S/ACC1020H and ACC2011S, MAM1012S (or equivalent), ECO1010F/S or ECO1110F/S and ECO1011F/S	STA2020F/S or an approved equivalent	To build on the knowledge gained in Financial Management, and to give students a thorough grounding in Fixed Income Securities, Derivatives and Financial Risk Management, and Behavioural Finance.	The course is divided into three modules that seek to provide students with a solid foundation of investment theory and its practical application. The modules covered include, Fixed Income Securities, Derivatives and Financial Risk Management, and Behavioural Finance. The Fixed Income Securities module is intended to provide a practical introduction to the valuation, analysis and management of fixed income securities. The Derivatives and Financial Risk Management module focuses on providing students with an overview in practical application of the valuation of derivative securities. The Behavioural Finance module explores the psychological biases and decision making processes that influence the investor behaviour and impacts financial markets.	Monday, Tuesday, Wednesday & Friday: 11h00 - 11h45 or 12h00 - 12h45	Satisfactory completion of all required assignments and tests. Sub-minimum for coursework of 40% and attendance at 80% of the tutorials. Please note that these requirements will be strictly enforced.	Coursework (including tests and assignments) 50%; final examination 50%.	\N	FTX3045S	FTX	S	FTX	S
BUSINESS LAW I	18	5	B Zungu	\N	\N	\N	The purpose of the course is to provide students with a general introduction to the South African legal system, with its main focus the law of contract. The course starts with an overview of the South African court structure and contemporary sources and branches of South African law, and also introduces students to the Constitution and the impact that it continues to have on legal development. The course then provides students with a general but comprehensive introduction to the general principles of contract, focusing on formation of contracts, the content of contracts, breach of contract and remedies for breach. The course also aims to provide students with an introduction to certain specific contracts, most notably contracts of sale, lease and agency. The general principles of contract are supplemented by a consideration of legislation, in particular the provisions of the Consumer Protection Act, where relevant.	The course is an intensive one, with 5 contact periods per week for the full semester.	Coursework is compulsory. If the student does not submit hand-ins or write a test the student will receive a mark of 0 for that assessment (unless granted an exemption). But the student will be able to write the exam.	Coursework 40%; final examination 60%.	\N	CML1004S	CML	S	CML	S
COMPANY LAW	18	6	Dr M Maphiri	Business Law 1 and no undergraduate student in his/her first year of study may register for Company Law.	\N	\N	The course offers an overview of the laws that govern the nature, formation, and management of partnerships, trusts, companies and close corporations with the main focus being on companies. Students are encouraged to apply the analytical abilities acquired in previous law courses and these skills are further developed. After the course students will be able to, amongst others, navigate the Companies Act 71 of 2008 and will be familiar with its core provisions and their practical impact.	The course is an intensive one with 5 contact periods per week for the full semester.	Coursework is compulsory. If the student does not submit hand-ins or write a test the student will receive a mark of 0 for that assessment (unless granted an exemption). But the student will be able to write the exam.	Coursework 40%; final examination 60%.	\N	CML2001F	CML	F	CML	F
COMPANY LAW - SUMMER TERM	18	6	TBA	No undergraduate student in the first year of study may register for Company Law. Business Law I is a prerequisite for Company Law, and students cannot register for Company Law unless they successfully completed Business Law I in the previous year of study.	\N	\N	Refer to course outline for CML2001F.	Lectures are offered on a daily basis for three hours over a four-week period	Writing the test is compulsory. If a student does not write the test and does not get an exemption then the student will be marked absent and awarded 0 for the test. But the student will be able to write the exam.	Test 40%; final examination 60%.	\N	CML2001P	CML	P	CML	P
LABOUR LAW	18	6	L Mkhwanazi	No undergraduate student in his/her first year of study may take Labour Law. It is recommended that students have passed a foundation course in law, e.g. Business Law I.	\N	\N	This course aims to provide students with an understanding of the common law contract of employment and labour law statutes; including the Labour Relations Act; Basic Conditions of the Employment Act; and the Employment Equity Act. The course will specifically focus on the following issues that commonly arise in the workplace: the legal definition of ‘employee’; discipline and dismissals; unfair labour practices; unfair discrimination in employment and recruitment and selection; employment equity issues; collective bargaining; strikes and lock-outs; and dispute resolution.	This course is an intensive one, with 3 lectures per week for the full semester.	Coursework is compulsory. If the student does not submit hand-ins or write a test the student will receive a mark of 0 for that assessment (unless granted an exemption). But the student will be able to write the exam.	Coursework 40%; final examination 60%.	\N	CML2005F	CML	F	CML	F
BUSINESS LAW I	18	5	K Lehmann 	\N	\N	\N	The purpose of the course is to provide students with a general introduction to the South African legal system, with its main focus the law of contract. The course starts with an overview of the South African court structure and contemporary sources and branches of South African law, and also introduces students to the Constitution and the impact that it continues to have on legal development. The course then provides students with a general but comprehensive introduction to the general principles of contract, focusing on formation of contracts, the content of contracts, breach of contract and remedies for breach. The course also aims to provide students with an introduction to certain specific contracts, most notably contracts of sale, lease and agency. The general principles of contract are supplemented by a consideration of legislation, in particular the provisions of the Consumer Protection Act, where relevant.	The course is an intensive one, with 5 contact periods per week for the full semester.	Coursework is compulsory. If the student does not submit hand-ins or write a test the student will receive a mark of 0 for that assessment (unless granted an exemption). But the student will be able to write the exam.	Coursework 40%; final examination 60%	\N	CML1001F	CML	F	CML	F
AI: AI SYSTEMS	18	7	To be advised	CSC2001F, CSC2041F, CSC2042S, (CSC3041F or CSC3042F)	\N	\N	This course provides an overview of agent architectures: cognitive architectures; software agents such as collaborative and information-gathering agents; as well as human-agent interaction and societal impacts of AI systems. Students will apply these concepts through a practical AI system development capstone project.	Monday – Friday, 3rd period, Practicals: One 4-hour practical per week, by arrangement	Minimum of 45% aggregate in practical work.	Tests 25%; practical work 25%; examinations 50%. Subminima: 45% for practicals, 45% weighted average of theory tests and examinations.	This course will only be offered from 2026.	CSC3044S	CSC	S	CSC	S
COMPUTER SCIENCE 1010	18	5	G Stewart	The permission of the Dean or Head of Department is required prior to registration for this course.	\N	\N	This course is an introduction to problem solving, algorithm development and programming in the Python language. It includes fundamental programming constructs and abstractions, sorting and searching techniques, and machine representations of data. The practical component covers input/output, conditionals, loops, strings, functions, arrays, lists, dictionaries, recursion, text files and exceptions in Python. Students are taught testing and debugging, as well as sorting and searching algorithms, algorithm complexity and equivalence classes. Number systems, binary arithmetic, boolean algebra and logic gates are also introduced	Monday - Friday, 5th period, Tutorials: One per week, replacing one lecture, Practicals: One per week, Thursday, 14h00 - 17h30	Minimum of 45% aggregate in practical work.	Theory tests count 15%; practical tests and practical assignments count 25%; one 2-hour examination written in November counts 60%. Subminima: 45% for practicals, 45% on weighted average of theory tests and examination.	This course only begins in week 7 and is intended for students who have been advised to transfer to this course after initially registering for CSC1015F (see entry for CSC1015F). The course places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. CSC1010H is equivalent to CSC1015F in level, credit value towards the degree and as prerequisite for certain other courses.	CSC1010H	CSC	H	CSC	H
COMPUTER SCIENCE 1011	18	5	G Stewart	CSC1010H	\N	\N	The first half of the course aims to further develop problem solving and programming in Python. The second half focuses on object-oriented design and programming in Java, covering object-oriented design techniques and UML diagrams, as well as elementary data structures such as lists, stacks and queues, as well as introducing important considerations relating to Human Computer Interaction and interface design. The practical component includes use of inheritance, polymorphism, interfaces, generics and GUI programming in Java.	Monday - Thursday, 4th period, Tutorials: One per week, replacing one lecture, Practicals: One per week, Monday, 14h00 - 16h00	Minimum of 45% aggregate in practical work.	Theory tests count 25%; practical tests and practical assignments count 25%; one 2-hour examination written in November counts 50%. Subminima: 45% for practicals, 45% on weighted average of theory tests and examination.	This course follows on from CSC1010H and also places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. CSC1011H is equivalent to CSC1016S in level, credit value towards the degree and as prerequisite for certain other courses.	CSC1011H	CSC	H	CSC	H
COMPUTER SCIENCE 1016	18	5	A Safla	CSC1015F (At least 45% for CSC1015F or at least 70% for CSC1017F)	\N	\N	This course builds on the foundation of CSC1015F/CSC1010H, with a focus on object-oriented design and programming in Java, as well as introducing important considerations relating to Human Computer Interaction and interface design. The Java component of the course covers object-oriented design techniques and UML diagrams, as well as elementary data structures such as lists, stacks and queues. The practical component includes use of inheritance, polymorphism, interfaces, generics and GUI programming in Java.	4th or 5th period daily, Tutorials: One per week, replacing one lecture, Practicals: One per week, Monday, Tuesday or Wednesday, 14h00 - 16h00 or 16h00 - 18h00	Minimum of 45% aggregate in practical work.	Theory tests count 15%; practical tests and practical assignments count 25%; one 2-hour exam written in November counts 60%. Subminima: 45% for practicals and 45% on weighted average of theory tests and examination.	\N	CSC1016S	CSC	S	CSC	S
INTRODUCTION TO PROGRAMMING	16	5	A Safla	\N	\N	\N	This course aims to provide an introduction to programming and algorithms, using the Python programming language. Topics to be included will be: basic syntax, variables, operators, comments, expressions, strings, input and output; conditional statements, if, nested ifs, if-else ladders, Boolean expressions; loops, for and while, nested loops; functions, parameters, return values; testing and debugging; arrays and lists, multidimensional arrays; sorting and searching; text files; and number systems. The course is offered in a blended-learning format: students are provided with a set of online video lectures and contact time is in a tutorial/practical format aimed at reinforcing the principles introduced in the online lectures and giving students time to do exercises under the supervision of tutors.	\N	45% weighted average for practical work.	Theory tests count for 20%, practicals count for 20%, practical tests count for 10%, June examination counts for 50% of the course mark. Subminima: 45% weighted average for practical work, 45% weighted average of tests and exams.	\N	CSC1017F	CSC	F	CSC	F
COMPUTER SCIENCE 2001	24	6	F Meyer	(CSC1015F and CSC1016S) or (CSC1010H and CSC1011H)	\N	\N	This course builds on the first year Computer Science foundation with an emphasis on data storage and manipulation. The course covers abstract data types and assertions, recursive algorithms, tree structures such as AVL and B-trees, graph traversals, minimum spanning trees, sets, hashing and priority queues. An introduction to conceptual modelling, database design and relational database manipulation is included. Practical programming in Java in a Unix environment is an important part of the course	Monday - Friday, 2nd period, Four or five lectures per week, Practicals: One 4-hour practical per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests 20%; practicals and practical test 30%; exam 50%. Subminima: 45% on weighted average of theory tests and examination.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC2001F	CSC	F	CSC	F
COMPUTER SCIENCE 2002	24	6	Associate Professor S Berman	CSC2001F (At least 45% for CSC2001F)	\N	\N	The aim of this course is to build on the foundational concepts covered in CSC2001F, with further necessary core topics of an undergraduate Computer Science curriculum. These topics comprise: concurrent and parallel computing (including practical work in Java); computer architecture; an introduction to Society, Ethics, and the Profession (covering ethical issues such as property rights, freedom of expression and privacy, free and open source software); and Theory of Computing (including Turing Machines and the limits of computation).	Monday - Friday, 2nd period, Four lectures per week, Practicals: One 4-hour practical per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests 20%; practicals and practical test 30%; exam 50%. Subminima: 45% on weighted average of theory tests and examination.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC2002S	CSC	S	CSC	S
ANTHROPOCENE ENVIRONMENTS IN PERSPECTIVE	36	7	Dr D Kibirige	EGS2013F	\N	\N	The course deals with the dynamic physical environment including the human impact on global environments at various spatial and temporal scales during the so-called Anthropocene. The general aim of this course is to illustrate the nature and scale of changes that characterise the earth’s environment, against a background of both natural and anthropogenically-induced processes. This provides an important perspective when thinking about contemporary environments and how they might change in the future – with obvious consequences for our own species and that of the others with which we share the planet.	Monday - Friday, 5th period	Satisfactory completion of practicals and all written assignments, including fieldwork report, essays and class tests. Students must attain an average mark of not less than 40% for the coursework.	Field report, essays, class tests and practical assignments count 50%; one 3-hour examination written in June count 50% (sub-minimum of 40% required).	\N	EGS3023F	EGS	F	EGS	F
INTRODUCTION TO AI 1: KNOWLEDGE REPRESENTATION	24	6	Dr Z Mahlaza	CSC1015F/S, CSC1016S, MAM1031F, MAM1032S, (MAM1019H or STA1000X or MAM1008S)	\N	\N	The course introduces the field of Artificial Intelligence and then covers the fundamentals of knowledge representation and reasoning as a paradigm for Artificial Intelligence. It includes relevant topics such as logical agents and the creation of symbolic and logical representations from problem statements. Inference in propositional and first-order logic are used to build upon the fundamentals of computational logic and automated reasoning. An overview of core algorithms for knowledge representation (e.g., tableau, case-based, constraints, SAT solving) is given. Approaches to handling uncertainty in knowledge representation and reasoning are introduced through random variables, probabilistic inference, and the framework of utility functions for decision making.	Monday - Friday, 3rd period, Four lectures per week, Practicals: One 4-hour practical per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests 25%; practicals and practical test 25%; examination 50%. Subminima: 45% on weighted average of theory tests and examination.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC2041F	CSC	F	CSC	F
INTRODUCTION TO AI 2: MACHINE LEARNING	24	6	Dr J Buys	CSC1015F/S, CSC1016S, MAM1031F or MAM1004F	\N	\N	Machine learning is introduced as a paradigm for Artificial Intelligence. Fundamental machine learning algorithms are introduced, and students implement a subset of those using the Python programming language and modern machine learning frameworks in Python. There is a focus on problem formulation, feature representations and evaluation.	Monday - Friday, 3rd period, Four lectures per week, Practicals: One 4-hour practical per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests 25%; practicals and practical test 25%; examination 50%. Subminima: 45% on weighted average of theory tests and examination. Third-Year Courses	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC2042S	CSC	S	CSC	S
COMPUTER SCIENCE 3002	36	7	Associate Professor P Marais	CSC2001F, CSC2002S, CSC2004Z and ((MAM1004F+MAM1008S) or (MAM1000W) or (MAM1031F or equivalent)).	\N	\N	The course provides an introduction to the structure and organization of operating systems, and computer networks including various logical layers of the ISO OSI layers, focusing on the Internet Protocol suite.	Monday - Friday, 2nd period, Practicals: Two 4-hour practicals per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests count 15%; practical work counts 35%; one 3-hour paper written in June counts 50%. Subminima: 45% for practicals; 45% on weighted average of theory tests and examinations.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC3002F	CSC	F	CSC	F
COMPUTER SCIENCE 3003	36	7	Associate Professor P Marais	CSC2001F, CSC2002S, CSC2004Z and ((MAM1004F+MAM1008S) or (MAM1000W) or (MAM1031F or equivalent)).	\N	\N	This is a course on two advanced topics: (1) advanced software design is about turning requirements into effective and efficient implementations in a systematic manner; and (2) the algorithms module expands on a topic central to computing. This module describes how algorithms are categorised, and shows interesting algorithms in each category and analyses their complexity. It also touches on Turing machines and the limits of computation.	Monday - Friday, 2nd period, Practicals: Two 4-hour practicals per week, Monday - Friday, 14h00 - 18h00	Minimum of 45% aggregate in practical work.	Tests count 15%; practical work counts 35%; one 3-hour paper written in November counts 50%. Subminima: 45% for practicals, 45% on weighted average of theory tests and 35% for the algorithms module (comprising Theory of Algorithms and Theory of Computation) in the final examination.	Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at https://internal.cs.uct.ac.za/teaching/laptop_requirement.html (a tablet will not be suitable). The course convenor will provide details of additional software (open source) required.	CSC3003S	CSC	S	CSC	S
C++ AND MACHINE LEARNING	36	7	Dr J Buys	CSC2001F, CSC2002S, CSC2004Z and ((MAM1004F+MAM1008S) or (MAM1000W) or (MAM1031F or equivalent)).	\N	\N	This course introduces the C++ programming language, followed by an exploration of topics in machine learning. Students are exposed to different aspects of C++ including templates and functional programming and an in-depth study of the C++ memory model. A basic introduction to a widely used Python ML framework is then provided. A number of machine learning algorithms are introduced and students implement a subset of these using the Python framework. By the end of the course, students should understand how to write efficient object-oriented programs in C++, and also be familiar with major categories of learning algorithms, and be able to select and implement the most appropriate algorithm for a given problem in Python.	Monday – Friday, 3rd period, Practicals: Two 4-hour practicals per week, by arrangement	Minimum of 45% aggregate in practical work.	Tests count 16.7%; practical work counts 33.3%; examinations count 50%. Subminima: 45% for practicals, 45% weighted average of theory tests and examinations.	This course will not be offered after 2025.	CSC3022F	CSC	F	CSC	F
CREATING SUSTAINABLE IMPACT	12	5	Dr J von Holdt	\N	Any one of CIV4041F, CIV4042F, CIV4045F and CIV4046F	\N	Sustainability is one of the most important concepts to date and is critical to address the challenges we face in the Anthropocene. Challenges such as climate change, biodiversity loss, resource depletion, pollution and social inequity can only be addressed by adopting transformative changes in policies, behaviours and systems that foster sustainability. This course will explore the critical role engineers play in society and the impact of their activities on the social, industrial (workplace) and physical environment. We will explore a range of relevant topics, including key concepts of and the rationalefor sustainability (which remains a contested concept with many potential definitions), basic climate science and the implications of climate change, mitigating pollution (water/air/soil), sustainable urban practice, assessing risk and managing impacts, and environmental assessment and management tools. Throughout the course, students will critically engage and reflect on the practice of engineering and develop a deep appreciation for the interconnectedness of environmental, social, and economic sustainability. The course includes practical sessions, case studies, field trips and a course project.	\N	\N	A class test, practical assignments and field report count 50%; one 2-hour examination written in June count 50% (sub-minimum of 40% required).	\N	EGS1005F	EGS	F	EGS	F
HUMAN & PHYSICAL SYSTEMS	18	7	To be advised	At least 50% for NSC Geography or GEO1009F	\N	\N	The course presents fundamental environmental and geographical concepts from the fields of human and physical geography and explores the interconnections, flows and boundaries across these systems. How these systems have played out in the past, how they are changing, and what the future may hold, is critical to a full appreciation of current and future environmental challenges. This course seeks to bring together an understanding of both the biophysical geographic settings and processes that inform all facets of our landscapes, and the social engagement with their components, which present both opportunity and limitation to human development.	Monday - Friday, 2nd period	Attendance and satisfactory completion of tutorial assignments; students must attain an average mark of not less than 40% for the coursework component.	Essays, assignments and tutorial work count 60%; one 2-hour theory examination written in November counts 40% (subminimum of 40% required). Second-Year Courses	\N	EGS1007S	EGS	S	EGS	S
THE PHYSICAL ENVIRONMENT	24	6	Professor F Eckardt	GEO1009F	\N	\N	The course focuses on contemporary Atmosphere-Earth surface interactions, in particular the role of precipitation and water from a global to a regional scale and examines temporal dynamics, driven by natural process as well as anthropogenic pressures. It covers in detail global circulation patterns, climate variability, soil formation, polar response to climate change, informants of regional biome formation, tropical deforestation, and desertification and earth observation technology. It is expected that students will enhance their understanding of Earth system dynamics, systems interactions and develop an appreciation for scales both temporal and spatial. Students are also expected to put the local context into a regional setting and make linkages to the larger global picture.	Monday - Friday, 5th period	Satisfactory completion of practicals and all written assignments, including projects, fieldwork reports, practicals, essays and class tests. Students must attain an average mark of not less than 40% for the coursework.	Project, essays, class tests and practical assignments including fieldwork report count 50%; one 3-hour examination written in June count 50% (subminimum of 40% required).	There is a compulsory fieldwork component involving half-day field excursions.	EGS2013F	EGS	F	EGS	F
SOCIETY & SPACE	24	6	Associate Professor J Battersby	For BSc: EGS1007S; For BA or BSocSc: EGS1007S or Social Science Foundation course and two full first year Humanities courses, or equivalent.	\N	\N	Spatial thinking sits at the core of Geographical scholarship, and space and human societies are always mutually constitutive. This course explores how geographers have theorised space and place as central to understanding historical processes, social relations and cultural practices. Focusing particularly on Africa and other regions of the global South, the course covers foundational Human Geography concepts including modernity, landscape, memory, heritage, identity and inclusion. Through theoretical work and field-based experiential learning, we examine how space and place both shape and are shaped by a range of power dynamics.	Monday - Friday, 5th period	Attendance and satisfactory completion of practical including fieldwork and tutorial assignments; students must attain an average mark of not less than 40% for the coursework.	Essays, a class test, practical assignments based on compulsory fieldwork and tutorial work count 60%; one 2-hour theory examination written in November counts 40%. In order to pass the course, you are required to obtain an average mark of at least 50% across all submissions. Third-Year Courses	There is a compulsory fieldwork component involving half-day field excursions.	EGS2015S	EGS	S	EGS	S
ATMOSPHERIC SCIENCE	36	7	To be advised	GEO1009F or equivalent, EGS2013F or SEA2004F (or SEA2002S or SEA2003F) or any approved 2000-level Science course, and or any approved 1000-level Physics or Mathematics course.	\N	\N	This course aims to provide a thorough understanding of the physical processes that control the Earth's atmosphere. It covers the following topics: atmospheric energy balance, thermodynamics, dynamics, and general circulation; tropical and mid-latitude weather producing systems; weather and climate extreme events (e.g. heat-waves, drought, and floods) in Africa; climate variability and change; atmospheric boundary layer turbulence, chemistry, and pollution. The lectures are complemented with field measurements and laboratory practicals to demonstrate basic data analysis techniques employed in atmospheric sciences.	Monday - Friday, 1st period	Satisfactory completion of practicals and all written assignments, including essays, project reports and class tests.	Essays and tests count 20%; project reports and practicals count 20%; one 3-hour examination in November counts 60% (subminimum of 40% required).	\N	EGS3012S	EGS	S	EGS	S
GEOGRAPHIC THOUGHT	36	7	Associate Professor Z Patel	EGS2015S	\N	\N	The course focuses on debates in classical and contemporary human geography. It considers important thematic areas in the geographical literature, such as development; spatiality; urban, political and feminist geographies. Each thematic area explores specific debates and key author’s work in the field, providing students with an introduction to literature, a content overview, and skills to deconstruct and build conceptual and analytical arguments related to evidence drawn from geographical research from around the world, other than South Africa. The course also emphasises academic reading and writing skills taught in the practical sessions.	Monday - Friday, 4th period	Satisfactory completion of essay and practical assignments and participation in tutorials; students must attain an average mark of not less than 40% for the coursework	Essay and other assignments count 70%; one 3-hour written examination in November count 30% (subminimum of 40% required).	\N	EGS3022S	EGS	S	EGS	S
DIFFERENTIAL EQUATIONS (2DE)	12	6	T C Van Heerden	MAM1031F and MAM1032S or equivalent, MAM2010F and MAM2011F.	\N	\N	Students will study the fundamentals of differential equations, including topics from: First and second- order difference equations; Linear differential equations, constant coefficients; Laplace transforms; Nonlinear equations, phase plane analysis; Parabolic partial differential equations, separation of variables, boundary value problems; Black-Scholes equation; Stochastic differential equations. Please note that lectures alternate during the week so that students can take any of MAM2012S, MAM2013S and MAM2014S concurrently.	Tuesdays, Fridays and some Wednesdays in 4th period.	\N	\N	\N	MAM2012S	MAM	S	MAM	S
MATHEMATICS 1004	18	5	T C Van Heerden	At least 70% in NSC Mathematics. Students registered in other faculties who do not meet the 70% NSC requirement may instead complete MAM1014F/MAM1022F followed by MAM1015S with a mark of 70% or higher to gain entry to MAM1004F and MAM1004S. Students who fail MAM1004F are expected to register for MAM1004S in the 2nd semester.	\N	\N	The aim of this course is to provide mathematics for applications, particularly in the Life and Earth sciences. The syllabus covers the following topics: Functions and graphs. Straight lines, power functions, polynomials, exponential and logarithmic functions, trigonometric functions (radians). Discrete-time dynamical systems. Stability and equilibria. Rates of change. Limits, derivatives. Maxima and minima. Concavity. Asymptotes and curve sketching. Antiderivatives and integrals. Mathematical modelling. Separable and linear differential equations.	Monday - Friday, 1st period	Minimum of 30% in class tests, and satisfactory tutorial attendance.	Class tests and regular WebAssigns determine a class record; one 3-hour examination makes up the balance of the final mark.	\N	MAM1004F	MAM	F	MAM	F
MATHEMATICS 1032	18	5	Dr H Wiggins	MAM1031F or MAM1033F or MAM1004F (with 65% or higher)	\N	\N	The aim of this course is to continue from the work in MAM1031F and introduce students to integral calculus, taylor polynomials, complex numbers, vector geometry, linear algebra and differential equations. This course, along with MAM1031F is necessary for entry into second year mathematics.	Five lectures per week, Monday - Friday, 1st or 3rd period.	Minimum of 30% for class tests, minimum 30% for weekly online tests, and 80% attendance at tutorial sessions.	Semester mark counts 33.3% and end-of-semester exam counts 66.6%.	\N	MAM1032S	MAM	S	MAM	S
MATHEMATICS 1004	18	5	To be advised	At least 70% in NSC Mathematics. Students registered in other faculties who do not meet the 70% NSC requirement may instead complete MAM1014F/MAM1022F followed by MAM1015S with a mark of 70% or higher to gain entry to MAM1004F and MAM1004S. Students who fail MAM1004F are expected to register for MAM1004S in the 2nd semester.	\N	\N	The aim of this course is to provide mathematics for applications, particularly in the Life and Earth sciences. The syllabus covers the following topics: Functions and graphs. Straight lines, power functions, polynomials, exponential and logarithmic functions, trigonometric functions (radians). Discrete-time dynamical systems. Stability and equilibria. Rates of change. Limits, derivatives. Maxima and minima. Concavity. Asymptotes and curve sketching. Antiderivatives and integrals. Mathematical modelling. Separable and linear differential equations.	Monday - Friday, Meridian	Minimum of 30% in class tests, and at least 80% attendance at tutorials.	Year mark counts up to 40%; one 3-hour examination makes up the balance.	\N	MAM1004S	MAM	S	MAM	S
MATHEMATICS 1005	18	5	Dr M Geyer	At least 70% in NSC Mathematics. The permission of the Dean or Head of Department is required prior to registration for this course. NOTES: 1) The course places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. 2) MAM1005H + MAM1006H is equivalent to MAM1031F + MAM1032S in level, credit value towards the degree and as prerequisite for other courses.	\N	\N	Similar to MAM1031F, the aim of this course is to introduce the fundamental ideas in calculus and related topics. It will cover the topics in MAM1031F including differential calculus of functions of one variable, but extended over the full year.	Students attend Monday - Friday in 1st or 3rd period (depending on the rest of their timetable); Workshops: Monday, 6th and 7th period.	Minimum of 35% for class record and very satisfactory attendance at all lectures, workshops and tutorials.	Year mark counts up to 50%; one 2-hour examination written in October/November makes up the balance.	\N	MAM1005H	MAM	H	MAM	H
MATHEMATICS 1006	18	5	Associate Professor B Osano	MAM1005H or a pass with at least 65% in MAM1004F/S. Students who have passed MAM1004F/S with less than 65% and who wish to register for MAM1006H will be required to write and pass the examination paper for MAM1005H in November or the supplementary examination paper in January before they are allowed to register for MAM1006H. Such students are required to inform the course co-ordinator for MAM1005H by 1 September or 1 December, respectively, of their intention to write the examination and at the same time obtain information about the reading to be done as preparation for the examination. NOTES: 1) This course follows on from MAM1005H and also places an emphasis on the strengthening of foundational concepts and skills, the carefully-paced introduction of new material, and the development of sound approaches to effective learning. 2) MAM1005H + MAM1006H is equivalent to MAM1000W in level, credit value towards the degree and as prerequisite for certain other courses.	\N	\N	Similar to the full-year course MAM1000W, the aim of this course is to introduce the fundamental ideas in calculus, linear algebra and related topics. This course consists of those topics in the MAM1000W syllabus that were not covered in MAM1005H the previous year, including differential equations, partial derivatives, vector geometry, matrix algebra, complex numbers, Taylor series.	Lectures on Monday, Tuesday, Wednesday and Friday in first period. Tutorials on Thursday in first period. No workshops.	Minimum of 35% in class tests and very satisfactory attendance at lectures and tutorials.	Year mark counts up to 40%; one 2-hour examination written in October/November makes up the balance.	\N	MAM1006H	MAM	H	MAM	H
INTRODUCTORY MATHEMATICS	18	5	R Rix	Either: (A) NSC 50% in Mathematics or at least an A-level grade of E, or, (B) Credit for one of MAM1013, MAM1014, and MAM1022.	\N	This course is intended to provide students with the necessary mathematical background to be able to continue with MAM1010F/S or, with a mark of 70% or higher, MAM1004F/S (note: students wishing to continue into MAM1010 or MAM1004 must also obtain credit for MAM1014F)	Basic algebra: Variables, algebraic manipulation, real numbers, sets and intervals, absolute value, exponents, polynomial and rational functions, equations, inequalities. Functions: Linear, quadratic, polynomial, rational, exponential, logarithmic, domain and range, graphs, piecewise-defined functions, composition of functions, inverse of a function.	Monday – Friday, 1st period.	A class record will be created through the compulsory submission of computer tutorials and written assignments and tests. A minimum of 40% for the class record and a minimum of 75% attendance will be required for a DP for admission to the examination.	Class record: 40%; exam: 60%.	\N	MAM1015S	MAM	S	MAM	S
MODERN ABSTRACT ALGEBRA (3AL)	18	7	Dr J Sanchez-Ortega	MAM2010F, MAM2011F, MAM2013S and at least one of MAM2012S or MAM2014S.	\N	\N	This course focusses on Group Theory. Topics include: Lagrange’s Theorem. Isomorphism Theorems, Correspondence Theorem. p-Groups. Cauchy’s Theorem. Sylow Theorems. Direct Product of groups. Finitely generated Abelian Groups. Jordan-Holder Theorem.	Mondays, Thursdays and some Wednesdays in 5th period.	\N	\N	\N	MAM3011F	MAM	F	MAM	F
INTRODUCTION TO DISCRETE MATHEMATICS	18	5	Dr I Allie	\N	MAM1004S or MAM1005H (unless a pass has been obtained for MAM1004F or MAM1031F or equivalent) Objective: To introduce students to the language and methods of the area of Discrete Mathematics, and to show students how discrete mathematics can be used in modern computer science (with the focus on algorithmic applications).	To introduce students to the language and methods of the area of Discrete Mathematics, and to show students how discrete mathematics can be used in modern computer science (with the focus on algorithmic applications).	This course provides a foundation for Computer Science and Applied Statistics. Many areas of Computer Science and Applied Statistics require the ability to work with concepts from discrete structures, which include topics such as set theory, logic, graph theory, and probability theory. In this course, you will learn about (1) sets, relations and functions; (2) basic logic, including propositional logic, logical connectives, truth tables, propositional inference rules and predicate logic; (3) proof techniques, including the structure of mathematical proofs, direct proofs, disproving by counterexample, proof by contradiction; (4) basics of counting, including counting arguments, the pigeonhole principle, permutations and combinations, solving recurrence relation; (5) graphs and trees; (6) discrete probability, including finite probability space, axioms of probability, conditional probability; and, (7) linear algebra, including vectors, matrices and their applications. The course is offered in a blended-learning format. Students are provided with a set of video lectures that they can watch multiple times. Student contact time is in a tutorial format aimed at reinforcing the principles introduced in the online lectures and giving students time to do exercises under the supervision of tutors.	No face-to-face lectures. The course content is delivered online.	Class Record of at least 30% and attendance at 10 or more (out of 12) tutorials.	Class Record counts 50% and Exam counts 50%.	\N	MAM1008S	MAM	S	MAM	S
MATHEMATICS 1012	18	5	M Vandeyar	Pass in MAM1010F/S/J or MAM1110F or equivalent. Students who have passed MAM1005H while being registered in another Faculty can be admitted to MAM1012F at the discretion of the Head of the Department. Such students will be granted exemption from the full first-year Mathematics requirement of the Commerce Faculty if and only if they pass MAM1012F.	\N	\N	The aim of this course is to continue the study of topics in mathematics that are of interest to Commerce students begun in MAM1010. Integral calculus, including numerical integration, introduction to ordinary differential equations, matrices and elementary linear algebra, Markov Systems, Taylor Maclaurin, and Binomial series, functions of several variables, three-dimensional space, partial derivatives and applications to optimization problems, the Simplex Method.	Monday – Friday 1st period	Minimum of 30% in class tests and full attendance at workshops.	Semester mark up to 40% June examination 1 x 2 hour paper	\N	MAM1012F	MAM	F	MAM	F
MATHEMATICS 1012	18	5	Dr R Moolman	Pass in MAM1010F/S or MAM1110F or equivalent.	\N	\N	The aim of this course is to continue the study of topics in mathematics that are of interest to Commerce students begun in MAM1010. Integral calculus, including numerical integration, introduction to ordinary differential equations, matrices and elementary linear algebra, Markov Systems, Taylor Maclaurin, and Binomial series, functions of several variables, three-dimensional space, partial derivatives and applications to optimization problems, the Simplex Method.	Monday - Friday, 1st, 3rd, or 4th period	Minimum of 30% in class tests and full attendance at workshops.	Semester mark up to 40% November examination 1 x 2 hour paper	\N	MAM1012S	MAM	S	MAM	S
LAW THAT COUNTS	18	5	Dr C Felix	None. Students can be exempted ONLY on the basis of adequate performance in the Quantitative Literacy component of the National Benchmark Test.	\N	The course is intended to provide Law students with the necessary quantitative literacy to be able to understand, express and interpret appropriate quantitative ideas. The aim of the course is to give students an appreciation and understanding of mathematical and statistical ideas within real life and legal contexts, and generally with a social justice focus.	Content covered includes percentages, ratios, interest and finance concepts, interpretation of graphs, manipulation of data, interpretation of statistics and use of spreadsheets.	Monday - Friday, 4th period	Achieve a class record of 40% and 75% attendance at lectures and tutorials.	Two written assessments, one assignment and assessment of computer tutorials contribute to the class record that counts 50% of the final mark. The final examination consists of a written paper and a computer assessment that together count 50% of the final mark.	\N	MAM1013F	MAM	F	MAM	F
QUANTITATIVE LITERACY FOR HUMANITIES	18	5	J Clarke	A pass in Matric Mathematics or Mathematical Literacy.	\N	\N	This course is intended to provide Humanities students with the necessary Quantitative Literacy to be able to understand and express appropriate quantitative ideas. The aim of this course is to give students an appreciation and an understanding of mathematical and statistical ideas within social science contexts. Course material will start from real-life situations and extract general concepts and principles using a problem-solving approach. For example: percentages; ratios; interpretation of graphs; manipulation of data; computer skills such as the use of spread sheets. The lectures will be conducted in the form of workshop/lectures: the aim is to create a learning environment based on group-work and problem-solving. Written assignments will be set to encourage students to explore their own understanding of mathematical and statistical ideas within context	Monday to Friday, 1st period or 6th period	A class record will be created through the compulsory submission of computer tutorials and written assignments, as well as through written tests. A minimum of 40% for this class record and a minimum of 75% attendance at lectures and computer laboratory periods will be required as a DP for admission to the examination.	Coursework 50% (75% assessments, 15% assignments; 10% computer submissions). Exam 50% (67% written examination; 33% computer examination) NOTE: Credit will not be given for both this course and MAM1013F/S or MAM1022F.	Details subject to change.	MAM1014F	MAM	F	MAM	F
BIOLOGICAL SCIENCES THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	BIO6003W	BIO	W	BIO	W
QUANTITATIVE LITERACY FOR THE SOCIAL SCIENCES	18	5	Dr M Henry	MAM1013F or MAM1014F or MAM1022F.	\N	\N	This course follows on from MAM1014F and is intended to provide Humanities students with the necessary Quantitative Literacy to be able to continue with studies in Quantitative Social Sciences, such as Psychology and Sociology. The aim of this course is to give students an appreciation and an understanding of mathematical and statistical ideas within appropriate contexts. The effective use of spreadsheets for data analysis and representation will be promoted. The lectures will be conducted in the form of workshop/lectures: the aim is to create a learning environment based on group-work and problem-solving. Written assignments will be set to encourage students to explore their own understanding of mathematical and statistical ideas within context.	Monday - Friday, 1st period	A class record will be created through the compulsory submission of computer tutorials and written assignments, as well as through written tests. A minimum of 40% for the class record and a minimum of 75% attendance at lectures and computer laboratory periods will be required as a DP for admission to the examination.	Coursework 50% (54% assessments, 30% assignments; 16% computer submissions). Exam 50% (67% written examination; 33% computer examination).	Details subject to change.	MAM1016S	MAM	S	MAM	S
ADVANCED NUMERICAL METHODS (3AN)	18	7	Dr N Alexeeva	MAM2040F, MAM2041F, MAM2042S and MAM2043S.	\N	\N	Advanced methods for ODEs, boundary value problems, differential eigenvalue problems. Numerical solution of PDEs by methods of finite differences, finite elements and spectral methods. Please note that lectures alternate during the week so that students can take MAM3042F and MAM3044F concurrently.	Monday - Friday, 3rd period. Assessment: Class record counts up to 50%, while the balance is given by the final examination.	\N	Class record counts up to 50%, while the balance is given by the final examination.	\N	MAM3042F	MAM	F	MAM	F
FUNDAMENTALS OF MATHEMATICS	18	5	Associate Professor A Schauerte	At least 70% in NSC Mathematics	MAM1031F and MAM1032S or equivalent.	\N	The aim of this course is to familiarise students with the most fundamental concepts and tools of modern mathematics at an elementary level. These include: fundamentals of logic and set theory, concepts of a function, of relations, of equivalence and order relations as well as some basic mathematical structures and the fundamental number systems.	Five lectures every two weeks in meridian.	Minimum of 30% in year mark.	Year mark counts up to 40%; one 2-hour examination paper written in November makes up the balance.	Students who intend to major in mathematics are expected to take MAM1019H during their first year of study.	MAM1019H	MAM	H	MAM	H
MATHEMATICS 1A FOR ENGINEERS	18	5	Dr B Mongwane	A pass in NSC Mathematics with at least 70%, or at least a D symbol at A-level.	\N	\N	The course aims to develop a good conceptual and visual understanding of the fundamentals of the mathematics of differential and the beginning of integral calculus as applied in engineering contexts. Topics include: Functions, limits and continuity. Rational functions, the natural exponential and logarithm functions. Radian measure and the Trigonometric functions. The rules of differentiation. Curve sketching. Applications of the mean value theorem. Rates of change and optimization involving functions of a single variable. L'Hospital's rules, indeterminate forms and the squeeze theorem. Anti- differentiation. Finite series, permutations, combinations and the binomial theorem. The definite integral and the fundamental theorem of calculus. The substitution rule.	Monday & Thursday & Friday, 1st & 2nd period; Tuesday & Wednesday, 1st & 2nd period, 1 double-period tutorial per week, offered in each semester.	30% For class record, high tutorial attendance.	Examination, not longer than 3 hours in June: Class record up to 40%.	\N	MAM1020F	MAM	F	MAM	F
MATHEMATICS 1A FOR ENGINEERS	18	5	To be advised	A pass in NSC Mathematics with at least 70%, or at least a D symbol at A-level.	\N	\N	The course aims to develop a good conceptual and visual understanding of the fundamentals of the mathematics of differential and the beginning of integral calculus as applied in engineering contexts. Topics include: Functions, limits and continuity. Rational functions, the natural exponential and logarithm functions. Radian measure and the Trigonometric functions. The rules of differentiation. Curve sketching. Applications of the mean value theorem. Rates of change and optimization involving functions of a single variable. L'Hospital's rules, indeterminate forms and the squeeze theorem. Anti- differentiation. Finite series, permutations, combinations and the binomial theorem. The definite integral and the fundamental theorem of calculus. The substitution rule.	Monday & Thursday & Friday, 1st & 2nd period; Tuesday & Wednesday, 1st, 2nd & 7th period	30% For class record, high tutorial attendance.	Examination, not longer than 3 hours in June or November: Class record up to 40%.	\N	MAM1020S	MAM	S	MAM	S
MATHEMATICS 1B FOR ENGINEERS	18	5	Dr S Haque	MAM1020F.	\N	\N	The course aims to develop a good conceptual and visual understanding of the fundamentals of the mathematics of differential and the beginning of integral calculus as applied in engineering contexts. The course covers the following: Further calculus of a single variable. The inverse trigonometric functions. Integration by parts. Partial fractions. Areas, volumes and arc length. Taylor series. An introduction to modelling and differential equations. Vector algebra and geometry. Points, lines and planes. Dot products and cross products. Matrices. Systems of linear equations. Gauss reduction. Matrix algebra. Linear transformations. The matrix representing a linear map. Inverses. An introduction to complex numbers. The complex plane. Moduli and arguments, conjugates. De Moivre's theorem. Roots of polynomials.	Monday & Thursday & Friday, 1st & 2nd period; Tuesday & Wednesday, 1st & 2nd period, 1 double-period tutorial per week, offered in each semester.	30% for class record, high tutorial attendance.	Examination, not longer than 3 hours in June or November: Class record up to 40%.	\N	MAM1021F	MAM	F	MAM	F
MATHEMATICS 1B FOR ENGINEERS	18	5	Dr Á de la Cruz-Dombriz	MAM1020F.	\N	\N	The course aims to develop a good conceptual and visual understanding of the fundamentals of the mathematics of differential and the beginning of integral calculus as applied in engineering contexts. The course covers the following: Further calculus of a single variable. The inverse trigonometric functions. Integration by parts. Partial fractions. Areas, volumes and arc length. Taylor series. An introduction to modelling and differential equations. Vector algebra and geometry. Points, lines and planes. Dot products and cross products. Matrices. Systems of linear equations. Gauss reduction. Matrix algebra. Linear transformations. The matrix representing a linear map. Inverses. An introduction to complex numbers. The complex plane. Moduli and arguments, conjugates. De Moivre's theorem. Roots of polynomials.	Monday & Thursday & Friday, 1st & 2nd period; Tuesday & Wednesday, 1st & 2nd period, 1 double-period tutorial per week, offered in each semester.	30% for class record, high tutorial attendance.	Examination, not longer than 3 hours in June or November: Class record up to 40%.	\N	MAM1021S	MAM	S	MAM	S
NUMBERS IN THE HUMANITIES	28	5	Dr M Sikhonde	Admission to this course is restricted to Extended Degree students and first-year Humanities students by course convener permission. It is strongly recommended for ED students taking BSocSc majors.	\N	\N	This course is intended to provide Humanities ED students with the necessary quantitative literacy to be able to understand and express appropriate quantitative ideas, which may be presented in text, tables, charts and graphs. The aim of the course is to give students an appreciation and understanding of simple mathematical and statistical ideas in social science contexts and to develop their ability to write about such quantitative information. Some examples of quantitative ideas to be mastered in the course include: percentages, ratios, ways of representing change, descriptive statistics, data representations and the use of spread-sheets.	Monday - Friday, 1st or 6th period	Students will build up a coursework mark through the compulsory submission of all computer tutorials, assignments and tests. A minimum of 45% for coursework and a minimum of 75% attendance at lectures and computer laboratory periods will be required as a DP for admission to the examination.	Coursework 50% (75% assessments, 15% assignments, 10% computer submissions). Exam 50% (67% written examination; 33% computer examination).	Details subject to change. For most students this is a terminating course. If students achieve more than 60% for this course they can continue to MAM1016S. Credits for this course may count towards the four-year programme of study leading to the BA or BSocSc degree	MAM1022F	MAM	F	MAM	F
MATHEMATICS 1A FOR ENGINEERS EXTENDED	18	5	K Ramesh-Kanjee	\N	\N	\N	An introduction to differential and integral calculus. Functions, limits and continuity. Rational functions, the natural exponential and logarithm functions. Radian measure and the Trigonometric functions. The rules of differentiation. Curve sketching. Applications of the mean value theorem. Rates of change and optimization involving functions of a single variable. L'Hospital's rules, indeterminate forms and the squeeze theorem. Anti-differentiation. The binomial theorem. The definite integral and the fundamental theorem of calculus. The substitution rule.	Lectures from Monday - Friday, 1st and 2nd period. Tutorials on Tuesday from 6th to 8th period.	35% in class record	Class record (tests, problem sets) 50%, Final examination 50%. Although a supplementary examination is usually granted for a final grade in the range 45-49%, a supplementary examination may also be granted for certain key courses in the range 40-44% under conditions agreed to by the Deans of EBE and Science, normally involving a mandatory pre-supplementary tutoring and revision programme.	\N	MAM1023F	MAM	F	MAM	F
MATHEMATICS 1A FOR ENGINEERS EXTENDED	18	5	Dr A Campbell	\N	\N	\N	An introduction to differential and integral calculus. Functions, limits and continuity. Rational functions, the natural exponential and logarithm functions. Radian measure and the Trigonometric functions. The rules of differentiation. Curve sketching. Applications of the mean value theorem. Rates of change and optimization involving functions of a single variable. L'Hospital's rules, indeterminate forms and the squeeze theorem. Anti-differentiation. The binomial theorem. The definite integral and the fundamental theorem of calculus. The substitution rule.	Lectures from Monday - Friday, 1st and 2nd period. Tutorials on Tuesday from 6th to 8th period.	35% in class record	Class record (tests, problem sets) 50%, Final examination 50%. Although a supplementary examination is usually granted for a final grade in the range 45-49%, a supplementary examination may also be granted for certain key courses in the range 40-44% under conditions agreed to by the Deans of EBE and Science, normally involving a mandatory pre-supplementary tutoring and revision programme.	\N	MAM1023S	MAM	S	MAM	S
MATHEMATICS 1B FOR ENGINEERS EXTENDED	18	5	Dr A Campbell	MAM1020F/S or MAM1023F/S	\N	\N	Further calculus of a single variable. The inverse trigonometric functions. Integration by parts. Partial fractions. Areas, volumes and arc length. Taylor series. An introduction to modelling and differential equations. Vector algebra and geometry. Points, lines and planes. Dot products and cross products. Matrices. Systems of linear equations. Gauss reduction. Matrix algebra. Linear transformations. The matrix representing a linear map. Inverses. An introduction to complex numbers. The complex plane. Moduli and arguments, conjugates. De Moivre's theorem. Roots of polynomials	Lectures Monday - Friday 1st period. Tutorials on Tuesday from 6th to 8th.	35% in class record	Class record (test, problem sets) 50%, Final examination 50%. Although a supplementary examination is usually granted for a final grade in the range 45-49%, a supplementary examination may also be granted for certain key courses in the range 40-44% under conditions agreed to by the Deans of EBE and Science, normally involving a mandatory pre-supplementary tutoring and revision programme.	\N	MAM1024F	MAM	F	MAM	F
MATHEMATICS 1112 FOR CADP	18	5	S Torr	Pass in MAM1110F or MAM1010F/S/J or equivalent.	\N	\N	The aim of this course is to continue the study of topics in mathematics that are of interest to Commerce students begun in MAM1010. Integral calculus, including numerical integration, introduction to ordinary differential equations, matrices and elementary linear algebra, Markov Systems, Taylor Maclaurin, and Binomial series, functions of several variables, three-dimensional space, partial derivatives and applications to optimization problems, the Simplex Method.	Monday - Friday, 1st period.	30% in class tests and satisfactory attendance at lectures and tutorials.	Year mark up to 40% Final examination 1 x 2 hour paper	(for EDU Commerce Academic Development students)	MAM1112S	MAM	S	MAM	S
MATHEMATICS 1B FOR ENGINEERS EXTENDED	18	5	K Ramesh-Kanjee	MAM1020F/S or MAM1023F/S	\N	\N	Further calculus of a single variable. The inverse trigonometric functions. Integration by parts. Partial fractions. Areas, volumes and arc length. Taylor series. An introduction to modelling and differential equations. Vector algebra and geometry. Points, lines and planes. Dot products and cross products. Matrices. Systems of linear equations. Gauss reduction. Matrix algebra. Linear transformations. The matrix representing a linear map. Inverses. An introduction to complex numbers. The complex plane. Moduli and arguments, conjugates. De Moivre's theorem. Roots of polynomials	Monday, Tuesday, Wednesday & Friday 1st& 2nd periods. Workshops: Wednesday 6th – 8th periods.	35% in class record	Class record (test, problem sets) 50%, Final examination 50%. Although a supplementary examination is usually granted for a final grade in the range 45-49%, a supplementary examination may also be granted for certain key courses in the range 40-44% under conditions agreed to by the Deans of EBE and Science, normally involving a mandatory pre-supplementary tutoring and revision programme.	\N	MAM1024S	MAM	S	MAM	S
MODELLING & APPLIED COMPUTING	18	5	Dr P W Adams	\N	MAM1031F and MAM1032S or equivalent.	\N	The aim of this course is to introduce Applied Mathematics and Mathematical Modelling including approximations and estimation theory, numerical methods, dynamical systems and modelling and simulation of discrete and continuous processes with MATLAB and/or Julia. Exposure to research methodology and mathematical communication is provided.	First Semester: 2nd period Monday, Wednesday, Friday. Second Semester: 2nd period Tuesday, Thursday.	A class record of 30% or more.	Class record counts 50%; one 3-hour examination written in October/November makes up the balance.	This course can be taken in conjunction with MAM1044H as lectures are arranged so that this is possible. Each student registered for this course is required to have a laptop for use during class sessions as well as after hours. The minimum specifications of the laptop are available at www.math.uct.ac.za. (A tablet or “netbook” will not be suitable). The course convener will provide details of additional software (open source) required.	MAM1043H	MAM	H	MAM	H
NON-LINEAR DYNAMICS (2ND)	12	6	To be advised	MAM1031F and MAM1032S or equivalent, MAM1043H, MAM1044H, MAM2010F and MAM2011F	\N	\N	The course will cover fixed points, bifurcations, phase portraits. Conservative and reversible systems. Index theory, PoincaréBendixson theorem, Liénard systems, relaxation oscillators. Hopf bifurcations, quasiperiodicity and Poincaré maps. Applications: chaos on a strange attractor, Lorentz map, logistic map, Hénon map. Lyapunov exponents. Fractals. Please note that lectures alternate during the week so that students can take MAM2042S and MAM2043S concurrently.	Monday - Friday, 3rd period.	Class record (CR) of at least 30% and satisfactory attendance at tutorials and submission of all assigned work.	The class record (CR) is comprised of at least two class tests and any additional assessments the course convenor feels are necessary. The examination (EX) at the end of the semester is two hours long The final mark (FM) is calculated as 50% CR + 50% EX. Note that the CR comprises a maximum of 50% of the FM, while the EX makes up the balance.	\N	MAM2042S	MAM	S	MAM	S
BOUNDARY-VALUE PROBLEMS (2BP)	12	6	Associate Professor B Osano	MAM1031F and MAM1032S or equivalent, MAM1043H, MAM1044H, MAM2010F, MAM2011F, and MAM2040F	\N	\N	The course will cover homogeneous and non-homogeneous boundary-value problems, Sturm- Liouville problems. Partial differential equations and their solution via separation of variables. Fourier series. Green's functions. Eigenfunction expansions. Please note that lectures alternate during the week so that students can take MAM2042S and MAM2043S concurrently.	Monday - Friday, 3rd period.	Class record (CR) of at least 30% and satisfactory attendance at tutorials and submission of all assigned work.	The class record (CR) is comprised of at least two class tests and any additional assessments the course convenor feels are necessary. The examination (EX) at the end of the semester is two hours long The final mark (FM) is calculated as 50% CR + 50% EX. Note that the CR comprises a maximum of 50% of the FM, while the EX makes up the balance.	\N	MAM2043S	MAM	S	MAM	S
VECTOR CALCULUS FOR ENGINEERS	16	6	Dr E Fredericks	MAM1020 or equivalent and MAM1021 or equivalent.	\N	\N	This course aims to develop an understanding of differentiation of vector valued functions, space curves and surfaces. Partial derivatives, chain rule, maxima and minima, Lagrange multipliers. Gradient, divergence and curl. Taylor's theorem for one and several variables, Jacobians, Newton's method for several variables. Multiple integrals and change of variable. Surface integrals. Line integrals, work done by a force, potentials. Green's theorem, divergence theorem, and Stokes' theorem.	\N	35% class record and satisfactory tutorial attendance.	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	This course is designed specifically for students in the Faculty of Engineering & the Built Environment.	MAM2083F	MAM	F	MAM	F
TERTIARY CHEMISTRY EDUCATION THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates for the PhD degree must submit a thesis on an approved research topic, and are referred to Book 3, General Rules and Policies, in which the rules for the degree are set out.	\N	\N	\N	\N	CEM6001W	CEM	W	CEM	W
LINEAR ALGEBRA & DIFFERENTIAL EQUATIONS FOR ENGINEERS	16	6	To be advised	MAM1021F/S or equivalent.	\N	\N	This course aims to develop an understanding of linear algebra and differential equations for engineers. Topics include: First order ordinary differential equations. Systems of linear equations, linear combinations, linear dependence, linear subspaces and basis. Determinants. Eigenvalues and eigenvectors, diagonalization, applications to systems of linear differential equations and finding principal axes. Solution of n-th order linear differential equations. The Laplace transform.	4 lectures per week, 1 double-period tutorial per week.	35% class record and satisfactory tutorial attendance.	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	This course is designed specifically for students in the Faculty of Engineering & the Built Environment.	MAM2084F	MAM	F	MAM	F
LINEAR ALGEBRA & DIFFERENTIAL EQUATIONS FOR ENGINEERS	16	6	To be advised	MAM1021F/S or equivalent.	\N	\N	This course aims to develop an understanding of linear algebra and differential equations for engineers. Topics include: First order ordinary differential equations. Systems of linear equations, linear combinations, linear dependence, linear subspaces and basis. Determinants. Eigenvalues and eigenvectors, diagonalization, applications to systems of linear differential equations and finding principal axes. Solution of n-th order linear differential equations. The Laplace transform.	4 lectures per week, 1 double-period tutorial per week.	35% class record and satisfactory tutorial attendance.	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	This course is designed specifically for students in the Faculty of Engineering & the Built Environment.	MAM2084S	MAM	S	MAM	S
VECTOR CALCULUS FOR ASPECT	16	6	Associate Professor P Padayachee	MAM1023 and MAM1024	\N	\N	This course aims to develop an understanding of vector calculus. Topics include: differentiation of vector valued functions, space curves and surfaces. Partial derivatives, chain rule, maxima and minima, Lagrange multipliers. Gradient, divergence and curl. Taylor's theorem for one and several variables, Jacobians, Newton's method for several variables. Multiple integrals and change of variable. Surface integrals. Line integrals, work done by a force, potentials. Green's theorem, divergence theorem, and Stokes' theorem.	Monday-Friday 1st period, 1 afternoon tutorial, optional additional mini-tutorials in 2nd or 3rd period	35% class record; attendance of tutorials	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	\N	MAM2085F	MAM	F	MAM	F
VECTOR CALCULUS FOR ASPECT	16	6	Associate Professor P Padayachee	MAM1023 and MAM1024	\N	\N	This course aims to develop an understanding of vector calculus. Topics include: differentiation of vector valued functions, space curves and surfaces. Partial derivatives, chain rule, maxima and minima, Lagrange multipliers. Gradient, divergence and curl. Taylor's theorem for one and several variables, Jacobians, Newton's method for several variables. Multiple integrals and change of variable. Surface integrals. Line integrals, work done by a force, potentials. Green's theorem, divergence theorem, and Stokes' theorem.	Monday-Friday 1st period, 1 afternoon tutorial, optional additional mini-tutorials in 2nd or 3rd period	35% class record; attendance of tutorials	One paper written in June or November no longer than 2.5 hours: up to 80%, year mark: up to 40%.	\N	MAM2085S	MAM	S	MAM	S
METRIC SPACES (3MS)	18	7	S Chili	MAM2010F, MAM2011F, MAM2014S and at least one of MAM2012S or MAM2013S.	\N	\N	The aim of this course is to introduce fundamental concepts in metric spaces and topology. Basic tools - Metrics, ultrametrics, pseudometrics, quasi-metrics. Convergence in metric spaces. Closed sets and closures. Open sets and interiors. Definition of topology in metric space and in general. Functions: continuous, uniformly continuous, Lipschitz continuous, contractions, isometries. Isomorphisms: topological, uniform, metric. Fundamental concepts - Completeness, via Cauchy sequences. Cantor’s intersection theorem. Construction of completion and proof of uniqueness. Banach’s Fixed Point Theorem and some applications. Compactness, via convergent subsequences; equivalence with total boundedness and completeness, and with open cover property. Connectedness, disconnectedness, and connected components.	Tuesdays, Fridays and some Wednesdays in 5th period.	\N	\N	\N	MAM3010F	MAM	F	MAM	F
TOPICS IN ANALYSIS (3TN)	18	7	Dr F Ebobisse-Bille	MAM3010F	\N	\N	1. Study of sequences: basic definitions on sequences of numbers; study of the behaviour of sequences of real numbers. 2. Revision on metric spaces: distance, balls, open and closed sets, limit of a function, convergence of sequences, compactness, completeness; spaces of continuous functions between metric spaces (continuity, uniform continuity, Lipschitz continuity, H?lderian continuity; ointwise convergence and uniform convergence for sequences of functions; normed spaces and linear continuous mappings between normed spaces; equivalence of norms; Banach spaces; linear continuous mappings between normed spaces (norm of a linear continuous mapping, the dual space). 3. Hilbert spaces: scalar product (parallelogram identity; Hilbert spaces; the orthogonal complement, the orthogonal projection operator, the Gram-Schmidt orthonormalization process. 5. Differential calculus between normed spaces: Gâteaux and Fréchet differentiability; chain rule; the Lagrange inequality; convexity (convex Fréchet differentiable functions); the implicit function theorem (IFT) – Inverse mapping theorem (IMT). 6. On Riemann integration and its limitations.	Mondays, Thursdays and some Wednesdays in 5th period.	\N	\N	\N	MAM3014S	MAM	S	MAM	S
METHODS OF MATHEMATICAL PHYSICS (3MP)	18	7	To be advised	MAM2040F, MAM2041F, MAM2042S and MAM2043S.	\N	\N	The aim of this course is to introduce a selection of advanced topics in Applied Mathematics. Topics include: The Fourier-transform solution of linear PDEs on the line. The long-term asymptotic behaviour of solutions: the methods of Laplace, stationary phase and steepest descents. Nonlinear waves: the method of characteristics; the effect of dissipation; the Cole-Hopf transform for the Burgers equation; travelling fronts for the KPP equation. The effect of dispersion: KdV and nonlinear Schroedinger equation. Elliptic integrals and elliptic functions; dark and bright solitons; kinks and breathers for the sine-Gordon equation. Multisoliton solutions: the Hirota method and Baecklund transformations. Please note that lectures alternate during the week so that students can take MAM3043S and MAM3045S concurrently.	Monday - Friday, 3rd period.	Class record of 30% or more.	Class record counts up to 50%, while the balance is given by the final examination.	\N	MAM3043S	MAM	S	MAM	S
INTRODUCTION TO PHILOSOPHY	18	5	TBA	None	\N	\N	This course is an introduction to philosophy that aims to make students more conscious, creative and critical in thinking about their own fundamental beliefs and values. Fundamental issues investigated include: the nature and possibility of knowledge, self-knowledge, the relationship between the mind and the body, the knowledge of other minds, whether we have free will, and whether life has a meaning. These issues are explored with the help of classical and contemporary philosophers, including Plato, Aristotle, Aquinas, Descartes, Hume, Biko, Appiah, Menkiti, Haslanger and others. As an introductory course, we use content that engages the diversity of students' lifeworlds and is cognizant of our African location. We employ innovative teaching and delivery methods that allow more time for active engagement and the development of critical reading and writing skills in the Humanities.	Monday, Tuesday, Wednesday 5th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%.	This course may also be offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI1024F	PHI	F	PHI	F
CRITICAL THINKING	18	5	Associate Professor E Galgut	None	\N	\N	Why do we value our beliefs? We value them because we take them to be true and, as true, they are good guides. But how can we tell when a belief is true? Our only handle here is whether or not the belief is justified. So we aim to have beliefs that are justified. The course concentrates on the practical business of appraising justifications. Of course, we all routinely attempt to justify our beliefs and arrive at new beliefs on the basis of supposed justifications. But almost as routinely we are hoodwinked. The course aims to make students better believers by making them more aware of the nature of justification, of the different sorts of justification and the pitfalls of each. At the end of it they will be less gullible and more able to explain just why a particular argument does or doesn't convince them. As an Introductory course we employ teaching and delivery methods that allow for active engagement and the development of critical reading and writing skills in the Humanities.	Monday, Tuesday, Wednesday 3rd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 50%; one 2-hour examination in June counts 50%.	\N	PHI1025F	PHI	F	PHI	F
PHILOSOPHY OF PSYCHOLOGY AND MIND	24	6	Associate Professor E Galgut	At least second year status.	\N	\N	The question of the nature of the mind and its relation to the body (e.g. the brain) is discussed at length, with attention given to dualism, behaviourism, physicalism and functionalism. Other topics which may be dealt with are the nature of action, free will and determinism and the problem of personal identity.	Monday, Tuesday, Wednesday 4th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%.	This course may also be offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI2012F	PHI	F	PHI	F
PHILOSOPHY OF ART AND LITERATURE	24	6	TBA	At least second year status.	\N	\N	This course will consider a variety of issues in contemporary philosophy of art and literature - a subject area also sometimes referred to as aesthetics. Among the issues that will be discussed are: the ontology of art (comparing literature, music, painting, etc); interpreting literary and other art works; the nature of metaphor; the relationship between art and morality; truth and sincerity as criteria of literary and artistic value; the definition (or general nature) of art and literature.	Monday, Tuesday, Wednesday 2nd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in October/November counts 60%.	\N	PHI2016S	PHI	S	PHI	S
APPLIED ETHICS	24	6	TBA	At least second year status.	\N	\N	The course involves the application of philosophical reasoning to real life practical and moral issues. It will be shown how rational argument can be brought to bear on the resolution of ethical dilemmas and difficult questions about what ought to be done. These may include issues concerning health care, business, the professions, the environment, or everyday life.	Monday, Tuesday, Wednesday 3rd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%.	(May not be offered in 2025)	PHI2037F	PHI	F	PHI	F
TERTIARY CHEMISTRY EDUCATION DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct and analysis of the results of research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	CEM5004W	CEM	W	CEM	W
PHILOSOPHY OF SCIENCE	24	6	Associate Professor J Ritchie	At least second year status.	\N	\N	The course aims to introduce the students to the epistemological, metaphysical and ethical issues that arise when science is considered from a philosophical perspective. Through the study of philosophers such as Popper, Kuhn and Feyerabend, among others, the following sorts of questions will be discussed: Do scientists employ a special method which sets them apart from non-scientists and gives their claims greater authority? Do electrons, genes and other entities that we can’t see or touch really exist? Are scientists inevitably influenced by political and moral agendas or can pure science be value free?	Monday, Tuesday, Wednesday 3rd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; November examination 3 hours 60%.	\N	PHI2040S	PHI	S	PHI	S
GREAT PHILOSOPHERS	24	6	Associate Professor T Angier	At least second year status and the successful completion of any PHI course. However, completing PHI1024F before attempting PHI2041S is strongly encouraged.	\N	\N	This course will introduce students to a selection of philosophy’s major figures. The figures chosen may vary from year to year but they will be selected on the basis of their originality, profundity, influence and on the degree to which their works speak to one another. Philosophy often proceeds through an engagement with its past and engaging with one’s philosophical inheritance is one of the most rewarding aspects of studying philosophy. This course will ask students to try to understand a set of historical thinkers and writers not as contemporaries who can be presumed to share our philosophical concerns nor yet as merely historical figures; rather we shall try to appreciate the thinker’s writings in the context of his own concerns, which may differ significantly from ours. We shall discover that, when properly understood in this way, these thinkers still have relevance.	Monday, Tuesday, Wednesday 4th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in October/November counts 60%.	\N	PHI2041S	PHI	S	PHI	S
POLITICAL PHILOSOPHY	24	6	Associate Professor T Angier	At least second year status.	\N	\N	What should our government do for us? Do the rich owe anything to the poor? Should society accept all cultures, or are there limits to tolerance? Is democracy really a good system? What is a just war, and can terrorism be justified? These are some of the questions asked in political philosophy. This course approaches the field in two ways. We choose several great political philosophers from ancient times to the twentieth century, and discuss their aims and arguments. Then we select some areas from contemporary political philosophy, and assess solutions to perpetual or recent problems in these areas.	Wednesday, Thursday, Friday 2nd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%. PHI2043FS BUSINESS ETHICS Please note that this course DOES NOT count towards the Philosophy major. This course may also be offered in Summer/ Winter Term for limited numbers of students - please consult the department. 18 NQF credits at NQF level 6 Convener: Associate Professor G Hull Course entry requirements: At least second year status or be registered for an ACC04/ACC08 programme. Course outline: Ethical choices are unavoidable in business. This course aims to help students to articulate their options when confronted with an ethical dilemma in business, and to make well-informed judgements about the right thing to do. The course will consider a range of problems, from issues that could arise in a student’s first job to questions of business regulation that they may one day face as a leader in commerce or government. In each case, the course will challenge and assist students to recognise ethical problems in practical situations, understand the possible solutions, and make reasoned decisions. Lecture times: Monday, Tuesday, Wednesday 3rd or 4th period. DP requirements: Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework. Assessment: Coursework counts 40%; one 3-hour examination in June or October/November counts 60%.	This course may also be offered in Summer/ Winter Term for limited numbers of students - please consult the department.	PHI2042F	PHI	F	PHI	F
PHILOSOPHY OF MATHEMATICS	24	6	Professor B Weiss	Second year status and at least 50% for Matric mathematics, or a pass for a MAM course, or a lower intermediate score for the NBT in Quantitative Literacy.	\N	\N	Mathematics – the paradigm of a successful intellectual practice, with highly secure results and many important applications – raises deep philosophical questions. For instance, if mathematical objects (like numbers) are not in time or space, then how can we know anything about these objects, and how can mathematics be of any use in understanding the physical world? Some other questions: Does mathematics have a foundation? What is a good mathematical explanation? In what ways does the discipline of mathematics develop? This course discusses and evaluates major contributions, both historical and current, to the philosophy of mathematics. The intended audience includes students who enjoy more abstract areas of philosophy in general as well as those interested in the significance of mathematics in particular.	Monday, Tuesday, Wednesday 6th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%, one 3-hour examination in June counts 60%.	\N	PHI2044F	PHI	F	PHI	F
INTRODUCTION TO POLITICS B +	10	5	S Seti	None (extended programme students only).	POL1005S.	\N	The purpose of this course is to augment and support its co-requisite course: POL1005S Introduction to Politics B. It aims to improve students’ performance by enhancing their grasp of key ideas and concepts, and by developing their mastery of the disciplinary discourse. It provides additional pedagogic enrichment in the form of regular Plus Tuts that extend into Writing Hub exercises and consultations. In these tutorials, students will receive explicit support around the co-requisite course assignments and detailed feedback on their written work.	Tutorial times by sign-up with the department.	100% tutorial attendance plus successful completion of all coursework assignments.	Coursework counts 100% comprising of tutorial assessments and other written work.	\N	POL1010S	POL	S	POL	S
POLITICAL THEORY	24	6	Dr G M Maxaulane	POL1004F and POL1005S or with special permission from the Head of Department.	\N	\N	The course examines the social theories of modernity or the role of the post-Enlightenment Scientific Revolution in the formation of the theory of the subject. Against this backdrop, we examine how Descartes goes about establishing the existence of the subject and then we will examine some of the different forms assumed by the new subject (including colonial, democratic, fascist, and totalitarian forms). When it comes to colonial modernity, we will consider the effects of the modern episteme in the history of colonialism and the modes of resistance assumed by the anti-colonial subject and the 'post'-colonial subject.	Monday to Thursday 8th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL2002F	POL	F	POL	F
PHILOSOPHY OF RACE	24	6	Associate Professor G Hull	At least second year status.	\N	\N	Many of the topics of public debate in contemporary South Africa raise intriguing philosophical questions: Morally speaking, does most of the Western Cape actually belong to the Khoisan? Does being indigenous (if that concept makes sense) give one certain moral rights? Has the achievement of legal equality liberated black people, or would true liberation require the rediscovery of a distinctive identity? What special responsibilities (if any) do formerly advantaged groups have today? This course brings the tools of philosophical argument and analysis to bear on such problems, making use of, e.g., contemporary theories of moral ownership rights and the phenomenon of “epistemic injustice”. In addition, it traces the intellectual ancestry of ideas such as those of Black Consciousness, critically examining the attempts of theorists such as Hegel, Fanon, Césaire and Biko to theorise about oppression, identity, empowerment and the predicament of colonised peoples.	Monday, Tuesday, Wednesday 5th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one three-hour examination in October/November counts 60%.	(May not be offered in 2025)	PHI2045S	PHI	S	PHI	S
LOGIC AND LANGUAGE	30	7	Professor B Weiss	PHI2041S and any one of the other second year PHI courses that count towards the major.	\N	\N	The philosophical investigation of linguistic meaning came to occupy a pivotal role in philosophy a little over a hundred years ago. The investigation became pivotal because the notion seems deeply perplexing — what sort of relation does a linguistic sign bear to what it represents? how do we form the ability to understand a potential infinity of sentences? — and because, more controversially, it came to seem that we could pursue many other questions in philosophy by looking at how language works. The philosophical focus on language was facilitated by developments in logical theory. The course begins by equipping the student with the technical basis in logic and then builds on this to explore the workings of language.	Tuesday, Wednesday, Thursday, Friday 7th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%.	\N	PHI3023F	PHI	F	PHI	F
METAPHYSICS AND EPISTEMOLOGY	30	7	Associate Professor J Ritchie	PHI2041S and any one of the other second year PHI courses that count toward the major, and PHI3023F.	\N	\N	On one widespread conception, metaphysics is a first-order inquiry into “what there is”, whilst epistemology is second-order inquiry reflecting on “what it takes to know what there is.” But the pursuit of epistemology raises metaphysical questions too: what do our ways of knowing tell us about human nature, and the nature of the world? This course explores some core contemporary issues in both areas of inquiry, and considers the relationship between them. Topics in metaphysics may include contemporary investigations into the nature of the mind, its relations to the body and the external world, as well as the nature of causation, space and time. The course may also include some reflection on how, if at all, metaphysical knowledge is possible. Topics in epistemology may include exploring contemporary debates regarding the conception of knowledge, the structure and nature of epistemic justification, the relationship between reasons and beliefs and the value (if any) of scepticism.	Monday, Tuesday, Wednesday 7th period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in October / November counts 60%.	\N	PHI3024S	PHI	S	PHI	S
MATHEMATICS 1010	18	5	T Low	NSC level 5 in Mathematics, or 50% on Higher Grade Mathematics (SC) or a pass in STA1101F/H or STA1001F/H/S; registered as an Academic Development Student (Commerce).	\N	\N	The aim of this course is to introduce topics in mathematics that are of interest to Commerce students, with applications to economics. Introductory financial mathematics including compound interest and annuities, functions, limits, differential calculus and applications of the derivative including graph sketching and Newton’s Method, introduction to integral calculus and techniques of integration.	Monday - Friday, 1st period.	Attendance at and submission of a minimum of 80% of lectures AND tutorials AND a weighted average of at least 40% for class tests.	Year mark up to 40% Final examination 1 x 2 hour paper	(for EDN Commerce Academic Development students)	MAM1110H	MAM	H	MAM	H
INTRODUCTION TO POLITICS	18	5	Associate Professor Z Jolobe	Faculty admission. Admission to this course is restricted to students registered for the major in Politics and Governance, or to students in the PPE programme or the 4- year version of the general bachelor's degree.	\N	\N	The purpose of this course is to provide an introduction to key concepts in Political Studies in particular political theory and public policy and administration. Under political theory, key concepts such as power, authority and legitimacy are discussed. Similarly, basic concepts in Public Policy and Administration are introduced to students. These concepts are applied to the study of politics. The case study of South African politics constitutes an application of the conceptual and theoretical material to contemporary politics. As an introductory course, we use content that engages the diversity of students' life worlds and is cognisant of our African location. We employ innovative teaching and delivery methods that allow more time for active engagement and the development of critical reading and writing skills in the Humanities.	Monday to Thursday 7th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests is a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	This course may also be offered in Summer/Winter Term – please consult the Department.	POL1004F	POL	F	POL	F
INTRODUCTION TO POLITICS B	18	5	Professor A Butler	DP for POL1004F or with special permission from the Head of Department.	\N	\N	This course is an introduction to two related fields of Political Studies – Comparative Politics and International Relations. Comparative Politics involves the use of comparative approaches to study political institutions and processes within states. International Relations examines power relations across state borders. The course provides an introduction to the systematic study of both fields, with an emphasis on some of the leading theories and questions.	Monday to Thursday 7th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	This course may also be offered in Summer/Winter Term – please consult the Department.	POL1005S	POL	S	POL	S
COMPARATIVE POLITICS	24	6	Z Lategan	POL1004F and POL1005S or with special permission from the Head of Department.	\N	\N	This course introduces students to the major concepts, approaches, themes and topics of inquiry in the field of comparative politics. The course is designed to relate specific theories and relevant case studies and/or empirical evidence. The first part of the course focuses on the broad theme of comparative government and the second on violent processes of political change.	Monday to Thursday 7th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	This course may also be offered in Summer/Winter Term – please consult the Department.	POL2038F	POL	F	POL	F
INTERNATIONAL POLITICAL ECONOMY	24	6	Associate Professor Z Jolobe	POL1004F and POL1005S or with special permission from the Head of the Department.	\N	\N	The course aims to familiarize students with the theoretical concepts and analytical tools central to the study of International Political Economy (IPE) as it relates to Africa. IPE focuses on the intersection between economics and politics in the global environment. In this course, students will analyse how international and domestic political factors interact with economic factors to determine outcomes in areas such as international trade, finance, aid, natural resources, international growth and development, as well as the interaction between business and governments. The course is intended not only to prepare students for further study in IPE, but also to make sense of current events, especially the challenges countries like South Africa face in the international arena.	Monday to Thursday 6th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 60%; final two-hour examination counts 40%.	\N	POL2039F	POL	F	POL	F
INTRODUCTION TO MACHINE LEARNING	6	7	Dr E Pienaar	STA2004F & STA2005S and MAM2000W strongly recommended. Recommended MAM2000W modules: 2LA - LINEAR ALGEBRA, 2AC - ADVANCED CALCULUS, 2DE - DIFFERENTIAL EQUATIONS, 2RA - REAL ANALYSIS. Registered for a BCom or BBusScience degree in Actuarial Science.	STA3048S	\N	Machine learning: Topics covered include: A basic introduction to statistical learning paradigms, applications of regression and classification trees, and a primer on feedforward neural networks and backpropagation.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline.	A computer based exam.	A student cannot obtain credits for both STA3043S and (STA3047S+STA3048S)	STA3047S	STA	S	STA	S
COMPARATIVE PUBLIC ADMINISTRATION	24	6	Associate Professor V Naidoo	POL1004F and POL1005S or with special permission from the Head of Department.	\N	\N	Public administration represents the most visible, and in many ways, the most active part of government. It is also that aspect of government that we probably know the least about, because it is comprised of a large army of non-elected officials working behind the scenes to implement legislation and policy. In this course, we will survey the history and contemporary practice of public administration (or public bureaucracies) around the world. Some of the key questions that we will aim to answer are: what is the proper place and role of public administration in a democracy? What are the benefits and potential risks of public administration in democratic government? What impact does public administration have on our lives as citizens? How can we construct effective working relationships between elected politicians and unelected administrators. And finally, what role can public administration play in responding to global policy crisis? Although this course adopts a comparative perspective, we will pay particular attention to the role that public administration has played in democratic transitions in South and Southern Africa.	Monday to Thursday 8th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL2042S	POL	S	POL	S
SOUTH AFRICAN POLITICS	24	6	Dr G Maluleke	POL1004F and POL1005S or with special permission from the Head of Department.	None	\N	This course introduces students to the academic study of South African politics. It explores the country’s recent political history, the political legacies of segregation and apartheid, and the relationships between politics and broader social life. It goes on to explore the character and significance of the country’s ‘democratic transition’. The course also investigates the country’s constitution, electoral systems, political parties, party system, and associational politics. Students learn key academic approaches to the study of domestic politics and apply these to the study of South Africa.	Monday to Thursday 5th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP MUST be submitted by the last day of the course.	Coursework 50%; final exam 50%.	\N	POL2043S	POL	S	POL	S
SPECIAL TOPIC IN HUMAN/ENVIRONMENT INTERACTIONS	23	9	Dr S Scheba	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	Issues and themes in contemporary aspects of the Human/ Environmental interface will be covered. Specific attention will be given to profiling core debates in a specialist field of human or environmental geography. The course will focus on using theory, but will encourage the use of case studies. Course outcomes will emphasize the development of conceptual and analytical skills. At the NQF 9 level there is a strong emphasis on the development of analytical skills and students are expected to apply these skills in the context of an appropriate theory, to a case study of their own specialist field of human or environmental geography.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS5040S	EGS	S	EGS	S
POLITICS OF AFRICA AND THE GLOBAL SOUTH	30	7	Associate Professor L Paremoer	Any 2000-level POL course, or with special permission from the Head of Department.	\N	\N	This course reviews the theories and approaches that are typically used to analyse the political economies and political regimes of countries in the global South. The reliability, validity and normative implications of these theories will be evaluated with reference to key case studies -- in many cases drawn from the African Continent – in order to illustrate or problematise their claims. Though this is a political science course, our study of the politics of the South will be informed by debates that span a number of disciplines, including history, economics, law, anthropology and sociology.	Monday. Tuesday, Wednesday 4th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL3029F	POL	F	POL	F
CONFLICT IN WORLD POLITICS	30	7	Associate Professor H Scanlon	Any 2000-level POL course or with special permission from the Head of Department.	\N	\N	In this course we examine conflict in world politics. We focus on: the analysis of conflict; causes of conflict; actors in conflict; behaviour during conflict; consequences of conflict; and moral evaluation of conflict. In each dimension, we ask questions. To each of these questions, there are different, even opposing, answers. We examine these answers, illustrating them with cases and/or empirical material.	Monday to Thursday 6th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL3030F	POL	F	POL	F
SOUTH AFRICAN PUBLIC POLICY ANALYSIS	30	7	Professor A Butler	Any 2000-level POL course or with special permission from the Head of Department.	\N	\N	This course introduces students to the analysis of public policy. We first explore public institutions in which policy is analysed, developed and implemented, including the cabinet system, treasury and the presidency. We then consider some models that scholars have used to make sense of complex policy processes. The course then explores specific public policy challenges in areas such as energy security, school system reform, and HIV/AIDS policy. This course will be especially useful for students wanting to understand contemporary government in SA, and the relationships between public policy and politics.	Monday to Thursday 7th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL3037F	POL	F	POL	F
URBAN POLITICS AND ADMINISTRATION	30	7	Dr T Zondi	Any 2000-level POL course or with special permission from the Head of Department.	\N	\N	The first section of the course locates South African local level politics and administration in the context of national and provincial state reform, and examines the significance of local implementation and service delivery for policy outputs and for the policy process as a whole. A theoretical framework for understanding local government reorganisation is developed and a comparative analysis undertaken of local government reorganisation with particular reference to metropolitan areas. There is in addition a focus on contemporary reforms which have affected South Africa's contemporary urban governance, such as the new megacities, politics-administration interface and developmental local government. The second section of the course introduces students to an overview of contemporary urban political and administrative challenges and opportunities. These challenges and opportunities occur in a context of global and local conditions. The course examines and compares good solutions to urban problems in third and first world cities. In its focus on delivery-level administration and politics, the course provides both intellectual and practical closure to the major sequence of courses on public administration, management and the policy process.	Monday to Thursday 7th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP purposes MUST be submitted by the last day of the course.	Coursework counts 50%; final two-hour examination counts 50%.	\N	POL3038S	POL	S	POL	S
GLOBAL GOVERNANCE	30	7	Associate Professor Z Jolobe	Any 2000-level POL course or with special permission from the Head of Department.	None	\N	Global governance refers to the way in which global affairs are managed in the absence of a global government, and involves a broad range of actors including states, international and regional organisations. This course provides an overview of the existing architecture of global governance, explores the management of selected global issues, and considers debates and new trends in global governance.	6th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP MUST be submitted by the last day of the course.	Coursework 50%; final exam 50%.	\N	POL3045S	POL	S	POL	S
PHYSICAL GEOLOGY	24	6	Associate Professor A Sloan	GEO2001F, PHY1031F or equivalent	\N	\N	This course builds on the previous mineralogy course and explores the physical structure of the Earth and the physical processes involved in sedimentary rock formation and rock deformation. These include transport and deposition of sediments; sedimentary textures and structure; siliciclastic, carbonate, evaporitic and other sedimentary rocks; earthquakes, stress, displacement and strain; brittle and ductile deformation; interpretation of geological maps and cross sections; introduction to tectonics and global geophysics.	Monday - Friday, 2nd period	An average of 30% in marked class work, and attendance at 80% of practicals.	Class tests and practicals count 25%; one 2-hour practical examination in November counts 30%; one 2-hour theory examination in November counts 45%. Subminima of 40% are required in practical and theory examination papers.	\N	GEO2004S	GEO	S	GEO	S
SOUTH AFRICAN POLITICAL THOUGHT	30	7	Associate Professor T Reddy	Any 2000-level POL course or with special permission from the Head of Department.	\N	\N	This course helps students to understand the complex relationships between Western, African, and South African Political Thought. The course introduces students to some of the key ideas in these traditions of political theory and explores some of the interactions between them. In particular, students will investigate the development of ideas concerning colonial rule and the nationalist responses to that rule, which together constitute a rich and complex literature. The themes address over the course will include the Western enlightenment, colonial modernity, nationalism and democracy.	4th period.	Tutorial attendance is compulsory and students who attend fewer than 85% of the tutorials will not be allowed to write the final examination. In addition, completion of all written assignments, essays and tests are a requirement for a DP. Should students fail to hand in written assignments by due date, they will be penalised according to the grading formula of the Department. All required work for DP MUST be submitted by the last day of the course.	Coursework 50%; final exam 50%.	\N	POL3046S	POL	S	POL	S
CHEMISTRY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates for the PhD degree must submit a thesis on an approved research topic, and are referred to Book 3, General Rules and Policies, in which the rules for the degree are set out.	\N	\N	\N	\N	CEM6000W	CEM	W	CEM	W
INTRODUCTION TO PSYCHOLOGY PART 1	18	5	TBA	Faculty admission. Admission to this course is restricted to students (a) registered for the major in Psychology, (b) for which the completion of this course is a degree-specific requirement (e.g., Social Work, Physiotherapy, Occupational Therapy, Speech and Communication Disorders [Speech Therapy and Audiology], or any other approved Health Sciences service programme), and (c) majoring in Organisational Psychology.	\N	\N	The course aims to introduce the student to some of the areas of specialisation within psychology. These include history of psychology, biopsychology and neuropsychology, memory, developmental psychology, psychopathology and psychotherapy, and learning and conditioning. Students are taught a great deal about plagiarism and develop skills necessary to write essays and prepare other submissions to the Department of Psychology.	Tuesday to Friday 1st or 5th period.	Satisfactory completion of all assignments by due date, attend at least 80% of tutorials, complete both class tests. In addition, obtain one Student Research Participation Programme (SRPP) point or equivalent.	Coursework (term assignments and tests) counts 50%; one two-hour examination in June counts 50%. Students are expected to complete the June examination as well as all coursework before being awarded a pass in this class.	\N	PSY1004F	PSY	F	PSY	F
INTRODUCTION TO PSYCHOLOGY PART 2	18	5	TBA	PSY1004F	\N	\N	This course builds on the content covered in Introduction to Psychology Part 1. There is emphasis on research methods, both quantitative and qualitative methods. The student is also introduced to other areas of specialisation, including intelligence, attention, emotion and motivation, personality and social psychology. With a focus on research methods, students develop skills necessary to write a research report and prepare other submissions to the Department of Psychology and to carry out conceptual analyses of research materials and results.	Tuesday to Friday 1st or 5th period.	Satisfactory completion of all assignments by due date, attend at least 80% of classroom tutorials, submit all statistics lab-based exercises, complete both class tests. In addition, obtain two Student Research Participation Programme (SRPP) points or equivalent.	Coursework (term assignments and tests) counts 50%; one two-hour examination in November counts 50%. Students are expected to complete the November examination as well as all coursework before being awarded a pass in this class.	\N	PSY1005S	PSY	S	PSY	S
SOCIAL AND DEVELOPMENTAL PSYCHOLOGY	24	6	TBA	PSY1004F and PSY1005S or equivalent.	None	\N	This course provides an introduction to two major areas of psychological research and theory. Social Psychology is taught in one half of the course. The social psychology module introduces students to some basic concepts and theories in social psychology, exposes students to current research within the field, and provides an opportunity for students to engage critically with existing theories and their relevance to the South African context. Some of the major topics covered will include race and racism, social identity and social change, intergroup contact, and social influence. Developmental psychology is taught in the other half of the course. The developmental psychology module focuses on understanding the changes and continuities that occur in children from conception through adolescence. The sessions will cover central theoretical issues and research strategies in developmental psychology, prenatal development, cognitive and language development, social and emotional development, and contexts of development.	Tuesday to Friday, 7th period.	Completion of all coursework, and 80% attendance at tutorials.	Coursework will be weighted at 50%, and will include completion of tutorial assignments, essays and tests as required. An exam at the end of the semester will be weighted 50%.	Was previously PSY2003S (Social Psychology and Intergroup Relations) and PSY2009F (Developmental Psychology)	PSY2013F	PSY	F	PSY	F
COGNITIVE NEUROSCIENCE AND ABNORMAL PSYCHOLOGY	24	6	Associate Professor G Lipinska	PSY1004F and PSY1005S	\N	\N	This course aims to introduce students to a variety of topics relevant to normal cognitive functioning as well as psychopathology. While one half of the course takes a neuroscientific approach, the other half of the course draws on psychological, sociocultural, cognitive and biological perspectives.	Tuesday to Friday, 7th period.	Completion of all coursework, attendance at all tutorials, and obtaining 3 points through the Student Research Participation Programme (SRPP).	Coursework: 70% (assignment submissions = 40% and class test = 30%) Exam: 30%.	Was previously PSY2010S (Cognition and Neuroscience) and PSY2011F (Clinical Psychology I)	PSY2014S	PSY	S	PSY	S
RESEARCH IN PSYCHOLOGY I	24	6	Professor C Ward	PSY1004F, PSY1005S; and meeting mathematics criterion for entrance into PSY1004F.	None	\N	This course introduces students to research in Psychology. We will cover four major approaches to research in Psychology, namely quantitative research methods, qualitative research methods, statistical analysis of data, and psychometrics.	Monday to Thursday, Meridian.	Completion of all coursework, 80% attendance at tutorials, and obtaining 3 points through the Student Research Participation Programme (SRPP).	Coursework will be weighted at 50%, and will include completion of tutorial assignments, and tests as required. An exam at the end of the semester will be weighted 50%.	Was previously PSY2006F (Research in Psychology I)	PSY2015F	PSY	F	PSY	F
DISCRETE MATHEMATICS (3DM)	18	7	Associate Professor D Erwin	MAM2010F, MAM2011F, and two of MAM2012S, MAM2013S and MAM2014S.			Graph theory, combinatorial counting, discrete probability theory, recurrences, algorithms, applications.	Monday - Friday, 4th period.				MAM3012S	MAM	S	MAM	S
CRITICAL PSYCHOLOGY	30	7	Dr R Makama	Students must have passed PSY1004F and PSY1005S and at least one 2000-level social science course.	\N	\N	This course has a central focus on the psychology of identities. It engages students to explore the role of psychology in examining issues of race, class, gender, sexuality, ethnicity, etc. Theoretical concepts from liberation psychology, postcolonial psychology and feminist psychology will be taught and discussed in relation to current debates in South Africa, and the African diaspora around identity differences. Tutorials may include practical exercises and case presentations.	Tuesday to Friday 5th period.	Completion of all coursework and attendance at tutorials as required.	Coursework (Tutorial assignments, group projects and individual written assignments) counts 100%	\N	PSY3005F	PSY	F	PSY	F
RESEARCH IN PSYCHOLOGY II	30	7	Professor C Tredoux	Students must have passed PSY2015F.	\N	\N	This course deepens and strengthens the introduction to research in PSY2006F. There are four central components: (a) research methods in psychology; (b) statistical analysis in psychology; (c) qualitative methods in psychology, and (d) psychological measurement. On completion of this course, students would have covered the following: analysis of group comparisons (including t-tests and analysis of variance); data modelling techniques (including table analysis and regression); psychometrics and psychological assessment (including item analysis, measurement of intelligence and neuropsychological assessment); qualitative techniques (including narrative and discourse analysis).	Tuesday to Friday 3rd period.	Completion of all coursework, at least 70% attendance at tutorials, as well as completion of 90 minutes in the Student Research Participation Programme (SRPP) or equivalent.	Coursework (projects and tests) counts 50%; one two-hour examination at the end of the semester counts 50% towards the final mark.	\N	PSY3007S	PSY	S	PSY	S
APPLIED COGNITIVE SCIENCE	30	7	Dr P Njomboro	Students must have passed PSY2015F and PSY2014S.	\N	\N	This course deals with various applications of cognitive science to practical and theoretical problems in psychology. Lectures and research projects offered in the course are aimed at developing students’ appreciation and understanding of the research methodologies and real world applications of cognitive science. Topics covered include connectionist architectures (neural networks), influences of biological cycles, drugs, and hormones on cognitive performance, the cognitive psychology of decision making, memory in the forensic arena, face recognition and reconstruction, clinical cognition, and evolutionary cognitive psychology among others.	Monday to Thursday Meridian.	Completion of all coursework, as well as completion of 90 minutes in the Student Research Participation Programme (SRPP) or equivalent and attendance of at least 5 tutorials.	Coursework: counts a total of 50%. This coursework is broken down into weekly tests (25%), and a group field project (25%). Examination: the two-hour examination in June counts 50% towards the final mark.	\N	PSY3009F	PSY	F	PSY	F
INTRODUCTION TO CLINICAL NEUROPSYCHOLOGY	30	7	Professor S Malcolm-Smith	Students must have passed PSY2015F and PSY2014S.	\N	\N	This course is designed to provide a broad general introduction to the field of clinical neuropsychology. Although the general focus of the course is on brain-behaviour relationships and ways in which cognition and behaviour are controlled by neural systems, we will take an approach that concentrates on the clinical presentation of human neurological dysfunction.	Monday to Thursday Meridian.	Completion of all coursework, attendance at a minimum of 5 tutorials, as well as completion of 90 minutes in the Student Research Participation Programme (SRPP) or equivalent.	Coursework (tests and tutorial response papers) counts 45%; one two-hour examination in November counts 55% towards the final mark.	\N	PSY3010S	PSY	S	PSY	S
CLINICAL PSYCHOLOGY II	30	7	Professor D Kaminer	Students must have passed PSY2014S.	\N	\N	This course introduces students to a number of critical debates shaping research and practice in the field of clinical psychology in South Africa. It provides an overview of the local mental health context, while exploring the problematics of diagnosis and intervention in respect of ‘race’, class, language, culture and gender. Particular attention is given to the debate around the ‘relevance’ of clinical psychology in South Africa. Additional topics include psychodynamic psychotherapy, community psychology and evidence-based practice.	Tuesday to Friday 5th period.	Completion of all coursework and attendance at tutorials as required.	Coursework (an essay, a test and tutorial assignments) counts 50%; one two-hour examination in November counts 50% towards the final mark. NOTE: Students who have passed PSY3004S will not be permitted to register for PSY3011S.	Was previously PSY3004S (Clinical Psychology II)	PSY3011S	PSY	S	PSY	S
CONSTITUTIONAL LAW	36	7	Dr N Ramalekana	Undergraduate LLB students: concurrent registration with PBL2001H and PVL2002H.Graduate LLB students: concurrent registration with PVL1003W, PVL1004F, PVL1008H, PVL2002H, PVL2003H.	\N	\N	The first part of the course provides an introduction to the history of South African constitutional law and basic concepts such as democracy, legitimacy, constitutionalism, federalism, separation of powers and the rule of law. It then considers the institutional framework provided by the South African Constitution in detail. The second part of the course focuses on the protection of human rights in the Constitution. It examines the operation of the Bill of Rights and, using both SA cases and the jurisprudence of constitutional courts in other jurisdictions as well as the European Court of Human Rights, considers freedom of speech, equality and affirmative action, the protection of property rights and social and economic rights among other issues.	\N	None	November examination (3 hour) 60%; The year mark contributes the remaining 40% of the mark.	Preliminary Level, whole year course	PBL2000W	PBL	W	PBL	W
CLIMATE CHANGE MINOR DISSERTATION	90	9	To be advised	EGS5012W (refer to entry in Department of Environmental and Geographical Science section)	\N	\N	The minor dissertation is based on a three- to six-month supervised research project, to be submitted at the end of January, with the possibility of extension to June of the next year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	GEO5005H	GEO	H	GEO	H
INTRODUCTORY STATISTICS	18	5	N Watson	A pass in any of MAM1004F/S or MAM1005H or MAM1031F or MAM1033F or MAM1020F/S or MAM1010F/S or MAM1110F/H.	\N	\N	This is an introductory statistics course aimed at exposing students to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This course is offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistics; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence intervals; introduction to hypothesis testing (including tests on means; tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using spreadsheet functions.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	(No first year students) STA1000F and STA1000S are identical courses offered in first and second semesters. Owing to the mathematics prerequisites, first-year students can only register for STA1000S in the second semester and STA1000F on completion of the mathematics prerequisite. One lecture per week, one workshop per week and one tutorial per week. A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1006S, STA1008F/S.	STA1000F	STA	F	STA	F
INTRODUCTORY STATISTICS	18	5	N Watson	A pass in any of MAM1004F/S or MAM1005H or MAM1031F or MAM1033F or MAM1020F/S or MAM1010F/S or MAM1110F/H or at least 45% for MAM1010F or MAM1004F or MAM1020F or MAM1031F or MAM1033F in the current year.	\N	\N	This is an introductory statistics course aimed at exposing students to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This course is offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistics; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence intervals; introduction to hypothesis testing (including tests on means, tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using spreadsheet functions.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	STA1000F and STA1000S are identical courses offered in first and second semesters. Owing to the mathematics prerequisites, first-year students can only register for STA1000S in the second semester and STA1000F on completion of the mathematics prerequisite. One lecture per week, one workshop per week, and one tutorial per week. A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1100S, STA1006S, STA1106H, STA1008F/S.	STA1000S	STA	S	STA	S
INTRODUCTORY STATISTICS	18	5	N Watson	Students should have obtained a DP for either STA1000F/S.	\N	\N	This is an introductory statistics course aimed at exposing students to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This course is offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistics; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence intervals; introduction to hypothesis testing (including tests on means, tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using spreadsheet functions.	\N	Satisfactory attendance of tests and completion of assignments and/or exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	(offered during summer and winter terms)	STA1000P/L	STA	L	STA	L
COMPUTATIONAL SCIENCE THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates for the PhD degree must submit a thesis on an approved research topic, and are referred to Book 3, General Rules and Policies, in which the rules for the degree are set out.	\N	\N	\N	\N	CEM6002W	CEM	W	CEM	W
MATHEMATICS HONOURS (EXTENDED2)	40	8	Dr F Ebobisse-Bille	A pass in MAM4100W.	MAM4014W	\N	This course, together with MAM4100W and MAM4014W, covers the content of MAM4000W over two years. Students in this course will do two modules in the first semester and the project (MAM4014W) in the second semester (total 80 credits).	\N	\N	As per MAM4000W	\N	MAM4110W	MAM	W	MAM	W
MATHEMATICAL STATISTICS I	18	5	S Salau	At least 60% in MAM1031F or MAM1033F or MAM1005H or MAM1020F/S or at least 70% in MAM1010F/S or MAM1004F and concurrent registration for MAM1032S or MAM1034S, or MAM1006H or MAM1012F/S or MAM1021S OR an average of at least 60% for both (MAM1031F & MAM1032S) or (MAM1033F & MAM1034S) or (MAM1020F/S & MAM1021S) or (MAM1005H & MAM1006H) or an average of least 70% for both (MAM1010F/S & MAM1012F/S).	\N	\N	This is an introduction to statistics: the study of collecting, analysing, and interpreting data. It is the key entry-point into a Mathematical Statistics major and hence it is compulsory for students intending to major in Mathematical Statistics. This course provides foundation knowledge in statistical theory, and is useful for any student who wishes for an introduction to the fundamentals of statistics, from a mathematical perspective. Topics covered include: Types of data variables. Exploratory data analysis. Grouping and graphing of data. Set theory and counting rules. Probability: conditional probabilities, independence. Bayes theorem. Random variables and values, probability mass and density functions, cumulative distribution functions. Population models and parameters: binomial, Poisson, geometric, negative binomial, hypergeometric. Uniform, exponential, Gaussian, expectation. Coefficient of variation. Sampling: sampling distribution t, Chi-square, F and their tables. Point and interval estimation. Sample size estimation. Hypotheses testing: Z-test and T-test (proportions, difference between two proportions, means, difference between two (means, difference between means: for independent samples and dependent samples). F-test (ratio of two independent variances). Chi- squared-test. Meaning of p-values. Bivariate data: scatterplot, simple linear regression and correlation.	Five lectures per week, Monday - Friday, 4th period	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1006S, STA1008F/S.	STA1006S	STA	S	STA	S
INTRODUCTORY STATISTICS FOR SCIENTISTS	18	5	Associate Professor R Altwegg	A pass in any of MAM1004F/S or MAM1005H or MAM1031F or MAM1033F or at least 45% for MAM1004F or MAM1031F or MAM1033F in the current year.	\N	\N	This course aims to provide an introduction to statistics for Science students, and the topics covered include: exploratory data analysis and summary statistics. Set theory. Probability: conditional probabilities, independence, Bayes theorem. Random variables. Probability mass and density functions. Binomial, Poisson, exponential, normal and uniform distributions. Sampling distributions. Confidence intervals. Hypothesis testing: Z-test and t-test (means, difference between means for independent and dependent samples). Chi-square test for independence and for Goodness-of-fit. Meaning of p-values. Determining sample size. Simple linear regression and measures of correlation. Practical data analysis will be taught using R. The course is the equivalent of STA1000S, in a biological setting.	Five lectures per week, Monday - Friday, 1st period.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 3-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1006S, STA1008F/S.	STA1007S	STA	S	STA	S
GEOLOGY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Prospective candidates are referred to the rules for the PhD degree in Book 3, General Rules and Policies.	\N	\N	\N	\N	GEO6000W	GEO	W	GEO	W
ADVANCED TOPICS IN COMPUTER SCIENCE HONOURS 2	12	8	Associate Professor C M Keet	Permission from the course convener.	\N	\N	The course aims to introduce students to advanced and cutting edge topics in Computer Science as they emerge as new areas of investigation or practice, and expose students to new research specialisations in the department. Students will obtain an advanced theoretical understanding of the topic and the ability to apply practically skills learnt related to this specific topic.	\N	None	Exam: 50% and Coursework: 50%	This course will not be offered every year.	CSC4010Z	CSC	Z	CSC	Z
DATA SCIENCE MINOR DISSERTATION	90	9	TBC				The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on an analysis of large data sets from Computational Biology.					IBS5005W	IBS	W	IBS	W
STATISTICS FOR ENGINEERS	12	5	A Paskaramoorthy	MAM1020F (or equivalent)	CHE1005W or CIV1005W or EEE1006F or MEC1005W	\N	This course aims to introduce engineering students to the basic concepts and tools of Statistics which are of particular relevance in an engineering context, and to enable students to apply these to data collected from engineering experiments. Topics include: Random variables, sampling and basic statistical measures; Normal, t, F and Chi-square distributions; Confidence intervals; Statistical models, such as the means and the effects models; t, F and Chi-square tests; Regression and correlation; One-way analysis of variance; Introduction to the design of experiments; Application of statistical tools to experimental data in an engineering setting.	\N	Satisfactory attendance of workshops and tests and completion of online quizzes as set out in the course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1006S, STA1008F/S.	STA1008F	STA	F	STA	F
STATISTICS FOR ENGINEERS	12	5	A Paskaramoorthy	MAM1020F (or equivalent)	CHE1005W or CIV1005W or EEE1007S or MEC1005W	\N	This course aims to introduce engineering students to the basic concepts and tools of Statistics which are of particular relevance in an engineering context, and to enable students to apply these to data collected from engineering experiments. Topics include: Random variables, sampling and basic statistical measures; Normal, t, F and Chi-square distributions; Confidence intervals; Statistical models, such as the means and the effects models; t, F and Chi-square tests; Regression and correlation; One-way analysis of variance; Introduction to the design of experiments; Application of statistical tools to experimental data in an engineering setting.	\N	Satisfactory attendance of workshops and tests and completion of online quizzes as set out in the course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1006S, STA1008F/S.	STA1008S	STA	S	STA	S
INTRODUCTORY STATISTICS	18	5	N Watson	A pass in any of MAM1110F or MAM1110H or MAM1005H or MAM1031F or MAM1033F or MAM1010F/S or at least 45% for MAM1110F or MAM1031F or MAM1033F or MAM1010F in the current year and registered as an Education Development Unit student (Commerce).	\N	\N	This is an introductory statistics course aimed at exposing student to principles and tools to support appropriate quantitative analysis. The aim is to produce students with a functional sense of statistics. We introduce students to statistical modelling and also cover exploratory data analysis. Appropriate tools for display, analysis and interpretation of data are discussed. This is a service course offered predominantly, but not exclusively, to Commerce students. The aim is to give a foundation to students who will encounter and apply statistics in their other courses and professions. Topics covered include: exploratory data analysis and summary statistic; probability theory; random variables; probability mass and density functions; Binomial, Poisson, Exponential, Normal and Uniform distributions; sampling distributions; confidence interval; introduction to hypothesis testing (including tests on means, tabular data and bivariate data); determining sample sizes; simple linear regression and measures of correlation. Students are assessed on their knowledge of the topics covered and their ability to perform simple and appropriate statistical analyses using basic spreadsheet functions.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	Offered to EDU (Commerce) students only. One lecture per week, one workshop per week and one tutorial per week.	STA1100S	STA	S	STA	S
VISUALISATION	12	8	Professor M M Kuttel	Admission to BSc Hons specialising in Computer Science, or permission of the course convenor.	\N	\N	Visualisation is the graphical representation of data with the goal of improving comprehension, communication, hypothesis generation and decision making. This course aims to teach the principles of effective visualisation of large, multidimensional data sets. We cover the field of visual thinking, outlining current understanding of human perception and demonstrating how we can use this knowledge to create more effective data visualisations.	\N	40% for assignment component.	Students will be assessed with assignments (50%) and an exam (50%). A sub- minimum of 40% will be required for each of the assignment and exam components of the course.	This course will not be offered every year.	CSC4013Z	CSC	Z	CSC	Z
LINEAR ALGEBRA (2LA)	12	6	Dr H Spakowski	MAM1031F and MAM1032S or equivalent. With permission from the convener, students with 70% for both MAM1010F and MAM1012S may register for MAM2010F.	\N	\N	Students will study the fundamentals of linear algebra, including: Vector spaces, linear independence, spans, bases, row space, column space, null space; Linear maps; Eigenvectors and eigenvalues; Inner product spaces, orthogonality. Please note that lectures alternate during the week so that students can take MAM2010F and MAM2011F concurrently.	Mondays, Thursdays and some Wednesdays in 5th period.	\N	\N	\N	MAM2011F	MAM	F	MAM	F
MATHEMATICAL STATISTICS I	18	5	T Low	At least 60% in MAM1005H or MAM1020F/S or at least 70% in MAM1010F/S and concurrent registration for MAM1006H or MAM1012F/S or MAM1021S. Concurrent registration for (MAM1031F and MAM1032S) or (MAM1033F and MAM1034S)OR an average of at least 60% for both (MAM1031F & MAM1032S) or (MAM1033F & MAM1034S) or (MAM1020F/S & MAM1021S) or (MAM1005H & MAM1006H) or an average of least 70% for both (MAM1010F/S & MAM1012F/S).Note: At least 60% pass for MAM1031F or MAM1033F is required for a student to continue with STA1106H in the second semester.	\N	\N	This course is an introduction to statistics: the study of collecting, analysing, and interpreting data. It is the key entry-point into a mathematical statistics major and hence it is compulsory for students intending to major in mathematical statistics. This course provides you with foundation knowledge in statistical theory, and is useful for any student who wishes for an introduction to the fundamentals or statistics, from a mathematical perspective. Topics covered include: Types of data variables. Exploratory data analysis. Grouping and graphing of data. Set theory and Counting rules. Probability: conditional probabilities, independence. Bayes theorem. Random variables and values, probability mass and density functions, cumulative distribution functions. Population models and parameters: Binomial, Poisson, Expectation. Coefficient of variation. Sampling: Sampling distributions t, Chi- Square, F and their tales. Point and interval estimation. Sample size estimation. Hypotheses testing: Z-test and t-test (means, difference between means: for independent samples and dependent samples). F-test (ratio of two independent variances). Chi-square-test. Meaning of p-values. Bivariate data: scatterplot, simple linear regression and correlation.	Monday - Friday, 2nd period and a two-hour compulsory tutorial on Monday afternoons.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline. Students write the same class tests and examination as students registered for STA1006S. Second-Year Courses	A student cannot obtain credits for more than one of STA1000F/S/P/L, STA1007S, STA1106H, STA1008F/S. At least 60% pass for MAM1031F or MAM1033F is required for a student to continue with STA1106H in the second semester. Course outline: This course is an introduction to statistics: the study of collecting, analysing, and interpreting data. It is the key entry-point into a mathematical statistics major and hence it is compulsory for students intending to major in mathematical statistics. This course provides you with foundation knowledge in statistical theory, and is useful for any student who wishes for an introduction to the fundamentals or statistics, from a mathematical perspective. Topics covered include: Types of data variables. Exploratory data analysis. Grouping and graphing of data. Set theory and Counting rules. Probability: conditional probabilities, independence. Bayes theorem. Random variables and values, probability mass and density functions, cumulative distribution functions. Population models and parameters: Binomial, Poisson, Expectation. Coefficient of variation. Sampling: Sampling distributions t, Chi- Square, F and their tales. Point and interval estimation. Sample size estimation. Hypotheses testing: Z-test and t-test (means, difference between means: for independent samples and dependent samples). F-test (ratio of two independent variances). Chi-square-test. Meaning of p-values. Bivariate data: scatterplot, simple linear regression and correlation. Lecture times: Monday - Friday, 2nd period and a two-hour compulsory tutorial on Monday afternoons. DP requirements: Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%. Assessment: Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline. Students write the same class tests and examination as students registered for STA1006S. Second-Year Courses	STA1106H	STA	H	STA	H
GEOCHEMISTRY DISSERTATION	180	9	\N	\N	\N	\N	This course consists of an investigation of an approved topic chosen for intensive study by the candidate (student), culminating in the submission of a dissertation. The dissertation shall demonstrate the successful completion of a programme of training in research methods, a thorough understanding of the scientific principles underlying the research and an appropriate acquaintance with the relevant literature. It must be clearly presented and conform to the standards of the department and faculty. The dissertation will usually consist of a report detailing the conduct, and analysis of the results of, research performed under the close guidance of a suitably qualified supervisor/s. The dissertation should be well-conceived and acknowledge earlier research in the field. It should demonstrate the ability to undertake a substantial and informed piece of research, and to collect, organise and analyse material. General rules for this degree may be found at the front of the handbook.	\N	\N	\N	\N	GEO5003W	GEO	W	GEO	W
EMBEDDED SYSTEMS II FOR SCIENCE STUDENTS	18	7	Associate Professor S Winberg	EEE2050F			This course focuses on embedded systems architectures, firmware and software tool stacks. This course builds on the Embedded Systems I course. Consideration for Internet of Things (IoT) is included in the form of design scenarios and project-based learning. The course is split into two parts. Part 1 (10 credits) covers: theory and practices of design and analysis through modeling and simulation of embedded systems; embedded operating systems, and methods for modelling and simulation of computer systems are studied. An introduction to Linux command line and source code version control are also taught. Part 2 (6 credits) introduces Hardware Description Language (HDL) programming and computer architecture fundamentals; and tools for developing gateware and simulating HDL designs. Part 1 practicals concern using a single board computer, deploying and using an embedded operating system, building applications using a cross-compiler tool stacks, and hardware software interfaces – the practical work culminates in Miniproject A, which requires the use of taught tools to design, analyse and implement an IoT application. Part2 practicals involve implementing a combination logic design and developing a small HDL testbench to analyse its behavior. Those completing the course for 18 credits (Computer Science students) are required to complete a more demanding Miniproject B which adds software features to the Miniproject A baseline and requires additional performance and throughput testing.		Please refer to the official course handout document for detailed information regarding the DP requirements for this course.	Please refer to the official course handout document regarding the assessment criteria for this course.		EEE3095S	EEE	S	EEE	S
MATHEMATICS HONOURS	160	8	Dr F Ebobisse-Bille	(i) 65% or higher for MAM3000W (or the equivalent at another institution), and, (ii) The average of the four marks for MAM1000W, MAM1019H, MAM2000W, and MAM3000W (or the equivalents at another institution) should be 65% or higher. In all cases acceptance is subject to individual approval by the Head of Department.	\N	\N	This course provides an introduction to some topics that are basic to a professional mathematician. Students do a mathematics project, at least three of the four core modules in Algebra, Analysis, Differential Geometry, and Topology, and other modules for a total of at least 160 credits (most modules are 20 credits; the project, which consists of a thesis and two seminars, is 40 credits total). Students have some flexibility in selecting their other modules but all curricula must be approved by the convenor. The decision about which modules will be offered is made by the Department, but typically includes (in addition to the previously mentioned core modules) a selection from such topics as Algebraic Geometry, Category Theory, Computational Complexity, Cryptology, Differential Topology, Functional Analysis, Graph Theory, Homological Algebra, Lie Algebras, Measure Theory, Number Theory, Operator Theory, Partial Differential Equations, and Theory of Hamiltonian Groups. Students may, with permission from the convenor and with agreement from a suitable supervisor in the Department, pursue reading modules on topics that are not offered as taught modules.	\N	\N	The project counts 25% of the final mark and must be passed (with 50%). On average, the examination counts at least 50% of the balance of the final mark for the course. Three core modules together count 37.5% of the final mark. The remaining 37.5% of the final mark is calculated using the student’s best marks in their other modules. These component parts of the course will be combined in a final overall mark which will be reflected against the course code MAM4000W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code MAM4000W will not carry an NQF credit value, students will be concurrently registered for MAM4013W (coursework component of 120 NQF credits) and MAM4014W (research project of 40 NQF credits). Students registered for MAM4000W are expected to tutor in the Department of Mathematics and Applied Mathematics.	MAM4000W	MAM	W	MAM	W
ASTROPHYSICS & SPACE SCIENCE MINOR DISSERTATION	90	9	\N	AST5003F DP requirements: None. Assessment: Students will work on an approved research topic on which a minor dissertation must be presented for formal examination.	\N	\N	\N	\N	None.	Students will work on an approved research topic on which a minor dissertation must be presented for formal examination.	(National Astrophysics & Space Science Programme (NASSP); for further details see entry under Department of Astronomy)	PHY5003W	PHY	W	PHY	W
STATISTICAL THEORY & INFERENCE	24	6	M Mavuso	A pass in (MAM1000W or MAM1032S or MAM1034S or MAM1012S or MAM1006H) and STA1006S or STA1106H.	\N	\N	STA2004F is a rigorous introduction to the foundation of the mathematical statistics and aims to provide students with a deeper understanding of the statistical concepts covered in STA1006S. The course is intended for students studying Mathematical Statistics or Actuarial Science. STA2004F is divided into two broad sections: (1) Distribution theory and (2) Statistical Inference. During the first part of the course, students will learn to derive the distributions of random variables and their transformations, and explore the limiting behaviour of sequences of random variables. The last part of the course covers the estimation of population parameters and hypothesis testing based on a sample of data.	Five lectures per week, Monday to Friday, 1st period.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for both STA2004F and STA2030S.	STA2004F	STA	F	STA	F
LINEAR MODELS	24	6	Dr B Erni	A pass in STA2004F. MAM2011F - Linear Algebra (2LA) is strongly recommended.	\N	\N	This course gives an introduction to statistical modelling and the theory of linear statistical models. The material is presented from a parametric and non-parametric perspective. The course has two sections: Regression: The multivariate normal distribution; quadratic forms; the linear model; maximum likelihood; estimates of parameters in the linear model; the Gauss-Markov theorem; variable selection procedures; analysis of residuals, bootstrap sampling; principal component analysis for dimension reduction and for regression. Design and analysis of experiments: Introduction to the basic design principles, basic experimental designs (completely randomised design, the randomised block design, Latin square design) factorial experiments, analysis of variance, the problem of multiple comparisons, power and sample size calculations, introduction to random effects and repeated measures, permutation/randomization tests, nonparametric tests, bootstrapping. The students are introduced to relevant statistical software and practical data analysis through weekly computer practicals and the exposure to many datasets.	Five lectures per week, Monday - Friday, 1st period.	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline. STA2007F/S/H STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS This course is offered in blended learning format. A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S. 24 NQF credits at NQF level 6 Convener: Associate Professor R Altwegg Course entry requirements: A pass in STA1000F/S or STA1006S or STA1007S or STA1106H or STA1100S or STA1008F/S) and (MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1005H or MAM1010F/S or MAM1020F/S or MAM1110F/H) Course outline: The course aims to equip students with practical experience and skills in analysing data, using statistical techniques frequently used in the sciences. The skills include designing experiments, choosing appropriate statistical methods for visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding of limitations of statistical methods and data. By the end of the course the student should have gained enough confidence to transfer these skills to new problems or data sets in their own profession. Topics covered include: Introduction to statistical notation, linear regression, design and analysis of experiments, generalized linear models. There will be strong emphasis on the practical application of the above methods, using open-source statistical software such as R. There will be a one-day face-to-face workshop at the beginning of the first semester and a one-day face-to-face workshop at the beginning of the second semester. DP requirements: Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35% . Assessment: Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2005S	STA	S	STA	S
LABOUR LAW - SUMMER TERM	18	6	TBA	No undergraduate student in his/her first year of study may take Labour Law. It is recommended that students have passed a foundation course in law, e.g. Business Law I.	\N	\N	Refer to course outline for CML2005F.	Lectures are offered on a daily basis for three hours over a four-week period.	Writing the test is compulsory. If a student does not write the test and does not get an exemption then the student will be marked absent and awarded 0 for the test. But the student will be able to write the exam	Test 40%; final examination 60%	\N	CML2005P	CML	P	CML	P
FUNCTIONS OF A COMPLEX VARIABLE (3CV)	18	7	To be advised	MAM2014S, MAM2040F, MAM2041F, MAM2042S and MAM2043S.			Complex calculus, calculus of residues, special functions, applications to physics. Please note that lectures alternate during the week so that students can take MAM3044F and MAM3042F concurrently.	Monday - Friday, 3rd period.		Class record counts up to 50%, while the balance is given by the final examination.		MAM3044S	MAM	S	MAM	S
SELECTED HONOURS MODULE IN COMPUTER SCIENCE	12	8	Associate Professor C M Keet	Permission from the course convener.	\N	\N	This course introduces advanced and cutting edge topics in Computer Science as they emerge with new areas of investigation or practice.	\N	None	Exam: 50% and Coursework: 50%	This course will not be offered every year.	CSC4007Z	CSC	Z	CSC	Z
APPLIED MATHEMATICS HONS (EXTENDED2)	40	8	Dr F Ebobisse-Bille	A pass in MAM4101W.	MAM4016W	\N	This course, together with MAM4101W and MAM4016W, covers the content of MAM4001W over two years. Students in this course will do two modules in the first semester and the project (MAM4016W) in the second semester (total 80 credits).	\N	\N	As per MAM4001W	\N	MAM4111W	MAM	W	MAM	W
STOCHASTIC PROCESSES & TIME SERIES	36	7	D Katshunga	STA2004F and STA2005S; MAM2000W or MAM2004H is strongly recommended. Recommended MAM2000W modules: MAM2011F - Linear Algebra (2LA), MAM 2010F - Advanced Calculus (2AC), MAM2012S - Differential Equations (2DE) and MAM2014S - Real Analysis (2RA).	\N	\N	This course forms part of the third-year major in Mathematical Statistics. It consists of two modules namely Stochastic Processes and Time Series Analysis. The Stochastic Processes module is aimed at providing introductory theory and basic applications of stochastic processes in financial modelling whilst the Time Series module introduces students to the foundations of the Box-Jenkins methodology with the intention of applying the methodology using statistical software. Details of the module content are as follows: Stochastic processes: The module covers the general theory underlying stochastic processes and their classifications, definitions and applications of discrete Markov chains. Branching processes are examined with an emphasis on analysing probability of extinction/survival. The module also covers both discrete and continuous time counting processes for purposes constructing forecasts and backcasts. Finally, a detailed introduction to homogeneous and non-homogeneous Poisson processes is given. Time series analysis: The module covers various topics including global and local models of dependence, stationary ARMA processes, unit root processes as well as a brief introduction to univariate Volatility models as well as cointegration.	Five lectures per week, Monday - Friday, 1st period	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for both STA3030F and STA3041F.	STA3041F	STA	F	STA	F
STUDY DESIGN & DATA ANALYSIS FOR SCIENTISTS	24	6	Associate Professor R Altwegg	A pass in STA1007S (preferably) or STA1000F/S or STA1006S or STA1106H or STA1100S or STA1008F/S) and (MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1005H or MAM1010F/S or MAM1020F/S, MAM1110F/H).	\N	\N	The course aims to equip students with practical experience and skills in analysing data and applying statistical techniques relevant to the natural sciences. Skills include designing experiments, choosing appropriate statistical methods for analysing data, visual display and statistical modelling of data, model checking, interpretation and reporting of statistical results, and understanding limitations of statistical methods and data. Topics include: introduction to statistical notation, linear regression, design and analysis of experiments, generalised linear models. There will be a strong emphasis on the practical application of these methods using the open-source statistical software R. There will be a one-day face-to-face workshop at the beginning of the first semester and a one-day face-to-face workshop at the beginning of the second semester.	\N	Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 40% and a 2-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	This course is offered in blended learning format during summer term dependent on there being sufficient demand and dependent on capacity to offer course. Note that request for offering course in any one year should come from a UCT course convener. Students make use of online learning workshops.	STA2007P	STA	P	STA	P
STATISTICAL MODELLING & BAYESIAN ANALYSIS	30	7	Dr E Pienaar	STA2004F & STA2005S and MAM200W strongly recommended. Recommended MAM2000W modules: 2LA - LINEAR ALGEBRA, 2AC - ADVANCED CALCULUS, 2DE - DIFFERENTIAL EQUATIONS, 2RA - REAL ANALYSIS. Registered for a BCom or BBusScience degree in Actuarial Science.	STA3047S		This course forms part of the third-year major in Mathematical Statistics. It consists of three modules: The first, Generalised Linear Models, introduces students to the theory and application of fitting linear models to various types of response variables with different underlying distributions. Subsequently, elementary concepts and methods in machine learning within the framework of statistical learning are explored. Finally, the Introduction to Bayesian Analysis module is dedicated to the Bayesian paradigm of statistical inference, analysis, and risk theory. The contents of the respective modules are outlined as follows: Generalized linear models: Topics covered include: The exponential family of distributions, the GLM formulation, estimation and inference, models for continuous responses with skew distributions, logistic regression, log-linear models and Poisson regression. Introduction to Bayesian Analysis: Topics covered include: use of Bayes’ theorem; Bayesian statistical analysis for Bernoulli and normal sampling; empirical Bayes and credibility theory; loss and extreme value distributions; Monte Carlo methods.		Satisfactory attendance of lectures, tutorials, practicals and tests and completion of assignments and/or class exercises as set out in course outline. Class record of at least 35%.	Class record 30% and a 3-hour exam counting 70%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for both STA3043S and (STA3047S+STA3048S)	STA3048S	STA	S	STA	S
RESEARCH PROJECT IN MOLECULAR & CELL BIOLOGY	0	7	Associate Professor R Ingle	MCB3025F or MCB3026F (or concurrent registration in MCB3023S or MCB3024S).	\N	\N	Groups of students will select and perform a research project two afternoons per week by arrangement. The work will be written up in the form of a research paper. This course replaces practical classes for all the third year second semester MCB courses.	\N	None	Project counts 100%	\N	MCB3012Z	MCB	Z	MCB	Z
INTEGRATED ANATOMICAL AND PHYSIOLOGICAL SCIENCES PART B	24	6	Assoc Professor A Gwanyanya	HUB2019F (or approved equivalent) and CEM1000W (or approved equivalent).	\N	\N	This course is under review and the content may change as a result The course integrates aspects of human physiology, anatomy and histology of organ systems, including cardiovascular, respiratory, nervous, reproductive, urinary and immune systems. The SCIENCE DEGREES concept of integrating homeostasis and regulation forms the golden thread throughout this course. Homeostatic concepts covered include thermoregulation, acid-base balance, neural transduction, cardiac output and regulation, and respiration. Students are introduced to anthropology and to concepts of ageing and disease. In the practicals, students work in small groups using computers and specialised equipment to study the physiology of the nervous system, the electrical events in the contraction of cardiac muscle and the mechanics of the respiratory system. Students also examine human anatomical specimens of various organs and examine the histology of the organ systems. At the end of the course, students will have a thorough grounding in the physiological mechanisms of the nervous, urinary, cardiovascular, respiratory, reproductive, and immune systems. They will have an understanding of the basic anatomy and microanatomical organisation (histology) of key organs within the above bodily systems; will be able to integrate the concepts above in terms of understanding structure-function relationships, so as to understand the basic key elements that impact on the physiology of organs during ageing which leads to disease processes; and will be able to interpret data obtained from the various practicals.	Lectures: Monday to Friday (08h00-08h45); Practicals Mondays or Tuesdays (14h00-17h00).	Attendance at all practicals, 40% average in class tests and an average of 50% for all assignments.	The final mark comprises class tests (30%); practicals, assignments and tutorials (20%); and final examinations (50%), consisting of a written theory exam (30%) and a practical (20%). A subminimum of 40% is required for the theory and practical examination to pass this course. Supplementary examinations, in the form of written, practical or oral assessment, may be offered to students whose overall score is between 45% and 49%. An oral examination may be required in the case of selected students.	Entrance is limited to 80 students	HUB2021S	HUB	S	HUB	S
APPLIED HUMAN BIOLOGY	36	7	Associate Professor AN Bosch and Dr D Rae	HUB2019F; and HUB2021S or equivalent. Entry into this course requires a subminimum of 40% average for the Physiology component of HUB2017H and PTY2000S.	\N	Understanding the physiology pertaining to exercise and performance with a view to furthering study at the Honours level.	This course is under review and the content may change as a result. The semester theme is “Living, working and playing”. Topics dealt with include metabolism and homeostasis, sports nutrition and metabolism, obesity and diabetes, muscle physiology, cardio- respiratory physiology, sporting performance, exercise physiology, thermoregulation, and physiology in extreme environments. At the end of the course students should have a good understanding of the physiology related to movement, sport and exercise. They should understand physiological control, the basics of the physiological components underlying athletic performance, and energy balance and key components of sports nutrition. In addition, they should have a good understanding of the cardiovascular system, muscle function, and the effect of exercise on health, particularly diabetes and obesity. Students will prepare a seminar topic which will be presented as a PowerPoint presentation towards the end of the semester, during the “practical” time slot.	\N	Attendance at all practicals, (including tutorials and seminar presentations held during the “practical” time slot), 40% average in class tests and an average of 50% for all assignments.	Class tests (30%); practicals including assignments/seminar presentation (20%) and examinations (written theory and practical theory) (50%). A subminimum of 40% is required for the theory and practical examinations to pass this course. A subminimum of 40% is required for the theory and practical examination to pass this course. Supplementary examinations in the form of written, practical or oral assessment, may be offered to students whose overal score is 45 - 49%. An oral examination may be required in the case of selected students.	\N	HUB3006F	HUB	F	HUB	F
HUMAN NEUROSCIENCES	36	7	Dr R Dangarembizi	HUB3006F (or approved equivalent). Exceptions are at the discretion of the convener.		To obtain a good grasp of core theoretical and practical concepts of human neurophysiological function.	This course is under review and the content may change as a result. This course offers theoretical and practical instructions on advanced concepts in neuroscience, such as embryological development and repair of the nervous system, histological and gross anatomical appearances of the brain, electrophysiology, principles of electrical and morphological brain imaging, neuronal signalling, signal transduction in sensory, motor and autonomic nervous systems, vision and pain perception, eating disorders, mechanisms of learning and the development of memory. At the end of the course, students should be able to apply knowledge gained and practical skills acquired to solve problems in neurophysiology; read and critically evaluate neuroscience literature; apply knowledge of human physiology in medical fields in the general market place; use acquired skills in assisting with undergraduate practical demonstrations; and teach the basics of human physiology.	Five 45-minute lectures per week, 1st period, Monday to Friday.	Attendance at all practicals, 40% average mark for class tests and an average of 50% for all assignments.	Class tests (30%); practicals including assignments/seminar presentation (20%) and examinations (written theory and practical theory) (50%). A subminimum of 40% is required for the theory and practical examinations to pass this course. A subminimum of 40% is required for the theory and practical examination to pass this course. Supplementary examinations in the form of written, practical or oral assessment, may be offered to students whose overall score is 45 - 49%. An oral examination may be required in the case of selected students.		HUB3007S	HUB	S	HUB	S
DIRECTED READING & RESEARCH	36	7	\N	Only for students specialising in Archaeology, with permission of the Head of Department.	\N	\N	A flexible intensive study course in a specific area customised to the needs of individual students.	By arrangement	Completion of assignments.	Assignments count 20%; a long paper counts 40%; one 3-hour examination in November counts 40%.	\N	AGE3006H	AGE	H	AGE	H
CELL BIOLOGY	18	5	Associate Professor J M Bishop	Admission will be restricted to students who have passed either NSC Physical Science or Life Science with at least 60%. NOTE: Preference will be given to students registered in the Science Faculty. Students registered for this course will be assessed in week 5; if it is judged that they are not coping with the level and pace of the course and would benefit from an opportunity to strengthen foundational concepts and learn new material at a slower pace, they will be required to transfer to BIO1000H from week 7.	\N	\N	Basic biological principles and processes at a cellular level provide an essential grounding for future study in the life sciences. The structure and function of cell components is introduced, followed by an introduction to chemistry, including the structure and functions of biological macro-molecules. Cell division and the role of genetics in inheritance and the control of biological systems is then considered. This leads into an introduction to membrane physiology, metabolism and its regulation. Cellular processes that are considered in detail include the functioning of photosynthesis and cellular respiration, and how these relate to organismal physiology. Cellular communication and the immune system of animals complete the organismal physiology.	Monday - Friday, 5th period, Tutorials: One per week, by arrangement, Practicals: One afternoon per week, Monday, Tuesday, Wednesday or Thursday, 14h00 - 17h00. Attendance is compulsory for all lectures and practicals.	Completion of at least 80% of deliverables (tests, practicals, tutorials), including at least one class test and at least one practical test, and attendance of practicals; minimum of 40% for the class record.	Class record counts 40% (two class tests count 27%; two practical tests count 5%; and a practical bookmark counts 8%). One 2-hour examination paper (Theory) written in June counts 40%; a subminimum of 40% is required for this paper. One 1.5-hour examination paper (Practical) in June counts 20%.	\N	BIO1000F	BIO	F	BIO	F
8TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE8	\N	\N	\N	\N
1ST YEAR ELECTIVE NUMBER 1	18	1										ELEC1001	\N	\N	\N	\N
3RD YEAR ELECTIVE NUMBER 2	18	1										ELEC3002	\N	\N	\N	\N
CLIMATE CHANGE MINOR DISSERTATION	90	9	Dr M Norton	EGS5012W	\N	\N	The minor dissertation is based on a three- to six-month supervised research project, to be submitted at the end of January, with the possibility of extension to June the following year.	\N	\N	The minor dissertation must be presented for formal examination. The coursework and minor dissertation each count 50% towards the degree; each must be passed separately for the award of the degree.	\N	EGS5029H	EGS	H	EGS	H
PROJECT/INTERNSHIP IN APPLIED MATHEMATICS	0	7	Professor I V Barashenkov	\N	\N	\N	With permission from the Convenor, and subject to the availability of a suitable supervisor in the Department, students may complete a project or internship on a topic in Applied Mathematics. This is strongly recommended for students intending to continue to Honours in Applied Mathematics.	\N	\N	\N	\N	MAM3055Z	MAM	Z	MAM	Z
RESEARCH METHODS FOR NATURAL SCIENTISTS	30	8	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	The course has a dual purpose. Firstly, a series of weekly lectures and hands-on practical seminars on the nuts and bolts of quantitative analysis. The analysis techniques investigated are (mostly) the fundamental methods found commonly in the literature; viz: Classification, time series analysis, EOF/PCA, non-linear analysis. In parallel to this are a series of seminars on “the Philosophy of Science” addressing issues of values, perception, the science community, etc.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4023S	EGS	S	EGS	S
CLIMATE MODELLING	30	8	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	An introduction into the development and application of climate models for exploring climate dynamics, forecasting, and climate change. The course explores the inner workings of climate models, the use in operational seasonal forecasting in Africa (with hands-on work with the current forecasts), and actual running model experiments. Students are expected to have done EGS3012S or its equivalent.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4030F	EGS	F	EGS	F
CLIMATE MODELLING	30	8	To be advised	Acceptance for Honours or Master’s specialising in EGS.	\N	\N	An introduction into the development and application of climate models for exploring climate dynamics, forecasting, and climate change. The course explores the inner workings of climate models, the use in operational seasonal forecasting in Africa (with hands-on work with the current forecasts), and actual running model experiments. Students are expected to have done EGS3012S or its equivalent.	\N	At least 80% attendance record and submission of all assignments.	100% Coursework.	\N	EGS4030S	EGS	S	EGS	S
FINANCIAL ACCOUNTING AUGMENTED	18	5	B Diale	Registration for a BCom Accounting, BBusSci Finance with Accounting, or Actuarial Science degree through the Education Development Unit, or by permission of the department.	\N	\N	Financial Accounting is predominantly an applied discipline that is based on broad conceptual principles. The course develops an understanding of the business cycle and various decisions taken in a business. Particular emphasis is placed on recording financial transactions in accounting records and interpreting financial transactions through the application of definitions and recognition criteria as set out in the conceptual framework.	Mon–Fri 10:00–11:00 or 11:00–12:00	Attendance at and submission of a minimum of 70% of tutorials AND a weighted average of 35% for class tests (excluding objective tests) and having written at least one class test AND an average of 35% for assignments.	Coursework: 35% Exam: 65%	\N	ACC1106F	ACC	F	ACC	F
TERTIARY MATHEMATICS EDUCATION THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Candidates are referred to the rules for this degree as set out in Book 3, General Rules and Policies.	\N	\N	\N	\N	MAM6002W	MAM	W	MAM	W
BIOLOGICAL INFORMATION TRANSFER	24	6	Dr P Meyers	CEM1000W or equivalent, BIO1000F and BIO1004S (or equivalent).	\N	\N	This course introduces students to fundamental concepts in genetics and examines how biological information is organised, used and transferred in viruses, prokaryotes and eukaryotes. Topics covered include the biological explanations for Mendel's laws of genetics, principles of evolutionary genetics, genome organisation, horizontal gene transfer and gene structure and regulation.	Monday - Friday, 4th period	50% average for assignments and practical reports; attendance at all practicals and tutorials.	Tests and assignments count 40%; practicals count 10%; one three-hour paper written in June counts 50%. A subminimum of 40% in the examination is required.	Entrance is limited to 140 students. Registration for this course is provisional until confirmed by the department. Should the limit be exceeded students will be ranked on CEM1000W (or equivalent) marks. No semester abroad students will be admitted to this course.	MCB2020F	MCB	F	MCB	F
FUNCTIONS OF A COMPLEX VARIABLE (3CV)	18	7	To be advised	MAM2014S, MAM2040F, MAM2041F, MAM2042S and MAM2043S.	\N	\N	Complex calculus, calculus of residues, special functions, applications to physics. Please note that lectures alternate during the week so that students can take MAM3044F and MAM3042F concurrently.	Monday - Friday, 3rd period.	\N	Class record counts up to 50%, while the balance is given by the final examination.	\N	MAM3044F	MAM	F	MAM	F
EVIDENCE-BASED MANAGEMENT	18	5	J Rousseau	Admission as First Year Faculty of Commerce students, or by permission of Head of the School.			This course equips students with crucial intellectual resources for facing the challenges presented by a globalised knowledge-dependent economy. Its focus is on developing critical reasoning skills, in particular competence at, and confidence in, assessing the quality of available evidence; distinguishing disinformation from misinformation, and understanding the influence of social media on shaping judgments and decision-making. Students will learn how to use evidence and sound argumentation to reach well-justified conclusions, and to then efficiently and persuasively communicate those conclusions to relevant stakeholders. Practically, the course uses case studies of contemporary debates on social and traditional media to emphasise the importance of understanding commercial activity as occurring within particular social and political environments, and on how those environments can affect our ability to make rational decisions.		Submission of all coursework assignments. Achieving a weighted average of at least 40%.	Coursework 75%; Capstone assessment 25%. A sub-minimum of 45% must be achieved in the capstone assessment.	First year status, first or second semester, (depending on degree stream).	BUS1036F	BUS	F	BUS	F
APPLIED MATHEMATICS HONOURS	160	8	Dr F Ebobisse-Bille	(i) 65% or higher for MAM3040W (or the equivalent at another institution), and, (ii) The average of the three marks for MAM1043H/1044H, MAM2046W, and MAM3040W (or the equivalents at another institution) should be 65% or higher. In all cases acceptance is subject to individual approval by the Head of Department.	\N	\N	This course provides an introduction to a selection of topics in applied mathematics. Students do an applied mathematics project and modules for a total of at least 160 credits (most modules are 20 credits; the project, which consists of a thesis and two seminars, is 40 credits total). Each student’s curriculum must be approved by the convenor and must include a minimum of 60 credits of applied mathematics modules taught by MAM (CERECAM and DMTCS modules are considered in this category). There is considerable flexibility in the structure of individual curricula and students are encouraged to include suitable modules from MAM4000W and from cognate departments (for example: Computer Science, Physics, Statistics, Economics, Oceanography). The decision about which modules will be offered is made by the Department, but typically includes a selection from such topics as Advanced Mathematical Methods, Continuum Mechanics, Finite Element Analysis, Mathematical Biology, General Relativity and Cosmology, and String Theory. Students may, with permission from the convenor and with agreement from a suitable supervisor in the Department, pursue reading modules on topics that are not offered as taught modules.	\N	\N	The project and seminar together count 25% of the final mark and must be passed (with 50%). On average, the examination counts at least 50% of the balance of the final mark for the course. At least 37.5% of the final mark must come from the previously mentioned applied mathematics modules taught by MAM. The remaining 37.5% of the final mark is calculated using the student’s best marks in their other modules. These component parts of the course will be combined in a final overall mark which will be reflected against the course code MAM4001W, with PA (pass) entered against the coursework and project codes; each of these components must be passed separately for the award of the degree.	Since the code MAM4001W will not carry an NQF credit value, students will be concurrently registered for MAM4015W (coursework component of 120 NQF credits) and MAM4016W (research project of 40 NQF credits). Students registered for MAM4001W are expected to tutor in the Department of Mathematics and Applied Mathematics.	MAM4001W	MAM	W	MAM	W
APPLIED MATHEMATICS HONOURS (EXTENDED1)	80	8	Dr F Ebobisse-Bille	(i) 60% or higher for MAM3040W, and, (ii) The average of the three marks for MAM1043H/1044H, MAM2046W, and MAM3040W should be 60% or higher. In all cases acceptance is subject to individual approval by the Head of Department.	\N	\N	This course, together with MAM4111W and MAM4016W, covers the content of MAM4001W over two years. Students in this course will do two core modules in the first semester and two more modules in the second semester (total 80 credits).	\N	\N	As per MAM4001W	\N	MAM4101W	MAM	W	MAM	W
2ND YEAR ELECTIVE NUMBER 2	18	1										ELEC2002	\N	\N	\N	\N
3RD YEAR ELECTIVE NUMBER 1	18	1										ELEC3001	\N	\N	\N	\N
4TH ELECTIVE OF YOUR DEGREE	18	1										ELECTIVE4	\N	\N	\N	\N
3RD YEAR ELECTIVE NUMBER 3	18	1										ELEC3003	\N	\N	\N	\N
DATA SCIENCE MINOR DISSERTATION	90	9	Dr S Er	Successful completion of the coursework component of the Masters course in Data Science.	\N	\N	The research component of the degree is based on a 90 credit dissertation. The topic of the research will be based on an analysis of large data sets from Physics.	\N	\N	\N	\N	PHY5008W	PHY	W	PHY	W
APPLIED ETHICS	24	6	TBA	At least second year status.			The course involves the application of philosophical reasoning to real life practical and moral issues. It will be shown how rational argument can be brought to bear on the resolution of ethical dilemmas and difficult questions about what ought to be done. These may include issues concerning health care, business, the professions, the environment, or everyday life.	Monday, Tuesday, Wednesday 3rd period.	Regular attendance at lectures and tutorials; completion of all tests, submission of all essays and assignments by due dates, and an average mark of at least 35% for the coursework.	Coursework counts 40%; one 3-hour examination in June counts 60%.	(May not be offered in 2025)	PHI2037S	PHI	S	PHI	S
FLUID DYNAMICS (3FD)	18	7	Professor A Malan	MAM2040F, MAM2041F, MAM2042S and MAM2043S.			Applications, description of fluids, equations of fluid flow for simple fluids, analytical techniques.	Monday and Tuesday, meridian. Thursday, 5th period.				MAM3046F	MAM	F	MAM	F
MATHEMATICS 1010	18	5	To be advised	At least 60% in NSC Mathematics or 50% on Higher Grade Mathematics (SC), or passes in both MAM1014F/MAM1022Fand MAM1015S.	\N	\N	The aim of this course is to introduce topics in mathematics that are of interest to Commerce students, with applications to economics. Introductory financial mathematics including compound interest and annuities, functions, limits, differential calculus and applications of the derivative including graph sketching and Newton’s Method, introduction to integral calculus and techniques of integration.	Monday - Friday, 1st or 4th period	Minimum of 30% in class tests and full attendance at workshops.	Semester up to 40% November examination 1 x 2 hour paper	\N	MAM1010S	MAM	S	MAM	S
GEOCHEMISTRY THESIS	360	10	\N	\N	\N	\N	The PhD is a research degree on an advanced topic under supervision which can be taken in any of the departments in the Faculty. Examination is by thesis alone. A candidate shall undertake doctoral research and advanced study under the guidance of a supervisor/s appointed by Senate. The thesis must constitute a substantial contribution to knowledge in the chosen subject, must show evidence of original investigation and give a full statement of the literature on the subject. The PhD degree demands that the candidate is able to conduct independent research on his/her own initiative. Through the thesis the candidate must be able to demonstrate that he/she is at the academic forefront in the topic selected, that the work is original and that it advances our knowledge in the relevant field. Prospective candidates are referred to the rules for the PhD degree in Book 3, General Rules and Policies.	\N	\N	\N	\N	GEO6001W	GEO	W	GEO	W
APPLIED STATISTICS	24	6	N Watson	A pass in STA1000F/S/P/L or STA1006S or STA1106H or STA1100S or STA1007S or STA1008F/S and MAM1000W or MAM1031F or MAM1033F or MAM1004F/S or MAM1010F/S or MAM1020F/S or MAM1110F/H or MAM1005H.	\N	\N	This course is designed to extend the student’s basic knowledge acquired in STA1000F/S/P/L. The emphasis of the course is on applying statistical methods and modelling techniques to data rather than focusing on the mathematical rigour underpinning these methods. Topics covered include: Analysis of variance and experimental design; revision and extension of simple linear regression; multiple regression; logistic regression; model building; time series analysis; and non-parametric statistics. Students will analyse data using R.	Monday - Thursday, 1st or 5th period	Satisfactory attendance of lectures, lab practicals and tests and completion of weekly quizzes and lab practicals as set out in course outline. Class record of at least 35% and at least 35% for Practical test.	Class record 40% and a 3-hour exam counting 60%. Weights will be adjusted in the case of missed assessments, as detailed in the course outline.	A student cannot obtain credits for more than one of STA2020F/S, STA2007F/H/S, STA2005S.	STA2020F	STA	F	STA	F
BIOINFORMATICS FOR HIGH-THROUGHPUT BIOLOGY	15	9	TBC	\N	\N	\N	This course is aimed to introduce students to bioinformatics techniques related to processing, analysis and interpretation of high-throughput biological data. It will cover the analysis of next generation sequence data of different types (metagenomic, RNA-Seq and full genome); statistical analysis of NGS in relation to metadata associated with it; phylogenetic analysis of sequence data; and medical population genetics from NGS or array data. The students who complete the course will be skilled both in handling big biological data sets, and in their downstream interpretation.	\N	\N	\N	\N	IBS5004Z	IBS	Z	IBS	Z
PATHOGENESIS AND TREATMENT OF INFECTIOUS DISEASES	36	7	Doctor MR Abrahams (Division of Medical Virology) and Doctor C Moodley (Division	PTY2001S (or equivalent). This course is offered only in the 1st semester, therefore students who fail the course will need to repeat the following year.			The course aims to provide the conceptual basis for understanding pathogenic bacteria, fungi, viruses and parasites, and particularly address the fundamental mechanisms of how they cause disease in humans. A successful pathogen is able to invade the host and escape it’s immune defences. Building on PTY2001S, the parts of the immune system that are important in resisting infection will be covered. Examples of the wide range of ways in which pathogens evade immune responses will be discussed. Another important way in which we combat pathogens is through antimicrobial therapy for bacterial, viral, fungal and parasitic infections. Knowledge of the life cycles of pathogens enables us to identify targets for developing treatments. Antimicrobial resistance is an emerging threat. Students will learn about the mechanisms of antimicrobial resistance and novel approaches to combat this, as well as the role of antimicrobial stewardship. Students will be able to describe fundamental process that drive how pathogens cause disease and immune evasion, and how understanding pathogen life-cycles enables us to target treatment and control infections. Through blended learning, practical sessions, field visits and interaction with experts in public health and infectious diseases, this course aims to introduce students to a variety of different career avenues.		40% average in class tests or quizzes, and an average of 50% for assignments. Attendance at all practicals, field trips and tutorials. Submission of at least 80% of assignments.	The breakdown of course marks is as follows: the class record counts 60%; and one 3- hour final examination written in June counts 40%. The class record consists of class tests and/or SCIENCE DEGREES quizzes (20%), practical reports and tutorials (20%) and assignments (20%). Supplementary examinations, in the form of written assessment, may be offered to students whose overall score is 45-49%.		PTY3010F	PTY	F	PTY	F
FINANCIAL ACCOUNTING	18	5	J Kew	Registration for a BCom Accounting, BBusSci Finance with Accounting, or Actuarial Science degree, or by permission of the department.			Financial Accounting is predominantly an applied discipline that is based on broad conceptual principles. The course develops an understanding of the business cycle and various decisions taken in a business. Particular emphasis is placed on recording financial transactions in accounting records and interpreting financial transactions through the application of definitions and recognition criteria as set out in the conceptual framework. Student will also be required to prepare and present basic financial statements.	Tues, Wed, Thurs, Fri 13:00–14:00; 14:00–15:00	Attendance at and submission of a minimum of 70% of tutorials AND a weighted average of 35% for class tests (excluding objective tests) and having written at least one class test AND an average of 35% for assignments.	Coursework: 35% Exam: 65%		ACC1006F	ACC	F	ACC	F
FINANCIAL REPORTING I	18	5	J Winfield	ACC1006F. Registration for a BCom Accounting, BBusSci Finance with Accounting, or Actuarial Science degree, or by permission of the department.			Financial Reporting 1 covers the second semester of the first-year accounting syllabus. The standard has been set to the level required for those intending to become Chartered Accountants, and it is, therefore, an extremely demanding course. Topics include: companies; property, plant and equipment; statements of cash flows; liabilities; and financial analysis.	Fridays at either 13h00–13h45 or 14h00–14h45, and a double-period tutorial per week. Optional in-person learning Tues–Thurs.	A weighted average of 35% for class tests, having written at least one class test.	Coursework: 40% Exam: 60%. The coursework component may include participation.		ACC1011S	ACC	S	ACC	S
\.


--
-- Data for Name: courses_per_degree; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses_per_degree (course_degree_id, degree_id, course_id, course_group_id, year, notes) FROM stdin;
394	CB001INF06	CSC3002F	\N	3	\N
395	CB001INF06	INF3011F	\N	3	\N
396	CB001INF06	INF3014F	\N	3	\N
397	CB001INF06	BUS2033S	\N	3	\N
398	CB001INF06	CSC3003S	\N	3	\N
399	CB001INF06	INF3012S	\N	3	\N
175	CB019BUS01	ACC1006F	\N	1	\N
176	CB019BUS01	BUS1036F	\N	1	\N
177	CB019BUS01	CSC1015F	\N	1	\N
178	CB019BUS01	ECO1010F	\N	1	\N
179	CB019BUS01	MAM1031F	\N	1	\N
180	CB019BUS01	MAM1032S	\N	1	\N
181	CB019BUS01	BUS1003H	\N	1	\N
182	CB019BUS01	ACC1011S	\N	1	\N
183	CB019BUS01	ECO1011S	\N	1	\N
184	CB019BUS01	STA1006S	\N	1	\N
191	CB019BUS01	MAM2014S	17	2	
190	CB019BUS01	MAM2012S	17	2	
185	CB019BUS01	CML1001F	\N	2	\N
186	CB019BUS01	ECO2003F	\N	2	\N
187	CB019BUS01	STA2004F	\N	2	\N
188	CB019BUS01	MAM2010F	\N	2	\N
189	CB019BUS01	MAM2011F	\N	2	\N
192	CB019BUS01	BUS2016H	\N	2	\N
193	CB019BUS01	ECO2004S	\N	2	\N
194	CB019BUS01	FTX2024S	\N	2	\N
195	CB019BUS01	STA2005S	\N	2	\N
664	CB001ACC08	ACC1006F	\N	1	\N
665	CB001ACC08	ACC1015F	\N	1	\N
666	CB001ACC08	ECO1010F	\N	1	\N
667	CB001ACC08	MAM1010F	\N	1	\N
668	CB001ACC08	ACC1011S	\N	1	\N
669	CB001ACC08	ECO1011S	\N	1	\N
670	CB001ACC08	INF1002S	\N	1	\N
373	CB001INF06	ACC1021F	\N	1	\N
374	CB001INF06	ACC1022Z	\N	1	\N
375	CB001INF06	ECO1010F	\N	1	\N
376	CB001INF06	CSC1015F	\N	1	\N
382	CB001INF06	ECO1011S	\N	1	\N
383	CB001INF06	CSC1016S	\N	1	\N
380	CB001INF06	MAM1032S	3	1	\N
381	CB001INF06	ACC1011S	3	1	\N
671	CB001ACC08	STA1000S	\N	1	\N
672	CB001ACC08	CML1004S	\N	1	\N
673	CB001ACC08	ACC2022H	\N	2	\N
384	CB001INF06	BUS1036F	\N	2	\N
385	CB001INF06	CML1001F	\N	2	\N
386	CB001INF06	CSC2001F	\N	2	\N
387	CB001INF06	INF2006F	\N	2	\N
388	CB001INF06	INF2009F	\N	2	\N
389	CB001INF06	CSC2002S	\N	2	\N
390	CB001INF06	INF2011S	\N	2	\N
391	CB001INF06	PHI2043S	\N	2	\N
392	CB001INF06	STA1000S	\N	2	\N
393	CB001INF06	CSC2004Z	\N	2	\N
674	CB001ACC08	FTX2024F	\N	2	\N
196	CB019BUS01	BUS3018F	\N	3	\N
197	CB019BUS01	STA3041F	\N	3	\N
198	CB019BUS01	STA3045F	\N	3	\N
199	CB019BUS01	BUS3024S	\N	3	\N
200	CB019BUS01	PHI2043S	\N	3	\N
201	CB019BUS01	STA3047S	\N	3	\N
202	CB019BUS01	STA3048S	\N	3	\N
429	CB001INF11	ACC1021F	\N	1	\N
430	CB001INF11	ACC1022Z	\N	1	\N
433	CB001INF11	ECO1010F	\N	1	\N
434	CB001INF11	MAM1010F	\N	1	\N
435	CB001INF11	BUS1036S	\N	1	\N
436	CB001INF11	ECO1011S	\N	1	\N
437	CB001INF11	STA1000S	\N	1	\N
438	CB001INF11	MAM1012S	\N	1	\N
675	CB001ACC08	INF2004F	\N	2	\N
676	CB001ACC08	ACC2012W	\N	2	\N
442	CB001INF11	INF2007F	\N	2	\N
443	CB001INF11	INF2006F	\N	2	\N
444	CB001INF11	INF2009F	\N	2	\N
445	CB001INF11	INF2010S	\N	2	\N
446	CB001INF11	INF2011S	\N	2	\N
447	CB001INF11	FTX2024F	\N	2	\N
448	CB001INF11	ECO2003F	\N	2	\N
449	CB001INF11	ECO2004S	\N	2	\N
450	CB001INF11	CML1004S	\N	2	\N
451	CB001INF11	BUS2033S	\N	3	\N
452	CB001INF11	STA2020F	\N	3	\N
453	CB001INF11	INF3014F	\N	3	\N
454	CB001INF11	INF3011F	\N	3	\N
455	CB001INF11	FTX3044F	\N	3	\N
456	CB001INF11	FTX3045S	\N	3	\N
457	CB001INF11	PHI2043S	\N	3	\N
458	CB001INF11	INF3012S	\N	3	\N
677	CB001ACC08	ACC2018H	\N	2	\N
678	CB001ACC08	ACC2023H	\N	2	\N
431	CB001INF11	INF1002F	4	1	\N
432	CB001INF11	CSC1015F	4	1	\N
439	CB001INF11	INF1003F	5	1	\N
379	CB001INF06	MAM1031F	9	1	\N
378	CB001INF06	MAM1012S	8	1	\N
377	CB001INF06	MAM1010F	8	1	\N
637	CB001ECO03	ACC1021F	\N	1	\N
459	CB001INF11	CSC1016S	5	1	\N
480	CB001PHI03	ACC1021F	\N	1	\N
481	CB001PHI03	ACC1022Z	\N	1	\N
482	CB001PHI03	ECO1010F	\N	1	\N
483	CB001PHI03	PHI1024F	\N	1	\N
484	CB001PHI03	POL1004F	\N	1	\N
485	CB001PHI03	ECO1011S	\N	1	\N
486	CB001PHI03	MAM1010S	\N	1	\N
276	CB019BUS09	MAM2011F	\N	2	\N
275	CB019BUS09	MAM2010F	\N	2	\N
274	CB019BUS09	STA2004F	\N	2	\N
487	CB001PHI03	POL1005S	\N	1	\N
488	CB001PHI03	ECO2003F	\N	2	\N
489	CB001PHI03	INF1002F	\N	2	\N
490	CB001PHI03	ECO2004S	\N	2	\N
491	CB001PHI03	ECO2007S	\N	2	\N
492	CB001PHI03	PHI1010S	\N	2	\N
493	CB001PHI03	STA1000S	\N	2	\N
499	CB001PHI03	POL2043S	12	2	\N
498	CB001PHI03	POL2042S	12	2	\N
273	CB019BUS09	ECO2003F	\N	2	\N
272	CB019BUS09	CML1001F	\N	2	\N
271	CB019BUS09	STA1006S	\N	1	\N
270	CB019BUS09	ECO1011S	\N	1	\N
269	CB019BUS09	BUS1036F	\N	1	\N
268	CB019BUS09	ACC1011S	\N	1	\N
267	CB019BUS09	BUS1003H	\N	1	\N
266	CB019BUS09	MAM1032S	\N	1	\N
265	CB019BUS09	MAM1031F	\N	1	\N
264	CB019BUS09	ECO1010F	\N	1	\N
263	CB019BUS09	CSC1015F	\N	1	\N
262	CB019BUS09	ACC1006F	\N	1	\N
497	CB001PHI03	POL2039F	12	2	\N
496	CB001PHI03	POL2038F	12	2	\N
495	CB001PHI03	PHI2041S	11	2	\N
494	CB001PHI03	PHI2042F	11	2	\N
500	CB001PHI03	ECO3020F	\N	3	\N
288	CB019BUS09	PHI2043S	\N	3	\N
511	CB001PHI03	ELECTIVE4	\N	3	Any PHI NQF Level 7 course, any POL NQF Level 7 course, any ECO NQF Level 7 course, or any other NQF Level 7 course
509	CB001PHI03	ECO2008S	16	3	\N
510	CB001PHI03	ELECTIVE3	16	3	Any PHI NQF Level 6 course, any POL NQF Level 6 course, or any other NQF Level 6 course
517	CB001INF01	BUS2024F	20	3	\N
518	CB001INF01	BUS2023S	20	3	\N
512	CB019BUS01	MAM2013S	17	2	
519	CB001INF01	CML2001F	20	3	\N
513	CB003BUS09	MAM2013S	18	2	
501	CB001PHI03	ECO3025S	\N	3	\N
504	CB001PHI03	PHI3024S	14	3	\N
503	CB001PHI03	PHI3023F	14	3	\N
291	CB001INF01	ACC1021F	\N	1	\N
292	CB001INF01	ACC1022Z	\N	1	\N
295	CB001INF01	ECO1010F	\N	1	\N
296	CB001INF01	MAM1010F	\N	1	\N
298	CB001INF01	ECO1011S	\N	1	\N
299	CB001INF01	CML1004S	\N	1	\N
293	CB001INF01	INF1002F	1	1	\N
294	CB001INF01	CSC1015F	1	1	\N
302	CB001INF01	INF2007F	\N	2	\N
303	CB001INF01	INF2006F	\N	2	\N
304	CB001INF01	INF2009F	\N	2	\N
305	CB001INF01	INF2010S	\N	2	\N
306	CB001INF01	INF2011S	\N	2	\N
307	CB001INF01	BUS2010S	\N	2	\N
308	CB001INF01	STA1000S	\N	2	\N
300	CB001INF01	INF1003F	2	2	\N
301	CB001INF01	CSC1016S	2	1	\N
309	CB001INF01	BUS2033F	\N	3	\N
310	CB001INF01	INF3014F	\N	3	\N
311	CB001INF01	INF3003W	\N	3	\N
312	CB001INF01	PHI2043S	\N	3	\N
313	CB001INF01	INF3012S	\N	3	\N
297	CB001INF01	BUS1036S	\N	1	\N
502	CB001PHI03	ELECTIVE1	\N	3	Any other NQF level 7 ECO 3000 course
505	CB001PHI03	POL3030F	15	3	\N
506	CB001PHI03	POL3046S	15	3	\N
290	CB019BUS09	STA3048S	\N	3	\N
289	CB019BUS09	STA3047S	\N	3	\N
507	CB001PHI03	POL3029F	15	3	\N
287	CB019BUS09	FTX3045S	\N	3	\N
286	CB019BUS09	BUS2033S	\N	2	\N
285	CB019BUS09	STA3045F	\N	3	\N
284	CB019BUS09	STA3041F	\N	3	\N
283	CB019BUS09	FTX3044F	\N	3	\N
282	CB019BUS09	STA2005S	\N	2	\N
281	CB019BUS09	FTX2024S	\N	2	\N
280	CB019BUS09	ECO2004S	\N	2	\N
279	CB019BUS09	BUS2016H	\N	2	\N
520	CB001INF01	CML2005F	20	3	\N
521	CB001INF01	ECO2003F	20	3	\N
508	CB001PHI03	ELECTIVE2	15	3	Any other NQF Level 7  POL 3000 course
514	CB001INF01	MAM1012S	19	2	\N
515	CB001INF01	POL1004F	19	2	\N
516	CB001INF01	PHI1025S	19	2	\N
522	CB001INF01	ECO2004S	20	3	\N
523	CB001INF01	ECO2007S	20	3	\N
524	CB001INF01	FTX2000S	20	3	\N
525	CB001INF01	FTX2020F	20	3	\N
526	CB001INF01	PHI2037S	20	3	\N
527	CB001INF01	STA2020F	20	3	\N
528	CB001INF01	STA2020S	20	3	\N
529	CB001ECO02	ACC1021F	\N	1	\N
530	CB001ECO02	ACC1022Z	\N	1	\N
531	CB001ECO02	ECO1010F	\N	1	\N
532	CB001ECO02	MAM1010F	\N	1	\N
533	CB001ECO02	INF1002F	\N	1	\N
534	CB001ECO02	ECO1011S	\N	1	\N
535	CB001ECO02	MAM1012S	\N	1	\N
536	CB001ECO02	STA1000S	\N	1	\N
537	CB001ECO02	CML1001F	\N	2	\N
538	CB001ECO02	ECO2003F	\N	2	\N
539	CB001ECO02	STA2020F	\N	2	\N
540	CB001ECO02	ECO2004S	\N	2	\N
541	CB001ECO02	ECO2007S	\N	2	\N
542	CB001ECO02	FTX2024S	\N	2	\N
543	CB001ECO02	ECO2008S	21	2	\N
544	CB001ECO02	ELECTIVE1	21	2	Any NQF  level  6  course
545	CB001ECO02	ELECTIVE2	\N	2	Any NQF  level  6  course
546	CB001ECO02	ECO3020F	\N	3	\N
547	CB001ECO02	FTX3044F	\N	3	\N
548	CB001ECO02	ECO3021S	\N	3	\N
549	CB001ECO02	FTX3045S	\N	3	\N
550	CB001ECO02	PHI2043S	\N	3	\N
557	CB001ECO02	ELECTIVE3	\N	3	Any NQF Level 7 course
582	CB001ECO04	STA1000S	27	1	\N
583	CB001ECO04	STA1006S	27	1	\N
589	CB001ECO04	STA2004F	29	2	\N
590	CB001ECO04	STA2005S	29	2	\N
591	CB001ECO04	STA2020F	30	2	\N
592	CB001ECO04	STA2030S	30	2	\N
595	CB001ECO04	FTX2020F	31	3	\N
596	CB001ECO04	FTX2024S	31	3	\N
599	CB001ECO04	STA3043S	34	3	\N
598	CB001ECO04	STA3041F	34	3	\N
600	CB001ECO04	STA3030F	35	3	\N
601	CB001ECO04	STA3036S	35	3	\N
657	CB001ECO03	ECO3025S	38	3	\N
658	CB001ECO03	ECO3021S	38	3	\N
659	CB001ECO03	ECO3009F	38	3	\N
660	CB001ECO03	ECO3016F	38	3	\N
571	CB001ECO04	ACC1021F	\N	1	\N
572	CB001ECO04	ACC1022Z	\N	1	\N
573	CB001ECO04	ECO1010F	\N	1	\N
577	CB001ECO04	ECO1011S	\N	1	\N
584	CB001ECO04	CML1001F	\N	2	\N
585	CB001ECO04	ECO2003F	\N	2	\N
586	CB001ECO04	ECO2004S	\N	2	\N
587	CB001ECO04	ECO2007S	\N	2	\N
588	CB001ECO04	PHI2043F	\N	2	\N
593	CB001ECO04	ELECTIVE1	\N	2	Any NQF Level 6 course
594	CB001ECO04	ECO3020F	\N	3	\N
597	CB001ECO04	ECO3021S	\N	3	\N
602	CB001ECO04	ECO3009F	\N	3	\N
603	CB001ECO04	ECO3016F	\N	3	\N
604	CB001ECO04	ECO3024F	\N	3	\N
605	CB001ECO04	ECO3022S	\N	3	\N
606	CB001ECO04	ECO3023S	\N	3	\N
607	CB001ECO04	ECO3025S	\N	3	\N
608	CB001ECO04	ELECTIVE2	\N	3	Any NQF Level 7 course
661	CB001ECO03	ECO3024F	38	3	\N
662	CB001ECO03	ECO3022S	38	3	\N
663	CB001ECO03	ECO3023S	38	3	\N
575	CB001ECO04	INF1002S	23	1	\N
574	CB001ECO04	INF1002F	23	1	\N
576	CB001ECO04	CSC1015F	23	1	\N
578	CB001ECO04	MAM1010F	25	1	\N
579	CB001ECO04	MAM1012S	25	1	\N
580	CB001ECO04	MAM1031F	26	1	\N
581	CB001ECO04	MAM1032S	26	1	\N
679	CB001ACC08	CML2001F	\N	3	\N
680	CB001ACC08	PHI2043F	\N	3	\N
681	CB001ACC08	ACC3020W	\N	3	\N
682	CB001ACC08	ACC3004W	\N	3	\N
683	CB001ACC08	ACC3022W	\N	3	\N
556	CB001ECO02	ECO3025S	22	3	
555	CB001ECO02	ECO3023S	22	3	
554	CB001ECO02	ECO3022S	22	3	
553	CB001ECO02	ECO3024F	22	3	
552	CB001ECO02	ECO3016F	22	3	
551	CB001ECO02	ECO3009F	22	3	
638	CB001ECO03	ACC1022Z	\N	1	\N
639	CB001ECO03	ECO1010F	\N	1	\N
640	CB001ECO03	MAM1010F	\N	1	\N
641	CB001ECO03	ECO1011S	\N	1	\N
642	CB001ECO03	INF1002S	\N	1	\N
643	CB001ECO03	STA1000S	\N	1	\N
644	CB001ECO03	MAM1012S	\N	1	\N
645	CB001ECO03	ECO2003F	\N	2	\N
646	CB001ECO03	PVL1003W	\N	2	\N
647	CB001ECO03	PVL1004F	\N	2	\N
648	CB001ECO03	PVL1008H	\N	2	\N
649	CB001ECO03	ECO2004S	\N	2	\N
650	CB001ECO03	ECO2007S	\N	2	\N
651	CB001ECO03	PHI2043S	\N	2	\N
652	CB001ECO03	ELECTIVE1	\N	2	Any NQF Level 5 or 6 course
653	CB001ECO03	ECO3020F	\N	3	\N
654	CB001ECO03	PBL2000W	\N	3	\N
655	CB001ECO03	PVL2002H	\N	3	\N
656	CB001ECO03	PVL2003H	\N	3	\N
684	CB001ACC08	ACC3023W	\N	3	\N
685	CB001ACC08	CML2010Z	\N	3	\N
686	CB001ACC04	ACC1006F	\N	1	\N
687	CB001ACC04	ACC1015F	\N	1	\N
688	CB001ACC04	ECO1010F	\N	1	\N
689	CB001ACC04	MAM1010F	\N	1	\N
690	CB001ACC04	ACC1011S	\N	1	\N
691	CB001ACC04	ECO1011S	\N	1	\N
692	CB001ACC04	INF1002S	\N	1	\N
693	CB001ACC04	STA1000S	\N	1	\N
694	CB001ACC04	CML1004S	\N	1	\N
695	CB001ACC04	PHI2043F	\N	2	\N
696	CB001ACC04	ACC2022H	\N	2	\N
697	CB001ACC04	FTX2024F	\N	2	\N
698	CB001ACC04	INF2004F	\N	2	\N
699	CB001ACC04	ACC2012W	\N	2	\N
700	CB001ACC04	ACC2018H	\N	2	\N
701	CB001ACC04	ACC2023H	\N	2	\N
702	CB001ACC04	CML2001F	\N	3	\N
703	CB001ACC04	ACC3009W	\N	3	\N
704	CB001ACC04	ACC3004W	\N	3	\N
705	CB001ACC04	ACC3022W	\N	3	\N
706	CB001ACC04	ACC3001F	\N	3	\N
707	CB001ACC04	ACC3002S	\N	3	\N
708	CB001ACC04	ACC3023W	\N	3	\N
709	CB001ACC04	CML2010Z	\N	3	\N
710	CB001ACC03	ACC1021F	\N	1	\N
711	CB001ACC03	ACC1022Z	\N	1	\N
712	CB001ACC03	ACC1015F	\N	1	\N
713	CB001ACC03	ECO1010F	\N	1	\N
714	CB001ACC03	MAM1010F	\N	1	\N
715	CB001ACC03	ECO1011S	\N	1	\N
716	CB001ACC03	INF1002S	\N	1	\N
717	CB001ACC03	STA1000S	\N	1	\N
718	CB001ACC03	ACC2023H	\N	2	\N
719	CB001ACC03	PHI2043F	\N	2	\N
720	CB001ACC03	ACC2012W	\N	2	\N
721	CB001ACC03	PVL1003W	\N	2	\N
722	CB001ACC03	PVL1004F	\N	2	\N
723	CB001ACC03	PVL1008H	\N	2	\N
724	CB001ACC03	ACC2018H	\N	2	\N
725	CB001ACC03	FTX2024F	\N	3	\N
726	CB001ACC03	ACC3020W	\N	3	\N
727	CB001ACC03	PBL2000W	\N	3	\N
728	CB001ACC03	PVL2003H	\N	3	\N
729	CB001ACC03	PVL2002H	\N	3	\N
730	CB001ACC03	ACC2022H	\N	3	\N
791	CB001BUS06	ACC1021F	\N	1	\N
792	CB001BUS06	ACC1022Z	\N	1	\N
793	CB001BUS06	ECO1010F	\N	1	\N
798	CB001BUS06	ECO1011S	\N	1	\N
799	CB001BUS06	STA1000S	\N	1	\N
803	CB001BUS06	ELECTIVE1	\N	1	Any NQF Level 5 course
804	CB001BUS06	PHI2043S	\N	2	\N
796	CB001BUS06	BUS1036F	40	1	\N
797	CB001BUS06	BUS1036S	40	1	\N
805	CB001BUS06	CML1001F	42	2	\N
806	CB001BUS06	CML1004S	42	2	\N
800	CB001BUS06	INF1002F	43	1	\N
801	CB001BUS06	INF1002S	43	1	\N
802	CB001BUS06	CSC1015F	43	1	\N
807	CB001BUS06	BUS2010F	44	2	\N
808	CB001BUS06	BUS2010S	44	2	\N
809	CB001BUS06	BUS2033S	44	2	\N
810	CB001BUS06	FTX2020F	45	2	\N
812	CB001BUS06	ELECTIVE2	\N	2	Any NQF Level 6 course
813	CB001BUS06	ELECTIVE3	\N	2	Any NQF Level 6 course
814	CB001BUS06	ELECTIVE4	\N	2	Any NQF Level 6 course
815	CB001BUS06	ELECTIVE5	\N	2	Any NQF Level 6 course
816	CB001BUS06	ELECTIVE6	\N	3	Any NQF Level 7 course
817	CB001BUS06	ELECTIVE7	\N	3	Any NQF Level 7 course
818	CB001BUS06	ELECTIVE8	\N	3	Any NQF Level 7 course
819	CB001BUS06	ELECTIVE9	\N	3	Any NQF Level 7 course
820	CB001BUS06	ELECTIVE10	\N	3	Any NQF Level 7 course
821	CB001BUS06	ELECTIVE11	\N	3	Any NQF Level 7 course
794	CB001BUS06	MAM1010F	39	1	\N
795	CB001BUS06	MAM1010S	39	1	\N
811	CB001BUS06	FTX2024S	45	2	\N
822	CB026BUS01	ACC1106F	\N	1	\N
823	CB026BUS01	BUS1036F	\N	1	\N
824	CB026BUS01	CSC1015F	\N	1	\N
825	CB026BUS01	DOC1103H	\N	1	\N
826	CB026BUS01	ECO1110F	\N	1	\N
827	CB026BUS01	MAM1031F	\N	1	\N
828	CB026BUS01	MAM1032S	\N	1	\N
829	CB026BUS01	BUS1003H	\N	1	\N
830	CB026BUS01	ACC1111S	\N	1	\N
831	CB026BUS01	ECO1011S	\N	1	\N
832	CB026BUS01	STA1106H	\N	1	\N
833	CB026BUS01	CML1001F	\N	2	\N
834	CB026BUS01	ECO2003F	\N	2	\N
835	CB026BUS01	STA2004F	\N	2	\N
836	CB026BUS01	MAM2010F	\N	2	\N
837	CB026BUS01	MAM2011F	\N	2	\N
841	CB026BUS01	BUS2016H	\N	2	\N
842	CB026BUS01	ECO2004S	\N	2	\N
843	CB026BUS01	FTX2024S	\N	2	\N
844	CB026BUS01	STA2005S	\N	2	\N
845	CB026BUS01	BUS3018F	\N	3	\N
846	CB026BUS01	STA3041F	\N	3	\N
847	CB026BUS01	STA3045F	\N	3	\N
848	CB026BUS01	BUS3024S	\N	3	\N
849	CB026BUS01	PHI2043S	\N	3	\N
850	CB026BUS01	STA3047S	\N	3	\N
851	CB026BUS01	STA3048S	\N	3	\N
838	CB026BUS01	MAM2012S	46	2	\N
839	CB026BUS01	MAM2013S	46	2	\N
840	CB026BUS01	MAM2014S	46	2	\N
852	CB026BUS09	ACC1106F	\N	1	\N
853	CB026BUS09	CSC1015F	\N	1	\N
854	CB026BUS09	DOC1103H	\N	1	\N
855	CB026BUS09	ECO1110F	\N	1	\N
856	CB026BUS09	MAM1031F	\N	1	\N
857	CB026BUS09	MAM1032S	\N	1	\N
858	CB026BUS09	BUS1003H	\N	1	\N
859	CB026BUS09	ACC1111S	\N	1	\N
860	CB026BUS09	BUS1036S	\N	1	\N
861	CB026BUS09	ECO1011S	\N	1	\N
862	CB026BUS09	STA1106H	\N	1	\N
863	CB026BUS09	CML1001F	\N	2	\N
864	CB026BUS09	ECO2003F	\N	2	\N
865	CB026BUS09	STA2004F	\N	2	\N
866	CB026BUS09	MAM2010F	\N	2	\N
867	CB026BUS09	MAM2011F	\N	2	\N
871	CB026BUS09	BUS2016H	\N	2	\N
872	CB026BUS09	ECO2004S	\N	2	\N
873	CB026BUS09	FTX2024S	\N	2	\N
874	CB026BUS09	STA2005S	\N	2	\N
875	CB026BUS09	FTX3044F	\N	3	\N
876	CB026BUS09	STA3041F	\N	3	\N
877	CB026BUS09	STA3045F	\N	3	\N
878	CB026BUS09	BUS2033S	\N	3	\N
879	CB026BUS09	FTX3045S	\N	3	\N
880	CB026BUS09	PHI2043S	\N	3	\N
881	CB026BUS09	STA3047S	\N	3	\N
882	CB026BUS09	STA3048S	\N	3	\N
868	CB026BUS09	MAM2012S	47	2	\N
869	CB026BUS09	MAM2013S	47	2	\N
870	CB026BUS09	MAM2014S	47	2	\N
883	TS001TST01	CSC1015F	58	1	
884	TS001TST01	CSC1015S	58	1	
885	TS001TST01	MAM1004F	62	1	
886	TS001TST01	MAM1008S	62	1	
889	TS001TST01	MAM1031F	\N	1	
890	TS001TST01	MAM1032S	\N	1	
891	CB015CSC05	CSC1015F	\N	1	
277	CB019BUS09	MAM2012S	\N	2	
278	CB019BUS09	MAM2014S	\N	2	
\.


--
-- Data for Name: courses_per_major; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.courses_per_major (course_major_id, major_id, course_id, course_group_id, year, notes) FROM stdin;
53	SB001MAM01	MAM1031F	\N	1	\N
54	SB001MAM01	MAM1032S	\N	1	\N
55	SB001MAM01	MAM1043H	\N	1	\N
56	SB001MAM01	MAM1044H	\N	1	\N
57	SB001MAM01	MAM2010F	\N	2	\N
58	SB001MAM01	MAM2011F	\N	2	\N
62	SB001MAM01	MAM2040F	\N	2	\N
63	SB001MAM01	MAM2041F	\N	2	\N
64	SB001MAM01	MAM2042S	\N	2	\N
65	SB001MAM01	MAM2043S	\N	2	\N
59	SB001MAM01	MAM2012S	1	2	
60	SB001MAM01	MAM2013S	1	2	
61	SB001MAM01	MAM2014S	1	2	
66	SB001MAM01	MAM3043F	2	3	
67	SB001MAM01	MAM3043S	2	3	
68	SB001MAM01	MAM3012F	3	3	\N
69	SB001MAM01	MAM3012S	3	3	\N
70	SB001MAM01	MAM3042F	3	3	\N
71	SB001MAM01	MAM3042S	3	3	\N
72	SB001MAM01	MAM3044F	3	3	\N
73	SB001MAM01	MAM3044S	3	3	\N
74	SB001MAM01	MAM3045F	3	3	\N
75	SB001MAM01	MAM3045S	3	3	\N
76	SB001MAM01	MAM3046F	3	3	\N
77	SB001MAM01	MAM3046S	3	3	\N
78	SB001STA01	MAM1031F	\N	1	\N
79	SB001STA01	MAM1032S	\N	1	\N
90	SB001STA01	STA2030S	\N	2	\N
91	SB001STA01	STA3030F	\N	3	\N
92	SB001STA01	STA3022F	6	3	
93	SB001STA01	STA3036S	6	3	
80	SB001STA01	STA1007S	4	1	\N
81	SB001STA01	STA1000F	4	1	\N
82	SB001STA01	STA1000S	4	1	\N
83	SB001STA01	STA1000P	4	1	\N
84	SB001STA01	STA1000L	4	1	\N
85	SB001STA01	STA2007F	5	2	\N
86	SB001STA01	STA2007S	5	2	\N
87	SB001STA01	STA2007H	5	2	\N
88	SB001STA01	STA2020F	5	2	\N
89	SB001STA01	STA2020S	5	2	\N
97	SB001CSC05	MAM1008S	8	1	\N
98	SB001CSC05	MAM1019H	8	1	\N
99	SB001CSC05	STA1007S	8	1	\N
100	SB001CSC05	STA1000F	8	1	\N
101	SB001CSC05	STA1000S	8	1	\N
102	SB001CSC05	STA1000P	8	1	\N
103	SB001CSC05	STA1000L	8	1	\N
104	SB001CSC05	MAM1004F	9	1	\N
105	SB001CSC05	MAM1004S	9	1	\N
106	SB001CSC05	MAM1031F	9	1	\N
110	SB001CSC05	INF2009F	10	2	\N
111	SB001CSC05	CSC2042S	10	2	\N
94	SB001CSC05	CSC1015F	7	1	
95	SB001CSC05	CSC1015S	7	1	
96	SB001CSC05	CSC1016S	\N	1	\N
107	SB001CSC05	CSC2001F	\N	2	\N
108	SB001CSC05	CSC2002S	\N	2	\N
109	SB001CSC05	CSC2004Z	\N	2	\N
112	SB001CSC05	CSC3002F	\N	3	\N
113	SB001CSC05	CSC3003S	\N	3	\N
114	SB001TST01	MAM1004F	11	1	
115	SB001TST01	MAM1008S	11	1	
116	SB001TST01	MAM1031F	12	1	
117	SB001TST01	MAM1032S	12	1	
118	SB001TST01	CSC1015F	13	1	
119	SB001TST01	CSC1015S	13	1	
\.


--
-- Data for Name: degree; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.degree (degree_name, degree_code, notes, department_id, program_id) FROM stdin;
Quantitative Finance	CB026BUS09	*MAM2010F and MAM2011F are compulsory courses. Students may choose 2 courses from\r\nMAM2012S, MAM2013S or MAM2014S.\r\nThe total credits for year 2 equals 186.	BUS	CB026
Computer Science	CB004CSC05	\N	CSC	CB004
Finance With Accounting	CB004FTX04	\N	FTX	CB004
Actuarial Science	CB025BUS01	\N	BUS	CB025
Quantitative Finance	CB025BUS09	\N	BUS	CB025
Statistics And Data Sciences	CB024STA13	\N	STA	CB024
Finance, Investment And Banking	CB024FTX05	\N	FTX	CB024
Finance With Accounting	CB024FTX04	\N	FTX	CB024
Computer Science	CB024CSC05	\N	CSC	CB024
Actuarial Science	CB018BUS01	\N	BUS	CB018
Quantitative Finance	CB018BUS09	\N	BUS	CB018
Statistics And Data Sciences	CB015STA13	\N	STA	CB015
Finance, Investment And Banking	CB015FTX05	\N	FTX	CB015
Finance With Accounting	CB015FTX04	\N	FTX	CB015
Actuarial Science	CB019BUS01	*MAM2010F  and  MAM2011F  are  compulsory  courses.  Students  may  choose  2  courses  from \r\nMAM2012S, MAM2013S or MAM2014S. \r\nThe total credits for year 2 equals 186.	BUS	CB019
Information Systems	CB023INF01	\N	INF	CB023
Information Systems And Computer Science	CB023INF06	\N	INF	CB023
Actuarial Science	CB020BUS01	\N	BUS	CB020
Information Systems	CB011INF01	\N	INF	CB011
Information Systems And Computer Science	CB011INF06	\N	INF	CB011
Quantitative Finance	CB020BUS09	\N	BUS	CB020
Financial Accounting: General Accounting	CB023ACC08	\N	ACC	CB023
Financial Accounting: Chartered Accountant	CB023ACC04	\N	ACC	CB023
Financial Accounting: General Accounting	CB011ACC08	\N	ACC	CB011
Financial Accounting: Chartered Accountant	CB011ACC04	\N	ACC	CB011
Financial Accounting: Chartered Accountant	CB001ACC04	*Students who registered prior to 2024 are required to complete CML1004S in year 2.	ACC	CB001
Information Systems And Computer Science	CB001INF06	Students who fail STA1000S are recommended to register for STA1000P (subject to approval by the \r\nStatistics Department).	INF	CB001
Financial Accounting: General Accounting	CB001ACC08	*Students who registered prior to 2024 are required to complete CML1004S in year 2.	ACC	CB001
Actuarial Science 	CB026BUS01	*MAM2010F and MAM2011F are compulsory courses. Students may choose 2 courses from MAM2012S, MAM2013S or MAM2014S.\r\nThe total credits for year 2 equals 186.	BUS	CB026
Philosophy, Politics & Economics	CB001PHI03	* Students who wish to study towards an honours degree in Economics must complete ECO3021S. \r\n** Students who wish to study towards an honours degree in Philosophy, Politics and Economics \r\nmust do at least two first year courses in the discipline which they do not take up to the third year \r\nlevel.	PHI	CB001
Economics And Statistics	CB001ECO04	* STA1006S is compulsory for students following the Mathematical Statistics option in the second \r\nand subsequent year.\r\n** Required for students who wish to pursue an honours degree in statistics.\r\n*** BUS2033 is usually offered to 3rd year students. If 2nd year, then only 2nd semester is permitted.\r\n**** Strongly recommended for students who wish to pursue an honours degree in statistics.	ECO	CB001
Information Systems	CB001INF01	*Students who wish to keep the option of a dual Information Systems and Computer Science major open are requested to register for CB001INF06 and complete CSC1015F and CSC1016S in first year. \r\n**Students who complete CSC1015F can complete CSC1016S in first year in substitution for INF1003F in second year. Year 2 Suggested Electives NQF Level 5 \r\nCourse \r\nMAM1012S: Mathematics 1012 \r\nPOL1004F: Introduction to Politics \r\nPHI1025S: Critical Thinking \r\nAny other courses must be approved by the Programme Convenor \r\nYear 3 suggested Electives NQF Level 6 \r\nBUS2024F: Psychology of Human Resource Management \r\nBUS2023S: Organisational Behaviour \r\nCML2001F: Company Law \r\nCML2005F: Labour Law \r\nECO2003F: Microeconomics II \r\nECO2004S: Macroeconomics II \r\nECO2007S: Co-operation and Competition \r\nFTX2000S: Personal Finance Management \r\nFTX2020F: Business Finance \r\nPHI2037S: Applied Ethics \r\nSTA2020F/S: Applied Statistics \r\nAny other course must be approved by the Programme Convenor.	INF	CB001
Information Systems And Finance	CB001INF11	*Students  who  complete  CSC1015F  can  complete  CSC1016S  in  first  year  in substitution  for \r\nINF1003F in second year. \r\n**Students  who  complete  CSC1015F  can  complete  CSC1016S  in  first  year  in  substitution  for \r\nINF1003F in second year.  \r\n***Students who fail STA1000S are recommended to register for STA1000P (subject to approval by \r\nthe Statistics Department).	INF	CB001
Economics With Law	CB001ECO03	* Places on the Law Courses in the 2nd and 3rd year are limited. To be eligible for consideration for\r\na possible (but not guaranteed) place, students wishing to apply to take Law courses in 2nd and 3rd\r\nyear need to fulfil all the requirements set out in Promotion Rule FBA16.1.	ECO	CB001
Finance, Investment And Banking	CB004FTX05	\N	FTX	CB004
Management Studies	CB001BUS06	Four electives at NQF level 6 must equal to 72 credits\r\nAny NQF level 7 electives for which students meet the prerequisites  \r\ntotalling a minimum of 120 credits	BUS	CB001
Test Degree	TS001TST01		TST	TS001
Quantitative Finance	CB019BUS09	MAM2010F  and  MAM2011F  are  compulsory  courses.  Students  may  choose  2  courses  from \r\nMAM2012S, MAM2013S or MAM2014S. \r\nThe total credits for year 2 equals 186.	BUS	CB019
Financial Accounting: Accounting With Law	CB001ACC03	NO NEW INTAKE FOR 2025 - this programme will not be offered in the future.\r\n*See section "Entrance to the Legal Profession" elsewhere in this Handbook.\r\n** Places on the Law Courses in the 2nd and third year are limited. To be eligible for consideration \r\nfor a possible (but not guaranteed) place, students wishing to apply to take Law courses in 2nd \r\nand 3rd year need to fulfil all the requirements set out in the promotion rules.\r\nThe pre-requisites for registering for the PVL courses are receipt of confirmation of place on those \r\ncourses and fulfilment of all the requirements set out in the promotion rules.	ACC	CB001
Actuarial Science	CB003BUS01	\N	BUS	CB003
Quantitative Finance	CB003BUS09	\N	BUS	CB003
Economics and Finance	CB001ECO02	*Students  wishing  to  register  for  MAM2000W  after  completing  MAM1010F/S  and  MAM1012F/S \r\nmust obtain permission from the convener of MAM2000W. See the MAM2000W handbook entry for \r\nfurther details.\r\n**BUS2033 is usually offered to 3rd year students. If 2nd year, then only 2nd semester is permitted.	ECO	CB001
Statistics And Data Sciences	CB004STA13	\N	STA	CB004
Computer Science	CB015CSC05		CSC	CB015
dsvfb	TS001MAM02		MAM	TS001
\.


--
-- Data for Name: degree_course_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.degree_course_group (course_group_id, degree_id, required_count, description, parent_group_id, major_code) FROM stdin;
36	CB001ECO04	2	Missing Description	\N	\N
35	CB001ECO04	2	Missing Description	5	\N
34	CB001ECO04	2	Missing Description	5	\N
58	TS001TST01	1	Choose 1 between CSC1015F and CSC1015S	\N	\N
30	CB001ECO04	2	Missing Description	4	\N
29	CB001ECO04	2	Missing Description	4	\N
26	CB001ECO04	2	Missing Description	3	\N
25	CB001ECO04	2	Missing Description	3	\N
18	CB003BUS09	2	Missing Description	\N	\N
17	CB019BUS01	2	Missing Description	\N	\N
15	CB001PHI03	2	Missing Description	2	\N
14	CB001PHI03	2	Missing Description	2	\N
9	CB001INF06	1	Missing Description	1	\N
1	CB001INF01	1	Missing Description	\N	\N
2	CB001INF01	1	Missing Description	\N	\N
3	CB001INF06	1	Missing Description	\N	\N
4	CB001INF11	1	Missing Description	\N	\N
5	CB001INF11	1	Missing Description	\N	\N
10	CB001PHI03	1	Missing Description	\N	\N
11	CB001PHI03	2	Missing Description	\N	\N
12	CB001PHI03	2	Missing Description	\N	\N
16	CB001PHI03	1	Missing Description	\N	\N
19	CB001INF01	1	Missing Description	\N	\N
20	CB001INF01	2	Missing Description	\N	\N
21	CB001ECO02	1	Missing Description	\N	\N
22	CB001ECO02	2	Missing Description	\N	\N
23	CB001ECO04	1	Missing Description	\N	\N
27	CB001ECO04	1	Missing Description	\N	\N
31	CB001ECO04	1	Missing Description	\N	\N
32	CB001ECO04	1	Missing Description	\N	\N
37	CB001ECO03	1	Missing Description	\N	\N
38	CB001ECO03	1	Missing Description	\N	\N
39	CB001BUS06	1	Missing Description	\N	\N
40	CB001BUS06	1	Missing Description	\N	\N
42	CB001BUS06	1	Missing Description	\N	\N
43	CB001BUS06	1	Missing Description	\N	\N
44	CB001BUS06	1	Missing Description	\N	\N
45	CB001BUS06	1	Missing Description	\N	\N
46	CB026BUS01	1	Missing Description	\N	\N
8	CB001INF06	2	Missing Description	1	\N
47	CB026BUS09	1	Missing Description	\N	\N
48	\N	2	Missing Description	\N	MAM01
49	\N	1	Missing Description	\N	MAM01
50	\N	3	Missing Description	\N	MAM01
51	\N	1	Missing Description	\N	STA01
52	\N	1	Missing Description	\N	STA01
53	\N	1	Missing Description	\N	STA01
54	\N	1	Missing Description	\N	CSC05
55	\N	1	Missing Description	\N	CSC05
56	\N	1	Missing Description	\N	CSC05
57	\N	1	Missing Description	\N	CSC05
62	TS001TST01	2	MAM1004F and MAM1008S	6	\N
64	TS001TST01	2	MAM1031F and MAM1032S	6	\N
\.


--
-- Data for Name: degree_parent_course_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.degree_parent_course_group (parent_group_id, degree_id, required_count, description) FROM stdin;
1	CB001INF06	1	Missing Description
2	CB001PHI03	1	Missing Description
3	CB001ECO04	1	Missing Description
4	CB001ECO04	1	Missing Description2
5	CB001ECO04	1	Missing Description3
6	TS001TST01	1	Choose 1 Group between Group 1 (MAM1004F and MAM1008S) and Group 2 (MAM1031F and MAM1032S)
\.


--
-- Data for Name: department; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.department (department_name, building, department_code, faculty_id) FROM stdin;
Historical Studies	Beattie Building and Rachel Bloch House	HST	4
School of Management Studies	Leslie Commerce Building	BUS	6
Information Systems	Leslie Commerce Building	INF	6
School of Economics	School of Economics Building	ECO	6
Psychology	PD Hahn Building	PSY	4
Anaesthesia and Perioperative Medicine	Groote Schuur Hospital	AAE	2
Finance and Tax	Leslie Social Sciences Building	FTX	6
The Nelson Mandela School of Public Governance	Linkoping House	GPP	6
Education Development Unit (EDU)	Leslie Commerce Building	EDU	6
Graduate School of Business	Breakwater Campus	GSB	6
Demography	Leslie Commerce Building	DOC	6
African Feminist Studies	Harry Oppenheimer Institute Building	AFS	4
Philosophy	Humanities Building	PHI	4
African Studies and Linguistics	Harry Oppenheimer Building	ASL	4
Anthropology	AC Jordan Building	ANS	4
School of Education	Neville Alexander Building	EDN	4
Umthombo Centre for Student Success	Beattie\r\nbuilding	DOH	4
English Literary Studies	A C Jordan Building	ELL	4
English Language Centre	Rosedale Building	ELC	4
Centre for Film and Media Studies	A C Jordan Building	FAM	4
Political Studies	Leslie Social Sciences Building	POL	4
Michaelis School of Fine Art	Michaelis School of Fine Art	FIN	4
Knowledge & Information Stewardship	Hlanganani building	LIS	4
South African College of Music	South African College of Music	MUZ	4
Social Work and Social Development	Leslie Social Science Building	SWK	4
Sociology	Leslie Social Science Building	SOC	4
Theatre, Dance and Performance Studies	Little Theatre	TDP	4
Department for the Study of Religions	Leslie Social Science Building	REL	4
Dean of Law	Kramer Law School Building	DOL	1
Department of Commercial Law	Kramer Law School Building	CML	1
Department of Private Law	Kramer Law School Building	PVL	1
Department of Public Law	Kramer Law School Building	PBL	1
Archaeology	Beattie Building	AGE	5
Astronomy	R W James Building	AST	5
Biological Sciences	H W Pearson Building & J Day Building	BIO	5
Chemistry	P D Hahn Building	CEM	5
Computer Science	Computer Science Building	CSC	5
Environmental & Geographical Science	EGS Building	EGS	5
Geological Sciences	Geological Sciences Building	GEO	5
Mathematics & Applied Mathematics	Mathematics Building	MAM	5
Molecular & Cell Biology	Molecular Biology Building	MCB	5
Oceanography	R W James Building	SEA	5
Physics	R W James Building	PHY	5
Statistical Sciences	P D Hahn Building	STA	5
Architecture, Planning and Geomatics	Centlivres Building and Menzies Building	APG	3
Chemical Engineering	Chemical Engineering Building and New Engineering Building	CHE	3
Civil Engineering	New Engineering Building	CIV	3
Construction Economics and Management	Snape Building	CON	3
Electrical Engineering	Menzies Building	EEE	3
Mechanical Engineering	Electrical & Mechanical Engineering Building, Duncan McMillan Building, Maintenance Place Building, and Menzies Building	MEC	3
Other courses in the Faculty of Engineering & the Built Environment	Snape Building and Menzies Building	END	3
Human Biology	Anatomy Building and Sports Science Institute of South Africa Building	HUB	2
Family, Community and Emergency Care	Old Main Building	FCE	2
Health and Rehabilitation Sciences	Old Main Building	AHS	2
Health Sciences Education	Old Main Building	HSE	2
Integrative Biomedical Sciences	Falmouth Building and Wernher and Beit Building North	IBS	2
Medicine	Old Main Building	MDN	2
Obstetrics and Gynaecology	Old Main Building	OBS	2
Pathology	Falmouth Building North, Institute of Child Health Building	PTY	2
Psychiatry and Mental Health	Neuroscience Institute	PRY	2
Public Health and Family Medicine	Falmouth Building South	PPH	2
Radiation Medicine	Groote Schuur Hospital	RAY	2
Surgery	Old Main Building	CHM	2
School of Languages and Literatures	Beattie Building and AC Jordan Building	SLL	4
Centre for Creative Writing	Beattie Building	CCW	4
Paediatrics and Child Health	Institute of Child Health Building	PED	2
College of Accounting	Leslie Commerce Building	ACC	6
Test Department		TST	6
\.


--
-- Data for Name: django_admin_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.django_admin_log (id, action_time, object_id, object_repr, action_flag, change_message, content_type_id, user_id) FROM stdin;
1	2025-07-12 16:08:02.425576+02	247	Courses object (247)	2	[]	8	1
2	2025-07-12 18:53:47.83462+02	BUS1036F/S	Courses object (BUS1036F/S)	2	[]	8	1
3	2025-07-12 18:56:09.968444+02	BUS1036S	Courses object (BUS1036S)	1	[{"added": {}}]	8	1
4	2025-07-12 18:56:21.702623+02	BUS1036F	Courses object (BUS1036F)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
5	2025-07-12 18:59:07.994947+02	CSC1015F/S	Courses object (CSC1015F/S)	2	[]	8	1
6	2025-07-12 19:00:09.886794+02	CSC1015F	Courses object (CSC1015F)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
7	2025-07-12 19:00:12.517725+02	CSC1015S	Courses object (CSC1015S)	1	[{"added": {}}]	8	1
8	2025-07-12 19:00:28.326635+02	CSC1015F/S	Courses object (CSC1015F/S)	3		8	1
9	2025-07-12 19:00:48.649957+02	BUS1036F/S	Courses object (BUS1036F/S)	3		8	1
10	2025-07-12 19:02:56.428188+02	ECO1010F	Courses object (ECO1010F)	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
11	2025-07-12 19:03:53.703832+02	ECO1010S	Courses object (ECO1010S)	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
12	2025-07-12 19:04:09.607068+02	ECO1010F/S	Courses object (ECO1010F/S)	3		8	1
13	2025-07-12 19:04:44.250207+02	ECO1011F	Courses object (ECO1011F)	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
14	2025-07-12 19:05:14.358326+02	ECO1011S	Courses object (ECO1011S)	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
15	2025-07-12 19:05:28.558102+02	ECO1011F/S	Courses object (ECO1011F/S)	3		8	1
16	2025-07-12 19:07:00.19565+02	FTX2024F	Courses object (FTX2024F)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
17	2025-07-12 19:07:09.804505+02	FTX2024S	Courses object (FTX2024S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
18	2025-07-12 19:07:17.304442+02	FTX2024F/S	Courses object (FTX2024F/S)	3		8	1
19	2025-07-12 19:08:01.303386+02	FTX2024S	Courses object (FTX2024S)	2	[{"changed": {"fields": ["Lecture times"]}}]	8	1
20	2025-07-12 19:14:15.043927+02	PHI2043F	Courses object (PHI2043F)	1	[{"added": {}}]	8	1
21	2025-07-12 19:14:32.49186+02	PHI2043S	Courses object (PHI2043S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
22	2025-07-12 19:15:58.138672+02	BUS2033F	Courses object (BUS2033F)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
23	2025-07-12 19:16:38.115632+02	BUS2033S	Courses object (BUS2033S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
24	2025-07-12 19:16:49.220086+02	BUS2033F/S	Courses object (BUS2033F/S)	3		8	1
25	2025-07-12 21:49:23.202634+02	ECO1008F/S	Courses object (ECO1008F/S)	2	[{"changed": {"fields": ["Course name", "Notes"]}}]	8	1
26	2025-07-12 21:50:16.002562+02	ECO1010F	Courses object (ECO1010F)	2	[{"changed": {"fields": ["Lecture times"]}}]	8	1
27	2025-07-12 21:51:18.960991+02	ECO1010S	Courses object (ECO1010S)	2	[{"changed": {"fields": ["Lecture times", "Notes"]}}]	8	1
28	2025-07-12 21:51:47.246272+02	ACC1015F/S	Courses object (ACC1015F/S)	3		8	1
29	2025-07-12 21:52:07.915102+02	ACC1015F	Courses object (ACC1015F)	2	[{"changed": {"fields": ["Convener"]}}]	8	1
30	2025-07-12 21:52:35.262426+02	ACC1015S	Courses object (ACC1015S)	2	[{"changed": {"fields": ["Convener"]}}]	8	1
31	2025-07-12 21:53:04.809996+02	ECO1008F/S	Courses object (ECO1008F/S)	3		8	1
32	2025-07-12 21:53:32.208397+02	ECO1110F/S	Courses object (ECO1110F/S)	3		8	1
33	2025-07-12 21:53:51.252984+02	ECO1009F	Courses object (ECO1009F)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
34	2025-07-12 21:54:03.126621+02	ECO1009S	Courses object (ECO1009S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
35	2025-07-12 21:54:11.155764+02	ECO1009F/s	Courses object (ECO1009F/s)	3		8	1
36	2025-07-12 21:54:21.218256+02	CSC2005F/S	Courses object (CSC2005F/S)	3		8	1
37	2025-07-12 21:54:39.454958+02	BUS3039F/S	Courses object (BUS3039F/S)	3		8	1
38	2025-07-12 21:55:13.945408+02	BUS2010F/S	Courses object (BUS2010F/S)	3		8	1
39	2025-07-12 21:56:39.022991+02	GSB3008F/S/X/Z	Courses object (GSB3008F/S/X/Z)	3		8	1
40	2025-07-12 21:56:47.330346+02	GSB3007F/S/X/Z	Courses object (GSB3007F/S/X/Z)	3		8	1
41	2025-07-12 21:56:54.000418+02	GSB3006F/S/X/Z	Courses object (GSB3006F/S/X/Z)	3		8	1
42	2025-07-12 21:57:01.050094+02	GSB3005F/S/X/Z	Courses object (GSB3005F/S/X/Z)	3		8	1
43	2025-07-12 21:57:08.673513+02	GSB3004F/S/X/Z	Courses object (GSB3004F/S/X/Z)	3		8	1
44	2025-07-12 21:57:16.549542+02	GSB3003F/S/X/Z	Courses object (GSB3003F/S/X/Z)	3		8	1
45	2025-07-12 21:57:22.839989+02	GSB3002F/S/X/Z	Courses object (GSB3002F/S/X/Z)	3		8	1
46	2025-07-12 21:57:32.330333+02	INF1102F/S	Courses object (INF1102F/S)	3		8	1
47	2025-07-12 21:57:39.210989+02	INF1002F/S	Courses object (INF1002F/S)	3		8	1
48	2025-07-12 21:57:46.654586+02	FTX1005F/S	Courses object (FTX1005F/S)	3		8	1
49	2025-07-13 13:23:19.38727+02	PHI1025S	Courses object (PHI1025S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
50	2025-07-13 13:24:00.698931+02	PHI2037S	Courses object (PHI2037S)	2	[{"changed": {"fields": ["Course code"]}}]	8	1
51	2025-07-13 14:10:57.340733+02	CB001INF01	Majors object (CB001INF01)	2	[{"changed": {"fields": ["Notes"]}}]	11	1
52	2025-07-13 15:28:38.145788+02	371	371 Information Systems STA2020S: APPLIED STATISTICS	3		13	1
53	2025-07-13 15:28:38.145822+02	370	370 Information Systems STA2020F: APPLIED STATISTICS	3		13	1
54	2025-07-13 15:28:38.145836+02	369	369 Information Systems PHI2037S: APPLIED ETHICS	3		13	1
55	2025-07-13 15:28:38.145847+02	368	368 Information Systems FTX2020F: BUSINESS FINANCE	3		13	1
56	2025-07-13 15:28:38.145857+02	367	367 Information Systems FTX2000S: PERSONAL FINANCIAL MANAGEMENT	3		13	1
57	2025-07-13 15:28:38.145866+02	366	366 Information Systems ECO2007S: COOPERATION AND COMPETITION	3		13	1
58	2025-07-13 15:28:38.145875+02	365	365 Information Systems ECO2004S: MACROECONOMICS II	3		13	1
59	2025-07-13 15:28:38.145884+02	364	364 Information Systems ECO2003F: Microeconomics II	3		13	1
60	2025-07-13 15:28:38.145892+02	363	363 Information Systems CML2005F: LABOUR LAW	3		13	1
61	2025-07-13 15:28:38.145901+02	362	362 Information Systems CML2001F: COMPANY LAW	3		13	1
62	2025-07-13 15:28:38.14591+02	361	361 Information Systems BUS2023S: ORGANISATIONAL BEHAVIOUR	3		13	1
63	2025-07-13 15:28:38.145919+02	360	360 Information Systems BUS2024F: PSYCHOLOGY OF HUMAN RESOURCE MANAGEMENT	3		13	1
64	2025-07-13 15:28:38.145927+02	359	359 Information Systems STA2020S: APPLIED STATISTICS	3		13	1
65	2025-07-13 15:28:38.145935+02	358	358 Information Systems STA2020F: APPLIED STATISTICS	3		13	1
66	2025-07-13 15:28:38.145944+02	357	357 Information Systems PHI2037S: APPLIED ETHICS	3		13	1
67	2025-07-13 15:28:38.145952+02	356	356 Information Systems FTX2020F: BUSINESS FINANCE	3		13	1
68	2025-07-13 15:28:38.14596+02	355	355 Information Systems FTX2000S: PERSONAL FINANCIAL MANAGEMENT	3		13	1
339	2025-08-16 22:57:28.547005+02	28	28	3		34	1
69	2025-07-13 15:28:38.145969+02	354	354 Information Systems ECO2007S: COOPERATION AND COMPETITION	3		13	1
70	2025-07-13 15:28:38.145977+02	353	353 Information Systems ECO2004S: MACROECONOMICS II	3		13	1
71	2025-07-13 15:28:38.145985+02	352	352 Information Systems ECO2003F: Microeconomics II	3		13	1
72	2025-07-13 15:28:38.145993+02	351	351 Information Systems CML2005F: LABOUR LAW	3		13	1
73	2025-07-13 15:28:38.146001+02	350	350 Information Systems CML2001F: COMPANY LAW	3		13	1
74	2025-07-13 15:28:38.14601+02	349	349 Information Systems BUS2023S: ORGANISATIONAL BEHAVIOUR	3		13	1
75	2025-07-13 15:28:38.146019+02	348	348 Information Systems BUS2024F: PSYCHOLOGY OF HUMAN RESOURCE MANAGEMENT	3		13	1
76	2025-07-13 15:28:38.146027+02	347	347 Information Systems PHI1025S: CRITICAL THINKING	3		13	1
77	2025-07-13 15:28:38.146036+02	346	346 Information Systems POL1004F: INTRODUCTION TO POLITICS	3		13	1
78	2025-07-13 15:28:38.146045+02	345	345 Information Systems MAM1012S: MATHEMATICS 1012	3		13	1
79	2025-07-13 15:28:38.146053+02	344	344 Information Systems BUS1007S: INTRODUCTION TO ORGANISATIONAL PSYCHOLOGY	3		13	1
80	2025-07-13 16:41:28.503235+02	426	426 Information Systems And Computer Science INF3012S: BPM & ENTERPRISE SYSTEMS	3		13	1
81	2025-07-13 16:41:28.503368+02	425	425 Information Systems And Computer Science CSC3003S: COMPUTER SCIENCE 3003	3		13	1
82	2025-07-13 16:41:28.5034+02	424	424 Information Systems And Computer Science BUS2033S: PROFESSIONAL COMMUNICATION	3		13	1
83	2025-07-13 16:41:28.503424+02	423	423 Information Systems And Computer Science INF3014F: ELECTRONIC COMMERCE	3		13	1
84	2025-07-13 16:41:28.503471+02	422	422 Information Systems And Computer Science INF3011F: I.T. PROJECT MANAGEMENT	3		13	1
85	2025-07-13 16:41:28.503492+02	421	421 Information Systems And Computer Science CSC3002F: COMPUTER SCIENCE 3002	3		13	1
86	2025-07-13 16:41:28.50351+02	420	420 Information Systems And Computer Science CSC2004Z: PROGRAMMING ASSESSMENT	3		13	1
87	2025-07-13 16:41:28.503526+02	419	419 Information Systems And Computer Science STA1000S: INTRODUCTORY STATISTICS	3		13	1
88	2025-07-13 16:41:28.503542+02	418	418 Information Systems And Computer Science PHI2043S: BUSINESS ETHICS	3		13	1
89	2025-07-13 16:41:28.503559+02	417	417 Information Systems And Computer Science INF2011S: SYSTEMS DESIGN & DEVELOPMENT	3		13	1
90	2025-07-13 16:41:28.503576+02	416	416 Information Systems And Computer Science CSC2002S: COMPUTER SCIENCE 2002	3		13	1
91	2025-07-13 16:41:28.503592+02	415	415 Information Systems And Computer Science INF2009F: SYSTEMS ANALYSIS	3		13	1
92	2025-07-13 16:41:28.503608+02	414	414 Information Systems And Computer Science INF2006F: BUSINESS INTELLIGENCE AND ANALYTICS	3		13	1
93	2025-07-13 16:41:28.503624+02	413	413 Information Systems And Computer Science CSC2001F: COMPUTER SCIENCE 2001	3		13	1
94	2025-07-13 16:41:28.503639+02	412	412 Information Systems And Computer Science CML1001F: BUSINESS LAW I	3		13	1
95	2025-07-13 16:41:28.503655+02	411	411 Information Systems And Computer Science BUS1036F: EVIDENCE-BASED MANAGEMENT	3		13	1
96	2025-07-13 16:41:28.503671+02	410	410 Information Systems And Computer Science CSC1016S: COMPUTER SCIENCE 1016	3		13	1
97	2025-07-13 16:41:28.503687+02	409	409 Information Systems And Computer Science ECO1011S: MACROECONOMICS	3		13	1
98	2025-07-13 16:41:28.503703+02	408	408 Information Systems And Computer Science ACC1011S: Financial Reporting I	3		13	1
99	2025-07-13 16:41:28.503719+02	407	407 Information Systems And Computer Science MAM1032S: MATHEMATICS 1032	3		13	1
100	2025-07-13 16:41:28.503736+02	406	406 Information Systems And Computer Science MAM1031F: MATHEMATICS 1031	3		13	1
101	2025-07-13 16:41:28.503751+02	405	405 Information Systems And Computer Science MAM1012S: MATHEMATICS 1012	3		13	1
102	2025-07-13 16:41:28.503766+02	404	404 Information Systems And Computer Science MAM1010F: MATHEMATICS 1010	3		13	1
103	2025-07-13 16:41:28.503782+02	403	403 Information Systems And Computer Science CSC1015F: COMPUTER SCIENCE 1015	3		13	1
104	2025-07-13 16:41:28.503798+02	402	402 Information Systems And Computer Science ECO1010F: MICROECONOMICS I	3		13	1
105	2025-07-13 16:41:28.503813+02	401	401 Information Systems And Computer Science ACC1022Z: Accounting For Business II	3		13	1
106	2025-07-13 16:41:28.503828+02	400	400 Information Systems And Computer Science ACC1021F: Accounting For Business I	3		13	1
107	2025-07-13 22:41:03.171785+02	297	CoursesPerMajor object (297)	2	[{"changed": {"fields": ["Course code"]}}]	13	1
108	2025-07-13 22:42:16.172102+02	427	CoursesPerMajor object (427)	1	[{"added": {}}]	13	1
109	2025-07-13 22:42:30.479804+02	428	CoursesPerMajor object (428)	1	[{"added": {}}]	13	1
110	2025-07-13 22:47:17.118267+02	261	CoursesPerMajor object (261)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
111	2025-07-13 22:47:26.124581+02	260	CoursesPerMajor object (260)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
112	2025-07-13 22:49:21.317879+02	259	CoursesPerMajor object (259)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
113	2025-07-13 22:49:35.788152+02	290	CoursesPerMajor object (290)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
114	2025-07-13 22:49:42.391746+02	289	CoursesPerMajor object (289)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
115	2025-07-13 22:50:48.854079+02	288	CoursesPerMajor object (288)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
116	2025-07-13 22:50:54.260165+02	287	CoursesPerMajor object (287)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
117	2025-07-13 22:51:04.981489+02	286	CoursesPerMajor object (286)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
118	2025-07-13 22:51:12.71441+02	285	CoursesPerMajor object (285)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
119	2025-07-13 22:52:15.575036+02	284	CoursesPerMajor object (284)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
120	2025-07-13 22:52:22.316855+02	283	CoursesPerMajor object (283)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
121	2025-07-13 22:52:28.284745+02	282	CoursesPerMajor object (282)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
122	2025-07-13 22:52:37.753414+02	281	CoursesPerMajor object (281)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
123	2025-07-13 22:52:43.390151+02	280	CoursesPerMajor object (280)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
124	2025-07-13 22:52:49.024448+02	279	CoursesPerMajor object (279)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
125	2025-07-13 22:52:55.731176+02	278	CoursesPerMajor object (278)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
126	2025-07-13 22:53:01.478566+02	277	CoursesPerMajor object (277)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
127	2025-07-13 22:53:06.490463+02	276	CoursesPerMajor object (276)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
128	2025-07-13 22:53:14.123653+02	275	CoursesPerMajor object (275)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
129	2025-07-13 22:54:21.078172+02	274	CoursesPerMajor object (274)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
340	2025-08-16 22:57:28.547045+02	24	24	3		34	1
130	2025-07-13 22:54:27.170701+02	273	CoursesPerMajor object (273)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
131	2025-07-13 22:54:32.407057+02	272	CoursesPerMajor object (272)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
132	2025-07-13 22:54:39.781676+02	271	CoursesPerMajor object (271)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
133	2025-07-13 22:54:45.605412+02	270	CoursesPerMajor object (270)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
134	2025-07-13 22:54:50.500117+02	269	CoursesPerMajor object (269)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
135	2025-07-13 22:54:55.664437+02	268	CoursesPerMajor object (268)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
136	2025-07-13 22:55:00.704115+02	267	CoursesPerMajor object (267)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
137	2025-07-13 22:55:05.908305+02	266	CoursesPerMajor object (266)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
138	2025-07-13 22:55:12.033575+02	265	CoursesPerMajor object (265)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
139	2025-07-13 22:55:37.533084+02	264	CoursesPerMajor object (264)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
140	2025-07-13 22:55:42.607445+02	263	CoursesPerMajor object (263)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
141	2025-07-13 22:55:47.7076+02	262	CoursesPerMajor object (262)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
142	2025-07-13 22:55:58.843017+02	258	CoursesPerMajor object (258)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
143	2025-07-13 22:56:12.802891+02	257	CoursesPerMajor object (257)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
144	2025-07-13 22:56:30.768341+02	256	CoursesPerMajor object (256)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
145	2025-07-13 22:56:47.323168+02	255	CoursesPerMajor object (255)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
146	2025-07-13 22:56:56.140258+02	254	CoursesPerMajor object (254)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
147	2025-07-13 22:57:30.561762+02	288	CoursesPerMajor object (288)	2	[{"changed": {"fields": ["Year taken"]}}]	13	1
148	2025-07-13 23:02:01.635661+02	260	CoursesPerMajor object (260)	3		13	1
149	2025-07-13 23:02:01.635698+02	259	CoursesPerMajor object (259)	3		13	1
150	2025-07-13 23:02:01.635717+02	258	CoursesPerMajor object (258)	3		13	1
151	2025-07-13 23:02:01.635734+02	257	CoursesPerMajor object (257)	3		13	1
152	2025-07-13 23:02:01.635751+02	256	CoursesPerMajor object (256)	3		13	1
153	2025-07-13 23:02:01.635767+02	255	CoursesPerMajor object (255)	3		13	1
154	2025-07-13 23:02:01.635783+02	254	CoursesPerMajor object (254)	3		13	1
155	2025-07-13 23:04:06.40391+02	261	CoursesPerMajor object (261)	3		13	1
156	2025-07-13 23:04:06.403934+02	253	CoursesPerMajor object (253)	3		13	1
157	2025-07-13 23:04:06.403944+02	252	CoursesPerMajor object (252)	3		13	1
158	2025-07-13 23:04:06.403951+02	251	CoursesPerMajor object (251)	3		13	1
159	2025-07-13 23:04:06.403959+02	250	CoursesPerMajor object (250)	3		13	1
160	2025-07-13 23:04:06.403967+02	249	CoursesPerMajor object (249)	3		13	1
161	2025-07-13 23:04:06.403974+02	247	CoursesPerMajor object (247)	3		13	1
162	2025-07-13 23:04:06.403981+02	246	CoursesPerMajor object (246)	3		13	1
163	2025-07-13 23:04:06.403988+02	245	CoursesPerMajor object (245)	3		13	1
164	2025-07-13 23:04:06.403996+02	244	CoursesPerMajor object (244)	3		13	1
165	2025-07-13 23:04:06.404004+02	243	CoursesPerMajor object (243)	3		13	1
166	2025-07-13 23:04:37.421496+02	203	CoursesPerMajor object (203)	3		13	1
167	2025-07-13 23:05:54.030816+02	242	CoursesPerMajor object (242)	3		13	1
168	2025-07-13 23:05:54.030875+02	241	CoursesPerMajor object (241)	3		13	1
169	2025-07-13 23:05:54.030897+02	240	CoursesPerMajor object (240)	3		13	1
170	2025-07-13 23:05:54.030918+02	239	CoursesPerMajor object (239)	3		13	1
171	2025-07-13 23:05:54.030938+02	238	CoursesPerMajor object (238)	3		13	1
172	2025-07-13 23:05:54.030972+02	237	CoursesPerMajor object (237)	3		13	1
173	2025-07-13 23:05:54.030992+02	236	CoursesPerMajor object (236)	3		13	1
174	2025-07-13 23:05:54.031027+02	235	CoursesPerMajor object (235)	3		13	1
175	2025-07-13 23:05:54.031062+02	234	CoursesPerMajor object (234)	3		13	1
176	2025-07-13 23:05:54.031081+02	233	CoursesPerMajor object (233)	3		13	1
177	2025-07-13 23:12:38.694635+02	248	CoursesPerMajor object (248)	3		13	1
178	2025-07-14 22:05:51.217746+02	6	CourseGroups object (6)	3		24	1
179	2025-07-14 22:08:20.859999+02	441	CoursesPerMajor object (441)	3		13	1
180	2025-07-14 22:08:20.86011+02	440	CoursesPerMajor object (440)	3		13	1
181	2025-07-14 22:11:59.906585+02	459	CoursesPerMajor object (459)	1	[{"added": {}}]	13	1
182	2025-07-14 22:12:18.249895+02	459	CoursesPerMajor object (459)	2	[{"changed": {"fields": ["Group"]}}]	13	1
183	2025-07-14 22:57:54.235127+02	7	CourseGroups object (7)	1	[{"added": {}}]	24	1
184	2025-07-14 22:58:58.409811+02	8	CourseGroups object (8)	1	[{"added": {}}]	24	1
185	2025-07-14 22:59:33.27183+02	9	CourseGroups object (9)	1	[{"added": {}}]	24	1
186	2025-07-14 23:00:20.88238+02	379	CoursesPerMajor object (379)	2	[{"changed": {"fields": ["Group", "Path group"]}}]	13	1
187	2025-07-14 23:00:51.694979+02	378	CoursesPerMajor object (378)	2	[{"changed": {"fields": ["Group", "Path group"]}}]	13	1
188	2025-07-14 23:01:00.7954+02	377	CoursesPerMajor object (377)	2	[{"changed": {"fields": ["Group", "Path group"]}}]	13	1
189	2025-07-14 23:19:32.262507+02	CB001PHI03	CB001PHI03	1	[{"added": {}}]	11	1
190	2025-07-14 23:21:01.34586+02	499	CoursesPerMajor object (499)	2	[{"changed": {"fields": ["Group"]}}]	13	1
191	2025-07-14 23:21:07.479239+02	498	CoursesPerMajor object (498)	2	[{"changed": {"fields": ["Group"]}}]	13	1
192	2025-07-14 23:21:13.227414+02	497	CoursesPerMajor object (497)	2	[{"changed": {"fields": ["Group"]}}]	13	1
193	2025-07-14 23:21:18.360747+02	496	CoursesPerMajor object (496)	2	[{"changed": {"fields": ["Group"]}}]	13	1
194	2025-07-14 23:21:25.898996+02	495	CoursesPerMajor object (495)	2	[{"changed": {"fields": ["Group"]}}]	13	1
195	2025-07-14 23:21:31.313071+02	494	CoursesPerMajor object (494)	2	[{"changed": {"fields": ["Group"]}}]	13	1
196	2025-07-14 23:45:41.033751+02	ELECTIVE1	ELECTIVE1	2	[{"changed": {"fields": ["Course name", "Notes", "Course code"]}}]	8	1
197	2025-07-14 23:46:31.006816+02	ELECTIVE2	ELECTIVE2	2	[{"changed": {"fields": ["Course name", "Notes", "Course code"]}}]	8	1
198	2025-07-14 23:46:57.690358+02	ELECTIVE1	ELECTIVE1	2	[{"changed": {"fields": ["Course name"]}}]	8	1
199	2025-07-14 23:47:08.914865+02	ELECTIVE2	ELECTIVE2	2	[{"changed": {"fields": ["Course name"]}}]	8	1
200	2025-07-14 23:47:40.694938+02	ELECTIVE3	ELECTIVE3	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
201	2025-07-14 23:47:57.706355+02	ELECTIVE4	ELECTIVE4	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
341	2025-08-16 22:57:28.547146+02	13	13	3		34	1
202	2025-07-14 23:48:11.786033+02	ELECTIVE5	ELECTIVE5	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	8	1
203	2025-07-14 23:48:24.174456+02	ELECTIVE	ELECTIVE	2	[]	8	1
204	2025-07-15 00:02:37.655639+02	14	14	2	[{"changed": {"fields": ["Parent group id"]}}]	24	1
205	2025-07-15 00:11:19.210043+02	502	CoursesPerMajor object (502)	2	[{"changed": {"fields": ["Notes"]}}]	13	1
206	2025-07-15 00:14:27.616219+02	508	CoursesPerMajor object (508)	2	[{"changed": {"fields": ["Group"]}}]	13	1
207	2025-07-15 22:22:50.650457+02	CB001ECO02	CB001ECO02	1	[{"added": {}}]	27	1
208	2025-07-15 22:24:07.471973+02	CB001ECO04	CB001ECO04	1	[{"added": {}}]	27	1
209	2025-07-15 22:27:45.772843+02	CB019BUS01	CB019BUS01	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
210	2025-07-15 22:46:12.889406+02	512	CoursesPerDegree object (512)	1	[{"added": {}}]	28	1
211	2025-07-15 22:46:59.92552+02	17	17	1	[{"added": {}}]	24	1
212	2025-07-15 22:47:50.305091+02	278	CoursesPerDegree object (278)	2	[{"changed": {"fields": ["Group"]}}]	28	1
213	2025-07-15 22:48:03.787444+02	277	CoursesPerDegree object (277)	2	[{"changed": {"fields": ["Group"]}}]	28	1
214	2025-07-15 22:48:16.627567+02	512	CoursesPerDegree object (512)	2	[{"changed": {"fields": ["Group"]}}]	28	1
215	2025-07-15 22:52:34.395329+02	CB019BUS09	CB019BUS09	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
216	2025-07-15 22:53:53.324478+02	513	CoursesPerDegree object (513)	1	[{"added": {}}]	28	1
217	2025-07-15 22:54:28.291597+02	278	CoursesPerDegree object (278)	2	[{"changed": {"fields": ["Group"]}}]	28	1
218	2025-07-15 22:54:39.92488+02	191	CoursesPerDegree object (191)	2	[{"changed": {"fields": ["Group"]}}]	28	1
219	2025-07-15 22:54:50.102522+02	190	CoursesPerDegree object (190)	2	[{"changed": {"fields": ["Group"]}}]	28	1
220	2025-07-15 22:55:13.375662+02	18	18	1	[{"added": {}}]	24	1
221	2025-07-15 22:55:27.088198+02	513	CoursesPerDegree object (513)	2	[{"changed": {"fields": ["Group"]}}]	28	1
222	2025-07-15 22:55:45.016068+02	277	CoursesPerDegree object (277)	2	[{"changed": {"fields": ["Group"]}}]	28	1
223	2025-07-15 22:55:53.877497+02	278	CoursesPerDegree object (278)	2	[{"changed": {"fields": ["Group"]}}]	28	1
224	2025-07-15 23:01:20.549421+02	CB001ACC08	CB001ACC08	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
225	2025-07-15 23:02:20.843074+02	CB001ACC04	CB001ACC04	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
226	2025-07-15 23:03:17.903049+02	CB001ACC03	CB001ACC03	1	[{"added": {}}]	27	1
227	2025-07-15 23:04:07.306963+02	CB001ACC03	CB001ACC03	2	[{"changed": {"fields": ["Notes"]}}]	27	1
228	2025-07-15 23:04:46.234693+02	ACC1021F	ACC1021F	2	[]	8	1
229	2025-07-15 23:05:40.56381+02	CB001INF01	CB001INF01	2	[{"changed": {"fields": ["Degree name"]}}]	27	1
230	2025-07-15 23:06:47.593962+02	CB001INF06	CB001INF06	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
231	2025-07-15 23:07:06.888696+02	CB001INF11	CB001INF11	2	[{"changed": {"fields": ["Degree name"]}}]	27	1
232	2025-07-19 19:20:00.663342+02	CB001ECO02	CB001ECO02	2	[]	27	1
233	2025-07-19 19:29:52.749655+02	570	CoursesPerDegree object (570)	3		28	1
234	2025-07-19 19:29:52.749716+02	569	CoursesPerDegree object (569)	3		28	1
235	2025-07-19 19:29:52.749732+02	568	CoursesPerDegree object (568)	3		28	1
236	2025-07-19 19:29:52.749747+02	567	CoursesPerDegree object (567)	3		28	1
237	2025-07-19 19:29:52.749761+02	566	CoursesPerDegree object (566)	3		28	1
238	2025-07-19 19:29:52.749774+02	565	CoursesPerDegree object (565)	3		28	1
239	2025-07-19 19:29:52.749785+02	564	CoursesPerDegree object (564)	3		28	1
240	2025-07-19 19:29:52.749797+02	563	CoursesPerDegree object (563)	3		28	1
241	2025-07-19 19:29:52.749808+02	562	CoursesPerDegree object (562)	3		28	1
242	2025-07-19 19:29:52.74982+02	561	CoursesPerDegree object (561)	3		28	1
243	2025-07-19 19:29:52.749832+02	560	CoursesPerDegree object (560)	3		28	1
244	2025-07-19 19:29:52.749844+02	559	CoursesPerDegree object (559)	3		28	1
245	2025-07-19 19:29:52.749855+02	558	CoursesPerDegree object (558)	3		28	1
246	2025-07-19 20:28:55.297941+02	428	CoursesPerDegree object (428)	3		28	1
247	2025-07-19 20:28:55.298446+02	427	CoursesPerDegree object (427)	3		28	1
248	2025-07-19 20:28:55.298531+02	372	CoursesPerDegree object (372)	3		28	1
249	2025-07-19 22:33:36.94569+02	36	36	2	[{"changed": {"fields": ["Degree code"]}}]	24	1
250	2025-07-19 22:36:01.11089+02	556	CoursesPerDegree object (556)	2	[{"changed": {"fields": ["Group"]}}]	28	1
251	2025-07-19 22:36:11.38694+02	555	CoursesPerDegree object (555)	2	[{"changed": {"fields": ["Group"]}}]	28	1
252	2025-07-19 22:36:20.873266+02	554	CoursesPerDegree object (554)	2	[{"changed": {"fields": ["Group"]}}]	28	1
253	2025-07-19 22:36:29.967644+02	553	CoursesPerDegree object (553)	2	[{"changed": {"fields": ["Group"]}}]	28	1
254	2025-07-19 22:36:37.783353+02	552	CoursesPerDegree object (552)	2	[{"changed": {"fields": ["Group"]}}]	28	1
255	2025-07-19 22:36:47.401585+02	551	CoursesPerDegree object (551)	2	[{"changed": {"fields": ["Group"]}}]	28	1
256	2025-07-19 22:59:50.109774+02	PVL1003W	PVL1003W	1	[{"added": {}}]	8	1
257	2025-07-19 23:01:19.973842+02	PVL1004F	PVL1004F	1	[{"added": {}}]	8	1
258	2025-07-19 23:03:19.329344+02	PVL1008H	PVL1008H	1	[{"added": {}}]	8	1
259	2025-07-19 23:07:03.715258+02	PVL2002H	PVL2002H	1	[{"added": {}}]	8	1
260	2025-07-19 23:08:12.457366+02	PVL2003H	PVL2003H	1	[{"added": {}}]	8	1
261	2025-07-20 20:14:24.447698+02	CB001ACC08	CB001ACC08	2	[]	27	1
262	2025-07-20 20:32:55.223945+02	CB001ACC03	CB001ACC03	2	[]	27	1
263	2025-07-20 21:01:27.055749+02	ELECTIVE	ELECTIVE	3		8	1
264	2025-07-20 21:03:05.225801+02	ELECTIVE6	ELECTIVE6	1	[{"added": {}}]	8	1
265	2025-07-20 21:03:27.585697+02	ELECTIVE7	ELECTIVE7	1	[{"added": {}}]	8	1
266	2025-07-20 21:03:48.42813+02	ELECTIVE8	ELECTIVE8	1	[{"added": {}}]	8	1
267	2025-07-20 21:04:08.343222+02	ELECTIVE9	ELECTIVE9	1	[{"added": {}}]	8	1
268	2025-07-20 21:04:22.877624+02	ELECTIVE10	ELECTIVE10	1	[{"added": {}}]	8	1
269	2025-07-20 21:04:54.141124+02	ELECTIVE11	ELECTIVE11	1	[{"added": {}}]	8	1
270	2025-07-20 21:05:15.28907+02	ELECTIVE12	ELECTIVE12	1	[{"added": {}}]	8	1
271	2025-07-20 21:13:25.586609+02	CB001	CB001	2	[{"changed": {"fields": ["Notes"]}}]	12	1
272	2025-07-20 21:27:02.375497+02	41	41	3		24	1
273	2025-07-20 21:29:46.110326+02	CB001BUS06	CB001BUS06	2	[{"changed": {"fields": ["Notes"]}}]	27	1
274	2025-07-20 21:44:41.700604+02	CB026BUS01	CB026BUS01	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
275	2025-07-20 23:13:07.154799+02	CB026BUS09	CB026BUS09	2	[{"changed": {"fields": ["Degree name", "Notes"]}}]	27	1
276	2025-07-20 23:14:13.664449+02	CB001	CB001	2	[]	12	1
277	2025-07-20 23:16:27.611448+02	CB023	CB023	2	[{"changed": {"fields": ["Notes"]}}]	12	1
278	2025-07-27 22:43:45.02818+02	6	Law	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
279	2025-07-27 22:44:09.348875+02	5	Health Sciences	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
280	2025-07-27 22:44:15.300594+02	4	Engineering & the Built Environment	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
281	2025-07-27 22:44:21.888783+02	3	Humanities	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
282	2025-07-27 22:44:39.049883+02	2	Science	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
283	2025-07-27 22:44:45.771858+02	1	Commerce	2	[{"changed": {"fields": ["Faculty code"]}}]	29	1
284	2025-07-29 11:50:59.892324+02	ELEC1001	ELEC1001	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
285	2025-07-29 11:51:29.930303+02	ELEC1002	ELEC1002	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
286	2025-07-29 11:52:32.446849+02	ELEC2001	ELEC2001	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
287	2025-07-29 11:52:41.102613+02	ELEC2001	ELEC2001	2	[{"changed": {"fields": ["Course name"]}}]	30	1
288	2025-07-29 11:52:58.840919+02	ELEC2001	ELEC2001	2	[{"changed": {"fields": ["Course name"]}}]	30	1
289	2025-07-29 11:53:06.942065+02	ELEC2002	ELEC2002	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
290	2025-07-29 11:53:40.101118+02	ELEC3001	ELEC3001	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
291	2025-07-29 11:53:54.439952+02	ELEC3002	ELEC3002	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
292	2025-07-29 11:54:06.648427+02	ELEC3003	ELEC3003	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
293	2025-07-29 11:54:17.76124+02	ELEC3003	ELEC3003	2	[{"changed": {"fields": ["Course name", "Course code"]}}]	30	1
294	2025-08-05 22:58:53.388585+02	AGE1005L	AGE1005L	2	[{"changed": {"fields": ["Course outline", "Assessment"]}}]	30	1
295	2025-08-05 23:03:28.303454+02	AGE3012S	AGE3012S	2	[{"changed": {"fields": ["Course name"]}}]	30	1
296	2025-08-05 23:03:54.630697+02	AGE3012S	AGE3012S	2	[{"changed": {"fields": ["Notes"]}}]	30	1
297	2025-08-11 17:04:53.724397+02	Course Info	Course Info	2	[]	32	1
298	2025-08-11 17:05:01.654762+02	Degree Planning	Degree Planning	2	[]	32	1
299	2025-08-12 22:38:49.570747+02	EEE3095S	EEE3095S	2	[{"changed": {"fields": ["Assessment"]}}]	30	1
300	2025-08-12 22:39:32.075158+02	HUB3007S	HUB3007S	2	[{"changed": {"fields": ["Assessment"]}}]	30	1
301	2025-08-12 22:43:15.168904+02	IBS5005W	IBS5005W	2	[{"changed": {"fields": ["Course entry requirements", "Course outline", "Lecture times", "Dp requirements", "Assessment"]}}]	30	1
302	2025-08-12 22:45:52.517342+02	PTY3010F	PTY3010F	2	[]	30	1
303	2025-08-12 23:06:44.540931+02	SB001	SB001	1	[{"added": {}}]	33	1
304	2025-08-12 23:07:51.896075+02	SB016	SB016	1	[{"added": {}}]	33	1
305	2025-08-16 15:16:19.745635+02	MAM3046F	MAM3046F	2	[{"changed": {"fields": ["Course code"]}}]	30	1
306	2025-08-16 15:17:02.139698+02	MAM3045F	MAM3045F	2	[{"changed": {"fields": ["Course code"]}}]	30	1
307	2025-08-16 15:17:17.697153+02	MAM3044S	MAM3044S	2	[{"changed": {"fields": ["Course code"]}}]	30	1
308	2025-08-16 15:18:08.319078+02	MAM3043F	MAM3043F	2	[{"changed": {"fields": ["Course code"]}}]	30	1
309	2025-08-16 15:18:19.511393+02	MAM3042S	MAM3042S	2	[{"changed": {"fields": ["Course code"]}}]	30	1
310	2025-08-16 15:18:44.206692+02	MAM3012S	MAM3012S	2	[{"changed": {"fields": ["Course code"]}}]	30	1
311	2025-08-16 19:28:51.931239+02	TS001TST01	TS001TST01	1	[{"added": {}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - CSC1015F"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - CSC1015S"}}]	31	1
312	2025-08-16 20:39:02.775795+02	TS001TST01	TS001TST01	2	[{"added": {"name": "course group", "object": "58 (TS001TST01)"}}]	31	1
313	2025-08-16 20:43:25.185618+02	TS001TST01	TS001TST01	2	[]	31	1
314	2025-08-16 21:17:31.302813+02	TS001TST01	TS001TST01	2	[{"added": {"name": "course group", "object": "Choose 1 Group between Group 1 (MAM1004F and MAM1008S) and Group 2 (MAM1031F and MAM1032S)"}}, {"added": {"name": "course group", "object": "MAM1004F and MAM1008S"}}, {"added": {"name": "course group", "object": "MAM1031F and MAM1032S"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1004F"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1008S"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1031F"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1032S"}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - CSC1015F", "fields": ["Group"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - CSC1015S", "fields": ["Group"]}}]	31	1
315	2025-08-16 21:18:27.665175+02	TS001TST01	TS001TST01	2	[{"changed": {"name": "course group", "object": "\\u2014 MAM1004F and MAM1008S", "fields": ["Parent"]}}, {"changed": {"name": "course group", "object": "\\u2014 MAM1031F and MAM1032S", "fields": ["Parent"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1004F", "fields": ["Group"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1008S", "fields": ["Group"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1031F", "fields": ["Group"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1032S", "fields": ["Group"]}}]	31	1
316	2025-08-16 21:18:31.501502+02	TS001TST01	TS001TST01	2	[]	31	1
317	2025-08-16 22:39:17.530395+02	1	Missing Description	1	[{"added": {}}]	35	1
318	2025-08-16 22:39:30.705668+02	2	Missing Description	1	[{"added": {}}]	35	1
319	2025-08-16 22:40:01.382771+02	3	Missing Description	1	[{"added": {}}]	35	1
320	2025-08-16 22:40:26.640251+02	4	Missing Description2	1	[{"added": {}}]	35	1
321	2025-08-16 22:40:48.6914+02	5	Missing Description3	1	[{"added": {}}]	35	1
322	2025-08-16 22:41:12.414607+02	6	Missing Description	1	[{"added": {}}]	35	1
323	2025-08-16 22:41:41.47121+02	9	9	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
324	2025-08-16 22:41:51.750639+02	8	8	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
325	2025-08-16 22:41:59.225617+02	15	15	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
326	2025-08-16 22:42:06.750059+02	14	14	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
327	2025-08-16 22:42:15.46925+02	26	26	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
328	2025-08-16 22:42:27.918444+02	25	25	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
329	2025-08-16 22:42:36.928451+02	30	30	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
330	2025-08-16 22:42:44.041105+02	29	29	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
331	2025-08-16 22:42:51.443149+02	35	35	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
332	2025-08-16 22:43:45.635791+02	34	34	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
333	2025-08-16 22:44:09.599518+02	61	61	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
334	2025-08-16 22:44:22.496495+02	60	60	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
335	2025-08-16 22:52:35.092492+02	61	61	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
336	2025-08-16 22:52:43.710476+02	60	60	2	[{"changed": {"fields": ["Parent group"]}}]	34	1
337	2025-08-16 22:57:28.546854+02	59	59	3		34	1
338	2025-08-16 22:57:28.546957+02	33	33	3		34	1
342	2025-08-16 22:57:28.54719+02	7	7	3		34	1
343	2025-08-16 22:57:47.718929+02	6	Choose 1 Group between Group 1 (MAM1004F and MAM1008S) and Group 2 (MAM1031F and MAM1032S)	2	[{"changed": {"fields": ["Description"]}}]	35	1
344	2025-08-16 22:59:18.851078+02	36	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
345	2025-08-16 22:59:26.858705+02	35	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
346	2025-08-16 22:59:33.542602+02	34	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
347	2025-08-16 22:59:40.248812+02	30	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
348	2025-08-16 22:59:46.978379+02	29	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
349	2025-08-16 22:59:55.370917+02	26	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
350	2025-08-16 23:00:04.25028+02	25	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
351	2025-08-16 23:00:14.982179+02	18	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
352	2025-08-16 23:00:22.410096+02	17	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
353	2025-08-16 23:00:28.584874+02	15	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
354	2025-08-16 23:00:34.952252+02	14	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
355	2025-08-16 23:00:41.769304+02	9	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
356	2025-08-16 23:00:47.73183+02	8	Missing Description	2	[{"changed": {"fields": ["Description"]}}]	34	1
357	2025-08-16 23:30:19.964349+02	1	Missing Description	1	[{"added": {}}]	36	1
358	2025-08-16 23:30:28.086289+02	2	Missing Description2	1	[{"added": {}}]	36	1
359	2025-08-16 23:30:43.779744+02	3	Missing Description3	1	[{"added": {}}]	36	1
360	2025-08-16 23:31:06.534694+02	4	Missing Description	1	[{"added": {}}]	36	1
361	2025-08-16 23:31:16.651201+02	5	Missing Description2	1	[{"added": {}}]	36	1
362	2025-08-16 23:31:22.624651+02	6	Missing Description3	1	[{"added": {}}]	36	1
363	2025-08-16 23:31:44.791461+02	7	Missing Description	1	[{"added": {}}]	36	1
364	2025-08-16 23:31:56.36556+02	8	Missing Description2	1	[{"added": {}}]	36	1
365	2025-08-16 23:32:12.771837+02	9	Missing Description3	1	[{"added": {}}]	36	1
366	2025-08-16 23:32:26.250642+02	10	Missing Description4	1	[{"added": {}}]	36	1
367	2025-08-16 23:32:52.247983+02	57	Missing Description	3		34	1
368	2025-08-16 23:32:52.248018+02	56	Missing Description	3		34	1
369	2025-08-16 23:32:52.248037+02	55	Missing Description	3		34	1
370	2025-08-16 23:32:52.248054+02	54	Missing Description	3		34	1
371	2025-08-16 23:32:52.24807+02	53	Missing Description	3		34	1
372	2025-08-16 23:32:52.248086+02	52	Missing Description	3		34	1
373	2025-08-16 23:32:52.2481+02	51	Missing Description	3		34	1
374	2025-08-16 23:32:52.248115+02	50	Missing Description	3		34	1
375	2025-08-16 23:32:52.248129+02	49	Missing Description	3		34	1
376	2025-08-16 23:32:52.248144+02	48	Missing Description	3		34	1
377	2025-08-16 23:36:29.020159+02	59	MAM01 - MAM2012S	2	[{"changed": {"fields": ["Group"]}}]	13	1
378	2025-08-16 23:36:38.958765+02	60	MAM01 - MAM2013S	2	[{"changed": {"fields": ["Group"]}}]	13	1
379	2025-08-16 23:36:48.60318+02	61	MAM01 - MAM2014S	2	[{"changed": {"fields": ["Group"]}}]	13	1
380	2025-08-16 23:37:00.045988+02	66	MAM01 - MAM3043F	2	[{"changed": {"fields": ["Group"]}}]	13	1
381	2025-08-16 23:37:13.069195+02	67	MAM01 - MAM3043S	2	[{"changed": {"fields": ["Group"]}}]	13	1
382	2025-08-16 23:43:52.494205+02	92	STA01 - STA3022F	2	[{"changed": {"fields": ["Group"]}}]	13	1
383	2025-08-16 23:44:00.453159+02	93	STA01 - STA3036S	2	[{"changed": {"fields": ["Group"]}}]	13	1
384	2025-08-16 23:44:07.76208+02	94	CSC05 - CSC1015F	2	[{"changed": {"fields": ["Group"]}}]	13	1
385	2025-08-16 23:44:14.955134+02	95	CSC05 - CSC1015S	2	[{"changed": {"fields": ["Group"]}}]	13	1
386	2025-08-18 19:03:34.666792+02	TS001TST02	TS001TST02	1	[{"added": {}}]	31	1
387	2025-08-18 19:03:53.592479+02	TS001TST02	TS001TST02	2	[{"changed": {"fields": ["Degree name"]}}]	31	1
388	2025-08-18 22:22:39.938361+02	TST01	TST01	1	[{"added": {}}]	37	1
389	2025-08-18 22:23:47.696732+02	TST01	TST01	2	[{"added": {"name": "major parent course group", "object": "Choose between both MAM1004F and MAM1008S or both MAM1031F and MAM1032S"}}]	37	1
390	2025-08-18 22:46:05.29001+02	TST01	TST01	2	[{"added": {"name": "major course group", "object": "11"}}, {"added": {"name": "major course group", "object": "12"}}]	37	1
391	2025-08-18 22:48:47.350539+02	TST01	TST01	2	[{"added": {"name": "courses per major", "object": "TST01 - MAM1004F"}}, {"added": {"name": "courses per major", "object": "TST01 - MAM1008S"}}, {"added": {"name": "courses per major", "object": "TST01 - MAM1031F"}}, {"added": {"name": "courses per major", "object": "TST01 - MAM1032S"}}]	37	1
392	2025-08-18 22:49:48.029467+02	TST01	TST01	2	[{"added": {"name": "major course group", "object": "Choose 1 between CSC1015F and CSC1015S"}}]	37	1
393	2025-08-18 22:50:23.893777+02	TST01	TST01	2	[{"added": {"name": "courses per major", "object": "TST01 - CSC1015F"}}, {"added": {"name": "courses per major", "object": "TST01 - CSC1015S"}}]	37	1
394	2025-08-18 22:51:07.072417+02	TST01	TST01	2	[{"changed": {"fields": ["Notes"]}}]	37	1
395	2025-08-19 12:49:46.187274+02	F	First	1	[{"added": {}}]	38	1
396	2025-08-19 12:49:54.449903+02	S	Second	1	[{"added": {}}]	38	1
397	2025-08-19 12:50:09.166316+02	W	Whole-year	1	[{"added": {}}]	38	1
398	2025-08-19 12:50:21.045613+02	H	Whole-year	1	[{"added": {}}]	38	1
399	2025-08-19 12:50:32.538605+02	P	Summer Term	1	[{"added": {}}]	38	1
400	2025-08-19 12:50:46.228164+02	L	Winter Term	1	[{"added": {}}]	38	1
401	2025-08-19 12:51:05.150759+02	Z	Non-Standard	1	[{"added": {}}]	38	1
402	2025-08-19 12:51:15.566991+02	X	Non-Standard	1	[{"added": {}}]	38	1
403	2025-08-19 13:43:41.228138+02	1	EthanSucks	2	[{"changed": {"fields": ["Username"]}}]	4	1
404	2025-08-19 13:44:29.325907+02	1	EthanSucks	2	[{"changed": {"fields": ["password"]}}]	4	1
405	2025-08-19 13:44:32.133746+02	1	EthanSucks	2	[]	4	1
406	2025-08-19 23:22:45.791427+02	1	EthanAndDylanSuck	2	[{"changed": {"fields": ["Username", "First name", "Last name"]}}]	4	1
407	2025-08-20 17:10:21.894699+02	ECO1015F	ECO1015F	1	[{"added": {}}]	30	1
408	2025-08-20 17:11:06.965122+02	ECO1015F	ECO1015F	3		30	1
409	2025-08-20 17:46:21.562435+02	TS001TST01	TS001TST01	2	[{"deleted": {"name": "degree course group", "object": "MAM1031F and MAM1032S"}}]	31	1
410	2025-08-20 17:48:39.789707+02	TS001TST01	TS001TST01	2	[{"deleted": {"name": "degree course group", "object": "MAM1004F and MAM1008S"}}]	31	1
411	2025-08-20 17:49:31.311111+02	TS001TST01	TS001TST01	2	[{"added": {"name": "degree course group", "object": "MAM1004F and MAM1008S"}}]	31	1
412	2025-08-20 17:50:08.820237+02	TS001TST01	TS001TST01	2	[{"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1004F", "fields": ["Course group"]}}, {"changed": {"name": "courses per degree", "object": "TS001TST01 - MAM1008S", "fields": ["Course group"]}}]	31	1
413	2025-08-20 17:50:22.836848+02	TS001TST01	TS001TST01	2	[{"changed": {"name": "degree course group", "object": "MAM1004F and MAM1008", "fields": ["Description"]}}]	31	1
414	2025-08-20 17:52:05.956538+02	TS001TST01	TS001TST01	2	[{"changed": {"name": "degree course group", "object": "MAM1004F and MAM1008S", "fields": ["Description"]}}]	31	1
415	2025-08-20 17:53:00.454863+02	TS001TST01	TS001TST01	2	[{"added": {"name": "degree course group", "object": "MAM1031F and MAM1032S"}}, {"changed": {"name": "degree course group", "object": "MAM1004F and MAM1008S", "fields": ["Parent group"]}}]	31	1
416	2025-08-20 17:54:07.414332+02	TS001TST01	TS001TST01	2	[{"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1031F"}}, {"added": {"name": "courses per degree", "object": "TS001TST01 - MAM1032S"}}]	31	1
417	2025-08-20 17:56:14.612213+02	TS001TST01	TS001TST01	2	[{"deleted": {"name": "degree course group", "object": "MAM1031F and MAM1032S"}}]	31	1
418	2025-08-20 18:23:52.044059+02	TS001TST01	TS001TST01	2	[{"added": {"name": "degree course group", "object": "MAM1031F and MAM1032S"}}]	31	1
419	2025-08-20 22:31:59.153985+02	TST	Test Department	1	[{"added": {}}]	39	1
420	2025-08-20 22:42:37.513496+02	TST	TST	1	[{"added": {}}]	33	1
421	2025-08-20 22:44:04.567973+02	TST	TST	3		33	1
422	2025-08-20 22:44:59.526292+02	TST01	TST01	1	[{"added": {}}]	33	1
423	2025-08-20 22:45:32.335565+02	TS001	TS001	2	[{"changed": {"fields": ["Program abbreviation", "Program code"]}}]	33	1
424	2025-08-20 22:45:38.404991+02	TST01	TST01	3		33	1
425	2025-08-20 22:45:43.823616+02	TS001	TS001	2	[{"changed": {"fields": ["Program abbreviation"]}}]	33	1
426	2025-08-20 23:58:57.462503+02	TS001	Test Program	2	[{"changed": {"fields": ["Minimum duration years", "Qualification"]}}]	33	1
427	2025-08-21 00:04:05.592137+02	TS001	Test Program	2	[]	33	1
428	2025-08-21 00:09:38.92477+02	SB016	Bachelor of Science Extended Degree Programme	2	[{"changed": {"fields": ["Qualification"]}}]	33	1
429	2025-08-21 00:10:35.734823+02	SB001	Bachelor of Science	2	[{"changed": {"fields": ["Qualification"]}}]	33	1
430	2025-08-21 00:12:01.281577+02	CU021	Advanced Diploma in Management Development	2	[{"changed": {"fields": ["Qualification"]}}]	33	1
431	2025-08-21 00:12:09.098445+02	CU020	Advanced Diploma in Actuarial Science	2	[{"changed": {"fields": ["Qualification"]}}]	33	1
432	2025-08-21 00:12:15.919505+02	CU017	Advanced Diploma in Accounting	2	[{"changed": {"fields": ["Qualification"]}}]	33	1
433	2025-08-21 00:18:11.505108+02	CB025	Bachelor of Business Science in Actuarial Science Academic Development: Augmented	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
434	2025-08-21 00:18:20.764595+02	CB024	Bachelor of Business Science Academic Development: Augmented	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
435	2025-08-21 00:18:31.361862+02	CB018	Bachelor of Business Science in Actuarial Science Academic Development: Extended	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
436	2025-08-21 00:18:39.679325+02	CB015	Bachelor of Business Science Academic Development: Extended	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
437	2025-08-21 00:18:47.322295+02	CB004	Bachelor of Business Science	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
438	2025-08-21 00:18:59.364517+02	CB003	Bachelor of Business Science in Actuarial Science	2	[{"changed": {"fields": ["Nqf level"]}}]	33	1
439	2025-08-21 11:17:23.682124+02	H	Whole-year	2	[]	38	1
440	2025-08-21 11:17:33.660064+02	H	Whole Year	2	[{"changed": {"fields": ["Semester name"]}}]	38	1
441	2025-08-21 11:17:40.23718+02	W	Whole Year	2	[{"changed": {"fields": ["Semester name"]}}]	38	1
442	2025-08-21 11:29:23.055895+02	TS001TST01	TS001TST01	2	[]	31	1
443	2025-08-21 11:58:06.815891+02	TST1010F	TST1010F	1	[{"added": {}}]	30	1
444	2025-08-21 11:58:34.084662+02	TST1010F	TST1010F	2	[{"changed": {"fields": ["Convener"]}}]	30	1
445	2025-08-21 11:58:58.093632+02	TST1010F	TST1010F	2	[{"changed": {"fields": ["Convener"]}}]	30	1
446	2025-08-21 14:13:01.638925+02	CB015CSC05	CB015CSC05	2	[{"added": {"name": "courses per degree", "object": "CB015CSC05 - CSC1015F"}}]	31	1
447	2025-08-21 14:23:55.794485+02	1	myAdvisorAdmin	2	[{"changed": {"fields": ["Username"]}}]	4	1
448	2025-08-21 14:26:20.291803+02	2	TimLow	1	[{"added": {}}]	4	1
449	2025-08-21 14:35:18.550467+02	2	TimLow	2	[{"changed": {"fields": ["Staff status", "Superuser status"]}}]	4	1
450	2025-08-22 18:54:24.027429+02	1	HWRDYL001	1	[{"added": {}}]	41	1
451	2025-08-22 18:55:58.747966+02	1	Aslam Safla	2	[{"changed": {"fields": ["Username", "First name", "Last name"]}}]	42	1
452	2025-08-22 19:38:35.757354+02	1	HWRDYL001	1	[{"added": {}}]	41	1
453	2025-08-22 20:13:13.130576+02	20	Dr Mitchell Flanegan	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
454	2025-08-22 20:14:59.417602+02	18	Dr Pragasen Pillay	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
455	2025-08-22 20:15:17.199829+02	17	Associate Professor Nkosivile Madinga	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
456	2025-08-22 20:15:39.52547+02	16	Dr Nqobile Bundwini	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
457	2025-08-22 20:15:53.564259+02	15	Dr Raeesah Chohan	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
458	2025-08-22 20:16:27.918941+02	14	Lecturer Lebogang Mototo	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
459	2025-08-22 20:17:42.147452+02	13	Daniel Munene	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
460	2025-08-22 20:17:52.807899+02	11	Marlin Hoffman	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
461	2025-08-22 20:18:03.295561+02	10	Jacques Rousseau	2	[{"changed": {"fields": ["Faculty", "Department"]}}]	42	1
462	2025-08-22 20:22:22.862782+02	9	Alison Meadows	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
463	2025-08-22 20:23:03.933754+02	8	Student Advisors – Organisational Psychology None	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
464	2025-08-22 20:37:58.551008+02	CB026BUS09	Bachelor of Commerce in Actuarial Science Academic Development: Augmented Quantitative Finance	2	[{"changed": {"fields": ["Degree name"]}}]	31	1
465	2025-08-22 20:38:17.671814+02	CB019BUS09	Bachelor of Commerce in Actuarial Science Quantitative Finance	2	[{"changed": {"fields": ["Degree name"]}}, {"changed": {"name": "courses per degree", "object": "Bachelor of Commerce in Actuarial Science Quantitative Finance - MAM2012S", "fields": ["Course group"]}}, {"changed": {"name": "courses per degree", "object": "Bachelor of Commerce in Actuarial Science Quantitative Finance - MAM2014S", "fields": ["Course group"]}}]	31	1
466	2025-08-22 20:39:50.806145+02	CB001ECO02	Bachelor of Commerce Economics and Finance	2	[{"changed": {"fields": ["Degree name"]}}]	31	1
467	2025-08-22 20:46:24.050136+02	1	Professor Aslam Safla	2	[{"changed": {"fields": ["Faculties", "Departments", "Programs", "Degrees"]}}]	42	1
468	2025-08-22 20:46:48.651784+02	1	Professor Aslam Safla	2	[{"changed": {"fields": ["Majors"]}}]	42	1
469	2025-08-22 20:47:46.457764+02	6	Information Systems Advisors None	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
470	2025-08-22 20:49:04.530578+02	5	Economics Advisors None	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
471	2025-08-22 20:51:43.358617+02	7	Student Advisors - Actuarial Science None	2	[{"changed": {"fields": ["Email", "Faculties", "Departments", "Programs", "Notes"]}}]	42	1
472	2025-08-22 20:52:37.625367+02	4	Student Advisors - Finance and Tax None	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
473	2025-08-22 20:52:49.783885+02	3	Student Advisors - Accounting None	2	[{"changed": {"fields": ["Faculties", "Departments"]}}]	42	1
474	2025-08-22 20:54:19.175353+02	2	Dominique Katshunga	2	[{"changed": {"fields": ["Faculties", "Departments", "Degrees"]}}]	42	1
475	2025-08-22 21:00:17.985545+02	1	Professor Aslam Safla	2	[{"changed": {"fields": ["Degrees", "Notes"]}}]	42	1
476	2025-08-22 22:48:11.889307+02	1	HWRDYL001	2	[]	41	1
477	2025-08-22 22:51:17.880309+02	1	myAdvisorAdmin	2	[{"changed": {"fields": ["First name", "Last name"]}}]	4	1
478	2025-08-22 22:52:02.046181+02	1	HWRDYL001	2	[]	41	1
479	2025-08-22 22:53:20.109938+02	2	EthanAllies	1	[{"added": {}}]	41	1
480	2025-08-22 22:53:48.926845+02	1	HWRDYL001	3		41	1
481	2025-08-22 23:39:43.457485+02	2	EthanAllies	2	[{"changed": {"fields": ["First name", "Last name"]}}]	41	1
482	2025-08-23 00:01:05.02742+02	20	Dr Mitchell Flanegan	2	[{"changed": {"fields": ["password"]}}]	42	1
483	2025-08-23 00:03:01.138798+02	20	Dr Mitchell Flanegan	2	[]	42	1
484	2025-08-23 00:13:02.424545+02	9	Alison Meadows	2	[{"changed": {"fields": ["Degrees"]}}]	42	1
485	2025-08-23 00:22:41.372867+02	2	EthanAllies	2	[]	41	1
486	2025-08-23 00:31:10.680026+02	20	Dr Mitchell Flanegan	2	[{"changed": {"fields": ["Faculties"]}}]	42	1
487	2025-08-23 00:53:27.448564+02	3	MitchellFlanegan	3		41	1
488	2025-08-23 01:29:06.606331+02	1	What is life?	1	[{"added": {}}]	49	1
489	2025-08-23 01:45:10.142294+02	2	ndkurfbss	1	[{"added": {}}]	49	1
490	2025-08-23 01:53:06.669295+02	7	JoeSoap	3		41	1
491	2025-08-23 01:56:54.162012+02	8	JoeSoap	3		41	1
492	2025-08-23 02:10:12.189257+02	9	JoeSoap	3		41	1
493	2025-08-23 02:10:26.303741+02	10	JoeSoap	3		41	1
494	2025-08-23 02:13:44.849657+02	1	What is life?	2	[{"changed": {"fields": ["Answer"]}}]	49	1
495	2025-08-23 02:23:52.173147+02	5	DylanHoward	2	[{"changed": {"fields": ["password"]}}]	41	1
496	2025-08-23 02:26:24.412676+02	2	EthanAllies	2	[{"changed": {"fields": ["password"]}}]	41	1
497	2025-08-23 16:09:23.325471+02	3	Can I apply for a concession in Law?	1	[{"added": {}}]	49	1
498	2025-08-23 16:09:56.725126+02	4	Can I apply for an exemption in Law?	1	[{"added": {}}]	49	1
499	2025-08-23 16:10:30.593099+02	5	Can I apply for an extended degree programme in law?	1	[{"added": {}}]	49	1
500	2025-08-23 16:10:57.652914+02	6	Can I apply for deferred exams in law?	1	[{"added": {}}]	49	1
501	2025-08-23 16:11:15.358882+02	7	Can I apply for UCT financial assistance if I have exceeded my NSFAS N+1 funding rule?	1	[{"added": {}}]	49	1
502	2025-08-23 16:11:32.145539+02	8	Can I apply to UCT while completing Grade 11?	1	[{"added": {}}]	49	1
503	2025-08-23 16:11:44.541863+02	9	Can I apply/submit a late application for NSFAS funding?	1	[{"added": {}}]	49	1
504	2025-08-23 16:11:57.95298+02	10	Can I be accepted into commerce if I don’t meet the Maths requirements?	1	[{"added": {}}]	49	1
505	2025-08-23 16:12:18.813984+02	11	Can I defer my exams because of my mental health?	1	[{"added": {}}]	49	1
506	2025-08-23 16:12:30.504812+02	12	Can I do a Postgraduate Diploma in Actuarial Science?	1	[{"added": {}}]	49	1
507	2025-08-23 16:12:56.493845+02	13	Can I get an extension for transcript submissions?	1	[{"added": {}}]	49	1
508	2025-08-23 16:13:08.029568+02	14	Can I get into UCT using my Cambridge results?	1	[{"added": {}}]	49	1
509	2025-08-23 16:13:28.323829+02	15	Can I physically return my books to UCT library?	1	[{"added": {}}]	49	1
510	2025-08-23 16:13:42.300771+02	16	Can I still use a Jammie shuttle if I stay off campus?	1	[{"added": {}}]	49	1
511	2025-08-23 16:13:56.595278+02	17	Can I transfer from another university into Law at UCT?	1	[{"added": {}}]	49	1
512	2025-08-23 16:14:10.824131+02	18	Can I volunteer to assist at the Disability Service?	1	[{"added": {}}]	49	1
513	2025-08-23 16:14:47.624296+02	19	Do all students qualify for NSFAS accommodation funding?	1	[{"added": {}}]	49	1
514	2025-08-23 16:15:05.817698+02	20	Do I have to write the NBTs if I want to do Law?	1	[{"added": {}}]	49	1
515	2025-08-23 16:15:30.506272+02	21	What software (microsoft word, powerpoint, excel) does uct provide?	1	[{"added": {}}]	49	1
516	2025-08-23 16:15:44.414607+02	22	Do I need to send my final school-leaving results to UCT?	1	[{"added": {}}]	49	1
517	2025-08-23 16:16:39.095734+02	23	Do I need to take the NBTs to apply to UCT?	1	[{"added": {}}]	49	1
518	2025-08-23 16:17:21.256871+02	24	Qualify for student housing?	1	[{"added": {}}]	49	1
519	2025-08-23 16:17:53.237706+02	25	Do I receive a funding offer with a UCT acceptance letter?	1	[{"added": {}}]	49	1
520	2025-08-23 16:18:05.744932+02	26	Do I receive a housing offer with a UCT acceptance letter?	1	[{"added": {}}]	49	1
521	2025-08-23 16:18:42.424664+02	27	Does Careers Service offer help with finding opportunities for work or study overseas/internationally?	1	[{"added": {}}]	49	1
522	2025-08-23 16:18:53.210563+02	28	Does NSFAS cover private accommodation if I don’t get into a University residence?	1	[{"added": {}}]	49	1
523	2025-08-23 16:19:18.447719+02	29	Does the library only have serious materials?	1	[{"added": {}}]	49	1
524	2025-08-23 16:19:28.462832+02	30	Does UCT offer counselling support?	1	[{"added": {}}]	49	1
525	2025-08-23 16:19:50.593175+02	31	Does UCT offer medical support?	1	[{"added": {}}]	49	1
526	2025-08-23 16:20:04.115052+02	32	Does UCT offer support for psychiatric emergencies?	1	[{"added": {}}]	49	1
527	2025-08-23 16:20:51.240665+02	33	Does UCT provide data for online learning?	1	[{"added": {}}]	49	1
528	2025-08-25 12:19:39.042742+02	2	ndkurfbss	3		49	1
529	2025-08-25 18:07:24.534829+02	33	Does UCT provide data for online learning?	2	[{"changed": {"fields": ["Answer"]}}]	49	1
530	2025-08-26 22:53:40.55602+02	35	How to degree	3		49	1
531	2025-08-26 23:14:48.413572+02	2	Ethan Allies	2	[{"changed": {"fields": ["Username"]}}]	41	1
532	2025-08-27 11:52:16.832421+02	41	What even is the Science faculty? TELL MEEEEE	3		49	1
533	2025-08-30 17:16:11.23946+02	TS001TST02	TProg specialising in Test Degree 2	2	[{"added": {"name": "degree course group", "object": "Group None"}}]	31	1
534	2025-08-30 17:16:42.189471+02	TS001TST02	TProg specialising in Test Degree 2	2	[{"added": {"name": "degree course group", "object": "e.g. 'Choose 1 between MAM1004F and MAM1031F'.\\r\\nLeave blank to have a unique description generated for you."}}]	31	1
535	2025-08-30 17:16:54.413744+02	TS001TST02	TProg specialising in Test Degree 2	2	[{"added": {"name": "degree course group", "object": "Group None"}}]	31	1
537	2025-08-30 17:17:45.27426+02	TS001TST02	TProg specialising in Test Degree 2	2	[{"deleted": {"name": "degree course group", "object": "Group None"}}, {"deleted": {"name": "degree course group", "object": "e.g. 'Choose 1 between MAM1004F and MAM1031F'.\\r\\nLeave blank to have a unique description generated for you."}}, {"deleted": {"name": "degree course group", "object": "Group None"}}]	31	1
538	2025-08-30 17:42:39.509942+02	TS001TST02	TProg specialising in Test Degree 2	2	[]	31	1
539	2025-08-30 17:43:05.976428+02	TS001TST02	TProg specialising in Test Degree 2	2	[]	31	1
540	2025-08-30 17:45:47.225715+02	TS001TST02	TProg specialising in Test Degree 2	2	[]	31	1
541	2025-08-30 21:57:44.652881+02	TST1012F	TST1012F	1	[{"added": {}}]	30	1
542	2025-08-30 21:58:07.026831+02	TST1010F	TST1010F	2	[]	30	1
543	2025-08-30 21:58:26.069734+02	TST1012F	TST1012F	3		30	1
544	2025-08-30 21:59:44.521518+02	ACC1006F	ACC1006F	2	[{"changed": {"fields": ["Course name"]}}]	30	1
545	2025-08-30 22:00:06.503563+02	ACC1011S	ACC1011S	2	[{"changed": {"fields": ["Course name"]}}]	30	1
546	2025-08-30 22:17:47.198067+02	TS001TST02	TProg specialising in Test Degree 2	3		31	1
547	2025-08-30 22:34:52.991473+02	TS001TST02	TProg specialising in dsvfb	1	[{"added": {}}]	31	1
548	2025-08-30 22:35:33.457483+02	TS001MAM02	TProg specialising in dsvfb	2	[{"changed": {"fields": ["Degree code"]}}]	31	1
549	2025-08-30 22:37:52.447985+02	TS001TST02	TProg specialising in dsvfb	3		31	1
550	2025-08-30 22:41:50.209736+02	TS001TST01	TProg ybiugvtu89go	1	[{"added": {}}]	37	1
551	2025-08-30 22:42:23.710616+02	TS001TST01	TProg ybiugvtu89go	3		37	1
552	2025-08-30 22:45:48.032645+02	7	dbxgfng	1	[{"added": {}}]	29	1
553	2025-08-30 22:54:58.622686+02	7	dbxgfng	3		29	1
554	2025-08-30 22:55:44.505945+02	afw	vdfegtdfvfsd	1	[{"added": {}}]	39	1
555	2025-08-30 22:56:11.238517+02	afw	vdfegtdfvfsd	3		39	1
556	2025-08-30 23:01:35.098932+02	VGF	vh fyu	1	[{"added": {}}]	39	1
557	2025-08-30 23:01:57.554271+02	VGF	vh fyu	3		39	1
558	2025-08-30 23:04:08.653457+02	8	uhoij	1	[{"added": {}}]	29	1
559	2025-08-30 23:04:20.491988+02	8	uhoij	3		29	1
560	2025-08-30 23:19:42.821898+02	10	Degree Planning - iulbk	1	[{"added": {}}]	46	1
561	2025-08-30 23:20:00.733601+02	10	Degree Planning - iulbk	3		46	1
562	2025-08-30 23:30:15.465425+02	6	Course Info - How do I know if a course is offered this year?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
563	2025-08-30 23:30:20.799524+02	5	Course Info - Where can I find course prerequisites?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
564	2025-08-30 23:30:26.476602+02	4	Degree Planning - Can I save multiple plans?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
565	2025-08-30 23:30:33.30912+02	3	Degree Planning - How do I plan my degree?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
566	2025-08-30 23:30:39.296626+02	2	General - Is MyAdvisor free to use?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
567	2025-08-30 23:30:43.745146+02	1	General - What is MyAdvisor?	2	[{"changed": {"fields": ["Temp"]}}]	46	1
568	2025-08-30 23:33:11.574928+02	Support	Support	2	[{"changed": {"fields": ["Section id"]}}]	47	1
569	2025-08-30 23:33:17.298765+02	General	General	2	[{"changed": {"fields": ["Section id"]}}]	47	1
570	2025-08-30 23:33:23.244127+02	Degree Planning	Degree Planning	2	[{"changed": {"fields": ["Section id"]}}]	47	1
571	2025-08-30 23:33:27.784958+02	Course Info	Course Info	2	[{"changed": {"fields": ["Section id"]}}]	47	1
572	2025-08-30 23:33:36.6042+02	Course Info	Course Info	2	[{"changed": {"fields": ["Section id"]}}]	47	1
573	2025-08-30 23:33:41.697258+02	Degree Planning	Degree Planning	2	[{"changed": {"fields": ["Section id"]}}]	47	1
574	2025-08-31 00:24:46.86104+02	11	Support - fgrsfa	1	[{"added": {}}]	46	1
575	2025-08-31 00:24:56.448448+02	11	Support - fgrsfa	3		46	1
\.


--
-- Data for Name: django_content_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.django_content_type (id, app_label, model) FROM stdin;
1	admin	logentry
2	auth	permission
3	auth	group
4	auth	user
5	contenttypes	contenttype
6	sessions	session
7	handbook	alternativecoursegroups
8	handbook	courses
9	handbook	departments
10	handbook	faculties
11	handbook	majors
12	handbook	programs
13	handbook	coursespermajor
14	handbook	authgroup
15	handbook	authgrouppermissions
16	handbook	authpermission
17	handbook	authuser
18	handbook	authusergroups
19	handbook	authuseruserpermissions
20	handbook	djangoadminlog
21	handbook	djangocontenttype
22	handbook	djangomigrations
23	handbook	djangosession
24	handbook	coursegroups
25	handbook	coursepathgroups
26	handbook	coursepaths
27	handbook	degrees
28	handbook	coursesperdegree
29	handbook	faculty
30	handbook	course
31	handbook	degree
32	handbook	faqsection
33	handbook	program
34	handbook	coursegroup
35	handbook	degreeparentcoursegroup
36	handbook	majorcoursegroup
37	handbook	major
38	handbook	semester
39	handbook	department
40	handbook	qualification
41	advising	student
42	advising	advisor
43	handbook	majorparentcoursegroup
44	handbook	degreecoursegroup
45	handbook	elective
46	advising	faq
47	advising	faqsection
48	advising	glossary
49	advising	advisorquestion
50	other	authgroup
51	other	authgrouppermissions
52	other	authpermission
53	other	authuser
54	other	authusergroups
55	other	authuseruserpermissions
56	other	djangoadminlog
57	other	djangocontenttype
58	other	djangomigrations
59	other	djangosession
\.


--
-- Data for Name: django_migrations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.django_migrations (id, app, name, applied) FROM stdin;
1	contenttypes	0001_initial	2025-07-12 14:49:03.407206+02
2	auth	0001_initial	2025-07-12 14:49:03.499448+02
3	admin	0001_initial	2025-07-12 14:49:03.530585+02
4	admin	0002_logentry_remove_auto_add	2025-07-12 14:49:03.538058+02
5	admin	0003_logentry_add_action_flag_choices	2025-07-12 14:49:03.548706+02
6	contenttypes	0002_remove_content_type_name	2025-07-12 14:49:03.573485+02
7	auth	0002_alter_permission_name_max_length	2025-07-12 14:49:03.585733+02
8	auth	0003_alter_user_email_max_length	2025-07-12 14:49:03.596472+02
9	auth	0004_alter_user_username_opts	2025-07-12 14:49:03.607061+02
10	auth	0005_alter_user_last_login_null	2025-07-12 14:49:03.618687+02
11	auth	0006_require_contenttypes_0002	2025-07-12 14:49:03.620943+02
12	auth	0007_alter_validators_add_error_messages	2025-07-12 14:49:03.633076+02
13	auth	0008_alter_user_username_max_length	2025-07-12 14:49:03.654192+02
14	auth	0009_alter_user_last_name_max_length	2025-07-12 14:49:03.669547+02
15	auth	0010_alter_group_name_max_length	2025-07-12 14:49:03.684735+02
16	auth	0011_update_proxy_permissions	2025-07-12 14:49:03.694983+02
17	auth	0012_alter_user_first_name_max_length	2025-07-12 14:49:03.705988+02
18	handbook	0001_initial	2025-07-12 14:49:03.717476+02
19	sessions	0001_initial	2025-07-12 14:49:03.739618+02
20	handbook	0002_authgroup_authgrouppermissions_authpermission_and_more	2025-07-13 14:08:42.312406+02
21	advising	0001_initial	2025-08-22 19:12:32.290147+02
22	advising	0002_remove_advisor_degree_remove_advisor_department_and_more	2025-08-22 20:08:30.610784+02
23	advising	0003_rename_degree_advisor_degrees_and_more	2025-08-22 20:20:07.730826+02
24	advising	0004_student_date_joined_student_groups_student_is_active_and_more	2025-08-22 22:34:42.029545+02
25	other	0001_initial	2025-08-22 22:34:42.045289+02
26	advising	0005_advisor_date_joined_advisor_groups_advisor_is_active_and_more	2025-08-22 23:52:48.102242+02
27	advising	0006_alter_advisor_password_alter_advisor_username_and_more	2025-08-23 00:21:27.018827+02
28	advising	0007_advisorquestion_advisor_read_and_more	2025-08-26 17:23:16.931723+02
29	advising	0008_rename_timestamp_advisorquestion_q_timestamp_and_more	2025-08-26 17:34:05.191272+02
30	advising	0009_alter_advisorquestion_a_timestamp_and_more	2025-08-26 17:34:05.243668+02
31	handbook	0002_alter_faculty_options	2025-08-29 20:52:07.391326+02
32	handbook	0002_faculty_faculty_id_alter_faculty_faculty_code	2025-08-30 12:39:50.114384+02
33	handbook	0003_alter_semester_options	2025-08-30 18:31:39.590902+02
34	handbook	0004_alter_semester_semester_name	2025-08-30 18:31:39.602755+02
35	handbook	0005_alter_course_options	2025-08-30 18:31:39.606244+02
36	handbook	0006_course_department_course_semester_and_more	2025-08-30 18:32:02.324258+02
37	handbook	0007_course_department_course_semester_and_more	2025-08-30 18:41:43.427897+02
38	handbook	0008_alter_qualification_options	2025-08-30 18:58:06.235192+02
39	handbook	0009_alter_program_options	2025-08-30 18:59:21.398946+02
40	handbook	0010_program_faculty_program_qualification_and_more	2025-08-30 19:06:14.402028+02
41	handbook	0011_alter_degree_options_alter_major_options_and_more	2025-08-30 19:12:30.676113+02
42	handbook	0012_alter_degree_department_alter_degree_program_and_more	2025-08-30 19:12:30.775081+02
43	handbook	0013_alter_degree_degree_name_alter_degree_department_and_more	2025-08-30 19:13:52.595271+02
44	handbook	0014_alter_degreecoursegroup_options_and_more	2025-08-30 21:05:00.368043+02
45	handbook	0015_degreecoursegroup_parent_group_and_more	2025-08-30 21:05:47.140595+02
46	handbook	0016_alter_coursesperdegree_options_and_more	2025-08-30 21:15:12.095904+02
47	handbook	0017_coursesperdegree_course_group_and_more	2025-08-30 21:15:12.186939+02
48	handbook	0018_alter_degreecoursegroup_parent_group_and_more	2025-08-30 21:16:32.514397+02
49	handbook	0019_alter_elective_options	2025-08-30 21:20:56.169725+02
50	handbook	0020_alter_elective_course_alter_elective_program_and_more	2025-08-30 21:20:56.214104+02
51	handbook	0021_alter_elective_year	2025-08-30 21:24:20.014563+02
52	handbook	0022_alter_elective_course_alter_elective_program	2025-08-30 21:28:04.717662+02
53	handbook	0023_alter_coursespermajor_course_and_more	2025-08-30 21:30:58.939867+02
54	handbook	0024_alter_coursesperdegree_course_and_more	2025-08-30 21:34:29.784025+02
55	handbook	0025_alter_degreecoursegroup_degree_and_more	2025-08-30 21:40:56.701502+02
56	handbook	0026_rename_group_id_degreeparentcoursegroup_parent_group_id_and_more	2025-08-30 21:52:03.988328+02
57	handbook	0027_alter_degree_department_alter_degree_program	2025-08-30 22:32:58.794559+02
58	handbook	0028_alter_major_department_alter_major_program	2025-08-30 22:39:46.978906+02
59	handbook	0029_alter_department_faculty	2025-08-30 22:57:03.640656+02
60	handbook	0030_alter_faculty_faculty_code	2025-08-30 23:03:35.435621+02
61	advising	0002_alter_faq_options_alter_faqsection_options_and_more	2025-08-30 23:12:33.993638+02
62	advising	0003_faq_section	2025-08-30 23:14:29.795647+02
63	advising	0002_faq_temp	2025-08-30 23:29:47.011494+02
64	advising	0003_faqsection_section_id_alter_faq_temp	2025-08-30 23:32:56.434453+02
65	advising	0004_remove_faq_section	2025-08-30 23:41:03.783249+02
66	advising	0002_alter_glossary_definition_alter_glossary_term_and_more	2025-08-31 00:06:51.347788+02
\.


--
-- Data for Name: django_session; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.django_session (session_key, session_data, expire_date) FROM stdin;
8cspc33w6sfl3q962kif9sfsxrdnekkb	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1uaZkJ:faM3IaDO5kHG7jLKA9thVH3M39w4lujoTShwQ06zsL8	2025-07-26 14:54:27.162547+02
z1pg105ula8h2ywkwxt23xehqndsb36c	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1uawU0:jbYgce3SCtNDI4UQH29SNqaC-LeFNUD7by8vNFX2_rA	2025-07-27 15:11:08.815104+02
hequ5gtwvih859xcqfv6fwnlf9x3l0aq	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1ufkqn:mGR9k7h93EZuj_6VfPFqc7Uz_1KDAdoPpjvfSBbNQkw	2025-08-09 21:46:33.131152+02
bkt8d7qou273zvgjfpgzlklll1txelef	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1ulU2Y:qHJuZEAEtnV1miyW7Kbf9_R9u_4clGp6oHLk0G2e3T8	2025-08-25 17:02:22.625067+02
a7sgx93rmt0ar57rny1wcjvzuepynnp2	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1ulvhm:TD0SmJwLMzWiGhyvZDQSudpXFHhj-UxO80x_yvYd1nY	2025-08-26 22:34:46.38367+02
4jjnsz0wtlfyv7v3341ss35nm01rz7ei	.eJxVjDsOwjAQBe_iGlleNv5R0nMGa22vcQA5UpxUiLuTSCmgnZn33iLQutSwdp7DmMVFgDj9skjpyW0X-UHtPsk0tWUeo9wTedgub1Pm1_Vo_w4q9bqtjU8Qcyns0BtENqoUBD04T0ieyeozRGsB3MZcVhxtQVSgchyAtBKfL9wHN0I:1umWs2:jVpJW9wmxtlbluuJlh_8mm-lr61n-nK8yGROENGk9sI	2025-08-28 14:15:50.374853+02
8fd15rsbx2ru99cn6xbgvb3lwye69w6b	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1uoKlR:u_YNekw09hjvISrsxcEqHkLDr0GUvdqwgxWlIOcxK2s	2025-09-02 13:44:29.336779+02
kpv7202m41kk4gbab6s3rylwrn8k5p65	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1up392:Nx5HR6SYHapF9Wf0C0KDa8yZtYdXMt4Agd00H5f-loc	2025-09-04 13:07:48.702847+02
fp3xzyjpxd1kr1ygfhl03k6h3wlvt5uz	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1up47M:LEIPy1b_Lhwt7uZVRXTOVyLkxE_vNEfOfoBBkSiNYmk	2025-09-04 14:10:08.810007+02
e04u1oxgayax4z5u5u3m55w1c50yzp8v	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1upAM3:gd_iCYj_f7vVgcZe4Ne2k4thNvxsA_wk8KTa7Bw7pKo	2025-09-04 20:49:43.760802+02
g70wqk9m2t0r0bxfwxgohxom7seesaaq	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1upZon:AOGpdL4zdK7gLbSJaoQ9HelE-X7LcqHhHGxBFVAf6Hs	2025-09-06 00:01:05.043842+02
jlfcegt3d3boa36u7vt37ijvg5et6hej	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1upc5Q:8h2MymmkDEBnKkiCpQWdtzF-4sxVl6APzJsg5ylKVsk	2025-09-06 02:26:24.41943+02
hlyxw351upahy5pi660igi1wpipjefc8	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1uplyv:aE9w9APjTmgBlfIR36j5Vsr7hqNBhpvyCwGfPZUuRJo	2025-09-06 13:00:21.704609+02
3bt16i8ol3fdghqk5h9uohcch727xrsb	.eJxVjMsOwiAQRf-FtSEtb1y69xvIwDBSNZCUdmX8dyXpQrf3nHNfLMC-lbD3vIYF2ZnN7PS7RUiPXAfAO9Rb46nVbV0iHwo_aOfXhvl5Ody_gwK9jFpLY6MWpIWnOHuyagJtDCAK6w0JqZNzMpFzCt3X9crFScSsLFiFxN4fzrY3aw:1usJWo:oMFXv6W0YOxPbvAUpujkuuiell2Pr7TyJbg2TWjMHm4	2025-09-13 13:13:50.987277+02
\.


--
-- Data for Name: elective; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.elective (elective_id, program_id, course_id, year, notes) FROM stdin;
16	CB001	BUS1004F	1	\N
125	CB001	BUS2023S	2	May not be taken with BUS3039
126	CB001	BUS2024F	2	\N
127	CB001	CML2001F	2	\N
128	CB001	CSC2001F	2	\N
129	CB001	CSC2002S	2	\N
130	CB001	ECO2003F	2	\N
131	CB001	ECO2004S	2	\N
132	CB001	ECO2007S	2	\N
133	CB001	ECO2008S	2	\N
134	CB001	EGS2013F	2	\N
135	CB001	INF2004F	2	\N
136	CB001	INF2009F	2	\N
137	CB001	INF2010S	2	\N
138	CB001	INF2011S	2	\N
139	CB001	PHI2012F	2	\N
140	CB001	PHI2037F	2	\N
141	CB001	PHI2042F	2	\N
142	CB001	PHI2044F	2	\N
143	CB001	PHI2016S	2	\N
144	CB001	PHI2040S	2	\N
145	CB001	PHI2041S	2	\N
146	CB001	POL2038F	2	\N
147	CB001	POL2002S	2	\N
148	CB001	POL2039F	2	\N
149	CB001	PSY2013F	2	\N
150	CB001	PSY2014S	2	\N
151	CB001	PSY2015F	2	\N
152	CB001	PVL1003W	2	\N
153	CB001	PVL1008H	2	\N
154	CB001	PVL1004F	2	\N
155	CB001	STA2020F	2	\N
156	CB001	STA2020S	2	\N
157	CB001	STA2030S	2	\N
158	CB001	BUS1004F	1	\N
159	CB001	BUS1007S	1	\N
160	CB001	CSC1016S	1	\N
161	CB001	EGS1007S	1	\N
162	CB001	GEO1009F	1	\N
163	CB001	INF1003F	1	\N
164	CB001	MAM1012S	1	\N
165	CB001	PHI1024F	1	\N
166	CB001	PHI1025F	1	Not allowed if BUS1036F/S has been completed
167	CB001	PHI1010S	1	\N
168	CB001	POL1004F	1	\N
169	CB001	POL1005S	1	\N
170	CB001	PSY1004F	1	Only with permission from the HOD
171	CB001	PSY1005S	1	Only with permission from the HOD
172	CB001	BUS3041F	3	\N
173	CB001	BUS3003F	3	\N
174	CB001	BUS3008W	3	\N
175	CB001	BUS3038S	3	\N
176	CB001	BUS3043S	3	\N
177	CB001	BUS3004S	3	\N
178	CB001	CSC3002F	3	\N
179	CB001	CSC3003S	3	\N
180	CB001	ECO3024F	3	\N
181	CB001	ECO3020F	3	\N
182	CB001	ECO3009F	3	\N
183	CB001	ECO3016F	3	\N
184	CB001	ECO3021S	3	\N
185	CB001	ECO3022S	3	\N
186	CB001	ECO3023S	3	\N
187	CB001	ECO3025S	3	\N
188	CB001	EGS3012S	3	\N
189	CB001	EGS3023F	3	\N
190	CB001	EGS3021F	3	\N
191	CB001	EGS3022S	3	\N
192	CB001	FTX3044F	3	\N
193	CB001	FTX3045S	3	\N
194	CB001	INF3014F	3	\N
195	CB001	INF3003W	3	\N
196	CB001	INF3012S	3	\N
197	CB001	PBL2000W	3	\N
198	CB001	PHI3023F	3	\N
199	CB001	PHI3024S	3	\N
200	CB001	POL3030F	3	\N
201	CB001	POL3029S	3	\N
202	CB001	POL3046S	3	\N
203	CB001	PSY3005F	3	\N
204	CB001	PSY3011S	3	\N
205	CB001	PSY3007S	3	\N
206	CB001	PSY3010S	3	\N
207	CB001	PVL2002H	3	\N
208	CB001	PVL2003H	3	\N
209	CB001	STA3022F	3	\N
210	CB001	STA3030F	3	\N
211	CB001	STA3036S	3	\N
\.


--
-- Data for Name: faculty; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.faculty (faculty_name, faculty_code, colour, icon, faculty_id) FROM stdin;
Law	LAW	#0000FF	\N	1
Health Sciences	MED	#0000FF	\N	2
Engineering & the Built Environment	EBE	#0000FF	\N	3
Humanities	HUM	#0000FF	\N	4
Science	SCI	#0000FF	\N	5
Commerce	COM	#0000FF	\N	6
\.


--
-- Data for Name: faq; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.faq (faq_id, question, answer, section_id) FROM stdin;
7	How do I contact support?	You can contact support via the Contact Us page or by emailing support@myadvisor.com.	1
4	Can I save multiple plans?	Yes, you can create and save multiple degree plans for different scenarios.	4
6	How do I know if a course is offered this year?	Course availability is updated annually. Check the course info section for the latest details.	3
5	Where can I find course prerequisites?	Course prerequisites are listed on each course's information page.	3
3	How do I plan my degree?	Use the Degree Planning tool to select your courses and visualize your academic path.	4
2	Is MyAdvisor free to use?	Yes, MyAdvisor is free for all students.	2
1	What is MyAdvisor?	MyAdvisor is a platform to help students plan their degrees, explore handbooks, and get answers to common questions.	2
8	Where can I report a bug?	Please use the feedback form on the website to report bugs or issues.	1
\.


--
-- Data for Name: faq_section; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.faq_section (section_name, section_id) FROM stdin;
Support	1
General	2
Course Info	3
Degree Planning	4
\.


--
-- Data for Name: glossary; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.glossary (term_id, term, definition) FROM stdin;
1	Faculty	A division within the university that groups together related academic departments and programs.
2	Department	An academic unit within a faculty that focuses on a specific field of study.
3	Course	A unit of teaching that typically lasts one semester and is led by one or more instructors.
4	Major	The primary area of study chosen by a student for their degree.
5	Credits	A measure of the workload of a course, often used to determine degree requirements.
6	NQF Level	The National Qualifications Framework level indicating the complexity and depth of a course or qualification.
7	Prerequisite	A requirement that must be fulfilled before enrolling in a particular course.
8	Semester	A division of the academic year during which courses are taught and assessed.
9	Degree	An academic qualification awarded by the university after completing the required program of study.
10	Handbook	The official document outlining degree rules, course information, and university policies.
11	Advisor	A staff member who provides academic guidance and support to students regarding their studies.
12	Registration	The process by which students officially enroll in courses for a semester.
13	Transcript	The official record of a student’s academic performance, including courses taken and grades received.
14	Elective	A course chosen by the student that is not compulsory for their program but counts towards degree requirements.
\.


--
-- Data for Name: major; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.major (major_code, major_name, notes, department_id, program_id) FROM stdin;
SB001MAM01	Applied Mathematics	Students who major in Applied Mathematics and wish to progress to Applied Mathematics Honours are strongly recommended to complete the project course MAM3055Z: Project in Applied Mathematics	MAM	SB001
SB001STA01	Applied Statistics	Students who major in Applied Statistics and wish to progress to Statistics Honours must complete one semester of Computer Science 1	STA	SB001
SB001AGE01	Archaeology	\N	AGE	SB001
SB001CSC08	Artificial Intelligence	\N	CSC	SB001
SB001AST02	Astrophysics	\N	AST	SB001
SB001MCB01	Biochemistry	This major has limits on the number of students accepted into second year level courses	MCB	SB001
SB001BIO12	Biology	Students who major in Biology and wish to progress to Biological Sciences or Marine Biology Honours must complete STA2007	BIO	SB001
SB001CSC02	Business Computing	Must be taken concurrently with a Computer Science major	CSC	SB001
SB001CEM01	Chemistry	\N	CEM	SB001
SB001CSC03	Computer Engineering	Must be taken concurrently with a Computer Science major	CSC	SB001
SB001CSC05	Computer Science	\N	CSC	SB001
SB001EGS02	Environmental & Geographical Science	\N	EGS	SB001
SB001MCB04	Genetics	This major has limits on the number of students accepted into second year level courses	MCB	SB001
SB001GEO02	Geology	This major has limits on the number of students accepted into second year level courses	GEO	SB001
SB001HUB17	Human Anatomy & Physiology	This major has limits on the number of students accepted into second year level courses	HUB	SB001
SB001BIO05	Marine Biology	Students who major in Marine Biology and wish to progress to Biology or Marine Biology Honours must complete STA2007S	BIO	SB001
SB001STA02	Mathematical Statistics	Students who major in Mathematical Statistics and wish to progress to Statistics Honours must complete one semester of Computer Science 1	STA	SB001
SB001MAM02	Mathematics	Students who major in Mathematics and wish to progress to Mathematics Honours are strongly recommended to complete the project course MAM3006Z: Project in Mathematics	MAM	SB001
SB001SEA03	Ocean & Atmosphere Science	Students who major in Ocean & Atmosphere Science and wish to progress to Ocean & Atmosphere Science Honours are strongly recommended to complete both STA2007F/S/H and CSC1015F/S	SEA	SB001
SB001PHY01	Physics	\N	PHY	SB001
SB001BIO13	Quantitative Biology	\N	BIO	SB001
SB001STA13	Statistics & Data Science	Students will need to choose between the Mathematical and Applied Statistics streams. Only one of the STA01, STA02, STA13 majors can be taken towards the BSc degree	STA	SB001
SB001TST01	Test Major		TST	SB001
\.


--
-- Data for Name: major_course_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.major_course_group (course_group_id, major_id, required_count, description, parent_group_id) FROM stdin;
1	SB001MAM01	2	Missing Description	\N
2	SB001MAM01	1	Missing Description2	\N
3	SB001MAM01	3	Missing Description3	\N
4	SB001STA01	1	Missing Description	\N
5	SB001STA01	1	Missing Description2	\N
6	SB001STA01	1	Missing Description3	\N
7	SB001CSC05	1	Missing Description	\N
8	SB001CSC05	1	Missing Description2	\N
9	SB001CSC05	1	Missing Description3	\N
10	SB001CSC05	1	Missing Description4	\N
11	SB001TST01	2	MAM1004F and MAM1008S	1
12	SB001TST01	2	MAM1031F and MAM1032S	1
13	SB001TST01	1	Choose 1 between CSC1015F and CSC1015S	\N
\.


--
-- Data for Name: major_parent_course_group; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.major_parent_course_group (parent_group_id, major_id, required_count, description) FROM stdin;
1	SB001TST01	1	Choose between both MAM1004F and MAM1008S or both MAM1031F and MAM1032S
\.


--
-- Data for Name: majors_per_program; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.majors_per_program (major_program_id, program_code, major_code) FROM stdin;
\.


--
-- Data for Name: program; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.program (program_name, program_abbreviation, program_code, saqa_id, minimum_duration_years, nqf_level, qualification_id, notes, faculty_id) FROM stdin;
Advanced Diploma in Management Development	AdvDip (Management Development)	CU021	101556	1	7	3		6
Advanced Diploma in Actuarial Science	AdvDip (Actuarial Science)	CU020	99629	1	7	3		6
Advanced Diploma in Accounting	AdvDip (Accounting)	CU017	94786	1	7	3		6
Bachelor of Business Science in Actuarial Science Academic Development: Augmented	BBusSc_Aug (Actuarial Science)	CB025		4	7	4	Academic Development: Augmented	6
Bachelor of Business Science Academic Development: Augmented	BBusSc_Aug	CB024		4	7	4	Academic Development: Augmented	6
Bachelor of Business Science in Actuarial Science Academic Development: Extended	BBusSc_Ext (Actuarial Science)	CB018		5	7	4	Academic Development: Extended	6
Bachelor of Business Science Academic Development: Extended	BBusSc_Ext	CB015		5	7	4	Academic Development: Extended	6
Bachelor of Business Science	BBusSc	CB004	116396	4	7	4		6
Bachelor of Business Science in Actuarial Science	BBusSc (Actuarial Science)	CB003	4411	4	7	4		6
Bachelor of Commerce in Actuarial Science	BCom (Actuarial Science)	CB019	\N	3	7	4	\N	6
Bachelor of Commerce in Actuarial Science Academic Development: Augmented	BCom_Aug (Actuarial Science)	CB026	\N	3	7	4	Academic Development: Augmented	6
Bachelor of Commerce Academic Development: Extended	BCom_Ext	CB011	\N	4	7	4	Academic Development: Extended	6
Bachelor of Commerce in Actuarial Science Academic Development: Extended	BCom_Ext (Actuarial Science)	CB020	\N	4	7	4	Academic Development: Extended	6
Bachelor of Commerce Academic Development: Augmented	BCom_Aug	CB023		3	7	4	Notes on core courses and electives:\r\nDepending on the individual student’s interest and abilities, students can follow one or more specialised disciplines within the programme structure. The list of pre-approved electives available to students appears below; however, students wishing to take electives that do not appear on the list below should request permission to take these courses from the programme convener.\r\nAll normal course prerequisite rules apply.\r\nAll normal course equivalents apply as per the Commerce Faculty undergraduate handbook\r\nStudents wishing to be eligible for Honours in a particular discipline need to ensure that they register for the appropriate courses in that discipline.\r\nThe guide below assists students in choosing electives if they are interested in eligibility to apply for Honours in a particular discipline commonly taken by students on the degree programme (note that students must achieve the required marks as per the entrance requirements described in the postgraduate handbook):\r\nEconomics:\r\nECO2007S OR ECO2008S, plus ECO3020F, ECO3021S plus another ECO course at 3rd year level\r\nFinance and Tax:\r\nMAM1012S, FTX2024F/S, STA2020F/S, FTX3044F, FTX3045S\r\nInformation Systems:\r\nBUS2033S, INF1003F, INF2008F, INF2009F, INF2010S and INF2011S plus\r\nINF3003W, INF3014F and INF3012S OR INF3011F, INF3012S and INF3014F\r\nMarketing:\r\nMAM1012S, BUS2010F/S, STA2020F/S, BUS3041F, BUS3043S, BUS3008W, STA3022F\r\nOrganisational Psychology:\r\nPSY1004F, PSY1005S, BUS1007S, BUS2024F, BUS2023S, BUS3003F, BUS3004S\r\nStatistical Sciences:\r\nMAM1012S, STA2020F and STA2030S, STA3030F, STA3036S (STA3022F optional)\r\nAdditional information:\r\nBUS3039 is not available to students who wish to pursue an Honours degree in Organisational Psychology. These students must take an alternative course at 3rd year level. Students may not register for both BUS2023S and BUS3039 within the degree programme.\r\nPlaces on the Law Courses in the 2nd and 3rd year are limited. To be eligible for consideration for a possible (but not guaranteed) place, students wishing to apply to take Law courses in 2nd and 3rd year need to fulfil all the requirements as set out in Promotion Rule FBA16.\r\nStudents may not register for PHI1025F as an elective if they have already completed BUS1036F/S\r\n1st year level electives:\r\nBUS1004F Introduction to Strategy and Marketing\r\nBUS1007S Introduction to Organisational Psychology\r\nCSC1016S Computer Science 1016\r\nEGS1007S Human and Physical Systems\r\nGEO1009F Introduction to Earth and Environmental Sciences\r\nINF1003F Commercial Programming\r\nMAM1012S Mathematics 1012\r\nPHI1024F Introduction to Philosophy\r\nPHI1026F Critical Foundations\r\nPHI1010S Ethics\r\nPOL1004F Introduction to Politics\r\nPOL1005S Introduction to Politics B\r\nPSY1004F Introduction to Psychology (Part 1) (only with permission from the HOD)\r\nPSY1005S Introduction to Psychology (Part 2) (only with permission from the HOD)\r\n2nd year level electives:\r\nBUS2023S Organisational Behaviour (may not be taken with BUS3039)\r\nBUS2024F Psychology of Human Resource Management\r\nCML2001F Company Law\r\nCSC2001F Computer Science 2001\r\nCSC2002S Computer Science 2002\r\nECO2003F Microeconomics 2\r\nECO2004S Macroeconomics 2\r\nECO2007S Co-operation and Competition\r\nECO2008S Development Economics\r\nEGS2013F The Physical Environment\r\nEGS2014S Contemporary Urban Challenges\r\nEND1019L Social Infrastructures: Engaging with Community for Change\r\nINF2004F Information Technology in Business\r\nINF2009F Systems Analysis\r\nINF2010S IT Architecture\r\nINF2011S Systems Design & Development\r\nPHI2012F Philosophy of Psychology and Mind\r\nPHI2037F Applied Ethics\r\nPHI2042F Political Philosophy\r\nPHI2044F Philosophy of Mathematics\r\nPHI2016S Philosophy of Art and Literature\r\nPHI2040S Philosophy of Science\r\nPHI2041S Great Philosophers\r\nPOL2038F Comparative Politics\r\nPOL2002S Political Theory\r\nPOL2036F Introductory Political Economy\r\nPOL2039F The Politics of International Economic Relations\r\nPSY2013F Social and Developmental Psychology\r\nPSY2014S Cognitive Neuroscience and Abnormal Psychology\r\nPSY2015F Research Methods I\r\nPSY2003S Social Psychology and Intergroup Relations\r\nPSY2010S Cognition and Neuroscience\r\nPVL1003W Foundations of South African Law\r\nPVL1008H Law of Persons and Family (formerly PVL1008S)\r\nPVL1004F South African Private Law: System and Context\r\nSTA2020F/S Business Statistics\r\nSTA2030S Theory of Statistics\r\n3rd year level electives:\r\nBUS3041F Marketing IIA\r\nBUS3003F Research Design in Organisational Psychology\r\nBUS3008W Research in Marketing\r\nBUS3038S Introduction to Project Management\r\nBUS3043S Marketing IIB\r\nBUS3004S Research Data Analysis in Organisational Psychology\r\nCSC3002F Computer Science 3002\r\nCSC3003S Computer Science 3003\r\nECO3024F International Trade and Finance\r\nECO3020F Advanced Macro & Microeconomics\r\nECO3009F Natural Resource Economics\r\nECO3016F History of Economic Thought\r\nECO3021S Quantitative Methods in Economics\r\nECO3022S Advanced Labour Economics\r\nECO3023S Public Sector Economics\r\nECO3025S Applied International Trade Bargaining\r\nEGS3012S Atmospheric Science\r\nEGS3023F Anthropocene Environments in Perspective\r\nEGS3021F Sustainability and the Environment\r\nEGS3022S Geographic Thought\r\nFTX3044F Investment Management A\r\nFTX3045S Investment Management B\r\nINF3014F Electronic Commerce\r\nINF3003W Systems Development Project I\r\nINF3012S BPM & Enterprise Systems\r\nPBL2000W Constitutional Law\r\nPHI3023F Logic and Language\r\nPHI3024S Metaphysics and Epistemology\r\nPOL3030F Conflict in World Politics\r\nPOL3013S SA Political Thought\r\nPOL3029S Third World Politics\r\nPOL3046S South African Political Thought\r\nPSY3005F Critical Psychology\r\nPSY3008F Health Psychology\r\nPSY3011S Clinical Psychology II\r\nPSY3007S Research Methods in Psychology II\r\nPSY3010S Introduction to Clinical Neuropsychology\r\nPVL2002H Law of Property\r\nPVL2003H Law of Succession\r\nSTA3022F Research and Survey Statistics\r\nSTA3030F Inferential Statistics\r\nSTA3036S Operational Research Techniques	6
Test Program	TProg	TS001		3	7	4		6
Bachelor of Commerce	BCom	CB001	116431	3	7	4	Notes on core courses and electives:\r\nDepending on the individual student’s interest and abilities, students can follow one or\r\nmore specialised disciplines within the programme structure. The list of pre-approved\r\nelectives available to students appears below, however students wishing to take electives\r\nthat do not appear on the list below should request permission to take these courses from\r\nthe programme convener.\r\nAll normal course prerequisite rules apply.\r\nAll normal course equivalents apply as per the Commerce Faculty undergraduate handbook\r\nStudents wishing to be eligible for Honours in a particular discipline need to ensure that\r\nthey register for the appropriate courses in that discipline.\r\nThe guide below assists students in choosing electives if they are interested in eligibility to\r\napply for Honours in a particular discipline commonly taken by students on the degree\r\nprogramme (note that students must achieve the required marks as per the entrance\r\nrequirements described in the postgraduate handbook):\r\nEconomics:\r\nECO2007S OR ECO2008S, plus ECO3020F, ECO3021S plus another ECO course at 3rd\r\nyear level\r\nFinance and Tax:\r\nMAM1012S, FTX2024F/S, STA2020F/S, FTX3044F, FTX3045S\r\nInformation Systems:\r\nBUS2033S, INF1003F INF2008F, INF2009F, INF2010S and INF2011S plus\r\nINF3003W, INF3014F and INF3012S OR INF3011F, INF3012S and INF3014F\r\nMarketing:\r\nMAM1012S, BUS2010F/S, STA2020F/S, BUS3041F, BUS3043S, BUS3008W,\r\nSTA3022F\r\nOrganisational Psychology:\r\nPSY1004F, PSY1005S, BUS1007S, BUS2024F, BUS2023S, BUS3003F, BUS3004S\r\nStatistical Sciences:\r\nMAM1012S, STA2020F and STA2030S, STA3030F, STA3036S (STA3022F optional)\r\nAdditional information:\r\nBUS3039 is not available to students who wish to pursue an Honours degree in\r\nOrganisational Psychology. These students must take an alternative course at 3rd year\r\nlevel. Students may not register for both BUS2023S and BUS3039 within the degree\r\nprogramme.\r\nPlaces on the Law Courses in the 2nd and third year are limited. To be eligible for\r\nconsideration for a possible (but not guaranteed) place, students wishing to apply to take\r\nLaw courses in 2nd and 3rd year need to fulfil all the requirements as set out in Promotion\r\nRule FBA16.\r\nStudents may not register for PHI1025F as an elective if they have already completed\r\nBUS1036F/S	6
Bachelor of Science Extended Degree Programme	BSc EDP	SB016		4	7	4		5
Bachelor of Science	BSc	SB001	117697	3	7	4		5
\.


--
-- Data for Name: qualification; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.qualification (qualification_id, qualification_name) FROM stdin;
1	Higher Certificate
2	Diploma
3	Advanced Diploma
4	Bachelor's degree
5	Postgraduate Diploma
6	Honour's degree
7	Master's degree
8	Doctoral degree
\.


--
-- Data for Name: semester; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.semester (semester_letter, semester_name) FROM stdin;
F	First
S	Second
P	Summer Term
L	Winter Term
Z	Non-Standard
X	Non-Standard
H	Whole Year
W	Whole Year
\.


--
-- Data for Name: student; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.student (student_id, username, first_name, last_name, email, password, date_joined, is_active, is_staff, is_superuser, last_login) FROM stdin;
4	MitchellFlanegan	Mitchell	Flanegan	mitchell@flanegan.com	pbkdf2_sha256$1000000$xcQ2wGImTgpgvaoScwms9I$iVikPz7ItktMBixdyzg4JFQNXYwq/I9R8p7EJ+D+amY=	2025-08-23 00:54:15.972759+02	t	f	f	\N
11	JoeSoap	\N	\N	email@email.com	pbkdf2_sha256$1000000$M1OukYyrsxQoIeJUxhAq69$szbA7m92UaIRl4BEOG1GhL+AfoTDklB0lMcGKKkQuB8=	2025-08-23 02:11:21.710999+02	t	f	f	\N
5	DylanHoward				pbkdf2_sha256$1000000$GdOxulKiAxw2fmoCNhbKKs$GSBj33HmWTNyMBPSxP0x51OUKwCcA9SekHnxTcjXzlo=	2025-08-23 00:58:33.166751+02	t	f	f	\N
12	Test123	\N	\N	test@gmail.com	pbkdf2_sha256$1000000$ypqI50TqMgXwqFYzhheZq7$SoPitNvgHjwomEj86FuaT0oj8FsFAo/UTb0VO45N/F4=	2025-08-23 12:58:47.318124+02	t	f	f	\N
2	Ethan Allies	Ethan	Allies	ethan@allies.com	pbkdf2_sha256$1000000$1AcsT5EbnT9rvKlq4gZctQ$8/AyO0PcJEvZEeuUgjnwdcmqgCqAS/gf+3CQgFZcb60=	2025-08-22 22:53:19.597707+02	t	f	f	\N
13	ali	\N	\N	ali@gmail.com	pbkdf2_sha256$1000000$BLkVkqd6SughwSu8bzskpn$hRJwEyzK15KZcBskqF6y4L5SYaDIMQI5Vciav8b5/LA=	2025-08-28 12:32:50.310505+02	t	f	f	\N
14	ethanw	\N	\N	ethan@gmail.com	pbkdf2_sha256$1000000$InSSgfS5ymfXfkMYdf3APp$BEBKIcCh4opkP1VbbBseaebY7AJl8qP+GOri6Ls1yU4=	2025-08-28 14:49:23.680126+02	t	f	f	\N
15	ThisBotSUcks	\N	\N	matthewrothenburg1@gmail.co	pbkdf2_sha256$1000000$OjqclJPQeO9dRDrG37kvcg$kXYth+b2ohifvbCku/HRJz9bxJI4LuaoVIERQAUXfuM=	2025-08-28 17:49:53.521193+02	t	f	f	\N
16	Razan	\N	\N	razan@gmail.com	pbkdf2_sha256$1000000$rBMTux7GKwwyXccfGB8HZM$mr1zvstIkTIM+FmJF2BTUMBWFuYz37smYk+MIcl+RGI=	2025-08-29 10:33:57.115856+02	t	f	f	\N
17	TylerM	\N	\N	tyler@gmail.com	pbkdf2_sha256$1000000$JobywDZA1WzbtYK3A2ilmG$S8AgkGaAIBom33ocXD61QaDk/P1wNwdgTyLy+MD8aVs=	2025-08-29 13:43:38.223224+02	t	f	f	\N
18	Joel	\N	\N	j@gmail.com	pbkdf2_sha256$1000000$lc6F1C55qRWmUnpQbddu73$0WpA7lL1kT3VHjgxA1VUwne1pGeDu3IE1olpFk2knKU=	2025-08-29 15:40:52.308935+02	t	f	f	\N
\.


--
-- Data for Name: student_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.student_groups (id, student_id, group_id) FROM stdin;
\.


--
-- Data for Name: student_user_permissions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.student_user_permissions (id, student_id, permission_id) FROM stdin;
\.


--
-- Name: advisor_advisor_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_advisor_id_seq', 1, false);


--
-- Name: advisor_degree_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_degree_id_seq', 7, true);


--
-- Name: advisor_department_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_department_id_seq', 18, true);


--
-- Name: advisor_faculty_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_faculty_id_seq', 20, true);


--
-- Name: advisor_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_groups_id_seq', 1, false);


--
-- Name: advisor_major_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_major_id_seq', 3, true);


--
-- Name: advisor_program_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_program_id_seq', 14, true);


--
-- Name: advisor_question_question_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_question_question_id_seq', 47, true);


--
-- Name: advisor_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.advisor_user_permissions_id_seq', 1, false);


--
-- Name: auth_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_group_id_seq', 1, false);


--
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_group_permissions_id_seq', 1, false);


--
-- Name: auth_permission_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_permission_id_seq', 212, true);


--
-- Name: auth_user_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_user_groups_id_seq', 1, false);


--
-- Name: auth_user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_user_id_seq', 2, true);


--
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.auth_user_user_permissions_id_seq', 1, false);


--
-- Name: course_groups_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.course_groups_group_id_seq', 67, true);


--
-- Name: courses_per_degree_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.courses_per_degree_id_seq', 891, true);


--
-- Name: courses_per_major_course_major_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.courses_per_major_course_major_id_seq', 119, true);


--
-- Name: degree_parent_course_group_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.degree_parent_course_group_group_id_seq', 6, true);


--
-- Name: django_admin_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.django_admin_log_id_seq', 575, true);


--
-- Name: django_content_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.django_content_type_id_seq', 59, true);


--
-- Name: django_migrations_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.django_migrations_id_seq', 66, true);


--
-- Name: electives_elective_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.electives_elective_id_seq', 211, true);


--
-- Name: faculty_faculty_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.faculty_faculty_id_seq', 8, true);


--
-- Name: faq_faq_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.faq_faq_id_seq', 11, true);


--
-- Name: faq_section_section_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.faq_section_section_id_seq', 4, true);


--
-- Name: glossary_word_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.glossary_word_id_seq', 14, true);


--
-- Name: major_course_group_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.major_course_group_group_id_seq', 13, true);


--
-- Name: major_parent_course_group_group_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.major_parent_course_group_group_id_seq', 1, true);


--
-- Name: major_program_link_major_program_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.major_program_link_major_program_id_seq', 1, false);


--
-- Name: qualification_qualification_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.qualification_qualification_id_seq', 8, true);


--
-- Name: student_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.student_groups_id_seq', 1, false);


--
-- Name: student_student_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.student_student_id_seq', 18, true);


--
-- Name: student_user_permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.student_user_permissions_id_seq', 1, false);


--
-- Name: advisor_degrees advisor_degree_advisor_id_degree_id_fdf287bb_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_degrees
    ADD CONSTRAINT advisor_degree_advisor_id_degree_id_fdf287bb_uniq UNIQUE (advisor_id, degree_id);


--
-- Name: advisor_degrees advisor_degree_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_degrees
    ADD CONSTRAINT advisor_degree_pkey PRIMARY KEY (id);


--
-- Name: advisor_departments advisor_department_advisor_id_department_id_8559e1da_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_departments
    ADD CONSTRAINT advisor_department_advisor_id_department_id_8559e1da_uniq UNIQUE (advisor_id, department_id);


--
-- Name: advisor_departments advisor_department_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_departments
    ADD CONSTRAINT advisor_department_pkey PRIMARY KEY (id);


--
-- Name: advisor advisor_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor
    ADD CONSTRAINT advisor_email_key UNIQUE (email);


--
-- Name: advisor_faculties advisor_faculty_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_faculties
    ADD CONSTRAINT advisor_faculty_pkey PRIMARY KEY (id);


--
-- Name: advisor_groups advisor_groups_advisor_id_group_id_0ae8838f_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_groups
    ADD CONSTRAINT advisor_groups_advisor_id_group_id_0ae8838f_uniq UNIQUE (advisor_id, group_id);


--
-- Name: advisor_groups advisor_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_groups
    ADD CONSTRAINT advisor_groups_pkey PRIMARY KEY (id);


--
-- Name: advisor_majors advisor_major_advisor_id_major_id_b89fa580_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_majors
    ADD CONSTRAINT advisor_major_advisor_id_major_id_b89fa580_uniq UNIQUE (advisor_id, major_id);


--
-- Name: advisor_majors advisor_major_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_majors
    ADD CONSTRAINT advisor_major_pkey PRIMARY KEY (id);


--
-- Name: advisor advisor_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor
    ADD CONSTRAINT advisor_pkey PRIMARY KEY (advisor_id);


--
-- Name: advisor_programs advisor_program_advisor_id_program_id_dd864611_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_programs
    ADD CONSTRAINT advisor_program_advisor_id_program_id_dd864611_uniq UNIQUE (advisor_id, program_id);


--
-- Name: advisor_programs advisor_program_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_programs
    ADD CONSTRAINT advisor_program_pkey PRIMARY KEY (id);


--
-- Name: advisor_question advisor_question_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_question
    ADD CONSTRAINT advisor_question_pkey PRIMARY KEY (question_id);


--
-- Name: advisor_user_permissions advisor_user_permissions_advisor_id_permission_id_704641c4_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_user_permissions
    ADD CONSTRAINT advisor_user_permissions_advisor_id_permission_id_704641c4_uniq UNIQUE (advisor_id, permission_id);


--
-- Name: advisor_user_permissions advisor_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_user_permissions
    ADD CONSTRAINT advisor_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: advisor advisor_username_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor
    ADD CONSTRAINT advisor_username_key UNIQUE (username);


--
-- Name: auth_group auth_group_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_name_key UNIQUE (name);


--
-- Name: auth_group_permissions auth_group_permissions_group_id_permission_id_0cd325b0_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_permission_id_0cd325b0_uniq UNIQUE (group_id, permission_id);


--
-- Name: auth_group_permissions auth_group_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_group auth_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group
    ADD CONSTRAINT auth_group_pkey PRIMARY KEY (id);


--
-- Name: auth_permission auth_permission_content_type_id_codename_01ab375a_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_codename_01ab375a_uniq UNIQUE (content_type_id, codename);


--
-- Name: auth_permission auth_permission_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups auth_user_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_pkey PRIMARY KEY (id);


--
-- Name: auth_user_groups auth_user_groups_user_id_group_id_94350c0c_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_group_id_94350c0c_uniq UNIQUE (user_id, group_id);


--
-- Name: auth_user auth_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT auth_user_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions auth_user_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_permission_id_14a6b632_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_permission_id_14a6b632_uniq UNIQUE (user_id, permission_id);


--
-- Name: auth_user auth_user_username_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user
    ADD CONSTRAINT auth_user_username_key UNIQUE (username);


--
-- Name: degree_course_group course_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_course_group
    ADD CONSTRAINT course_group_pkey PRIMARY KEY (course_group_id);


--
-- Name: courses_per_degree courses_per_degree_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree
    ADD CONSTRAINT courses_per_degree_pkey PRIMARY KEY (course_degree_id);


--
-- Name: courses_per_major courses_per_major_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major
    ADD CONSTRAINT courses_per_major_pkey PRIMARY KEY (course_major_id);


--
-- Name: course courses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.course
    ADD CONSTRAINT courses_pkey PRIMARY KEY (course_code);


--
-- Name: degree_parent_course_group degree_parent_course_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_parent_course_group
    ADD CONSTRAINT degree_parent_course_group_pkey PRIMARY KEY (parent_group_id);


--
-- Name: degree degree_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree
    ADD CONSTRAINT degree_pkey PRIMARY KEY (degree_code);


--
-- Name: department departments_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT departments_pkey PRIMARY KEY (department_code);


--
-- Name: django_admin_log django_admin_log_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_pkey PRIMARY KEY (id);


--
-- Name: django_content_type django_content_type_app_label_model_76bd3d3b_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_app_label_model_76bd3d3b_uniq UNIQUE (app_label, model);


--
-- Name: django_content_type django_content_type_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_content_type
    ADD CONSTRAINT django_content_type_pkey PRIMARY KEY (id);


--
-- Name: django_migrations django_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_migrations
    ADD CONSTRAINT django_migrations_pkey PRIMARY KEY (id);


--
-- Name: django_session django_session_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_session
    ADD CONSTRAINT django_session_pkey PRIMARY KEY (session_key);


--
-- Name: elective electives_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.elective
    ADD CONSTRAINT electives_pkey PRIMARY KEY (elective_id);


--
-- Name: faculty faculty_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faculty
    ADD CONSTRAINT faculty_pkey PRIMARY KEY (faculty_id);


--
-- Name: faq faq_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faq
    ADD CONSTRAINT faq_pkey PRIMARY KEY (faq_id);


--
-- Name: faq_section faq_section_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faq_section
    ADD CONSTRAINT faq_section_pkey PRIMARY KEY (section_id);


--
-- Name: glossary glossary_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.glossary
    ADD CONSTRAINT glossary_pkey PRIMARY KEY (term_id);


--
-- Name: glossary glossary_word_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.glossary
    ADD CONSTRAINT glossary_word_key UNIQUE (term);


--
-- Name: major_course_group major_course_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_course_group
    ADD CONSTRAINT major_course_group_pkey PRIMARY KEY (course_group_id);


--
-- Name: major_parent_course_group major_parent_course_group_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_parent_course_group
    ADD CONSTRAINT major_parent_course_group_pkey PRIMARY KEY (parent_group_id);


--
-- Name: major major_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major
    ADD CONSTRAINT major_pkey PRIMARY KEY (major_code);


--
-- Name: program program_program_name_6fd69943_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.program
    ADD CONSTRAINT program_program_name_6fd69943_uniq UNIQUE (program_name);


--
-- Name: program programs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.program
    ADD CONSTRAINT programs_pkey PRIMARY KEY (program_code);


--
-- Name: program programs_program_abbreviation_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.program
    ADD CONSTRAINT programs_program_abbreviation_key UNIQUE (program_abbreviation);


--
-- Name: qualification qualification_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.qualification
    ADD CONSTRAINT qualification_pkey PRIMARY KEY (qualification_id);


--
-- Name: qualification qualification_qualification_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.qualification
    ADD CONSTRAINT qualification_qualification_name_key UNIQUE (qualification_name);


--
-- Name: semester semester_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.semester
    ADD CONSTRAINT semester_pkey PRIMARY KEY (semester_letter);


--
-- Name: student student_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student
    ADD CONSTRAINT student_email_key UNIQUE (email);


--
-- Name: student_groups student_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_groups
    ADD CONSTRAINT student_groups_pkey PRIMARY KEY (id);


--
-- Name: student_groups student_groups_student_id_group_id_81addf69_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_groups
    ADD CONSTRAINT student_groups_student_id_group_id_81addf69_uniq UNIQUE (student_id, group_id);


--
-- Name: student student_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student
    ADD CONSTRAINT student_pkey PRIMARY KEY (student_id);


--
-- Name: student_user_permissions student_user_permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_user_permissions
    ADD CONSTRAINT student_user_permissions_pkey PRIMARY KEY (id);


--
-- Name: student_user_permissions student_user_permissions_student_id_permission_id_7dbf3714_uniq; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_user_permissions
    ADD CONSTRAINT student_user_permissions_student_id_permission_id_7dbf3714_uniq UNIQUE (student_id, permission_id);


--
-- Name: student student_username_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student
    ADD CONSTRAINT student_username_key UNIQUE (username);


--
-- Name: courses_per_degree unique_course_degree; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree
    ADD CONSTRAINT unique_course_degree UNIQUE (degree_id, course_id);


--
-- Name: courses_per_major unique_course_major; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major
    ADD CONSTRAINT unique_course_major UNIQUE (major_id, course_id);


--
-- Name: department unique_department_code; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT unique_department_code UNIQUE (department_code);


--
-- Name: department unique_department_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT unique_department_name UNIQUE (department_name);


--
-- Name: faculty unique_faculty_code; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faculty
    ADD CONSTRAINT unique_faculty_code UNIQUE (faculty_code);


--
-- Name: faculty unique_faculty_name; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faculty
    ADD CONSTRAINT unique_faculty_name UNIQUE (faculty_name);


--
-- Name: advisor_degree_advisor_id_6342830e; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_degree_advisor_id_6342830e ON public.advisor_degrees USING btree (advisor_id);


--
-- Name: advisor_degree_degree_id_ebc414e5; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_degree_degree_id_ebc414e5 ON public.advisor_degrees USING btree (degree_id);


--
-- Name: advisor_degree_degree_id_ebc414e5_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_degree_degree_id_ebc414e5_like ON public.advisor_degrees USING btree (degree_id varchar_pattern_ops);


--
-- Name: advisor_department_advisor_id_7b46c8d5; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_department_advisor_id_7b46c8d5 ON public.advisor_departments USING btree (advisor_id);


--
-- Name: advisor_department_department_id_93140784; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_department_department_id_93140784 ON public.advisor_departments USING btree (department_id);


--
-- Name: advisor_department_department_id_93140784_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_department_department_id_93140784_like ON public.advisor_departments USING btree (department_id varchar_pattern_ops);


--
-- Name: advisor_email_1166d1d5_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_email_1166d1d5_like ON public.advisor USING btree (email varchar_pattern_ops);


--
-- Name: advisor_faculty_advisor_id_3dd2c9cc; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_faculty_advisor_id_3dd2c9cc ON public.advisor_faculties USING btree (advisor_id);


--
-- Name: advisor_groups_advisor_id_6bb318ae; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_groups_advisor_id_6bb318ae ON public.advisor_groups USING btree (advisor_id);


--
-- Name: advisor_groups_group_id_bc03a0a9; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_groups_group_id_bc03a0a9 ON public.advisor_groups USING btree (group_id);


--
-- Name: advisor_major_advisor_id_dddd42a4; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_major_advisor_id_dddd42a4 ON public.advisor_majors USING btree (advisor_id);


--
-- Name: advisor_major_major_id_433ab318; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_major_major_id_433ab318 ON public.advisor_majors USING btree (major_id);


--
-- Name: advisor_major_major_id_433ab318_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_major_major_id_433ab318_like ON public.advisor_majors USING btree (major_id varchar_pattern_ops);


--
-- Name: advisor_program_advisor_id_67d4d348; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_program_advisor_id_67d4d348 ON public.advisor_programs USING btree (advisor_id);


--
-- Name: advisor_program_program_id_296c7438; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_program_program_id_296c7438 ON public.advisor_programs USING btree (program_id);


--
-- Name: advisor_program_program_id_296c7438_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_program_program_id_296c7438_like ON public.advisor_programs USING btree (program_id varchar_pattern_ops);


--
-- Name: advisor_question_advisor_cbf1b882; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_question_advisor_cbf1b882 ON public.advisor_question USING btree (advisor);


--
-- Name: advisor_question_student_be479363; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_question_student_be479363 ON public.advisor_question USING btree (student);


--
-- Name: advisor_user_permissions_advisor_id_055cd99e; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_user_permissions_advisor_id_055cd99e ON public.advisor_user_permissions USING btree (advisor_id);


--
-- Name: advisor_user_permissions_permission_id_f8cd2a9b; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_user_permissions_permission_id_f8cd2a9b ON public.advisor_user_permissions USING btree (permission_id);


--
-- Name: advisor_username_d477ec67_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX advisor_username_d477ec67_like ON public.advisor USING btree (username varchar_pattern_ops);


--
-- Name: auth_group_name_a6ea08ec_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_group_name_a6ea08ec_like ON public.auth_group USING btree (name varchar_pattern_ops);


--
-- Name: auth_group_permissions_group_id_b120cbf9; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_group_permissions_group_id_b120cbf9 ON public.auth_group_permissions USING btree (group_id);


--
-- Name: auth_group_permissions_permission_id_84c5c92e; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_group_permissions_permission_id_84c5c92e ON public.auth_group_permissions USING btree (permission_id);


--
-- Name: auth_permission_content_type_id_2f476e4b; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_permission_content_type_id_2f476e4b ON public.auth_permission USING btree (content_type_id);


--
-- Name: auth_user_groups_group_id_97559544; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_user_groups_group_id_97559544 ON public.auth_user_groups USING btree (group_id);


--
-- Name: auth_user_groups_user_id_6a12ed8b; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_user_groups_user_id_6a12ed8b ON public.auth_user_groups USING btree (user_id);


--
-- Name: auth_user_user_permissions_permission_id_1fbb5f2c; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_user_user_permissions_permission_id_1fbb5f2c ON public.auth_user_user_permissions USING btree (permission_id);


--
-- Name: auth_user_user_permissions_user_id_a95ead1b; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_user_user_permissions_user_id_a95ead1b ON public.auth_user_user_permissions USING btree (user_id);


--
-- Name: auth_user_username_6821ab7c_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX auth_user_username_6821ab7c_like ON public.auth_user USING btree (username varchar_pattern_ops);


--
-- Name: course_department_id_5110981f; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX course_department_id_5110981f ON public.course USING btree (department_id);


--
-- Name: course_department_id_5110981f_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX course_department_id_5110981f_like ON public.course USING btree (department_id varchar_pattern_ops);


--
-- Name: course_semester_id_df45f3b6; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX course_semester_id_df45f3b6 ON public.course USING btree (semester_id);


--
-- Name: course_semester_id_df45f3b6_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX course_semester_id_df45f3b6_like ON public.course USING btree (semester_id varchar_pattern_ops);


--
-- Name: django_admin_log_content_type_id_c4bce8eb; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX django_admin_log_content_type_id_c4bce8eb ON public.django_admin_log USING btree (content_type_id);


--
-- Name: django_admin_log_user_id_c564eba6; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX django_admin_log_user_id_c564eba6 ON public.django_admin_log USING btree (user_id);


--
-- Name: django_session_expire_date_a5c62663; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX django_session_expire_date_a5c62663 ON public.django_session USING btree (expire_date);


--
-- Name: django_session_session_key_c0390e0f_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX django_session_session_key_c0390e0f_like ON public.django_session USING btree (session_key varchar_pattern_ops);


--
-- Name: program_program_name_6fd69943_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX program_program_name_6fd69943_like ON public.program USING btree (program_name varchar_pattern_ops);


--
-- Name: student_email_76e7ca2e_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_email_76e7ca2e_like ON public.student USING btree (email varchar_pattern_ops);


--
-- Name: student_groups_group_id_0bc54d92; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_groups_group_id_0bc54d92 ON public.student_groups USING btree (group_id);


--
-- Name: student_groups_student_id_2cd9b76d; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_groups_student_id_2cd9b76d ON public.student_groups USING btree (student_id);


--
-- Name: student_user_permissions_permission_id_7b58a882; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_user_permissions_permission_id_7b58a882 ON public.student_user_permissions USING btree (permission_id);


--
-- Name: student_user_permissions_student_id_e1448ffa; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_user_permissions_student_id_e1448ffa ON public.student_user_permissions USING btree (student_id);


--
-- Name: student_username_b1d1b6d7_like; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX student_username_b1d1b6d7_like ON public.student USING btree (username varchar_pattern_ops);


--
-- Name: advisor_degrees advisor_degree_advisor_id_6342830e_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_degrees
    ADD CONSTRAINT advisor_degree_advisor_id_6342830e_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_degrees advisor_degree_degree_id_ebc414e5_fk_degree_degree_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_degrees
    ADD CONSTRAINT advisor_degree_degree_id_ebc414e5_fk_degree_degree_code FOREIGN KEY (degree_id) REFERENCES public.degree(degree_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_departments advisor_department_advisor_id_7b46c8d5_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_departments
    ADD CONSTRAINT advisor_department_advisor_id_7b46c8d5_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_departments advisor_department_department_id_93140784_fk_departmen; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_departments
    ADD CONSTRAINT advisor_department_department_id_93140784_fk_departmen FOREIGN KEY (department_id) REFERENCES public.department(department_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_faculties advisor_faculty_advisor_id_3dd2c9cc_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_faculties
    ADD CONSTRAINT advisor_faculty_advisor_id_3dd2c9cc_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_groups advisor_groups_advisor_id_6bb318ae_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_groups
    ADD CONSTRAINT advisor_groups_advisor_id_6bb318ae_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_groups advisor_groups_group_id_bc03a0a9_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_groups
    ADD CONSTRAINT advisor_groups_group_id_bc03a0a9_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_majors advisor_major_advisor_id_dddd42a4_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_majors
    ADD CONSTRAINT advisor_major_advisor_id_dddd42a4_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_majors advisor_major_major_id_433ab318_fk_major_major_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_majors
    ADD CONSTRAINT advisor_major_major_id_433ab318_fk_major_major_code FOREIGN KEY (major_id) REFERENCES public.major(major_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_programs advisor_program_advisor_id_67d4d348_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_programs
    ADD CONSTRAINT advisor_program_advisor_id_67d4d348_fk_advisor_advisor_id FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_programs advisor_program_program_id_296c7438_fk_program_program_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_programs
    ADD CONSTRAINT advisor_program_program_id_296c7438_fk_program_program_code FOREIGN KEY (program_id) REFERENCES public.program(program_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_question advisor_question_advisor_cbf1b882_fk_advisor_advisor_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_question
    ADD CONSTRAINT advisor_question_advisor_cbf1b882_fk_advisor_advisor_id FOREIGN KEY (advisor) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_question advisor_question_student_be479363_fk_student_student_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_question
    ADD CONSTRAINT advisor_question_student_be479363_fk_student_student_id FOREIGN KEY (student) REFERENCES public.student(student_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_user_permissions advisor_user_permiss_advisor_id_055cd99e_fk_advisor_a; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_user_permissions
    ADD CONSTRAINT advisor_user_permiss_advisor_id_055cd99e_fk_advisor_a FOREIGN KEY (advisor_id) REFERENCES public.advisor(advisor_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: advisor_user_permissions advisor_user_permiss_permission_id_f8cd2a9b_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.advisor_user_permissions
    ADD CONSTRAINT advisor_user_permiss_permission_id_f8cd2a9b_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions auth_group_permissio_permission_id_84c5c92e_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissio_permission_id_84c5c92e_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_group_permissions auth_group_permissions_group_id_b120cbf9_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_b120cbf9_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_permission auth_permission_content_type_id_2f476e4b_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_2f476e4b_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_groups auth_user_groups_group_id_97559544_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_group_id_97559544_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_groups auth_user_groups_user_id_6a12ed8b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_6a12ed8b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_user_permissions auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: course course_department_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.course
    ADD CONSTRAINT course_department_fkey FOREIGN KEY (department) REFERENCES public.department(department_code);


--
-- Name: course course_department_id_5110981f_fk_department_department_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.course
    ADD CONSTRAINT course_department_id_5110981f_fk_department_department_code FOREIGN KEY (department_id) REFERENCES public.department(department_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: degree_course_group course_group_parent_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_course_group
    ADD CONSTRAINT course_group_parent_group_id_fkey FOREIGN KEY (parent_group_id) REFERENCES public.degree_parent_course_group(parent_group_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: course course_semester_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.course
    ADD CONSTRAINT course_semester_fkey FOREIGN KEY (semester) REFERENCES public.semester(semester_letter) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: course course_semester_id_df45f3b6_fk_semester_semester_letter; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.course
    ADD CONSTRAINT course_semester_id_df45f3b6_fk_semester_semester_letter FOREIGN KEY (semester_id) REFERENCES public.semester(semester_letter) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: courses_per_degree courses_per_degree_course_group_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree
    ADD CONSTRAINT courses_per_degree_course_group_fkey FOREIGN KEY (course_group_id) REFERENCES public.degree_course_group(course_group_id) ON UPDATE CASCADE;


--
-- Name: courses_per_degree courses_per_degree_course_id_45139c6a_fk_course_course_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree
    ADD CONSTRAINT courses_per_degree_course_id_45139c6a_fk_course_course_code FOREIGN KEY (course_id) REFERENCES public.course(course_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: courses_per_degree courses_per_degree_degree_id_e7d72a53_fk_degree_degree_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_degree
    ADD CONSTRAINT courses_per_degree_degree_id_e7d72a53_fk_degree_degree_code FOREIGN KEY (degree_id) REFERENCES public.degree(degree_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: courses_per_major courses_per_major_course_id_4e62c2ac_fk_course_course_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major
    ADD CONSTRAINT courses_per_major_course_id_4e62c2ac_fk_course_course_code FOREIGN KEY (course_id) REFERENCES public.course(course_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: courses_per_major courses_per_major_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major
    ADD CONSTRAINT courses_per_major_group_id_fkey FOREIGN KEY (course_group_id) REFERENCES public.major_course_group(course_group_id);


--
-- Name: courses_per_major courses_per_major_major_id_f8eefff2_fk_major_major_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.courses_per_major
    ADD CONSTRAINT courses_per_major_major_id_f8eefff2_fk_major_major_code FOREIGN KEY (major_id) REFERENCES public.major(major_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: degree_course_group degree_course_group_degree_id_9ffd94cd_fk_degree_degree_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_course_group
    ADD CONSTRAINT degree_course_group_degree_id_9ffd94cd_fk_degree_degree_code FOREIGN KEY (degree_id) REFERENCES public.degree(degree_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: degree degree_department_id_dba9087a_fk_department_department_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree
    ADD CONSTRAINT degree_department_id_dba9087a_fk_department_department_code FOREIGN KEY (department_id) REFERENCES public.department(department_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: degree_parent_course_group degree_parent_course_group_degree_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree_parent_course_group
    ADD CONSTRAINT degree_parent_course_group_degree_fkey FOREIGN KEY (degree_id) REFERENCES public.degree(degree_code) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: degree degree_program_id_cf72e73e_fk_program_program_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.degree
    ADD CONSTRAINT degree_program_id_cf72e73e_fk_program_program_code FOREIGN KEY (program_id) REFERENCES public.program(program_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: department department_faculty_id_79d0fb85_fk_faculty_faculty_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.department
    ADD CONSTRAINT department_faculty_id_79d0fb85_fk_faculty_faculty_id FOREIGN KEY (faculty_id) REFERENCES public.faculty(faculty_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log django_admin_log_content_type_id_c4bce8eb_fk_django_co; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_content_type_id_c4bce8eb_fk_django_co FOREIGN KEY (content_type_id) REFERENCES public.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: django_admin_log django_admin_log_user_id_c564eba6_fk_auth_user_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.django_admin_log
    ADD CONSTRAINT django_admin_log_user_id_c564eba6_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES public.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: elective elective_course_id_5fe56427_fk_course_course_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.elective
    ADD CONSTRAINT elective_course_id_5fe56427_fk_course_course_code FOREIGN KEY (course_id) REFERENCES public.course(course_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: elective elective_program_id_0250d2cb_fk_program_program_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.elective
    ADD CONSTRAINT elective_program_id_0250d2cb_fk_program_program_code FOREIGN KEY (program_id) REFERENCES public.program(program_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: faq faq_section_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.faq
    ADD CONSTRAINT faq_section_id_fkey FOREIGN KEY (section_id) REFERENCES public.faq_section(section_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: major_course_group major_course_group_major_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_course_group
    ADD CONSTRAINT major_course_group_major_fkey FOREIGN KEY (major_id) REFERENCES public.major(major_code) ON UPDATE CASCADE;


--
-- Name: major_course_group major_course_group_major_parent_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_course_group
    ADD CONSTRAINT major_course_group_major_parent_group_id_fkey FOREIGN KEY (parent_group_id) REFERENCES public.major_parent_course_group(parent_group_id);


--
-- Name: major major_department_id_13c2669d_fk_department_department_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major
    ADD CONSTRAINT major_department_id_13c2669d_fk_department_department_code FOREIGN KEY (department_id) REFERENCES public.department(department_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: major_parent_course_group major_parent_course_group_major_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major_parent_course_group
    ADD CONSTRAINT major_parent_course_group_major_fkey FOREIGN KEY (major_id) REFERENCES public.major(major_code) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: major major_program_id_d0b5be4c_fk_program_program_code; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.major
    ADD CONSTRAINT major_program_id_d0b5be4c_fk_program_program_code FOREIGN KEY (program_id) REFERENCES public.program(program_code) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: program program_faculty_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.program
    ADD CONSTRAINT program_faculty_id_fkey FOREIGN KEY (faculty_id) REFERENCES public.faculty(faculty_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: program program_qualification_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.program
    ADD CONSTRAINT program_qualification_fkey FOREIGN KEY (qualification_id) REFERENCES public.qualification(qualification_id);


--
-- Name: student_groups student_groups_group_id_0bc54d92_fk_auth_group_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_groups
    ADD CONSTRAINT student_groups_group_id_0bc54d92_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES public.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: student_groups student_groups_student_id_2cd9b76d_fk_student_student_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_groups
    ADD CONSTRAINT student_groups_student_id_2cd9b76d_fk_student_student_id FOREIGN KEY (student_id) REFERENCES public.student(student_id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: student_user_permissions student_user_permiss_permission_id_7b58a882_fk_auth_perm; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_user_permissions
    ADD CONSTRAINT student_user_permiss_permission_id_7b58a882_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES public.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- Name: student_user_permissions student_user_permiss_student_id_e1448ffa_fk_student_s; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.student_user_permissions
    ADD CONSTRAINT student_user_permiss_student_id_e1448ffa_fk_student_s FOREIGN KEY (student_id) REFERENCES public.student(student_id) DEFERRABLE INITIALLY DEFERRED;


--
-- PostgreSQL database dump complete
--

