# Generated by Django 5.2.5 on 2025-08-30 22:16

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('handbook', '0030_alter_faculty_faculty_code'),
    ]

    operations = [
        migrations.CreateModel(
            name='FaqSection',
            fields=[
                ('section_id', models.IntegerField(primary_key=True, serialize=False)),
                ('section_name', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'faq_section',
            },
        ),
        migrations.CreateModel(
            name='Glossary',
            fields=[
                ('term_id', models.AutoField(primary_key=True, serialize=False)),
                ('term', models.CharField(max_length=255, unique=True)),
                ('definition', models.TextField()),
            ],
            options={
                'verbose_name_plural': 'Glossary',
                'db_table': 'glossary',
            },
        ),
        migrations.CreateModel(
            name='Advisor',
            fields=[
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('advisor_id', models.AutoField(primary_key=True, serialize=False)),
                ('username', models.CharField(max_length=255, unique=True)),
                ('password', models.CharField(max_length=255)),
                ('first_name', models.CharField(blank=True, max_length=255, null=True)),
                ('last_name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=255, null=True, unique=True)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('phone_number', models.CharField(blank=True, max_length=255, null=True)),
                ('building', models.CharField(blank=True, max_length=255, null=True)),
                ('office_number', models.CharField(blank=True, max_length=255, null=True)),
                ('profile_photo', models.BinaryField(blank=True, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('degrees', models.ManyToManyField(blank=True, to='handbook.degree')),
                ('departments', models.ManyToManyField(blank=True, to='handbook.department')),
                ('faculties', models.ManyToManyField(blank=True, to='handbook.faculty')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this advisor belongs to.', related_name='advisor_set', to='auth.group', verbose_name='groups')),
                ('majors', models.ManyToManyField(blank=True, to='handbook.major')),
                ('programs', models.ManyToManyField(blank=True, to='handbook.program')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this advisor.', related_name='advisor_set', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'advisor',
            },
        ),
        migrations.CreateModel(
            name='Faq',
            fields=[
                ('faq_id', models.AutoField(primary_key=True, serialize=False)),
                ('question', models.TextField()),
                ('answer', models.TextField()),
                ('section', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='advising.faqsection')),
            ],
            options={
                'db_table': 'faq',
            },
        ),
        migrations.CreateModel(
            name='Student',
            fields=[
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('student_id', models.AutoField(primary_key=True, serialize=False)),
                ('username', models.CharField(max_length=255, unique=True)),
                ('password', models.CharField(max_length=255)),
                ('first_name', models.CharField(blank=True, max_length=255, null=True)),
                ('last_name', models.CharField(blank=True, max_length=255, null=True)),
                ('email', models.EmailField(blank=True, max_length=255, null=True, unique=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to.', related_name='student_set', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='student_set', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'student',
            },
        ),
        migrations.CreateModel(
            name='AdvisorQuestion',
            fields=[
                ('question_id', models.AutoField(primary_key=True, serialize=False)),
                ('category', models.CharField(blank=True, help_text="Can only be 1 of 'Faculty', 'Department', 'Program', 'Degree', or 'Major'", max_length=255, null=True)),
                ('subject', models.CharField(blank=True, max_length=255, null=True)),
                ('question', models.TextField()),
                ('answer', models.TextField(blank=True, null=True)),
                ('q_timestamp', models.DateTimeField(auto_now_add=True, null=True)),
                ('a_timestamp', models.DateTimeField(auto_now_add=True, null=True)),
                ('student_read', models.BooleanField(default=True)),
                ('advisor_read', models.BooleanField(default=False)),
                ('advisor', models.ForeignKey(blank=True, db_column='advisor', null=True, on_delete=django.db.models.deletion.CASCADE, to='advising.advisor')),
                ('student', models.ForeignKey(blank=True, db_column='student', null=True, on_delete=django.db.models.deletion.CASCADE, to='advising.student')),
            ],
            options={
                'db_table': 'advisor_question',
            },
        ),
    ]
