from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from .models import *

@admin.register(Student)
class StudentAdmin(UserAdmin):
    list_display = ("username", "first_name", "last_name", "email")
    fieldsets = (
        ('Login Details', {
            'fields': ("username", "password"),
        }),
        ('Personal Details', {
            'fields': ("first_name", "last_name", "email"),
        }),
    )
    search_fields = ("username", "first_name", "last_name", "email")
    ordering = ("username",)
    list_filter = ()

@admin.register(Advisor)
class AdvisorAdmin(UserAdmin):
    list_display = ("username", "first_name", "last_name", "title", "email")
    fieldsets = (
        ('Login Details', {
            'fields': ("username", "password"),
        }),
        ('Personal Details', {
            'fields': ("title", "email", "first_name", "last_name", "phone_number", "office_number", "building"),
        }),
        ('Academic Details', {
            'fields': ("faculties", "departments", "programs", "degrees", "majors", "notes"),
        }),
    )
    search_fields = ("username", "first_name", "last_name")
    ordering = ("username",)
    list_filter = ()

@admin.register(AdvisorQuestion)
class AdvisorQuestionAdmin(admin.ModelAdmin):
    list_display = ('question_id', 'subject', 'question', 'answer', 'q_timestamp', 'a_timestamp', 'student', 'advisor')
    search_fields = ['subject', 'question']
    list_filter = ['student__username', 'advisor__username']
    ordering = ['-question_id']

@admin.register(FaqSection)
class FaqSectionAdmin(admin.ModelAdmin):
    list_display = ('section_id', 'section_name')
    ordering = ('section_id',)

@admin.register(Faq)
class FaqAdmin(admin.ModelAdmin):
    list_display = ('faq_id', 'section', 'question', 'answer')
    search_fields = ['question', 'answer']
    list_filter = ['section']
    ordering = ('faq_id',)

@admin.register(Glossary)
class GlossaryAdmin(admin.ModelAdmin):
    list_display = ('term', 'definition')
    search_fields = ['term']
    ordering = ['term']