import { jsx as _jsx } from "react/jsx-runtime";
import Cookies from "js-cookie";
import { createContext, useState, useContext, } from "react";
const UserContext = createContext({
    user: null,
    setUser: () => null,
    signout: () => null,
    signin: () => null,
    sessionKey: () => undefined,
});
export const UserProvider = ({ children }) => {
    const storageKey = "user";
    const [user, setUser] = useState(() => localStorage.getItem(storageKey) || null);
    const signout = () => {
        localStorage.removeItem(storageKey);
        Cookies.remove("sessionKey");
        setUser(null);
    };
    const saveUser = (user) => {
        localStorage.setItem(storageKey, user);
        setUser(user);
    };
    const value = {
        user,
        setUser: (user) => {
            saveUser(user);
        },
        signout,
        signin: (user, sessionKey) => {
            signout();
            Cookies.set("sessionKey", sessionKey);
            saveUser(user);
        },
        sessionKey: () => {
            return Cookies.get("sessionKey");
        },
    };
    return _jsx(UserContext.Provider, { value: value, children: children });
};
export const useUser = () => useContext(UserContext);
