var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useForm } from "react-hook-form";
import { zodResolver } from "@hookform/resolvers/zod";
import { CardContent, CardFooter } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Tooltip, TooltipContent, TooltipProvider, TooltipTrigger, } from "@/components/ui/tooltip";
import { Form, FormControl, FormField, FormItem, } from "@/components/ui/form";
import { useState } from "react";
import { CircleHelp } from "lucide-react";
import { z } from "zod";
import { useUser } from "./UserProvider";
const FormSchema = z.object({
    username: z.string().min(4, {
        message: "Username must be at least 4 characters.",
    }),
    password: z.string().min(4, {
        message: "Password must be at least 4 characters.",
    }),
});
const UserForm = ({ ft }) => {
    const form = useForm({
        resolver: zodResolver(FormSchema),
        defaultValues: {
            username: "",
            password: "",
        },
    });
    const [invalid, setInvalid] = useState({ username: null, password: null, neither: null });
    const { signin } = useUser();
    return (_jsx(Form, Object.assign({}, form, { children: _jsxs("form", { onSubmit: (e) => {
                e.preventDefault();
                return onSubmit(setInvalid, signin, ft, form.getValues());
            }, children: [_jsx(CardContent, { children: _jsxs("div", { className: "grid w-full items-center gap-4", children: [_jsx(Field, { t: "username", help: ft === "Sign Up"
                                    ? "This will be publicly visible. All created templates will be assigned to your username."
                                    : undefined, placeholder: "Your Username.", control: form.control }), _jsx(Field, { t: "password", placeholder: "Don't forget this! There's no recovery system.", control: form.control })] }) }), _jsxs(CardFooter, { className: "flex flex-col justify-between gap-4", children: [invalid.username === null && invalid.password === null ? (_jsx(_Fragment, {})) : (_jsxs("div", { className: "text-red-600", children: [_jsx("p", { children: invalid.username }), _jsx("p", { children: invalid.password })] })), _jsx(Button, { type: "submit", children: ft })] })] }) })));
};
const Field = ({ t, help, placeholder, control }) => {
    return (_jsx(FormField, { control: control, name: t, render: ({ field }) => (_jsxs("div", { className: "flex flex-col space-y-1.5", children: [_jsx(Lbl, { text: t, help: help }), _jsx(FormItem, { children: _jsx(FormControl, { children: _jsx(Input, Object.assign({ placeholder: placeholder, type: t }, field)) }) })] })) }));
};
const Lbl = ({ text, help }) => {
    let tooltip = _jsx(_Fragment, {});
    if (help !== undefined) {
        tooltip = (_jsx(TooltipProvider, { delayDuration: 0, children: _jsxs(Tooltip, { children: [_jsx(TooltipTrigger, { asChild: true, children: _jsx("div", { children: _jsx(CircleHelp, {}) }) }), _jsx(TooltipContent, { children: _jsx("p", { className: "max-w-32", children: help }) })] }) }));
    }
    return (_jsxs("div", { className: "flex justify-between", children: [_jsx(Label, { className: "flex flex-col justify-end", htmlFor: text, children: text.charAt(0).toUpperCase() + text.slice(1) }), tooltip] }));
};
const onSubmit = (setInvalid, signin, ft, data) => __awaiter(void 0, void 0, void 0, function* () {
    setInvalid({ username: null, password: null, neither: null });
    const apiPath = "/api/" + (ft == "Sign In" ? "signin" : "signup");
    const request = {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data),
    };
    try {
        const response = yield fetch(apiPath, request);
        if (response.ok) {
            const json = yield response.json();
            signin(data.username, json.sessionKey);
        }
        else {
            const json = yield response.json();
            onInvalid(setInvalid, json);
        }
    }
    catch (error) {
        console.error("Error:", error);
    }
});
const onInvalid = (setInvalid, err) => {
    const is_un = err.field == "username";
    const is_pw = err.field == "password";
    const is_neither = !(is_un || is_pw);
    if (is_neither) {
        console.log(err.message);
    }
    setInvalid({
        username: is_un ? err.message : null,
        password: is_pw ? err.message : null,
        neither: is_neither
            ? "Sorry, our server had an issue during the process. Please try again."
            : null,
    });
};
export default UserForm;
