import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@/components/ui/button";
import { Card, CardDescription, CardHeader, CardTitle, } from "@/components/ui/card";
import { useNavigate } from "react-router-dom";
import { useUser } from "./UserProvider";
import { Spinner } from "@/components/ui/spinner";
import { useEffect } from "react";
import UserForm from "./UserForm";
export const SignUp = () => {
    return _jsx(Signinup, { ft: "Sign Up" });
};
export const SignIn = () => {
    return _jsx(Signinup, { ft: "Sign In" });
};
const Signinup = ({ ft }) => {
    const navigate = useNavigate();
    const { user, sessionKey } = useUser();
    const signedIn = user !== null && sessionKey() !== undefined;
    useEffect(() => {
        if (signedIn) {
            navigate("/");
        }
    }, [signedIn]);
    if (signedIn) {
        return (_jsx("div", { className: "flex flex-grow flex-col justify-center", children: _jsx("div", { className: "flex justify-center text-lg font-semibold", children: _jsxs("div", { className: "flex flex-col gap-5", children: [_jsx("div", { children: "Signed In. Redirecting...." }), _jsx(Spinner, {})] }) }) }));
    }
    return _jsx(UserCard, { ft: ft });
};
export const Signup = () => { };
const UserCard = ({ ft }) => {
    return (_jsx("div", { className: "h-full pt-5 sm:pt-20", children: _jsx("div", { className: "sm:flex sm:justify-center", children: _jsxs("div", { className: "flex flex-col gap-4", children: [_jsxs(Card, { className: "sm:w-[30em]", children: [_jsxs(CardHeader, { children: [_jsx(CardTitle, { children: ft }), ft === "Sign Up" ? (_jsx(CardDescription, { children: "One-click signup. No email authentication required." })) : null] }), _jsx(UserForm, { ft: ft })] }), _jsxs("div", { className: "sm:w-[30em]", children: [_jsxs("div", { className: "text-xs text-muted-foreground", children: [ft === "Sign In" ? "Don't" : "Already", " have an account?"] }), _jsx("a", { href: ft === "Sign In" ? "signup" : "signin", children: _jsx(Button, { variant: "outline", children: ft === "Sign In" ? "Sign Up" : "Sign In" }) })] })] }) }) }));
};
