import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { useContext, useEffect } from "react";
import { TemplateContext, TemplateErrorContext } from "./TemplateProvider";
import { checkIdentifier } from "./checkIdentifier";
const TemplateName = ({ locked }) => {
    const { template, setTemplate } = useContext(TemplateContext);
    const { errors, setErrors } = useContext(TemplateErrorContext);
    const onChange = (title) => {
        setTemplate(Object.assign(Object.assign({}, template), { title: title }));
        const nameErrs = checkErrors(title);
        setErrors(Object.assign(Object.assign({}, errors), { title: nameErrs }));
    };
    useEffect(() => {
        onChange(template.title);
    }, []);
    return (_jsxs("div", { className: "flex grow flex-col gap-1.5 p-2 sm:p-0", children: [_jsx(Label, { className: "flex justify-center text-lg font-semibold sm:block", htmlFor: "TemplateName", children: _jsx("p", { className: "md:w-1/2 lg:w-full", children: "Template Title" }) }), _jsx(Input, { disabled: locked, onChange: (e) => {
                    onChange(e.target.value);
                }, id: "TemplateName", placeholder: "Required", value: template.title })] }));
};
const checkErrors = (name) => {
    if (name === "") {
        return "Template title cannot be be empty.";
    }
    const banned = checkIdentifier(name);
    if (banned === null) {
        return null;
    }
    return "`" + banned + "`" + " is not allowed in template title.";
};
export default TemplateName;
