import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { useContext } from "react";
import { TemplateContext } from "./TemplateProvider";
const TemplateDescription = ({ locked }) => {
    const { template, setTemplate } = useContext(TemplateContext);
    return (_jsxs("div", { className: "flex grow flex-col gap-1.5 p-2 sm:p-0", children: [_jsx(Label, { className: "flex justify-center text-lg font-semibold sm:block", htmlFor: "TemplateDescription", children: _jsx("p", { className: "md:w-1/2 lg:w-full", children: "Template Description" }) }), _jsx(Input, { onChange: (e) => {
                    setTemplate(Object.assign(Object.assign({}, template), { description: e.target.value }));
                }, id: "TemplateDescription", placeholder: "Optional", value: template.description, disabled: locked })] }));
};
export default TemplateDescription;
